# SAP R/3 Environment - please do not edit


case `uname` in
  Linux)
    case `uname -m` in
      ia64)  
        _PLATFORM=linuxia64
        ;;
      x86_64)  
        _PLATFORM=linuxx86_64
        ;;
      s390x)  
        _PLATFORM=linuxs390x
        ;;
      ppc64)  
        _PLATFORM=linuxppc64
        ;;
      ppc64le)  
        _PLATFORM=linuxppc64le
        ;;
      i686|i386)
        _PLATFORM=linuxintel
        ;;
      *)
        _PLATFORM=linuxintel
        ;;
    esac
    ;;

  AIX*)
    _PLATFORM=rs6000_64
    ;;

  Sun*)
    case `uname -m` in
      sun4u*)
        _PLATFORM=sun_64
        ;;
      i86pc)
        _PLATFORM=sunx86_64
        ;;
      *)
        _PLATFORM=sun_64
        ;;
    esac
    ;;

  HP*)
    case `uname -m` in
      ia64)
        _PLATFORM=hpia64
        ;;
      *)
        _PLATFORM=hp_64
        ;;
    esac
    ;;

  OSF*)
    _PLATFORM=alphaosf
    ;;

  OS/390*)
    _PLATFORM=os390_64
    ;;

  *)
    _PLATFORM=os390_64
    ;;

esac 

SAPSYSTEMNAME=@SID@; export SAPSYSTEMNAME

_UC_NUC=@UC_NUC@
_DEF_EXE1=/usr/sap/"$SAPSYSTEMNAME"/SYS/exe/"$_UC_NUC"/"$_PLATFORM"
_DEF_EXE2=/usr/sap/"$SAPSYSTEMNAME"/SYS/exe/run
_DEF_EXE="$_DEF_EXE1 $_DEF_EXE2"

DIR_LIBRARY=$_DEF_EXE2; export DIR_LIBRARY

RSEC_SSFS_DATAPATH=/usr/sap/"$SAPSYSTEMNAME"/SYS/global/security/rsecssfs/data; export RSEC_SSFS_DATAPATH
RSEC_SSFS_KEYPATH=/usr/sap/"$SAPSYSTEMNAME"/SYS/global/security/rsecssfs/key; export RSEC_SSFS_KEYPATH
rsdb_ssfs_connect=@RSDB_SSFS_CONNECT@; export rsdb_ssfs_connect


for d in $_DEF_EXE $HOME; do
    i=0
    for p in `echo $PATH | sed 's/:/ /g'`; do
        if [ "$p" = "$d" ]; then
            i=1
            break
        fi
    done
    if [ $i -eq 0 ]; then
        PATH=${PATH}:${d}; export PATH
    fi
done

case `uname` in
    SIN* | Reliant*)
        for d in /usr/ccs/bin /usr/ucb; do
            i=0
            for p in `echo $PATH | sed 's/:/ /g'`; do
                if [ "$p" = "$d" ]; then
                    i=1
                    break
                fi
            done
            if [ $i -eq 0 ]; then
                PATH=${PATH}:${d}; export PATH
            fi
        done
        ;;
    Sun*)
        for d in /usr/ccs/bin /usr/ucb /usr/gnu/bin; do
            i=0
            for p in `echo $PATH | sed 's/:/ /g'`; do
                if [ "$p" = "$d" ]; then
                    i=1
                    break
                fi
            done
            if [ $i -eq 0 ]; then
                PATH=${PATH}:${d}; export PATH
            fi
        done
        ;;
	OSF*)
        for d in /usr/sbin; do
            i=0
            for p in `echo $PATH | sed 's/:/ /g'`; do
                if [ "$p" = "$d" ]; then
                    i=1
                    break
                fi
            done
            if [ $i -eq 0 ]; then
                PATH=${PATH}:${d}; export PATH
            fi
        done
        ;;
    *)
        ;;
esac

case `uname` in
    AIX*)
        if [ -z "$LIBPATH" ]; then
            LIBPATH=/usr/lib:/lib:$_DEF_EXE2:$_DEF_EXE1; export LIBPATH
        else
            for d in $_DEF_EXE; do
                i=0
                for p in `echo $LIBPATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    LIBPATH=${LIBPATH}:${d}; export LIBPATH
                fi
            done
        fi
        ;;

    HP*)
        if [ -z "$SHLIB_PATH" ]; then
            SHLIB_PATH=$_DEF_EXE2:$_DEF_EXE1; export SHLIB_PATH
        else
            for d in $_DEF_EXE; do
                i=0
                for p in `echo $SHLIB_PATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    SHLIB_PATH=${SHLIB_PATH}:${d}; export SHLIB_PATH
                fi
            done
        fi
        ;;

    OS\/390)
        if [ -z "$LIBPATH" ]; then
            LIBPATH=/usr/lib:/lib:/usr/lpp/icli/sbin:$_DEF_EXE2:$_DEF_EXE1; export LIBPATH
        else
            for d in /usr/lpp/icli/sbin $_DEF_EXE; do
                i=0
                for p in `echo $LIBPATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    LIBPATH=${LIBPATH}:${d}; export LIBPATH
                fi
            done
        fi
        ;;

    *)
        if [ -z "$LD_LIBRARY_PATH" ]; then
            LD_LIBRARY_PATH=$_DEF_EXE2:$_DEF_EXE1; export LD_LIBRARY_PATH
        else
            for d in $_DEF_EXE; do
                i=0
                for p in `echo $LD_LIBRARY_PATH | sed 's/:/ /g'`; do
                    if [ "$p" = "$d" ]; then
                        i=1
                        break
                    fi
                done
                if [ $i -eq 0 ]; then
                    LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${d}; export LD_LIBRARY_PATH
                fi
            done
        fi
        ;;
esac


case `uname` in
    Sun*)
        ulimit -n 4096
        unset LD_LIBRARY_PATH_64;;
    OS\/390)
        alias hostname='hostname -s';;
    *)
        ;;
esac

# set TERM environment variable, terminal mode and terminal options
tty -s
if [ $? -eq 0 ]; then
    case `uname` in
        AIX*|BOS*)
            TERM=${TERM:-aixterm}; export TERM
            eval `tset -I -Q`
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            ;;

        HP*)
            TERM=${TERM:-hp}; export TERM
            eval `tset -I -Q`
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            ;;
        OSF*)
            TERM=${TERM:-vt100}; export TERM
            eval `tset -I -Q`
            case $TERM in
                vt*)
                    stty erase '^?' kill '^u' intr '^c' susp '^z'
                    ;;
                *)
                    stty erase '^h' kill '^u' intr '^c' susp '^z'
                    ;;
            esac
            ;;
        OS\/390)
            TERM=${TERM:-xterm}; export TERM
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            ;;
        Sun*)
            TERM=${TERM:-sun}; export TERM
            eval `tset -I -Q`
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            ;;
        SIN* | Reliant*)
            TERM=${TERM:-97801}; export TERM
            eval `tset -I -Q`
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            ;;

        ULT*)
            TERM=${TERM:-vt100}; export TERM
            eval `tset -I -n -Q`
            case $TERM in
                vt*)
                    stty erase '^?' kill '^u' intr '^c' susp '^z'
                    ;;
                *)
                    stty erase '^h' kill '^u' intr '^c' susp '^z'
                    ;;
            esac
            ;;
        dgux*)
            ;;
        Linux*)
            ;;
        *)
            TERM=${TERM:-xterm}; export TERM
            eval `tset -I -Q`
            stty erase '^h' kill '^u' intr '^c' susp '^z'
            ;;
    esac

fi

# define primary prompt string
if ( tty -s ) then
    y=`hostname|cut -f1-2 -d.`
    x=`whoami`
    export PS1
    case "$TERM" in
        aix*)        PS1="];$x@$y:\$PWD$x> ";;
        hp*)         PS1="$y:$x> &s1A";;
        OS\/390)     PS1="];$x@$y:\$PWD$x> ";;
        xterm*)      PS1="];$x@$y:\$PWD
$x> ";;
        *)           PS1="$y:$x> ";;
    esac
    unset y
    unset x
fi

# define some nice aliases
alias dir='ls -l'
alias l='ls -abxCF'
alias h='history'
alias Pwd='/bin/pwd'
alias Su="rlogin `hostname` -l"
alias cdexe='cd $_DEF_EXE2'
alias cdpro='cd /usr/sap/$SAPSYSTEMNAME/SYS/profile'
alias cdglo='cd /usr/sap/$SAPSYSTEMNAME/SYS/global'
alias cdput='cd /usr/sap/$SAPSYSTEMNAME/put'

ls -d /usr/sap/$SAPSYSTEMNAME/[D,G,S,J,T,A]*[0-9][0-9] > /dev/null 2>&1
if [ $? -eq 0 ]; then
 INSTANCEDIR_LIST=`ls -d /usr/sap/$SAPSYSTEMNAME/[D,G,S,J,T,A]*[0-9][0-9]`
 INSTANCEDIR_CI="/usr/sap/$SAPSYSTEMNAME/DVEBM"
 INSTANCEDIR_DI="/usr/sap/$SAPSYSTEMNAME/D"
 INSTANCEDIR_GW="/usr/sap/$SAPSYSTEMNAME/G"
 INSTANCEDIR_S="/usr/sap/$SAPSYSTEMNAME/SCS"
 INSTANCEDIR_JC="/usr/sap/$SAPSYSTEMNAME/JC"
 INSTANCEDIR_J="/usr/sap/$SAPSYSTEMNAME/J"
 INSTANCEDIR_T="/usr/sap/$SAPSYSTEMNAME/TRX"
 INSTANCEDIR_AS="/usr/sap/$SAPSYSTEMNAME/ASCS"

 for d in $INSTANCEDIR_LIST; do
  echo $d | grep `echo $INSTANCEDIR_CI` > /dev/null
  rc1=$?
  echo $d | grep `echo $INSTANCEDIR_DI` > /dev/null
  rc2=$?
  echo $d | grep `echo $INSTANCEDIR_GW` > /dev/null
  rc3=$?
  echo $d | grep `echo $INSTANCEDIR_S` > /dev/null
  rc4=$?
  echo $d | grep `echo $INSTANCEDIR_JC` > /dev/null
  rc5=$?
  echo $d | grep `echo $INSTANCEDIR_J` > /dev/null
  rc6=$?
  echo $d | grep `echo $INSTANCEDIR_T` > /dev/null
  rc7=$?
  echo $d | grep `echo $INSTANCEDIR_AS` > /dev/null
  rc8=$?
  if [ $rc1 -eq 0 ]; then
    alias cdD='cd /usr/sap/$SAPSYSTEMNAME/DVEBM*[0-9][0-9]'
  elif [ $rc2 -eq 0 ]; then
    alias cdDi='cd /usr/sap/$SAPSYSTEMNAME/D[0-9][0-9]'
  elif [ $rc3 -eq 0 ]; then
    alias cdG='cd /usr/sap/$SAPSYSTEMNAME/G[0-9][0-9]'
  elif [ $rc4 -eq 0 ]; then
    alias cdS='cd /usr/sap/$SAPSYSTEMNAME/SCS[0-9][0-9]'
  elif [ $rc5 -eq 0 ]; then
    alias cdJC='cd /usr/sap/$SAPSYSTEMNAME/JC[0-9][0-9]'
  elif [ $rc6 -eq 0 ]; then
    alias cdJ='cd /usr/sap/$SAPSYSTEMNAME/J[0-9][0-9]'
  elif [ $rc7 -eq 0 ]; then
    alias cdT='cd /usr/sap/$SAPSYSTEMNAME/TRX[0-9][0-9]'
  elif [ $rc8 -eq 0 ]; then
    alias cdAS='cd /usr/sap/$SAPSYSTEMNAME/ASCS[0-9][0-9]'
  fi
 done
fi

# end SAP R/3 Environment
