if ( ! $?dbms_type ) then
# preserve search path for executables and libraries
set _db_PATH=$PATH
# add odbc driver location to library search path
switch (`uname`)
  case AIX*:
    setenv LIBPATH ${LIBPATH}:/usr/sap/$SAPSYSTEMNAME/SYS/global/syb/rs6000_64/sybodbc
    set _db_LIBPATH=$LIBPATH
    breaksw
  case HP*:
    setenv SHLIB_PATH ${SHLIB_PATH}:/usr/sap/$SAPSYSTEMNAME/SYS/global/syb/hpia64/sybodbc
    set _db_SHLIB_PATH=$SHLIB_PATH
    breaksw
  case Linux:
    setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:/usr/sap/$SAPSYSTEMNAME/SYS/global/syb/linuxx86_64/sybodbc
    set _db_LD_LIBRARY_PATH=$LD_LIBRARY_PATH
    breaksw
  case Sun*:
    setenv LD_LIBRARY_PATH ${LD_LIBRARY_PATH}:/usr/sap/$SAPSYSTEMNAME/SYS/global/syb/sun_64/sybodbc
    set _db_LD_LIBRARY_PATH=$LD_LIBRARY_PATH
    breaksw
  default:
endsw
if ( ! $?SYBASE ) then
  if ( -e /sybase/$SAPSYSTEMNAME/SYBASE.csh ) then
    switch (`uname`)
      case AIX*:
        setenv PATH ""
        setenv LIBPATH ""
        source /sybase/$SAPSYSTEMNAME/SYBASE.csh
        setenv PATH ${_db_PATH}:$PATH
        setenv LIBPATH ${_db_LIBPATH}:${LIBPATH}
        breaksw
      case HP*:
        setenv PATH ""
        setenv SHLIB_PATH ""
        source /sybase/$SAPSYSTEMNAME/SYBASE.csh
        setenv PATH ${_db_PATH}:$PATH
        setenv SHLIB_PATH ${_db_SHLIB_PATH}:${SHLIB_PATH}
        breaksw
      case Linux:
        setenv PATH ""
        setenv LD_LIBRARY_PATH ""
        source /sybase/$SAPSYSTEMNAME/SYBASE.csh
        setenv PATH ${_db_PATH}:$PATH
        setenv LD_LIBRARY_PATH ${_db_LD_LIBRARY_PATH}:${LD_LIBRARY_PATH}
        breaksw
      case Sun*:
        setenv PATH ""
        setenv LD_LIBRARY_PATH ""
        source /sybase/$SAPSYSTEMNAME/SYBASE.csh
        setenv PATH ${_db_PATH}:$PATH
        setenv LD_LIBRARY_PATH ${_db_LD_LIBRARY_PATH}:${LD_LIBRARY_PATH}
        breaksw
      default:
    endsw
  endif
endif
# add database connect information
setenv dbms_type syb
setenv dbs_syb_schema SAPSR3
setenv dbs_syb_server @SAPDBHOST@
setenv dbs_syb_dbname @DB_SID@
setenv dbs_syb_port @dbs_syb_port@
setenv dbs_syb_ssl @dbs_syb_ssl@
setenv rsdb_ssfs_connect 1
setenv RSEC_SSFS_DATAPATH /usr/sap/$SAPSYSTEMNAME/SYS/global/security/rsecssfs/data
setenv RSEC_SSFS_KEYPATH /usr/sap/$SAPSYSTEMNAME/SYS/global/security/rsecssfs/key
endif
