if [ -z "$dbms_type" ]; then
# preserve search path for executables and libraries
_db_PATH=$PATH
# add odbc driver location to library search path
case `uname` in
  AIX*)
    LIBPATH=${LIBPATH}:/usr/sap/$SAPSYSTEMNAME/SYS/global/syb/rs6000_64/sybodbc
    export LIBPATH
    _db_LIBPATH=${LIBPATH}
    ;;
  HP*)
    SHLIB_PATH=${SHLIB_PATH}:/usr/sap/$SAPSYSTEMNAME/SYS/global/syb/hpia64/sybodbc
    export SHLIB_PATH
    _db_SHLIB_PATH=${SHLIB_PATH}
    ;;
  Linux)
    LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/usr/sap/$SAPSYSTEMNAME/SYS/global/syb/linuxx86_64/sybodbc
    export LD_LIBRARY_PATH
    _db_LD_LIBRARY_PATH=${LD_LIBRARY_PATH}
    ;;
  Sun*)
    LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:/usr/sap/$SAPSYSTEMNAME/SYS/global/syb/sun_64/sybodbc
    export LD_LIBRARY_PATH
    _db_LD_LIBRARY_PATH=${LD_LIBRARY_PATH}
    ;;
  *)
    ;;
esac
if [ -z "$SYBASE" ]; then
  if [ -f /sybase/$SAPSYSTEMNAME/SYBASE.sh ]; then
    case `uname` in
      AIX*)
        PATH=""
        export PATH
        LIBPATH=""
        export LIBPATH
        . /sybase/$SAPSYSTEMNAME/SYBASE.sh
        PATH=${_db_PATH}:$PATH
        export PATH
        LIBPATH=${_db_LIBPATH}:${LIBPATH}
        export LIBPATH
        ;;
      HP*)
        PATH=""
        export PATH
        SHLIB_PATH=""
        export SHLIB_PATH
        . /sybase/$SAPSYSTEMNAME/SYBASE.sh
        PATH=${_db_PATH}:$PATH
        export PATH
        SHLIB_PATH=${_db_SHLIB_PATH}:${SHLIB_PATH}
        export SHLIB_PATH
        ;;
      Linux)
        PATH=""
        export PATH
        LD_LIBRARY_PATH=""
        export LD_LIBRARY_PATH
        . /sybase/$SAPSYSTEMNAME/SYBASE.sh
        PATH=${_db_PATH}:$PATH
        export PATH
        LD_LIBRARY_PATH=${_db_LD_LIBRARY_PATH}:${LD_LIBRARY_PATH}
        export LD_LIBRARY_PATH
        ;;
      Sun*)
        PATH=""
        export PATH
        LD_LIBRARY_PATH=""
        export LD_LIBRARY_PATH
        . /sybase/$SAPSYSTEMNAME/SYBASE.sh
        PATH=${_db_PATH}:$PATH
        export PATH
        LD_LIBRARY_PATH=${_db_LD_LIBRARY_PATH}:${LD_LIBRARY_PATH}
        export LD_LIBRARY_PATH
        ;;
      *)
        ;;
    esac
  fi
fi
# add database connect information
dbms_type=syb
export dbms_type
dbs_syb_schema=SAPSR3
export dbs_syb_schema
dbs_syb_server=@SAPDBHOST@
export dbs_syb_server
dbs_syb_dbname=@DB_SID@
export dbs_syb_dbname
dbs_syb_port=@dbs_syb_port@
export dbs_syb_port
dbs_syb_ssl=@dbs_syb_ssl@
export dbs_syb_ssl
rsdb_ssfs_connect=1
export rsdb_ssfs_connect
RSEC_SSFS_DATAPATH=/usr/sap/$SAPSYSTEMNAME/SYS/global/security/rsecssfs/data
export RSEC_SSFS_DATAPATH
RSEC_SSFS_KEYPATH=/usr/sap/$SAPSYSTEMNAME/SYS/global/security/rsecssfs/key
export RSEC_SSFS_KEYPATH
fi
