set serverout on size 999999
set feedback off
WHENEVER SQLERROR EXIT SQL.SQLCODE;

/* n�chste Zeile erzeugt SQL-File alds.sql */
/* spool altds.sql */

begin
declare
	c integer;
	cDDL integer;
	r integer;
	rd integer;
	stmt varchar2(300);
	stmtDDL varchar2(300);
	tsname varchar2(60);
	version varchar2(20);

begin
	/* Das n�chste Statement k�nnte �rger bei alten Oracle Versionen geben - etwa 7.3 */
	/* weil m�glicherweise die Column Version in v$instance nicht existiert */
	/* muss noch gecheckt werden */
	/* wenn ja, dann m�sste umst�ndlich Banner von V$Version ausgewertet werden */

    select version into version from v$instance;

	c := dbms_sql.open_cursor;

	stmt := 'select tablespace_name from dba_tablespaces where ';

	/* nur 8.1 ff: extent_management = 'LOCAL' kenn keine default storage Parameter */
	/* Abfrage auf > 8.0 wieder gel�scht wegen Oracle 10 und weil nur Upgrades mit */
	/* Oracle 9 und 10 unterst�tzt werden */
	stmt := stmt || 'not extent_management = ''LOCAL'' and ';
	
	/* kein TS mit Rollback Segment */ 
	stmt := stmt || 'tablespace_name not in (select tablespace_name from dba_rollback_segs)';
	
	/* kein TS, der als Temporary Tablespace eine beliebigen Users verwendet wird*/
	/* MCOD!! */
    stmt := stmt || 'and tablespace_name not in (select temporary_tablespace from dba_users)';
	
	/* Finger Weg vom SYSTEM TS - f�r den Fall, dass das SYSTEMRS gel�scht wurde */
	stmt := stmt || 'and not tablespace_name = ''SYSTEM''';
	
	/* weil's  einfach sch�ner ist */
	stmt := stmt || ' order by tablespace_name';

	
	dbms_sql.parse(c,stmt,dbms_sql.native);
	dbms_sql.define_column(c,1,tsname,60);

	cDDL := dbms_sql.open_cursor;

	r := dbms_sql.execute(c);
	loop
	   if dbms_sql.fetch_rows(c)> 0 then
	    dbms_sql.column_value(c,1,tsname);
		/* erzeugt testoutput, hier k�nnte mit dbms_sql das Statement auch direkt */
		/* augef�hrt werden */
	        
            stmtDDL := 'alter tablespace ' || tsname || ' default storage (maxextents unlimited)';
            dbms_sql.parse(cDDL, stmtDDL, dbms_sql.native); 
            dbms_output.put_line(stmtDDL);
            rd := dbms_sql.execute(cDDL);
                
	   else
		exit;
	   end if;
	end loop;
        dbms_sql.close_cursor (cDDL); 
        dbms_sql.close_cursor (c);
end;
end;
/
/* scharf machen f�r den Fall der Nutzung von altds.sql */
/* spool off */
exit success
