<?xml version="1.0" encoding="UTF-8" ?>
<!-- ****************************************** -->
<!--  Style sheet for SAPup HTTP communication  -->
<!-- ****************************************** -->
<!--  $Id: //bc_control/LM-SL/lmt_023_REL/ehpi/HTDOC/doc/SAPupHttp.xsl#5 $  -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:param name="refresh">10</xsl:param>
  <xsl:output method="html" />

  <!-- *************************************************************** -->
  <xsl:template match='/'>
    <html>
      <head>
        <style type="text/css">
<![CDATA[
body      { font-family: Arial,Helvetica,sans-serif; }
table	  { border-collapse: collapse; }
table, th, td { border: 1px solid black; }
.phm      { font-size:10pt; font-weight:bold; background-color:#cccccc; width=80%; }
.phlunsel { background-color:#f2f4f7; foreground-color:#1D1D1D; }
.phlsel   { background-color:#83acd8; foreground-color:#f2f4f7; }
.rdbox    { background-color:#83acd8; 83acd8; border-color:#78a3d1; width:30px; height:30px; border:1px; }
.rdboxsel { background-color:#ffc54e; border-color:#bba669; width:30px; height:30px; border:1px; }
.button   {  }
.actidinf { font-size:10pt; font-weight:bold; background-color:lightblue; }
.actiderr { font-size:10pt; font-weight:bold; background-color:red; }
.acttitle { font-size:10pt; font-weight:bold; border:1px; }
td.pb0    { font-size:10pt; font-weight:bold; }
td.pbp    { font-size:10pt; font-weight:bold; background-color:#83acd8; }
.etag     { font-family:monospace; font-size:larger; border:1px solid; }
]]>
        </style>
	<script type="text/javascript">//<![CDATA[
// **********************************************************

function submit_form(element)
{
   document.guiform.action = element.name;
   const XHR = new XMLHttpRequest();
   const dataURLenc = new URLSearchParams(new FormData(document.guiform)).toString();

   XHR.addEventListener("load", function(e) {
	  function succHdl(e) {
	    const z = new XMLHttpRequest();
	    z.open("POST", e.target.responseURL, true);
		z.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
		z.setRequestHeader('X-CSRF-Token', e.target.getResponseHeader('x-csrf-token'));
	    z.send(dataURLenc);
		document.guiform.method = "get";
		document.guiform.submit();
	  }
	  if (e.target.status == 403) {
		const y = new XMLHttpRequest();
		y.addEventListener('load', succHdl);
		y.open("GET", e.target.responseURL, true);
		y.setRequestHeader('X-CSRF-Token', 'Fetch');
	    y.send();
	  } else {
		document.guiform.method = "get";
		document.guiform.submit();
	  } 
   });

   XHR.open("POST", document.guiform.action, true);
   XHR.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
   XHR.send(dataURLenc);

//   document.guiform.action = element.name;
//   document.guiform.submit();   
}

// **********************************************************
//  Enable/disable groups
function toggle_single_ed(element)
{
    do_toggle_ed(element, '');
    return false;
}

function toggle_multi_ed(element)
{
    var name;

    name = element.getAttribute('name');

    var ifields, nfields, i;

    ifields = document.guiform[name];
    nfields = ifields.length;

    for(i = 0 ; i < nfields ; ++i) {
       var value = ifields[i].value;
       var fset = document.getElementById('enable:' + name + '/' + value);

       do_toggle_ed(ifields[i], '/' + value);
    }
}

function do_toggle_ed(element, postfix)
{
    var elid, status, fset;

    elid = element.getAttribute('name') + postfix
    status = element.getAttribute('checked');

    fset = document.getElementById('enable:' + elid);
    if(fset) {
        fset.style.display = status ? '' : 'none';
    }
    fset = document.getElementById('disable:' + elid);
    if(fset) {
        fset.style.display = !status ? '' : 'none';
    }
}

// **********************************************************
function toggle_act(element)
{
  var item = element.firstChild;
  setElement(element, (item.data == "+") ? "-" : "+", 1);
}

//  'element' should point to the "SPAN" node with class "etag"
function setElement(element, type, dosub)
{
  var sub = element.firstChild;
  if(!sub) return;

  if(!type) type = sub.data;

  var newdisp = (type == "+") ? "none" : "";
  sub.data = type;

  //  Go to "tr" element and change display of all following "tr" until
  //   element with same class is found (== next header)
  element = element.parentNode; //  go to "TD" element
  var myclass = element.attributes["class"];
  if(!myclass) return;

  myclass = myclass.nodeValue;
  element = element.parentNode; //  go to "TR" element

  var next;
  for(next = element.nextSibling ; next ; next = next.nextSibling) {
    sub = next.firstChild;
    if(!sub) continue; //  skip text nodes

    for( ; sub ; sub = sub.nextSibling) {
      if(sub.tagName == "TD")
        break;
    }

    if(!sub || sub.attributes["class"].nodeValue == myclass)
      break;

    next.style.display = newdisp;
  }

  //  Fix all subelements on reopen
  if(dosub != 0 && newdisp == "") {
    for(next = element.nextSibling ; next ; next = next.nextSibling)
      toggleall(next, "");
  }
}

function toggleall(element, type)
{
  if(element.tagName == "SPAN") {
    var clattr = element.attributes["class"];
    if(clattr && clattr.nodeValue == "etag")
      setElement(element, type, 0);
  }

  var sub;
  for(sub = element.firstChild ; sub ; sub = sub.nextSibling)
    toggleall(sub, type);
}

// **********************************************************
function table_add_line(tabid)
{
  var table = document.getElementById(tabid);

  if(!table) {
    alert('Table ' + tabid + ' not found!');
    return;
  }

  for(table = table.firstChild ; table ; table = table.nextSibling)
    if(table.tagName == "TBODY")
      break;

  var sub, templ, count = 0;
  for(sub = table.firstChild ; sub ; sub = sub.nextSibling) {
    if(sub.tagName != "TR")
      continue;

    if(sub.style.display == 'none') {
      templ = sub;
      continue;
    }
    ++count;
  }

  if(templ) {
    templ = templ.cloneNode(true);

    templ.style.display = '';

    for(sub = templ.firstChild ; sub ; sub = sub.nextSibling) {
       var subsub;

       for(subsub = sub.firstChild ; subsub ; subsub = subsub.nextSibling) {
          if(subsub.tagName != "INPUT")
            continue;

          var name = String(subsub.name);
          if(!name) continue;

          subsub.name = name.replace(/::/g, ":" + count + ":");
       }
    }

    table.appendChild(templ);
  }
}

var CurrentRow;

function remember_focus(ele)
{
   CurrentRow = ele;
}

function table_rem_line(tabid)
{
  var table = document.getElementById(tabid);

  if(!table) {
    alert('Table ' + tabid + ' not found!');
    return;
  }

  for(table = table.firstChild ; table ; table = table.nextSibling)
    if(table.tagName == "TBODY")
      break;

  var actel = CurrentRow;
  while(actel) {
    if(actel.tagName == "TR")
      break;

    actel = actel.parentNode;
  }

  if(!actel) {
     alert('Element not found');
     return;
  }

  var sub, templ, count = 0, fixcnt = 0;
  for(sub = table.firstChild ; sub ; sub = sub.nextSibling) {
    if(sub.tagName != "TR")
      continue;

    if(sub.style.display == 'none') {
      templ = sub;
      continue;
    }

    if(sub == actel) {
      fixcnt = 1;
      count--;
    }

    if(fixcnt > 0) {
      for(subsub = sub.firstChild.firstChild ; subsub ; subsub = subsub.nextSibling) {
        if(subsub.tagName != "INPUT")
          continue;

        var name = String(subsub.name);
        if(!name) continue;

        subsub.name = name.replace(/:\d+:/g, ":" + count + ":");

        if(fixcnt == 2) {
          if(subsub.focus)
            subsub.focus();
          else if(subsub.setActive)
            subsub.setActive();
        }
      }

      ++fixcnt;
    }

    ++count;
  }

  table.removeChild(actel);
}

function handle_breakpoint(ele)
{
  if(ele.firstChild.data == "+") {
    var trline = ele.parentNode.parentNode;
    var newtrline = trline.cloneNode(true);

    var sub_input, sub_enabled, sub_name;

    sub_input = newtrline.firstChild;
    sub_enabled = sub_input.nextSibling;
    sub_input = sub_input.firstChild;

    sub_name = sub_enabled.nextSibling;
    sub_enabled = sub_enabled.firstChild;
    sub_name = sub_name.firstChild;

    var breakName = sub_name.value;

    if(breakName == "") {
       alert("Please enter a phase name!");
       return;
    }
    sub_input.firstChild.data = "-";
    sub_input = sub_input.nextSibling;
    sub_input.name = "DEL:" + breakName;
    sub_enabled.name = "BRK:" + breakName;

    sub_name.name = "ADD:" + breakName;
    sub_name.disabled = "disabled";

    sub_name = sub_name.nextSibling;
    sub_name.name = "ADD:" + breakName;

    trline.parentNode.insertBefore(newtrline, trline);

    var orig_text = trline.firstChild.nextSibling.nextSibling.firstChild;
    orig_text.value = "";

  } else if(ele.firstChild.data == "-") {
    var parent = ele.parentNode;

    var sub;
    for(sub = parent.firstChild ; sub ; sub = sub.nextSibling) {
      if(sub.tagName == "INPUT") {
        sub.value = "true";
      }
    }

    parent.parentNode.style.display = 'none';

    var sub_input = parent.nextSibling.nextSibling;
    while(sub_input.firstChild && sub_input.firstChild.tagName == "INPUT")
        sub_input.removeChild(sub_input.firstChild);
  }
}

//]]>
        </script>
	<xsl:choose>
          <xsl:when test="name(*) = 'Actions'">
            <title>ABAP Actions</title>
            <meta http-equiv="refresh" >
	      <xsl:attribute name="content"><xsl:value-of select="$refresh" />; URL=manual_actions</xsl:attribute>
	    </meta>
          </xsl:when>
          <xsl:when test="name(*) = 'PhaseList'">
            <title>ABAP Phaselist</title>
<!--
            <meta http-equiv="refresh" >
	      <xsl:attribute name="content"><xsl:value-of select="$refresh" />; URL=phaselist</xsl:attribute>
	    </meta>
-->
          </xsl:when>
          <xsl:when test="name(*) = 'BreakPoints'">
            <title>ABAP Breakpoints</title>
          </xsl:when>
	  <xsl:when test="count(ToolStatus/metadialog) &gt; 0">
            <title>ABAP Gui: <xsl:value-of select="ToolStatus/metadialog/content/header/title" /></title>
          </xsl:when>
          <xsl:when test="name(*) = 'DirectoryList'">
            <title>Directory <xsl:value-of select="DirectoryList/@name" /></title>
          </xsl:when>
	  <xsl:otherwise>
            <title>ABAP Tool status</title>
              <meta http-equiv="refresh" >
		<xsl:attribute name="content"><xsl:value-of select="$refresh" />; URL=gui</xsl:attribute>
	      </meta>
	  </xsl:otherwise>
	</xsl:choose>
      </head>
      <body>
        <xsl:apply-templates />
      </body>
    </html>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='ToolStatus'>
    <xsl:variable name="status" select="Status" />
    <xsl:variable name="current" select="UnitStati/@current" />
    <xsl:variable name="progress" select="Progress" />
    <xsl:variable name="esttime" select="Estimate" />
    <xsl:variable name="lefttime" select="Estimate/@left" />
    <xsl:variable name="subesttime" select="SubEstimate" />
    <xsl:variable name="sublefttime" select="SubEstimate/@left" />
    <xsl:variable name="description" select="Description" />

    <xsl:if test="$status != ''">
    <table>
      <tr>
        <xsl:for-each select="UnitStati/Unit">
          <td width="12.5%" align="center">
            <xsl:choose>
              <xsl:when test="@id = $current">
                <table><tr>
                <td class="rdboxsel" align="center"><xsl:number /></td>
                </tr></table>
              </xsl:when>
              <xsl:otherwise>
                <table><tr>
                <td class="rdbox" align="center"><xsl:number /></td>
                </tr></table>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </xsl:for-each>
      </tr>
      <tr>
        <xsl:for-each select="UnitStati/Unit">
          <td align="center" font="Helvetica">
            <xsl:value-of select="@title" />
          </td>
        </xsl:for-each>
      </tr>
      <xsl:if test="$progress &gt; 0">
	<tr>
	  <td>
	    <xsl:attribute name="colspan"><xsl:value-of select="count(UnitStati/Unit)" /></xsl:attribute>
            <table width="100%" border="1" align="right" cellpadding="2">
              <tr>
		<xsl:if test="$progress &gt; 0">
                  <td class="pbp" align="center" nowrap="nowrap" width="{$progress}%">
                    <xsl:choose>
                      <xsl:when test="$progress &gt; 19">
			<xsl:value-of select="$progress" />%
                      </xsl:when>
                      <xsl:otherwise>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
		</xsl:if>
		<xsl:if test="$progress &lt; 100">
                  <td class="pb0" align="center">
                    <xsl:choose>
                      <xsl:when test="$progress &lt; 20">
			<xsl:value-of select="$progress" />%
                      </xsl:when>
                      <xsl:otherwise>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
		</xsl:if>
              </tr>
            </table>
	  </td>
	</tr>
      </xsl:if>
    </table>
    <hr/>

    <table>
      <tr>
        <td width="15%">
          <xsl:choose>
            <xsl:when test="$status = 'RUNNING'">
	      <xsl:attribute name="bgcolor">lightblue</xsl:attribute>
            </xsl:when>
            <xsl:when test="$status = 'STOPPED'">
	      <xsl:attribute name="bgcolor">yellow</xsl:attribute>
            </xsl:when>
            <xsl:when test="$status = 'BREAK'">
	      <xsl:attribute name="bgcolor">yellow</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
	      <xsl:attribute name="bgcolor">red</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
	  <center>
            <xsl:value-of select="$status" />
	  </center>
        </td>
        <td>
        </td>
        <td>
          <p><xsl:value-of select="$description" /></p>
        </td>
      </tr>

      <xsl:if test="$esttime != ''">
	<tr>
	  <td colspan="3">
	    <hr/>
	  </td>
	</tr>
	<tr>
	  <td colspan="3">
	    Estimated time to finish: <xsl:value-of select="$esttime" /> (left: <xsl:value-of select="$lefttime" />) <br/>
	  </td>
	</tr>
      </xsl:if>
      <xsl:if test="$subesttime != ''">
	<tr>
	  <td colspan="3">
	    Estimated time to finish phase: <xsl:value-of select="$subesttime" /> (left: <xsl:value-of select="$sublefttime" />) <br/>
	  </td>
	</tr>
      </xsl:if>
    </table>
    <hr/>
    </xsl:if>

    <p>
      <xsl:choose>
	<!-- ************************************************ -->
	<xsl:when test="count(metadialog) &gt; 0">

	  <form name="guiform" method="post">
	    <xsl:attribute name="action">
	      <xsl:value-of select="link[@name = 'next']/@uri" />
	    </xsl:attribute>

	    <table border="1" width="80%">

	      <xsl:if test="count(DialogueError) &gt; 0">
		<tr><td>
		    <xsl:value-of select="DialogueError" />
		</td></tr>
	      </xsl:if>

	      <xsl:apply-templates select="metadialog"/>
	    </table>
	  </form>
        </xsl:when>
	<!-- ************************************************ -->
        <xsl:otherwise>
	  <!--<iframe src="phaselist#current"
		  name="Phase list"
		  width="60%"
		  height="50%"
		  frameborder="1"
		  scrolling="auto"
		  />-->
            <table border="1" width="80%">
                <tr>
                    <td>Processing request...</td>
                </tr>
            </table>
            <script type="text/javascript">//<![CDATA[
                setTimeout(function(){location.reload();}, 3000);
            //]]></script>
	</xsl:otherwise>
      </xsl:choose>
    </p>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='PhaseList'>
    <xsl:variable name="current" select="@current" />

    <table class="phm">
      <xsl:for-each select="Phase">
        <tr>
	  <td>
	    <xsl:attribute name="class">
              <xsl:choose>
		<xsl:when test=". = $current">phlsel</xsl:when>
		<xsl:otherwise>phlunsel</xsl:otherwise>
              </xsl:choose>
	    </xsl:attribute>

	    <a target="_blank" rel="noopener noreferrer">
	      <xsl:attribute name="href">
		<xsl:value-of select="concat('phaselog/', .)" />
	      </xsl:attribute>
	      <xsl:value-of select="." />
	    </a>
	  </td>
	</tr>
      </xsl:for-each>
    </table>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='Actions'>
    <table width="90%">
      <xsl:for-each select="action">
	<tr>
	  <td class="etag" width="2%">
	    <span class="etag" onclick="toggle_act(this)">+</span>
	  </td>
	  <td width="20%">
            <xsl:choose>
	      <xsl:when test="@type = 'error'">
		<xsl:attribute name="class">actiderr</xsl:attribute>
	      </xsl:when>
	      <xsl:otherwise>
		<xsl:attribute name="class">actidinf</xsl:attribute>
	      </xsl:otherwise>
            </xsl:choose>
	    <xsl:value-of select="@id" />
	  </td>
	  <td class="acttitle">
	    <xsl:value-of select="@title" />
	  </td>
	</tr>
	<tr style="display:none">
	  <td></td>
	  <td colspan="2">
	    <table border="1"><tr><td>
            <xsl:choose>
	      <xsl:when test="count(html/body) &gt; 0">
		<xsl:for-each select="html/body">
		  <xsl:copy-of select="." />
		</xsl:for-each>
	      </xsl:when>
	      <xsl:otherwise>
		<xsl:copy-of select="." />
	      </xsl:otherwise>
            </xsl:choose>
	    </td></tr></table>
	  </td>
	</tr>
      </xsl:for-each>
    </table>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='BreakPoints'>
    <form name="guiform" method="post">
      <h2>List of breakpoints</h2>
      <table class="phm" border="1">
	<xsl:attribute name="action">
	  <xsl:value-of select="link[@name = 'breakpoints']/@uri" />
	</xsl:attribute>

	<tr>
	  <th>Delete/Add</th>
	  <th>Enabled</th>
	  <th>Breakpoint</th>
	</tr>

	<xsl:for-each select="BreakPoint">
          <tr>
	    <td>
	      <span class="etag" onclick="handle_breakpoint(this)">-</span>
              <input type="hidden" value="false" >
		<xsl:attribute name="name">DEL:<xsl:value-of select="."/></xsl:attribute>
              </input>
	    </td>
	    <td>
              <input type="checkbox">
		<xsl:attribute name="name">BRK:<xsl:value-of select="."/></xsl:attribute>

		<xsl:if test="@enabled = 'true'">
                  <xsl:attribute name="checked">checked</xsl:attribute>
		</xsl:if>
              </input>
	    </td>
	    <td>
	      <xsl:value-of select="." />
	    </td>
	  </tr>
	</xsl:for-each>

	<tr>
	  <td>
	    <span class="etag" onclick="handle_breakpoint(this)">+</span>
            <input type="hidden" value="" />
	  </td>
	  <td>
            <input type="checkbox" checked="checked">
	    </input>
	  </td>
	  <td>
	    <input type="text" value="" />
	    <input type="hidden" value="" />
	  </td>
	</tr>
      </table>
      <input type="submit" value="Update" class="button" />
    </form>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='DirectoryList'>
    <table border="1">
      <tr>
	<th>Name</th>
	<th>Date</th>
	<th>Size</th>
      </tr>
      <xsl:for-each select="FileEntry">
	<tr>
	  <td>
	    <a target="_blank" rel="noopener noreferrer">
	      <xsl:attribute name="href">
		<xsl:value-of select="concat(../@name, '/', @name)" />
	      </xsl:attribute>

	      <xsl:value-of select="@name" />
	    </a>
	  </td>
	  <td>
	    <xsl:value-of select="@date" />
	  </td>
	  <td align="right">
	    <xsl:value-of select="@size" />
	  </td>
	</tr>
      </xsl:for-each>
    </table>
  </xsl:template>

  <!-- *************************************************************** -->
  <!-- *************************************************************** -->
  <xsl:template match='metadialog'>
    <tr>
      <td width="25%">
        <input type="button" value="Back" onclick="submit_form(this)" class="button">
	  <xsl:choose>
	    <xsl:when test="../link[@name='back']">
	      <xsl:attribute name="name">
		<xsl:value-of select="../link[@name = 'back']/@uri" />
	      </xsl:attribute>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:attribute name="disabled">disabled</xsl:attribute>
	    </xsl:otherwise>
	  </xsl:choose>
        </input>
      </td>
      <td width="25%">
        <input type="button" value="Next" onclick="submit_form(this)" class="button">
	  <xsl:attribute name="name">
	    <xsl:value-of select="../link[@name = 'next']/@uri" />
	  </xsl:attribute>
	</input>
      </td>
      <td width="25%">
        <input type="button" onclick="submit_form(this)" value="Reset" class="button">
	  <xsl:choose>
	    <xsl:when test="../link[@name='reset']">
	      <xsl:attribute name="name">
		<xsl:value-of select="../link[@name = 'reset']/@uri" />
	      </xsl:attribute>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:attribute name="disabled">disabled</xsl:attribute>
	    </xsl:otherwise>
	  </xsl:choose>
        </input>
      </td>
    </tr>
    <tr valign="middle">
      <td colspan="4">
        <center>
          <h3> <xsl:value-of select="content/header/title" /></h3>
        </center>
      </td>
    </tr>
    <tr>
      <td colspan="4">
	<table>
	  <input type="hidden" name="form:diagtime">
            <xsl:attribute name="value">
	      <xsl:value-of select="@diagtime" />
	    </xsl:attribute>
	  </input>
          <xsl:apply-templates select="content/group"/>
	</table>
      </td>
    </tr>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='group'>
    <xsl:choose>
      <xsl:when test="caption != ''">
	<tr><td colspan="2">
        <fieldset>
          <legend><h4>Caption: <xsl:value-of select="caption" /></h4></legend>
	  <table>
            <xsl:apply-templates select="*"/>
	  </table>
        </fieldset>
	</td></tr>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="*"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='caption'>
    <!--  must be dropped since it is handled elsewhere  -->
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='text'>
    <tr>
      <td colspan="2">
	<xsl:choose>
	  <xsl:when test="count(html) &gt; 0">
            <xsl:copy-of select="html" />
	  </xsl:when>
          <xsl:otherwise>
            <xsl:copy-of select="." />
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='choice'>
    <xsl:choose>
      <xsl:when test="count(multichoice) &gt; 0">
	<xsl:variable name="id" select="@id" />
	<xsl:variable name="has_ed" select="count(multichoice/item/enables) + count(multichoice/item/disables)" />

	<tr>
	  <td>
            <label>
              <xsl:attribute name="for">
		<xsl:value-of select="@id"/>
              </xsl:attribute>
              <xsl:value-of select="caption" />
            </label>
	  </td>
	  <td>
            <xsl:for-each select="multichoice/item">
	      <xsl:call-template name="gen-radio">
		<xsl:with-param name="name" select="$id" />
		<xsl:with-param name="has_ed" select="$has_ed" />
	      </xsl:call-template>
            </xsl:for-each>
	  </td>
	</tr>

        <xsl:for-each select="multichoice/item/enables">
	  <tr>
	    <td colspan="2">
              <xsl:choose>
		<xsl:when test="../@selected = 'true'">
		  <xsl:call-template name="show-ed">
                    <xsl:with-param name="type" select="'enable'" />
                    <xsl:with-param name="id" select="concat($id, '/', ../@id)" />
		  </xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
		  <xsl:call-template name="show-ed">
                    <xsl:with-param name="type" select="'enable'" />
                    <xsl:with-param name="id" select="concat($id, '/', ../@id)" />
                    <xsl:with-param name="style" select="'display:none'" />
		  </xsl:call-template>
		</xsl:otherwise>
              </xsl:choose>
	    </td>
	  </tr>
        </xsl:for-each>
      </xsl:when>

      <!-- ********************************************************** -->
      <xsl:when test="count(singlechoice) &gt; 0">
	<tr>
	  <td>
            <label>
              <xsl:attribute name="for">
		<xsl:value-of select="@id"/>
              </xsl:attribute>
              <xsl:value-of select="caption" />
            </label>
	  </td>
	  <td>
            <input type="checkbox">
              <xsl:attribute name="name">
                <xsl:value-of select="@id"/>
              </xsl:attribute>
              <xsl:attribute name="value">true</xsl:attribute>
              <xsl:if test="singlechoice/@selected = 'true'">
                <xsl:attribute name="checked">checked</xsl:attribute>
              </xsl:if>
              <xsl:if test="count(singlechoice/enables) &gt; 0 or count(singlechoice/disables) &gt; 0">
                <xsl:attribute name="onclick">toggle_single_ed(this)</xsl:attribute>
              </xsl:if>
            </input>
	  </td>
	</tr>

        <xsl:if test="count(singlechoice/enables) &gt; 0">
	  <tr>
	    <td colspan="2">
              <xsl:choose>
		<xsl:when test="singlechoice/@selected = 'true'">
                  <xsl:call-template name="show-ed">
                    <xsl:with-param name="type" select="'enable'" />
                    <xsl:with-param name="id" select="@id" />
                  </xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
                  <xsl:call-template name="show-ed">
                    <xsl:with-param name="type" select="'enable'" />
                    <xsl:with-param name="id" select="@id" />
                    <xsl:with-param name="style" select="'display:none'" />
                  </xsl:call-template>
		</xsl:otherwise>
              </xsl:choose>
	    </td>
	  </tr>
        </xsl:if>

        <xsl:if test="count(singlechoice/disables) &gt; 0">
	  <tr>
	    <td colspan="2">
              <xsl:choose>
                <xsl:when test="singlechoice/@selected = 'true'">
                  <xsl:call-template name="show-ed">
                    <xsl:with-param name="type" select="'disable'" />
                    <xsl:with-param name="id" select="@id" />
                    <xsl:with-param name="style" select="'display:none'" />
                  </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:call-template name="show-ed">
                    <xsl:with-param name="type" select="'disable'" />
                    <xsl:with-param name="id" select="@id" />
                  </xsl:call-template>
                </xsl:otherwise>
              </xsl:choose>
	    </td>
	  </tr>
        </xsl:if>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='input'>
    <tr>
      <td>
        <xsl:value-of select="caption" />
      </td>
      <td>
	<xsl:call-template name="gen-input">
          <xsl:with-param name="name" select="@id" />
          <xsl:with-param name="readonly" select="'no'" />
	</xsl:call-template>
      </td>
    </tr>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='output'>
    <tr>
      <td>
        <xsl:value-of select="caption" />
      </td>
      <td>
	<xsl:call-template name="gen-input">
          <xsl:with-param name="name" select="@id" />
          <xsl:with-param name="readonly" select="'yes'" />
	</xsl:call-template>
      </td>
    </tr>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template match='table'>
    <xsl:variable name="tabid" select="@id" />

    <xsl:if test="@dynamic = 'true'">
      <tr>
	<td>
	  <input type="button" name="Add" value="Add">
	    <xsl:attribute name="onclick">
	      <xsl:value-of select="concat('table_add_line(&quot;', $tabid, '&quot;)')"/>
	    </xsl:attribute>
	  </input>
	</td>
	<td>
	  <input type="button" name="Remove" value="Remove">
	    <xsl:attribute name="onclick">
	      <xsl:value-of select="concat('table_rem_line(&quot;', $tabid, '&quot;)')"/>
	    </xsl:attribute>
	  </input>
	</td>
      </tr>
    </xsl:if>

    <tr>
      <td colspan="2">
	<table border="1">
	  <xsl:attribute name="id"><xsl:value-of select="$tabid"/> </xsl:attribute>

	  <caption>
	    <xsl:value-of select="caption" />
	  </caption>
	  <tbody>
	  <tr>
            <xsl:for-each select="column">
	      <th>
		<xsl:value-of select="@id" />
	      </th>
	    </xsl:for-each>
	  </tr>

	  <xsl:if test="@dynamic = 'true'">
	    <tr style="display:none"> <!--  Template line  -->
              <xsl:for-each select="column/*">
		<xsl:variable name="colid" select="../@id" />
		<xsl:call-template name="gen-tabcol">
		  <xsl:with-param name="cellname" select="name()" />
		  <xsl:with-param name="colid" select="$colid" />
		  <xsl:with-param name="name" select="concat($tabid, '::', $colid)" />
		</xsl:call-template>
	      </xsl:for-each>
	    </tr>
	  </xsl:if>

      <xsl:for-each select="row">
	    <xsl:variable name="rowpos" select="position()" />
	    <tr>
          <xsl:for-each select="/*">
		    <xsl:variable name="cellpos" select="position()" />
            <xsl:variable name="colid" select="../column[position() = $cellpos]/@id" />
	        <xsl:call-template name="gen-tabcol">
		      <xsl:with-param name="cellname" select="name(../column[position() = $cellpos]/*)" />
		      <xsl:with-param name="colid" select="$colid" />
		      <xsl:with-param name="name" select="concat($tabid, ':', $rowpos, ':', $colid)" />
		    </xsl:call-template>
	      </xsl:for-each>
	    </tr>
	  </xsl:for-each>
	  </tbody>

	  <!-- TODO:  mappeditemcell/stringvalue + stringvalue ??? -->
	</table>
      </td>
    </tr>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template name="show-ed">
    <xsl:param name="type"/>
    <xsl:param name="id"/>
    <xsl:param name="style" select="''"/>

    <fieldset>
      <xsl:attribute name="id">
        <xsl:value-of select="concat($type, ':', $id)" />
      </xsl:attribute>
      <xsl:attribute name="style">
        <xsl:value-of select="$style" />
      </xsl:attribute>
      <table>
        <xsl:apply-templates />
      </table>
    </fieldset>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template name="gen-input">
    <xsl:param name="name"/>
    <xsl:param name="readonly"/>
    <xsl:param name="focus" select="'no'" />

    <input>
      <xsl:if test="$readonly = 'yes'">
        <xsl:attribute name="readonly">readonly</xsl:attribute>
        <xsl:attribute name="disabled">disabled</xsl:attribute>
      </xsl:if>

      <xsl:if test="$focus = 'yes'">
        <xsl:attribute name="onfocus">remember_focus(this)</xsl:attribute>
      </xsl:if>

      <xsl:attribute name="name">
        <xsl:value-of select="$name"/>
      </xsl:attribute>
      <xsl:choose>
        <xsl:when test="count(string/stringvalue) &gt; 0">
          <xsl:attribute name="type">text</xsl:attribute>
          <xsl:attribute name="value">
            <xsl:value-of select="string/stringvalue"/>
          </xsl:attribute>
        </xsl:when>
	<!--  for outputcells  -->
        <xsl:when test="count(stringvalue) &gt; 0">
          <xsl:attribute name="type">text</xsl:attribute>
          <xsl:attribute name="value">
            <xsl:value-of select="stringvalue"/>
          </xsl:attribute>
        </xsl:when>
        <xsl:when test="count(numeric/numericvalue) &gt; 0">
          <xsl:attribute name="type">text</xsl:attribute>
          <xsl:attribute name="value">
            <xsl:value-of select="numeric/numericvalue"/>
          </xsl:attribute>
        </xsl:when>
        <xsl:when test="count(path/pathvalue) &gt; 0">
          <xsl:attribute name="type">text</xsl:attribute>
          <xsl:attribute name="value">
            <xsl:value-of select="path/pathvalue"/>
          </xsl:attribute>
        </xsl:when>
        <xsl:when test="count(password/passvalue) &gt; 0">
          <xsl:attribute name="type">password</xsl:attribute>
          <xsl:attribute name="value">
            <xsl:value-of select="password/passvalue"/>
          </xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="type">text</xsl:attribute>
          <xsl:attribute name="value"></xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
    </input>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template name="gen-radio">
    <xsl:param name="name"/>
    <xsl:param name="has_ed"/>

    <input type="radio">
      <xsl:attribute name="name">
        <xsl:value-of select="$name"/>
      </xsl:attribute>
      <xsl:attribute name="value">
        <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:if test="@selected = 'true'">
        <xsl:attribute name="checked">checked</xsl:attribute>
      </xsl:if>
      <xsl:if test="$has_ed &gt; 0">
        <xsl:attribute name="onclick">toggle_multi_ed(this)</xsl:attribute>
      </xsl:if>
    </input>
    <xsl:value-of select="stringvalue" /> <br/>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template name="gen-tabcol">
    <xsl:param name="cellname"/>
    <xsl:param name="colid"/>
    <xsl:param name="name"/>

    <td>
      <xsl:choose>
	<xsl:when test="$cellname = 'outputcell'">
	  <xsl:call-template name="gen-input">
	    <xsl:with-param name="name" select="$name" />
	    <xsl:with-param name="readonly" select="'yes'" />
	  </xsl:call-template>
	</xsl:when>
	<xsl:when test="$cellname = 'inputcell'">
	  <xsl:call-template name="gen-input">
	    <xsl:with-param name="name" select="$name" />
	    <xsl:with-param name="readonly" select="'no'" />
	    <xsl:with-param name="focus" select="'yes'" />
	  </xsl:call-template>
	</xsl:when>
	<xsl:when test="$cellname = 'choicecell'">
	  <input type="checkbox">
            <xsl:attribute name="name">
              <xsl:value-of select="$name"/>
            </xsl:attribute>
            <xsl:attribute name="value">true</xsl:attribute>
            <xsl:if test=". = 'true'">
              <xsl:attribute name="checked">checked</xsl:attribute>
            </xsl:if>
          </input>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:value-of select="$cellname" />
	</xsl:otherwise>
      </xsl:choose>
    </td>
  </xsl:template>

  <!-- *************************************************************** -->
  <xsl:template name="NBSPC">
    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
  </xsl:template>

</xsl:stylesheet>
