<?xml version="1.0" encoding="UTF-8" ?>
<!-- ************************************************* -->
<!-- Transforms phaselist as generated by SAPup -->
<!-- into a human readable HTML format -->
<!-- Copyright 2008 SAP-AG -->
<!-- ************************************************* -->

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
        <xsl:output method="html" />
        <xsl:variable name="strategy">Downtime-minimized</xsl:variable>
        <xsl:variable name="exclude-roadmap">SYSIDENTUPDATE</xsl:variable>
        <xsl:variable name="excluded-module-type">revoke</xsl:variable>

        <xsl:template match='/*'>
                        <xsl:choose>
                                <xsl:when test="name() = 'ExecutionControl'">
                                        <xsl:variable name="execntrl" select="." />
                                        <xsl:call-template name="gen-html-head" />

                                        <body onload="redesign()">
                                                <a name="top" />
                                                <xsl:call-template name="gen-html-title" />

                                                <xsl:for-each select="UnitDefinition">
                                                        <xsl:call-template name="gen-unitcntrl">
                                                                <xsl:with-param name="execntrl" select="$execntrl" />
                                                        </xsl:call-template>
                                                </xsl:for-each>

                                                <xsl:call-template name="assignUnreferencedModules"/>
                                                <xsl:call-template name="assignRevokeModules"/>
                                        </body>
                                </xsl:when>

                                <xsl:when test="name() = 'SAPupControl'">
                                        <body>
                                                <div>
                                                        NB:
                                                        <b>
                                                                <xsl:value-of select="ExecutionControl/@note"></xsl:value-of>
                                                        </b>
                                                </div>
                                        </body>
                                </xsl:when>
                        </xsl:choose>
        </xsl:template>

        <!-- ******************************************************************* -->
        <xsl:template name="gen-html-head">
                <head>
                        <title>
                                Phases:
                                <xsl:value-of select="@name" />
                        </title>
                        <style type="text/css">
                                body {
                                        font-family: Arial;
                                        margin-top:20px;
                                        margin-bottom:20px; margin-left:20px;
                                        margin-right:20px;
                                        background-color:#ffffff;
                                }
                                .roadmap , .revokes , .unreferenced {
                                        border-radius: 25px;
                                        border: 2px solid #999999;
                                        padding: 20px;
                                        margin-bottom: 20px;
                                }
                                .roadmapSteps {
                                        margin:10px;
                                }
                                .roadmapStep {
                                        border-radius: 25px;
                                border: 2px solid #008FD3;
                                        padding: 10px;
                                        margin-bottom:20px;
                                }
                                .stepName {
                                        border-radius: 25px;
                                border: 2px solid #008FD3;
                                        padding: 20px;
                                }
                                .moduleName {
                                        font-family:Arial;
                                        font-size:larger;
                                        font-weight:bold;
                                }
                                .rsTable {
                                        border-radius: 25px;
                                        margin:10px
                                }
                                .rsTable.module {
                                        border: 2px solid #93C939;
                                }
                                .rsTable.module .phm {
                                        font-size:12pt;
                                        color:#587822;
                                        vertical-align:middle;
                                }
                                .rsTable.sub {
                                        margin:15px;
                                        border: 2px solid #F0AB00;
                                }
                                .rsContent {
                                        margin:5px;
                                }
                                .subRevoke {
                                        border-radius: 25px;
                                }
                                .fixSize {
                                        width: 300px;
                                        height: 70px;
                                }
                                .toc { font-size:12pt; }
                                .foot {
                                        font-size:10pt;
                                }
                                .btoc {
                                font-size:12pt; font-weight:bold; }
                                .head {
                                        text-align: center;
                                        font-size:24pt;
                                        font-weight:bold;
                                }
                                .etag {
                                        font-size:larger;
                                        border-radius: 25px;
                                border:1px solid;
                                        cursor: pointer
                                }
                                .etagTable {
                                        font-size:larger;
                                        border:1px solid;
                                        cursor: pointer
                                }
                                .etag2{
                                        font-size:larger; border:1px solid;
                                }
                                .allbutton {
                                        border:1px solid;
                                }
                                form.searchForm {
                                        display: inline;
                                }
                                button {
                                        cursor: pointer;
                                        margin: 10px;
                                        border-radius: 5px;
                                        text-decoration: none;
                                        padding: 0px;
                                        text-align: center;
                                        font-size: 22px;
                                        transition: .3s;
                                        -webkit-transition: .3s;
                                        -moz-transition: .3s;
                                        -o-transition: .3s;
                                        display: inline-block;

                                        background-color: #ffffff;
                                }
                                button:hover {
                                        background-color: #55acee;
                                        color: #fff
                                }
                                button.blue:active , button.red:active, button.yellow:active, button.purple:active {
                                        padding:0.1em;
                                }
                                button.blue.plus:active, button.red.minus:active {
                                transition: .1s;
                                        -webkit-transition: .1s;
                                        -moz-transition: .1s;
                                        -o-transition: .1s;
                                padding: 10px;
                                }
                                .blue.plus , .red.minus , .noToggle.blue {
                                        width:35px;
                                        height:35px;
                                }
                                .blue {
                                        color: #55acee;
                                        border: 2px #55acee solid;
                                }
                                .blue:hover {
                                        background-color: #55acee;
                                        color: #fff
                                }
                                .red {
                                        color: #e74c3c;
                                        border: 2px #e74c3c solid;
                                }
                                .red:hover {
                                        color: #fff;
                                        background-color: #e74c3c;
                                }
                                .purple {
                                        color: #9b59b6;
                                        border: 2px #9b59b6 solid;
                                }
                                .purple:hover {
                                        color: #fff;
                                        background-color: #9b59b6;
                                }
                                .yellow {
                                        color: #f1c40f;
                                        border: 2px #f1c40f solid;
                                }
                                .yellow:hover {
                                        color: #fff;
                                        background-color: #f1c40f;
                                }
                                .openModuleComplete {
                                        float:right;
                                        font-size:12pt
                                }
                                a:link { color:#000080; text-decoration:none; }
                                a:visited {
                                        color:#000080;
                                        text-decoration:none;
                                }
                                #searchField, #searchButton, #searchDescription {
                                        float:right;
                                        margin:0;
                                        display: inline-block;
                                }
                                #searchField {
                                        border-radius: 5px;
                                        width:15%;
                                        font-size: 16pt;
                                        font-weight:lighter;
                                }
                                #searchDescription {
                                        font-size: 16pt;
                                        font-weight:lighter;
                                        margin-right:5px;
                                        color:#666666
                                }
                                table {
                                        padding: 20px;
                                        empty-cells:show;
                                }
                                tr:last-child {
                                        background-color:#000000
                                        height:500px;
                                }
                                td {
                                        text-align:left;
                                        vertical-align:top;
                                        max-width: 150px;
                                    word-wrap: break-word;
                                }
                                .placeholder {
                                        border:none
                                }
                                td.hab {
                                        font-size:10pt;
                                        font-weight:bold;
                                        color:#fefcff;
                                        height:25px;
                                        vertical-align:middle;
                                }
                                .uhm {
                                        color:#00557E;
                                        font-size:12pt;
                                        font-weight:bold;
                                        text-indent:4px;
                                }
                                td.bP {
                                        font-size:10pt; text-align:left; vertical-align:top;
                                }
                                .arg {
                                        font-family: Consolas
                                }
                                td.b { font-size:10pt; text-align:left;
                                vertical-align:top; }
                                td.bL {
                                        font-family: Consolas;
                                        font-size:10pt;
                                        text-align:left;
                                        vertical-align:top;
                                }
                                .phm , .revokeTitel , .urTitel {
                                        font-size:14pt;
                                        font-weight:bold;
                                        color:#666666;
                                        text-indent:0px;
                                }
                                td.php {
                                        font-size:10pt;
                                        font-weight:bold;
                                        background-color:#93C939;
                                        min-width:25pt;
                                }

                                .phs {
                                        font-size:10pt; font-weight:bold;
                                        color:#C08800;
                                        text-indent:4px;
                                }
                                .phq {
                                        font-size:10pt;
                                        font-weight:bold; background-color:#F0AB00;
                                        text-indent:4px;
                                }

                                table.noborder { border:0px #211500; border-style: none;
                                border-collapse:collapse;
                                }
                                ul { display: inline; margin: 0;
                                list-style-type: none; margin-left:
                                0; padding-left: 0; }
                                li {
                                        font-family: Consolas;
                                        padding-left: 1em;
                                        text-indent: -1em;
                                }
                                li.inside:before { content:
                                "++"; padding-right: 5px; font-weight:bold;
                                color:#C11B17; }
                                .plusplus { font-size:10pt; font-weight:bold; color:#C11B17;
                                text-decoration:none; }
                                .dollar { color: #970A82 }
                                .percent { color: #BC3618 }

                        </style>

                        <script type="text/javascript">
                                if (document.URL.indexOf("?suihcb=true")>0) {
                                        document.styleSheets[0].deleteRule(0);
                                        document.styleSheets[0].insertRule("body { font-family: Arial; margin: 20px; background-color: rgb(0, 0, 0); color: rgb(255,255,255); }", 0);
                                        document.styleSheets[0].deleteRule(1);
                                        document.styleSheets[0].insertRule(".roadmap, .revokes, .unreferenced { border-radius: 25px; border: 2px solid rgb(204,204,204); padding: 20px; margin-bottom: 20px; }", 1);
                                        document.styleSheets[0].deleteRule(3);
                                        document.styleSheets[0].insertRule(".roadmapStep { border-radius: 25px; border: 2px solid rgb(179,231,255); padding: 10px; margin-bottom: 20px; }", 3);
                                        document.styleSheets[0].deleteRule(4);
                                        document.styleSheets[0].insertRule(".stepName { border-radius: 25px; border: 2px solid rgb(179,231,255); padding: 20px; }", 4);
                                        document.styleSheets[0].deleteRule(7);
                                        document.styleSheets[0].insertRule(".rsTable.module { border: 2px solid rgb(225,252,156); }", 7);
                                        document.styleSheets[0].deleteRule(8);
                                        document.styleSheets[0].insertRule(".rsTable.module .phm { font-size: 12pt; color: rgb(222,238,195); vertical-align: middle; }", 8);
                                        document.styleSheets[0].deleteRule(9);
                                        document.styleSheets[0].insertRule(".rsTable.sub { margin: 15px; border: 2px solid rgb(255,226,153); }", 9);
                                        document.styleSheets[0].deleteRule(22);
                                        document.styleSheets[0].insertRule("button { cursor: pointer; margin: 10px; border-radius: 5px; text-decoration: none; padding: 0px; text-align: center; font-size: 22px; transition: all 0.3s ease 0s; display: inline-block; background-color: rgb(0,0,0); }", 22);
                                        document.styleSheets[0].deleteRule(23);
                                        document.styleSheets[0].insertRule("button:hover { background-color: rgb(185,221,248); color: rgb(0,0,0); }", 23);
                                        document.styleSheets[0].deleteRule(27);
                                        document.styleSheets[0].insertRule(".blue { color: rgb(185,221,248); border: 2px solid rgb(185,221,248); }", 27);
                                        document.styleSheets[0].deleteRule(28);
                                        document.styleSheets[0].insertRule(".blue:hover { background-color: rgb(185,221,248); color: rgb(0,0,0); }", 28);
                                        document.styleSheets[0].deleteRule(29);
                                        document.styleSheets[0].insertRule(".red { color: rgb(244,172,164); border: 2px solid rgb(244,172,164); }", 29);
                                        document.styleSheets[0].deleteRule(30);
                                        document.styleSheets[0].insertRule(".red:hover { color: rgb(0,0,0); background-color: rgb(244,172,164); }", 30);
                                        document.styleSheets[0].deleteRule(31);
                                        document.styleSheets[0].insertRule(".purple { color: rgb(247,218,187); border: 2px solid rgb(247,218,187); }", 31);
                                        document.styleSheets[0].deleteRule(32);
                                        document.styleSheets[0].insertRule(".purple:hover { color: rgb(0,0,0); background-color: rgb(247,218,187); }", 32);
                                        document.styleSheets[0].deleteRule(33);
                                        document.styleSheets[0].insertRule(".yellow { color: rgb(254,236,154); border: 2px solid rgb(254,236,154); }", 33);
                                        document.styleSheets[0].deleteRule(34);
                                        document.styleSheets[0].insertRule(".yellow:hover { color: rgb(0,0,0); background-color: rgb(254,236,154); }", 34);
                                        document.styleSheets[0].deleteRule(36);
                                        document.styleSheets[0].insertRule("a:link { color: rgb(255,255,0); text-decoration: none; }", 36);
                                        document.styleSheets[0].deleteRule(37);
                                        document.styleSheets[0].insertRule("a:visited { color: rgb(255,255,0); text-decoration: none; }", 37);
                                        document.styleSheets[0].deleteRule(40);
                                        document.styleSheets[0].insertRule("#searchDescription { font-size: 16pt; font-weight: lighter; margin-right: 5px; color: rgb(204,204,204); }", 40);
                                        document.styleSheets[0].deleteRule(45);
                                        document.styleSheets[0].insertRule("td.hab { font-size: 10pt; font-weight: bold; color: rgb(34,0,51); height: 25px; vertical-align: middle; }", 45);
                                        document.styleSheets[0].deleteRule(46);
                                        document.styleSheets[0].insertRule(".uhm { color: rgb(204,238,255); font-size: 12pt; font-weight: bold; text-indent: 4px; }", 46);
                                        document.styleSheets[0].deleteRule(51);
                                        document.styleSheets[0].insertRule(".phm, .revokeTitel, .urTitel { font-size: 14pt; font-weight: bold; color: rgb(204,204,204); text-indent: 0px; }", 51);
                                        document.styleSheets[0].deleteRule(52);
                                        document.styleSheets[0].insertRule("td.php { font-size: 10pt; font-weight: bold; background-color: rgb(29,40,11); min-width: 25pt; }", 52);
                                        document.styleSheets[0].deleteRule(53);
                                        document.styleSheets[0].insertRule(".phs { font-size: 10pt; font-weight: bold; color: rgb(255,233,179); text-indent: 4px; }", 53);
                                        document.styleSheets[0].deleteRule(54);
                                        document.styleSheets[0].insertRule(".phq { font-size: 10pt; font-weight: bold; background-color: rgb(51,37,0); text-indent: 4px; }", 54);
                                        document.styleSheets[0].deleteRule(55);
                                        document.styleSheets[0].insertRule("table.noborder { border: 0px none rgb(255,246,230); border-collapse: collapse; }", 55);
                                        document.styleSheets[0].deleteRule(58);
                                        document.styleSheets[0].insertRule("li.inside::before { content: \"++\"; padding-right: 5px; font-weight: bold; color: rgb(244,165,164); }", 58);
                                        document.styleSheets[0].deleteRule(59);
                                        document.styleSheets[0].insertRule(".plusplus { font-size: 10pt; font-weight: bold; color: rgb(244,165,164); text-decoration: none; }", 59);
                                        document.styleSheets[0].deleteRule(60);
                                        document.styleSheets[0].insertRule(".dollar { color: rgb(249,159,235); }", 60);
                                        document.styleSheets[0].insertRule(".percent { color: rgb(246,198,187); }", 61);
                                        document.styleSheets[0].deleteRule(62);
                                        document.styleSheets[0].insertRule("#searchField { color: rgb(255,255,255); background-color: rgb(0,0,0); }", 40);
                                }
                        </script>

                        <script type="text/javascript">//<![CDATA[
                                //load on start
                                function redesign() {
                                        //var caButton = document.getElementById('caButton');
                                        //caButton.click()
                                        toggleall(document, '+')
                                }

                                //  Toggle single element
                                function toggle(element)
                                {
                                  var item = element.firstChild;
                                  setElement(element, (item.data == "+") ? "-" : "+", 1);
                                }

                                function search() {
                                        var searchText = document.getElementById('searchField').value;
                                        if(searchText) {
                                                searchText = searchText.toUpperCase();
                                                var module = document.getElementById(searchText);
                                                var isTd = false;
                                                //when searching for a phase, which is a td tag
                                                if(module.tagName == 'TD') {
                                                        var parent = module.parentNode;
                                                        while(parent.className.indexOf("module") == -1) {
                                                                parent = parent.parentNode;
                                                        }
                                                        module = parent;
                                                        isTd = true;
                                                }
                                                try {
                                                        openItem(module);
                                                }
                                                catch(e) {
                                                        console.log(e);
                                                }
                                                finally {
                                                        if(isTd == true) {
                                                                var button = module.getElementsByClassName("blue plus");
                                                                toggle(button[0]);
                                                        }
                                                        window.location.href = window.location.href.substring(0 ,window.location.href.lastIndexOf(".xml") + 4 ) + "#Link-" + searchText;;
                                                }
                                        }
                                }

                                //open the element on which the link refers to
                                //if hidden
                                function openItem(ident) {
                                        if (ident.length) ident = ident[0];
                                        ident.style.display = 'block';
                                        if(!ident.parentNode) {
                                                ident.style.display = 'block';
                                        }
                                        //if the element has a parent(s)
                                        //open them too
                                        else {
                                                var parent = ident;
                                                while(parent.parentNode) {
                                                        var searchSpan = parent.firstElementChild;
                                                        //search for every span tag which gets opened
                                                        //and change it to '-'
                                                        while(searchSpan) {
                                                                if(searchSpan.innerHTML == "+") {
                                                                        searchSpan.className = "red minus";
                                                                        searchSpan.innerHTML = "-";
                                                                        searchSpan = null;
                                                                }
                                                                else {
                                                                        searchSpan = searchSpan.firstElementChild;
                                                                }
                                                        }
                                                        parent = parent.parentNode;
                                                        if(parent.style && (parent.style.display === 'none' || parent.style.display === '')) {
                                                                parent.style.display = 'block';
                                                        }
                                                }
                                        }
                                        return true;
                                }

                                function toggleall(element, type)
                                {
                                    if(element.id != 'searchField' && element.id != 'searchButton') {
                                            if(element.tagName == 'BUTTON' && element.attributes["class"].nodeValue != 'noToggle blue') {
                                                setElement(element, type, 0);
                                            }
                                                var sub;
                                                for(sub = element.firstChild ; sub ; sub = sub.nextSibling) {
                                                        if(element.id == 'searchField' || element.id == 'searchButton') {
                                                                continue;
                                                        }
                                                        else {
                                                                toggleall(sub, type);
                                                        }
                                                }
                                        }
                                }

                                function toggleModule(element, type) {
                                        var roadmap = element.parentNode.parentNode.parentNode;
                                        var names = roadmap.getElementsByTagName("button");
                                        for(var i=0;i<names.length; i++) {
                                                if(names[i].innerHTML == "+") {
                                                        //names[i].click();
                                                        toggle(names[i]);
                                                }
                                        }
                                        //console.log(roadmap)
                                }

                                function backwards()
                                {
                                    window.history.back();
                                }

                                //  'element' should point to the "SPAN" node with class "etag"
                                function setElement(element, type, dosub)
                                {
                                  var sub = element.firstChild;
                                  if(!sub) {
                                        return;
                                  }

                                  if(!type) {
                                        type = sub.data;
                                  }

                                  var newdisp = (type == "+") ? "none" : "";
                                  if(element.innerHTML != 'Close All' && element.innerHTML != 'Open All' && element.innerHTML != 'Open Roadmap') {
                                        sub.data = type;
                                        if(element.innerHTML == "-") {
                                                element.className = "red minus";
                                        }
                                        else if(element.innerHTML == "+") {
                                                element.className = "blue plus";
                                        }
                                  }

                                  //  Go to "tr" element and change display of all following "tr" until
                                  //   element with same class is found (== next header)
                                  element = element.parentNode; //  go to "TD" element
                                  var myclass = element.attributes["class"];
                                  if(!myclass) {
                                        return;
                                  }

                                  myclass = myclass.nodeValue;
                                  element = element.parentNode; //  go to "TR" element

                                  var next;
                                  //next sibling is next element on the same level
                                  for(next = element.nextSibling ; next ; next = next.nextSibling) {
                                    sub = next.firstChild;
                                    if(!sub) {
                                     continue; //  skip text nodes
                                    }

                                    for( ; sub ; sub = sub.nextSibling) {
                                      if(sub.tagName == "DIV" || sub.tagName == "TD")
                                        break;
                                    }

                                    if(!sub || sub.attributes["class"].nodeValue == myclass) {
                                      break;
                                    }

                                    next.style.display = newdisp;
                                  }

                                  //  Fix all subelements on reopen
                                  if(dosub != 0 && newdisp == "") {
                                    for(next = element.nextSibling ; next ; next = next.nextSibling)
                                      toggleall(next, "");
                                  }
                                }
                //]]></script>
                </head>
        </xsl:template>

        <!-- ******************************************************************* -->
        <xsl:template name="gen-html-title">
                <xsl:choose>
                        <xsl:when test="@note != ''">
                                <div class="head">
                                        <center>
                                                <xsl:value-of select="@note" />
                                        </center>
                                </div>
                        </xsl:when>
                        <xsl:otherwise>
                                <xsl:if test="@release != ''">
                                        <div class="head">
                                                Phase List for SAPup (Release '<xsl:value-of select="@release" />'<xsl:if test="@version">, Version'<xsl:value-of select="@version" />'</xsl:if>):
                                        </div>
                                        <div class="searchElements">
                                                <button id="searchButton" class="yellow" onclick="search()">Search</button>
                                                <input id="searchField" type="text" placeholder="Module..." onfocus="this.placeholder = ''" onblur="this.placeholder ='Search...'"/>
                                                <div id="searchDescription">Search Modules:</div>
                                        </div>

                                </xsl:if>
                                <table cellspacing="0" cellpadding="3" class="noborder">
                                        <colgroup span="2" />
                                        <tr>
                                                <div class="fixSize">
                                                        <td>
                                                                <button class="blue" onclick="toggleall(document, '-')">Open All</button>

                                                        </td>
                                                        <td>
                                                                <button id="caButton" class="red" onclick="toggleall(document, '+')">Close All</button>
                                                        </td>
                                                </div>
<!--                                            <td class="rightTopElements"> -->
<!--                                                    <input id="searchField" type="text" placeholder="Search..." /> -->
<!--                                            </td> -->
<!--                                            <td class="rightTopElements"> -->
<!--                                                    <button id="searchButton" class="yellow" onclick="search()">Search</button> -->
<!--                                            </td> -->
                                        </tr>
                                </table>
                                <br />
                        </xsl:otherwise>
                </xsl:choose>
        </xsl:template>

        <!-- ******************************************************************* -->
        <xsl:template name="gen-unitcntrl">
                <xsl:param name="execntrl" />

                <xsl:if test="not(@name = $exclude-roadmap)">
                        <div class="roadmap" id="{@name}">
                                <div class="roadmapName" id="{$exclude-roadmap}">
                                        <div class="phm">
                                                <xsl:call-template name="mkjstag" />
                                                <xsl:call-template name="NBSPC" />
                                                <a name="Roadmap-{@name}" />Roadmap <xsl:value-of select="@name" />
                                                <xsl:call-template name="cmButton" />
                                        </div>
                                </div>
                        <!-- Loop over road map steps -->

                                <xsl:variable name="anzahl">
                                        <xsl:variable name="anzahl_prep" select="count(./unit[@type='prepare'])" />
                                        <xsl:variable name="anzahl_upgr" select="count(./unit[@type='upgrade'])" />

                                        <xsl:choose>
                                                <xsl:when test="$anzahl_prep > $anzahl_upgr">
                                                        <xsl:value-of select="$anzahl_prep" />
                                                </xsl:when>
                                                <xsl:otherwise>
                                                        <xsl:value-of select="$anzahl_upgr" />
                                                </xsl:otherwise>
                                        </xsl:choose>
                                </xsl:variable>

                                <xsl:variable name="minwidth" select="floor(60 div $anzahl)" />

                                <div class="roadmapSteps">
                                        <xsl:for-each select="unit[@type='prepare']">
                                                <xsl:call-template name="gen-unit">
                                                        <xsl:with-param name="execntrl" select="$execntrl" />
                                                        <xsl:with-param name="minwidth" select="$minwidth" />
                                                </xsl:call-template>
                                        </xsl:for-each>

                                        <xsl:for-each select="unit[@type='upgrade']">
                                                <xsl:call-template name="gen-unit">
                                                        <xsl:with-param name="execntrl" select="$execntrl" />
                                                        <xsl:with-param name="minwidth" select="$minwidth" />
                                                </xsl:call-template>
                                        </xsl:for-each>
                                </div>
                        </div>
                </xsl:if>

        </xsl:template>

        <!-- ******************************************************************* -->
        <xsl:template name="gen-unit">
                <xsl:param name="execntrl" />
                <xsl:param name="minwidth" />

                <xsl:variable name="type">
                        <xsl:call-template name="initcap">
                                <xsl:with-param name="text" select="@type" />
                        </xsl:call-template>
                </xsl:variable>

                <div class="roadmapStep">
                        <xsl:attribute name="style">min-width:<xsl:value-of
                                select="$minwidth" />%</xsl:attribute>

                        <div class="titelStep">
                                <div class="uhm" colspan="2">
                                        <xsl:call-template name="mkjstag" />
                                        <xsl:call-template name="NBSPC" />

                                        <xsl:value-of select="$type" />
                                        Roadmap Step '<xsl:value-of select="@name" />'
                                        <small>(<xsl:value-of select="@id" />)</small>:
                                </div>
                        </div>

                        <div class="subRoadmapStep">
                                <div class="rsContent">
                                        <xsl:for-each select=".//unitmodule">
                                                <xsl:variable name="modname" select="@name" />
                                                <xsl:variable name="modopts" select="options" />
                                                <xsl:variable name="moddescript"
                                                        select="/.//modules/module[@name=$modname]/description" />
                                                <xsl:variable name="RoadmapStep" select="ancestor::unit/@id" />
                                                <xsl:call-template name="gen-modules">
                                                        <xsl:with-param name="execntrl" select="$execntrl" />
                                                        <xsl:with-param name="moduleName" select="$modname" />
                                                </xsl:call-template>
                                        </xsl:for-each>
                                </div>
                        </div>
                </div>
        </xsl:template>

        <!-- ******************************************************************* -->
        <xsl:template name="gen-modules">
                <xsl:param name="execntrl" />
                <xsl:param name="moduleName" />

                <xsl:if test="name(../../../..) = 'ExecutionControl'">
                        <xsl:for-each select="../../../..//modules/*">
                                <xsl:sort select="translate(substring(@type,1,1),'rpu','zab')" />

                                <xsl:variable name="type">
                                        <xsl:call-template name="initcap">
                                                <xsl:with-param name="text" select="@type" />
                                        </xsl:call-template>
                                </xsl:variable>

                                <!-- <modules> can contain <module> and - recursively - <modules> -->
                                <xsl:if test="name() = 'module'">
                                        <xsl:if test="@name = $moduleName">
                                                <xsl:call-template name="gen-module">
                                                        <xsl:with-param name="type" select="$type" />
                                                        <xsl:with-param name="execntrl" select="." />
                                                        <!-- xsl:with-param name="execntrl" select="$execntrl"/ -->
                                                </xsl:call-template>
                                        </xsl:if>
                                </xsl:if>
                        </xsl:for-each>
                </xsl:if>
        </xsl:template>

        <!-- ******************************************************************* -->
        <xsl:template name="gen-module">
                <xsl:param name="type" />
                <xsl:param name="execntrl" />

                <a name="Link-{@name}"/>
                <xsl:variable name="tableClassName">
                        <xsl:choose>
                                <xsl:when test="name() = 'module'">rsTable module</xsl:when>
                                <xsl:otherwise>rsTable sub</xsl:otherwise>
                        </xsl:choose>
                </xsl:variable>
                <div class="{$tableClassName}">
                        <div id="{@name}">
                                <table rules="all" cellpadding="5" cellspacing="0" width="100%">
                                        <xsl:call-template name="colgroup-module" />

                                        <xsl:choose>
                                                <xsl:when test="name() = 'submodule'">
                                                        <tr>
                                                                <td colspan="6" class="phs">
                                                                        <xsl:call-template name="mkjstagTable" />
                                                                        <xsl:call-template name="NBSPC" />
                                                                        Submodule (inline<xsl:choose><xsl:when test="@execparallel = 'true' or @execparallel = 'yes'">, executed in parallel)</xsl:when><xsl:otherwise>)</xsl:otherwise></xsl:choose>
                                                                </td>
                                                        </tr>
                                                        <xsl:if test="./phaselist/phase or ./phaselist/phaseref">
                                                                <xsl:call-template name="phase-header">
                                                                        <xsl:with-param name="type" select="$type" />
                                                                        <xsl:with-param name="class">
                                                                                phq
                                                                        </xsl:with-param>
                                                                </xsl:call-template>
                                                        </xsl:if>
                                                </xsl:when> <!-- submodule -->

                                                <xsl:when test="name() = 'submoduleref'">

                                                        <xsl:variable name="submoddef-has-phases">
                                                                <xsl:value-of select="0" />
                                                                <xsl:variable name="refname" select="@refname" />
                                                                <xsl:for-each select="/.//submoduledefs/submoduledef[@name=$refname]">
                                                                        <xsl:for-each select="phaselist/*">
                                                                                <xsl:if test="name()='phase' or name()='phaseref'" >
                                                                                        <xsl:value-of select="1" />
                                                                                </xsl:if>
                                                                        </xsl:for-each>
                                                                </xsl:for-each>
                                                                <!-- fix because of the submoduleref -->
                                                                <xsl:for-each select="//submoduleref[@name=$refname]">
                                                                        <xsl:for-each select="phaselist/*">
                                                                                <xsl:if test="name()='phase' or name()='phaseref'" >
                                                                                        <xsl:value-of select="2" />
                                                                                </xsl:if>
                                                                        </xsl:for-each>
                                                                </xsl:for-each>
                                                        </xsl:variable>

                                                        <tr>
                                                                <td colspan="6" class="phs">
                                                                        <xsl:call-template name="mkjstagTable" />
                                                                        <xsl:call-template name="NBSPC" />

                                                                        <xsl:variable name="name_or_ref">
                                                                                <xsl:choose>
                                                                                        <xsl:when test="@name != ''">
                                                                                                <xsl:value-of select="@name" />
                                                                                        </xsl:when>
                                                                                        <xsl:otherwise>
                                                                                                <xsl:value-of select="@refname" />
                                                                                        </xsl:otherwise>
                                                                                </xsl:choose>
                                                                        </xsl:variable>
                                                                        Submodule
                                                                        <xsl:choose>
                                                                                <xsl:when test="not($name_or_ref = @refname)">
                                                                                        <!-- list both names because they are different -->
                                                                                        <xsl:value-of select="$name_or_ref" />
                                                                                        <xsl:if test="not(starts-with(@refname,'@') and @name != '' and $name_or_ref != @refname)">
                                                                                                <b>&#160;Ref&#160;&#8631;&#160;</b>
                                                                                                <i>
                                                                                                        <xsl:value-of select="@refname" />
                                                                                                </i>
                                                                                        </xsl:if>
                                                                                </xsl:when>
                                                                                <xsl:when test="contains($submoddef-has-phases, '2')">
                                                                                        <i>
                                                                                                <xsl:value-of select="@refname" />
                                                                                        </i>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                        <!-- list only one name because they are the same -->
                                                                                        <b>&#160;Ref&#160;&#8631;&#160;</b>
                                                                                        <i>
                                                                                                <xsl:value-of select="@refname" />
                                                                                        </i>
                                                                                </xsl:otherwise>
                                                                        </xsl:choose>
<!--                                                                    <xsl:if test="not($name_or_ref = @refname)"> -->
<!--                                                                            <b>&#160;Ref&#160;&#8631;&#160;</b> -->
<!--                                                                            <i> -->
<!--                                                                                    <xsl:value-of select="@refname" /> -->
<!--                                                                            </i> -->
<!--                                                                    </xsl:if> -->

                                                                        <xsl:if test="@execparallel = 'true' or @execparallel = 'yes'">
                                                                                (executed in parallel)
                                                                        </xsl:if>
                                                                </td>
                                                        </tr>

                                                        <!-- Does the submoddef have definitions? -->
                                                        <xsl:if test="./defs">
                                                                <tr>
                                                                        <td class="phq">Definition</td>
                                                                        <td class="phq">Value</td>
                                                                        <td colspan="4" class="phq">
                                                                                <xsl:call-template name="NBSPC" />
                                                                        </td>
                                                                </tr>
                                                                <xsl:for-each select='./defs/*'>
                                                                        <tr>
                                                                                <td class="bP">
                                                                                        <xsl:value-of select="@name" />
                                                                                </td>
                                                                                <td class="bP">
                                                                                        &quot;<xsl:value-of select="." />&quot;
                                                                                </td>
                                                                                <td colspan="4">
                                                                                        <xsl:call-template name="NBSPC" />
                                                                                </td>
                                                                        </tr>
                                                                </xsl:for-each>
                                                        </xsl:if>

                                                        <xsl:if test="not($submoddef-has-phases = 0)">
                                                                <xsl:call-template name="phase-header">
                                                                        <xsl:with-param name="type" select="$type" />
                                                                        <xsl:with-param name="class">
                                                                                phq
                                                                        </xsl:with-param>
                                                                </xsl:call-template>
                                                        </xsl:if>

                                                        <xsl:call-template name="find-submoddef">
                                                                <xsl:with-param name="submoddef" select="@refname" />
                                                                <xsl:with-param name="type" select="$type" />
                                                        </xsl:call-template>

                                                </xsl:when> <!-- submoduleref -->

                                                <xsl:when test="name() = 'module'">
                                                        <tr>
                                                                <td colspan="3" class="phm">
                                                                        <xsl:choose>
                                                                                <xsl:when test="./phaselist/*">
                                                                                        <xsl:call-template name="mkjstagTable" />
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                        <xsl:call-template name="mkjstag2" />
                                                                                </xsl:otherwise>
                                                                        </xsl:choose>
                                                                        <xsl:call-template name="NBSPC" />
                                                                        <xsl:if test="$type != ''">
                                                                                <xsl:value-of select="$type" />
                                                                                <xsl:call-template name="NBSPC" />
                                                                        </xsl:if>Module <xsl:value-of select="@name" />
                                                                        <xsl:if test="./description">
                                                                                <xsl:call-template name="NBSPC" />
                                                                                <i>
                                                                                        <xsl:value-of select="description" />
                                                                                </i>
                                                                        </xsl:if>
                                                                        <xsl:if test="$type = 'Prepare'">
                                                                                <xsl:choose>
                                                                                        <xsl:when test="@mandatory = 'yes' and @checkmode = 'yes'">
                                                                                                <xsl:call-template name="NBSPC" />
                                                                                                (Mandatory, Check Mode)
                                                                                        </xsl:when>
                                                                                        <xsl:when test="@checkmode = 'yes'">
                                                                                                <xsl:call-template name="NBSPC" />
                                                                                                (Check Mode)
                                                                                        </xsl:when>
                                                                                        <xsl:when test="@mandatory = 'yes'">
                                                                                                <xsl:call-template name="NBSPC" />
                                                                                                (Mandatory)
                                                                                        </xsl:when>
                                                                                </xsl:choose>
                                                                        </xsl:if>
                                                                </td>

                                                                <td class="phm">
                                                                        <xsl:choose>
                                                                                <xsl:when test="./revokemodule">
                                                                                        <xsl:variable name="revokeModName" select="./revokemodule" />
                                                                                        Revoke:
                                                                                        <a href="#Module-{$revokeModName}" onclick="openItem({$revokeModName})">
                                                                                                <xsl:value-of select="./revokemodule" />
                                                                                        </a>
                                                                                </xsl:when>
                                                                                <xsl:when test="@type = 'revoke'">
                                                                                        <button class="purple" onclick="backwards()">
                                                                                                <b>&#8656;</b>
                                                                                        </button>
                                                                                </xsl:when>
                                                                        </xsl:choose>
                                                                </td>

                                                                <td colspan="2" class="phm">
                                                                        <xsl:if
                                                                                test="./postevent and substring-before(./postevent,'(') = 'MODULE_INIT' and @type = 'revoke'"> <!-- and not(@type = 'revoke') -->
                                                                                <xsl:call-template name="next-module">
                                                                                        <xsl:with-param name="postevent" select="./postevent" />
                                                                                </xsl:call-template>
                                                                        </xsl:if>
                                                                </td>
                                                        </tr>
                                                        <xsl:if test="./phaselist/phase or ./phaselist/phaseref">
                                                                <xsl:call-template name="phase-header">
                                                                        <xsl:with-param name="type" select="$type" />
                                                                        <xsl:with-param name="class">
                                                                                php
                                                                        </xsl:with-param>
                                                                </xsl:call-template>
                                                        </xsl:if>
                                                </xsl:when> <!-- module -->

                                                <xsl:otherwise>
                                                        <div>
                                                                New Tag found:
                                                                <xsl:value-of select="name()" />
                                                        </div>
                                                </xsl:otherwise>
                                        </xsl:choose>

                                        <xsl:for-each select="phaselist/*">
                                                <xsl:call-template name="gen-phase">
                                                        <xsl:with-param name="execntrl" select="." />
                                                        <xsl:with-param name="type" select="$type" />
                                                </xsl:call-template>
                                        </xsl:for-each>
                                        <tr class="placeholder">
                                                <td class="placeholder"><xsl:call-template name="NBSPC" /></td>
                                                <td class="placeholder"><xsl:call-template name="NBSPC" /></td>
                                                <td class="placeholder"><xsl:call-template name="NBSPC" /></td>
                                                <td class="placeholder"><xsl:call-template name="NBSPC" /></td>
                                                <td class="placeholder"><xsl:call-template name="NBSPC" /></td>
                                                <td class="placeholder"><xsl:call-template name="NBSPC" /></td>
                                        </tr>
                                </table>
                        </div>
                </div>

                <!-- xsl:if test="name() = 'module' and ./phaselist">
                        <a href="#top">
                                <xsl:call-template name="NBSPC" />
                                <xsl:call-template name="NBSPC" />
                                <xsl:call-template name="NBSPC" />
                                <b>&#8657;</b>
                        </a--> <!-- back to top -->
                <!-- /xsl:if-->
        </xsl:template>

        <!-- ******************************************************************* -->
        <xsl:template name="gen-phase">
                <xsl:param name="execntrl" />
                <xsl:param name="type" />
                <xsl:choose>
                        <!-- *********************************************************************** -->
                        <xsl:when test="name() = 'submodule' or name() = 'submoduleref'">
                                <tr>
                                        <td colspan="6" class="phsub">
                                                <table rules="all" border="0" cellpadding="5" cellspacing="0"
                                                        width="100%">
                                                        <xsl:call-template name="colgroup-module" />

                                                        <td colspan="6">
                                                                <xsl:for-each select=".">
                                                                        <xsl:call-template name="gen-module">
                                                                                <xsl:with-param name="type" select="$type" />
                                                                                <xsl:with-param name="execntrl" select="." />
                                                                        </xsl:call-template>
                                                                </xsl:for-each>
                                                        </td>
                                                </table>
                                        </td>
                                </tr>
                        </xsl:when>

                        <!-- *********************************************************************** -->
                        <xsl:when test="name() = 'phaseref'">
                                <tr>
                                        <td class="bP">
                                                <xsl:call-template name="find-phasename-for-ref">
                                                        <xsl:with-param name="refname" select="@refname" />
                                                </xsl:call-template>
                                        </td>
                                        <td class="bP arg" colspan="5">
                                                <xsl:call-template name="phaseref-attribs" />
                                        </td>
                                </tr>
                        </xsl:when>

                        <!-- *********************************************************************** -->
                        <xsl:otherwise>
                                <tr>
                                        <td id="{@name}" class="bP">
                                                <a name="Link-{@name}"/>
                                                <xsl:value-of select="@name" />
                                        </td>
                                        <td class="bP arg">
                                                <xsl:for-each select="./args/*">
                                                        <xsl:choose>
                                                                <xsl:when test="*"> <!-- Has children, argstring is relevant -->
                                                                        <!-- NB: each argstring may contain a ;-sep string Hence: Concatenate
                                                                                the argstring values to a long ;-sep string -->
                                                                        <xsl:variable name="stringlist">
                                                                                <xsl:for-each select="./argstring">
                                                                                        <xsl:value-of select="." />
                                                                                        <xsl:if test="position() != last()">
                                                                                                <xsl:value-of select="$delim" />
                                                                                        </xsl:if>
                                                                                </xsl:for-each>
                                                                        </xsl:variable>

                                                                        <!-- The long ;-sep string is now converted into a <ul/> -->
                                                                        <xsl:call-template name="sep-string-to-ulist">
                                                                                <xsl:with-param name="sep-string" select="$stringlist" />
                                                                        </xsl:call-template>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                        <xsl:choose>
                                                                                <xsl:when test="contains(.,$delim)">
                                                                                        <!-- The long ;-sep string is now converted into a <ul/> -->
                                                                                        <xsl:call-template name="sep-string-to-ulist">
                                                                                                <xsl:with-param name="sep-string" select="." />
                                                                                        </xsl:call-template>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                        <xsl:call-template name="colorString">
                                                                                                <xsl:with-param name="string" select="." />
                                                                                        </xsl:call-template>
                                                                                </xsl:otherwise>
                                                                        </xsl:choose>
                                                                </xsl:otherwise>
                                                        </xsl:choose>
                                                </xsl:for-each>
                                        </td>
                                        <td class="b">
                                                <xsl:value-of select="action" />
                                                <xsl:call-template name="NBSPC" />
                                        </td>
                                        <td class="bL">
                                                <xsl:value-of select="@logfile" />
                                                <xsl:call-template name="NBSPC" />
                                        </td>
                                        <td class="bL">
                                                <xsl:value-of select="@elgfile" />
                                                <xsl:call-template name="NBSPC" />
                                        </td>
                                        <td class="b">
                                                <xsl:value-of select="usage" />
                                                <xsl:call-template name="NBSPC" />
                                        </td>
                                </tr>
                        </xsl:otherwise>
                </xsl:choose>
        </xsl:template>

        <!-- ******************************************************************* -->

        <xsl:template name="assignUnreferencedModules">
                <!-- only occurs only once -->
                <div class="unreferenced">
                        <div class="urTitel">
                                <div class="subUrTitel">
                                        <xsl:call-template name="mkjstag" />
                                        <xsl:call-template name="NBSPC" />Unreferenced Modules
                                        <xsl:call-template name="cmButton"/>
                                </div>
                        </div>
                        <xsl:for-each select="modules/module[not(@type = $excluded-module-type)]">
                                <xsl:variable name="modname" select="@name"/>
                                        <xsl:variable name="referenced">
                                    <xsl:value-of select="0"/>
                                    <xsl:for-each select="/.//unitmodule[@name = $modname]">
                                        <xsl:if test="not(ancestor::UnitDefinition/@name = $exclude-roadmap)">
                                                <xsl:value-of select="1"/>
                                        </xsl:if>
                                         </xsl:for-each>
                                </xsl:variable>
                        <xsl:if test="$referenced=0">
                                <xsl:variable name="type">
                                                <xsl:call-template name="initcap">
                                                        <xsl:with-param name="text" select="@type" />
                                                </xsl:call-template>
                                        </xsl:variable>
                                        <div class="subRevoke">
                                                <div class="revoke" id="Module-{@name}">
                                                <xsl:call-template name="gen-module">
                                                                <xsl:with-param name="type" select="$type" />
                                                                <xsl:with-param name="execntrl" select="." />
                                                        </xsl:call-template>
                                                </div>
                                        </div>
                                </xsl:if>
                        </xsl:for-each>
                </div>
        </xsl:template>

        <!-- ******************************************************************* -->

        <xsl:template name="assignRevokeModules">
                <div class="revokes">
                        <div class="revokeTitel">
                                <div class="subRevokeTitel">
                                        <xsl:call-template name="mkjstag" />
                                        <xsl:call-template name="NBSPC" />Revokes
                                        <xsl:call-template name="cmButton"/>
                                </div>
                        </div>
                        <xsl:for-each select="./*">
                                <xsl:call-template name="findRevokeModules" />
                        </xsl:for-each>
                </div>
        </xsl:template>

        <!-- ******************************************************************* -->

        <xsl:template name="findRevokeModules">
                <xsl:for-each select="./*">

                        <xsl:if test="name()='module' and @type='revoke'">
                                <xsl:variable name="type">
                                        <xsl:call-template name="initcap">
                                                <xsl:with-param name="text" select="@type" />
                                        </xsl:call-template>
                                </xsl:variable>

                                <div class="subRevoke">
                                        <div class="revoke" id="Module-{@name}">
                                                <xsl:call-template name="gen-module">
                                                        <xsl:with-param name="type" select="$type" />
                                                        <xsl:with-param name="execntrl" select="." />
                                                </xsl:call-template>
                                        </div>
                                </div>
                        </xsl:if>
                        <xsl:if test="name()='modules'">
                                <!-- recursive call to go through all modules tags -->
                                <xsl:call-template name="findRevokeModules" />
                        </xsl:if>
                </xsl:for-each>
        </xsl:template>

        <!-- ******************************************************************* -->
        <xsl:template name="mkjstag">
                <!-- span class="etag" onclick="toggle(this)">-</span-->
                <button class="red minus" onclick="toggle(this)">-</button>
        </xsl:template>
        <xsl:template name="cmButton">
                <button class="blue openModuleComplete" onclick="toggleModule(this, '-')">Open Roadmap</button>
        </xsl:template>
        <xsl:template name="mkjstag2">
                <!-- span class="etag2">&#160;</span-->
                <button class="noToggle blue">&#160;</button>
        </xsl:template>
        <xsl:template name="mkjstagTable">
                <!-- span class="etagTable" onclick="toggle(this)">-</span-->
                <button class="red minus" onclick="toggle(this)">-</button>
        </xsl:template>


        <!-- ******************************************************************* -->
        <xsl:template name="NBSPC">
                <xsl:text disable-output-escaping="yes">&#160;</xsl:text>
        </xsl:template>


        <!-- ******************************************************************* -->
        <xsl:template name="find-submoddef">
                <xsl:param name="submoddef" />
                <xsl:param name="type" />
                <xsl:for-each select="/.//submoduledefs/submoduledef">
                        <xsl:if test="@name = $submoddef">
                                <xsl:for-each select="phaselist/*">
                                        <xsl:call-template name="gen-phase">
                                                <xsl:with-param name="execntrl" select="." />
                                                <xsl:with-param name="type" select="$type" />
                                        </xsl:call-template>
                                </xsl:for-each>
                        </xsl:if>
                </xsl:for-each>
        </xsl:template>

        <!-- ******************************************************************* -->
        <xsl:template name="phase-header">
                <xsl:param name="type" />
                <xsl:param name="class" />
                <tr>
                        <td>
                                <xsl:attribute name="class"><xsl:value-of select="$class" /></xsl:attribute>
                                Phase
                        </td>
                        <td>
                                <xsl:attribute name="class"><xsl:value-of select="$class" /></xsl:attribute>
                                Arguments
                        </td>
                        <td>
                                <xsl:attribute name="class"><xsl:value-of select="$class" /></xsl:attribute>
                                <xsl:value-of select="$type" />
                                <xsl:call-template name="NBSPC" />
                                Actions
                        </td>
                        <td>
                                <xsl:attribute name="class"><xsl:value-of select="$class" /></xsl:attribute>
                                Log File
                        </td>
                        <td>
                                <xsl:attribute name="class"><xsl:value-of select="$class" /></xsl:attribute>
                                Error Summary File
                        </td>
                        <td>
                                <xsl:attribute name="class"><xsl:value-of select="$class" /></xsl:attribute>
                                User Actions
                        </td>
                </tr>
        </xsl:template>

        <!-- ******************************************************************* -->
        <xsl:template name="phaseref-attribs">
                <xsl:for-each select="@*">
                        <xsl:if test="name() != 'refname'">
                                <xsl:value-of select="name()" />
                                = <xsl:call-template name="colorString">
                                        <xsl:with-param name="string" select="."/>
                                </xsl:call-template>
                        </xsl:if>
                </xsl:for-each>
        </xsl:template>

        <!-- ******************************************************************* -->
        <xsl:template name="find-phasename-for-ref">
                <xsl:param name="refname" />
                <xsl:for-each select="/.//phasedef[@refname = $refname]">
                        <b>Ref&#160;&#8631;&#160;</b>
                        <xsl:value-of select="@refname" />
                        <br />
                        <xsl:choose>
                                <xsl:when test="phase/@name != ''">
                                        <b>Phase:&#160;</b>
                                        <nobr>
                                                <xsl:value-of select="phase/@name" />
                                        </nobr>
                                </xsl:when>
                                <xsl:when test="phaseref/@refname != ''">
                                        <xsl:call-template name="find-phasename-for-ref">
                                                <xsl:with-param name="refname" select="phaseref/@refname" />
                                        </xsl:call-template>
                                </xsl:when>
                                <xsl:otherwise>
                                        OTHERREFDEF
                                </xsl:otherwise>
                        </xsl:choose>
                </xsl:for-each>
        </xsl:template>

        <!-- template for coloring parts of the string -->
        <xsl:template name="colorString">
                <xsl:param name="string" />
                <xsl:choose>
                        <xsl:when test="contains($string,'%(')">
                                <xsl:variable name="ncFirst" select="substring-before($string,'%(')"/>
                                <xsl:variable name="iStart" select="string-length(substring-before($string, '%('))+1"/>
                                <xsl:variable name="leftover" select="substring($string, $iStart)"/>
                                <xsl:variable name="iEnd" select="string-length(substring-before($leftover, ')'))+1"/>
                                <xsl:variable name="cPart" select="substring($string, $iStart, $iEnd)"/>
                                <xsl:variable name="ncLast" select="substring-after($leftover,')')"/>

                                <xsl:text>&quot;</xsl:text><xsl:value-of select="$ncFirst"/><span class="percent"><xsl:value-of select="$cPart"/></span><xsl:value-of select="$ncLast"/><xsl:text>&quot;</xsl:text>
                                <br />
                        </xsl:when>
                        <xsl:otherwise>
                                <xsl:choose>
                                        <xsl:when test="contains($string,'$(')">
                                                <xsl:variable name="ncFirst" select="substring-before($string,'$(')"/>
                                                <xsl:variable name="iStart" select="string-length(substring-before($string, '$('))+1"/>
                                                <xsl:variable name="leftover" select="substring($string, $iStart)"/>
                                                <xsl:variable name="iEnd" select="string-length(substring-before($leftover, ')'))+1"/>
                                                <xsl:variable name="cPart" select="substring($string, $iStart, $iEnd)"/>
                                                <xsl:variable name="ncLast" select="substring-after($leftover,')')"/>

                                                <xsl:text>&quot;</xsl:text><xsl:value-of select="$ncFirst"/><span class="dollar"><xsl:value-of select="$cPart"/></span><xsl:value-of select="$ncLast"/><xsl:text>&quot;</xsl:text>
                                                <br />
                                        </xsl:when>
                                        <xsl:otherwise>
                                                <xsl:text>&quot;</xsl:text><xsl:value-of select="$string" /><xsl:text>&quot;</xsl:text>
                                                <br />
                                        </xsl:otherwise>
                                </xsl:choose>
                        </xsl:otherwise>
                </xsl:choose>
        </xsl:template>

        <!-- ******************************************************** -->

        <xsl:template name="coloredList">
                <xsl:param name="string"/>
                <xsl:choose>
                        <xsl:when test="contains($string,'%(')">
                                <xsl:variable name="ncFirst" select="substring-before($string,'%(')"/>
                                <xsl:variable name="iStart" select="string-length(substring-before($string, '%('))+1"/>
                                <xsl:variable name="leftover" select="substring($string, $iStart)"/>
                                <xsl:variable name="iEnd" select="string-length(substring-before($leftover, ')'))+1"/>
                                <xsl:variable name="cPart" select="substring($string, $iStart, $iEnd)"/>
                                <xsl:variable name="ncLast" select="substring-after($leftover,')')"/>
                                <li class="inside">
                                        <xsl:value-of select="$ncFirst"/><span class="percent"><xsl:value-of select="$cPart"/></span><xsl:value-of select="$ncLast"/>
                                        <xsl:value-of select="$delim" />
                                </li>
                        </xsl:when>
                        <xsl:otherwise>
                                <xsl:choose>
                                        <xsl:when test="contains($string,'$(')">
                                                <xsl:variable name="ncFirst" select="substring-before($string,'$(')"/>
                                                <xsl:variable name="iStart" select="string-length(substring-before($string, '$('))+1"/>
                                                <xsl:variable name="leftover" select="substring($string, $iStart)"/>
                                                <xsl:variable name="iEnd" select="string-length(substring-before($leftover, ')'))+1"/>
                                                <xsl:variable name="cPart" select="substring($string, $iStart, $iEnd)"/>
                                                <xsl:variable name="ncLast" select="substring-after($leftover,')')"/>
                                                <li class="inside">
                                                        <xsl:value-of select="$ncFirst"/><span class="dollar"><xsl:value-of select="$cPart"/></span><xsl:value-of select="$ncLast"/>
                                                        <xsl:value-of select="$delim" />
                                                </li>
                                        </xsl:when>
                                        <xsl:otherwise>
                                                <li class="inside">
                                                        <xsl:value-of select="$string" />
                                                        <xsl:value-of select="$delim" />
                                                </li>
                                        </xsl:otherwise>
                                </xsl:choose>
                        </xsl:otherwise>
                </xsl:choose>
        </xsl:template>


        <!-- ******************************************************** -->
        <!-- ** ** -->
        <!-- ** Make an unordered list from a ;-separated string ** -->
        <!-- ** ** -->
        <!-- ******************************************************** -->

        <xsl:variable name="delim">
                <xsl:text>;</xsl:text>
        </xsl:variable>

        <xsl:template name="string2list">
                <xsl:param name="seplist" />

                <xsl:choose>
                        <xsl:when test="contains($seplist,$delim)">
                                <xsl:call-template name="coloredList">
                                        <xsl:with-param name="string" select="substring-before($seplist,$delim)"/>
                                </xsl:call-template>

                                <xsl:call-template name="string2list">
                                        <xsl:with-param name="seplist" select="substring-after($seplist,$delim)" />
                                </xsl:call-template>
                        </xsl:when>

                        <xsl:otherwise>
                                <xsl:variable name="string" select="$seplist"/>
                                <xsl:call-template name="coloredList">
                                        <xsl:with-param name="string" select="$seplist"/>
                                </xsl:call-template>
                        </xsl:otherwise>
                </xsl:choose>
        </xsl:template>

        <!-- ********************************************************* -->

        <xsl:template name="sep-string-to-ulist">
                <xsl:param name="sep-string" />

                <ul>
                        <li class="plusplus">&quot;&#8212;&#8212;&#8212;</li>
                        <xsl:call-template name="string2list">
                                <xsl:with-param name="seplist" select="$sep-string" />
                        </xsl:call-template>
                        <li class="plusplus">&#8212;&#8212;&#8212;&quot;</li>
                </ul>
        </xsl:template>

        <!-- ********************************************************* -->
        <!-- ** ** -->
        <!-- ** Make a list of <href/>s from a ;-separated string ** -->
        <!-- ** ** -->
        <!-- ********************************************************* -->

        <xsl:template name="stringlist2hrefs">
                <xsl:param name="seplist" />

                <xsl:variable name="comma">
                        <xsl:text>,</xsl:text>
                </xsl:variable>

                <xsl:choose>
                        <xsl:when test="contains($seplist,$comma)">
                                <xsl:variable name="v1" select="substring-before($seplist,$comma)" />
                                <a href="#Module-{$v1}" onclick="openItem({$v1})">
                                        <xsl:value-of select="$v1" />
                                </a>
                                ,

                                <xsl:call-template name="stringlist2hrefs">
                                        <xsl:with-param name="seplist"
                                                select="substring-after($seplist,$comma)" />
                                </xsl:call-template>
                        </xsl:when>

                        <xsl:otherwise>
                                <xsl:variable name="v2" select="$seplist" />
                                <a href="#Module-{$v2}" onclick="openItem({$v2})">
                                        <xsl:value-of select="$v2" />
                                </a>
                        </xsl:otherwise>
                </xsl:choose>

        </xsl:template>


        <!-- ************************************* -->
        <!-- ** ** -->
        <!-- ** Evaluate the <postevent/> tag ** -->
        <!-- ** ** -->
        <!-- ************************************* -->

        <xsl:template name="next-module">
                <xsl:param name="postevent" />
                <xsl:variable name="next"
                        select="substring-before(substring-after($postevent,'MODULE_INIT('),')')" />
                <xsl:choose>
                        <xsl:when test="contains($next,',')">
                                Post&#160;Events:
                        </xsl:when>
                        <xsl:otherwise>
                                Post&#160;Event:
                        </xsl:otherwise>
                </xsl:choose>
                <xsl:call-template name="stringlist2hrefs">
                        <xsl:with-param name="seplist" select="$next" />
                </xsl:call-template>
        </xsl:template>


        <!-- Capitalize first letter only -->
        <xsl:template name="initcap">
                <xsl:param name="text" />
                <!-- Crazy way of capitalize the first letter!!! -->
                <xsl:value-of
                        select="concat(translate(substring($text,1,1),
                                           'abcdefghijklmnopqrstuvwxyz',
                                           'ABCDEFGHIJKLMNOPQRSTUVWXYZ'),
                                 substring($text,2))" />
        </xsl:template>


        <!-- ******************************************************** -->
        <!-- ** ** -->
        <!-- ** By which Roadmap step(s) is a module referenced? ** -->
        <!-- ** ** -->
        <!-- ******************************************************** -->

        <xsl:template name="referenced-by">
                <xsl:param name="modname" />
                <xsl:for-each select="/.//unitmodule[@name = $modname]">
                        <xsl:variable name="UdefName" select="ancestor::UnitDefinition/@name" />
                        <xsl:variable name="RoadmapStep" select="ancestor::unit/@id" />

                        <xsl:choose>
                                <xsl:when test="position()=1">
                                        <xsl:text> (referenced by </xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                        <xsl:text>, </xsl:text>
                                </xsl:otherwise>
                        </xsl:choose>

                        <a href="#{$RoadmapStep}-{$modname}">
                                <nobr>
                                        <xsl:value-of select="$UdefName" />
                                        &#10145;<!-- Arrow -->
                                        <xsl:value-of select="$RoadmapStep" />
                                </nobr>
                        </a>

                        <xsl:if test="position()=last()">
                                <xsl:text>)</xsl:text>
                        </xsl:if>
                </xsl:for-each>
        </xsl:template>

        <!-- <colgroup/> for the module <table/> -->
        <xsl:template name="colgroup-module">
                <colgroup>
                        <col width="15%" />
                        <col width="25%" />
                        <col width="15%" />
                        <col width="15%" />
                        <col width="15%" />
                        <col width="15%" />
                </colgroup>
        </xsl:template>

</xsl:stylesheet>
