<?xml version="1.0" encoding="UTF-8"?>
<!--  ************************************************* -->
<!--  Transforms UPGANA.XML as generated by the UPGEVAL -->
<!--   phases into a human readable HTML format         -->
<!--        Copyright 2006-2008 SAP-AG                  -->
<!--  ************************************************* -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:param name="title" />
  <xsl:param name="creationdate" />
  <xsl:param name="contact" />
  <xsl:param name="cutofftime">30</xsl:param>
  <xsl:param name="cutoffsize">1048576</xsl:param>
  <xsl:param name="sizeunit">GB</xsl:param>
  <xsl:param name="sizesrcunit">KB</xsl:param>
  <xsl:param name="slotScaleView">1600</xsl:param>
  <xsl:param name="slotTooltipThreshold">500000</xsl:param>
  <xsl:param name="stepColumnWidth">18</xsl:param>
  <xsl:param name="stepColumnHeight">450</xsl:param>
  <xsl:output method="html" />
  <xsl:template match="execution-summary/execution-handler[@type='ABAP']/execution-handler-subset[@type!='EVAL']" />
  <xsl:template match="execution-summary/execution-handler[@type!='ABAP']" />
  <xsl:template match="/execution-summary/*[name()!='execution-handler']" />
  <xsl:template match="execution-summary/execution-handler[@type='ABAP']/execution-handler-subset[@type='EVAL']/analysis">
    <xsl:call-template name="main" />
  </xsl:template>
  <xsl:template match="/analysis">
    <xsl:call-template name="main" />
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="main">
    <head>
      <xsl:if test="$title != ''">
        <title>
          <xsl:value-of select="$title" />
        </title>
      </xsl:if>
      <xsl:call-template name="insert-style" />
      <xsl:call-template name="insert-script" />
    </head>
    <body onload="redesign()">
      <div class="head">
        <xsl:call-template name="print_title">
          <xsl:with-param name="title" select="title" />
        </xsl:call-template>
        <xsl:if test="configuration[@group='Upgrade']/property[@name='MigrateMode'] = 'yes' and not(contains(title, 'with DMO')) and not(contains(title, 'using DMO'))">
              (with DMO)
        </xsl:if>
      </div>
      <xsl:call-template name="show-title" />
      <xsl:call-template name="show-system" />
      <!-- *************************************************************************** -->
      <xsl:if test="count(configuration[@group='Upgrade']/property) &gt; 0">
        <xsl:call-template name="show-upgconfig" />
      </xsl:if>
      <xsl:if test="count(configuration[@group='Languages']/property) &gt; 0">
        <xsl:call-template name="show-upgrade-languages" />
      </xsl:if>
      <xsl:call-template name="show-upgtimes" />
      <xsl:call-template name="show-boundobjects" />
      <!-- *************************************************************************** -->
      <xsl:if test="count(configuration[@group='Versions']/version[@type='export' or @type='Upgrade']) &gt; 0">
        <xsl:call-template name="show-upgrade-versions" />
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(configuration[@group='Modifications']/property) &gt; 0">
        <xsl:call-template name="show-mods" />
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(configuration[@group='Versions']/configuration[@group='Source']/version) &gt; 0 or count(configuration[@group='Versions']/configuration[@group='Destination']/version) &gt; 0">
        <xsl:call-template name="show-tool-versions" />
      </xsl:if>
      <!-- **************************************************************************** -->
      <xsl:call-template name="show-main-components" />
      <!-- *************************************************************************** -->
      <div id="stepsContainer" class="steps">
        <div class="title">
          <div class="subTitle">
            <xsl:call-template name="mkjstag" /> Roadmap Steps
          </div>
        </div>
        <xsl:for-each select="phases[not(@group = preceding-sibling::phases/@group)]">
          <xsl:if test="@group != 'revoke' or $cutofftime = 0">
            <a name="phaselist{@group}" />
            <div class="step" style="display:table">
              <div class="stepTitle">
                <div class="subStepTitle">
                  <xsl:call-template name="mkjstag" />
                                              Roadmap Step: <i><xsl:value-of select="@group" /></i>
                                              (Cutoff Time: <xsl:value-of select="$cutofftime" />s)
                </div>
              </div>
              <xsl:call-template name="show-phases">
                <xsl:with-param name="group" select="@group" />
                <xsl:with-param name="cutofftime2" select="$cutofftime" />
              </xsl:call-template>
            </div>
          </xsl:if>
        </xsl:for-each>
      </div>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='DEPLOYMENTS']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="deploylist" />
        <div class="system" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="phm tableCell title">
              <xsl:call-template name="mkjstag" />
            Deployments (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'DEPLOYMENTS'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type = 'XPRAS']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="xpralist" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="phm tableCell title">
              <xsl:call-template name="mkjstag" />
            XPRAs (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'XPRAS'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
            <xsl:with-param name="showmodrecords" select="'YES'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='XPRAS-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="xpralist-ut" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="phm tableCell title">
              <xsl:call-template name="mkjstag" />
            XPRAs during Uptime (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'XPRAS-UT'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
            <xsl:with-param name="showmodrecords" select="'YES'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type = 'XCLAS']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="xclalist" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="phm tableCell title">
              <xsl:call-template name="mkjstag" />
            XCLAs (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'XCLAS'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
            <xsl:with-param name="showmodrecords" select="'YES'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='XCLAS-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="xclalist-ut" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="phm tableCell title">
              <xsl:call-template name="mkjstag" />
            XCLAs during Uptime (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'XCLAS-UT'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
            <xsl:with-param name="showmodrecords" select="'YES'" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='AFTIMP']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="aftimplist" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title phm tableCell">
              <xsl:call-template name="mkjstag" />
            After Import Methods (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'AFTIMP'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='AFTIMP-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="aftimplist-ut" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title tableCell phm">
              <xsl:call-template name="mkjstag" />
            After Import Methods during Uptime (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'AFTIMP-UT'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='SDMI']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="sdmilist" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title phm tableCell">
              <xsl:call-template name="mkjstag" />
              Silent Data Migrations (Cutoff Time: <xsl:value-of select="$cutofftime" />s)
            </div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'SDMI'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='SDMI-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="sdmilist-ut" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title tableCell phm">
              <xsl:call-template name="mkjstag" />
              Silent Data Migrations during Uptime (Cutoff Time: <xsl:value-of select="$cutofftime" />s)
            </div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'SDMI-UT'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='MPL']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="mpllist" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="phm tableCell title">
              <xsl:call-template name="mkjstag" />
            Multiplexer (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'MPL'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div class="phm tableCell title">
              <xsl:call-template name="mkjstag" />
            Multiplexer Statistics (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <div class="tableRow">
            <div>
              <xsl:call-template name="show-mplstats">
                <xsl:with-param name="exectype" select="'MPL'" />
                <xsl:with-param name="cutofftime2" select="$cutofftime" />
              </xsl:call-template>
            </div>
          </div>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='MPL-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="mpllist-ut" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="phm tableCell title">
              <xsl:call-template name="mkjstag" />
            Multiplexer during Uptime (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'MPL-UT'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div class="phm tableCell title">
              <xsl:call-template name="mkjstag" />
            Multiplexer Statistics during Uptime (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <div class="tableRow">
            <div>
              <xsl:call-template name="show-mplstats">
                <xsl:with-param name="exectype" select="'MPL-UT'" />
                <xsl:with-param name="cutofftime2" select="$cutofftime" />
              </xsl:call-template>
            </div>
          </div>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='CONVERSION']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="convlist" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title tableCell phm">
              <xsl:call-template name="mkjstag" />
            Conversions (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'CONVERSION'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='DDL']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="ddllist" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title tableCell phm">
              <xsl:call-template name="mkjstag" />
            SQLs (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'DDL'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='DDL-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="ddllist-ut" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title tableCell phm">
              <xsl:call-template name="mkjstag" />
            SQLs during Uptime (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'DDL-UT'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='CLONE']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="clonelist" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title tableCell phm">
              <xsl:call-template name="mkjstag" />
            Table Clone Times (longest 20)</div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'CLONE'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='MIGRATE-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="migrateutlist" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title tableCell phm">
              <xsl:call-template name="mkjstag" />
              Migration Uptime (Cutoff Time: <xsl:value-of select="$cutofftime" />s)
            </div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'MIGRATE-UT'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="total" select="executions[@type='MIGRATE-UT']/@time" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='MIGRATE-DT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="migratedtlist" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title tableCell phm">
              <xsl:call-template name="mkjstag" />
              Migration Downtime (Cutoff Time: <xsl:value-of select="$cutofftime" />s)
            </div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'MIGRATE-DT'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="total" select="executions[@type='MIGRATE-DT']/@time" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(executions[@type='MIGRATE-BENCH']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
        <a name="migratebenchlist" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title tableCell phm">
              <xsl:call-template name="mkjstag" />
              Migration Benchmarking (Cutoff Time: <xsl:value-of select="$cutofftime" />s)
            </div>
          </div>
          <xsl:call-template name="show-executions">
            <xsl:with-param name="exectype" select="'MIGRATE-BENCH'" />
            <xsl:with-param name="cutofftime2" select="$cutofftime" />
            <xsl:with-param name="total" select="executions[@type='MIGRATE-BENCH']/@time" />
            <xsl:with-param name="treepos" select="." />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(tabsizes/table[number(@size) &gt;= $cutoffsize]) &gt; 0">
        <a name="tabsizes" />
        <div class="meta" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%">
          <div class="tableRow">
            <div colspan="5" class="title tableCell phm">
              <xsl:call-template name="mkjstag" />
              <xsl:variable name="factor"><xsl:call-template name="calculate-size-factor"><xsl:with-param name="unit" select="$sizesrcunit" /><xsl:with-param name="targetunit" select="$sizeunit" /></xsl:call-template></xsl:variable>
              Table Sizes (Cutoff Size: <xsl:value-of select="concat(concat(format-number(number($cutoffsize) div $factor,'#,##0.###'), ' '), $sizeunit)" />)
            </div>
          </div>
          <xsl:call-template name="show-tabsizes">
            <xsl:with-param name="treepos" select="." />
            <xsl:with-param name="cutoff" select="$cutoffsize" />
          </xsl:call-template>
        </div>
      </xsl:if>
      <!-- *************************************************************************** -->
      <xsl:if test="count(processstats/phaserun) &gt; 0">
        <a name="procstats" />
        <div class="procStats">
          <!--         <div class="procStats" rules="none" border="0" cellpadding="1" cellspacing="1" width="100%"> -->
          <div class="title">
            <div class="subProcStatTitle">
              <xsl:call-template name="mkjstag" />
              Process Statistics (Cutoff Time: <xsl:value-of select="$cutofftime" />s)
              <div class="hidden totalTime">
                <xsl:value-of select="sum(processstats/phaserun/@seconds)" />
              </div>
              <form onsubmit="fadeoutStats(this); return false;" class="alignRight">
                min <input class="smallInput2" type="number" name="time" size="2" />
                <button class="yellow smallButton" type="submit">show</button>
              </form>
            </div>
          </div>
          <div class="tableContent">
            <div class="hint">
              The following diagrams show the processes running in parallel for each phase.
              The horizontal axis indicates the time course and the vertical axis shows the different processes.
              Each process is visualized by a blue line indicating the start time and the runtime of the process.
              If you move the mouse pointer over the blue line, you get further information about the process.
            </div>
            <xsl:for-each select="processstats/phaserun">
              <!-- validating time because time attribute is not stated everytime -->
              <xsl:variable name="validatedTime">
                <xsl:call-template name="timevalidation">
                  <xsl:with-param name="time" select="current()/@seconds" />
                </xsl:call-template>
              </xsl:variable>
              <xsl:variable name="maxProcessTime">
                <xsl:choose>
                  <xsl:when test="current()/@longest">
                    <xsl:value-of select="current()/@longest"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="findMaxProcessTime">
                      <xsl:with-param name="processTime" select="process"/>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:if test="number($validatedTime) &gt;= $cutofftime and $maxProcessTime &gt;= $cutofftime">
                <xsl:call-template name="show-one-procstat">
                  <xsl:with-param name="phaserun" select="current()" />
                  <xsl:with-param name="cutofftime2" select="$cutofftime" />
                </xsl:call-template>
              </xsl:if>
            </xsl:for-each>
          </div>
        </div>
      </xsl:if>
    </body>
  </xsl:template>

  <xsl:template name="findMaxProcessTime">
    <xsl:param name="processTime"/>
    <xsl:variable name="maxProcessTime">
        <xsl:for-each select="$processTime">
            <xsl:sort select="current()/@seconds" data-type="number" order="descending" />
            <xsl:if test="position() = 1">
                <xsl:value-of select="current()/@seconds"/>
            </xsl:if>
        </xsl:for-each>
    </xsl:variable>

    <xsl:value-of select="$maxProcessTime" />
  </xsl:template>

  <xsl:template name="find-title-replacement">
    <xsl:param name="title" />
    <xsl:param name="number" />
    <xsl:variable name="producttype_replacement">
          <item>ERP/S4HANA system release 751=S/4HANA oP 1610</item>
          <item>ERP/S4HANA system release 752=S/4HANA oP 1709</item>
          <item>ERP/S4HANA system release 753=S/4HANA oP 1809</item>
          <item>ERP/S4HANA system release 754=S/4HANA oP 1909</item>
          <item>ERP system release 751=S/4HANA oP 1610</item>
          <item>ERP system release 752=S/4HANA oP 1709</item>
          <item>ERP system release 753=S/4HANA oP 1809</item>
          <item>ERP system release 754=S/4HANA oP 1909</item>
          <item>SSUITE system release 760=S/4HANA CE 1503</item>
          <item>SSUITE system release 761=S/4HANA CE 1506</item>
          <item>SSUITE system release 762=S/4HANA CE 1511</item>
          <item>SSUITE system release 763=S/4HANA CE 1603</item>
          <item>SSUITE system release 764=S/4HANA CE 1605</item>
          <item>SSUITE system release 765=S/4HANA CE 1608</item>
          <item>SSUITE system release 766=S/4HANA CE 1611</item>
          <item>SSUITE system release 767=S/4HANA CE 1702</item>
          <item>SSUITE system release 768=S/4HANA CE 1705</item>
          <item>SSUITE system release 769=S/4HANA CE 1708</item>
          <item>SSUITE system release 770=S/4HANA CE 1711</item>
          <item>SSUITE system release 771=S/4HANA CE 1802</item>
          <item>SSUITE system release 772=S/4HANA CE 1805</item>
          <item>SSUITE system release 773=S/4HANA CE 1808</item>
          <item>SSUITE system release 774=S/4HANA CE 1811</item>
          <item>SSUITE system release 775=S/4HANA CE 1902</item>
          <item>SSUITE system release 776=S/4HANA CE 1905</item>
          <item>SSUITE system release 777=S/4HANA CE 1908</item>
          <item>760=1503</item>
          <item>761=1506</item>
          <item>762=1511</item>
          <item>763=1603</item>
          <item>764=1605</item>
          <item>765=1608</item>
          <item>766=1611</item>
          <item>767=1702</item>
          <item>768=1705</item>
          <item>769=1708</item>
          <item>770=1711</item>
          <item>771=1802</item>
          <item>772=1805</item>
          <item>773=1808</item>
          <item>774=1811</item>
          <item>775=1902</item>
          <item>776=1905</item>
          <item>777=1908</item>
      <item>SSUITE=S/4HANA CE</item>
      <item>ERP/S4HANA=S/4HANA oP</item>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="contains($title,substring-before(document('')/xsl:stylesheet/*/xsl:variable[@name='producttype_replacement']/item[$number],'='))">
        <xsl:value-of select="substring-before($title,substring-before(document('')/xsl:stylesheet/*/xsl:variable[@name='producttype_replacement']/item[$number],'='))" />
        <xsl:value-of select="substring-after(document('')/xsl:stylesheet/*/xsl:variable[@name='producttype_replacement']/item[$number],'=')" />
        <xsl:value-of select="substring-after($title,substring-before(document('')/xsl:stylesheet/*/xsl:variable[@name='producttype_replacement']/item[$number],'='))" />
      </xsl:when>
      <xsl:when test="$number = count(document('')/xsl:stylesheet/*/xsl:variable[@name='producttype_replacement']/item)" />
      <xsl:otherwise>
        <xsl:call-template name="find-title-replacement">
          <xsl:with-param name="title" select="$title" />
          <xsl:with-param name="number" select="$number + 1" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="print_title">
    <xsl:param name="title" />
    <xsl:variable name="replaced_title">
      <xsl:call-template name="find-title-replacement">
        <xsl:with-param name="title" select="$title" />
        <xsl:with-param name="number" select="1" />
      </xsl:call-template>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test="$replaced_title != ''">
        <xsl:value-of select="$replaced_title" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$title" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- ******************************************************************* -->
  <xsl:template match="CloneSequence">
    <head>
      <title>Sequence of cloned tables</title>
      <xsl:call-template name="insert-style" />
      <xsl:call-template name="insert-script" />
    </head>
    <body>
      <div class="meta" rules="none" border="1" cellpadding="1" cellspacing="1" width="100%">
        <xsl:for-each select="Clone">
          <div class="tableRow">
            <div width="6%">
              <xsl:value-of select="@div" />
            </div>
            <div width="2%">
              <xsl:value-of select="@relsize" />%</div>
            <div width="90%">
              <div width="100%" border="1" align="left" cellpadding="2">
                <div class="tableRow">
                  <div class="pbp" align="center" nowrap="nowrap" width="{@relsize}%">
                    &#160;
                  </div>
                  <div>
                    &#160;
                  </div>
                </div>
              </div>
            </div>
          </div>
        </xsl:for-each>
      </div>
    </body>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template match="CloneDurations">
    <head>
      <title>Clone times</title>
      <xsl:call-template name="insert-style" />
      <xsl:call-template name="insert-script" />
    </head>
    <body>
      <table class="DurationsTable" rules="none" border="0" cellpadding="0" cellspacing="0" width="100%">
        <xsl:for-each select="CloneDuration">
          <tr>
            <td width="6%" align="right">
              <xsl:value-of select="@table" />
            </td>
            <td width="90%">
              <table width="100%" border="0" align="left" cellpadding="2">
                <tr>
                  <td class="pb0" align="center" nowrap="nowrap" width="{@startperc+1}%">
                                                                        &#160;
                  </td>
                  <td class="tooltips" align="center" nowrap="nowrap" width="{@lenperc+1}%">&#160;
                    <span>
                                                                Table: <xsl:value-of select="@table" /><br />
                                                                NRow (exp): <xsl:value-of select="format-number(@exprowcount,'###,###')" /><br />
                                  NRow (imp): <xsl:value-of select="format-number(@improwcount,'###,###')" /><br />
                                                                Size: <xsl:value-of select="format-number(@size div 1024,'###,###')" /> MB <br />
                                                                Start Time: <xsl:value-of select="substring(@starttime,1,4)" />.<xsl:value-of select="substring(@starttime,5,2)" />.<xsl:value-of select="substring(@starttime,7,2)" />&#160;<xsl:value-of select="substring(@starttime,9,2)" />:<xsl:value-of select="substring(@starttime,11,2)" />:<xsl:value-of select="substring(@starttime,13,2)" /><br />
                                                                End Time: <xsl:value-of select="substring(@endtime,1,4)" />.<xsl:value-of select="substring(@endtime,5,2)" />.<xsl:value-of select="substring(@endtime,7,2)" />&#160;<xsl:value-of select="substring(@endtime,9,2)" />:<xsl:value-of select="substring(@endtime,11,2)" />:<xsl:value-of select="substring(@endtime,13,2)" /><br />
                                                                Runtime: <xsl:value-of select="format-number(floor(@impduration div 3600),'###,###')" />h <xsl:value-of select="format-number((@impduration div 60) mod 60,'##')" />m <br />
                                                                Migration Speed: <xsl:value-of select="format-number(@kbpersecond div 1024,'###,##0.#')" /> MB/s
                    </span></td>
                  <td class="pb0">
                                                                        &#160;
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </xsl:for-each>
      </table>
    </body>
  </xsl:template>
  <!-- ******************************************************************* -->
  <!-- (de) print process slot summary statistics -->
  <xsl:template match="TableSplitDistribution|ProcessSlotsComparison">
    <head>
      <title>Table Split Distribution </title>
      <xsl:call-template name="insert-style" />
      <xsl:call-template name="insert-script" />
    </head>
    <body>
      <xsl:for-each select="ProcessSlots">
        <p>
          <b> Table Split Distribution: </b>
          Determined <xsl:value-of select="@nsplits" /> tables for splitting and <xsl:value-of select="@nmoves" /> for moving to avoid tail processes at the end.
        </p>
        <table class="TableSplitDistribution" rules="none" border="0" cellpadding="0" cellspacing="0" width="{100+$slotScaleView}px">
          <xsl:for-each select="ProcessSlot">
            <xsl:variable select="@slotSize" name="varSlotSize" />
            <tr>
              <td align="right" style="padding-right:10px">
                <xsl:value-of select="format-number($varSlotSize div 1024 div 1024, '###.##')" /> GB</td>
              <td width="{$slotScaleView}px">
                <xsl:for-each select="ProcessChunk|ProcessSplit">
                  <div class="tooltips" style="width:{@relSize*$slotScaleView}px;">
                    <xsl:choose>
                      <xsl:when test="@tableFlag='1'">
                        <xsl:attribute name="class">tooltips split</xsl:attribute>
                      </xsl:when>
                    </xsl:choose>
                    <xsl:choose>
                      <xsl:when test="@tableSize &gt; $slotTooltipThreshold">
                        <span>
                            Name: <xsl:value-of select="@tableName" /><br />
                            Flag: <xsl:value-of select="@tableFlag" /><br />
                            SlotSize: <xsl:value-of select="format-number($varSlotSize div 1024 div 1024, '###.##')" /> GB <br />
                            TableSize: <xsl:value-of select="format-number(@tableSize div 1024 div 1024, '###.##')" /> GB <br />
                            ChunkSize: <xsl:value-of select="format-number(@chunkSize div 1024 div 1024, '###.##')" /> GB
                        </span>
                      </xsl:when>
                    </xsl:choose>
                  </div>
                </xsl:for-each>
              </td>
            </tr>
          </xsl:for-each>
        </table>
      </xsl:for-each>
    </body>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="insert-style">
    <!-- <LINK rel="stylesheet" type="text/css" href="../config/upgana.css"/> -->
    <STYLE>
        .head {
                text-align: center;
                font-size:24pt;
                font-weight:bold;
        }
        .foot { font-family:Arial;  font-size:10pt; }
        .DurationsTable tr:nth-child(even) { background:#C1D4DC; }
        .TableSplitDistribution tr:nth-child(even) { background:#D9D9D9; }

        .TableSplitDistribution div {
        float:left;
        height:15px;
    }
    .TableSplitDistribution div.tooltips {
      position: relative;
      background-color:#199EDE;
      border-radius:2em;
      font-size:8pt;
    }
    .TableSplitDistribution div.split { background: #548235; }

        a:link { color:#000099; text-decoration:none;  }
        a:visited { color:#000099; text-decoration:none;  }

        .topElements {
                border:none;
        }

        body {
            min-width: 800px;
            margin: 1%;
            font-family: Arial;
            font-size: 10pt;
            color: #000000;
            background-color: #FFFFFF;
        }

        /* tooltip */

        td.tooltips {
          position: relative;
          background-color:#199EDE;
          border-radius:2em;
          font-size:8pt;
        }
        .TableSplitDistribution div.tooltips span,
        td.tooltips span {
          position: absolute;
          width:190px;
          color: #FFFFFF;
          background: #000000;
          border: 1px solid #CFCFCF;
          height: 120px;
          text-align: left;
          visibility: hidden;
          border-radius: 6px;
          padding: 8px;
          font-size: 10pt;
        }
        .TableSplitDistribution div.tooltips span:before,
        td.tooltips span:before {
          content: '';
          position: absolute;
          bottom: 100%;
          left: 50%;
          margin-left: -10px;
          width: 0; height: 0;
          border-bottom: 10px solid #CFCFCF;
          border-right: 10px solid transparent;
          border-left: 10px solid transparent;
        }
        .TableSplitDistribution div.tooltips span:after
        td.tooltips span:after {
          content: '';
          position: absolute;
          bottom: 100%;
          left: 50%;
          margin-left: -8px;
          width: 0; height: 0;
          border-bottom: 8px solid #000000;
          border-right: 8px solid transparent;
          border-left: 8px solid transparent;
        }
        .TableSplitDistribution div:hover.tooltips span,
        td:hover.tooltips span {
          visibility: visible;
          opacity: 0.8;
          top: 30px;
          left: 50%;
          margin-left: -105px;
          z-index: 999;
        }
        .TableSplitDistribution div:hover.tooltips.bottom span {
        bottom: 0px;
        top: 100%;
    }

/* tool tip end */

        .meta , .step, .procStats, .procStat, .quicklinks, .steps {
                border-radius: 25px;
                padding: 15px;
                margin-bottom: 5px;
        }
        .module {
                border-radius: 15px;
                padding-bottom:5px;
                padding-right:5px;
                padding-left:5px;
                margin-bottom: 5px;
                border: 2px solid #93C939;
                display:table;
                width:98%;
        }
        .moduleTitleRight {
                border-top-right-radius: 25px;
                text-align: right;
        }
        .moduleTitleLeft {
                border-top-left-radius: 25px;
        }
        .tableRowTitle {display: table-row;}
        .fsa { border:none; }
        .tableRow { display: table-row; }
        .tableCell {
                display: table-cell;
                border: 1px solid #FFFFFF;
                padding-left: 5px;
        }
        .tableContent {
                width:100%;
                display:table;
        }

        .hhd { font-weight:bold; font-weight:bold; border:none; }
        .hhc { font-size:10pt; font-weight:bold; font-weight:bold; background-color:#e5e5e5; }
        .hhr { font-size:10pt; font-weight:bold; background-color:#87C1DD; min-width:100pt;}

        .hac { font-size:10pt; background-color:#ddddee; }
        .hab { font-size:10pt; font-weight:bold;}
        .ha { font-size:10pt; background-color:#ddddee; min-width:100pt;}

        .hbc  { font-size:10pt; background-color:#fbeabf; }
        .hbb  { font-size:10pt; background-color:#fbeabf; font-weight:bold;}
        .hb   { font-size:10pt; background-color:#fbeabf; min-width:100pt; }

        .hcb  { font-size:10pt; font-weight:bold; background-color:#fbeabf; width:200px; }
        .hc   { font-size:10pt; background-color:#fbeabf; min-width:100pt;}
        .e    { font-size:10pt; }
        .le   { font-size:10pt; min-width:200pt;}

        .hdb  { font-size:10pt; font-weight:bold; min-width:100pt;}
        .hhh { font-size:14pt; font-weight:bold; background-color:#e5e5e5;}
        .fff { font-size:8pt; font-weight:bold; background-color:#e5e5e5;}

        .phm { font-size:12pt; font-weight:bold;}

        .php { font-size:10pt; font-weight:bold; background-color:#CCCCCC;}
        .ph  { font-size:10pt; font-weight:bold; background-color:#CCCCCC;}
        .phr { font-size:10pt; font-weight:bold; background-color:#CCCCCC;}

        .pap { font-size:10pt; font-weight:bold; background-color:#e5e5e5;}
        .pa  { font-size:10pt; background-color:#e5e5e5; min-width:100pt;}

        .pb0 { font-size:8pt; font-weight:bold; border:none}
        .pbp { font-size:8pt; background-color:#c9e49c;}
        .pbp:hover { background-color:#98b5c3; }
        .pps { background-color: #008FD3; cursor: pointer; }
        .pps:hover { background-color:#003283; }
        .pb  { font-size:10pt; background-color:#c9e49c; min-width:100pt;}

        .xap { font-size:10pt; font-weight:bold; background-color:#eedddd;}
        .xa  { font-size:10pt; background-color:#eedddd; min-width:100pt;}

        .xbp { font-size:10pt; font-weight:bold; background-color:#fbeabf;}
        .xb  { font-size:10pt; background-color:#fbeabf; min-width:100pt;}

        .ebbx { font-family:Courier; font-size:10pt; font-weight:bold; background-color:#ffeeee; max-width:100pt;}
        .ebb { font-size:10pt; font-weight:bold; background-color:#ffeeee; max-width:100pt;}
        .ebb { font-size:10pt; font-weight:bold; background-color:#ffeeee; max-width:100pt;}
        .ebt { font-size:10pt; background-color:#ffeeee; min-width:200pt;}

        .eh { font-size:12pt; font-weight:bold; background-color:#e5e5e5;}

        .ep { font-size:10pt; font-weight:bold; background-color:#ffdddd;}
        .et { font-size:10pt; font-weight:bold; background-color:#ffffff;}

        .etag { font-family:monospace; font-size:larger; border:1px solid; }
        .allbutton { border:1px solid; }

        .meta {
                border: 2px solid #999999;
                width: 95%;
                margin: 0 auto;
                margin-bottom: 2%;
                display:table;
        }
        .controlButtons {
                width: 98%;
                margin: 0 auto;
                margin-top: 1%;
                margin-bottom: 1%;
        }
        .steps {
                position:relative;
                border: 2px solid #999999;
                width: 95%;
                margin: 0 auto;
                margin-bottom: 2%;
        }
        .step {
                border: 2px solid #008FD3;
                width: 95%;
                margin: 0 auto;
                margin-bottom: 2%;
        }
        .procStats {
                border: 2px solid #970A82;
                width: 95%;
                margin: 0 auto;
                margin-bottom: 2%;
        }
        .procStat {
                border: 2px solid #F0AB00;
                display:table;
                width: 95%;
                margin: 0 auto;
                margin-bottom: 2%;
        }
        .stepsContainer {
                width:98%;
                position:fixed;
        }
        .stepTitle {
                font-weight:bold;
                font-size:11pt;
        }

        .quicklinks {border: 2px solid #EB7300;}
        .qLink {
                font-size:12pt;
                margin:5px;
        }
        #dbHeading { border:none; }

        .title {
                font-size: 14pt;
        font-weight: bold;
        }
        button {
                cursor: pointer;
                margin: 10px;
                margin-left: 0px;
                border-radius: 5px;
                text-decoration: none;
                padding: 0px;
                text-align: center;
                font-size: 22px;
                transition: .3s;
                -webkit-transition: .3s;
                -moz-transition: .3s;
                -o-transition: .3s;
                display: inline-block;
                background-color: #ffffff;
        }
        button:hover {
                background-color: #55acee;
                color: #fff
        }
        button.blue:active , button.red:active, button.yellow:active, button.purple:active {
                padding:0.1em;
        }
        button.blue.plus:active, button.red.minus:active {
                transition: .1s;
                -webkit-transition: .1s;
                -moz-transition: .1s;
                -o-transition: .1s;
                padding: 10px;
        }
        .blue.plus , .red.minus , .noToggle.blue {
                width:35px;
                height:35px;
        }
        .blue {
                color: #55acee;
                border: 2px #55acee solid;
        }
        .blue:hover {
                background-color: #55acee;
                color: #fff
        }
        .red {
                color: #e74c3c;
                border: 2px #e74c3c solid;
        }
        .red:hover {
                color: #fff;
                background-color: #e74c3c;
        }
        .yellow {
                color: #f1c40f;
                border: 2px #f1c40f solid;
        }
        .yellow:hover {
                color: #fff;
                background-color: #f1c40f;
        }
        .smallInput, .smallInput2 {
                width:50px;
        }
        .hint {
                padding-left: 65px;
                font-size: 10pt;
                margin-bottom: 20px;
        }
        .alignRight { float:right; }
        .subTitle { padding-left: 5px; }
        .subProcStatTitle { padding-left: 5px; }
        .smallButton { font-size:15px; }
        .hidden { display: none; }
    </STYLE>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="insert-script">
    <script type="text/javascript">//<![CDATA[

function getDarkModeColor(colorMap, origColor, defaultColor)
{
    var newColor = colorMap[origColor];
    if(newColor != undefined) {
        return newColor;
    }

    return defaultColor;
}

if(document.URL.indexOf("?suihcb=true") > 0)
{
    var colorMap = {
        "rgb(217, 217, 217)" : "rgb(37, 57, 65)",
        "rgb(0, 143, 211)"   : "rgb(255, 255, 255)",
        "rgb(0, 50, 131)"    : "rgb(220, 220, 220)"
    };

    for(var idxStyle = 0 ; idxStyle < document.styleSheets.length ; idxStyle++) {
        var style = document.styleSheets[idxStyle];

        for(var idxRule = 0 ; idxRule < style.cssRules.length ; idxRule++) {
            var rule = style.cssRules[idxRule];

            console.log(rule);

            if(rule.style.color != undefined) {
                rule.style.color = getDarkModeColor(colorMap, rule.style.color, "rgb(255, 255, 255)");
            }

            if(rule.style.backgroundColor != undefined) {
                rule.style.backgroundColor = getDarkModeColor(colorMap, rule.style.backgroundColor, "rgb(0, 0, 0)");
            }

            if(rule.style.borderColor != undefined) {
                rule.style.borderColor = getDarkModeColor(colorMap, rule.style.borderColor, "rgb(255, 255, 255)");
            }
        }
    }
}

//onload function
function redesign() {
        //handle empty modules
        checkEmptyModules()

        //close single steps
        closeSteps(document.getElementsByClassName('step'));
        closeStats(document.getElementsByClassName('procStat'));

        //getting longest runtimes
        loadLongestRuntime("meta");
        loadLongestRuntime("step");
        loadLongestRuntime("proc");
}

function checkEmptyModules() {
        var modules = document.getElementsByClassName("module");
        for(var i=0; i<modules.length; i++) {
                if(modules[i].childNodes.length == 2) {
                        var fc = modules[i].firstChild;
                        var button = fc.firstChild.firstChild;
                        button.className = "noToggle blue";
                        button.innerHTML = "";
                        button.onclick = "";
                        if(button.parentNode.className.indexOf("moduleTitleRight") != -1) {
                                button.parentNode.style.borderRadius = '0px 25px 25px 0px';
                        }
                        else if(button.parentNode.className.indexOf("moduleTitleLeft") != -1) {
                                button.parentNode.style.borderRadius = '25px 0px 0px 25px';
                                var nextTitle = button.parentNode.nextSibling;
                                while(nextTitle) {
                                        if(nextTitle.className.indexOf("moduleTitleRight") != -1) {
                                                nextTitle.style.borderRadius = '0px 25px 25px 0px';
                                        }
                                        nextTitle = nextTitle.nextSibling;
                                }
                        }
                        //delete second row
                        var rows = modules[i].childNodes;
                        var deleteRow = rows[1];
                        deleteRow.parentNode.removeChild(deleteRow);
                }
        }
}

/*
        load the longes time int the title
        container: current container in which the longest runtime should get loaded
*/
function loadLongestRuntime(container) {
        switch(container) {
                case "meta":
                        var titles = document.getElementsByClassName("timeSelector");
                        getLongestTime(titles, "meta", "timeStatement", false);
                        titles = document.getElementsByClassName("timeSelector");
            getLongestTime(titles, "step", "timeStatement", false);
                        break;
                case "step":
                        var titles = document.getElementsByClassName("subStepTitle");
                        getLongestTime(titles, "step", "timeStatementStep", false);
                        break;
                case "proc":
                        var titles = document.getElementsByClassName("subProcStatTitle");
                        getLongestTime(titles, "procStats", "subPhaseTitle", true)
                        break;
        }

}

/*
        getting the longest runtime with param
        titles: all titles which shall contain the runtime later
        parentName: name of the parent which contains all elements
        tPlace: place where the time is stated
        isProc: true/false proc stats getting extra parsing of the time
*/
function getLongestTime(titles, parentName, tPlace, isProc) {
        for(var t=0;t<titles.length;t++) {
                var longest = 0;
                var sum = 0;
                var parent = titles[t].parentNode;
                while(parent != null && parent.className != parentName) {
                        parent = parent.parentNode;
                }
        if (parent != null)
        {
            var timeStates = parent.getElementsByClassName(tPlace);
            for(var ts=0; ts<timeStates.length; ts++) {
                var sec;
                if(isProc) {
                    sec = stringToSeconds(timeStates[ts].innerHTML
                                            .substring(timeStates[ts].innerHTML.lastIndexOf("(runtime")+8,
                                                        timeStates[ts].innerHTML.lastIndexOf("):")
                                             ).split(":")
                                         );
                }
                else {
                    sec = stringToSeconds(timeStates[ts].innerHTML.split(":"));
                }
                if(!isNaN(sec)) {
                    if(sec > longest) {
                        longest = sec;
                    }
                    if(parentName == "step") {
                        sum += sec;
                    }
                }
            }
            var longestResult = secondsToTime(longest);
            if(parentName == "step") {
                var sumResult = secondsToTime(sum);
                //if (parent.getElementsByClassName("totalTime").length > 0)
                    //sumResult = secondsToTime(parent.getElementsByClassName("totalTime")[0].innerHTML);
                titles[t].innerHTML += "Total / Longest Runtime: " + sumResult + " / "  + longestResult;
            }
            else {
                var totalTime = parent.getElementsByClassName("totalTime");
                var sumResult = secondsToTime(totalTime[0].innerHTML);
                titles[t].innerHTML += "Total / Longest Runtime: " + sumResult + " / "  + longestResult;
            }
        }
    }
}

//highlight rows with which run longer than stated
function highlight(form) {
        var time = parseInt(form.elements["time"].value) *60;
        var parent = form.parentNode.parentNode;
        var row = parent.nextSibling;
        while(row.nextSibling) {
                row = row.nextSibling;
                var childs = row.childNodes;
                if(childs.length > 1) {
                        var timeContent = childs[1].innerHTML.split(":");
                        //convert to seconds
                        var sec = stringToSeconds(timeContent);
                        //handling for internet explorer
                        if(!isNaN(sec)) {
                                //check if step took longer than stated time
                                if(sec >= time) {
                                        for(var c=0;c<childs.length;c++) {
                                                childs[c].style.background = "#e74c3c";
                                        }
                                }
                                else {
                                        for(var c=0;c<childs.length;c++) {
                                                if(typeof(childs[c].innerHTML) != 'undefined') {
                                                        childs[c].style.background = ""; // "#C9E49C";
                                                }
                                        }
                                }
                        }
                        //extra handling for internet explorer
                        else if (childs.length > 3) {
                                timeContent = childs[3].innerHTML.split(":");
                                //convert to seconds
                                sec = stringToSeconds(timeContent);

                                if(!isNaN(sec)) {
                                //check if step took longer than stated time
                                        if(sec >= time) {
                                                for(var c=0;c<childs.length;c++) {
                                                        if(typeof(childs[c].innerHTML) != 'undefined') {
                                                                childs[c].style.background = "#e74c3c";
                                                        }
                                                }
                                        }
                                        else {
                                                for(var c=0;c<childs.length;c++) {
                                                        if(typeof(childs[c].innerHTML) != 'undefined') {
                                                                childs[c].style.background = ""; // "#C9E49C";
                                                        }
                                                }
                                        }
                                }
                        }
                }
        }
}

//fadeout stats which run faster than stated
//form: current form
function fadeoutStats(form) {
        var time = parseInt(form.elements["time"].value) *60;
        var titles = document.getElementsByClassName("subPhaseTitle");


        //change btn to correct style
        var procStatBtn = document.getElementsByClassName("subProcStatTitle");
        var btn = procStatBtn[0].getElementsByTagName("BUTTON");
        if(btn[0].className == "blue plus") {
                btn[0].innerHTML = "-";
                btn[0].className = "red minus";
        }

        for(var t=0;t<titles.length;t++) {
                var row = titles[t];
                var timeContent = row.innerHTML.substring(row.innerHTML.lastIndexOf("(runtime")+8, row.innerHTML.lastIndexOf("):")).split(":");
                var sec = stringToSeconds(timeContent);

                if(!isNaN(sec)) {
                        while(row.className != "procStat") {
                                row = row.parentNode;
                        }

                        var childs = row.getElementsByTagName("*");

                        //check if step took longer than stated time
                        if(sec < time) {
                                row.style.display = 'none';
                                for(var c=0; c<childs.length; c++) {
                                        childs[c].style.display = 'none';
                                }
                        }
                        else if(row.style.display == "none") {
                                row.style.display = '';
                                for(var c=0; c<childs.length; c++) {
                                        childs[c].style.display = '';
                                }
                                var buttons = row.getElementsByTagName("BUTTON");
                                //double toggle to fix
                                toggle(buttons[0]);
                                toggle(buttons[0]);
                        }
                }
        }
}

/*
        parses an array with length 3 to seconds
        [0]: hours
        [1]: minutes
        [2] seconds
*/
function stringToSeconds(time) {
        var hToSec = parseInt(time[0]) * 60 *60;
        var minToSec = parseInt(time[1]) *60;
        var secToSec = parseInt(time[2]);

        var sum = hToSec + minToSec + secToSec;
        return sum;
}

//convert time into hh:mm:ss
function secondsToTime(sec) {
    //round off
    var hr   = Math.floor(sec / 3600);
    var min = Math.floor((sec - (hr * 3600)) / 60);
    var seconds = sec - (hr * 3600) - (min * 60);

    //ad 0 if number is too small
    if (hr   < 10) {hr   = "0" + hr;}
    if (min < 10) {min = "0" + min;}
    if (seconds < 10) {seconds = "0"+seconds;}
    var time = hr + ':' + min + ':' + seconds;
    return time;
}

function openElement(element) {
        var childs = element.childNodes;
        for(var i=0; i<childs.length; i++) {
                setElement(childs[0])
                if(childs[i].firstChild.firstChild.className == "blue plus") {
                        childs[i].firstChild.firstChild.innerHTML = "-";
                        childs[i].firstChild.firstChild.className = "red minus";
                }
                childs[i].style.display = "";
        }
}

// close the stats
function closeStats(elements) {
        for(var e=0;e<elements.length;e++) {
                var spt = elements[e].getElementsByClassName("subPhaseTitle");
                for(var s=0;s<spt.length;s++) {
                        var buttons = spt[s].childNodes;
                        for(var b=0;b<buttons.length;b++) {
                                if(buttons[b].className && buttons[b].className.indexOf('red')!= -1) {
                                        toggle(buttons[b]);
                                        //buttons[b].click();
                                }
                        }
                }
        }

  if(elements.length > 0) {
        var previous = elements[0].previousSibling;
        if(previous != undefined && previous.className != 'title') {
                while(previous != undefined && previous.className != 'title') {
                        previous = previous.previousSibling;
                }
    }

    if(previous != undefined) {
        var tchilds = previous.childNodes;
        for(var t=0;t<tchilds.length;t++) {
          if(tchilds[t].className == "subProcStatTitle") {
            var buttons = tchilds[t].childNodes;
            for(var b=0;b<buttons.length;b++) {
              if(buttons[b].className && buttons[b].className.indexOf('red') != -1) {
                toggle(buttons[b]);
                //buttons[b].click();
              }
            }
          }
        }
    }
  }
}

//close single steps
function closeSteps(elements) {
        for(var i=0;i<elements.length;i++) {
                var rows = elements[i].getElementsByClassName("tableRow");
                for(var r=0;r<rows.length;r++) {
                        var tmpElements = rows[r].childNodes;
                        for(var t=0;t<tmpElements.length;t++) {
                                if(tmpElements[t].className && tmpElements[t].className.length > 0 && (tmpElements[t].className.indexOf("moduleTitleLeft") != -1 || tmpElements[t].className.indexOf("tableRowTitle") != -1)) {
                                        var tmpElementsChilds = tmpElements[t].childNodes;
                                        if(tmpElementsChilds[0].className && tmpElementsChilds[0].className.length > 2 && tmpElementsChilds[0].className.indexOf("red") != -1) {
                                                tmpElementsChilds[0].click();
                                        }
                                }
                        }
                }

                var steptitles = elements[i].getElementsByClassName("subStepTitle");
                for(var s=0; s<steptitles.length; s++) {
                        var buttons = steptitles[s].childNodes;
                        for(var b=0;b<buttons.length;b++) {
                                if(buttons[b].className && buttons[b].className.length > 2 && buttons[b].className.indexOf('red') != -1) {
                                        buttons[b].click();
                                }
                        }
                }
        }
}

//  Toggle single element
function toggle(element)
{
  var item = element.firstChild;
  setElement(element, (item.data == "+") ? "-" : "+", 1);
}

function toggleall(element, type)
{
  if(element.tagName == "BUTTON") {
    //var clattr = element.attributes["class"];
    //if(clattr && clattr.nodeValue == "etag")
      setElement(element, type, 0);
  }

  var sub;
  for(sub = element.firstChild ; sub ; sub = sub.nextSibling)
    toggleall(sub, type);
}
//  'element' should point to the "SPAN" node with class "etag"
        function setElement(element, type, dosub)
        {
          var sub = element.firstChild;
          if(!sub) {
                return;
          }

          if(!type) {
                type = sub.data;
          }

          var newdisp = (type == "+") ? "none" : "";
          if(element.innerHTML != 'Close All' && element.innerHTML != 'Open All' && element.className != "yellow smallButton") {
                sub.data = type;
                if(element.innerHTML == "-") {
                        element.className = "red minus";
                }
                else if(element.innerHTML == "+") {
                        element.className = "blue plus";
                }
          }

          //  Go to "div" element and change display of all following "div" until
          //   element with same class is found (== next header)
      // /(ms) or until the classname has a "stop" inside, the class must be equal until the stop sign

          element = element.parentNode; //  go to "TD" element

          var myclass = element.attributes["class"];
          if(!myclass) {
                return;
          }

          //console.debug("Ursprung: " + element.attributes["class"].nodeValue);
          myclass = myclass.nodeValue;
          element = element.parentNode; //  go to "TR" element
          //console.debug("Vater: " + element.attributes["class"].nodeValue);

          var next;
          //next sibling is next element on the same level
          for(next = element.nextSibling ; next ; next = next.nextSibling) {
            //console.debug("Nachbar: " + next.attributes["class"].value);
            sub = next.firstChild;
            if(!sub) {
             continue; //  skip text nodes
            }
            //console.debug("Nachbars erstes Kind: " + sub.tagName +  " " + sub.className);
            for( ; sub ; sub = sub.nextSibling) {
              if(sub.tagName == "DIV" || sub.tagName == "TD" || sub.tagName =="TABLE")
                break;
            }

            var indexStop = -1;

        if(!sub || sub.className == myclass || ((indexStop = sub.className.indexOf('stop')) > 1 && sub.className.substring(0, indexStop - 2) == myclass.substring(0, indexStop - 2))) {
              break;
            }

            if(next.className == "meta system") {
                var childs = next.childNodes;
                //searching for the content which should be hidden
                for(var i=0;i<childs.length;i++) {
                        if(childs[i].className == "tableContent") {
                                next = childs[i];
                        }
                }
            }
            next.style.display = newdisp;
          }

          //  Fix all subelements on reopen
          if(dosub != 0 && newdisp == "") {
            for(next = element.nextSibling ; next ; next = next.nextSibling)
              toggleall(next, "");
          }
        }
//]]></script>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="mkjstag">
    <!--     <span class="etag" onclick="toggle(this)">-</span> -->
    <button class="red minus" onclick="toggle(this)">-</button>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-title">
    <div class="controlButtons">
      <div class="subControlButtons">
        <button class="blue" onclick="toggleall(document, '-')">Open All</button>
        <xsl:call-template name="NBSPC" />
        <xsl:call-template name="NBSPC" />
        <button id="closeAllButton" class="red" onclick="toggleall(document, '+')">Close All</button>
        <a class="qLink" href="#components">&gt;&gt; Component Versions</a>
        <a class="qLink" href="#phaselistExtraction">&gt;&gt; PREPARE</a>
        <a class="qLink" href="#phaselistPreprocessing">&gt;&gt; MAIN</a>
        <xsl:if test="count(executions[@type='DEPLOYMENTS']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#deploylist">&gt;&gt; Deployments</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='XPRAS-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#xpralist-ut">&gt;&gt; XPRAs during Uptime</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='XPRAS']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#xpralist">&gt;&gt; XPRAs</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='XCLAS-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#xclalist-ut">&gt;&gt; XCLAs during Uptime</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='XCLAS']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#xclalist">&gt;&gt; XCLAs</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='AFTIMP-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#aftimplist-ut">&gt;&gt; After Import Methods during Uptime</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='AFTIMP']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#aftimplist">&gt;&gt; After Import Methods</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='SDMI-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#sdmilist-ut">&gt;&gt; Silent Data Migrations during Uptime</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='SDMI']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#sdmilist">&gt;&gt; Silent Data Migrations</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='CONVERSION']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#convlist">&gt;&gt; Conversions</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='DDL']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#ddllist">&gt;&gt; SQLs</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='DDL-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#ddllist-ut">&gt;&gt; SQLs during Uptime</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='MIGRATE-UT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#migrateutlist">&gt;&gt; Migration Uptime</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='MIGRATE-DT']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#migratedtlist">&gt;&gt; Migration Downtime</a>
        </xsl:if>
        <xsl:if test="count(executions[@type='MIGRATE-BENCH']/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">
          <a class="qLink" href="#migratebenchlist">&gt;&gt; Migration Benchmarking</a>
        </xsl:if>
        <xsl:if test="count(tabsizes/table[number(@size) &gt;= $cutoffsize]) &gt; 0">
          <a class="qLink" href="#tabsizes">&gt;&gt; Table Sizes</a>
        </xsl:if>
        <xsl:if test="count(processstats/phaserun) &gt; 0">
          <a class="qLink" href="#procstats">&gt;&gt; Process Statistics</a>
        </xsl:if>
      </div>
    </div>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-system">
    <xsl:variable name="section" select="configuration[@group='System']" />
    <xsl:variable name="nProdClients">
      <xsl:choose>
        <xsl:when test="number($section/property[@name='NrProdClients']) = 0">N/A</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$section/property[@name='NrProdClients']" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <div class="meta system">
      <div class="tableRow">
        <div class="title hhd tableCell">
          <xsl:call-template name="mkjstag" />System</div>
      </div>
      <div class="tableContent">
        <div class="tableRow">
          <div class="hcb tableCell">Start-Release:</div>
          <div class="hc tableCell">
            <xsl:value-of select="$section/property[@name='StartRel']" />
          </div>
        </div>
        <div class="tableRow">
          <div class="hcb tableCell">Destination-Release:</div>
          <div class="hc tableCell">
            <xsl:value-of select="$section/property[@name='DestRel']" />
          </div>
        </div>
        <div class="tableRow">
          <div class="hcb tableCell">SID:</div>
          <div class="hc tableCell">
            <xsl:value-of select="@SID" />
          </div>
        </div>
        <div class="tableRow">
          <div class="hcb tableCell">Installation number:</div>
          <div class="hc tableCell">
            <xsl:value-of select="@instnumber" />
          </div>
        </div>
        <div class="tableRow">
          <div class="hcb tableCell">OS-Type:</div>
          <div class="hc tableCell">
            <xsl:value-of select="$section/property[@name='OSType']" />
          </div>
        </div>
        <div class="tableRow">
          <div class="hcb tableCell">OS-Version:</div>
          <div class="hc tableCell">
            <xsl:value-of select="$section/property[@name='OSVersion']" />
          </div>
        </div>
        <div class="tableRow">
          <div class="hcb tableCell">SAP-Host:</div>
          <div class="hc tableCell">
            <xsl:value-of select="$section/property[@name='SAPHost']" />
          </div>
        </div>
        <div class="tableRow">
          <xsl:if test="$section/property[@name='BatchHost'] != ''">
            <div class="hcb tableCell">Batch host:</div>
            <div class="hc tableCell">
              <xsl:value-of select="$section/property[@name='BatchHost']" />
            </div>
          </xsl:if>
        </div>
        <div class="tableRow">
          <xsl:if test="$section/property[@name='SystemType'] != ''">
            <div class="hcb tableCell">System-Type:</div>
            <div class="hc tableCell">
              <xsl:value-of select="$section/property[@name='SystemType']" />
            </div>
          </xsl:if>
        </div>
        <xsl:if test="$section/property[@name='SPCProcessId'] != ''">
          <div class="tableRow">
            <div class="hcb tableCell">SPC Process ID:</div>
            <div class="hc tableCell">
              <xsl:value-of select="$section/property[@name='SPCProcessId']" />
            </div>
          </div>
        </xsl:if>
        <div class="tableRow">
          <div class="hcb tableCell">No. clients (productive):</div>
          <div class="hc tableCell">
            <xsl:choose>
              <xsl:when test="number($section/property[@name='NrClients']) &gt;= count($section/configuration[@group='Clients']/client)">
                <xsl:value-of select="$section/property[@name='NrClients']" />
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="count($section/configuration[@group='Clients']/client)" />
              </xsl:otherwise>
            </xsl:choose>
            (<xsl:value-of select="$nProdClients" />)
          </div>
        </div>
        <!-- seperate db information -->
        <div class="tableRow">
          <div id="dbHeading" class="title tableCell">DB-Information</div>
        </div>
        <xsl:choose>
          <xsl:when test="configuration[@group='Upgrade']/property[@name='MigrateMode'] = 'yes'">
            <div class="tableRow">
              <div class="hcb tableCell">DB Type Old:</div>
              <div class="hc tableCell">
                <xsl:value-of select="configuration[@group='Upgrade']/property[@name='MigrateOldDBType']" />
              </div>
            </div>
            <div class="tableRow">
              <div class="hcb tableCell">DB Version Old:</div>
              <div class="hc tableCell">
                <xsl:value-of select="configuration[@group='Upgrade']/property[@name='MigrateOldDBVersion']" />
              </div>
            </div>
            <div class="tableRow">
              <div class="hcb tableCell">DB Host Old:</div>
              <div class="hc tableCell">
                <xsl:value-of select="configuration[@group='Upgrade']/property[@name='MigrateOldDBHost']" />
              </div>
            </div>
            <div class="tableRow">
              <div class="hcb tableCell">DB Type New:</div>
              <div class="hc tableCell">
                <xsl:value-of select="configuration[@group='Upgrade']/property[@name='MigrateNewDBType']" />
              </div>
            </div>
            <div class="tableRow">
              <div class="hcb tableCell">DB Version New:</div>
              <div class="hc tableCell">
                <xsl:value-of select="configuration[@group='Upgrade']/property[@name='MigrateNewDBVersion']" />
              </div>
            </div>
            <div class="tableRow">
              <div class="hcb tableCell">DB Host New:</div>
              <div class="hc tableCell">
                <xsl:value-of select="configuration[@group='Upgrade']/property[@name='MigrateNewDBHost']" />
              </div>
            </div>
          </xsl:when>
          <xsl:otherwise>
            <div class="tableRow">
              <div class="hcb tableCell">DB Type:</div>
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='DBType']" />
              </div>
            </div>
            <div class="tableRow">
              <div class="hcb tableCell">DB Version:</div>
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='DBVersion']" />
              </div>
            </div>
            <div class="tableRow">
              <div class="hcb tableCell">DB Host:</div>
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='DBHost']" />
              </div>
            </div>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="$section/property[@name='DBSizeInitial'] != ''">
          <div class="tableRow">
            <div class="hcb tableCell">DB Size (initial):</div>
            <div class="hc tableCell">
              <xsl:choose>
                <xsl:when test="$section/property[@name='DBSizeInitial'] != '0.00/0.00'">
                  <xsl:value-of select="$section/property[@name='DBSizeInitial']" /> GB
                </xsl:when>
                <xsl:otherwise>
                  N/A
                </xsl:otherwise>
              </xsl:choose>
            </div>
          </div>
        </xsl:if>
        <xsl:if test="$section/property[@name='DBSizeFinal'] != ''">
          <div class="tableRow">
            <div class="hcb tableCell">DB size (final):</div>
            <div class="hc tableCell">
              <xsl:choose>
                <xsl:when test="$section/property[@name='DBSizeFinal'] != '0.00/0.00'">
                  <xsl:value-of select="$section/property[@name='DBSizeFinal']" /> GB
                </xsl:when>
                <xsl:otherwise>
                  N/A
                </xsl:otherwise>
              </xsl:choose>
            </div>
          </div>
        </xsl:if>
      </div>
    </div>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-mods">
    <xsl:variable name="section" select="configuration[@group='Modifications']" />
    <xsl:if test="($section/property[@name='Notes'] != '' and $section/property[@name='Notes'] != '-1')
               or ($section/property[@name='Objects'] != '' and $section/property[@name='Objects'] != '-1')
               or ($section/property[@name='DDICOjbects'] != '' and $section/property[@name='DDICOjbects'] != '-1')
               or ($section/property[@name='DDICObjects'] != '' and $section/property[@name='DDICObjects'] != '-1')">
    <div class="meta system">
      <div class="tableRow">
        <div colspan="5" class="title hhd tableCell">
          <xsl:call-template name="mkjstag" />Modifications</div>
      </div>
      <div class="tableContent">
        <xsl:if test="$section/property[@name='Notes'] != '' and $section/property[@name='Notes'] != '-1'">
          <div class="tableRow">
            <div class="hcb tableCell">Notes:</div>
            <div class="hc tableCell">
              <xsl:value-of select="$section/property[@name='Notes']" />
            </div>
          </div>
        </xsl:if>
        <xsl:if test="$section/property[@name='Objects'] != '' and $section/property[@name='Objects'] != '-1'">
          <div class="tableRow">
            <div class="hcb tableCell">Objects:</div>
            <div class="hc tableCell">
              <xsl:value-of select="$section/property[@name='Objects']" />
            </div>
          </div>
        </xsl:if>
        <xsl:if test="($section/property[@name='DDICOjbects'] != '' and $section/property[@name='DDICOjbects'] != '-1')
                   or ($section/property[@name='DDICObjects'] != '' and $section/property[@name='DDICObjects'] != '-1')">
          <div class="tableRow">
            <div class="hcb tableCell">DDIC Objects:</div>
            <div class="hc tableCell">
              <xsl:choose>
                <xsl:when test="$section/property[@name='DDICObjects'] != '' and $section/property[@name='DDICObjects'] != '-1'">
                  <xsl:value-of select="$section/property[@name='DDICObjects']" />
                </xsl:when>
                <xsl:when test="$section/property[@name='DDICOjbects'] != '' and $section/property[@name='DDICOjbects'] != '-1'">
                  <xsl:value-of select="$section/property[@name='DDICOjbects']" />
                </xsl:when>
              </xsl:choose>
            </div>
          </div>
        </xsl:if>
      </div>
    </div>
    </xsl:if>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-boundobjects">
    <div class="meta system">
      <div class="tableRow">
        <div colspan="5" class="title hhd tableCell">
          <xsl:call-template name="mkjstag" />Packages and customer transports</div>
      </div>
      <div class="tableContent">
        <div class="tableRow">
          <xsl:variable name="boundPackages">
            <xsl:call-template name="countBoundPackages">
              <xsl:with-param name="srcvers" select="configuration[@group='Versions']/configuration[@group='Components']/configuration[@group='Source' or @group='source']/version"/>
              <xsl:with-param name="expvers" select="configuration[@group='Versions']/configuration[@group='Components']/configuration[@group='Export' or @group='export']/version"/>
              <xsl:with-param name="destvers" select="configuration[@group='Versions']/configuration[@group='Components']/configuration[@group='Destination' or @group='destination']/version"/>
            </xsl:call-template>
          </xsl:variable>
          <div class="hcb tableCell">Number of bound packages:</div>
          <div class="hc tableCell">
            <xsl:value-of select="$boundPackages" />
          </div>
          <div class="e tableCell"></div>
                  <div class="hcb tableCell">Number of bound customer transports:</div>
                  <div class="hc tableCell">
            <xsl:choose>
              <xsl:when test="count(configuration[@group='Upgrade']/property[@name='CustomerTransports']) &gt; 0" >
                <xsl:value-of select="configuration[@group='Upgrade']/property[@name='CustomerTransports']" />
              </xsl:when>
              <xsl:otherwise>n/a</xsl:otherwise>
                    </xsl:choose>
                  </div>
        </div>
      </div>
    </div>
  </xsl:template>

  <xsl:template name="countBoundPackages">
    <xsl:param name="srcvers" />
    <xsl:param name="expvers" />
    <xsl:param name="destvers" />
    <xsl:choose>
      <xsl:when test="$destvers">
        <xsl:variable name="packages">
          <xsl:call-template name="countBoundPackages">
            <xsl:with-param name="srcvers" select="$srcvers"/>
            <xsl:with-param name="expvers" select="$expvers"/>
            <xsl:with-param name="destvers" select="$destvers[position() != 1]"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="destvers_patchlevel">
          <xsl:choose>
            <xsl:when test="$destvers[position() = 1]/@patchlevel">
               <xsl:value-of select="$destvers[position() = 1]/@patchlevel"/>
            </xsl:when>
            <xsl:otherwise>
              0
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="$expvers[@name = $destvers[position() = 1]/@name]">
            <xsl:choose>
              <xsl:when test="$expvers[@name = $destvers[position() = 1]/@name]/@release = $destvers[position() = 1]/@release">
                <xsl:variable name="expvers_patchlevel">
                  <xsl:choose>
                    <xsl:when test="$expvers[@name = $destvers[position() = 1]/@name]/@patchlevel">
                       <xsl:value-of select="$expvers[@name = $destvers[position() = 1]/@name]/@patchlevel"/>
                    </xsl:when>
                    <xsl:otherwise>
                      0
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                <xsl:value-of select="number($packages) + number($destvers_patchlevel) - number($expvers_patchlevel)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="number($packages) + number($destvers_patchlevel)"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$srcvers[@name = $destvers[position() = 1]/@name]">
            <xsl:choose>
              <xsl:when test="$srcvers[@name = $destvers[position() = 1]/@name]/@release = $destvers[position() = 1]/@release">
                <xsl:variable name="srcvers_patchlevel">
                  <xsl:choose>
                    <xsl:when test="$srcvers[@name = $destvers[position() = 1]/@name]/@patchlevel">
                       <xsl:value-of select="$srcvers[@name = $destvers[position() = 1]/@name]/@patchlevel"/>
                    </xsl:when>
                    <xsl:otherwise>
                      0
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                <xsl:value-of select="number($packages) + number($destvers_patchlevel) - number($srcvers_patchlevel)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="number($packages) + number($destvers_patchlevel)"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="number($packages)" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
     </xsl:choose>
   </xsl:template>

  <!-- ******************************************************************* -->
  <xsl:template name="show-upgtimes">
    <xsl:variable name="section" select="configuration[@group='Times']" />
    <div class="meta system">
      <div class="tableRow">
        <div colspan="5" class="title hhd tableCell">
          <xsl:call-template name="mkjstag" />Times</div>
      </div>
      <div class="tableContent">
        <div class="tableRow">
          <div class="hcb tableCell">Start date:</div>
          <div class="hc tableCell">
            <xsl:call-template name="format-various-dates">
              <xsl:with-param name="Date" select="@startdate" />
            </xsl:call-template>
          </div>
          <div class="e tableCell"></div>
          <div class="hcb tableCell">End date:</div>
          <div class="hc tableCell">
            <xsl:call-template name="format-various-dates">
              <xsl:with-param name="Date" select="@enddate" />
            </xsl:call-template>
          </div>
        </div>
        <div class="tableRow">
          <div class="hcb tableCell">
            <xsl:choose>
              <xsl:when test="configuration[@group='Upgrade']/property[@name='ZeroDowntimeUpgrade'] = 'yes'">
                  Cutover Time:
              </xsl:when>
              <xsl:otherwise>
                  SUM Technical downtime:
              </xsl:otherwise>
            </xsl:choose>
          </div>
          <div class="hc tableCell">
            <xsl:if test="$section/property[@name='MinDownTime' or @name='MinCutoverTime'] != ''">
              <xsl:call-template name="seconds-to-time">
                <xsl:with-param name="seconds" select="$section/property[@name='MinDownTime' or @name='MinCutoverTime']" />
              </xsl:call-template>
            </xsl:if>
          </div>
          <div class="e tableCell"></div>
          <div class="hcb tableCell">Runtime:</div>
          <div class="hc tableCell">
            <xsl:choose>
              <xsl:when test="$section/property[@name='SAPJupTime'] != ''">
                <xsl:call-template name="seconds-to-time">
                  <xsl:with-param name="seconds" select="$section/property[@name='SAPJupTime']" />
                </xsl:call-template>
              </xsl:when>
              <xsl:when test="$section/property[@name='SAPupTime'] != ''">
                <xsl:call-template name="seconds-to-time">
                  <xsl:with-param name="seconds" select="$section/property[@name='SAPupTime']" />
                </xsl:call-template>
              </xsl:when>
              <xsl:when test="$section/property[@name='SAPehpiTime'] != ''">
                <xsl:call-template name="seconds-to-time">
                  <xsl:with-param name="seconds" select="$section/property[@name='SAPehpiTime']" />
                </xsl:call-template>
              </xsl:when>
              <xsl:when test="$section/property[@name='R3upTime'] != ''">
                <xsl:call-template name="seconds-to-time">
                  <xsl:with-param name="seconds" select="$section/property[@name='R3upTime']" />
                </xsl:call-template>
              </xsl:when>
              <xsl:when test="$section/property[@name='RunTime'] != ''">
                <xsl:call-template name="seconds-to-time">
                  <xsl:with-param name="seconds" select="$section/property[@name='RunTime']" />
                </xsl:call-template>
              </xsl:when>
            </xsl:choose>
          </div>
        </div>
        <xsl:if test="$section/property[@name='MinEU_LOCKTime'] &gt; 0 or $section/property[@name='MinBridgeTime'] &gt; 0">
          <div class="tableRow">
            <div class="hcb tableCell">
                      <xsl:if test="$section/property[@name='MinEU_LOCKTime'] &gt; 0">
                Minimum EU_LOCK time:
                          </xsl:if>
            </div>
            <div class="hc tableCell">
              <xsl:if test="$section/property[@name='MinEU_LOCKTime'] &gt; 0">
                <xsl:call-template name="seconds-to-time">
                  <xsl:with-param name="seconds" select="$section/property[@name='MinEU_LOCKTime']" />
                </xsl:call-template>
                          </xsl:if>
            </div>
            <div class="e tableCell"></div>
            <div class="hcb tableCell">
              <xsl:if test="$section/property[@name='MinBridgeTime'] &gt; 0">
                Bridge Time:
              </xsl:if>
            </div>
            <div class="hc tableCell">
              <xsl:if test="$section/property[@name='MinBridgeTime'] &gt; 0">
                <xsl:call-template name="seconds-to-time">
                  <xsl:with-param name="seconds" select="$section/property[@name='MinBridgeTime']" />
                </xsl:call-template>
              </xsl:if>
                    </div>
          </div>
        </xsl:if>
      </div>
    </div>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-upgconfig">
    <xsl:variable name="section" select="configuration[@group='Upgrade']" />
    <div class="meta system">
      <div class="tableRow">
        <div class="title hhd tableCell">
          <xsl:call-template name="mkjstag" />Configuration</div>
      </div>
      <div class="tableContent">
        <div class="tableRow">
          <div class="hcb tableCell">Strategy:</div>
          <xsl:choose>
            <xsl:when test="$section/property[@name='ZeroDowntimeUpgrade'] = 'yes'">
              <div class="hc tableCell">Zero Downtime (ZDO)</div>
            </xsl:when>
            <xsl:when test="$section/property[@name='Strategy'] != ''">
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='Strategy']" />
              </div>
            </xsl:when>
            <xsl:otherwise>
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='UpgradeStrategy']" />
              </div>
            </xsl:otherwise>
          </xsl:choose>
          <div class="e tableCell"></div>
          <div class="hcb tableCell">Archiving:</div>
          <xsl:choose>
            <xsl:when test="$section/property[@name='ArchiveMode'] != ''">
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='ArchiveMode']" />
              </div>
            </xsl:when>
            <xsl:otherwise>
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='Archiving']" />
              </div>
            </xsl:otherwise>
          </xsl:choose>
        </div>
        <div class="tableRow">
          <div class="hcb tableCell">Batch processes:</div>
          <xsl:choose>
            <xsl:when test="$section/property[@name='BatchProcesses'] != ''">
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='BatchProcesses']" />
              </div>
            </xsl:when>
            <xsl:otherwise>
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='BatchProcs']" />
              </div>
            </xsl:otherwise>
          </xsl:choose>
          <div class="e tableCell"></div>
          <xsl:if test="$section/property[@name='IterativeShadowUpgrade'] != ''">
            <div class="hcb tableCell">Used nZDM capabilities:</div>
            <div class="hc tableCell">
              <xsl:value-of select="$section/property[@name='IterativeShadowUpgrade']" />
            </div>
          </xsl:if>
        </div>
        <div class="tableRow">
          <div class="hcb tableCell">R3trans processes:</div>
          <xsl:choose>
            <xsl:when test="$section/property[@name='R3transProcesses'] != ''">
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='R3transProcesses']" />
              </div>
            </xsl:when>
            <xsl:otherwise>
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='R3transProcs']" />
              </div>
            </xsl:otherwise>
          </xsl:choose>
          <div class="e tableCell"></div>
          <div class="hcb tableCell">SGEN processes:</div>
          <xsl:choose>
            <xsl:when test="$section/property[@name='SGENProcesses'] != ''">
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='SGENProcesses']" />
              </div>
            </xsl:when>
            <xsl:otherwise>
              <div class="hc tableCell">
                <xsl:value-of select="$section/property[@name='SGENProcs']" />
              </div>
            </xsl:otherwise>
          </xsl:choose>
        </div>
        <xsl:if test="$section/property[@name='R3loadProcesses'] != '' or $section/property[@name='R3loadProcs'] != '' or $section/property[@name='MaxUptimeProcesses'] != '' or $section/property[@name='UptimeProcs'] != ''">
          <div class="tableRow">
            <xsl:if test="$section/property[@name='R3loadProcesses'] != '' or $section/property[@name='R3loadProcs'] != ''">
              <div class="hcb tableCell">R3load processes:</div>
              <xsl:choose>
                <xsl:when test="$section/property[@name='R3loadProcesses'] != ''">
                  <div class="hc tableCell">
                    <xsl:value-of select="$section/property[@name='R3loadProcesses']" />
                  </div>
                </xsl:when>
                <xsl:otherwise>
                  <div class="hc tableCell">
                    <xsl:value-of select="$section/property[@name='R3loadProcs']" />
                  </div>
                </xsl:otherwise>
              </xsl:choose>
              <div class="e tableCell"></div>
            </xsl:if>
            <xsl:if test="$section/property[@name='MaxUptimeProcesses'] != '' or $section/property[@name='UptimeProcs'] != ''">
              <div class="hcb tableCell">Uptime processes:</div>
              <xsl:choose>
                <xsl:when test="$section/property[@name='MaxUptimeProcesses'] != ''">
                  <div class="hc tableCell">
                    <xsl:value-of select="$section/property[@name='MaxUptimeProcesses']" />
                  </div>
                </xsl:when>
                <xsl:otherwise>
                  <div class="hc tableCell">
                    <xsl:value-of select="$section/property[@name='UptimeProcs']" />
                  </div>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
          </div>
        </xsl:if>
        <xsl:if test="$section/property[@name='J2EEPresent'] != '' or $section/property[@name='CRRProcesses'] != '' or $section/property[@name='CRRProcs'] != ''">
          <div class="tableRow">
            <xsl:if test="$section/property[@name='J2EEPresent'] != ''">
              <div class="hcb tableCell">J2EE present:</div>
              <div class="hc tableCell">
                <xsl:choose>
                  <xsl:when test="$section/property[@name='J2EEPresent'] = 1">
                      yes
                  </xsl:when>
                  <xsl:when test="$section/property[@name='J2EEPresent'] = 0">
                      no
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="$section/property[@name='J2EEPresent']" />
                  </xsl:otherwise>
                </xsl:choose>
              </div>
              <div class="e tableCell"></div>
            </xsl:if>
            <xsl:if test="$section/property[@name='CRRProcesses'] != '' or $section/property[@name='CRRProcs'] != ''">
              <div class="hcb tableCell">CRR processes:</div>
              <xsl:choose>
                <xsl:when test="$section/property[@name='CRRProcesses'] != ''">
                  <div class="hc tableCell">
                    <xsl:value-of select="$section/property[@name='CRRProcesses']" />
                  </div>
                </xsl:when>
                <xsl:otherwise>
                  <div class="hc tableCell">
                    <xsl:value-of select="$section/property[@name='CRRProcs']" />
                  </div>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:if>
          </div>
        </xsl:if>
      </div>
    </div>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-upgrade-languages">
    <div class="meta system">
      <div class="tableRow">
        <div class="title hhd tableCell">
          <xsl:call-template name="mkjstag" />
          <a name="versions" />Languages</div>
      </div>
      <div class="tableContent">
        <xsl:for-each select="configuration[@group='Languages']/property">
          <div class="tableRow">
            <div class="hcb tableCell">
              <xsl:value-of select="current()/@name" />
            </div>
            <div class="hc tableCell">
              <xsl:value-of select="current()" />
            </div>
          </div>
        </xsl:for-each>
      </div>
    </div>
  </xsl:template>
  <!-- ******************************************************************* -->
  <!-- ******************************************************************* -->
  <xsl:template name="show-upgrade-versions">
    <xsl:variable name="upgrade" select="configuration[@group='Versions']/version[@type='Upgrade']" />
    <xsl:variable name="section" select="configuration[@group='Versions']/version[@type='export']" />
    <div class="meta system">
      <div class="tableRow">
        <div class="title hhd tableCell">
          <xsl:call-template name="mkjstag" />
          <a name="versions" />Versions</div>
      </div>
      <div class="tableContent">
        <xsl:if test="count($upgrade[@name='SUM']) > 0">
          <div class="tableRow">
            <xsl:call-template name="show-sum-version">
              <xsl:with-param name="tool" select="$upgrade[@name='SUM']" />
            </xsl:call-template>
          </div>
        </xsl:if>
        <div class="tableRow">
          <xsl:choose>
            <xsl:when test="$upgrade[@name='R3up'] != ''">
              <xsl:call-template name="show-upgtool-version">
                <xsl:with-param name="tool" select="$upgrade[@name='R3up']" />
              </xsl:call-template>
            </xsl:when>
            <xsl:when test="$upgrade[@name='SAPup'] != ''">
              <xsl:call-template name="show-upgtool-version">
                <xsl:with-param name="tool" select="$upgrade[@name='SAPup']" />
              </xsl:call-template>
            </xsl:when>
            <xsl:when test="$upgrade[@name='SAPehpi'] != ''">
              <xsl:call-template name="show-upgtool-version">
                <xsl:with-param name="tool" select="$upgrade[@name='SAPehpi']" />
              </xsl:call-template>
            </xsl:when>
            <xsl:when test="$upgrade[@name='SAPJup'] != ''">
              <xsl:call-template name="show-upgtool-version">
                <xsl:with-param name="tool" select="$upgrade[@name='SAPJup']" />
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <div class="hcb tableCell">R3up:</div>
              <div class="hc tableCell" />
            </xsl:otherwise>
          </xsl:choose>
        </div>
        <xsl:if test="$upgrade[@name='FIXPACKAGE'] != ''">
          <div class="tableRow">
            <div class="hcb tableCell">Fixpackage:</div>
            <div class="hc tableCell">
              &quot;<xsl:value-of select="$upgrade[@name='FIXPACKAGE']" />&quot;
              <b> Level: </b><xsl:value-of select="$upgrade[@name='FIXPACKAGE']/@patchlevel" /><b> Date :</b><xsl:value-of select="$upgrade[@name='FIXPACKAGE']/@date" /></div>
          </div>
        </xsl:if>
        <div class="tableRow">
          <xsl:if test="$section[@name='export'] != ''">
            <div class="hcb tableCell">Export:</div>
            <div class="hc tableCell">
              <xsl:call-template name="format-various-dates">
                <xsl:with-param name="Date" select="$section[@name='export']" />
              </xsl:call-template>
            </div>
          </xsl:if>
          <xsl:if test="$section[@name='misc'] != ''">
            <div class="hcb tableCell">Misc:</div>
            <div class="hc tableCell">
              <xsl:call-template name="format-various-dates">
                <xsl:with-param name="Date" select="$section[@name='misc']" />
              </xsl:call-template>
            </div>
          </xsl:if>
        </div>
        <div class="tableRow">
          <xsl:if test="$section[@name='control'] != ''">
            <div class="hcb tableCell">Control:</div>
            <div class="hc tableCell">
              <xsl:call-template name="format-various-dates">
                <xsl:with-param name="Date" select="$section[@name='control']" />
              </xsl:call-template>
            </div>
          </xsl:if>
          <div class="hcb tableCell">Kernel:</div>
          <div class="hc tableCell">
            <xsl:call-template name="format-various-dates">
              <xsl:with-param name="Date" select="$section[@name='kernel']" />
            </xsl:call-template>
          </div>
        </div>
      </div>
    </div>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-upgtool-version">
    <xsl:param name="tool" />
    <div class="hcb tableCell">
      <xsl:value-of select="$tool/@name" />
    </div>
    <div class="hc tableCell">
      <xsl:call-template name="format-various-dates">
        <xsl:with-param name="Date" select="$tool/@date" />
      </xsl:call-template>
      <b> Branch: </b>
      <xsl:value-of select="$tool/@release" />
      <xsl:choose>
        <xsl:when test="$tool/@unicode = 'yes'">
          <b> UNICODE </b>
        </xsl:when>
        <xsl:otherwise>
          <b> NON-UNICODE </b>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </xsl:template>

  <xsl:template name="show-sum-version">
    <xsl:param name="tool" />
    <div class="hcb tableCell">
      <xsl:value-of select="$tool/@name" />
    </div>
    <div class="hc tableCell">
      <xsl:call-template name="format-various-dates">
        <xsl:with-param name="Date" select="$tool/@date" />
      </xsl:call-template>
      <xsl:if test="$tool != ''">
        <b> Branch: </b><xsl:value-of select="$tool/@release" />
        <b> Release: </b><xsl:value-of select="$tool" />
        <xsl:choose>
            <xsl:when test="$tool/@sp != ''">.<xsl:value-of select="$tool/@sp" /></xsl:when><xsl:otherwise>.0</xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
            <xsl:when test="$tool/@patchlevel != ''">.<xsl:value-of select="$tool/@patchlevel" /></xsl:when><xsl:otherwise>.0</xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </div>
  </xsl:template>

  <!-- ******************************************************************* -->
  <xsl:template name="show-tool-versions">
    <xsl:variable name="Source" select="configuration[@group='Versions']/configuration[@group='Source']" />
    <!-- FIXME: Actually, there is no 'Export' group for tools, but leaving it empty gives XSLT errors  -->
    <xsl:variable name="Export" select="configuration[@group='Versions']/configuration[@group='Export']" />
    <xsl:variable name="Destin" select="configuration[@group='Versions']/configuration[@group='Destination']" />
    <div class="meta" border="0" cellpadding="1" rules="none" width="100%">
      <div class="tableRow">
        <div colspan="7" class="title hhd tableCell">
          <xsl:call-template name="mkjstag" />
          <a name="toolversions" />Tool Versions</div>
      </div>
      <div class="tableRow">
        <div class="e tableCell"></div>
        <div class="e tableCell"></div>
        <div class="hhr tableCell">Source</div>
        <div class="hhr tableCell"></div>
        <div class="e tableCell"></div>
        <div class="hhr tableCell">Destination</div>
        <div class="hhr tableCell"></div>
      </div>
      <div class="tableRow">
        <div class="hhr tableCell">Tool</div>
        <div class="e tableCell"></div>
        <div class="hhr tableCell">Rel</div>
        <div class="hhr tableCell">PL/Date</div>
        <div class="e tableCell"></div>
        <div class="hhr tableCell">Rel</div>
        <div class="hhr tableCell">PL/Date</div>
      </div>
      <xsl:for-each select="$Source/version">
        <xsl:if test="$Destin/version[@name=current()/@name]/@name = ''">
          <xsl:call-template name="show-one-comp">
            <xsl:with-param name="compname" select="current()/@name" />
            <xsl:with-param name="srccomp" select="current()" />
            <xsl:with-param name="expcomp" select="$Export/version[@name=current()/@name]" />
            <xsl:with-param name="dstcomp" select="$Destin/version[@name=current()/@name]" />
            <xsl:with-param name="showexport" select="boolean($Export != '')" />
          </xsl:call-template>
        </xsl:if>
      </xsl:for-each>
      <xsl:for-each select="$Destin/version">
        <xsl:call-template name="show-one-comp">
          <xsl:with-param name="compname" select="current()/@name" />
          <xsl:with-param name="srccomp" select="$Source/version[@name=current()/@name]" />
          <xsl:with-param name="expcomp" select="$Export/version[@name=current()/@name]" />
          <xsl:with-param name="dstcomp" select="current()" />
          <xsl:with-param name="showexport" select="boolean($Export != '')" />
        </xsl:call-template>
      </xsl:for-each>
    </div>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-main-components">
    <xsl:variable name="Source" select="configuration[@group='Versions']/configuration[@group='Components']/configuration[@group='Source' or @group='source']" />
    <xsl:variable name="Export" select="configuration[@group='Versions']/configuration[@group='Components']/configuration[@group='Export' or @group='export']" />
    <xsl:variable name="Destin" select="configuration[@group='Versions']/configuration[@group='Components']/configuration[@group='Destination' or @group='destination']" />
    <div class="meta" border="0" cellpadding="1" rules="none" width="100%">
      <div class="tableRow">
        <div colspan="10" class="title hhd tableCell">
          <xsl:call-template name="mkjstag" />
          <a name="components" />Component Versions</div>
      </div>
      <div class="tableRow">
        <div class="e tableCell"></div>
        <div class="e tableCell"></div>
        <div class="hhr tableCell">Source</div>
        <div class="hhr tableCell"></div>
        <xsl:if test="$Export != ''">
          <div class="e tableCell"></div>
          <div class="hhr tableCell">Export</div>
          <div class="hhr tableCell"></div>
        </xsl:if>
        <div class="e tableCell"></div>
        <div class="hhr tableCell" colspan="2">Destination</div>
        <div class="hhr tableCell"></div>
      </div>
      <div class="tableRow">
        <div class="hhr tableCell">Main Component</div>
        <div class="e tableCell"></div>
        <div class="hhr tableCell">Rel</div>
        <div class="hhr tableCell">PL</div>
        <xsl:if test="$Export != ''">
          <div class="e tableCell"></div>
          <div class="hhr tableCell">Rel</div>
          <div class="hhr tableCell">PL</div>
        </xsl:if>
        <div class="e tableCell"></div>
        <div class="hhr tableCell">Rel</div>
        <div class="hhr tableCell">PL</div>
      </div>
      <xsl:for-each select="$Source/version">
        <!-- first get only elements from source which don't exist in destination -->
        <xsl:if test="not($Destin/version[@name=current()/@name])">
          <xsl:call-template name="show-one-comp">
            <xsl:with-param name="compname" select="current()/@name" />
            <xsl:with-param name="srccomp" select="current()" />
            <xsl:with-param name="expcomp" select="$Export/version[@name=current()/@name]" />
            <xsl:with-param name="dstcomp" select="$Destin/version[@name=current()/@name]" />
            <xsl:with-param name="showexport" select="boolean($Export != '')" />
          </xsl:call-template>
        </xsl:if>
      </xsl:for-each>
      <!-- then get all objects which exist in destination, should contain all object -->
      <xsl:for-each select="$Destin/version">
        <xsl:call-template name="show-one-comp">
          <xsl:with-param name="compname" select="current()/@name" />
          <xsl:with-param name="srccomp" select="$Source/version[@name=current()/@name]" />
          <xsl:with-param name="expcomp" select="$Export/version[@name=current()/@name]" />
          <xsl:with-param name="dstcomp" select="current()" />
          <xsl:with-param name="showexport" select="boolean($Export != '')" />
        </xsl:call-template>
      </xsl:for-each>
    </div>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-one-comp">
    <xsl:param name="compname" />
    <xsl:param name="srccomp" />
    <xsl:param name="expcomp" />
    <xsl:param name="dstcomp" />
    <xsl:param name="showexport" />
    <xsl:if test="$srccomp/@type = 'SC' or $dstcomp/@type = 'SC' or
                  $srccomp/@type = 'R3' or $dstcomp/@type = 'R3' or
                  $srccomp/@type = 'tool' or $dstcomp/@type = 'tool'">
      <div class="tableRow">
        <div class="hhc tableCell">
          <xsl:value-of select="$compname" />
        </div>
        <div class="e tableCell"></div>
        <div class="ha tableCell">
          <xsl:value-of select="$srccomp/@release" />
        </div>
        <div class="ha tableCell">
          <xsl:call-template name="print-patchlevel">
            <xsl:with-param name="versiontag" select="$srccomp" />
          </xsl:call-template>
        </div>
        <xsl:if test="$showexport">
          <div class="e tableCell"></div>
          <div class="hc tableCell">
            <xsl:if test="$expcomp/@name != ''">
              <xsl:value-of select="$expcomp/@release" />
            </xsl:if>
          </div>
          <div class="hc tableCell">
            <xsl:if test="$expcomp/@name != ''">
              <xsl:call-template name="print-patchlevel">
                <xsl:with-param name="versiontag" select="$expcomp" />
              </xsl:call-template>
            </xsl:if>
          </div>
        </xsl:if>
        <div class="e tableCell"></div>
        <xsl:choose>
          <xsl:when test="$showexport">
            <div class="ha tableCell">
              <xsl:value-of select="$dstcomp/@release" />
            </div>
            <div class="ha tableCell">
              <xsl:call-template name="print-patchlevel">
                <xsl:with-param name="versiontag" select="$dstcomp" />
              </xsl:call-template>
            </div>
          </xsl:when>
          <xsl:otherwise>
            <div class="hc tableCell">
              <xsl:value-of select="$dstcomp/@release" />
            </div>
            <div class="hc tableCell">
              <xsl:call-template name="print-patchlevel">
                <xsl:with-param name="versiontag" select="$dstcomp" />
              </xsl:call-template>
            </div>
          </xsl:otherwise>
        </xsl:choose>
      </div>
    </xsl:if>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="format-off-len"><xsl:param name="offset" /><xsl:param name="length" /><xsl:param name="offperc" /><xsl:param name="lenperc" /><div>Start: </div><xsl:call-template name="seconds-to-time"><xsl:with-param name="seconds" select="$offset" /></xsl:call-template><div> Length: </div><xsl:call-template name="seconds-to-time"><xsl:with-param name="seconds" select="$length" /></xsl:call-template>(<xsl:value-of select="$lenperc" />%):
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-one-procstat">
    <xsl:param name="phaserun" />
    <xsl:param name="cutofftime2" />
    <xsl:variable name="total">
      <xsl:value-of select="number($phaserun/@seconds)" />
    </xsl:variable>
    <div class="procStat">
      <div class="phaseTitle">
        <div class="subPhaseTitle">
          <xsl:call-template name="mkjstag" />
          Phase
          <xsl:value-of select="$phaserun/@module" /><xsl:if test="$phaserun/@submodule">/<xsl:value-of select="$phaserun/@submodule" /></xsl:if>/<xsl:value-of select="$phaserun/@phase" />
          (runtime <xsl:call-template name="seconds-to-time"><xsl:with-param name="seconds" select="$total" /></xsl:call-template>):
        </div>
      </div>
      <div class="psInfo">
        <xsl:for-each select="$phaserun/process">
          <xsl:variable name="descript">
            <xsl:value-of select="." />
          </xsl:variable>
          <xsl:variable name="offset">
            <xsl:value-of select="number(@offset)" />
          </xsl:variable>
          <xsl:variable name="length">
            <xsl:value-of select="number(@seconds)" />
          </xsl:variable>
          <!-- validating time because time attribute is not stated everytime -->
          <xsl:variable name="validatedTime">
            <xsl:call-template name="timevalidation">
              <xsl:with-param name="time" select="@seconds" />
            </xsl:call-template>
          </xsl:variable>
          <xsl:if test="number($validatedTime) &gt;= $cutofftime2">
            <xsl:variable name="offperc">
              <xsl:value-of select="floor(100 * $offset div $total)" />
            </xsl:variable>
            <xsl:variable name="lenperc">
              <xsl:value-of select="floor(100 * $length div $total)" />
            </xsl:variable>
            <!-- each row has its own table -->
            <table class="psirTable" width="100%" align="left" cellpadding="2">
              <tr class="row">
                <xsl:variable name="value"><xsl:call-template name="format-off-len"><xsl:with-param name="offset" select="$offset" /><xsl:with-param name="length" select="number($validatedTime)" /><xsl:with-param name="offperc" select="$offperc" /><xsl:with-param name="lenperc" select="$lenperc" /></xsl:call-template><xsl:value-of select="$descript" /></xsl:variable>
                <xsl:if test="$offperc &gt; 0">
                  <td class="pb0" align="center" width="{$offperc}%" title="{$value}"></td>
                </xsl:if>
                <!-- blue lines -->
                <xsl:if test="$lenperc &gt; 0">
                  <td class="pps" align="center" nowrap="nowrap" width="{$lenperc}%" title="{$value}"></td>
                </xsl:if>
                <xsl:if test="$lenperc = 0">
                  <td class="pps" align="center" nowrap="nowrap" width="5px" title="{$value}"></td>
                </xsl:if>
                <xsl:if test="($offperc + $lenperc) &lt; 100">
                  <td class="pb0" align="center" title="{$value}"></td>
                </xsl:if>
              </tr>
            </table>
          </xsl:if>
        </xsl:for-each>
      </div>
    </div>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="print-patchlevel">
    <xsl:param name="versiontag" />
    <xsl:choose>
      <xsl:when test="$versiontag/@patchlevel != ''">
        <xsl:call-template name="format-PL">
          <xsl:with-param name="PL" select="$versiontag/@patchlevel" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        -
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$versiontag/@date != ''">
      / <xsl:call-template name="format-various-dates"><xsl:with-param name="Date" select="$versiontag/@date" /></xsl:call-template></xsl:if>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-phases">
    <xsl:param name="cutofftime2" />
    <xsl:param name="group" />
    <xsl:variable name="section" select="../phases" />
    <xsl:for-each select="$section[@group = $group]">
      <div class="module">
        <xsl:variable name="subtotal">
          <xsl:value-of select="sum(./phase/@time)" />
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="@module != ''">
            <div class="tableRow">
              <div class="hdb moduleTitleLeft tableCell">
                <xsl:call-template name="mkjstag" />

                            Module:
                <xsl:choose><xsl:when test="@name != ''"><i><xsl:if test="@group != ''"><xsl:value-of select="@group" />/</xsl:if><xsl:value-of select="@name" /></i></xsl:when><xsl:otherwise><i><xsl:if test="@group != ''"><xsl:value-of select="@group" />/</xsl:if><xsl:value-of select="@module" /></i></xsl:otherwise></xsl:choose></div>
              <div class="hdb tableCell"></div>
              <div class="hdb tableCell">
                <xsl:call-template name="NBSPC" />
              </div>
              <div class="hdb moduleTitleRight tableCell">
                <form onsubmit="highlight(this); return false;">
                                                min <input class="smallInput" type="number" name="time" min="1" size="2" /><button class="yellow smallButton" type="submit">highlight</button><xsl:call-template name="NBSPC" /><span class="timeStatementStep"><xsl:call-template name="seconds-to-time"><xsl:with-param name="seconds" select="$subtotal" /></xsl:call-template></span></form>
              </div>
            </div>
            <div class="tableRow">
              <div class="php tableCell">Phase</div>
              <div class="ph tableCell">Time</div>
              <div class="ph tableCell">Runs</div>
              <div class="ph tableCell">Failed</div>
            </div>
          </xsl:when>
          <xsl:when test="@name != ''">
            <div class="tableRow">
              <div class="hdb tableCell">
                <xsl:call-template name="mkjstag" />
                          Phase Group:
                <i><xsl:call-template name="get-phasegroup-name"><xsl:with-param name="name" select="INIT" /></xsl:call-template></i></div>
            </div>
          </xsl:when>
        </xsl:choose>
        <xsl:for-each select="./phase">
          <!-- validating time because time attribute is not stated everytime -->
          <xsl:variable name="validatedTime">
            <xsl:call-template name="timevalidation">
              <xsl:with-param name="time" select="@time" />
            </xsl:call-template>
          </xsl:variable>
          <xsl:choose>
            <xsl:when test="substring(@name, 1, 11) = 'PHASE_GROUP'">
              <div class="tableRow">
                <div class="hdb tableCell">
                  <xsl:call-template name="mkjstag" />
                            Phase Group:
                  <i><xsl:call-template name="get-phasegroup-name"><xsl:with-param name="name" select="substring(@name, 13)" /></xsl:call-template></i></div>
              </div>
            </xsl:when>
            <xsl:when test="number($validatedTime) &gt;= $cutofftime2 or @dialogs = 'yes' or @failed &gt;= 1">
              <xsl:variable name="phase_name">
                <xsl:call-template name="format-phasename">
                  <xsl:with-param name="name" select="@name" />
                </xsl:call-template>
              </xsl:variable>
              <xsl:variable name="class_prefix">
                <xsl:choose>
                  <xsl:when test="@failed != 0">pa</xsl:when>
                  <xsl:otherwise>pb</xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:variable name="xpras_aim_phase">
                <xsl:choose>
                  <xsl:when test="$phase_name = 'XPRAS_SHD_AIMMERGE'">-UT</xsl:when>
                  <xsl:when test="$phase_name = 'XPRAS_AIMMRG'"></xsl:when>
                  <xsl:otherwise>NO</xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:variable name="xpras_aim_addtitle">
                <xsl:choose>
                  <xsl:when test="$phase_name = 'XPRAS_SHD_AIMMERGE'"> during Uptime</xsl:when>
                  <xsl:when test="$phase_name = 'XPRAS_AIMMRG'"></xsl:when>
                  <xsl:otherwise></xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:variable name="xpras_show">
                <xsl:choose>
                  <xsl:when test="$xpras_aim_phase = 'NO'">NO</xsl:when>
                  <xsl:when test="count(../../executions[@type=concat('XPRAS',$xpras_aim_phase)]/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">YES</xsl:when>
                  <xsl:otherwise>NO</xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:variable name="xclas_show">
                <xsl:choose>
                  <xsl:when test="$xpras_aim_phase = 'NO'">NO</xsl:when>
                  <xsl:when test="count(../../executions[@type=concat('XCLAS',$xpras_aim_phase)]/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">YES</xsl:when>
                  <xsl:otherwise>NO</xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:variable name="aim_show">
                <xsl:choose>
                  <xsl:when test="$xpras_aim_phase = 'NO'">NO</xsl:when>
                  <xsl:when test="count(../../executions[@type=concat('AFTIMP',$xpras_aim_phase)]/execution[number(@time) &gt;= $cutofftime or @aborts &gt; 0]) &gt; 0">YES</xsl:when>
                  <xsl:otherwise>NO</xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:variable name="xpras_aim_title">
                <xsl:choose>
                  <xsl:when test="$xpras_show = 'YES' and $xclas_show = 'YES' and $aim_show = 'YES'">XCLAS, XPRAS and After Import Methods</xsl:when>
                  <xsl:when test="$xpras_show = 'YES' and $aim_show = 'YES'">XPRAS and After Import Methods</xsl:when>
                  <xsl:when test="$xclas_show = 'YES' and $aim_show = 'YES'">XCLAS and After Import Methods</xsl:when>
                  <xsl:when test="$xpras_show = 'YES' and $xclas_show = 'YES'">XPRAS and XCLAS</xsl:when>
                  <xsl:when test="$xpras_show = 'YES'">XPRAS</xsl:when>
                  <xsl:when test="$xclas_show = 'YES'">XCLAS</xsl:when>
                  <xsl:when test="$aim_show = 'YES'">After Import Methods</xsl:when>
                  <xsl:otherwise></xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:choose>
                <xsl:when test="$xpras_aim_phase != 'NO'">
                  <div class="tableRow">
                    <div class="{concat($class_prefix, 'p')} tableCell tableRowTitle">
                      <xsl:if test="$xpras_show = 'YES' or $xclas_show = 'YES' or$aim_show = 'YES'">
                        <xsl:call-template name="mkjstag" />
                      </xsl:if>
                      <a name="pl-xpraaimlist{$xpras_aim_phase}" />
                      <xsl:value-of select="$phase_name" />
                    </div>
                    <div class="{$class_prefix} tableCell">
                      <xsl:choose>
                        <xsl:when test="@time != ''">
                          <xsl:call-template name="seconds-to-time">
                            <xsl:with-param name="seconds" select="@time" />
                          </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>0:00:00</xsl:otherwise>
                      </xsl:choose>
                      <xsl:if test="@dialogs = 'yes'">+ dialogs</xsl:if>
                    </div>
                    <div class="{$class_prefix} tableCell">
                      <xsl:value-of select="@runs" />
                    </div>
                    <div class="{$class_prefix} tableCell">
                      <xsl:value-of select="@failed" />
                    </div>
                  </div>
                  <xsl:if test="$xpras_show = 'YES' or $xclas_show = 'YES' or $aim_show = 'YES'">
                    <div class="tableRow">
                      <div class="phm tableCell title">
                        <xsl:value-of select="concat($xpras_aim_title,$xpras_aim_addtitle)" /> (Cutoff Time: <xsl:value-of select="$cutofftime" />s)</div>
                    </div>
                    <xsl:call-template name="show-executions">
                      <xsl:with-param name="exectype" select="concat('XPRAS',$xpras_aim_phase)" />
                      <xsl:with-param name="exectype2" select="concat('XCLAS',$xpras_aim_phase)" />
                      <xsl:with-param name="exectype3" select="concat('AFTIMP',$xpras_aim_phase)" />
                      <xsl:with-param name="treepos" select="../.." />
                      <xsl:with-param name="cutofftime2" select="$cutofftime" />
                    </xsl:call-template>
                    <div class="tableRow">
                      <div class="tableCell">
                        <xsl:call-template name="NBSPC" />
                      </div>
                      <div class="tableCell">
                        <xsl:call-template name="NBSPC" />
                      </div>
                      <div class="tableCell">
                        <xsl:call-template name="NBSPC" />
                      </div>
                      <div class="tableCell">
                        <xsl:call-template name="NBSPC" />
                      </div>
                    </div>
                    <div class="tableRow">
                      <div class="{concat($class_prefix, 'p')} tableCell stop" />
                    </div>
                  </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                  <div class="tableRow">
                    <div class="{concat($class_prefix, 'p')} tableCell">
                      <xsl:value-of select="$phase_name" />
                    </div>
                    <div class="{$class_prefix} tableCell">
                      <xsl:choose>
                        <xsl:when test="@time != ''">
                          <xsl:call-template name="seconds-to-time">
                            <xsl:with-param name="seconds" select="@time" />
                          </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>0:00:00</xsl:otherwise>
                      </xsl:choose>
                      <xsl:if test="@dialogs = 'yes'">+ dialogs</xsl:if>
                    </div>
                    <div class="{$class_prefix} tableCell">
                      <xsl:value-of select="@runs" />
                    </div>
                    <div class="{$class_prefix} tableCell">
                      <xsl:value-of select="@failed" />
                    </div>
                  </div>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
          </xsl:choose>
        </xsl:for-each>
      </div>
    </xsl:for-each>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-executions">
    <xsl:param name="exectype" />
    <xsl:param name="exectype2" />
    <xsl:param name="exectype3" />
    <xsl:param name="cutofftime2" />
    <xsl:param name="total" />
    <xsl:param name="treepos" />
    <xsl:param name="showheader" />
    <xsl:param name="showmodrecords" />
    <xsl:variable name="section" select="$treepos/executions[@type=$exectype or @type=$exectype2 or @type=$exectype3]/execution" />
    <xsl:variable name="showmodrecs" select="sum($section/@records_read) + sum($section/@records_modified)" />
    <div class="tableRow">
      <div class="hidden totalTime">
        <xsl:choose>
          <xsl:when test="$total != ''">
            <xsl:value-of select="$total" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="sum($section/@time)" />
          </xsl:otherwise>
        </xsl:choose>
      </div>
    </div>
    <xsl:if test="$showheader = '' or $showheader = 'YES'">
      <div class="tableRow">
        <div class="php tableCell">Name</div>
        <div class="ph tableCell">Time</div>
        <div class="ph tableCell">Runs</div>
        <div class="ph tableCell">Aborts</div>
        <xsl:if test="$showmodrecords = 'YES' and $showmodrecs != 0">
          <div class="ph tableCell">Modified / read data records</div>
        </xsl:if>
      </div>
    </xsl:if>
    <xsl:for-each select="$section">
      <!-- validating time because time attribute is not stated everytime -->
      <xsl:sort select="@time" order="descending" data-type="number" />
      <xsl:variable name="validatedTime">
        <xsl:call-template name="timevalidation">
          <xsl:with-param name="time" select="@time" />
        </xsl:call-template>
      </xsl:variable>
      <xsl:if test="number($validatedTime) &gt;= $cutofftime2 or @aborts &gt; 0">
        <div class="tableRow">
          <xsl:variable name="class_prefix">
            <xsl:choose>
              <xsl:when test="@failed != 0">xa</xsl:when>
              <xsl:otherwise>xb</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:variable name="exec_name">
            <xsl:choose>
              <xsl:when test="@name != ''">
                <xsl:value-of select="@name" />
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="@component" />
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <div class="{concat($class_prefix, 'p')} tableCell">
            <xsl:value-of select="$exec_name" />
          </div>
          <div class="{$class_prefix} tableCell timeStatement">
            <xsl:call-template name="seconds-to-time">
              <xsl:with-param name="seconds" select="@time" />
            </xsl:call-template>
          </div>
          <div class="{$class_prefix} tableCell">
            <xsl:value-of select="@runs" />
          </div>
          <div class="{$class_prefix} tableCell">
                    <xsl:if test="@aborts != '-1'">
              <xsl:value-of select="@aborts" />
                        </xsl:if>
          </div>
          <xsl:if test="$showmodrecords = 'YES' and $showmodrecs != 0">
            <div class="{$class_prefix} tableCell">
              <xsl:choose>
                <xsl:when test="@records_modified != ''">
                  <xsl:value-of select="@records_modified" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="@records_read != ''">
                    0 <!-- if records read are given, records modified is 0, also if not given -->
                  </xsl:if>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:choose>
                <xsl:when test="@records_read != ''">
                  / <xsl:value-of select="@records_read" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:if test="@records_modified != ''">
                    / ?
                  </xsl:if>
                </xsl:otherwise>
              </xsl:choose>
            </div>
          </xsl:if>
        </div>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-tabsizes">
    <xsl:param name="treepos" />
    <xsl:param name="cutoff" />
    <div class="tableRow">
      <div class="php tableCell">Name</div>
      <div class="ph tableCell">Size</div>
    </div>
    <xsl:for-each select="$treepos/tabsizes/table[number(@size) &gt;= $cutoff]">
      <xsl:sort select="@size" order="descending" data-type="number" />
      <xsl:variable name="realsize">
        <xsl:call-template name="format-size">
          <xsl:with-param name="size" select="@size" />
          <xsl:with-param name="unit" select="$sizesrcunit" />
          <xsl:with-param name="targetunit" select="$sizeunit" />
        </xsl:call-template>
      </xsl:variable>
      <div class="tableRow">
        <div class="xbp tableCell">
          <xsl:value-of select="@name" />
        </div>
        <div class="xb tableCell">
          <xsl:value-of select="concat(concat($realsize, ' '),$sizeunit)" />
        </div>
      </div>
    </xsl:for-each>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="show-mplstats">
    <xsl:param name="exectype" />
    <xsl:param name="cutofftime2" />
    <xsl:variable name="clients" select="configuration[@group='System']/configuration[@group='Clients']/client" />
    <div>
      <div class="tableRow">
        <div class="php tableCell">
          <xsl:call-template name="NBSPC" />
        </div>
        <xsl:for-each select="$clients">
          <div align="center" class="php tableCell">Client: <xsl:value-of select="." /></div>
        </xsl:for-each>
      </div>
      <xsl:for-each select="executions[@type=$exectype]/execution">
        <xsl:variable name="runs" select="." />
        <!-- validating time because time attribute is not stated everytime -->
        <xsl:variable name="validatedTime">
          <xsl:call-template name="timevalidation">
            <xsl:with-param name="time" select="@time" />
          </xsl:call-template>
        </xsl:variable>
        <xsl:if test="number($validatedTime) &gt;= $cutofftime2 or @aborts &gt; 0">
          <xsl:variable name="repname" select="@name" />
          <div class="tableRow">
            <div class="hdb tableCell" width="20%">
              <xsl:value-of select="$repname" />
            </div>
            <xsl:for-each select="$clients">
              <xsl:variable name="client" select="." />
              <xsl:variable name="nrruns" select="count($runs/run[@client=$client])" />
              <xsl:variable name="errors" select="$runs/run[@client=$client]/@errors" />
              <xsl:variable name="aborted" select="$runs/run[@client=$client]/@aborted" />
              <xsl:variable name="seconds" select="sum($runs/run[@client=$client]/@seconds)" />
              <xsl:variable name="class_prefix">
                <xsl:choose>
                  <xsl:when test="$errors != 0 or $aborted != 'yes'">pa</xsl:when>
                  <xsl:otherwise>pb</xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <div align="center" class="{$class_prefix} tableCell">
                <xsl:call-template name="seconds-to-time">
                  <xsl:with-param name="seconds" select="$seconds" />
                </xsl:call-template>
                <xsl:choose>
                  <xsl:when test="$seconds != 0">
                    <xsl:if test="$nrruns &gt; 1">
                      <xsl:value-of select="$nrruns" /> runs
                    </xsl:if>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="NBSPC" />
                  </xsl:otherwise>
                </xsl:choose>
              </div>
            </xsl:for-each>
          </div>
        </xsl:if>
      </xsl:for-each>
    </div>
  </xsl:template>
  <!-- ******************************************************************* -->
  <!-- ************************ helper templates ************************* -->
  <!-- ******************************************************************* -->
  <xsl:template name="format-date">
    <xsl:param name="D" />
    <!-- quick and dirty formatting
         20050405115050 = 2005/04/05 11:50:50
    -->
    <xsl:value-of select="concat (substring($D, 1, 4), '/', substring($D, 5, 2), '/', substring($D, 7, 2), ' ', substring($D, 9, 2), ':', substring($D, 11, 2), ':', substring($D, 13, 2))" />
  </xsl:template>

  <xsl:template name="format-various-dates">
    <xsl:param name="Date" />
    <!-- understands the following formats now:
20160305115050               = 2016/03/14 11:50:50  (1)
11:50:50 Mar 14 2016         = 2016/03/14 11:50:50  (2)
2016-03-14 11:50:50          = 2016/03/14 11:50:50  (3)
2016/03/14 11:50:50          = 2016/03/14 11:50:50  (3)
Mon Mar 14 11:50:50 CET 2016 = 2016/03/14 11:50:50  (4)
Mar 14 2016 11:50:50         = 2016/03/14 11:50:50  (5)
14.03.16                     = 2016/03/14           (6)
    -->
    <xsl:variable name="D"><xsl:value-of select="normalize-space($Date)" /></xsl:variable>

    <xsl:variable name="format_type"><xsl:choose>
        <xsl:when test="string-length($D) = 14">1</xsl:when>
        <xsl:when test="string-length($D) = 27">4a</xsl:when>
        <xsl:when test="string-length($D) = 28 and substring($D,10,1) = ' '">4c</xsl:when>
        <xsl:when test="string-length($D) = 28">4b</xsl:when>
        <xsl:when test="string-length($D) = 29">4d</xsl:when>
        <xsl:when test="string-length($D) = 19 and number(substring($D,1,4)) > 1900">3</xsl:when>
        <xsl:when test="string-length($D) = 18"><xsl:choose>
            <xsl:when test="number(substring($D,4,1)) > 0 and substring($D,5,1) = ' '">5c</xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose></xsl:when>
        <xsl:when test="string-length($D) = 19"><xsl:choose>
            <xsl:when test="number(substring($D,1,2)) > 0 and substring($D,3,1) = ':'">2a</xsl:when>
            <xsl:when test="number(substring($D,5,2)) > 0 and substring($D,4,1) = ' '">5a</xsl:when>
            <xsl:when test="number(substring($D,4,2)) > 0 and substring($D,6,1) = ' '">5d</xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose></xsl:when>
        <xsl:when test="string-length($D) = 20"><xsl:choose>
            <xsl:when test="number(substring($D,1,2)) > 0 and substring($D,3,1) = ':'">2b</xsl:when>
            <xsl:when test="number(substring($D,5,2)) > 0 and substring($D,4,1) = ' '">5b</xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
         </xsl:choose></xsl:when>
        <xsl:when test="string-length($D) = 8">6</xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose></xsl:variable>

    <xsl:variable name="year"><xsl:choose>
        <xsl:when test="$format_type = '1' and number(substring($D,1,4)) > 1900"><xsl:value-of select="substring($D,1,4)" /></xsl:when>
        <xsl:when test="$format_type = '2a' and number(substring($D,16,4)) > 1900"><xsl:value-of select="substring($D,16,4)" /></xsl:when>
        <xsl:when test="$format_type = '2b' and number(substring($D,17,4)) > 1900"><xsl:value-of select="substring($D,17,4)" /></xsl:when>
        <xsl:when test="$format_type = '3' and number(substring($D,1,4)) > 1900"><xsl:value-of select="substring($D,1,4)" /></xsl:when>
        <xsl:when test="$format_type = '4a' and number(substring($D,24,4)) > 1900"><xsl:value-of select="substring($D,24,4)" /></xsl:when>
        <xsl:when test="($format_type = '4b' or $format_type = '4c') and number(substring($D,25,4)) > 1900"><xsl:value-of select="substring($D,25,4)" /></xsl:when>
        <xsl:when test="$format_type = '4d' and number(substring($D,26,4)) > 1900"><xsl:value-of select="substring($D,26,4)" /></xsl:when>
        <xsl:when test="$format_type = '5a' and number(substring($D,7,4)) > 1900"><xsl:value-of select="substring($D,7,4)" /></xsl:when>
        <xsl:when test="$format_type = '5b' and number(substring($D,8,4)) > 1900"><xsl:value-of select="substring($D,8,4)" /></xsl:when>
        <xsl:when test="$format_type = '5c' and number(substring($D,6,4)) > 1900"><xsl:value-of select="substring($D,6,4)" /></xsl:when>
        <xsl:when test="$format_type = '5d' and number(substring($D,7,4)) > 1900"><xsl:value-of select="substring($D,7,4)" /></xsl:when>
        <xsl:when test="$format_type = '6' and number(substring($D,7,2)) > 0">20<xsl:value-of select="substring($D,7,2)" /></xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose></xsl:variable>

    <xsl:variable name="month"><xsl:choose>
        <xsl:when test="$format_type = '1' and number(substring($D,5,2)) > 0"><xsl:value-of select="substring($D,5,2)" /></xsl:when>
        <xsl:when test="substring($format_type,1,1) = '2'"><xsl:call-template name="convert-month"><xsl:with-param name="month" select="substring($D,10,3)" /></xsl:call-template></xsl:when>
        <xsl:when test="$format_type = '3' and number(substring($D,6,2)) &gt; 0 and number(substring($D,6,2)) &lt; 13"><xsl:value-of select="substring($D,6,2)" /></xsl:when>
        <xsl:when test="substring($format_type,1,1) = '4'"><xsl:call-template name="convert-month"><xsl:with-param name="month" select="substring($D,5,3)" /></xsl:call-template></xsl:when>
        <xsl:when test="substring($format_type,1,1) = '5'"><xsl:call-template name="convert-month"><xsl:with-param name="month" select="substring($D,1,3)" /></xsl:call-template></xsl:when>
        <xsl:when test="$format_type = '6' and number(substring($D,4,2)) > 0"><xsl:value-of select="substring($D,4,2)" /></xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose></xsl:variable>

    <xsl:variable name="day"><xsl:choose>
        <xsl:when test="$format_type = '1' and number(substring($D,7,2)) > 0"><xsl:value-of select="substring($D,7,2)" /></xsl:when>
        <xsl:when test="$format_type = '2a' and number(substring($D,14,1)) > 0">0<xsl:value-of select="substring($D,14,1)" /></xsl:when>
        <xsl:when test="$format_type = '2b' and number(substring($D,14,2)) > 0"><xsl:value-of select="substring($D,14,2)" /></xsl:when>
        <xsl:when test="$format_type = '3' and number(substring($D,9,2)) > 0"><xsl:value-of select="substring($D,9,2)" /></xsl:when>
        <xsl:when test="($format_type = '4a' or $format_type = '4c') and number(substring($D,9,1)) > 0">0<xsl:value-of select="substring($D,9,1)" /></xsl:when>
        <xsl:when test="($format_type = '4b' or $format_type = '4d') and number(substring($D,9,2)) > 0"><xsl:value-of select="substring($D,9,2)" /></xsl:when>
        <xsl:when test="$format_type = '5a' and number(substring($D,5,1)) > 0">0<xsl:value-of select="substring($D,5,1)" /></xsl:when>
        <xsl:when test="$format_type = '5b' and number(substring($D,5,2)) > 0"><xsl:value-of select="substring($D,5,2)" /></xsl:when>
        <xsl:when test="$format_type = '5c' and number(substring($D,4,1)) > 0">0<xsl:value-of select="substring($D,4,1)" /></xsl:when>
        <xsl:when test="$format_type = '5d' and number(substring($D,4,2)) > 0"><xsl:value-of select="substring($D,4,2)" /></xsl:when>
        <xsl:when test="$format_type = '6' and number(substring($D,1,2)) > 0"><xsl:value-of select="substring($D,1,2)" /></xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose></xsl:variable>

    <xsl:variable name="hours"><xsl:choose>
        <xsl:when test="$format_type = '1' and number(substring($D,9,2)) > 0"><xsl:value-of select="substring($D,9,2)" /></xsl:when>
        <xsl:when test="substring($format_type,1,1) = '2' and number(substring($D,1,2)) > 0"><xsl:value-of select="substring($D,1,2)" /></xsl:when>
        <xsl:when test="$format_type = '3' and number(substring($D,12,2)) > 0"><xsl:value-of select="substring($D,12,2)" /></xsl:when>
        <xsl:when test="($format_type = '4a' or $format_type = '4c') and number(substring($D,11,2)) > 0"><xsl:value-of select="substring($D,11,2)" /></xsl:when>
        <xsl:when test="($format_type = '4b' or $format_type = '4d') and number(substring($D,12,2)) > 0"><xsl:value-of select="substring($D,12,2)" /></xsl:when>
        <xsl:when test="$format_type = '5a'"><xsl:choose><xsl:when test="number(substring($D,12,2)) > 0"><xsl:value-of select="substring($D,12,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:when test="$format_type = '5b'"><xsl:choose><xsl:when test="number(substring($D,13,2)) > 0"><xsl:value-of select="substring($D,13,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:when test="$format_type = '5c'"><xsl:choose><xsl:when test="number(substring($D,11,2)) > 0"><xsl:value-of select="substring($D,11,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:when test="$format_type = '5d'"><xsl:choose><xsl:when test="number(substring($D,12,2)) > 0"><xsl:value-of select="substring($D,12,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:otherwise>00</xsl:otherwise>
      </xsl:choose></xsl:variable>

    <xsl:variable name="minutes"><xsl:choose>
        <xsl:when test="$format_type = '1' and number(substring($D,11,2)) > 0"><xsl:value-of select="substring($D,11,2)" /></xsl:when>
        <xsl:when test="substring($format_type,1,1) = '2' and number(substring($D,4,2)) > 0"><xsl:value-of select="substring($D,4,2)" /></xsl:when>
        <xsl:when test="$format_type = '3' and number(substring($D,15,2)) > 0"><xsl:value-of select="substring($D,15,2)" /></xsl:when>
        <xsl:when test="($format_type = '4a' or $format_type = '4c') and number(substring($D,14,2)) > 0"><xsl:value-of select="substring($D,14,2)" /></xsl:when>
        <xsl:when test="($format_type = '4b' or $format_type = '4d') and number(substring($D,15,2)) > 0"><xsl:value-of select="substring($D,15,2)" /></xsl:when>
        <xsl:when test="$format_type = '5a'"><xsl:choose><xsl:when test="number(substring($D,15,2)) > 0"><xsl:value-of select="substring($D,15,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:when test="$format_type = '5b'"><xsl:choose><xsl:when test="number(substring($D,16,2)) > 0"><xsl:value-of select="substring($D,16,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:when test="$format_type = '5c'"><xsl:choose><xsl:when test="number(substring($D,14,2)) > 0"><xsl:value-of select="substring($D,14,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:when test="$format_type = '5d'"><xsl:choose><xsl:when test="number(substring($D,15,2)) > 0"><xsl:value-of select="substring($D,15,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:otherwise>00</xsl:otherwise>
      </xsl:choose></xsl:variable>

    <xsl:variable name="seconds"><xsl:choose>
        <xsl:when test="$format_type = '1' and number(substring($D,13,2)) > 0"><xsl:value-of select="substring($D,13,2)" /></xsl:when>
        <xsl:when test="substring($format_type,1,1) = '2' and number(substring($D,7,2)) > 0"><xsl:value-of select="substring($D,7,2)" /></xsl:when>
        <xsl:when test="$format_type = '3' and number(substring($D,18,2)) > 0"><xsl:value-of select="substring($D,18,2)" /></xsl:when>
        <xsl:when test="($format_type = '4a' or $format_type = '4c') and number(substring($D,17,2)) > 0"><xsl:value-of select="substring($D,17,2)" /></xsl:when>
        <xsl:when test="($format_type = '4b' or $format_type = '4d') and number(substring($D,18,2)) > 0"><xsl:value-of select="substring($D,18,2)" /></xsl:when>
        <xsl:when test="$format_type = '5a'"><xsl:choose><xsl:when test="number(substring($D,18,2)) > 0"><xsl:value-of select="substring($D,18,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:when test="$format_type = '5b'"><xsl:choose><xsl:when test="number(substring($D,19,2)) > 0"><xsl:value-of select="substring($D,19,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:when test="$format_type = '5c'"><xsl:choose><xsl:when test="number(substring($D,17,2)) > 0"><xsl:value-of select="substring($D,17,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:when test="$format_type = '5d'"><xsl:choose><xsl:when test="number(substring($D,18,2)) > 0"><xsl:value-of select="substring($D,18,2)" /></xsl:when><xsl:otherwise>00</xsl:otherwise></xsl:choose></xsl:when>
        <xsl:otherwise>00</xsl:otherwise>
      </xsl:choose></xsl:variable>

    <xsl:variable name="dotransform"><xsl:choose>
        <xsl:when test="$format_type != '0' and $year != '0' and $month != '0' and $day != '0' and ($hours != '00' or $minutes != '00' or $seconds != '00')">1</xsl:when>
        <xsl:when test="$format_type != '0' and $year != '0' and $month != '0' and $day != '0'">2</xsl:when>
        <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose></xsl:variable>
    <xsl:choose>
      <xsl:when test="$dotransform = '1'"><xsl:value-of select="concat ($year, '/', $month, '/', $day, ' ', $hours, ':', $minutes, ':', $seconds)" /></xsl:when>
      <xsl:when test="$dotransform = '2'"><xsl:value-of select="concat ($year, '/', $month, '/', $day)" /></xsl:when>
      <xsl:otherwise><xsl:value-of select="$D" /></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="convert-month"><xsl:param name="month" /><xsl:choose>
      <xsl:when test="$month = 'Jan'">01</xsl:when>
      <xsl:when test="$month = 'Feb'">02</xsl:when>
      <xsl:when test="$month = 'Mar'">03</xsl:when>
      <xsl:when test="$month = 'Apr'">04</xsl:when>
      <xsl:when test="$month = 'May'">05</xsl:when>
      <xsl:when test="$month = 'Jun'">06</xsl:when>
      <xsl:when test="$month = 'Jul'">07</xsl:when>
      <xsl:when test="$month = 'Aug'">08</xsl:when>
      <xsl:when test="$month = 'Sep'">09</xsl:when>
      <xsl:when test="$month = 'Oct'">10</xsl:when>
      <xsl:when test="$month = 'Nov'">11</xsl:when>
      <xsl:when test="$month = 'Dec'">12</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose></xsl:template>

  <!-- ******************************************************************* -->
  <xsl:template name="seconds-to-time">
    <xsl:param name="seconds" />
    <xsl:choose>
      <xsl:when test="'$seconds' = ''">
        <xsl:value-of select="'-'" />
      </xsl:when>
      <xsl:when test="'$seconds' = 0">
        <xsl:value-of select="'0.0'" />
      </xsl:when>
      <xsl:otherwise>
        <!-- (jo) Sequence matters!  -->
        <xsl:variable name="minu">
          <xsl:value-of select="floor(number($seconds) div 60)" />
        </xsl:variable>
        <xsl:variable name="seconds2">
          <xsl:value-of select="format-number(floor(number($seconds) - 60 * $minu), '00')" />
        </xsl:variable>
        <xsl:variable name="hours">
          <xsl:value-of select="floor($minu div 60)" />
        </xsl:variable>
        <xsl:variable name="minutes">
          <xsl:value-of select="format-number(floor($minu - 60 * $hours), '00')" />
        </xsl:variable>
        <xsl:value-of select="concat ($hours, ':', $minutes, ':', $seconds2)" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- ******************************************************************* -->

  <xsl:template name="format-size">
    <xsl:param name="size" />
    <xsl:param name="unit" />
    <xsl:param name="targetunit" />
    <xsl:variable name="factor"><xsl:call-template name="calculate-size-factor"><xsl:with-param name="unit" select="$unit" /><xsl:with-param name="targetunit" select="$targetunit" /></xsl:call-template></xsl:variable>
    <xsl:variable name="realsize"><xsl:value-of select="number($size) div number($factor)" /></xsl:variable>
    <xsl:value-of select="format-number(number($realsize),'#,##0.000')" />
  </xsl:template>

  <xsl:template name="calculate-size-factor">
    <xsl:param name="unit" />
    <xsl:param name="targetunit" />
    <xsl:variable name="in"><xsl:call-template name="get-size-unit-int"><xsl:with-param name="unit" select="$unit" /></xsl:call-template></xsl:variable>
    <xsl:variable name="out"><xsl:call-template name="get-size-unit-int"><xsl:with-param name="unit" select="$targetunit" /></xsl:call-template></xsl:variable>
    <xsl:value-of select="number($out) div number($in)" />
  </xsl:template>

  <xsl:template name="get-size-unit-int">
    <xsl:param name="unit" />
    <xsl:choose>
      <xsl:when test="$unit = 'KB'">1024</xsl:when>
      <xsl:when test="$unit = 'MB'">1048576</xsl:when>
      <xsl:when test="$unit = 'GB'">1073741824</xsl:when>
      <xsl:when test="$unit = 'TB'">1099511627776</xsl:when>
      <xsl:otherwise>1</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- ******************************************************************* -->

  <xsl:template name="format-PL">
    <xsl:param name="PL" />
    <!--
       "0" = 0000
       "0000000000" = 0000
       "" = -
    -->
    <xsl:choose>
      <xsl:when test="$PL=''">
        <xsl:value-of select="'-'" />
      </xsl:when>
      <xsl:when test="number($PL)=0">
        <xsl:value-of select="'0000'" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$PL" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- ******************************************************************* -->
  <!-- (jo)  -->
  <xsl:template name="format-phasename">
    <xsl:param name="name" />
    <xsl:variable name="name2">
      <xsl:choose>
        <xsl:when test="substring($name, 1, 6) = 'Phase.'">
          <xsl:value-of select="substring($name, 7)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$name" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="name3">
      <xsl:choose>
        <xsl:when test="substring($name2, 1, 8) = 'Prepare/'">
          <xsl:value-of select="substring($name2, 9)" />
        </xsl:when>
        <xsl:when test="substring($name2, 1, 8) = 'Upgrade/'">
          <xsl:value-of select="substring($name2, 9)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$name2" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="$name3" />
  </xsl:template>
  <!-- ******************************************************************* -->
  <!-- (jo)  -->
  <xsl:template name="get-phasegroup-name">
    <xsl:param name="name" />
    <xsl:choose>
      <xsl:when test="$name = 'INIT'">Configuration and Initialization</xsl:when>
      <xsl:when test="$name = 'EUIM'">Import and Modification Transfer</xsl:when>
      <xsl:when test="$name = 'SHDINST'">Shadow System Installation</xsl:when>
      <xsl:when test="$name = 'SHADOW'">Shadow System Operations: SPDD and Activation</xsl:when>
      <xsl:when test="$name = 'SHDIM'">Shadow Import</xsl:when>
      <xsl:when test="$name = 'SWITCH'">Downtime phases I: Switch tables and Kernel</xsl:when>
      <xsl:when test="$name = 'NEWBAS'">Downtime phases II: Conversion, Main Import, XPRAs</xsl:when>
      <xsl:when test="$name = 'POSTP'">Post Processing</xsl:when>
      <xsl:otherwise>$name</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- ******************************************************************* -->
  <xsl:template name="NBSPC">
    <xsl:text disable-output-escaping="yes">&amp;</xsl:text>nbsp;
  </xsl:template>
  <xsl:template name="timevalidation">
    <xsl:param name="time" />
    <!-- validating time because time attribute is not stated everytime -->
    <xsl:choose>
      <xsl:when test="$time != ''">
        <xsl:value-of select="$time" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="0" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
