
var pages = [false, true];
var url = ["../analysis/SUMOBSERVER.XML", "../analysis/SUMDIALOG.XML"];
var title = ["SUM ABAP Observer Monitor"];
var progrTitle = ["Overall progress"];
var lastState = [""];
var fastPolls = 20;
var fastPollCountDn = [fastPolls, fastPolls];
var last_diagtime = ""; 
/* ** SUM 1.0 also supported JAVA Stack **
var pages = [false, false];
var url = ["../analysis/SUMOBSERVER.XML", "../analysis/SUMJAVAOBSERVER.XML"];
var title = ["SUM ABAP Observer Monitor", "SUM JAVA Observer Monitor"];
var progrTitle = ["Overall progress", "Progress of roadmap step \"<RDMPSTP>\""];
var lastState = ["", ""];
var fastPollCountDn = [fastPolls, fastPolls];
*/


//this is to extend the Array functionality by the .find() method which might be missing in some (silly) browsers
if (typeof Array.prototype.find !== 'function') {
	Array.prototype.find = function(funct) {
		var array = Object(this);
		for (var i = 0; i < array.length; i++) if (funct.call(arguments[1], array[i], i, array)) return array[i];
		return undefined;
	};
}

function xmlToJson(xml) {

    // Create the return object
    var obj = {};

    if (xml.nodeType == 1) { // element
        // do attributes
        if (xml.attributes.length > 0) {
            obj["@attributes"] = {};
            for (var j = 0; j < xml.attributes.length; j++) {
                var attribute = xml.attributes.item(j);
                obj["@attributes"][attribute.nodeName] = attribute.nodeValue;
            }
        }
    } else if (xml.nodeType == 3) { // text
        obj = xml.nodeValue;
    }

    // do children
    if (xml.hasChildNodes()) {
        for (var i = 0; i < xml.childNodes.length; i++) {
            var item = xml.childNodes.item(i);
            var nodeName = item.nodeName;
            if (typeof (obj[nodeName]) == "undefined") {
                obj[nodeName] = xmlToJson(item);
            } else {
                if (typeof (obj[nodeName].push) == "undefined") {
                    var old = obj[nodeName];
                    obj[nodeName] = [];
                    obj[nodeName].push(old);
                }
                obj[nodeName].push(xmlToJson(item));
            }
        }
    }
    return obj;
}


function parseFile(xml, target)
{
    var obj = xmlToJson(xml);
    //alert(JSON.stringify(obj));
	if (obj["monitor"]["Task"][0] === undefined) {var help = obj["monitor"]["Task"]; obj["monitor"]["Task"] = []; obj["monitor"]["Task"][0] = help;}
    var taskState = obj["monitor"]["Task"][0]["status"]["#text"];
    var viewState = "";
    if ((taskState === "slp.task.state.ERROR") || (taskState === "slp.task.state.ABORTED"))
    {
        target.setState(sap.ui.core.ValueState.Error);
        viewState = "Error";
    }
    else if (taskState === "slp.task.state.DIALOG")
    {
        target.setState(sap.ui.core.ValueState.Warning);
        viewState = "DIALOG";
    }
    else if (taskState === "slp.task.state.RUNNING")
    {
        target.setState(sap.ui.core.ValueState.Success);
        viewState = "RUNNING";
    }
    else if (taskState === "slp.task.state.INITIAL")
    {
        target.setState(sap.ui.core.ValueState.Success);
        viewState = "INITIAL";
    }
    else if (taskState === "slp.task.state.FINISHED")
    {
        target.setState(sap.ui.core.ValueState.Success);
        viewState = "FINISHED";
    }
    else
    {
        target.setState(sap.ui.core.ValueState.None);
        viewState = taskState;
    }
    return {Object: obj, State: viewState};
}

function mStatus(mState) {
    switch (mState) {
        case "slp.task.state.ABORTED":
            return "Process has aborted";
        case "slp.task.state.FINISHED":
            return "Process has finished";
        case "slp.task.state.ERROR":
            return "Process stopped with error";
        case "slp.task.state.RUNNING":
            return "Process is running";
        case "slp.task.state.DIALOG":
            return "Process is in a dialog";
        case "slp.task.state.INITIAL":
            return "Process is initial";
        case "slp.task.state.ACTION_REQUIRED":
            return "Process stopped with 'action required'";
        case "slp.task.state.BREAKPOINT":
            return "Process reached breakpoint";
        default:     
            return "Process is in an unknown state";
    }
}


function buildPage() {

/*	Panel1: Overall Progress     */
	var progressIndicatorObj = new sap.m.ProgressIndicator({
        percentValue: 0,
        displayValue: progrTitle[0] + ": Unknown",
        showValue: true,
        state: sap.ui.core.ValueState.None
    });
    var pan1 = new sap.m.Panel({
        width: "auto",
        expandable: true,
        expanded: true,
        headerText: progrTitle[0],
        content: [progressIndicatorObj]
    });

/*  Panel2: Current Status        */
    var toolbarObj = new sap.m.Toolbar({
        height: "3rem",
        content: [
            new sap.m.Text({text: "Current Status"}),
            new sap.ui.core.Icon({
                //src: sap.ui.core.IconPool.getIconURI("message-warning"),
                size: "27px",
                width: "40px"
            })
        ]
    });
    var pan2 = new sap.m.Panel({
        width: "auto",
        expandable: true,
        expanded: true,
        headerToolbar: toolbarObj,
        content: [
            new sap.m.Text({text: "Unknown"})
        ]
    });

/*  Panel3: Current Phase           */
    var toolbarObj2 = new sap.m.Toolbar({
        height: "3rem",
        content: [
            new sap.m.Text({text: "Current Phase"}),
            new sap.ui.core.Icon({
                //src: sap.ui.core.IconPool.getIconURI("message-warning"),
                size: "27px",
                width: "40px"
            })
        ]
    });
    var pan3 = new sap.m.Panel({
        width: "auto",
        expandable: true,
        expanded: true,
        headerToolbar: toolbarObj2,
        content: [
            new sap.m.Text({text: "Unknown"})
        ]
    });

/*  Panel4: Troubleticket (optional)    */
    var toolbarObj3 = new sap.m.Toolbar({
        height: "3rem",
        content: [
            new sap.m.Text({text: "Troubleticket"}),
			new sap.m.Button({
						icon: "sap-icon://download",
						tooltip: ["Download SAPup_troubleticket.zip"],
						press: function() {
							var that = {};
							that.file = "SAPup_troubleticket.zip";
							var xhr = new XMLHttpRequest(); 
							xhr.open("GET", "../analysis/SAPup_troubleticket.zip"); 
							xhr.responseType = "blob";
							xhr.onload = $.proxy(function() { 
								if (window.navigator.msSaveOrOpenBlob) window.navigator.msSaveBlob(xhr.response, this.file);
								else {
									var elem = window.document.createElement('a');
									elem.href = window.URL.createObjectURL(xhr.response);
									elem.download = this.file;        
									document.body.appendChild(elem);
									elem.click();        
									document.body.removeChild(elem);
								}    		
							}, that);
							xhr.send();          	
						}
			}).addStyleClass("sapUiSizeCompact")
        ]
    });
    var pan4 = new sap.m.Panel({
        width: "auto",
        visible: false,
        expandable: true,
        expanded: false,
        headerToolbar: toolbarObj3,
        content: [
            new sap.m.Text().addStyleClass("monospc")
        ]
    });

/*  Panel5: SAPUI5 Logo or last Dialog      */
    var toolbarObj4 = new sap.m.Toolbar({
        height: "3rem",
        content: [
            new sap.m.Text("idDlgText"),
            new sap.m.Text("idDiagtime"),
            new sap.ui.core.Icon({
                //src: sap.ui.core.IconPool.getIconURI("message-warning"),
                size: "27px",
                width: "40px"
            })
        ]
    });
    var logoObj = new sap.m.Image({
        src: "../slui/resources/sap/ui/core/mimes/logo/icotxt_white_220x72_blue.png",
        height: "36px"
    });
	var boxObj2 = new sap.m.VBox({items: [logoObj]}).addStyleClass("shrink");
    var pan5 = new sap.m.Panel({
		backgroundDesign: sap.m.BackgroundDesign.Transparent,
        width: "auto",
        expandable: true,
        expanded: true,
        headerToolbar: toolbarObj4,
        content: [boxObj2]
    });

    return {oProgInd: progressIndicatorObj, oProgPanel: pan1, oStatusInd: pan2, oPhaseStr: pan3, oTicket: pan4, oLogo: pan5};
}

function disableRecursive(fragment) {
	if (typeof fragment.setEnabled == "function") fragment.setEnabled(false);
	var items = null;
	if (typeof fragment.getItems === "function") items = fragment.getItems();
	if (items) for (var i=0; i < items.length; i++) disableRecursive(items[i]);
	var gcontent = null;
	if (fragment.oGrid && typeof fragment.oGrid.getContent  === "function") gcontent = fragment.oGrid.getContent();
	if (gcontent) for (var c=0; c < gcontent.length; c++) disableRecursive(gcontent[c]);
	var content = null;
	if (typeof fragment.getContent  === "function") content = fragment.getContent();
	if (content) for (var c=0; c < content.length; c++) disableRecursive(content[c]);
	var buttons = null;
	if (typeof fragment.getButtons  === "function") buttons = fragment.getButtons();
	if (buttons) for (var c=0; c < buttons.length; c++) disableRecursive(buttons[c]);
	var children = null;
	if (typeof fragment.getChildren  === "function") children = fragment.getChildren();
	if (children) for (var c=0; c < children.length; c++) disableRecursive(children[c]);
	var cells = null;
	if (typeof fragment.getCells  === "function") cells = fragment.getCells();
	if (cells) for (var c=0; c < cells.length; c++) disableRecursive(cells[c]);
	if (fragment.oCheckBox) disableRecursive(fragment.oCheckBox);
	if (fragment.getMetadata().getElementName() === "SUMControls.Table") {
		if (typeof fragment.setExport  === "function") fragment.setExport(false);
		if (typeof fragment.setDynamic  === "function") fragment.setDynamic(false);
	}
	if (fragment.getMetadata().getElementName() === "SUMControls.DiagTitle") {
		if (fragment.oIcon) fragment.oIcon.detachPress(openHelpWindow);
	}
}


function doLoop(idx)
{
    $.ajax({
        type: "GET",
        url: url[idx],
        cache: false,
        dataType: (idx === 1) ? "text" : "xml",
        success: function (xml, status, xhr) {
            if (!pages[idx]) {

                pages[idx] = buildPage();

                var page = new sap.m.Page("page" + idx, {
					showHeader: true,
					customHeader: new sap.m.OverflowToolbar({content: [new sap.m.Text("idSID"), new sap.m.ToolbarSpacer(), new sap.m.Text({text: title[idx]}), new sap.m.ToolbarSpacer()]}),
                    content: [pages[idx].oProgPanel, pages[idx].oStatusInd, pages[idx].oPhaseStr, pages[idx].oTicket, pages[idx].oLogo]
                });

                carousel.addPage(page);
            }
			switch(idx) {
				case 0:
					try {
						sap.ui.getCore().byId("idSID").setText(gSUMGlobals.sid).addStyleClass("sid");
						var file = parseFile(xml, pages[idx].oProgInd);
						var currState = "";
						var currRdmpStp = "Initial";
						var aTasks = file.Object["monitor"]["Task"];
						for (var i=0; i<aTasks.length; i++) if (aTasks[i]["type"]["#text"]==="slp.task.type.ROADMAP.TECH") currRdmpStp = aTasks[i]["displayName"]["#text"];
						var progressTitle = progrTitle[idx];
						if (idx) progressTitle = progressTitle.replace("<RDMPSTP>", currRdmpStp.replace("Current step: ", ""));
						pages[idx].oProgPanel.setHeaderText(progressTitle); 
						pages[idx].oProgInd.setPercentValue(parseInt(aTasks[0]["progress"]["#text"]));
		//              pages[idx].oProgInd.setDisplayValue(progressTitle + ": " + file.Object["monitor"]["Task"][0]["progress"]["#text"] + "%");
						pages[idx].oProgInd.setDisplayValue(aTasks[0]["progress"]["#text"] + "% - " + mStatus(aTasks[0]["status"]["#text"]));
						pages[idx].oStatusInd.removeAllContent();
						currState += file.State;
						var currStateDisplay = currState;
						var currPhaseTmStp = "";
						var oStep = aTasks.find(function(elem){return (elem.type["#text"] === "slp.task.type.STEP");});
						if (oStep) currPhaseTmStp = oStep["startedAt"]["#text"].replace("T", "  ");
						var currDiaTmStp = "";
						if (oStep && oStep["statusChangedAt"]) {
							currDiaTmStp = oStep["statusChangedAt"]["#text"];
							currStateDisplay += "\n" + currDiaTmStp.substr(0, 4) + "-" + currDiaTmStp.substr(4, 2) + "-" + currDiaTmStp.substr(6, 2) +"  " + currDiaTmStp.substr(8, 2) + ":" + currDiaTmStp.substr(10, 2) + ":" + currDiaTmStp.substr(12, 2);
						}
						else if (oStep) currStateDisplay += "\n" + currPhaseTmStp;
						pages[idx].oStatusInd.addContent(new sap.m.Text({text: currStateDisplay}));
						pages[idx].oPhaseStr.removeAllContent();
						var currPhase = ((file.State == "FINISHED") ? (aTasks[0].globalmode ? aTasks[0]["globalmode"]["#text"] : "Procedure Completed") : aTasks[0]["progressMessages"]["ProgressMessage"]["message"]["#text"]);
						currState += currPhase;
		//              var oStep = file.Object["monitor"]["Task"].find(function(elem){return (elem.type["#text"] === "slp.task.type.STEP");});
						if (oStep) currPhase += "\n" + currPhaseTmStp;
						pages[idx].oPhaseStr.addContent(new sap.m.Text({text: currPhase}));
						if (currState !== lastState[idx]) {
							lastState[idx] = currState;
							fastPollCountDn[idx] = fastPolls;
						}
					} catch (err) {
					}
					break;
				case 1:
					if (pages[0].oLogo && pages[0].oLogo.getContent()) {
						try {
							var diagtime = $($.parseXML(xml)).find("VBox").attr("app:diagtime");
							if (diagtime != last_diagtime) {
								last_diagtime = diagtime;
								sap.ui.getCore().byId("idDlgText").setText("Last Dialog");								
								sap.ui.getCore().byId("idDiagtime").setText("("+diagtime.substr(0, 4)+"-"+diagtime.substr(4, 2)+"-"+diagtime.substr(6, 2)+"  "+diagtime.substr(8, 2)+":"+diagtime.substr(10, 2)+":"+diagtime.substr(12, 2)+")");
								var oFrag = sap.ui.xmlfragment({fragmentContent: xml}, this);
								pages[0].oLogo.getContent()[0].removeAllItems();
								pages[0].oLogo.getContent()[0].addItem(oFrag);
								disableRecursive(oFrag);
							}
						} catch (err) {
						}
					}
					break;
			}

            setTimeout(function () {
                doLoop(idx);
            }, fastPollCountDn[idx] > 0 ? ((fastPollCountDn[idx]-- > fastPolls/2) ? 3000 : 10000) : 30000);
        },
        error: function(xhr, status, err) {
			fastPollCountDn[idx] = 0;
			switch(idx) {
				case 0:
					lastState[idx] = "";
					break;
				case 1:
					break;
			}
            setTimeout(function () {
                doLoop(idx);
            }, 15000);
        }
    });
    if ((idx == 1) && pages[0].oTicket) { 
	    $.ajax({
	        type: "GET",
	        url: "../analysis/SAPup_troubleticket.log",
	        cache: false,
	        dataType: "text",
	        success: $.proxy(function(txt, status, xhr) {
		        this.setVisible(true);
		        this.getContent()[0].setText(txt);
		    }, pages[0].oTicket),
	        error: $.proxy(function(xhr, status, err) {this.setVisible(false);}, pages[0].oTicket)
	    });
    }
}

var carousel = new sap.m.Carousel({
    id: "carousel",
    loop: false,
    pages: []
});

var app = new sap.m.App("myApp", {initialPage: "carousel"});

function startApp()
{
    app.addPage(carousel);
    app.placeAt("content");
    doLoop(0);
    doLoop(1);
}


var Globals = function(){
        
        /*** Path parameters ************************************************************************************/
		this.urlEndPoint	= "/monitor";
        this.fullUrl        = document.location.href;
        var tempUrl         = this.fullUrl;
        this.sumProtocol    = this.fullUrl.substring(0, this.fullUrl.indexOf("://") + 3);
        tempUrl             = tempUrl.substring(tempUrl.indexOf(this.sumProtocol) + this.sumProtocol.length);

        if (tempUrl.indexOf(":") > 0) {
        	this.clientHost     = tempUrl.substring(0, tempUrl.indexOf(":"), 4);
        	this.sumPort        = tempUrl.substring(tempUrl.indexOf(":") + 1, tempUrl.indexOf(":")+5);
        }else{ //k8s
        	this.clientHost     = tempUrl.substring(0, tempUrl.indexOf("/"), 4);
        	this.sumPort        = "";
        }
        
        this.pathBase       = this.sumProtocol + this.clientHost;
        if (tempUrl.indexOf(":") > 0) {
        	this.pathBase   = this.pathBase + ":" + this.sumPort;
        }    
		this.sid            = tempUrl.substring(tempUrl.indexOf(this.urlEndPoint)-3, tempUrl.indexOf(this.urlEndPoint));
        this.tooltype       = tempUrl.substring(tempUrl.indexOf("/lmsl")+6, tempUrl.indexOf("/" + this.sid + "/"));
    
        this.sumUiUrlExt    = tempUrl.substring(tempUrl.indexOf("/lmsl"));
        this.sumAbapUrl     = this.pathBase + this.sumUiUrlExt;
        this.pathSlpJava    = "";
        this.pathSlpAbap    = this.pathBase + "/slp/" + this.tooltype + "/" + this.sid;
        this.pathLmslAbap   = this.pathBase + "/lmsl/" + this.tooltype + "/" + this.sid;
        this.slpResBPs      = "breakpoints";
        this.tableLimit		= 10000;
        this.version 		= "";
        this.extVersion		= "";

        
        this.pathsTaskImages = "resources/img/tasktype";
        
        this.popupError = function(message) {
        	alert(message);	//eslint-disable-line
			gSUMGlobals.busy = false;
//			console.log("busy = false\n");
        };
        this.genericError = function(xhr, status) {
        	if (xhr) {
        		if ((xhr.status == 0) && !xhr.responseText) xhr.responseText = "No response from server.";
        		gSUMGlobals.popupError('Cannot load Resource from URL: '+xhr.status+'\n\n'+xhr.responseText);
        	}
        	else gSUMGlobals.popupError("General Failure - please retry (press F5) or inform SAP Support if this error persists!");
        };
        
    
        /*** Menu/Buttons vars ************************************************************************************/
        this.activeMenuItem = "";    
        
        /*** config resource **************************************************************************************/
        this.diaParamMap = [];
        this.osDirSeparator = "/";

		this.oSLPAPI = {};	//SLP interface - once it is instantiated
		this.oLMSLAPI = {};	//LMSL interface - once it is instantiated
		this.guideInfo = {db: "HDB", opt: "std", loio: "", section: ""};
		document.title = this.sid+": "+document.title;

		this.mdtArry = [];
		this.optOut = [];
		this.handleNext = function() {};
		this.handleMdt = function() {};
};

var gSUMGlobals = new Globals();

startApp();
