sap.ui.define([
	"sap/ui/core/Control",
    "sap/m/Dialog",
    "sap/m/Tree",
    "sap/m/Button",
], function(Control, Dialog, Tree, Button) {
  "use strict";

	var Browser = Control.extend("SUMControls.Browser", {	// call the new Control type "Browser" 
															// and let it inherit from sap.m.Dialog
		metadata: {
				properties: {
					browserType: 	{type: "string", defaultValue: "File"},
					hook:			{type: "sap.m.Input"}, 
					windowsOS:		{type: "Boolean", defaultValue: false},
					filter:	 		{type: "string", defaultValue: ""}
				}
		},	
	
		init: function() {
			var that = this;
			this._oDialog = new Dialog(
				{	contentWidth: 	"600px",
					contentHeight:	"350px"	}
			);
			this._oTree = new Tree({mode: sap.m.ListMode.SingleSelectMaster, //selectionChange: that._pick,
				toggleOpenState: function(oEvent) {
					if (oEvent.getParameter("itemContext")) {
						var sSelectedItemId = oEvent.oSource.mBindingInfos.items.template.sId;
						var sTableId = oEvent.oSource.sId;
						var sItemIndex = oEvent.getParameter("itemIndex");
						var sSelectedRowId = sSelectedItemId + "-" + sTableId + "-" + sItemIndex;
						var oSelectedRow = sap.ui.getCore().byId(sSelectedRowId);
						var bExpanded = oEvent.getParameter("expanded");
						that.handleToggle(oSelectedRow, bExpanded);
					}
				}
			});
			this._oTree.addStyleClass("SUMFileBrowser");
		
			var oBtnCn = new Button({text: "Cancel", press: function () {this.getParent().close();}});
			var oBtnOk = new Button({
				text: "OK", 
				press: $.proxy(function(){
							this.picked(this._oModel, this.set(this._oTree.getSelectedItem()), this.getBrowserType(), true, this.getHook(), this.getFilter());
						}, this)
			});
			this._oDialog.addContent(this._oTree);
			this._oDialog.addButton(oBtnOk);
			this._oDialog.addButton(oBtnCn);
//			this._oModel = new sap.ui.model.xml.XMLModel();
			this._oModel = new sap.ui.model.json.JSONModel();
			this._oModel.setSizeLimit(gSUMGlobals.tableLimit);
			this._oTree.setModel(this._oModel, "FSEntries");
//			this._oModel.setXML('<?xml version="1.0" encoding="UTF-8" standalone="yes"?><fileSystemEntries><FileSystemEntry><name/><icon/></FileSystemEntry></fileSystemEntries>');
			this._oModel.setJSON('{"FileSystemEntry": {"name": "", "icon": ""}}');
			this._oTree.attachBrowserEvent("dblclick", $.proxy(function(oEvt) {
				var node = oEvt.target.parentElement;
				if ($(node).context.className === "sapMLIBContent") node = node.parentNode;
				var index = this._oTree.indexOfItem(sap.ui.getCore().byId(node.id));
				this._oTree.fireToggleOpenState({
					itemIndex: index,
					itemContext: sap.ui.getCore().byId(node.id).getBindingContext("FSEntries"),
					expanded: true
				}); 
				this._oTree.getBinding("items").toggleIndex(index);
			}, this));
			this._oNodeRoot = new sap.m.StandardTreeItem({type: sap.m.ListType.Active, title: "{FSEntries>name}", icon: "{FSEntries>icon}"});
			sap.m.StandardTreeItem.prototype._getPadding = function(){return 0.7*this.getLevel();}; // get a fix indentation for directory levels
			this._oTree.bindItems("FSEntries>/", this._oNodeRoot);
			this._pickedNode = undefined;
		},
		
		handleToggle: function(oSelectedRow, bExpanded) {
			this._oTree.setBusy(true).rerender();
			if (bExpanded == true) {
				var nextNode = oSelectedRow.getBindingContext("FSEntries").getObject();
				this.picked(this._oModel, this.set(oSelectedRow), this.getBrowserType(), false, this.getHook(), this.getFilter());
			}
			this._oTree.setBusy(false).rerender();
		}
	});
	
		
	SUMControls.Browser.prototype.open = function() {
		
		function iterateTree(i, preSel, path, drive, nextNode, text, winUNC, scrollIdx, scrollMax, success, cont, that) {
			if (success && cont && (i < preSel.length)) {
				var thisNode = nextNode;
				SUMControls.Browser.prototype.exploreTree(nextNode, that.getBrowserType(), path, that.getFilter()).then(function(boolArry){
					that._oModel.refresh();
					if (i == 0) that._oTree.fireToggleOpenState({itemIndex: 0, expanded: true}).getBinding("items").toggleIndex(0); 
					that._oTree.rerender();
					success = boolArry[0];
					cont = boolArry[1];					
					var findIdx = -1;
					nextNode = (!preSel[i] || !thisNode.FileSystemEntry) ? undefined : thisNode.FileSystemEntry.name ? (thisNode.FileSystemEntry.type === "slp.fileSystemEntry.type.DIRECTORY") ? (findIdx++, thisNode.FileSystemEntry) : (scrollIdx++, scrollMax++, undefined) : thisNode.FileSystemEntry.find(function(elem, idx){return (elem.name === preSel[i]) ? (findIdx = idx, true) : false;});
					if (nextNode) {
						scrollIdx++;
						scrollMax++;
						scrollIdx += findIdx;
						scrollMax += thisNode.FileSystemEntry.length ? thisNode.FileSystemEntry.length : 1;
						thisNode = nextNode;
						that._oTree.getBinding("items").toggleIndex(scrollIdx);  
						winUNC = false; //from now on, we can even treat WinUNC paths like normal paths because we found one existing level
					}
					else if (winUNC) { 
						if (text.slice(text.length-1) !== gSUMGlobals.osDirSeparator) text += gSUMGlobals.osDirSeparator;
						text += preSel[i];
						if (i === 0) {
							cont = true;
							nextNode = thisNode;
							nextNode.name = text;
						}
						that._oNodeRoot.setTitle(text); 
					} 
					else {cont = false; scrollMax += (thisNode.FileSystemEntry && thisNode.FileSystemEntry.length) ? thisNode.FileSystemEntry.length : 1;}
					if (path.slice(path.length-1) !== gSUMGlobals.osDirSeparator) path += gSUMGlobals.osDirSeparator;
					path += preSel[i];
					iterateTree(++i, preSel, path, drive, nextNode, text, winUNC, scrollIdx, scrollMax, success, cont, that);
				});
			} else {
				if (!success) sap.m.MessageToast.show("Error: No file system access.");
				that._oDialog.scrollRatio = (scrollMax == 0) ? 0 : scrollIdx / scrollMax; 	//calculate ratio where to find preselected entry in tree! this is cool! 
				that._oDialog.addEventDelegate(
						{
							onAfterRendering: function(evt) {
								this.ctrl = "";
								setTimeout($.proxy(function scroll(){ 
									var ctrl = this.getDomRef("cont");
									if (ctrl && ctrl.scrollHeight && $(ctrl) && (typeof $(ctrl).scrollTop === "function"))
										$(ctrl).scrollTop(Math.floor(this.scrollRatio * ctrl.scrollHeight));  //awesome algorithm, isn't it? Don't forget to like it...  ;-)
									if (this.ctrl != ctrl) {this.ctrl = ctrl; setTimeout($.proxy(scroll, this), 500);}
								}, this), 500);
							}
						}, that._oDialog); 
				that._oTree.setSelectedItem(sap.ui.getCore().byId(that._oTree.mBindingInfos.items.template.sId + "-" + that._oTree.sId + "-" + scrollIdx), true);
				that._oDialog.open(); 
				SUMControls.Browser.prototype._semaphore = false; //enable again the opening of another browser instance 
			}				
		}

		if (this._oDialog) {
			this._oDialog.setTitle(this.getBrowserType() + " Explorer"); 
			if (this.getWindowsOS() === "true") gSUMGlobals.osDirSeparator = "\\";
			var hook = this.getHook();
			var preSel = (hook.getValue().length?hook.getValue():gSUMGlobals.osDirSeparator).split(/[/\\]/);
			if (preSel && (preSel[preSel.length-1] !== "")) preSel.push("");			
			var text, icon, drive, winUNC = false;
			if (hook.getValue().substr(0, 2) === "\\\\") {
				winUNC = true;
				preSel.shift(); preSel.shift();
				text = "\\\\"+preSel[0];
				icon = "sap-icon://share-2";
				drive = preSel[0] = "\\\\"+preSel[0]; 
				preSel.shift();
			}
			else if (preSel[0][1] == ':') {
				text = preSel[0];
				icon = "sap-icon://goalseek";
				drive = preSel[0]; 
				preSel.shift();
			} 
			else if ((gSUMGlobals.osDirSeparator === "\\") && (hook.getValue()==="")) {
				preSel.shift();
				text = location.hostname;
				icon = "sap-icon://it-host";
				drive = "";														
			}
			else {
				if (hook.getValue()!=="") {preSel.shift(); drive = gSUMGlobals.osDirSeparator;}
				else drive = "";
				text = gSUMGlobals.osDirSeparator;
				icon = "sap-icon://folder-blank";
			}
			var nextNode = this._oModel.getData().FileSystemEntry;
			nextNode.name = nextNode.path = text;
			nextNode.icon = icon;
			nextNode.type = "slp.fileSystemEntry.type.DIRECTORY";

			iterateTree(0, preSel, drive, drive, nextNode, text, winUNC, 0, 0, true, true, this);			
		}
	};


	SUMControls.Browser.prototype.set = function(oRow) {
		this._pickedNode = oRow.getBindingContext("FSEntries").getObject();
		if (this._pickedNode.FileSystemEntry && (!this._pickedNode.FileSystemEntry.name) && (this._pickedNode.FileSystemEntry.length) && (!this._pickedNode.FileSystemEntry[0].name)) this._pickedNode.FileSystemEntry = [];
		oRow.setSelected(true);
		this._oModel.refresh();
		return oRow;
	};
	
	
	SUMControls.Browser.prototype.picked = function(oModel, oRow, sType, bExplicit, hook, urlparam) {
		function deepFindSelected(oRow) {
			if (oRow.getSelected()) return oRow;
			else {
				var selRow = oRow.getList().getItems().find(function(elem){return elem.getSelected();});
				if (selRow) {
					oRow.getList().getItems().forEach(function(elem){if (elem != selRow) elem.collapse();});
					selRow.expand(false, false);
					return selNode;
				}
				var expRow = oRow.getList().getItems().find(function(elem){return elem.getExpanded();});
				return expRow ? deepFindSelected(expRow) : oRow;				
			}
		}
		if (this._pickedNode || bExplicit) {
			var name = this._pickedNode.name;
			var type = this._pickedNode.type;
			var absPath = this._pickedNode.path;
			if (absPath === location.hostname) absPath = "";
			if ((absPath.substr(0,2) === "\\\\") && absPath.lastIndexOf("\\") === 1) absPath = name;
			if      ((type === "slp.fileSystemEntry.type.FILE") || bExplicit) {
				if ((absPath.length > 2) && (absPath[0]==="\\") && (absPath[2]===":")) absPath = absPath.slice(1);
				if ((type === "slp.fileSystemEntry.type.DIRECTORY") && (absPath.slice(absPath.length-1) !== gSUMGlobals.osDirSeparator)) absPath += gSUMGlobals.osDirSeparator;
				hook.setValue(absPath);
				hook.fireChange();
				this._oDialog.close();
				for (var i = 0; i < gSUMGlobals.mdtArry.length; i++) {
					if (gSUMGlobals.mdtArry[i].inpId === hook.getId()) {gSUMGlobals.mdtArry[i].fulfilled = Boolean(absPath); break;}
				}
				if (gSUMGlobals.nextButton) gSUMGlobals.handleNext();
				return true;
			}
//			else if (type === "slp.fileSystemEntry.type.DIRECTORY") if (!SUMControls.Browser.prototype.exploreTree(deepFindSelected(oRow).getBindingContext("FSEntries").getObject(), sType, absPath, urlparam)[0]) sap.m.MessageToast.show("Error: No file system access.");
			else if (type === "slp.fileSystemEntry.type.DIRECTORY") {
				SUMControls.Browser.prototype.exploreTree(deepFindSelected(oRow).getBindingContext("FSEntries").getObject(), sType, absPath, urlparam).then($.proxy(function(boolArry) {
					if (!boolArry[0]) sap.m.MessageToast.show("Error: No file system access.");
					this._oModel.refresh();
				}, this));
			}
		}	
		return false;
	};


	SUMControls.Browser.prototype.exploreTree = function(thisNode, sType, path, urlparam) {
		function _enrich(item, ind) {
			item.path = path + ((path.slice(path.length-1) !== gSUMGlobals.osDirSeparator) ? gSUMGlobals.osDirSeparator : "") + item.name;
			switch(item.type) {
				case "slp.fileSystemEntry.type.DIRECTORY": item.icon = 	((item.name[1] === ":") && (item.name[2] === "\\")) ? "sap-icon://goalseek" : "sap-icon://folder-blank"; item.FileSystemEntry = [{}]; cont = true; break;
				case "slp.fileSystemEntry.type.FILE": 		
					if (sType === "File") item.icon = "sap-icon://document-text"; 
					else thisNode.delArry.push(ind);
					break;						
			};
		}
		function _ascending(a, b) {
			return a.name > b.name ? 1 : a.name < b.name ? -1 : 0;			
		}
		
		var cont = false;
		thisNode.delArry = [];
		if (path && (path[0] !== gSUMGlobals.osDirSeparator)) path = gSUMGlobals.osDirSeparator + path;
//		if (path && ((path[0] !== gSUMGlobals.osDirSeparator) || (path.substr(0, 2) === "\\\\"))) path = gSUMGlobals.osDirSeparator + path;
		//windows backslashes need to be changed to slashes except the windows network UNC double backslash
		//special characters must be URLencoded except the slashes 
		var urlpath = encodeURIComponent(path.replace(/\\\\/g, "\%5C\%5C").replace(/\\/g, "/").replace(/\%5C\%5C/g, "/\\\\")).replace(/\%2F/g, "/");
		return new Promise(
				function(resolve, reject) {
					gSUMGlobals.oSLPAPI.getFileSystemEntries(
							urlpath + (urlparam ? "?" + urlparam : ""), 
							function(xml) {
								if (Boolean(thisNode.FileSystemEntry = slpxml2json(xml).json.fileSystemEntries.FileSystemEntry)) {
									if (thisNode.FileSystemEntry.name) _enrich(thisNode.FileSystemEntry, 0);
									else thisNode.FileSystemEntry.sort(_ascending).forEach(_enrich);
									var ind;
									while (thisNode.delArry && (ind = thisNode.delArry.pop()) != undefined) if (typeof thisNode.FileSystemEntry.splice === "function") thisNode.FileSystemEntry.splice(ind, 1); else if (ind === 0) delete thisNode.FileSystemEntry;
								}
								delete thisNode.delArry;
								resolve([true, cont]);
							}, 
							function(xhr, options, errorText) {
								thisNode.FileSystemEntry = {"FileSystemEntry": {"name": "?", "icon": ""}};
								sap.m.MessageToast.show("Error: Server does not answer Filesystem request");
								jQuery.sap.log.error("GET /fileSystemEntries Failure: " + errorText);
								delete thisNode.delArry;
								reject([false, false]);
							});
				}
		);
	};


	SUMControls.Browser.prototype.destroy = function() {
		if (this._oDialog) {
			this._oDialog.destroy();
			delete this._oDialog;
		}
	};
	
  return Browser;
});  