sap.ui.define([
    "sap/m/CheckBox"
], function(CheckBox) {
  "use strict";

	var ChkBox = CheckBox.extend("SUMControls.CheckBox", {	// call the new Control type "CheckBox" 
															// and let it inherit from sap.m.CheckBox
		metadata: {
			properties: {
				selected: 	{type: "boolean", defaultValue: false},
				required:   {type: "boolean", defaultValue: false},
				enables:	{type: "string"},
				disables:	{type: "string"},
				text:		{type: "string"}
			},
			aggregations: {
				children: {type: "sap.ui.core.Control", multiple: true}
			},
			defaultAggregation: "children"
		},
		
		init: function() {
			this.attachSelect(function(oEvt){
				var that = oEvt.getSource();
				var value = oEvt.getParameter("selected");
				if (gSUMGlobals.nextButton) {
//					if (!value && that.getEnables()) gSUMGlobals.nextButton.setEnabled(true); // beim Ausschalten von Enables erstmal Next aktivieren
//todo					if (value && that.getDisables()) gSUMGlobals.nextButton.setEnabled(true); // beim Einschalten von Disables erstmal Next aktivieren
					gSUMGlobals.nextButton.decision = "";
					for (var i = 0; i < gSUMGlobals.mdtArry.length; i++) 
						if (gSUMGlobals.mdtArry[i].inpId === that.getId()) {gSUMGlobals.mdtArry[i].fulfilled = value; gSUMGlobals.handleNext(); break;}
				}
				var groups = findChildren(oEvt.getSource().getChildren(), "SUMControls.Group");
				for (var i=0; i<groups.length; i++) {
					if (groups[i].data("sumid") === oEvt.getSource().getEnables()) {groups[i].mkVisible(value); if (!value) groups[i].rerender();}
					else if (groups[i].data("sumid") === oEvt.getSource().getDisables()) {groups[i].mkVisible(!value); if (value) groups[i].rerender();}
				}
				if (that.getParent().oCheckBox) that.getParent().getParent().rerender(); // call rerendering to update button status as of SAPUI5 lib version 1.71.14 - does not trigger intrinsically anymore (in some situations)
			});			
		},
		
		onBeforeRendering: function(oEvt) {
			var oControl = oEvt.srcControl;		
			oControl.setTooltip(oControl.getText());
			if (oControl.getParent().oCheckBox && gSUMGlobals.nextButton) gSUMGlobals.handleNext();
		},
		
	    renderer: function(oRm, oControl) {
	        oRm.write("<div style=\"width: 100%;\">");
			oRm.write("<div style=\"display:flex; flex-direction: row; \">");
			sap.m.CheckBoxRenderer.render(oRm, oControl);
			findChildren(oControl.getChildren(), "SUMControls.Hint").forEach(function(a){oRm.renderControl(a);});
			oRm.write("</div>");	
			findChildren(oControl.getChildren(), "SUMControls.Group").forEach(function(a) {
				if ( (!oControl.getEnables() || (a.data("sumid") !== oControl.getEnables()) || oControl.getSelected() )
				||   (!oControl.getDisables() || (a.data("sumid") !== oControl.getDisables()) || !oControl.getSelected() )){
					oRm.write("<div style=\"margin-left: 40px;\">");
					oRm.renderControl(a);
					oRm.write("</div>");
				}
			});
		    oRm.write("</div>");
	    },
		
		onAfterRendering: function(oEvt) {
			$("#"+oEvt.srcControl.getId()+"-CbBg").attr("sumid", oEvt.srcControl.data("sumid"));
		}
	});
	
  return ChkBox;
});  