sap.ui.define([
	"sap/ui/core/Control",
    "sap/m/Title",
	"sap/ui/core/Icon"
], function(Control, Title, Icon) {
  "use strict";

	var DiagTitle = Control.extend("SUMControls.DiagTitle", {	// call the new Control type "DiagTitle" 
																// and let it inherit from sap.ui.core.Control
		metadata: {
				properties: {
					text:		{type: "string", defaultValue: ""}
				}
		},	

		init: function() {
			this.oTitle = new Title();
        	this.oIcon = new Icon({src: "sap-icon://sys-help", color: document.URL.indexOf("suihcb=true")>0 ? "#FFFFFF" : document.URL.indexOf("suihcw=true")>0 ? "#000000" : "green", tooltip: "Press F1 or click here to open the guide for this topic", press: openHelpWindow});
        },

		onBeforeRendering: function(oEvt) {
			this.oTitle.setText(this.getText());
		},
		
	    renderer: function(oRm, oControl) {
			oRm.write("<div style='display:flex;flex-direction:row;'>");
	    	oRm.addClass("sapUiNoMargin");
	        oRm.addStyle('font-weight', 'bolder');  
	        oRm.addStyle('font-size', 'x-large');
	        oRm.addStyle('padding-bottom', '1rem');
	        sap.m.TitleRenderer.render(oRm, oControl.oTitle);
			if (gSUMGlobals.guideInfo.loio != "") {
				oRm.addStyle('margin', '1px 0px 15px 15px;');  
				oRm.addStyle('font-size', 'x-large');  
				sap.ui.core.IconRenderer.render(oRm, oControl.oIcon);
			}
			oRm.write('</div>');
	    },  

        exit: function() {
    		if (this.oTitle) {
    			this.oTitle.destroy();
    			delete this.oTitle;
    		}
    		if (this.oIcon) {
    			this.oIcon.destroy();
    			delete this.oIcon;
    		}
    	}
		
	});
	

  return DiagTitle;
});  
