jQuery.sap.require("SUMControls.Browser");

sap.ui.define([
  "./Input"
], function(Input) {
  "use strict";

	var DirBrowser = Input.extend("SUMControls.DirectoryInput", {	// call the new Control type "DirectoryInput" 
																	// and let it inherit from SUMControls.Input
		metadata: {
			properties: {
				bwslash:	{type: "Boolean", defaultValue: false},
				endswith:	{type: "string"}
			}
		},	
	
		init: function() {
			if (sap.m.Input.prototype.init) sap.m.Input.prototype.init();
			if (this.setShowValueHelp) this.setShowValueHelp(true);
			this.attachValueHelpRequest(this, this._showBrowser);
			this._getValueHelpIcon().setTooltip("Open server side directory browser");
	//		this.setProperty("width", "100%");
	//		this.setLayoutData(new sap.ui.layout.GridData({span: "L3 M4 S6", linebreak: false}));
		},
		
	    renderer: function(oRm, oControl) {
	//      oRm.addStyle('width','500px');  
	//    	oRm.addClass("sapUiLeftPadding");
	        SUMControls.InputRenderer.render(oRm, oControl);
	    },
		
		onAfterRendering: function(oEvt) {
			$("#"+oEvt.srcControl.getId()+"-inner").attr("sumid", oEvt.srcControl.data("sumid"));
			$("#"+oEvt.srcControl.getId()+"-vhi").attr("sumid", oEvt.srcControl.data("sumid")+"-vhi");
		}
	});
  
	SUMControls.Browser.prototype._semaphore = false; // free semaphore
	  
	SUMControls.DirectoryInput.prototype._showBrowser = function(evt) {
		if (SUMControls.Browser.prototype._semaphore) return; // already one browser in opening process!
		SUMControls.Browser.prototype._semaphore = true;	// lock semaphore 
		var filter = "$filter=type%20eq%20%27slp.fileSystemEntryType.DIRECTORY%27";
		if (this.getEndswith()) {
			filter += "%20and";
			this.getEndswith().split("/").forEach(function(elem, idx){filter += (idx ? "%20or" : "") + "%20endswith(name,%27" + elem + "%27)";});		
		}
		this._oBrowser = new SUMControls.Browser({browserType: "Directory", windowsOS: this.getBwslash(), filter: filter, hook: evt.getSource()});
		this._oBrowser.open();	// semaphore will become free'd here...
	};

	SUMControls.DirectoryInput.prototype.exit = function() {
		if (this._oBrowser) {
			this._oBrowser.destroy();
			delete this._oBrowser;
		}
	};
	
  return DirBrowser;
});  