sap.ui.define([
    "sap/ui/core/Icon",
	"sap/m/Panel",
	"sap/m/PanelRenderer",
	"sap/m/HBox"
], function(Icon, Panel, PanelRenderer, HBox) {
    "use strict";

	var Group = Panel.extend("SUMControls.Group", {

		metadata: {
			properties: {
				type:     {type: "string", defaultValue: null},
			}
		},

		mkVisible: function(bVis) {
			if (bVis) {
				this.swOn = true;
			} else {	
				this.swOn = false;			
				for (var i = 0; i < gSUMGlobals.mdtArry.length; i++) {
					if (findRecursiveItemMode(this, gSUMGlobals.mdtArry[i].inpId, 4)) {gSUMGlobals.mdtArry[i].fulfilled = true;}
				}
				if (gSUMGlobals.nextButton) gSUMGlobals.handleNext();
			}
			this.setVisible(bVis);
		},
		
		onBeforeRendering: function(evt) {
			if (!this.icon){
				if (this.getExpandable()) {
					switch (this.getType()) {
						case "info": this.icon = new Icon({src: "sap-icon://message-information"}); break;
						case "ignored":
						case "warning": this.icon = new Icon({src: "sap-icon://message-warning"}); break;
						case "error": this.icon = new Icon({src: "sap-icon://error"}); break;
						default: gSUMGlobals.popupError("missing or wrong expandable group type in dialog");
					}
					this.setHeaderToolbar(new sap.m.Toolbar({content : [this.icon, new sap.m.Text({text: this.getHeaderText()})]}));
					this.expanded = this.getExpanded() === "true";
				} else if (this.getType() === "error"){
					this.insertContent(new HBox({items: [(this.icon = new Icon({src: "sap-icon://message-error", color: "#bb0000"})), this.removeContent(0)], alignItems: "Center"}));
				}
			}
		},

	    renderer: function(oRm, oControl) {
	    	oRm.addClass("sapUiNoMargin");
			if (oControl.getExpandable()) oRm.addStyle('font-size', '20px');
	        if (oControl.getType() === "error") {
	        	if ((document.URL.indexOf("suihcb=true")<0) && (document.URL.indexOf("suihcw=true")<0)) oRm.addStyle('background-color', '#ffe4e4');
				if (!oControl.getExpandable()) {
					oRm.addStyle('border', '1px solid');
					oRm.addStyle('border-color', '#ee0000');
					oRm.addStyle('border-radius', '0.1875rem');
					oRm.addStyle('padding-left', '1rem');
					oRm.addStyle('padding-right', '1rem');
					oRm.addStyle('width','auto !important');
				}
        	}
			PanelRenderer.render(oRm, oControl);
	    },

		onAfterRendering: function(oEvt) {
			if (this.getExpandable()) {
				if (!this.getExpanded()) this.$().children(".sapMPanelExpandablePart").hide();
			} else {
				$(this.getDomRef()).removeClass("sapMPanel");
				$(this.getDomRef("content")).removeClass("sapMPanelContent");
				$(this.getDomRef("content")).removeClass("sapMPanelBGTranslucent");
				$(this.getDomRef("header")).removeClass("sapMPanelHdr");
				if (this.icon) {
					var st = this.icon.getDomRef().style;
					st.paddingRight = "0.5rem";
					st.fontSize = "1rem";
				}
 
			}
			if (this.swOn) {
				this.swOn = false;
				gSUMGlobals.handleMdt();
			}
		}
	});

	return Group;
});  