sap.ui.define([
	"sap/ui/core/Control",
	"sap/ui/layout/Grid",
	"sap/ui/core/VerticalAlign"
], function(Control, Grid, VerticalAlign) {
    "use strict";

	var InputBox = Control.extend("SUMControls.InputBox", {	// call the new Control type "InputBox" 
															// and let it inherit from sap.ui.core.Control
        metadata: {
            properties: {},
            aggregations: {
                content: {
                    type: "sap.ui.core.Control"
                }
            },
            defaultAggregation: "content"
        },
        
        init: function() {
        	this.oGrid = new Grid({defaultSpan: "L4 M4 S6"});
        	this.oGrid.addStyleClass("sapUiNoMarginTop").addStyleClass("sapUiNoMarginBottom");
        },

        renderer: function(oRm, oControl) {
        	
        	$(oControl.getContent()).each(function(key, val) {
        		switch (val.getMetadata().getElementName()) { 
	    			case "sap.m.Label":
	    				val.setWrapping(true);
	    			case "SUMControls.PwdCnfrmInput":
					case "sap.m.Input":
	    			case "SUMControls.Input":
	    				val.setLayoutData(new sap.ui.layout.GridData({span: "L3 M4 S6", linebreak: false}));
	    				break;
	    			case "SUMControls.FileInput": 
	    			case "SUMControls.DirectoryInput": 
	    				val.setLayoutData(new sap.ui.layout.GridData({span: "L8 M8 S12", linebreak: false})); 
	    				break;
	    		}
	    		val.addStyleClass("sapUiTinyMarginTop").addStyleClass("sapUiTinyMarginBottom");
	    		oControl.oGrid.addContent(val);
        	});
        	
        	oRm.renderControl(oControl.oGrid);
        	
        	$(oControl.oGrid.getContent()).each(function(key, val) {
        		oControl.addContent(val);
        	});
        },
		
        exit: function() {
    		if (this.oGrid) {
    			this.oGrid.destroyContent();	// destroy aggregated content
    			this.oGrid.destroy();
    			delete this.oGrid;
    		}
    		this.destroyContent(); 							// destroy own content
    	}
	});

	return InputBox;
});  
