sap.ui.define([
	"sap/ui/core/Control",
	"sap/m/Label",
	"./Input",
	"./InputBox"
], function(Control, Label, Input, InputBox) {
    "use strict";

	var PwdCnfrmInput = Control.extend("SUMControls.PwdCnfrmInput", {	// call the new Control type "PwdCnfrmInput" 
																		// and let it inherit from sap.ui.core.Control
        metadata: {
            properties: {
            	placeholder:	{type: "string"},
            	value: 			{type: "string"},
				required:   	{type: "boolean", defaultValue: true},
                width: 			{type: "sap.ui.core.CSSSize", defaultValue: "auto"},
                remId:   		{type: "string", defaultValue: null},
                remArg:  		{type: "string", defaultValue: null}
            },
			aggregations: {
				hint: {
					type: "SUMControls.Hint"
				}
			},
			defaultAggregation: "hint"
        }, 
        
        init: function() {
        	this.oInput1 = new Input({id: this.getId()+"_1", type: sap.m.InputType.Password, liveChange: $.proxy(this.liveEval, this)});
			this.oInput1.addStyleClass("sapUiTinyMarginTop");
        	this.oLbl2 = new Label({text: "Password Confirmation", labelFor: this.getId()+"_2", required: true});
        	this.oInput2 = new Input({id: this.getId()+"_2", type: sap.m.InputType.Password, liveChange: $.proxy(this.liveEval, this)});
        	this.oIBox2 = new InputBox({content: [this.oLbl2, this.oInput2]});
        	this.initial = true;
        },

		onBeforeRendering: function(oEvt) {
			this.getHint().forEach($.proxy(function(a,b,c){if (!b || (b < (c.length-1))) this.oInput1.addHint(a); else this.oInput2.addHint(a);}, this));
		},
		
        renderer: function(oRm, oControl) {
        	oControl.oInput1.setPlaceholder(oControl.getPlaceholder()); 
        	oControl.oInput1.setValue(oControl.getValue()); 
        	oControl.oInput1.setWidth(oControl.getWidth()); 
        	oControl.oInput2.setPlaceholder("Password Confirmation"); 
        	oControl.oInput2.setValue(oControl.getValue()); 
        	oControl.oInput2.setWidth(oControl.getWidth()); 
            oRm.renderControl(oControl.oInput1);
            oRm.write("</div></div>");
            oRm.renderControl(oControl.oIBox2);
            oRm.write("<div><div>");
        }, 
        
	    onAfterRendering: function(oEvt) {
	    	var that = oEvt.srcControl;
	    	$("#"+that.oInput1.getId()+"-inner").attr("sumid", that.data("sumid") + "_1");
	    	$("#"+that.oInput2.getId()+"-inner").attr("sumid", that.data("sumid") + "_2");
		},
		
        liveEval: function(e) {		
			function setState(state, ttip) {
				e.getSource().setValueState(state).setValueStateText("Entries do not match");
				e.getSource().setTooltip(ttip);
				srcCntrl.setValueState(state).setValueStateText("Entries do not match");
				srcCntrl.setTooltip(ttip);
			}
			var tarId = e.getSource().sId;
			var tarVal  = e.getParameter("value");
			var typing2ndFld = false;
			if (tarId) {
				var pos = tarId.lastIndexOf("_1");
				var srcId;
				if (Boolean(typing2ndFld = ((pos === -1) || (pos !== tarId.length-2)))) {
					pos = tarId.lastIndexOf("_2");
					if ((pos === -1) || (pos !== tarId.length-2)) {
						SUMGlobals.popupError("Invalid Confirmation Field Composition!");
						return;
					} 
					else srcId = tarId.replace("_2","_1");
				}
				else srcId = tarId.replace("_1","_2");
				if (srcId) {
					var srcCntrl =  sap.ui.getCore().byId(srcId);
					if (srcCntrl) {
						var lblVal = e.getSource().getPlaceholder();
						var srcVal = srcCntrl.getValue();
						if (srcVal === tarVal) {
							if (srcVal !== "") setState(sap.ui.core.ValueState.Success, lblVal);
							else setState(sap.ui.core.ValueState.None, lblVal);
							for (var i = 0; i < gSUMGlobals.mdtArry.length; i++) {
								if (gSUMGlobals.mdtArry[i].inpId === tarId.replace("_2","_1")) {gSUMGlobals.mdtArry[i+1].fulfilled = true; break;}
							}
						} else {
							if (typing2ndFld) setState(sap.ui.core.ValueState.Error, "Mismatching " + lblVal + "...");
							else {setState(sap.ui.core.ValueState.None, lblVal); srcCntrl.setValue("");}
							for (var i = 0; i < gSUMGlobals.mdtArry.length; i++) {
								if (gSUMGlobals.mdtArry[i].inpId === tarId.replace("_2","_1")) {gSUMGlobals.mdtArry[i+1].fulfilled = false; break;}
							}
						}
						if (gSUMGlobals.nextButton) gSUMGlobals.handleNext();
					}
		        	if (this.initial) {
		        		this.initial = false;
		        		e.getSource().setValue(tarVal);
		        		srcCntrl.setValue("");
						for (var i = 0; i < gSUMGlobals.mdtArry.length; i++) {
							if (gSUMGlobals.mdtArry[i].inpId === srcCntrl.getId()) {gSUMGlobals.mdtArry[i].fulfilled = false; break;}
						}
		        	}					
				}
			}
        },
        
        exit: function() {
    		if (this.oInput1) {
    			this.oInput1.destroy();			// destroy aggregated content
    			delete this.oInput1;
    		}
    		if (this.oInput2) {
    			this.oInput2.destroy();			// destroy aggregated content
    			delete this.oInput2;
    		}
    		if (this.oLbl2) {
    			this.oLbl2.destroy();			// destroy aggregated content
    			delete this.oLbl2;
    		}
    		if (this.oIBox2) {
    			this.oIBox2.destroy();			// destroy aggregated content
    			delete this.oIBox2;
    		}
    	}  
	});

	return PwdCnfrmInput;
});  