sap.ui.define([
    "sap/m/RadioButton",
    "./CheckBox"
], function(RadioButton, CheckBox) {
  "use strict";

	var RButton = RadioButton.extend("SUMControls.RadioButton", {	// call the new Control type "RadioButton" 
																	// and let it inherit from sap.m.RadioButton
		metadata: {
				properties: {
					selected: 	{type: "boolean", defaultValue: false},
					defaulted: 	{type: "boolean", defaultValue: false},
					enables:	{type: "string"},
					disables:	{type: "string"},
					text:		{type: "string"},
					value:		{type: "string"}
				},
				aggregations: {
					children: {type: "sap.ui.core.Control", multiple: true}
				},
				defaultAggregation: "children"
		},
		
		init: function() {
			this.attachSelect(function(oEvt){
				var that = oEvt.getSource();
				var value = oEvt.getParameter("selected");
				var alternativlos = oEvt.getParameter("alternativlos");
				if (gSUMGlobals.nextButton) {
//					if (!value && that.getEnables()) gSUMGlobals.nextButton.setEnabled(true); // beim Ausschalten von Enables erstmal Next aktivieren
//todo					if (value && that.getDisables()) gSUMGlobals.nextButton.setEnabled(true); // beim Einschalten von Disables erstmal Next aktivieren
					if (that.oCheckBox && alternativlos && (gSUMGlobals.nextButton.decision !== "renderer")) {
						gSUMGlobals.handleNext();
						gSUMGlobals.nextButton.decision = "select";
					}
				}
				var groups = findChildren(that.getChildren(), "SUMControls.Group");
				for (var i=0; i<groups.length; i++) {
					if (groups[i].data("sumid") === that.getEnables()) groups[i].mkVisible(value);
					else groups[i].mkVisible(!value);
					groups[i].rerender();
				}
			});			
		},
		
		createCheckBox: function() {
			this.oCheckBox = new CheckBox({text: this.getText(), enables: this.getEnables(), disables: this.getDisables(), tooltip: this.getText(), required: true});
			this.addDependent(this.oCheckBox); //alternativlos checkboxes are now "dependents", in order to find their parent in CheckBox.js
			var children = this.getChildren();
			for (var i=0; i<children.length; i++) {
				if (children[i].getMetadata().getElementName() === "SUMControls.Group") 
					children[i].setProperty("visible", (children[i].data("sumid") === this.getDisables()) ? !this.getDefaulted(): this.getDefaulted(), true);
				this.oCheckBox.addAggregation("children", children[i], true);
			}
			this.oCheckBox.setProperty("selected", this.getDefaulted(), true);
			this.oCheckBox.attachSelect($.proxy(function(evt){this.fireSelect({selected: evt.getParameter("selected"), alternativlos: true});}, this)); 
		},
		
		onBeforeRendering: function(oEvt) {
			var oControl = oEvt.srcControl;
			oControl.setTooltip(oControl.getText());
			if (oControl.getParent().aRBs.length === 1) {
				if (!oControl.oCheckBox) oControl.createCheckBox();
				if (gSUMGlobals.nextButton) {
					gSUMGlobals.handleNext();
					gSUMGlobals.nextButton.decision = "renderer";
				}
			}
		},
		
	    renderer: function(oRm, oControl) {
	    	oRm.write("<div style=\"width: 100%;\">");	    	
			oRm.write("<div style=\"display:flex; flex-direction: row; \">");
			if (oControl.oCheckBox) oRm.renderControl(oControl.oCheckBox);
			else sap.m.RadioButtonRenderer.render(oRm, oControl);			
			findChildren(oControl.getChildren(), "SUMControls.Hint").forEach(function(a){oRm.renderControl(a);});
			oRm.write("</div>");			
			findChildren(oControl.getChildren(), "SUMControls.Group").forEach(function(a) {
				oRm.write("<div style=\"margin-left: 40px;\">");
				oRm.renderControl(a);
				oRm.write("</div>");
			});			
		    oRm.write("</div>");
	    },
		
	    onAfterRendering: function(oEvt) {
	    	var that = oEvt.srcControl;
	    	if (that.oCheckBox) $("#"+that.oCheckBox.getId()+"-CbBg").attr("sumid", that.getParent().data("sumid"));
			$("#"+that.getId()).attr("sumid", that.getParent().data("sumid")+"-"+that.getValue());
		},
		
        exit: function() {
    		if (this.oCheckBox) {
				this.removeAllDependents();
    			this.oCheckBox.destroyChildren();		// destroy aggregated children
    			this.oCheckBox.destroy();
    			delete this.oCheckBox;
    		}
    		this.destroyChildren(); 					// destroy own children
    	}
	});
	
  return RButton;
});  