sap.ui.define([
    "sap/m/RadioButtonGroup"
], function(RadioButtonGroup) {
    "use strict";

	var RadioButtonBox = RadioButtonGroup.extend("SUMControls.RadioButtonBox", {
		metadata: {
			aggregations: {
				buttons: {type: "SUMControls.RadioButton"}
			},
		},
		
		renderer: function(oRm, oControl) {
	//    	oRm.addClass("sapUiNoMargin");
	        oRm.addStyle('width', '100%');
			oRm.addStyle('margin-top', '0.75rem');
	        sap.m.RadioButtonGroupRenderer.render(oRm, oControl);
	    },
		
		onAfterRendering: function(oEvt) {
			this.onkeydown = null; 								// this helps handling the arrow keys in input fields
			if (this.aRBs.length > 1) { 						// this is for RadioButtonGroups that have no default selection (DownConfBck)
				var selected = false;
				this.aRBs.forEach(function(a){if (a.getSelected()) selected = true;});
				if (!selected) {
					this.addStyleClass("sapMLabelRequired"); 	// to get this control handled as a mandatory one
					var m;
					this.attachSelect((m = function(){
						for (var i = 0; i < gSUMGlobals.mdtArry.length; i++)
							if (gSUMGlobals.mdtArry[i].inpId === this.getId()) {gSUMGlobals.mdtArry[i].fulfilled = true; break;}						
						if (gSUMGlobals.nextButton) gSUMGlobals.handleNext();
						this.detachSelect(m);
					})); 
				}
			}
		} 

	});
	
	return RadioButtonBox;
});  