jQuery.sap.require("sap.ui.core.util.Export");
jQuery.sap.require("sap.ui.core.util.ExportTypeCSV");
sap.ui.define([
    "sap/m/Table",
    "sap/m/Button"
], function(Table, Button) {
  "use strict";

	var SUMTable = Table.extend("SUMControls.Table", {		// call the new Control type "sum:Table" 
															// and let it inherit from sap.m.Table
		metadata: {
			properties: {
				dynamic: 	{type: "boolean", defaultValue: false},
				export: 	{type: "boolean", defaultValue: false} //eslint-disable-line 
			}
		},
		
		init: function() {
			this.setSticky([sap.m.Sticky.ColumnHeaders]);
		},
		
		onAfterRendering: function(oEvt) {
	        var tb = this.getHeaderToolbar();
			if (tb && !tb.getContent().length) {
				if (this.getDynamic() || this.getExport()) {
					tb.addContent(new sap.m.ToolbarSpacer());
					this.setSticky([sap.m.Sticky.HeaderToolbar, sap.m.Sticky.ColumnHeaders]);
				} 
				else this.destroyHeaderToolbar();
				if (this.getDynamic()) {
					tb.addContent(new Button({
	//	        		text: "Add",
						icon: "sap-icon://add",
						tooltip: ["Add one Row"],
						press: function() {
							var aCells = [];
							var oTab = this.getParent().getParent();
							var aCols= oTab.getColumns();
							for (var c = 0; c < aCols.length; c++){
								var opts = {}; 
								var oCol = aCols[c];
								var colElm = oCol.data("uiElem");
								var colElmBWSlash = oCol.data("bwslash");
								if (colElmBWSlash) opts.bwslash = JSON.parse(colElmBWSlash);
								var colElmEndswith = oCol.data("endswith");
								if (colElmEndswith) opts.endswith = colElmEndswith;
								var modelClass = jQuery.sap.getObject((colElm.substr(0, 4) === "sum:") ? "SUMControls." + colElm.substr(4) : "sap.m." + colElm); 
								aCells.push(new modelClass(opts));
							}
							oTab.addItem(new sap.m.ColumnListItem({cells: aCells}));
							oTab.rerender();
						}
					}));
					tb.addContent(new Button({
	//	        		text: "Remove",
						icon: "sap-icon://less",
						tooltip: ["Remove one Row"],
						press: function() {
							var iIndex = this.getParent().getParent().indexOfItem(this.getParent().getParent().getSelectedItem());
							if (iIndex === -1) sap.m.MessageToast.show("Please first select the row you wish to remove!");
							else this.getParent().getParent().getAggregation("items")[iIndex].destroy();
							this.getParent().getParent().rerender();
						}
					}));
					// below we capture the focus event on an arbitrary input field and trigger a selection event on the corresponding row
					this.getAggregation("items").forEach(function(a){a.getAggregation("cells").forEach(function(b){
					   $("#"+b.getId()+"-inner").focus($.proxy(function(){sap.ui.getCore().byId(this.getId()).setSelected(true);}, a));
					});});
				}
				if (this.getExport()) {
					tb.addContent(new Button({
	//	        		text: "Download",
						icon: "sap-icon://download",
						tooltip: ["Download Content"],
						press: function() {
							var aColumns = this.getParent().getParent().getColumns();
							var aItems = this.getParent().getParent().getItems();
							var aTemplate = [];
							var jStr = "[" ;
							for (var i = 0; i < aItems.length; i++) {
								jStr += "{";
								for (var j = 0 ; j < aColumns.length; j++) {
									var x = aItems[i].getAggregation("cells")[j];
									var y = ((typeof x.getText === "function") ? x.getText() : x.getValue());
									if (i == 0) aTemplate.push({name: aColumns[j].getHeader().getText(), template: {content: {path: aColumns[j].getHeader().getText()}}});
									jStr += '"' + aColumns[j].getHeader().getText() + '":"' + y + '"';
									if (j != aColumns.length - 1) jStr += ",";
								}
								if (i == aItems.length-1) jStr += "}";
								else jStr += "},\n";
							}
							jStr += "]";
							
							var oModel = new sap.ui.model.json.JSONModel();
							oModel.setJSON(jStr);
							var oExport = new sap.ui.core.util.Export({  
								exportType: new sap.ui.core.util.ExportTypeCSV({separatorChar: ";", charset : "utf-8" }), 	// Type that will be used to generate the content. Own ExportType's can be created to support other formats    
								models: 	oModel,
								rows: 		{path: "/"},
								columns: 	aTemplate 
							});  
							oExport.saveFile().catch(function(oError) {							// download exported file 
								sap.m.MessageBox.error("Error when downloading data. Browser might not be supported!\n\n" + oError);  
							}).then(function() {oExport.destroy();});  
						}
					}));
				}
			}
        	// handle Master-Checkbox if available 
			var aCols = this.getColumns();
			for (var i = 0; i < aCols.length; i++) if ((aCols[i].getHeader()) && (aCols[i].getHeader().getMetadata().getElementName() === "SUMControls.CheckBox")) {
				this.col = i;
				aCols[i].getHeader().attachSelect($.proxy(function(evt){
					var aItems = this.getItems();
					for (var j = 0; j < aItems.length; j++) aItems[j].getCells()[this.col].setSelected(evt.getParameter("selected"));
				}, this));
			}
			// remove empty table headers for better visual proportions
			for (var i = 0; i < aCols.length; i++) if ((aCols[i].getHeader()) && (aCols[i].getHeader().getMetadata().getElementName() === "sap.m.FormattedText") && (aCols[i].getHeader().getHtmlText() === "")) aCols[i].destroyHeader();
			// set keyboard navigation to reach all cells via TAB key 
			this.setKeyboardMode("Edit");
			this.setFixedLayout(false);   //optimize columns 
		},

		renderer: function(oRm, oControl) {
			oControl.setMode(sap.m.ListMode.SingleSelectMaster);
	        oRm.addStyle('word-wrap', 'break-word');   //wrap text in columns if width too small -  
	        sap.m.TableRenderer.render(oRm, oControl);
	    }
	});
	
  return SUMTable;
});  
