sap.ui.define([
        "sap/ui/core/mvc/Controller"
], function (Controller) {
"use strict";
        return Controller.extend("SoftwareUpdateManager.BaseController", {
                oSLPAPI: null,
                monitorFastTimer: 3000, 		//initial Monitor polling timer (milliseconds)
                monitorActTimer: 3000, 			//actual Monitor polling timer (milliseconds)
                monitorSleepTimer: 30000,		//in-dialog sleep Monitor polling timer (milliseconds)
                monitorFastPoll: 10,			//number of fast Monitor polling cycles 
                monitorMedPoll: 5,				//number of medium Monitor polling cycles
                monitorActPoll: 0,				//counter
                manactFastTimer: 5000, 			//initial ManAct polling timer (milliseconds)
                manactActTimer: 5000, 			//actual ManAct polling timer (milliseconds)
                manactFastPoll: 10,				//number of fast ManAct polling cycles
                manactActPoll: 0,				//counter
                manactTimer: 0,					//timer handler for ManAct; zero if no timer is set
                daemonsActTimer: 15000, 		//actual ManAct polling timer (milliseconds)
                daemonsTimer: 0,				//timer handler for Daemons; zero if no timer is set
                
                /**
                 * Convenience method for accessing the router.
                 * @public
                 * @returns {sap.ui.core.routing.Router} the router for this component
                 */
                getRouter: function() {
                    return sap.ui.core.UIComponent.getRouterFor(this);
                },
                /**
                 * Convenience method for getting the view model by name.
                 * @public
                 * @param {string} [sName] the model name
                 * @returns {sap.ui.model.Model} the model instance
                 */
                getModel: function(sName) {
                    return this.getView().getModel(sName);
                },
                /**
                 * Convenience method for setting the view model.
                 * @public
                 * @param {sap.ui.model.Model} oModel the model instance
                 * @param {string} sName the model name
                 * @returns {sap.ui.mvc.View} the view instance
                 */
                setModel: function(oModel, sName) {
                    return this.getView().setModel(oModel, sName);
                },
                /**
                 * Getter for the resource bundle.
                 * @public
                 * @returns {sap.ui.model.resource.ResourceModel} the resourceModel of the component
                 */
                getResourceBundle: function() {
                    return this.getOwnerComponent().getModel("i18n").getResourceBundle();
                },
                               
                refreshDialog: function() {
                    var cbRefresh = function(xml) {
                        try {gSUMGlobals.oFragment = this.oFragment = sap.ui.xmlfragment({id: "idXmlFragSAPupMain", fragmentContent: xml}, this.getView().getController());} catch(e) {
                            this.setModel(new sap.ui.model.json.JSONModel({}), "failedFragment");
                            this.getModel("failedFragment").setData({ 	errorText: 		"Dialog fragment cannot be instantiated.", 
                            											errorDetails:	e.message,
                            											data: 			xml											});
                            this.oErrDialog = sap.ui.xmlfragment("SoftwareUpdateManager.view.Error", this);
                            this.getView().addDependent(this.oErrDialog);
                            this.oErrDialog.open();
                            return;
                        }
						sap.ui.core.CustomData.prototype.getWriteToDom=function(){return (this.getKey() === "id");};
                        this.oFragment.addStyleClass("sapUiSizeCompact");
                        try {this.getView().byId("vbox0").addItem(this.oFragment);} catch(e) {};
                        this.oFragment.addEventDelegate({	onsapenter: 		function(){if (gSUMGlobals.nextButton && gSUMGlobals.nextButton.getEnabled()) gSUMGlobals.nextButton.firePress();},  	// attach SUBMIT action on ENTER key event
                        									onAfterRendering: 	$.proxy(this.onDialogReady, this)	});
                        this.onSecContentRefresh();
						if (SUMControls.Browser) SUMControls.Browser.prototype._semaphore = false; //be more resilient against SAPup crash while filebrowsing
                    };
                    
                	function _pullDialogs(that) {
                		return new Promise(
                				function(resolve, reject) {
									that.reject = reject;
                					function rec(that){that.oSLPAPI.getDialogs(function(xml){if ($(xml).find("Dialog").length) resolve(xml); else rec(that);}, $.proxy(function(){this.reject(this);}, that));}
                					rec(that);		            
                				}
                		);
                	}
                    
                    if (this.oFragment) this.oFragment.destroy();
					this.getView().byId("vbox0").destroyItems();
					
					_pullDialogs(this).then($.proxy(function() {
						this.oSLPAPI.getFragment($.proxy(cbRefresh, this), gSUMGlobals.genericError, "");
	                    this.oSLPAPI.getRoadmap($.proxy(processRoadmap, this), gSUMGlobals.genericError);
						this.oSLPAPI.getActions($.proxy(handleSpecialButtons, this), gSUMGlobals.genericError);
						this.oSLPAPI.getConfig($.proxy(loadConfigSuccess, this), gSUMGlobals.genericError);
					}, this), function(that){if (that.cleanupTriggered) that.exitPage(); else gSUMGlobals.genericError();});
                },

                checkMon: function(data, init) {
					function mask(data) {
						var obj;
						if ((obj = $(data).find("estimate"))) obj.remove();
						if ((obj = $(data).find("diskFreeKBytes"))) obj.remove();
						if ((obj = $(data).find("diskChkTmst"))) obj.remove();
						return data;
					}
                    var cbChkMonitor = function(data) {
						if (this.semaMon) return;
                        if (slpxml2json(mask(data), true).hash !== this.oldHash) {
                        	this.oMessagePopover.close();
                        	this.getView().byId("idErrorMsg").setVisible(false);
							this.semaDlg = false;	// release semaphore for refreshDialog()
                        	this.pullMon();
                        }
						else this.monSleep = setTimeout($.proxy(this.checkMon, this), this.monitorSleepTimer);
                    };
					if (init) this.oldHash = slpxml2json(mask(data), true).hash;
					if (this.semaMon) return;
                    this.oSLPAPI.getMonitor($.proxy(cbChkMonitor, this), function(xhr, status){gSUMGlobals.popupError('Cannot read status from SUM: '+xhr.status+'\n\nNo connection to serverside SUM process.\nPlease reload the page (press F5).');});
                },
                
                pullMon: function() {
                    var cbMonitor = function(data) {
                        var oMonitor = slpxml2json(data).json;                       
                        var taskArray = arrayify(oMonitor.monitor.Task);                        
                        if (taskArray.length === 0) gSUMGlobals.genericError();
                        else {
             				// identify the Id step Id and a road map type task
                            var stepTaskID = "", roadMapId = "", subprogress = -1, progressMessage = "", subprogressMessage = "", subEstimate = "", subLeft = "", phStarted = "";
                			var enableBucketIcon = false;
    	    				for (var x = 0; x < taskArray.length; x++) {
    	    					if (taskArray[x].type === "slp.task.type.STEP") {
									stepTaskID = taskArray[x].id;
									phStarted = taskArray[x].startedAt ? "Started at: " + utils.Formatter.tmStpFormatter(taskArray[x].startedAt) : "";
									if (typeof taskArray[x].progress != "undefined") {
										subprogress = parseFloat(taskArray[x].progress);
										subprogressMessage = taskArray[x].progressMessages.ProgressMessage.message;
										subEstimate = taskArray[x].estimate ? taskArray[x].estimate : "";
										subLeft = $(data).find("estimate")[1] ? $(data).find("estimate")[1].getAttribute("left") : "";
										if (subprogressMessage === progressMessage) subprogressMessage = "";
									}
								}
    	    					else if (taskArray[x].type === "slp.task.type.ROADMAP.TECH") {
    	    						roadMapId = taskArray[x].id;
									progressMessage = taskArray[x].progressMessages.ProgressMessage.message;
    	    					}
								else if ((taskArray[x].type === "slp.task.type.INTERNAL_SUBSTEP") && (typeof taskArray[x].progress != "undefined")) {
									subprogress = parseFloat(taskArray[x].progress);
									subprogressMessage = taskArray[x].progressMessages.ProgressMessage.message;
									subEstimate = taskArray[x].estimate ? taskArray[x].estimate : "";
									subLeft = $(data).find("estimate")[1] ? $(data).find("estimate")[1].getAttribute("left") : "";
									if (subprogressMessage === progressMessage) subprogressMessage = "";
									enableBucketIcon = (taskArray[x].status === "slp.task.state.ACTION_REQUIRED"); 
								}
    	    				}
							this.getView().byId("subProgress").setVisible((subprogress > -1) && (taskArray[0].status === "slp.task.state.RUNNING"));
							if ((taskArray[0].hasPhaseMonitor === "1") && (taskArray[0].status === "slp.task.state.RUNNING")) {
								this.oLMSLAPI.getPhMon($.proxy(function(xml) {
			                        if (typeof xml !== "string") xml = new XMLSerializer().serializeToString(xml);
									this.getModel("phMonModel").setData({content: xml});
									this.getModel("phMonModel").refresh(true);
									this.getView().byId("hbox0").setVisible(xml.length > 15);
								}, this), function(){/*ignore failed calls*/});
							} else this.getView().byId("hbox0").setVisible(false);
							this.getView().byId("idFailedBck").setVisible(enableBucketIcon);
							var curPhase = taskArray[0].progressMessages.ProgressMessage.message;
							// substitute technical information by dummy text
							if (curPhase === "SUM ABAP process started") {curPhase = "Software Update Manager"; phStarted = "";}
    	                    this.getModel("monitorModel").setData({ 
    	                    	progress: parseFloat(taskArray[0].progress), 
								progressMessage: progressMessage,
    	                    	currentPhase: curPhase,
								phStarted: phStarted,
    	                    	currentModule: roadMapId,
    	                    	currentStep: stepTaskID,
    	                    	status: taskArray[0].status,
    	                    	estimate: taskArray[0].estimate ? taskArray[0].estimate : "",
    	                    	left: $(data).find("estimate")[0] ? $(data).find("estimate")[0].getAttribute("left") : "",
    	                    	subEstimate: subEstimate,
    	                    	subLeft: subLeft,
								subprogress: subprogress,
								subprogressMessage: subprogressMessage
    	                    });    	                    

    	                    if (taskArray[0].status === "slp.task.state.DIALOG" || taskArray[0].status === "slp.task.state.ERROR" || taskArray[0].status === "slp.task.state.FINISHED" || taskArray[0].status === "slp.task.state.BREAKPOINT")   
                            {
                                if (!this.semaDlg) {
                            		this.monitorActPoll = 0;
                        	        this.getView().byId("idOverflowToolbar").setVisible(true);
                    	            this.getView().byId("vbox0").setVisible(true);
                	                this.getView().byId("loaderBox").setVisible(false);  
            	                    this.semaDlg = true;		// will be reset in postToResource(), exit, reset, cleanup, and cbChkMonitor() 
    		                       	this.refreshDialog();
									this.dialogId = taskArray[0].dialogId && taskArray[0].dialogId.split("|");
								}
                            	// these 2 make sense for debugging... 
                            	//this.oSLPAPI.getRoadmap($.proxy(processRoadmap, this), gSUMGlobals.genericError);
                            	//setTimeout($.proxy(this.pullMon, this), this.monitorActTimer);
                            	this.monSleep = setTimeout($.proxy(function(){this.checkMon(data, true);}, this), this.monitorSleepTimer);
                                if ((taskArray[0].status === "slp.task.state.FINISHED") && (taskArray[0].progress === "100")) this.pollFeedback = true;
                            }
                            else if (taskArray[0].status === "slp.task.state.RUNNING") {
        	                    this.oSLPAPI.getRoadmap($.proxy(processRoadmap, this), gSUMGlobals.genericError);
                            	setTimeout($.proxy(this.pullMon, this), this.monitorActTimer);
                            	if (!this.manactTimer) this.pullManAct();
                            }
                            else gSUMGlobals.genericError();
                            if (taskArray[0].error) {
								sap.m.MessageToast.show(taskArray[0].error, {duration: 3000});
								this.getView().byId("idErrorMsg").setText(taskArray[0].error).setVisible(true);
							} else this.getView().byId("idErrorMsg").setVisible(false);							
							updateDiskStatus(this.getView().byId("idDiskFree"), /*parseFloat(taskArray[0].diskUsedKBytes),*/ parseFloat(taskArray[0].diskFreeKBytes), taskArray[0].diskChkTmst);
							this.getView().byId("idOTBDesc").setHtmlText(taskArray[0].description ? "<span style=\"font-size: 12px\">" +taskArray[0].description + "</span>" : "");
							
							gSUMGlobals.guideInfo.loio = "";      // reference fallback to index page of current guide
							gSUMGlobals.guideInfo.section = "";
							
							if ("docLOIO" in taskArray[0]) {
							    gSUMGlobals.guideInfo.loio = taskArray[0].docLOIO;
							    
							    if ("docDB" in taskArray[0]) {
							        gSUMGlobals.guideInfo.db = taskArray[0].docDB;
							    }
							    
							    if ("docOPT" in taskArray[0]) {
                                    gSUMGlobals.guideInfo.opt = taskArray[0].docOPT;
                                }
                                
                                if ("docSection" in taskArray[0]) {
                                    gSUMGlobals.guideInfo.section = taskArray[0].docSection;
                                }
							}
                        }
						this.semaMon = false;
                    };
                    /* Adaptive stepwise Monitor Polling */
                    if (++this.monitorActPoll < this.monitorFastPoll) this.monitorActTimer = this.monitorFastTimer;
                    else if (this.monitorActPoll < (this.monitorFastPoll + this.monitorMedPoll)) this.monitorActTimer = 2 * this.monitorFastTimer;
                    else this.monitorActTimer = 3 * this.monitorFastTimer;
                    
                    this.getView().byId("idOverflowToolbar").setVisible(false);
                    this.getView().byId("vbox0").setVisible(false);
                    this.getView().byId("loaderBox").setVisible(true);                    
					this.getView().setBusy(false);
					this.pollFeedback = false;
                    
					this.semaMon = true;
                    this.oSLPAPI.getMonitor($.proxy(cbMonitor, this), gSUMGlobals.genericError);
                },
                
                pullManAct: function() {
                    var cbManAct = function(content)
                    {
                        /* Adaptive stepwise ManAct Polling */
                        if (++this.manactActPoll < this.manactFastPoll) this.manactActTimer = this.manactFastTimer;
                        else this.manactActTimer = 3 * this.manactFastTimer;

                        var countInfo = 0;
                        var countError = 0;

                        var contentXML = content;
                        if (typeof contentXML === "string") contentXML = $.parseXML(contentXML);

                        var contentString = content;
                        if (typeof contentString === "object") contentString = new XMLSerializer().serializeToString(contentString);

                        this.getModel("manual_actions").setXML(contentString);
                        this.getModel("manual_actions").refresh(true); 
                        var currentManualActionsJXML = $(contentXML);
                        var countInfo = currentManualActionsJXML.find("action>type:contains(Information)").length;
                        var countWarning = currentManualActionsJXML.find("action>type:contains(Warning)").length;
                        var countError = currentManualActionsJXML.find("action>type:contains(Error)").length;
                        var checksIcon = this.getView().byId("idManAct");
                        if (countError > 0) {
							checksIcon.setIcon("sap-icon://error");
                        	checksIcon.setVisible(true);
                        	checksIcon.setType(sap.m.ButtonType.Reject);
                        	checksIcon.setTooltip("There are unprocessed items");
                        }
                        else if (countWarning > 0) {
							checksIcon.setIcon("sap-icon://message-warning");
                        	checksIcon.setVisible(true);
                        	checksIcon.setType(sap.m.ButtonType.Ghost); //customized as orange icon
                        	checksIcon.setTooltip("There are unprocessed items");
                        }
                        else if (countInfo > 0) {
							checksIcon.setIcon("sap-icon://message-information");
                        	checksIcon.setVisible(true);
                        	checksIcon.setType(sap.m.ButtonType.Neutral);
                        	checksIcon.setTooltip("Information available");
                        }
                        else {
                        	checksIcon.setVisible(false);
                        }
                    	if (!this.getModel("monitorModel").getData().status || (this.getModel("monitorModel").getData().status === "slp.task.state.RUNNING")) this.manactTimer = setTimeout($.proxy(this.pullManAct, this), this.manactActTimer);
                    	else this.manactActPoll = this.manactTimer = 0;
                    };
                    this.oLMSLAPI.getManAct($.proxy(cbManAct, this), gSUMGlobals.genericError);
                },
                
                _getDaemonLength: function(xml, status) {
                	return xml.find("daemon[status='" + status + "']").length;
                },
                
                pullDaemons: function() {
                    var cbDaemons = function(xml) {
                        var daemonsXML = $(xml);
                        
                        var statusLength = this._getDaemonLength(daemonsXML, "STARTING") +
                        				   this._getDaemonLength(daemonsXML, "RUNNING")  +
                        				   this._getDaemonLength(daemonsXML, "STOPPED")  +
                        				   this._getDaemonLength(daemonsXML, "NULL");
                        
                        var enableDaemonIcon = (daemonsXML.find("daemon").length !== statusLength);
						this.getView().byId("idFailedDmn").setVisible(enableDaemonIcon);
						this.daemonsTimer = setTimeout($.proxy(this.pullDaemons, this), this.daemonsActTimer);						
                    };
                    this.oLMSLAPI.getDaemons($.proxy(cbDaemons, this), $.proxy(function(xhr, status){gSUMGlobals.genericError(xhr, status); this.daemonsTimer = setTimeout($.proxy(this.pullDaemons, this), this.daemonsActTimer);}, this));
                },
				
				onDialogReady: function() {						// this event is triggered when Dialog has been completely rendered
					gSUMGlobals.handleMdt();
					if (this.pollFeedback && !this.evalSent) {
						$("a[target='_self']").click(launchFeedbackFormDialog);
						launchFeedbackFormDialog("once");
					}	
					$("a[target='download']").click(function(evt){
						evt.preventDefault();
						var that = {};
						that.file = evt.target.href.substr(evt.target.href.lastIndexOf("/")+1);
						var xhr = new XMLHttpRequest(); 
						xhr.open("GET", "../log/" + encodeURIComponent(that.file)); 
						xhr.responseType = "blob";
						xhr.onload = $.proxy(function() { 
							if (window.navigator.msSaveOrOpenBlob) window.navigator.msSaveBlob(xhr.response, this.file);
							else {
								var elem = window.document.createElement('a');
								elem.href = window.URL.createObjectURL(xhr.response);
								elem.download = this.file;        
								document.body.appendChild(elem);
								elem.click();        
								document.body.removeChild(elem);
							}    		
						}, that);
						xhr.send();          	
					});
				}
        }
    );
});

