sap.ui.define([
    "SoftwareUpdateManager/controller/BaseController",
    "sap/ui/model/json/JSONModel",
    "sap/ui/model/xml/XMLModel",
], function (BaseController, JSONModel, XMLModel) {
    "use strict";


    return BaseController.extend("SoftwareUpdateManager.controller.View1", {
        oLogDialog: null,
        oSLPAPI: null,
        onInit: function() {
			this.evalSent = 0;
        	this.cbKeyValues = function(xml){
                if (typeof xml === "string") xml = $.parseXML(xml);
                this.evalSent = Boolean($(xml).find("KeyValuePairs>Property[key='Evaluation_sent'][value='yes']").length);
        	};
			this.doOnce = true;
			lmslToolWakeUp();
        	gSUMGlobals.oSLPAPI = this.oSLPAPI = new SLPApi(gSUMGlobals.pathSlpAbap);
        	gSUMGlobals.oLMSLAPI = this.oLMSLAPI = new LMSLApi(gSUMGlobals.pathLmslAbap);
            this.oLMSLAPI.getMetaInfo($.proxy(getVersionString, this), gSUMGlobals.genericError);

            this.setModel(new JSONModel({}), "currentLogFile");
            this.setModel(new JSONModel({}), "currentConfig");
            this.setModel(new JSONModel({}), "monitorModel");
            var x = new JSONModel({});
            x.setDefaultBindingMode("OneWay");
            this.setModel(x, "roadmapModel");
            this.setModel(new JSONModel({}), "breakpointModel");
            this.setModel(new JSONModel({}), "tasklistModel");
			this.setModel(new JSONModel({}), "actions");
			this.setModel(new JSONModel({}), "phMonModel");
            this.pullMon();
            this.oSLPAPI.getActions($.proxy(handleSpecialButtons, this), gSUMGlobals.genericError);
            this.oSLPAPI.getLogs($.proxy(logHandler, this), gSUMGlobals.genericError);

			// ************ initialize dynamicSideContent ****************
			this.splitCont = this.getView().byId("splitCont");
			this.splitter = this.getView().byId("idSumMainPage");
			this.splitter._onParentResize = function(){
				var hook = this.getParent().byId("idSumMainPage2");
				if (this._getHiddenPanes().length) {
					if (hook.hasStyleClass("pageFull")) {
						hook.removeStyleClass("pageFull");
						hook.addStyleClass("pageFlip");
					}
				} else {
					if (hook.hasStyleClass("pageFlip")) {
						hook.removeStyleClass("pageFlip");
						hook.addStyleClass("pageFull");
					}
				}
				// taken from SAPUI5 lib V 1.63.1
				var i=this._intervalHasChanged(),r=this.getRootPaneContainer();if(i&&r){this._arrangeContent();this._setPaginatorVisibility();}
			};
			this.tasklistPane = this.getView().byId("idTasklistPane");
			this.breakpointPane = this.getView().byId("idBreakpointPane");
			this.logPane = this.getView().byId("idLogPane");

			this.splitCont.removePane(this.tasklistPane);
			this.splitCont.removePane(this.breakpointPane);
			this.splitCont.removePane(this.logPane);
			
			this.setModel(new XMLModel(), "manual_actions");
            this.oMessageTemplate = new sap.m.MessagePopoverItem({
                type: 				'{type}',
                title: 				'{title}',
				subtitle:			'{id}',
                description: 		'{description}',
				counter:			1,
                markupDescription: 	true
            });
            this.oMessagePopover = new sap.m.MessagePopover({
                items: {path: '/action', template: this.oMessageTemplate},
                initiallyExpanded: true,
				placement: "Bottom",
				headerButton: new sap.m.Button({id: "idRst", text: "Restore Hidden", press: function(){
					gSUMGlobals.optOut = [];
					document.cookie = "optout=; expires=Sat, 24 Jan 1970 00:00:00 UTC;";
					this.setVisible(false);
					this.getParent().getParent().getParent().getParent().invalidate();
				}}).addStyleClass("sapUiSizeCompact").setVisible(false),
                afterClose: $.proxy(function() {this.popped = this.popped2 = false;}, this),                
				asyncURLHandler: function(config){
					config.promise.resolve({
						allowed: (config.url.lastIndexOf("http", 0) === 0),
						id: config.id
					});
				}
            });
            this.oMessagePopover.setModel(this.getModel("manual_actions"));
			this.oMessagePopover._oPopover.setContentWidth("800px").setResizable(true);	
			this.rmNav = function(){this.oMessagePopover._oPopover._getPopup().getContent().setFooter(null);};
			this.refrNav = function(list) {
//				var idx = list.indexOf(this.oMessagePopover._oMessageView._oLastSelectedItem);
				/* correction of the "_oLastSelectedItem" */
				var that = {id: "", idx: -1};
				if (this.oMessagePopover._oMessageView._oLastSelectedItem) {
					that.id = this.oMessagePopover._oMessageView._oLastSelectedItem.getId();
					that.id = that.id.substr(0, that.id.lastIndexOf("-"));
					list.forEach(function(a, b){if (a.getId().substr(0, a.getId().lastIndexOf("-")) === this.id) this.idx = b;}, that);
				}
				if (that.idx > -1) this.oMessagePopover._oMessageView._oLastSelectedItem = list[that.idx];
				/* end of correction of the "_oLastSelectedItem" */
				var idx2;
				for (idx2 = that.idx - 1; ((idx2 >= 0) && (gSUMGlobals.optOut.indexOf(list[idx2].getSubtitle()) != -1)); idx2--);
				this.prev.setEnabled(idx2 >= 0) ;
				for (idx2 = that.idx + 1; ((idx2 < list.length) && (gSUMGlobals.optOut.indexOf(list[idx2].getSubtitle()) != -1)); idx2++);
				this.next.setEnabled(idx2 < list.length);
			};
			this.oNavButtons = new sap.m.Toolbar({content : [
				(this.prev = new sap.m.Button({text: "Previous", press: $.proxy(function(){
					var idx, idx2;
					for (idx = (idx2 = this.oMessagePopover._oMessageView.getItems().indexOf(this.oMessagePopover._oMessageView._oLastSelectedItem)) - 1; ((idx > 0) && (gSUMGlobals.optOut.indexOf(this.oMessagePopover._oMessageView._oLists.all.getItems()[idx].getDescription()) != -1)); idx--);
					this.oMessagePopover._oMessageView._fnHandleForwardNavigation(this.oMessagePopover._oMessageView._oLists.all.getItems()[gSUMGlobals.optOut.indexOf(this.oMessagePopover._oMessageView._oLists.all.getItems()[idx].getDescription()) != -1 ? idx2 : idx], "show");
					this.refrNav(this.oMessagePopover._oMessageView.getItems());
				}, this)})), 
				new sap.m.ToolbarSpacer(), 
				(this.next = new sap.m.Button({text: "Next", press: $.proxy(function(){
					var idx, idx2;
					for (idx = (idx2 = this.oMessagePopover._oMessageView.getItems().indexOf(this.oMessagePopover._oMessageView._oLastSelectedItem)) + 1; ((idx < this.oMessagePopover._oMessageView.getItems().length - 1) && (gSUMGlobals.optOut.indexOf(this.oMessagePopover._oMessageView._oLists.all.getItems()[idx].getDescription()) != -1)); idx++);
					this.oMessagePopover._oMessageView._fnHandleForwardNavigation(this.oMessagePopover._oMessageView._oLists.all.getItems()[gSUMGlobals.optOut.indexOf(this.oMessagePopover._oMessageView._oLists.all.getItems()[idx].getDescription()) != -1 ? idx2 : idx], "show");
					this.refrNav(this.oMessagePopover._oMessageView.getItems());
				}, this)}))
			], design: "Transparent", height: "2rem"});
			this.oNavButtons.addStyleClass("sapUiSizeCompact");
			this.oNavButtons.addEventDelegate({
				onBeforeRendering: $.proxy(function(){this.refrNav(this.oMessagePopover._oMessageView.getItems());}, this)
			});
			this.oMessagePopover._oMessageView._detailsPage.mAggregations.customHeader.mAggregations.content[0].attachPress(this.rmNav, this);
			this.oMessagePopover.attachBeforeClose(this.rmNav, this);
			this.oMessagePopover.attachItemSelect($.proxy(function(oEvt){
				if (this.oMessagePopover._oMessageView.getItems().length > 1) this.oMessagePopover._oPopover._getPopup().getContent().setFooter(this.oNavButtons);
			}, this));
			this.byId("idManAct").addDependent(this.oMessagePopover);
			this.getView().byId("idLogTable").attachEvent("filter", function(evt){this.getView().byId("idGrepBtn").setText(evt.getParameter("value") ? "Search in filtered Files" : "Search in all Files");}, this);
			// unselect first roadmap icon (which is highlighted by default) if selection is not appropriate  
			this.getView().byId("idIconTabBar").addEventDelegate({
				onAfterRendering: function(evt){if ((evt.srcControl.getProperty("selectedKey") === "") && evt.srcControl.getItems()[0]) evt.srcControl.getItems()[0].$().removeClass("sapMITBSelected");}
			});
			this.autoScroll = true;		
			this.assignF1KeyForHelp();
//			this.getView().byId("idSID").setHtmlText("<span style=\"position:absolute;width:100%;font-size:10px;font-weight:bold;margin:-26px 0 0 -3px;text-align:center;\">" + gSUMGlobals.sid + "</span>");			
			this.getView().byId("idSID").setText(gSUMGlobals.sid).addStyleClass("sid");			
			gSUMGlobals.feedbackItem = this.getView().byId("idMoreMenuItemFeedback");
            this.oLMSLAPI.getSAPupKeyValues($.proxy(this.cbKeyValues, this), $.proxy(function(xhr, status){gSUMGlobals.genericError(xhr, status);}, this));

			this.pullManAct();
			this.pullDaemons();
        },
        
        onNotifToggle: function(oEvent) {
            var secondclick = false;
            var fullId = oEvent.mParameters.id;
            var pressedId = fullId.substring(fullId.indexOf("--") + 2);
            
            if (this.onNotifToggle.activeItem === "") //first click
            	this.onNotifToggle.activeItem = pressedId;
            if ((this.onNotifToggle.activeItem === pressedId) && this.oMessagePopover.isOpen()) {
                secondclick = true;					//2.click on same element, close
                this.oMessagePopover.close();
            }
            if (!secondclick) {
                switch (this.onNotifToggle.activeItem = pressedId) {
                    case "idManAct":
                    	this.oMessagePopover.openBy(oEvent.getSource());
                        break;
                }
            }
        },
        
        onFailedBck: function() {
        	var ind = document.URL.indexOf("?sui");
        	if (ind < 0 ) ind = document.URL.indexOf("&sui");
        	window.open("../slui_ext/"  + ((ind > 0) ? "?"+document.URL.slice(ind+1) : "") + "#buckets", "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");
        },
        
        onFailedDmn: function() {
        	var ind = document.URL.indexOf("?sui");
        	if (ind < 0 ) ind = document.URL.indexOf("&sui");
        	window.open("../slui_ext/"  + ((ind > 0) ? "?"+document.URL.slice(ind+1) : "") + "#daemons", "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");
        },
        
//		*** Info-Icon for HTML-Content in <doc>-Tag ***
//      onInfoHTML: function(oEvt) {
//			if (!this.popover) {
//				this.popover = new sap.m.Popover({placement: "Bottom", showHeader: false, contentWidth: "50%", resizable: true});
//				var html = new sap.ui.core.HTML({content: gSUMGlobals.infoHTML});
//				var box = new sap.m.FlexBox({items: [html]});
//				box.addStyleClass("sapUiTinyMargin");
//				this.popover.addContent(box);
//			}
//      	this.popover.openBy(oEvt.getSource());
//      },

		findBP: function(evt) {
			var idx = -1;
			gSUMGlobals.resizeBox.clearSelection();
			if (gSUMGlobals.resizeBox.getBinding() && gSUMGlobals.resizeBox.getBinding().getModel() && gSUMGlobals.resizeBox.getBinding().getModel().getData().breakpoints.Breakpoint) gSUMGlobals.resizeBox.getBinding().getModel().getData().breakpoints.Breakpoint.find(function(i,j){
				if ((i.status === "slp.breakpoint.status.AT")||(i.status === "slp.breakpoint.status.BEFORE")) {
					idx = j;
					return true; // this is to exit the each() loop when actual phase is found
				}
			});
			gSUMGlobals.resizeBox.setSelectedIndex(idx);
		},
        
        onSecContentToggle: function(oEvent) {
            var secondclick = false;
            var fullId = oEvent.mParameters.id;
            var pressedId = fullId.substring(fullId.indexOf("--") + 2);
            
            if (gSUMGlobals.resizeBox && this.onSecContentToggle.eventObj) 
            	gSUMGlobals.resizeBox.removeEventDelegate(this.onSecContentToggle.eventObj);

            if (gSUMGlobals.activeMenuItem === "") //first click
                gSUMGlobals.activeMenuItem = pressedId;

            if ((gSUMGlobals.activeMenuItem === pressedId) && (this.splitCont.getPanes().length > 1)) {
                secondclick = true;					//2.click on same element, close
            //	this.getView().byId("idSumMainPage2").addStyleClass("pageFull");
				this.splitCont.removePane(this.splitCont.getPanes()[1]);
                gSUMGlobals.resizeBox = null;
            }

            if (!secondclick) {
            //	this.getView().byId("idSumMainPage2").removeStyleClass("pageFull");
				if (this.splitCont.getPanes().length > 1) this.splitCont.removePane(this.splitCont.getPanes()[1]);
                switch (gSUMGlobals.activeMenuItem = pressedId) {
                    case "idMenuTasklist":
						this.splitCont.addPane(this.tasklistPane);
                    	this.autoScroll = true;
                        gSUMGlobals.resizeBox = this.getView().byId("idTasklistTable");
                        simulateTasklist(this, this.getModel("roadmapModel").getData().roadmap.selectedKey);
                    	this.onSecContentRefresh();
						$("td[id$='-col2']").each(function(){$(this).css("cursor", "pointer");});
						gSUMGlobals.resizeBox.fireCellClick = function(p) {
							if (p.cellControl.mBindingInfos.text) {
								var step = p.cellControl.mBindingInfos.text.binding.oValue;
								var file = p.cellControl.mBindingInfos.text.binding.oContext.getProperty("logs");
								if (["slp.task.state.INITIAL", "slp.task.state.SKIPPED"].indexOf(p.cellControl.mBindingInfos.text.binding.oContext.getProperty("status")) === -1)
								  this.getParent().getParent().getParent().getParent().getController().showLogWindow(null, step, file, null, null);
							}
						};
                    	break;
                    case "idMenuLogs":
						this.splitCont.addPane(this.logPane);
                        gSUMGlobals.resizeBox = this.getView().byId("idLogTable");
                    	this.onSecContentRefresh();
                        break;
                    case "idMenuBreakpoints":
						this.splitCont.addPane(this.breakpointPane);
                        gSUMGlobals.resizeBox = this.getView().byId("idBreakpointTable");
                    	gSUMGlobals.resizeBox.addEventDelegate(this.onSecContentToggle.eventObj = {onBeforeRendering: this.findBP}, gSUMGlobals.resizeBox);
                    	this.onSecContentRefresh();
                }
                if (gSUMGlobals.resizeBox) {
					gSUMGlobals.resizeBox.setVisibleRowCount(Math.floor(($(window).height() - (true ? 170 : 685)) / 34.3));
					$(window).resize(function(){if (gSUMGlobals.resizeBox) gSUMGlobals.resizeBox.setVisibleRowCount(Math.floor(($(window).height() - (true ? 170 : 685)) / 34.3));});
                }
            }
        },
        
		onGrep: function(oEvt) {
			new Grep(this);
        },
        
        onSecContentRefresh: function(oEvt) {
        	switch (gSUMGlobals.activeMenuItem) {
	            case "idMenuTasklist":
	            	this.oSLPAPI.getTasklist($.proxy(tasklistHandler, this), gSUMGlobals.genericError, this.getModel("roadmapModel").getData().roadmap.selectedKey);
	                break;
	            case "idMenuLogs":
	            	this.oSLPAPI.getLogs($.proxy(logHandler, this), gSUMGlobals.genericError);
	                break;
	            case "idMenuBreakpoints":
	            	updateBreakpoints(this, Boolean(oEvt), $.proxy(function(){
						this.findBP();
						setTimeout(function(){if (gSUMGlobals.resizeBox) {
							var idx = gSUMGlobals.resizeBox.getSelectedIndex();
							if (idx >= 0) gSUMGlobals.resizeBox.setFirstVisibleRow((idx>2) ? idx-3 : 0);						
						}}, 100); 
					}, this));
	            	this.oSLPAPI.getBreakpoints($.proxy(function(xml) {
						var resp = slpxml2json(xml).json;
						this.getView().byId("idStopNext").setPressed(resp && resp.breakpoints && resp.breakpoints.Breakpoint && resp.breakpoints.Breakpoint.enabled === "1");
					}, this), gSUMGlobals.genericError, "%2A");
        	}
        	if (oEvt) this.autoScroll = true;
	        if (gSUMGlobals.resizeBox) {
                for (var i = 0; i < gSUMGlobals.resizeBox.getColumns().length; i++) {
                    gSUMGlobals.resizeBox.getColumns()[i].setSorted(false);
                    gSUMGlobals.resizeBox.getColumns()[i].setFiltered(false);
                }
	        	gSUMGlobals.resizeBox.invalidate();
	        }
        },
        
        onSecContentClose: function() {
        	this.onSecContentToggle({mParameters: {id: "--" + gSUMGlobals.activeMenuItem}});
        },
        
        selectRoadMapStep: function(oEvt) {
			var roadmapItem;
			var roadmapIdx;
            var roadmap = this.getView().getModel("roadmapModel").getData().roadmap;
			if (!roadmap.Task.length) roadmap.Task = [roadmap.Task];
            var roadmapCtrl = this.getView().byId("idIconTabBar");
            // the assignment in the following line IS INTENDED! It is NOT meant as a condition! I notice this because ESLINT complains.
			if (roadmapItem = roadmap.Task.find(function(a,b){roadmapIdx = b; return (a.id === roadmap.selectedKey);})) //eslint-disable-line
				this.getView().byId("idTasklistRdmpStp").setText(roadmapItem ? "(" + roadmapItem.displayName + ")" : "");
            if (roadmap && (((roadmapIdx === 0) && this.doOnce) || (roadmapCtrl.getProperty("selectedKey") !== roadmap.selectedKey))) {
            	roadmapCtrl.setSelectedKey(roadmap.selectedKey);
            	this.onSecContentRefresh();
				this.doOnce = (roadmapIdx !== 0);
            }
            if (roadmap.selectedKey === "") roadmapCtrl.setProperty("selectedKey", "");
            roadmapCtrl.rerender();
        },
		
		onBreakpointBusy: function(oEvent) {
			gSUMGlobals.resizeBox.setBusy(true);
		},

		onBreakpointNoBusy: function(oEvent) {
			gSUMGlobals.resizeBox.setBusy(false);
		},

        onBreakpointChange: function(oEvent) {        	
            var idx = oEvent.getSource().getParent().getBindingContext("breakpoints").sPath;
            if (idx) idx = parseInt(idx.replace("/breakpoints/Breakpoint/", ""));
            var bpEnabled = oEvent.getParameter("selected");
            var bpObj = this.getModel("breakpoints").getData().breakpoints.Breakpoint[idx];
			if (bpEnabled) bpObj.enabled = "1"; else bpObj.enabled = "0";
			var bpPayload = "<breakpoints xmlns=\"http://www.sap.com/lmsl/slp\"><Breakpoint><id>" + bpObj.id + "</id>"
							+ "<technicalName>" + bpObj.technicalName + "</technicalName>"
							+ "<enabled>" + (bpEnabled|0) + "</enabled>"
							+ "<status>" + bpObj.status + "</status></Breakpoint></breakpoints>";			
			this.oSLPAPI.postBreakpoint($.proxy(function(){this.getModel("breakpoints").refresh();}, this), gSUMGlobals.genericError, bpPayload);
		},

        onStopNext: function(oEvent) {
/*        	updateBreakpoints(this, true, $.proxy(function(){
				var idx = -1;
				var bpArry = this.getModel("breakpoints").getData().breakpoints.Breakpoint;
				if (bpArry) bpArry.find(function(i,j){
					if (i.status === "slp.breakpoint.status.BEFORE") {
						idx = j;
						return true; // this is to exit the each() loop when next phase is found
					}
				});
				if (idx > -1) { 
					var bpPayload = "<breakpoints xmlns=\"http://www.sap.com/lmsl/slp\"><Breakpoint><id>" + bpArry[idx].id + "</id>"
									+ "<technicalName>" + bpArry[idx].technicalName + "</technicalName>"
									+ "<enabled>1</enabled>"
									+ "<status>" + bpArry[idx].status + "</status></Breakpoint></breakpoints>";		
					this.oSLPAPI.postBreakpoint($.proxy(function(){updateBreakpoints(this, true);}, this), gSUMGlobals.genericError, bpPayload);
				}
			}, this));
*/
			var bpPayload = "<breakpoints xmlns=\"http://www.sap.com/lmsl/slp\"><Breakpoint><id>*</id>"
				+ "<technicalName>*</technicalName>"
				+ "<enabled>" + (oEvent.getParameter("pressed")|0) + "</enabled>"
				+ "</Breakpoint></breakpoints>";		
			this.oSLPAPI.postBreakpoint($.proxy(function(){updateBreakpoints(this, true);}, this), gSUMGlobals.genericError, bpPayload); 
		},

        onMainMenuClick: function(oEvent) {
			var fullId = oEvent.getParameter("id");
            var pressedMenuId = fullId.substring(fullId.indexOf("--") + 2);
			switch (pressedMenuId) {
				case "idMenuMore":
		            var fullItemId = oEvent.getParameter("item").getId();
		            var pressedMenuItemId = fullItemId.substring(fullItemId.indexOf("--") + 2);
					var ind = document.URL.indexOf("?sui"), sep = "?"; if (ind < 0) {ind = document.URL.indexOf("&sui"); if (document.URL.indexOf("?") > 0) sep = "&";}
		            switch (pressedMenuItemId) {
						case "idMoreMenuHelp":
							openHelpWindow();					
							break;	
						case "idMoreMenuItemBelize":
							if (ind > 0) document.location.href = document.URL.slice(0, ind);
							if (gSUMGlobals.cookies) {
								document.cookie = "suiplus=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
								document.cookie = "suihcb=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
								document.cookie = "suihcw=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
							}
							break;	
						case "idMoreMenuItemPlus":
							if (ind > 0) document.location.href = document.URL.slice(0, ind) + sep + "suiplus=true";
							else document.location.href = document.URL + sep + "suiplus=true";
							if (gSUMGlobals.cookies) {
								document.cookie = "suiplus=true; expires=Tue, 19 Jan 2038 03:14:07 UTC; path=/;";
								document.cookie = "suihcb=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
								document.cookie = "suihcw=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
							}
							break;	
						case "idMoreMenuItemHCB":
							if (ind > 0) document.location.href = document.URL.slice(0, ind) + sep + "suihcb=true";
							else document.location.href = document.URL + sep + "suihcb=true";
							if (gSUMGlobals.cookies) {
								document.cookie = "suiplus=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
								document.cookie = "suihcb=true; expires=Tue, 19 Jan 2038 03:14:07 UTC; path=/;";
								document.cookie = "suihcw=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
							}
							break;	
						case "idMoreMenuItemHCW":
							if (ind > 0) document.location.href = document.URL.slice(0, ind) + sep + "suihcw=true";
							else document.location.href = document.URL + sep + "suihcw=true";
							if (gSUMGlobals.cookies) {
								document.cookie = "suiplus=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
								document.cookie = "suihcb=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
								document.cookie = "suihcw=true; expires=Tue, 19 Jan 2038 03:14:07 UTC; path=/;";
							}
							break;	
						case "idMoreMenuItemCookiesToggle":
							var x = this.getView().byId("__xmlview0--idMoreMenuItemCookies");
							var y = sap.ui.getCore().byId("__xmlview0--idMoreMenuItemCookiesToggle");
							gSUMGlobals.cookies = !gSUMGlobals.cookies;
							if (gSUMGlobals.cookies) {
								x.setIcon("sap-icon://accept");
								y.setText("Decline");
								document.cookie = "cookies=true; expires=Tue, 19 Jan 2038 03:14:07 UTC; path=/;";
							} else {
								x.setIcon("");
								y.setText("Allow");
								document.cookie = "cookies=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
								document.cookie = "optout=; expires=Sat, 24 Jan 1970 00:00:00 UTC;";
								document.cookie = "suiplus=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
								document.cookie = "suihcb=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
								document.cookie = "suihcw=; expires=Sat, 24 Jan 1970 00:00:00 UTC; path=/;";
							}
							break;	
						case "idMoreMenuItemGuide":
							window.open("https://help.sap.com/viewer/c4ebc2b5d928446180d9ad2667f11faa/1.0/en-US/a151c8571e0c46b0a4098eda8d34303a.html", "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");					
							break;	
						case "idMoreMenuItemNote":
							window.open("https://launchpad.support.sap.com/#/notes/3146834", "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");					
							break;						
						case "idMoreMenuItemSHP":
							window.open("https://help.sap.com", "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");					
							break;						
						case "idMoreMenuItemUtil":
							window.open(gSUMGlobals.pathLmslAbap + "/slui_ext/" + ((ind > 0) ? "?"+document.URL.slice(ind+1) : ""), "_blank", "noopener,noreferrer,resizable=yes,scrollbars=yes,location=yes,menubar=yes,status=yes,toolbar=yes");					
							break;	
						case "idMoreMenuItemLogTail":
							new LogTail();					
							break;						
						case "idMoreMenuItemAbout":
							createAboutDialog();					
							break;	
						case "idMoreMenuItemLogout":
							this.stopPolling();
							logout();					
							break;						
						case "idMoreMenuLegend":
							gLegendDialog.open();
							break;
		            	case "idMoreMenuItemReset":
							if (this.monSleep) {clearTimeout(this.monSleep); this.monSleep = 0;}
							this.semaDlg = false;		// release semaphore for refreshDialog()
							this.getView().setBusy(true);
		            		this.oSLPAPI.postAction("reset", $.proxy(this.pullMon, this), gSUMGlobals.genericError);
		            		break;
		            	case "idMoreMenuItemCleanup":
							this.stopPolling();
							this.semaDlg = false;		// release semaphore for refreshDialog()
							this.getView().setBusy(true);
		            		this.oSLPAPI.postAction("cleanup", $.proxy(function(){setTimeout($.proxy(this.afterCleanup, this), 1000);}, this), gSUMGlobals.genericError);
		            		break;
		            	case "idMoreMenuItemExit":
							this.stopPolling();
							this.semaDlg = false;		// release semaphore for refreshDialog()
							this.getView().setBusy(true);
		            		this.oSLPAPI.postAction("exit", $.proxy(function() {
		            			if (gSUMGlobals.httpServerExitTriggered) this.exitPage();
		            			else $.proxy(this.pullMon(), this);
		            		}, this), gSUMGlobals.genericError);
		            		if (document.getElementsByTagName('html')[0].innerHTML.search("Tool start required") > 0) gSUMGlobals.httpServerExitTriggered = true;
							var x = sap.ui.getCore().byId("feedbackDialog");
							if (x) x.close();
		            		break;
		            	case "idMoreMenuItemFeedback":
		            		launchFeedbackFormDialog();
		            		break;
		            	default: gSUMGlobals.popupError("D'Oh! You have found an unhandled menu item!");
		            }
					break;
			}
		},
		
		succFinCount: 0,
		succRunCount: 0,
		cleanupTriggered: false,
		afterCleanup: function() {
			function successReq(data) {
				// the unexpected case... at least for longer time
                var oMonitor = slpxml2json(data).json;                       
                var taskArray = arrayify(oMonitor.monitor.Task);                        
                if (taskArray.length == 0) gSUMGlobals.genericError();
//				console.log("Successfully got the monitor ressource. This is unexpected!\n");
                if (taskArray[0].status == "slp.task.state.FINISHED") {
//					console.log("status is still FINISHED, succFinCount="+this.succFinCount+"\n");
					if (++this.succFinCount <= 120) { // wait max. one minute for the SAPup process to terminate after a cleanup command. If time exceeds, reload page. 
//						console.log("waiting 0.5s for termination: status=FINISHED, succFinCount="+this.succFinCount+"\n"); 
						setTimeout($.proxy(this.afterCleanup, this), 500); // check every 0.5 seconds
						return;
					}
					else {
						location.reload();
/*						console.log("timeout while waiting for termination; continuing UI loop.\n"); 
						this.succFinCount = this.succRunCount = 0; 
						this.cleanupTriggered = true; 
						this.pullMon();
*/					}
				}
                else if (taskArray[0].status == "slp.task.state.RUNNING") {
//					console.log("status is still RUNNING, succRunCount="+this.succRunCount+"\n");
					if (++this.succRunCount <= 8) {
//						console.log("waiting 0.5s for termination.\n"); 
						setTimeout($.proxy(this.afterCleanup, this), 500); 
						return;
					}
					else {
//						console.log("apparently no termination triggered (waited too long); continuing UI loop.\n"); 
						this.succRunCount = 0; 
						this.cleanupTriggered = true; 
						this.pullMon();
					}
				}
                else {
//					console.log("status="+taskArray[0].status+", succFinCount="+this.succFinCount+", succRunCount="+this.succRunCount+": continuing UI loop.\n" ); 
					this.succFinCount = this.succRunCount = 0; 
					this.cleanupTriggered = true; 
					this.pullMon();				
				}
			}
			function failReq(xhr, status, error) {
				// the expected case
//				console.log("finally got the expected failure! --> exitPage()\n");
				this.exitPage();
			}
//			console.log("method afterCleanup() called --> fetching the monitor ressource...\n");
            this.oSLPAPI.getMonitor($.proxy(successReq, this), $.proxy(failReq, this));	
		},
		
		stopPolling: function() {
			if (this.monSleep) {clearTimeout(this.monSleep); this.monSleep = 0;}
			if (this.daemonsTimer) {clearTimeout(this.daemonsTimer); this.daemonsTimer = 0;}
			if (this.manactTimer) {clearTimeout(this.manactTimer); this.manactTimer = 0;}
		},
		
		exitPage: function() {
			this.stopPolling();
            var htmlClosingPage="<HEAD></HEAD><body bgcolor=\"#DDEDF1\"><hr>The SUM ABAP server process (&quot;SAPup&quot;) has been ended. You may close the browser page now. For an immediate restart of SUM <a href=\".\">click here</a> or refresh the browser page.<hr></body>";							
			document.getElementById('content').outerHTML = htmlClosingPage;
            if (isIE()) document.execCommand('Stop');
			else window.stop();		            				            				
		},
		
        actionPressed: function(oEvent) {
			function conflict(xhr, status, error) {
				switch(xhr.status) {
					case 409: 	sap.m.MessageBox.error("Conflict with another Client.\n\n Press F5 to update content.", {duration: 5000});
								gSUMGlobals.busy = false;
								break;
					default: 	if ((xhr.status === 0) && (xhr.state() === "rejected") && this.doOnce1) {
									this.doOnce1 = false;
									postToResource(stripId(oEvent.getSource().getId()), this, $.proxy(this.pullMon, this), $.proxy(conflict, this));
								} else {
									sap.m.MessageBox.error("Server responds error " + xhr.status + " (" + xhr.responseText + ")\n\n Press F5 to update content.", {duration: 5000});
									gSUMGlobals.busy = false;
								}
				}
			}
			if (gSUMGlobals.busy === true) {
				sap.m.MessageToast.show("Program is busy. Please wait.");
				return;
			}
			if (this.monSleep) {clearTimeout(this.monSleep); this.monSleep = 0;}
			gSUMGlobals.busy = true;	// will be reset in handleSpecialButtons() and in popupError()
			if (gSUMGlobals.nextButton) gSUMGlobals.handleNext();
			this.doOnce1 = true;
        	gSUMGlobals.httpServerExitTriggered = false;
        	this.oMessagePopover.close();
//    		*** Info-Icon for HTML-Content in <doc>-Tag ***
//			Note: also clean all notification in BaseController/cbChkMonitor!
//			delete this.popover;
//        	this.getView().byId("idInfoHTML").setVisible(false);
        	this.getView().byId("idErrorMsg").setVisible(false);
            postToResource(stripId(oEvent.getSource().getId()), this, $.proxy(this.cleanupTriggered ? this.afterCleanup : this.pullMon, this), $.proxy(conflict, this));
        },
        
        showLogWindow: function(oEvent, step, file, line, expr) {
            var cbLog = function(data) {
                var logModel = {logtext: data};
                this.getModel("currentLogFile").setData(logModel);
                if (this.oLogDialog === null)
                {
                    this.oLogDialog = sap.ui.xmlfragment("SoftwareUpdateManager.view.LogViewer", this);
                    this.getView().addDependent(this.oLogDialog);
					this.oLogDialog.getButtons().forEach(function(a){seleniumizeObj(a);});
                }
                this.oLogDialog.setTitle("Log File Viewer: " + this.logId + (this.stepId ? " (Step: "+this.stepId+")" : ""));
                this.oLogDialog.open();
				var txt = this.oLogDialog.getContent()[0].getItems()[0].getDomRefsForHyphenatedTexts().main;
				if (expr) hlight(expr, txt);
				if (line) {
					this.i = 1;
					txt.innerHTML = "<span data-line='"+this.i+"'></span>"+txt.innerHTML.replace(new RegExp(/\r*\n/, "g"), $.proxy(function(a){return a+"<span data-line='"+ ++this.i+ "'></span>";}, this));
					var occ = $("span[data-line='"+line+"']", this.oLogDialog.getDomRef("cont"));
					if (occ) occ.get(0).scrollIntoView();
				}
            };
			function openLog(that) {
				that.oSLPAPI.getLog($.proxy(cbLog, that), $.proxy(function(){sap.m.MessageBox.error("Log file "+that.logId+" does not exist.");}, that), that.logId);
			};
            if (oEvent) {
				var obj = oEvent.getSource().getBindingContext("logs");
				var size;
				this.logId = obj.getProperty("id"); this.stepId = "";
				if (this.logId.toUpperCase().endsWith(".SAR") && (gSUMGlobals.sid !== "SAR")) {
					sap.m.MessageBox.error("The file " + this.logId + " is a binary archive file.\nIt cannot be displayed in this tool.", {
						title: "Display binary file"
					});
				}
				else if ((size = obj.getProperty("size")) > 1000000) {
					sap.m.MessageBox.confirm("The file " + this.logId + " has a size of " + size + " Bytes.\n\nThis might result in a longer download time.\nDo you really want to display this file?", {
						title: "Display large log file",
						onClose: $.proxy(function(oAct){if (oAct === sap.m.MessageBox.Action.OK) openLog(this);}, this)
					});
				}
				else openLog(this);
			}
			else {this.logId = file; this.stepId = step; openLog(this);}
        },

        onLogSave: function(oEvent) {
            var idx = oEvent.getSource().getParent().getBindingContext("logs").sPath;
            if (idx) idx = parseInt(idx.replace("/logs/Log/", ""));
            var logObj = this.getModel("logs").getData().logs.Log[idx];
			var _a = logObj.content.split("/");
			if (_a && _a.length) saveFile(_a[_a.length-1]);
		},

		onLogSaveDia: function(oEvent) {
			if (this.logId) saveFile(this.logId);
		},

		onErrSaveDia: function(oEvent) {
			var data = oEvent.getSource().getModel("failedFragment").getData();
			var blob = new Blob([data.errorText, "|", data.errorDetails, "|", data.data], { type: 'text/plain' });
			if (window.navigator.msSaveOrOpenBlob) window.navigator.msSaveBlob(blob, "SUM_UI_Error.txt");
			else {
				var elem = window.document.createElement('a');
				elem.href = window.URL.createObjectURL(blob);
				elem.download = "SUM_UI_Error.txt";        
				document.body.appendChild(elem);
				elem.click();        
				document.body.removeChild(elem);
			}    		

		},

		closePopup: function() {
            this.oLogDialog.close();
        }, 
        
		closeError: function() {
            this.oErrDialog.close();
        }, 
        
        assignF1KeyForHelp: function() {
        	$(document).keydown(function(e){
        		if (e && (e.key === "F1")) {
        			window.onhelp = function() {return false;};
        			e.cancelable = true;
        			e.stopPropagation();
        			e.preventDefault();
        			e.returnValue = false;
        			openHelpWindow();
        		}
        	}); 
        },
        
        onAfterRendering: function() {
			var x = sap.ui.getCore().byId("__xmlview0--idMoreMenuItemCookies");
			if (($(location).attr('href').indexOf("allowcookies") > -1) || gSUMGlobals.cookies) x.setVisible(true);
			var y = sap.ui.getCore().byId("__xmlview0--idMoreMenuItemCookiesToggle");
			sap.ui.getCore().byId("idRst").setVisible(Boolean(gSUMGlobals.optOut.length));
			x.setIcon(gSUMGlobals.cookies ? "sap-icon://accept" : "");
			if (gSUMGlobals.cookies) y.setText("Decline"); 
			else y.setText("Allow"); 
        	this.getView().byId("idSumMainPage2").addStyleClass("pageFull");
			seleniumize("idCurrentPhase", this);
			seleniumize("idPhStarted", this);
			seleniumize("idProgressBar", this);
			seleniumize("idGrepBtn", this);
        }

    });

});