jQuery.sap.declare("interface.BaseModel");


function SLUIBaseModel(sFormat, mData) {
	this.sModelFormat = sFormat;
    if (this.sModelFormat === suiCnst.UI_DATA_FORMAT_JSON) {
    	this.oModel  = new sap.ui.model.json.JSONModel();
    } else if (this.sModelFormat === suiCnst.UI_DATA_FORMAT_XML) {
    	this.oModel  = new sap.ui.model.xml.XMLModel();
    } else {
        throw new Error("Unsupported Data format Model !");
    }
    this.oModel.setData(mData);
};

SLUIBaseModel.prototype.getData = function () {
    if (this.oModel) {
         return this.oModel.getData();
    }
};

SLUIBaseModel.prototype.getModel = function () {
    if (this.oModel) {
         return this.oModel;
    }
};

SLUIBaseModel.prototype.getDataFormat = function () {
    if (this.sModelFormat && this.oModel) {
         return this.sModelFormat;
    }
};

SLUIBaseModel.prototype.quickDataLookUp = function (dataKey,hasChildType) {
    if (dataKey) {
        var dataSegment = this.getData();
        if (this.sModelFormat === suiCnst.UI_DATA_FORMAT_JSON) {
            return ((dataSegment)[dataKey]);
        } else if (this.sModelFormat === suiCnst.UI_DATA_FORMAT_XML) {
            if (hasChildType && dataSegment.length > 0) {
                dataSegment = dataSegment[0];
            }
            if (dataSegment.localName === dataKey || dataSegment.nodeName === dataKey) {
                return dataSegment;
            } else {
                return $($(dataSegment).find(dataKey));
            }
        }
    }
};

SLUIBaseModel.prototype.dataLookUp = function (dataSegment, dataKey, hasChildType,restrictAsChild) {
    if (dataSegment != null && dataKey != null) {
        dataFormat = this.sModelFormat;
        if (dataFormat === suiCnst.UI_DATA_FORMAT_JSON) {
            return ((dataSegment)[dataKey]);
        } else if (dataFormat === suiCnst.UI_DATA_FORMAT_XML) {
            if (hasChildType && dataSegment.length > 0) {
                dataSegment = dataSegment[0];
            }
            if (dataSegment.localName === dataKey || dataSegment.nodeName === dataKey) {
                return dataSegment;
            } else {
            	if(restrictAsChild){
            		return $($(dataSegment).children(dataKey));
            	}else{
            		return $($(dataSegment).find(dataKey));
            	}
            }
        }
    }
};

SLUIBaseModel.prototype.getXMLTextContent = function (dataIndex, dataSegment) {
    if (dataIndex == -1) {
        return (dataSegment).textContent;
    } else {
        if (dataSegment.length > 0) {
            return (dataSegment)[dataIndex].textContent;
        } else {
            return null;
        }
    }
};

SLUIBaseModel.prototype._setXMLTextContent = function (dataIndex, dataSegment, dataValue) {
    if (dataIndex == -1) {
        (dataSegment).textContent = dataValue;
    } else {
        if (dataSegment.length > 0) {
            (dataSegment)[dataIndex].textContent = dataValue;
        }
    }

};