jQuery.sap.declare("interface.Error");
SLUIError = function(sFormat, dta) {
	 this.baseModel = new SLUIBaseModel(dataFormat, data);
	 if(this.baseModel){
	    this.objData =  this.baseModel.getData();
	    this.sDataFormat = this.baseModel.getDataFormat();
	    this.tData = this.baseModel.quickDataLookUp(suiCnst.SLP_ERROR_NAME);
	 }
};
SLUIError.prototype.getId = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_ID));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_COMMON_ID);
		}
	}else{
		return null;
	}
};
SLUIError.prototype.getCode = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_CODE));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_CODE);
		}
	}else{
		return null;
	}
};
SLUIError.prototype.getOccurredAt = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_OCCURRED_AT));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_OCCURRED_AT);
		}
	}else{
		return null;
	}
};
SLUIError.prototype.getUserMessage = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_USR_MSG));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_USR_MSG);
		}
	}else{
		return null;
	}
};
SLUIError.prototype.getDevMessage = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_DEV_MSG));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_DEV_MSG);
		}
	}else{
		return null;
	}
};
SLUIError.prototype.getHelp = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_HELP));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_HELP);
		}
	}else{
		return null;
	}
};
SLUIError.prototype.getLogs = function() {
	if(this.baseModel){
		if (this.sDataFormat === suiCnst.UI_DATA_FORMAT_XML) {
			return this.baseModel.getXMLTextContent(0, this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_LOGS));
		} else {
			return this.baseModel.dataLookUp(this.tData, suiCnst.SLP_ERROR_LOGS);
		}
	}else{
		return null;
	}
};
