var LMSLApi = function(baseurl) {
    
    this.baseUrl = baseurl;
            
    this.getManAct = function(successFunction, failFunction){
        var resourceUrl = this.baseUrl+"/manual_actions?xsl=0";
        gSUMGlobals.oSLPAPI.doGetText(successFunction, failFunction, resourceUrl);
    };
    this.getDaemons = function(successFunction, failFunction){
        var resourceUrl = this.baseUrl+"/daemons?details=0&xsl=0";
//        var resourceUrl = this.baseUrl+"/slui/daemons.xml?xsl=0";   // for debugging purpose
        gSUMGlobals.oSLPAPI.doGetText(successFunction, failFunction, resourceUrl);
    };
    this.getSAPupKeyValues = function(successFunction, failFunction){
        var resourceUrl = this.baseUrl+"/key_value?xsl=0";
        gSUMGlobals.oSLPAPI.doGetText(successFunction, failFunction, resourceUrl);
    };
    this.getMetaInfo = function(successFunction, failFunction){
        var resourceUrl = this.baseUrl+"/slui/slui.metainfo.xml?xsl=0";
        gSUMGlobals.oSLPAPI.doGetText(successFunction, failFunction, resourceUrl);
    };
    this.getPhMon = function(successFunction, failFunction){
        var resourceUrl = this.baseUrl+"/phasemonitor?xsl=0";
        gSUMGlobals.oSLPAPI.doGetText(successFunction, failFunction, resourceUrl);
    };
    this.postGrepPoll = function(successFunction, failFunction, logPtn, searchPtn, that){
//		for (var i = searchPtn.length-1; i >= 0; i--) if ((searchPtn[i]==='\\')||(searchPtn[i]==='[')||(searchPtn[i]===']')) searchPtn = searchPtn.slice(0, i) + '\\' + searchPtn.slice(i); 
		for (var i = searchPtn.length-1; i >= 0; i--) if (searchPtn[i]==='\\') searchPtn = searchPtn.slice(0, i) + '\\' + searchPtn.slice(i); 
        var resourceUrl = this.baseUrl+"/grep/poll?logPattern="+encodeURIComponent(logPtn)+"&grepPattern="+encodeURIComponent(searchPtn);
        return this.doPost(successFunction, failFunction, resourceUrl, that);
    };
    this.postGrepStop = function(successFunction, failFunction, logPtn, searchPtn, that){
		if (that.xhr) {that.xhr.abort();}
//		for (var i = searchPtn.length-1; i >= 0; i--) if ((searchPtn[i]==='\\')||(searchPtn[i]==='[')||(searchPtn[i]===']')) searchPtn = searchPtn.slice(0, i) + '\\' + searchPtn.slice(i); 
		for (var i = searchPtn.length-1; i >= 0; i--) if (searchPtn[i]==='\\') searchPtn = searchPtn.slice(0, i) + '\\' + searchPtn.slice(i); 
        var resourceUrl = this.baseUrl+"/grep/stop?logPattern="+encodeURIComponent(logPtn)+"&grepPattern="+encodeURIComponent(searchPtn);
        this.doPost(successFunction, failFunction, resourceUrl, that);
    };
    this.doPost = function(successFunction, failFunction, url, that) {
        return $.ajax({
            type: "post",
            url: url,
            accept: "application/xml",
            dataType: "text",
            cache: false,
//          data: payload,
            success: $.proxy(successFunction, that),
            error: $.proxy(function(xhr, status, error) {
				switch(xhr.status) {
					case 403:	this.xhr = $.ajax({
									type: "get",
									url: url,
									headers: {'X-CSRF-Token': 'Fetch'},
									cache: false,
									success: 	$.proxy(function(a,b,c){
													$.ajaxSetup({headers: {'X-CSRF-Token': c.getResponseHeader('X-CSRF-Token')}});
													this.xhr = gSUMGlobals.oLMSLAPI.doPost(successFunction, failFunction, url);
												}, this),
									error: 		gSUMGlobals.genericError
								});
								break;
					default: 	failFunction(xhr, status, error);
				}
			}, that)
        });
    };

};