var SLPApi = function(baseurl) {
    
    this.baseUrl = baseurl;
            
    this.getMonitor = function(successFunction, failFunction) {
        var resourceUrl = this.baseUrl+"/monitor";
        this.doGet(successFunction, failFunction, resourceUrl);
    };
    this.getDialogs = function(successFunction, failFunction) {
        var resourceUrl = this.baseUrl+"/dialogs";
        this.doGet(successFunction, failFunction, resourceUrl);
    };
    this.getFragment = function(successFunction, failFunction, fragmentName) {
        var resourceUrl = this.baseUrl+"/metadialogui5" + fragmentName;
        this.doGetText(successFunction, failFunction, resourceUrl);
    };
    this.getRoadmap = function(successFunction, failFunction) {
        var resourceUrl = this.baseUrl+"/roadmap";
        this.doGet(successFunction, failFunction, resourceUrl);
    };
    this.getConfig = function(successFunction, failFunction) {
        var resourceUrl = this.baseUrl+"/config";
        this.doGet(successFunction, failFunction, resourceUrl);        
    };
    this.getMetadata = function(successFunction, failFunction) {
        var resourceUrl = this.baseUrl+"/metadata";
        this.doGet(successFunction, failFunction, resourceUrl);
    };
    this.getActions = function(successFunction, failFunction) {
        var resourceUrl = this.baseUrl+"/actions";
        this.doGet(successFunction, failFunction, resourceUrl);      
    };
    this.getError = function(successFunction, failFunction) {
        var resourceUrl = this.baseUrl+"/error";
        this.doGet(successFunction, failFunction, resourceUrl);      
    };
    this.getBreakpoints = function(successFunction, failFunction, id) {
        var resourceUrl = this.baseUrl+"/breakpoints";
        if (id) resourceUrl += "/" + id;
        this.doGet(successFunction, failFunction, resourceUrl);       
    };
    this.getTasklist = function(successFunction, failFunction, rdmapStep) {
        var resourceUrl = this.baseUrl+"/tasklist";
        if (rdmapStep) resourceUrl += "/" + rdmapStep;
        this.doGet(successFunction, failFunction, resourceUrl);       
    };
    this.getCurrentBreakpoints = function(successFunction, failFunction) {
        var resourceUrl = this.baseUrl+"/currentBreakpoints";
        this.doGet(successFunction, failFunction, resourceUrl);
    };
    this.getVersions = function(successFunction, failFunction) {
        var resourceUrl = this.baseUrl+"/versions";
        this.doGet(successFunction, failFunction, resourceUrl);        
    };
    this.getProperties = function(successFunction, failFunction) {
        var resourceUrl = this.baseUrl+"/properties";
        this.doGet(successFunction, failFunction, resourceUrl);        
    };
    this.getLogs = function(successFunction, failFunction, qryOpt) {
        var resourceUrl = this.baseUrl+"/logs"+(qryOpt ? "?"+qryOpt : "");
        this.doGet(successFunction, failFunction, resourceUrl);        
    };
    this.getLog = function(successFunction, failFunction, filename) {
        var resourceUrl = this.baseUrl+"/logs/" + encodeURIComponent(filename);
        this.doGetText(successFunction, failFunction, resourceUrl);        
    };
    this.getFileSystemEntries = function(suffix, successFunction, failFunction) {
        var resourceUrl = this.baseUrl+"/fileSystemEntries"+suffix;
        this.doGet(successFunction, failFunction, resourceUrl);       
    };
    this.postConfig = function(successFunction, failFunction, payload) {
        var resourceUrl = this.baseUrl+"/config";
        this.doPost(successFunction, failFunction, resourceUrl, payload);        
    };
	this.postBreakpoint = function(successFunction, failFunction, payload) {
        var resourceUrl = this.baseUrl+"/breakpoints";
        this.doPost(successFunction, failFunction, resourceUrl, payload);        
    };
    this.postAction = function(action, successFunction, failFunction, payload) {
        var resourceUrl = this.baseUrl+"/actions/"+action;
        this.doPost((gSUMGlobals.nextButton && gSUMGlobals.handleNext(), successFunction), failFunction, resourceUrl, payload);
    };
    this.doGet = function(successFunction, failFunction, url) {
        $.ajax({
            type: "get",
            url: url,
            async: true,
            accept: "application/xml",
            dataType: "xml",
            cache: false,
            success: successFunction,
            error: failFunction
        });
    };
    this.doGetText = function(successFunction, failFunction, url) {
        $.ajax({
            type: "get",
            url: url,
            accept: "application/xml",
            dataType: "text",
            cache: false,
            success: successFunction,
            error: failFunction
        });
    };
    this.doPost = function(successFunction, failFunction, url, payload) {
        $.ajax({
            type: "post",
            url: url,
            accept: "application/xml",
            dataType: "xml",
            cache: false,
            data: payload,
            success: successFunction,
            error: $.proxy(function(xhr, status, error) {
				switch(xhr.status) {
					case 403:	$.ajax({
									type: "get",
									url: url,
									headers: {'X-CSRF-Token': 'Fetch'},
									cache: false,
									success: 	$.proxy(function(a,b,c){
													$.ajaxSetup({headers: {'X-CSRF-Token': c.getResponseHeader('X-CSRF-Token')}});
													this.doPost(successFunction, failFunction, url, payload);
												}, this),
									error: 		gSUMGlobals.genericError
								});
								break;
					default: 	failFunction(xhr, status, error);
				}
			}, this)
        });
    };
};