/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./InputBase','./ComboBoxTextField','./ComboBoxBase','./List','./library','sap/ui/Device','sap/ui/core/Item','./StandardListItem','./ComboBoxRenderer','sap/ui/base/ManagedObjectObserver',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","./Toolbar","sap/base/assert","sap/base/security/encodeXML","sap/ui/core/Core","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/dom/jquery/control"],function(I,C,a,L,l,D,b,S,c,M,d,K,T,f,g,h,j,k,q){"use strict";var m=l.ListType;var n=l.ListMode;var o=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ComboBox.designtime",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},filterSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{change:{parameters:{value:{type:"string"},itemPressed:{type:"boolean"}}},selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}},dnd:{draggable:false,droppable:true}}});function H(e,i){if(!i){return;}var r=e.getFocusDomRef(),t=e._getSelectionRange().start,u=r.value.substring(0,r.selectionStart),v=e._shouldResetSelectionStart(i),w=e.getSelectedItem(),G=i.isA("sap.ui.core.SeparatorItem"),x;e.setSelection(i);if(i!==w&&!G){e.updateDomValue(i.getText());e.fireSelectionChange({selectedItem:i});i=e.getSelectedItem();if(v){t=0;}e.selectText(t,r.value.length);e._bIsLastFocusedItemHeader=false;}if(G){e.setSelectedItem(null);e.fireSelectionChange({selectedItem:null});e.updateDomValue(u);e._bIsLastFocusedItemHeader=true;e._handleAriaActiveDescendant(i);e._getGroupHeaderInvisibleText().setText(e._oRb.getText("LIST_ITEM_GROUP_HEADER")+" "+i.getText());}x=this.getListItem(i);e.handleListItemsVisualFocus(x);if(e.isOpen()){e.removeStyleClass("sapMFocus");e._getList().addStyleClass("sapMListFocus");}else{e.addStyleClass("sapMFocus");}e.scrollToItem(i);}o.prototype.scrollToItem=function(i){var P=this.getPicker(),e=P.getDomRef("cont"),r=this.getListItem(i),t=i&&r&&r.getDomRef();if(!P||!e||!t){return;}var u=e.scrollTop,v=t.offsetTop,w=e.clientHeight,x=t.offsetHeight;if(u>v){e.scrollTop=v;}else if((v+x)>(u+w)){e.scrollTop=Math.ceil(v+x-w);}};function s(i,e){if(document.activeElement===this.getFocusDomRef()){this.selectText(i,e);}}function p(i){var e=this.getSelectedItem(),r=this.getListItem(e),t=e&&r&&r.getDomRef(),u=t&&t.offsetTop,v=t&&t.offsetHeight,P=this.getPicker(),w=P.getDomRef("cont"),x=w.clientHeight;if(e&&((u+v)>(x))){if(!i){this._getList().$().css("visibility","hidden");}else{w.scrollTop=u-v/2;this._getList().$().css("visibility","visible");}}}o.prototype._handleAriaActiveDescendant=function(i){var e=this.getFocusDomRef(),r=this.getListItem(i),A="aria-activedescendant";if(e){if(i&&r&&r.getDomRef()&&this.isOpen()){e.setAttribute(A,r.getId());}else{e.removeAttribute(A);}}};o.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};o.prototype._setItemVisibility=function(i,v){var O=i&&this.getListItem(i).$(),e="sapMSelectListItemBaseInvisible";if(v){i.bVisible=true;O.length&&O.removeClass(e);}else{i.bVisible=false;O.length&&O.addClass(e);}};o.prototype.setSelectedIndex=function(i,_){var e;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);e=_[i];if(e){this.setSelection(e);}};o.prototype.revertSelection=function(){var P,e=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){P=this._sValueBeforeOpen;}else{P=this._oSelectedItemBeforeOpen.getText();}e&&e.setValue(P);};o.prototype.filterItems=function(O){var i=this.getItems(),F=[],e=[],r=O.properties.indexOf("additionalText")>-1,t=this.fnFilter||a.DEFAULT_TEXT_FILTER,G=[],u=false;this._oFirstItemTextMatched=null;i.forEach(function(v){if(v.isA("sap.ui.core.SeparatorItem")){if(!v.getText()){this.getListItem(v).setVisible(false);return;}G.push({separator:v,show:false});u=true;this.getListItem(v).setVisible(false);return;}var w=t.call(this,O.value,v,"getText");var x=t.call(this,O.value,v,"getAdditionalText");if((w||x)&&u){G[G.length-1].show=true;u=false;}if(w){e.push(v);F.push(v);}else if(x&&r){F.push(v);}}.bind(this));i.forEach(function(v){if(v.isA("sap.ui.core.SeparatorItem")){return;}var w=F.indexOf(v)>-1;var x=e.indexOf(v)>-1;if(!this._oFirstItemTextMatched&&x){this._oFirstItemTextMatched=v;}this.getListItem(v).setVisible(w);if(!v.getEnabled()){this.getListItem(v).setVisible(false);}},this);G.forEach(function(v){if(v.show){this.getListItem(v.separator).setVisible(true);}}.bind(this));return F;};o.prototype._filterStartsWithItems=function(i,e){var r=i.toLowerCase();var t=this.getItems(),F=t.filter(function(u){return u[e]&&u[e]().toLowerCase().startsWith(r);});return F;};o.prototype._getFilters=function(){return this.getFilterSecondaryValues()?["text","additionalText"]:["text"];};o.prototype.getNextFocusableItem=function(e){var A=this.getSelectableItems(),i=this.getNonSeparatorSelectableItems(A),F=this.hasStyleClass("sapMFocus"),r=this.getSelectedItem()||this._getItemByListItem(this._oLastFocusedListItem),N;if(F&&this.isOpen()){N=A[0];}else if(F){N=i[i.indexOf(r)+(e?1:-1)];}else{N=A[A.indexOf(r)+(e?1:-1)];}return N;};o.prototype.getNonSeparatorSelectableItems=function(i){return i.filter(function(e){return!e.isA("sap.ui.core.SeparatorItem");});};o.prototype._itemsTextStartsWithTypedValue=function(i,t){if(!i||typeof t!="string"||t==""){return false;}return i.getText().toLowerCase().startsWith(t.toLowerCase());};o.prototype._shouldResetSelectionStart=function(i){var e=this.getFocusDomRef(),r=this._getSelectionRange(),t=r.start!==r.end,u=e.value.substring(0,r.start),v=this._itemsTextStartsWithTypedValue(i,u);return!(v&&(t||this._bIsLastFocusedItemHeader));};o.prototype._getSelectionRange=function(){var e=this.getFocusDomRef(),v=this.getValue(),i=e.selectionStart,r=e.selectionEnd,R={start:i,end:r};if(!(D.browser.msie||D.browser.edge)){return R;}if(this._bIsLastFocusedItemHeader){R.start=v.length;R.end=v.length;}return R;};o.prototype.handleListItemsVisualFocus=function(e){if(this._oLastFocusedListItem){this._oLastFocusedListItem.removeStyleClass("sapMLIBFocused");this._oLastFocusedListItem=null;}if(e){this._oLastFocusedListItem=e;e.addStyleClass("sapMLIBFocused");}};o.prototype.init=function(){this._oRb=h.getLibraryResourceBundle("sap.m");a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._sInputValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;this.bIsFocused=false;if(D.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this._oLastFocusedListItem=null;this._bIsLastFocusedItemHeader=null;this._oItemObserver=new M(this._forwardItemProperties.bind(this));};o.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this.synchronizeSelection();};o.prototype._fillList=function(){var e=this._getList(),r,t,u,i,v;if(!e){return;}if(this._oLastFocusedListItem){v=this._getItemByListItem(this._oLastFocusedListItem);}e.destroyItems();r=this.getItems();if(this._sInputValueBeforeOpen){r=this.filterItems({properties:this._getFilters(),value:this._sInputValueBeforeOpen});}for(i=0,u=r.length;i<u;i++){t=this._mapItemToListItem(r[i]);e.addAggregation("items",t,true);}if(v){this._oLastFocusedListItem=this.getListItem(v);}};o.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._oRb=null;this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;this._oLastFocusedListItem=null;if(this._oSuggestionPopover){if(this._oPickerCustomHeader){this._oPickerCustomHeader.destroy();this._oPickerCustomHeader=null;}this._oSuggestionPopover.destroy();this._oSuggestionPopover=null;}if(this._oItemObserver){this._oItemObserver.disconnect();this._oItemObserver=null;}};o.prototype.onBeforeRenderingPicker=function(){var O=this["onBeforeRendering"+this.getPickerType()];O&&O.call(this);};o.prototype.onBeforeRenderingDropdown=function(){var P=this.getPicker(),w=(this.$().outerWidth()/parseFloat(l.BaseFontSize))+"rem";if(P){P.setContentMinWidth(w);}};o.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var e=this._getList(),F=this.getFocusDomRef();if(e){e.setBusy(true);}if(F){F.setAttribute("aria-busy","true");}}};o.prototype.onAfterRenderingPicker=function(){var O=this["onAfterRendering"+this.getPickerType()];O&&O.call(this);p.call(this,false);};o.prototype.onAfterRenderingList=function(){var e=this.getSelectedItem(),i=this.getListItem(e);if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var r=this._getList(),F=this.getFocusDomRef();this._highlightList(this._sInputValueBeforeOpen);if(e){r.setSelectedItem(i);this.handleListItemsVisualFocus(i);}if(r){r.setBusy(false);}if(F){F.removeAttribute("aria-busy");}};o.prototype.oninput=function(e){a.prototype.oninput.apply(this,arguments);this.syncPickerContent();if(e.isMarked("invalid")){return;}this.loadItems(function(){this.handleInputValidation(e,this.isComposingCharacter());},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&(this.getPickerType()==="Dropdown")){this.open();}this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus");};o.prototype.handleInputValidation=function(e,i){var r=this.getSelectedItem(),v=e.target.value,E=v==="",t=e.srcControl,V,u=(this.getPickerType()==="Dropdown");if(E&&!this.bOpenedByKeyboardOrButton&&!this.isPickerDialog()){V=this.getItems();}else{V=this.filterItems({properties:this._getFilters(),value:v});}var w=!!V.length;var F=V[0];if(!E&&F&&F.getEnabled()){this.handleTypeAhead(t,V,v,i);}if(E||!w||(!t._bDoTypeAhead&&(this._getSelectedItemText()!==v))){this.setSelection(null);if(r!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}}this._sInputValueBeforeOpen=v;if(this.isOpen()){setTimeout(function(){this._highlightList(v);}.bind(this));}if(w){if(E&&!this.bOpenedByKeyboardOrButton){this.close();}else if(u){this.open();this.scrollToItem(this.getSelectedItem());}}else if(this.isOpen()){if(u&&!this.bOpenedByKeyboardOrButton){this.close();}}else{this.clearFilter();}};o.prototype.handleTypeAhead=function(i,e,v,r){var t=this.intersectItems(this._filterStartsWithItems(v,'getText'),e);var u=this.getFilterSecondaryValues();var w=D.system.desktop;var x=this.getSelectedItem();if(i._bDoTypeAhead){var y=this.intersectItems(this._filterStartsWithItems(v,'getAdditionalText'),e);if(u&&!t[0]&&y[0]){!r&&i.updateDomValue(y[0].getAdditionalText());this.setSelection(y[0]);}else if(t[0]){!r&&i.updateDomValue(t[0].getText());this.setSelection(t[0]);}}else{this.setSelection(t[0]);}if(x!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}if(i._bDoTypeAhead){if(w){s.call(i,v.length,i.getValue().length);}else{setTimeout(s.bind(i,v.length,i.getValue().length),0);}}this.addStyleClass("sapMFocus");this._getList().removeStyleClass("sapMListFocus");};o.prototype.onSelectionChange=function(e){var i=this._getItemByListItem(e.getParameter("listItem")),P=this.getChangeEventParams(),r=(i!==this.getSelectedItem());this.updateDomValue(i.getText());this.setSelection(i);this.fireSelectionChange({selectedItem:this.getSelectedItem()});if(r){P.itemPressed=true;this.onChange(null,P);}};o.prototype.onItemPress=function(e){var i=e.getParameter("listItem"),t=i.getTitle(),P=this.getChangeEventParams(),r=(i!==this.getListItem(this.getSelectedItem()));if(i.isA("sap.m.GroupHeaderListItem")){return;}this.handleListItemsVisualFocus(i);this.updateDomValue(t);if(!r){P.itemPressed=true;this.onChange(null,P);}this._setPropertyProtected("value",t,true);if(this.getPickerType()==="Dropdown"&&!this.isPlatformTablet()){this.selectText.bind(this,this.getValue().length,this.getValue().length);}this.close();};o.prototype.onBeforeOpen=function(){var P=this["onBeforeOpen"+this.getPickerType()],e=this.getFocusDomRef();if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);if(e){this.getRoleComboNodeDomRef().setAttribute("aria-owns",this._getList().getId());}this.addContent();P&&P.call(this);};o.prototype.onBeforeOpenDialog=function(){var P=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();if(this.getSelectedItem()){this.filterItems({properties:this._getFilters(),value:""});}P.setValue(this._sValueBeforeOpen);};o.prototype.onAfterOpen=function(){var e=this.getFocusDomRef(),i=this.getSelectedItem(),r=this.getListItem(i),t=this._getSelectionRange(),u=this.isPlatformTablet();if(e){this.getRoleComboNodeDomRef().setAttribute("aria-expanded","true");r&&e.setAttribute("aria-activedescendant",r.getId());}p.call(this,true);if(!u&&i&&t.start===t.end){setTimeout(function(){this.selectText(0,t.end);}.bind(this),0);}};o.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);var e=this.getFocusDomRef();if(e){this.getRoleComboNodeDomRef().removeAttribute("aria-owns");e.removeAttribute("aria-activedescendant");}this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);};o.prototype.onAfterClose=function(){var e=this.getFocusDomRef();if(e){this.getRoleComboNodeDomRef().setAttribute("aria-expanded","false");}this.clearFilter();this._sInputValueBeforeOpen="";if(this.shouldValueStateMessageBeOpened()&&(document.activeElement===e)){this.openValueStateMessage();}};o.prototype.onItemChange=function(e){var i=this.getAssociation("selectedItem"),N=e.getParameter("newValue"),P=e.getParameter("name");if(i===e.getParameter("id")){switch(P){case"text":if(!this.isBound("value")){this.setValue(N);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(N);}break;}}};o.prototype.onkeydown=function(e){var i=e.srcControl;a.prototype.onkeydown.apply(i,arguments);if(!i.getEnabled()||!i.getEditable()){return;}var r=K;i._bDoTypeAhead=!D.os.android&&(e.which!==r.BACKSPACE)&&(e.which!==r.DELETE);};o.prototype.oncut=function(e){var i=e.srcControl;a.prototype.oncut.apply(i,arguments);i._bDoTypeAhead=false;};o.prototype.onsapenter=function(e){var i=e.srcControl,r=i.getSelectedItem();if(r&&this.getFilterSecondaryValues()){i.updateDomValue(r.getText());}a.prototype.onsapenter.apply(i,arguments);if(!i.getEnabled()||!i.getEditable()){return;}if(i.isOpen()&&!this.isComposingCharacter()){i.close();}};o.prototype.onsapdown=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function navigateToNextSelectableItem(){H.call(this,i,this.getNextFocusableItem(true));});};o.prototype.onsapup=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function navigateToPrevSelectableItem(){H.call(this,i,this.getNextFocusableItem(false));});};o.prototype.onsaphome=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function navigateToFirstSelectableItem(){var F=this.getSelectableItems()[0];H.call(this,i,F);});};o.prototype.onsapend=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function navigateToLastSelectableItem(){var r=this.findLastEnabledItem(this.getSelectableItems());H.call(this,i,r);});};o.prototype.onsappagedown=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function(){var r=this.getNonSeparatorSelectableItems(this.getSelectableItems()),t=r.indexOf(this.getSelectedItem())+10,u;t=(t>r.length-1)?r.length-1:Math.max(0,t);u=r[t];H.call(this,i,u);});};o.prototype.onsappageup=function(e){var i=e.srcControl;if(!i.getEnabled()||!i.getEditable()){return;}this.syncPickerContent();e.setMarked();e.preventDefault();this.loadItems(function(){var r=this.getNonSeparatorSelectableItems(this.getSelectableItems()),t=r.indexOf(this.getSelectedItem())-10,u;t=(t>r.length-1)?r.length-1:Math.max(0,t);u=r[t];H.call(this,i,u);});};o.prototype.onsapshow=function(e){var i,r,E=this.getEditable();a.prototype.onsapshow.apply(this,arguments);this.syncPickerContent();if(!this.getValue()&&E){i=this.getSelectableItems();r=this.getNonSeparatorSelectableItems(i)[0];if(r){this.setSelection(r);this.updateDomValue(r.getText());this.fireSelectionChange({selectedItem:r});setTimeout(function(){this.selectText(0,r.getText().length);}.bind(this),0);}}};o.prototype.onsaphide=o.prototype.onsapshow;o.prototype.onfocusin=function(e){var i=this.getPickerType()==="Dropdown";if(this._bIsBeingDestroyed){return;}if(e.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(i&&!this.isPlatformTablet()){this.focus();}}else{if(i){setTimeout(function(){if(document.activeElement===this.getFocusDomRef()&&!this.bIsFocused&&!this.bFocusoutDueRendering&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}this.bIsFocused=true;}.bind(this),0);}if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}if(this.getEnabled()&&(!this.isOpen()||!this.getSelectedItem()||!this._getList().hasStyleClass("sapMListFocus"))){this.addStyleClass("sapMFocus");}};o.prototype.onsapfocusleave=function(e){this.bIsFocused=false;var t,P,r,F,i=this.getSelectedItem();if(i&&this.getFilterSecondaryValues()){this.updateDomValue(i.getText());}a.prototype.onsapfocusleave.apply(this,arguments);if(this.isPickerDialog()){return;}P=this.getPicker();if(!e.relatedControlId||!P){return;}t=this.isPlatformTablet();r=h.byId(e.relatedControlId);F=r&&r.getFocusDomRef();if(d(P.getFocusDomRef(),F)&&!t){this.focus();}};o.prototype.setSelection=function(i){var e=this._getList(),r,t;this.setAssociation("selectedItem",i,true);this._setPropertyProtected("selectedItemId",(i instanceof b)?i.getId():i,true);if(typeof i==="string"){i=h.byId(i);}if(e){r=this.getListItem(i);if(r){e.setSelectedItem(r,true);}else{e.removeSelections(true);}}t=i?i.getKey():"";this._setPropertyProtected("selectedKey",t,true);this._handleAriaActiveDescendant(i);if(this._oSuggestionPopover){this._oSuggestionPopover._iPopupListSelectedIndex=this.getItems().indexOf(i);}};o.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};o.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var e=this.getSelectedKey(),i=this.getItemByKey(""+e);if(i&&(e!=="")){this.setAssociation("selectedItem",i,true);this._setPropertyProtected("selectedItemId",i.getId(),true);if(this._sValue===this.getValue()){this.setValue(i.getText());this._sValue=this.getValue();}}};o.prototype.isFiltered=function(){var e=this._getList();return e&&(e.getVisibleItems().length!==this.getItems().length);};o.prototype.isItemVisible=function(i){return i&&(i.bVisible===undefined||i.bVisible);};o.prototype.configPicker=function(P){var r=this.getRenderer(),e=r.CSS_CLASS_COMBOBOXBASE;P.setHorizontalScrolling(false).addStyleClass(e+"Picker").addStyleClass(e+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this);};o.prototype._configureList=function(e){var r=this.getRenderer();if(!e){return;}e.setMode(n.SingleSelectMaster).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List");e.attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);e.addEventDelegate({onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this);};o.prototype.destroyItems=function(){this.destroyAggregation("items");if(this._getList()){this._getList().destroyItems();}return this;};o.prototype._mapItemToListItem=function(i){var e,r,t;var A="";var R=this.getRenderer();if(!i){return null;}if(i.getAdditionalText&&this.getShowSecondaryValues()){A=k.escapeSettingsValue(i.getAdditionalText());}r=R.CSS_CLASS_COMBOBOXBASE+"Item";t=(this.isItemSelected(i))?r+"Selected":"";if(i.isA("sap.ui.core.SeparatorItem")){e=this._mapSeparatorItemToGroupHeader(i,R);}else{e=new S({type:m.Active,info:A,visible:i.getEnabled()}).addStyleClass(r+" "+t);}e.setTitle(i.getText());this.setSelectable(i,i.getEnabled());e.setTooltip(i.getTooltip());i.data(R.CSS_CLASS_COMBOBOXBASE+"ListItem",e);i.getCustomData().forEach(function(u){e.addCustomData(u.clone(null,null,{cloneBindings:false}));});this._oItemObserver.observe(i,{properties:["text","additionalText","enabled","tooltip"]});return e;};o.prototype._forwardItemProperties=function(P){var i=P.object,e=i.data(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"ListItem"),r={text:"title",enabled:"visible",tooltip:"tooltip"},A,t,u;if(Object.keys(r).indexOf(P.name)>-1){t=r[P.name];u="set"+t.charAt(0).toUpperCase()+t.slice(1);e[u](P.current);}if(P.name==="additionalText"){A=this.getShowSecondaryValues()?P.current:"";e.setInfo(A);}};o.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};o.prototype.getDefaultSelectedItem=function(){return null;};o.prototype.getChangeEventParams=function(){return{itemPressed:false};};o.prototype.clearSelection=function(){this.setSelection(null);};o.prototype.selectText=function(i,e){a.prototype.selectText.apply(this,arguments);this.textSelectionStart=i;this.textSelectionEnd=e;return this;};o.prototype.setAssociation=function(A,i,e){var r=this._getList();if(r&&(A==="selectedItem")){if(!(i instanceof b)){i=this.findItem("id",i);}r.setSelectedItem(this.getListItem(i),true);}return a.prototype.setAssociation.apply(this,arguments);};o.prototype.removeAllAssociation=function(A,e){var i=this._getList();if(i&&(A==="selectedItem")){L.prototype.removeAllAssociation.apply(i,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};o.prototype.removeAllItems=function(){var i=a.prototype.removeAllItems.apply(this,arguments);this._fillList();return i;};o.prototype.clone=function(i){var e=a.prototype.clone.apply(this,arguments),r=this._getList();if(!this.isBound("items")&&r){e.syncPickerContent();e.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return e;};o.prototype.open=function(){this.syncPickerContent();var e=this._getList();a.prototype.open.call(this);if(this.getSelectedItem()){e.addStyleClass("sapMListFocus");this.removeStyleClass("sapMFocus");}return this;};o.prototype.syncPickerContent=function(){var P,e=this.getPicker(),i=this.getInputForwardableProperties();if(!e){var r,G;e=this.createPicker(this.getPickerType());P=this.getPickerTextField();this._updateSuggestionsPopoverValueState();this._fillList();if(P){i.forEach(function(t){t=t.charAt(0).toUpperCase()+t.slice(1);r="set"+t;G="get"+t;if(P[r]){P[r](this[G]());}},this);}}this.synchronizeSelection();return e;};o.prototype.close=function(){var e=this._getList();a.prototype.close.call(this);this.addStyleClass("sapMFocus");e&&e.removeStyleClass("sapMListFocus");return this;};o.prototype.findAggregatedObjects=function(){var e=this._getList();if(e){return L.prototype.findAggregatedObjects.apply(e,arguments);}return[];};o.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=h.byId(i);}if(!(i instanceof b)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};o.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);i=this.getSelectedItem();this.setValue(this._getSelectedItemText(i));return this;};o.prototype.setSelectedKey=function(e){e=this.validateProperty("selectedKey",e);var i=(e===""),r=this.isBound("selectedKey")&&this.isBound("value")&&this.getBindingInfo("selectedKey").skipModelUpdate;if(i){this.setSelection(null);if(!r){this.setValue("");}return this;}var t=this.getItemByKey(e);if(t){this.setSelection(t);if(!r){this.setValue(this._getSelectedItemText(t));}return this;}this._sValue=this.getValue();return this._setPropertyProtected("selectedKey",e);};o.prototype._setPropertyProtected=function(P,v,i){try{return this.setProperty(P,v,i);}catch(e){j.warning("setSelectedKey update failed due to exception. Loggable in support mode log",null,null,function(){return{exception:e};});}};o.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:h.byId(v)||null;};o.prototype.updateItems=function(){var r,e=this.getSelectedItem(),r=a.prototype.updateItems.apply(this,arguments);clearTimeout(this._debounceItemsUpdate);this._debounceItemsUpdate=setTimeout(this["_syncItemsSelection"].bind(this,e),0);return r;};o.prototype._syncItemsSelection=function(e){var i,N,r=this.getSelectedKey();if(!e||e===this.getSelectedItem()){return;}N=this.getItems();i=N.some(function(t){return r===t.getKey();});this.setSelectedItem(i&&r?this.getItemByKey(r):null);};o.prototype.removeItem=function(i){i=a.prototype.removeItem.apply(this,arguments);var e;if(this._getList()){this._getList().removeItem(i&&this.getListItem(i));}if(this.isBound("items")&&!this.bItemsUpdated){return i;}var v=this.getValue();if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){e=this.getDefaultSelectedItem();this.setSelection(e);this.setValue(v);}return i;};o.prototype._modifyPopupInput=function(i){a.prototype._modifyPopupInput.apply(this,arguments);i.addEventDelegate({onsapenter:function(){var t=i.getValue();this.updateDomValue(t);this.onChange();if(t){this.updateDomValue(t);this.onChange();this.close();}}},this);return i;};o.prototype.applyShowItemsFilters=function(){var P,e;this.syncPickerContent();P=this.getPicker();e=function(){P.detachBeforeOpen(e,this);P=null;this.filterItems({value:this.getValue()||"_",properties:this._getFilters()});};P.attachBeforeOpen(e,this);};return o;});
