/*!
* OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['./NavContainer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/core/IntervalTrigger','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/Icon','sap/ui/model/Filter','./FacetFilterRenderer',"sap/ui/events/KeyCodes","sap/base/assert","sap/base/Log","sap/ui/events/jquery/EventSimulation","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollRightRTL","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/Selectors"],function(N,l,C,I,a,b,c,D,M,d,F,e,K,f,L,E,q){"use strict";var T=l.ToolbarDesign;var g=l.ListType;var h=l.ListMode;var m=l.FacetFilterListDataType;var B=l.ButtonType;var P=l.PlacementType;var n=l.FacetFilterType;var o=C.extend("sap.m.FacetFilter",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{showPersonalization:{type:"boolean",group:"Appearance",defaultValue:false},type:{type:"sap.m.FacetFilterType",group:"Appearance",defaultValue:n.Simple},liveSearch:{type:"boolean",group:"Behavior",defaultValue:true},showSummaryBar:{type:"boolean",group:"Behavior",defaultValue:false},showReset:{type:"boolean",group:"Behavior",defaultValue:true},showPopoverOKButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lists",aggregations:{lists:{type:"sap.m.FacetFilterList",multiple:true,singularName:"list"},buttons:{type:"sap.m.Button",multiple:true,singularName:"button",visibility:"hidden"},removeFacetIcons:{type:"sap.ui.core.Icon",multiple:true,singularName:"removeFacetIcon",visibility:"hidden"},popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},addFacetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},summaryBar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},resetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},arrowLeft:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},arrowRight:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{reset:{},confirm:{}}}});o.SCROLL_STEP=264;o.prototype.setType=function(t){var s=this.getAggregation("summaryBar");if(D.system.phone){this.setProperty("type",n.Light);s.setActive(true);}else{this.setProperty("type",t);s.setActive(t===n.Light);}if(t===n.Light){if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}}return this;};o.prototype.setShowReset=function(v){this.setProperty("showReset",v);var s=this.getAggregation("summaryBar");if(v){if(this.getShowSummaryBar()||this.getType()===n.Light){this._addResetToSummary(s);}}else{if(this.getShowSummaryBar()||this.getType()===n.Light){this._removeResetFromSummary(s);}}return this;};o.prototype.setShowSummaryBar=function(v){this.setProperty("showSummaryBar",v);if(v){var s=this.getAggregation("summaryBar");if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}s.setActive(this.getType()===n.Light);}return this;};o.prototype.setLiveSearch=function(v){this.setProperty("liveSearch",v);if(this._displayedList){var i=this._displayedList;var s=sap.ui.getCore().byId(i.getAssociation("search"));s.detachLiveChange(i._handleSearchEvent,i);if(v){s.attachLiveChange(i._handleSearchEvent,i);}}return this;};o.prototype.getLists=function(){var i=this.getAggregation("lists");if(!i){i=[];}if(this._displayedList){i.splice(this._listAggrIndex,0,this._displayedList);}i.forEach(function(j){if(!j.hasListeners("listItemsChange")){j.attachEvent("listItemsChange",_.bind(this));}}.bind(this));return i;};function _(i){var j=i.getSource();if(this._oAllCheckBoxBar){this._oAllCheckBoxBar.setVisible(Boolean(j.getItems(true).length));}}o.prototype.removeList=function(O){var i=M.prototype.removeAggregation.call(this,"lists",O);this._removeList(i);return i;};o.prototype.removeAggregation=function(){var i=M.prototype.removeAggregation.apply(this,arguments);if(arguments[0]==="lists"){this._removeList(i);}return i;};o.prototype.openFilterDialog=function(){var i=this._getFacetDialog();var j=this._getFacetDialogNavContainer();i.addContent(j);this.getLists().forEach(function(k){if(k.getMode()===h.MultiSelect){k._preserveOriginalActiveState();}});i.setInitialFocus(j.getPages()[0].getContent()[0].getItems()[0]);i.open();return this;};o.prototype.init=function(){this._pageSize=5;this._addDelegateFlag=false;this._invalidateFlag=false;this._lastCategoryFocusIndex=0;this._aDomRefs=null;this._previousTarget=null;this._addTarget=null;this._aRows=null;this._bundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.data("sap-ui-fastnavgroup","true",true);this._buttons={};this._aOwnedLabels=[];this._removeFacetIcons={};this._listAggrIndex=-1;this._displayedList=null;this._lastScrolling=false;this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._getAddFacetButton();this._getSummaryBar();this.setAggregation("resetButton",this._createResetButton());if(E.touchEventMode==="ON"&&!D.system.phone){this._enableTouchSupport();}if(D.system.phone){this.setType(n.Light);}};o.prototype.exit=function(){var i;c.removeListener(this._checkOverflow,this);if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();}if(this._aOwnedLabels){this._aOwnedLabels.forEach(function(s){i=sap.ui.getCore().byId(s);if(i){i.destroy();}});this._aOwnedLabels=null;}if(this._oAllCheckBoxBar){this._oAllCheckBoxBar=undefined;}};o.prototype.onBeforeRendering=function(){if(this.getShowSummaryBar()||this.getType()===n.Light){var s=this.getAggregation("summaryBar");var t=s.getContent()[0];t.setText(this._getSummaryText());}c.removeListener(this._checkOverflow,this);};o.prototype.onAfterRendering=function(){if(this.getType()!==n.Light&&!D.system.phone){c.addListener(this._checkOverflow,this);}if(this.getType()!==n.Light){this._startItemNavigation();}};o.prototype._startItemNavigation=function(){var j=this.getDomRef(),r=j.getElementsByClassName("sapMFFHead"),k=[];if(r.length>0){for(var i=0;i<r[0].childNodes.length;i++){if(r[0].childNodes[i].id.indexOf("ff")<0&&r[0].childNodes[i].id.indexOf("icon")<0&&r[0].childNodes[i].id.indexOf("add")<0){k.push(r[0].childNodes[i]);}if(r[0].childNodes[i].id.indexOf("add")>=0){k.push(r[0].childNodes[i]);}}}if(k!=""){this._aDomRefs=k;}if((!this.oItemNavigation)||this._addDelegateFlag==true){this.oItemNavigation=new a();this.addDelegate(this.oItemNavigation);this._addDelegateFlag=false;}this._aRows=r;for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].id.indexOf("add")>=0){this._addTarget=this.$().find(":sapTabbable")[i];break;}}this.oItemNavigation.setRootDomRef(j);this.oItemNavigation.setItemDomRefs(k);this.oItemNavigation.setCycling(false);this.oItemNavigation.setPageSize(this._pageSize);};o.prototype.onsapdelete=function(i){var j,p;if(this.getType()===n.Light){return;}if(!this.getShowPersonalization()){return;}j=sap.ui.getCore().byId(i.target.id);if(!j){return;}p=sap.ui.getCore().byId(j.getAssociation("list"));if(!p){return;}if(!p.getShowRemoveFacetIcon()){return;}p.removeSelections(true);p.setSelectedKeys();p.setProperty("active",false,true);this.invalidate();var t=this.$().find(":sapTabbable");q(t[t.length-1]).focus();var r=this.oItemNavigation.getFocusedIndex();q(i.target).blur();this.oItemNavigation.setFocusedIndex(r+1);this.focus();if(this.oItemNavigation.getFocusedIndex()==0){for(var k=0;k<this.$().find(":sapTabbable").length-1;k++){if(t[k].id.indexOf("add")>=0){q(t[k]).focus();}}}};o.prototype.onsaptabnext=function(j){if(this.getType()===n.Light){return;}this._previousTarget=j.target;if(j.target.parentNode.className=="sapMFFHead"){for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].parentNode.className=="sapMFFResetDiv"){q(this.$().find(":sapTabbable")[i]).focus();this._invalidateFlag=false;j.preventDefault();j.setMarked();return;}}}this._lastCategoryFocusIndex=this.oItemNavigation.getFocusedIndex();if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false;}};o.prototype.onsaptabprevious=function(i){if(this.getType()===n.Light){return;}if(i.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget==null){q(this.$().find(":sapTabbable")[0]).focus();i.preventDefault();i.setMarked();return;}if(i.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget!=null&&this._previousTarget.id!=i.target.id){q(this._previousTarget).focus();i.preventDefault();i.setMarked();return;}if(i.target.id.indexOf("add")>=0||i.target.parentNode.className=="sapMFFHead"){this._previousTarget=i.target;q(this.$().find(":sapTabbable")[0]).focus();}};o.prototype.onsapend=function(i){if(this.getType()===n.Light){return;}if(this._addTarget!=null){q(this._addTarget).focus();i.preventDefault();i.setMarked();}else{q(this._aRows[this._aRows.length-1]).focus();i.preventDefault();i.setMarked();}this._previousTarget=i.target;};o.prototype.onsaphome=function(i){if(this.getType()===n.Light){return;}q(this._aRows[0]).focus();i.preventDefault();i.setMarked();this._previousTarget=i.target;};o.prototype.onsappageup=function(i){this._previousTarget=i.target;};o.prototype.onsappagedown=function(i){this._previousTarget=i.target;};o.prototype.onsapincreasemodifiers=function(i){if(this.getType()===n.Light){return;}if(i.which==K.ARROW_RIGHT){this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()-1;var k=j+this._pageSize;q(i.target).blur();this.oItemNavigation.setFocusedIndex(k);this.focus();}};o.prototype.onsapdecreasemodifiers=function(i){if(this.getType()===n.Light){return;}var j=0;if(i.which==K.ARROW_LEFT){this._previousTarget=i.target;j=this.oItemNavigation.getFocusedIndex()+1;var k=j-this._pageSize;q(i.target).blur();this.oItemNavigation.setFocusedIndex(k);this.focus();}};o.prototype.onsapdownmodifiers=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;var j=0;j=this.oItemNavigation.getFocusedIndex()-1;var k=j+this._pageSize;q(i.target).blur();this.oItemNavigation.setFocusedIndex(k);this.focus();};o.prototype.onsapupmodifiers=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;var j=0;j=this.oItemNavigation.getFocusedIndex();if(j!=0){j=j+1;}var k=j-this._pageSize;q(i.target).blur();this.oItemNavigation.setFocusedIndex(k);this.focus();};o.prototype.onsapexpand=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()+1;q(i.target).blur();this.oItemNavigation.setFocusedIndex(j);this.focus();};o.prototype.onsapcollapse=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;var j=this.oItemNavigation.getFocusedIndex()-1;q(i.target).blur();this.oItemNavigation.setFocusedIndex(j);this.focus();};o.prototype.onsapdown=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).focus();i.preventDefault();i.setMarked();return;}};o.prototype.onsapup=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).focus();i.preventDefault();i.setMarked();}};o.prototype.onsapleft=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).focus();i.preventDefault();i.setMarked();}};o.prototype.onsapright=function(i){if(this.getType()===n.Light){return;}this._previousTarget=i.target;if(i.target.parentNode.className=="sapMFFResetDiv"){q(i.target).focus();i.preventDefault();i.setMarked();}};o.prototype.onsapescape=function(i){if(this.getType()===n.Light){return;}if(i.target.parentNode.className=="sapMFFResetDiv"){return;}var j=this._lastCategoryFocusIndex;q(i.target).blur();this.oItemNavigation.setFocusedIndex(j);this.focus();};o.prototype._getPopover=function(){var p=this.getAggregation("popover");if(!p){var t=this;p=new sap.m.Popover({placement:P.Bottom,beforeOpen:function(j){if(t._displayedList){t._displayedList._bSearchEventDefaultBehavior&&t._displayedList._setSearchValue("");}this.setCustomHeader(t._createFilterItemsSearchFieldBar(t._displayedList));var s=this.getSubHeader();if(!s){this.setSubHeader(t._createSelectAllCheckboxBar(t._displayedList));}i(t._displayedList);},afterClose:function(j){t._addDelegateFlag=true;t._handlePopoverAfterClose();},horizontalScrolling:false});this.setAggregation("popover",p,true);p.setContentWidth("30%");p.addStyleClass("sapMFFPop");var i=function(j){if(!j){return;}var k=t._getFacetRemoveIcon(j);if(k){k._bTouchStarted=false;}};}if(this.getShowPopoverOKButton()){this._addOKButtonToPopover(p);}else{p.destroyAggregation("footer");}return p;};o.prototype._handlePopoverAfterClose=function(){var p=this.getAggregation("popover"),i=this._displayedList;if(!p){return;}var j=this._getFacetRemoveIcon(i);if(j&&j._bTouchStarted){return;}this._restoreListFromDisplayContainer(p);this._displayRemoveIcon(false,i);i._fireListCloseEvent();this._fireConfirmEvent();this.destroyAggregation("popover");if(this._oOpenPopoverDeferred){setTimeout(function(){this._oOpenPopoverDeferred.resolve();this._oOpenPopoverDeferred=undefined;}.bind(this),0);}};o.prototype._fireConfirmEvent=function(){this.fireEvent('confirm');};o.prototype._openPopover=function(p,i){var j;if(!p.isOpen()){var k=sap.ui.getCore().byId(i.getAssociation("list"));f(k,"The facet filter button should be associated with a list.");j=!k.fireListOpen({});this._moveListToDisplayContainer(k,p);p.openBy(i);if(k.getShowRemoveFacetIcon()){this._displayRemoveIcon(true,k);}if(k.getWordWrap()){p.setContentWidth("30%");}if(!j){k._applySearch();}}return this;};o.prototype._getAddFacetButton=function(){var i=this.getAggregation("addFacetButton");if(!i){var t=this;var i=new sap.m.Button(this.getId()+"-add",{icon:I.getIconURI("add-filter"),type:B.Transparent,tooltip:this._bundle.getText("FACETFILTER_ADDFACET"),press:function(j){t.openFilterDialog();}});this.setAggregation("addFacetButton",i,true);}return i;};o.prototype._getButtonForList=function(i){if(this._buttons[i.getId()]){this._setButtonText(i);return this._buttons[i.getId()];}var t=this;var j=new sap.m.Button({type:B.Transparent,press:function(k){var p=this;var O=function(){var r=t._getPopover();t._openPopover(r,p);};if(i.getMode()===h.MultiSelect){i._preserveOriginalActiveState();}var r=t._getPopover();if(r.isOpen()){setTimeout(function(){if(r.isOpen()){return;}t._oOpenPopoverDeferred=q.Deferred();t._oOpenPopoverDeferred.promise().done(O);},100);}else{setTimeout(O.bind(this),100);}}});this._buttons[i.getId()]=j;this.addAggregation("buttons",j);j.setAssociation("list",i.getId(),true);this._setButtonText(i);return j;};o.prototype._setButtonText=function(i){var j=this._buttons[i.getId()];if(i._iAllItemsCount===undefined&&i.getMaxItemsCount()||!i._bSearchEventDefaultBehavior){i._iAllItemsCount=i.getMaxItemsCount();}if(j){var t="";var s=Object.getOwnPropertyNames(i._oSelectedKeys);var k=s.length;if(k===1){var S=i._oSelectedKeys[s[0]];t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[i.getTitle(),S]);}else if(k>0&&k===(i._iAllItemsCount?i._iAllItemsCount:0)){t=this._bundle.getText("FACETFILTER_ALL_SELECTED",[i.getTitle()]);}else if(k>0){t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[i.getTitle(),k]);}else{t=i.getTitle();}j.setText(t);}};o.prototype._getFacetRemoveIcon=function(i){var t=this,j=this._removeFacetIcons[i.getId()];if(!j){j=new d({src:I.getIconURI("sys-cancel"),tooltip:this._bundle.getText("FACETFILTER_REMOVE"),press:function(){j._bPressed=true;}});j.addDelegate({ontouchstart:function(){j._bTouchStarted=true;j._bPressed=false;},ontouchend:function(){t._displayRemoveIcon(false,i);j._bTouchStarted=false;setTimeout(p.bind(this),100);}},true);var p=function(){if(j._bPressed){i.removeSelections(true);i.setSelectedKeys();i.setProperty("active",false,true);}t._handlePopoverAfterClose();};j.setAssociation("list",i.getId(),true);j.addStyleClass("sapMFFLRemoveIcon");this._removeFacetIcons[i.getId()]=j;this.addAggregation("removeFacetIcons",j);this._displayRemoveIcon(false,i);}return j;};o.prototype._displayRemoveIcon=function(i,j){if(this.getShowPersonalization()){var k=this._removeFacetIcons[j.getId()];if(i){k.removeStyleClass("sapMFFLHiddenRemoveIcon");k.addStyleClass("sapMFFLVisibleRemoveIcon");}else{k.removeStyleClass("sapMFFLVisibleRemoveIcon");k.addStyleClass("sapMFFLHiddenRemoveIcon");}}};o.prototype._getFacetDialogNavContainer=function(){var i=new N({autoFocus:false});var j=this._createFacetPage();i.addPage(j);i.setInitialPage(j);var t=this;i.attachAfterNavigate(function(k){var p=k.getParameters()["to"];var r=k.getParameters()['from'];if(r===j){var s=(t._displayedList.getMode()===h.MultiSelect)?p.getContent(0)[1].getItems()[0]:p.getContent(0)[0].getItems()[0];if(s){s.focus();}}if(p===j){r.destroySubHeader();f(t._displayedList===null,"Filter items list should have been placed back in the FacetFilter aggregation before page content is destroyed.");r.destroyContent();t._selectedFacetItem.invalidate();p.invalidate();t._selectedFacetItem.focus();t._selectedFacetItem=null;}});return i;};o.prototype._createFacetPage=function(){var i=this._createFacetList();var j=new sap.m.SearchField({width:"100%",tooltip:this._bundle.getText("FACETFILTER_SEARCH"),liveChange:function(k){var r=i.getBinding("items");if(r){var s=new F("text",sap.ui.model.FilterOperator.Contains,k.getParameters()["newValue"]);r.filter([s]);}}});var p=new sap.m.Page({enableScrolling:true,title:this._bundle.getText("FACETFILTER_TITLE"),subHeader:new sap.m.Bar({contentMiddle:j}),content:[i]});return p;};o.prototype._createFilterItemsPage=function(){var t=this;var p=new sap.m.Page({showNavButton:true,enableScrolling:true,navButtonPress:function(i){var j=i.getSource().getParent();t._navFromFilterItemsPage(j);}});return p;};o.prototype._getFilterItemsPage=function(i){var O=i.getPages()[1];if(O){i.removePage(O);O.destroy();}var p=this._createFilterItemsPage();i.addPage(p);return p;};o.prototype._createFilterItemsSearchFieldBar=function(i){var t=this;var s=true;if(i.getDataType()!=m.String){s=false;}var S=new sap.m.SearchField({value:i._getSearchValue(),width:"100%",enabled:s,tooltip:this._bundle.getText("FACETFILTER_SEARCH"),search:function(k){t._displayedList._handleSearchEvent(k);}});if(this.getLiveSearch()){S.attachLiveChange(i._handleSearchEvent,i);}var j=new sap.m.Bar({contentMiddle:S});i.setAssociation("search",S);return j;};o.prototype._getFacetDialog=function(){var i=this.getAggregation("dialog");if(!i){var t=this;i=new sap.m.Dialog({showHeader:false,stretch:D.system.phone?true:false,afterClose:function(){t._addDelegateFlag=true;t._invalidateFlag=true;var j=this.getContent()[0];var k=j.getPages()[1];if(j.getCurrentPage()===k){var p=t._restoreListFromDisplayContainer(k);if(p.getMode()===h.MultiSelect){p._updateActiveState();t._bCheckForAddListBtn=true;}p._fireListCloseEvent();p._bSearchEventDefaultBehavior&&p._search("");}this.destroyAggregation("content",true);t.invalidate();},beginButton:new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){t._closeDialog();}}),contentHeight:"500px",ariaLabelledBy:[b.getStaticId("sap.m","FACETFILTER_AVAILABLE_FILTER_NAMES")]});i.addStyleClass("sapMFFDialog");i.onsapentermodifiers=function(j){if(j.shiftKey&&!j.ctrlKey&&!j.altKey){var k=this.getContent()[0];t._navFromFilterItemsPage(k);}};this.setAggregation("dialog",i,true);}return i;};o.prototype._closeDialog=function(){var i=this.getAggregation("dialog");if(i&&i.isOpen()){i.close();this._fireConfirmEvent();}};o.prototype._closePopover=function(){var p=this.getAggregation("popover");if(p&&p.isOpen()){p.close();}};o.prototype._createFacetList=function(){var j=this._oFacetList=new sap.m.List({mode:h.None,items:{path:"/items",template:new sap.m.StandardListItem({title:"{text}",counter:"{count}",type:g.Navigation,customData:[new sap.ui.core.CustomData({key:"index",value:"{index}"})]})}});var k=this._getMapFacetLists();var p=new sap.ui.model.json.JSONModel({items:k});if(k.length>100){p.setSizeLimit(k.length);}var t=this;j.attachUpdateFinished(function(){for(var i=0;i<j.getItems().length;i++){var r=this.getItems()[i];r.detachPress(t._handleFacetListItemPress,t);r.attachPress(t._handleFacetListItemPress,t);}});j.setModel(p);return j;};o.prototype.refreshFacetList=function(){this._oFacetList.getModel().setData({items:this._getMapFacetLists()});return this;};o.prototype._getMapFacetLists=function(){return this.getLists().map(function(i,j){return{text:i.getTitle(),count:i.getAllCount(),index:j};});};o.prototype._createSelectAllCheckboxBar=function(i){if(!i.getMultiSelect()){return null;}var s=i.getActive()&&i.getItems().length>0&&Object.getOwnPropertyNames(i._oSelectedKeys).length===i.getItems().length;var j=new sap.m.CheckBox(i.getId()+"-selectAll",{text:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),tooltip:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),selected:s,select:function(p){j.setSelected(p.getParameter("selected"));i._handleSelectAllClick(p.getParameter("selected"));}});i.setAssociation("allcheckbox",j);var k=new sap.m.Bar({visible:Boolean(i.getItems(true).length)});k.addEventDelegate({ontap:function(p){if(p.srcControl===this){i._handleSelectAllClick(j.getSelected());}}},k);k.addContentLeft(j);k.addStyleClass("sapMFFCheckbar");this._oAllCheckBoxBar=k;return k;};o.prototype._handleFacetListItemPress=function(i){this._navToFilterItemsPage(i.getSource());};o.prototype._navToFilterItemsPage=function(i){this._selectedFacetItem=i;var j=this.getAggregation("dialog").getContent()[0];var k=i.getCustomData();f(k.length===1,"There should be exactly one custom data for the original facet list item index");var p=k[0].getValue();var r=this.getLists()[p];this._listIndexAgg=this.indexOfAggregation("lists",r);if(this._listIndexAgg==p){var s=this._getFilterItemsPage(j);r.fireListOpen({});this._moveListToDisplayContainer(r,s);s.setSubHeader(this._createFilterItemsSearchFieldBar(r));var t=this._createSelectAllCheckboxBar(r);if(t){s.insertContent(t,0);}s.setTitle(r.getTitle());j.to(s);}};o.prototype._navFromFilterItemsPage=function(i){var j=i.getPages()[1];var k=this._restoreListFromDisplayContainer(j);if(k.getMode()===h.MultiSelect){k._updateActiveState();}k._fireListCloseEvent();k._bSearchEventDefaultBehavior&&k._search("");this._selectedFacetItem.setCounter(k.getAllCount());i.backToTop();};o.prototype._moveListToDisplayContainer=function(i,j){this._listAggrIndex=this.indexOfAggregation("lists",i);f(this._listAggrIndex>-1,"The lists index should be valid.");M.prototype.removeAggregation.call(this,"lists",i,true);j.addAggregation("content",i,false);i.setAssociation("facetFilter",this,true);this._displayedList=i;};o.prototype._restoreListFromDisplayContainer=function(i){var j=i.removeAggregation("content",this._displayedList,true);this.insertAggregation("lists",j,this._listAggrIndex,j.getActive());this._listAggrIndex=-1;this._displayedList=null;return j;};o.prototype._getSequencedLists=function(){var k=-1;var s=[];var p=this.getLists();if(p.length>0){for(var i=0;i<p.length;i++){if(p[i].getActive()){if(p[i].getSequence()<-1){p[i].setSequence(-1);}else if(p[i].getSequence()>k){k=p[i].getSequence();}s.push(p[i]);}else if(!p[i].getRetainListSequence()){p[i].setSequence(-1);}}for(var j=0;j<s.length;j++){if(s[j].getSequence()<=-1){k+=1;s[j].setSequence(k);}}if(s.length>1){s.sort(function(r,t){return r.getSequence()-t.getSequence();});}}return s;};o.prototype._getSummaryBar=function(){var s=this.getAggregation("summaryBar");if(!s){var t=new sap.m.Text({maxLines:1});var i=this;s=new sap.m.Toolbar({content:[t],active:this.getType()===n.Light?true:false,design:T.Info,ariaLabelledBy:[b.getStaticId("sap.m","FACETFILTER_TITLE"),t],press:function(j){i.openFilterDialog();}});s._setRootAccessibilityRole("button");this.setAggregation("summaryBar",s);}return s;};o.prototype._createResetButton=function(){var t=this;var j=new sap.m.Button({type:B.Transparent,icon:I.getIconURI("undo"),tooltip:this._bundle.getText("FACETFILTER_RESET"),press:function(k){t._addDelegateFlag=true;t._invalidateFlag=true;t.fireReset();var p=t.getLists();for(var i=0;i<p.length;i++){p[i]._setSearchValue("");p[i]._applySearch();var r=p[i].getItems()[0];if(r){r.focus();}}t.invalidate();}});return j;};o.prototype._addOKButtonToPopover=function(p){var i=p.getFooter();if(!i){var t=this;var i=new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),width:"100%",press:function(){t._closePopover();}});p.setFooter(i);}return i;};o.prototype._getSummaryText=function(){var k=", ";var S=" ";var s="";var p=true;var r=this.getLists();if(r.length>0){for(var i=0;i<r.length;i++){var t=r[i];if(t.getActive()){var u=this._getSelectedItemsText(t);var v="";for(var j=0;j<u.length;j++){v=v+u[j]+k;}if(v){v=v.substring(0,v.lastIndexOf(k)).trim();if(p){s=this._bundle.getText("FACETFILTER_INFOBAR_FILTERED_BY",[t.getTitle(),v]);p=false;}else{s=s+S+this._bundle.getText("FACETFILTER_INFOBAR_AND")+S+this._bundle.getText("FACETFILTER_INFOBAR_AFTER_AND",[t.getTitle(),v]);}}}}}if(!s){s=this._bundle.getText("FACETFILTER_INFOBAR_NO_FILTERS");}return s;};o.prototype._getSelectedItemsText=function(i){var t=i.getSelectedItems().map(function(v){return v.getText();});i._oSelectedKeys&&Object.getOwnPropertyNames(i._oSelectedKeys).forEach(function(v){t.indexOf(i._oSelectedKeys[v])===-1&&t.push(i._oSelectedKeys[v]);});return t;};o.prototype._addResetToSummary=function(s){if(s.getContent().length===1){s.addContent(new sap.m.ToolbarSpacer({width:""}));var i=this._createResetButton();s.addContent(i);i.addStyleClass("sapUiSizeCompact");i.addStyleClass("sapMFFRefresh");i.addStyleClass("sapMFFBtnHoverable");}};o.prototype._removeResetFromSummary=function(s){if(s.getContent().length===3){var S=s.removeAggregation("content",1);S.destroy();var i=s.removeAggregation("content",1);i.destroy();}};o.prototype._removeList=function(i){if(i){var j=this._buttons[i.getId()];if(j){this.removeAggregation("buttons",j);j.destroy();}var r=this._removeFacetIcons[i.getId()];if(r){this.removeAggregation("removeIcons",r);r.destroy();}delete this._buttons[i.getId()];delete this._removeFacetIcons[i.getId()];}};o.prototype._getScrollingArrow=function(s){var A=null;var p={src:"sap-icon://navigation-"+s+"-arrow"};if(s==="left"){A=this.getAggregation("arrowLeft");if(!A){p.id=this.getId()+"-arrowScrollLeft";A=I.createControlByURI(p);var j=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollLeft"];for(var i=0;i<j.length;i++){A.addStyleClass(j[i]);A.setTooltip(this._bundle.getText("FACETFILTER_PREVIOUS"));}this.setAggregation("arrowLeft",A);}}else if(s==="right"){A=this.getAggregation("arrowRight");if(!A){p.id=this.getId()+"-arrowScrollRight";A=I.createControlByURI(p);var k=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollRight"];for(var i=0;i<k.length;i++){A.addStyleClass(k[i]);A.setTooltip(this._bundle.getText("FACETFILTER_NEXT"));}this.setAggregation("arrowRight",A);}}else{L.error("Scrolling arrow name "+s+" is not valid");}return A;};o.prototype._checkOverflow=function(){var i=this.getDomRef("head"),$=q(i),j=this.$(),s=false,S=false,k=false,p=null,r=null,t=null;if(i){p=i.scrollLeft;r=i.scrollWidth;t=i.clientWidth;if(r>t){if(r-t==1){r=t;}else{k=true;}}j.toggleClass("sapMFFScrolling",k);j.toggleClass("sapMFFNoScrolling",!k);this._lastScrolling=k;if(!this._bRtl){s=p>0;S=(r>t)&&(r>p+t);}else{S=$.scrollLeftRTL()>0;s=$.scrollRightRTL()>0;}if((S!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){j.toggleClass("sapMFFNoScrollBack",!s);j.toggleClass("sapMFFNoScrollForward",!S);}}};o.prototype.onclick=function(i){var t=i.target.id;if(t){var s=this.getId(),j=i.target;i.preventDefault();if(t==s+"-arrowScrollLeft"){j.tabIndex=-1;j.focus();this._scroll(-o.SCROLL_STEP,500);}else if(t==s+"-arrowScrollRight"){j.tabIndex=-1;j.focus();this._scroll(o.SCROLL_STEP,500);}}};o.prototype._scroll=function(i,j){var k=this.getDomRef("head");var s=k.scrollLeft;if(!D.browser.internet_explorer&&this._bRtl){i=-i;}var S=s+i;q(k).stop(true,true).animate({scrollLeft:S},j);};o.prototype._enableTouchSupport=function(){var t=this;var i=function(p){var s=t.getType();if(s===n.Light){return;}p.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId);}t.startScrollX=t.getDomRef("head").scrollLeft;t.startTouchX=p.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=new Date().getTime();};var j=function(p){var s=t.getType();if(s===n.Light){return;}var r=p.touches[0].pageX-t.startTouchX;var u=t.getDomRef("head");var v=u.scrollLeft;var w=t.startScrollX-r;u.scrollLeft=w;t._bTouchNotMoved=false;var x=new Date().getTime()-t._lastMoveTime;t._lastMoveTime=new Date().getTime();if(x>0){t._velocity=(w-v)/x;}p.preventDefault();};var k=function(p){var s=t.getType();if(s===n.Light){return;}if(t._bTouchNotMoved===false){p.preventDefault();var r=t.getDomRef("head");var u=50;var v=Math.abs(t._velocity/10);t._iInertiaIntervalId=window.setInterval(function(){t._velocity=t._velocity*0.80;var w=t._velocity*u;r.scrollLeft=r.scrollLeft+w;if(Math.abs(t._velocity)<v){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined;}},u);}else if(t._bTouchNotMoved===true){t.onclick(p);p.preventDefault();}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined;};this.addEventDelegate({ontouchstart:i},this);this.addEventDelegate({ontouchend:k},this);this.addEventDelegate({ontouchmove:j},this);};return o;});
