/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','./Link','./Text','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/Device','sap/ui/base/ManagedObject','./ObjectIdentifierRenderer'],function(l,L,T,C,I,a,c,D,M,O){"use strict";var b=c.TextDirection;var d=C.extend("sap.m.ObjectIdentifier",{metadata:{library:"sap.m",designtime:"sap/m/designtime/ObjectIdentifier.designtime",properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},badgeNotes:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgePeople:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgeAttachments:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},titleActive:{type:"boolean",group:"Misc",defaultValue:false},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:b.Inherit}},aggregations:{_titleControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_textControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{titlePress:{parameters:{domRef:{type:"object"}}}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},dnd:{draggable:true,droppable:false}}});d.prototype.init=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(sap.ui.getCore().getConfiguration().getAccessibility()){d.OI_ARIA_ROLE=o.getText("OI_ARIA_ROLE");this._createAriaInfoTextControl();}};d.prototype.exit=function(){if(this._attachmentsIcon){this._attachmentsIcon.destroy();this._attachmentsIcon=null;}if(this._peopleIcon){this._peopleIcon.destroy();this._peopleIcon=null;}if(this._notesIcon){this._notesIcon.destroy();this._notesIcon=null;}if(this._oAriaCustomRole){this._oAriaCustomRole.destroy();this._oAriaCustomRole=null;}};d.prototype._getAttachmentsIcon=function(){if(!this._attachmentsIcon){this._attachmentsIcon=this._getIcon(I.getIconURI("attachment"),this.getId()+"-attachments");}return this._attachmentsIcon;};d.prototype._getPeopleIcon=function(){if(!this._peopleIcon){this._peopleIcon=this._getIcon(I.getIconURI("group"),this.getId()+"-people");}return this._peopleIcon;};d.prototype._getNotesIcon=function(){if(!this._notesIcon){this._notesIcon=this._getIcon(I.getIconURI("notes"),this.getId()+"-notes");}return this._notesIcon;};d.prototype._getIcon=function(u,i){var s=D.system.phone?"1em":"1em";var o;o=this._icon||I.createControlByURI({src:u,id:i+"-icon",size:s,useIconTooltip:false},sap.m.Image);o.setSrc(u);return o;};d.prototype._getTitleControl=function(){var t=this.getAggregation("_titleControl"),i=this.getId();if(!t){if(this.getProperty("titleActive")){t=new L({id:i+"-link",text:M.escapeSettingsValue(this.getProperty("title")),ariaLabelledBy:this._oAriaCustomRole});t.addAssociation("ariaLabelledBy",i+"-text",true);}else{t=new T({id:i+"-txt",text:M.escapeSettingsValue(this.getProperty("title"))});}this.setAggregation("_titleControl",t,true);}t.setVisible(!!this.getTitle());return t;};d.prototype._getTextControl=function(){var t=this.getAggregation("_textControl");if(!t){t=new T({text:M.escapeSettingsValue(this.getProperty("text"))});this.setAggregation("_textControl",t,true);}t.setTextDirection(this.getTextDirection());t.setVisible(!!this.getText());return t;};d.prototype.setTitle=function(t){var o=this._getTitleControl();o.setProperty("text",t);o.setVisible(!!o.getText());return this.setProperty("title",t);};d.prototype.setText=function(t){this._getTextControl().setProperty("text",t);return this.setProperty("text",t);};d.prototype.setTitleActive=function(v){var p=this.getTitleActive();this.setProperty("titleActive",v);if(p!=v){this.destroyAggregation("_titleControl");this._getTitleControl();}return this;};d.prototype._handlePress=function(e){var o=e.target;if(this.getTitleActive()&&this.$("title")[0].firstChild==o){this.fireTitlePress({domRef:o});e.setMarked();}};d.prototype.onsapenter=function(e){d.prototype._handlePress.apply(this,arguments);};d.prototype.onsapspace=function(e){d.prototype._handlePress.apply(this,arguments);};d.prototype.ontap=function(e){d.prototype._handlePress.apply(this,arguments);};d.prototype.addAssociation=function(A,i,s){var t=this.getAggregation("_titleControl");if(A==="ariaLabelledBy"){if(this.getTitleActive()&&t instanceof sap.m.Link){t.addAssociation("ariaLabelledBy",i,true);}}return C.prototype.addAssociation.apply(this,arguments);};d.prototype.removeAssociation=function(A,o,s){var t=this.getAggregation("_titleControl");if(A==="ariaLabelledBy"){if(this.getTitleActive()&&t instanceof sap.m.Link){t.removeAssociation("ariaLabelledBy",o,true);}}return C.prototype.removeAssociation.apply(this,arguments);};d.prototype._createAriaInfoTextControl=function(){if(!this._oAriaCustomRole){this._oAriaCustomRole=new a(this.getId()+"-oIHiddenText",{text:d.OI_ARIA_ROLE});}return this._oAriaCustomRole;};d.prototype.getAccessibilityInfo=function(){var t=this.getAggregation("_titleControl").getAccessibilityInfo(),o=(d.OI_ARIA_ROLE+" "+(t.type||"")).trim();t.type=o;t.description=t.description+" "+this.getText();return t;};d.prototype._hasTopRow=function(){return this.getTitle()||this.getBadgeNotes()||this.getBadgePeople()||this.getBadgeAttachments();};return d;});
