/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./InputBase','./DateTimeField','./MaskInputRule','./ResponsivePopover','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','./TimePickerSliders','./MaskEnabler','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/Locale','sap/m/library','sap/ui/core/LocaleData','./TimePickerRenderer',"sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/InvisibleText",'./Button',"sap/ui/thirdparty/jquery"],function(I,D,M,R,E,a,T,b,c,d,L,l,e,f,K,g,h,B,q){"use strict";var P=l.PlacementType,j=l.TimePickerMaskMode,k=l.ButtonType,m=1;var n=D.extend("sap.m.TimePicker",{metadata:{library:"sap.m",designtime:"sap/m/designtime/TimePicker.designtime",properties:{localeId:{type:"string",group:"Data"},title:{type:"string",group:"Misc",defaultValue:null},minutesStep:{type:"int",group:"Misc",defaultValue:m},secondsStep:{type:"int",group:"Misc",defaultValue:m},placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null},maskMode:{type:"sap.m.TimePickerMaskMode",group:"Misc",defaultValue:j.On},support2400:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"},_picker:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},dnd:{draggable:false,droppable:true}}});a.insertFontFaceStyle();E.call(n.prototype,true);b.call(n.prototype);var o={Short:"short",Medium:"medium",Long:"long"},p={Hour:"hour",Minute:"minute",Second:"second"},r='-';n.prototype.init=function(){D.prototype.init.apply(this,arguments);b.init.apply(this,arguments);this.setDisplayFormat(t());this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._bValid=false;this._sUsedDisplayPattern=null;this._sUsedValuePattern=null;this._oDisplayFormat=null;this._sValueFormat=null;this._oPopoverKeydownEventDelegate=null;this._rPlaceholderRegEx=new RegExp(r,'g');this._sLastChangeValue=null;var i=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,title:""});this._bShouldClosePicker=false;i.addEventDelegate({onmousedown:function(u){this._bShouldClosePicker=this.isOpen();}},this);i.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);};n.prototype.onBeforeRendering=function(){D.prototype.onBeforeRendering.apply(this,arguments);var v=this._getValueHelpIcon();if(v){v.setProperty("visible",this.getEditable(),true);}};n.prototype.exit=function(){if(this._oTimeSemanticMaskHelper){this._oTimeSemanticMaskHelper.destroy();}b.exit.apply(this,arguments);this._removePickerEvents();this._oResourceBundle=null;this._bValid=false;this._sUsedDisplayPattern=null;this._oDisplayFormat=null;this._oPopoverKeydownEventDelegate=null;this._sUsedValuePattern=null;this._sValueFormat=null;this._sLastChangeValue=null;};n.prototype.getIconSrc=function(){return a.getIconURI("time-entry-request");};n.prototype.isOpen=function(){return this._getPicker()&&this._getPicker().isOpen();};n.prototype.toggleOpen=function(O){this[O?"_closePicker":"_openPicker"]();};n.prototype.onfocusin=function(i){var u=this._getPicker();var v=this._isIconClicked(i);b.onfocusin.apply(this,arguments);if(u&&u.isOpen()&&!v){this._closePicker();}};n.prototype._isIconClicked=function(i){return q(i.target).hasClass("sapUiIcon")||q(i.target).hasClass("sapMInputBaseIconContainer");};n.prototype.onBeforeOpen=function(){var S=this._getSliders(),i=this.getDateValue(),u=this._$input.val(),F=this.getValueFormat(),v=F.indexOf("HH"),w=F.indexOf("H");S.setValue(u);if(this._shouldSetInitialFocusedDateValue()){i=this.getInitialFocusedDateValue();}S._setTimeValues(i,T._isHoursValue24(u,v,w));S.collapseAll();this.$().addClass(I.ICON_PRESSED_CSS_CLASS);};n.prototype.onAfterOpen=function(){var S=this._getSliders();if(S){S.openFirstSlider();this._handleAriaOnExpandCollapse();}};n.prototype.onAfterClose=function(){this.$().removeClass(I.ICON_PRESSED_CSS_CLASS);this._handleAriaOnExpandCollapse();};n.prototype._getValueHelpIcon=function(){var v=this.getAggregation("_endIcon");return v&&v[0];};n.prototype._handleInputChange=function(v){var i,u,w,F=this.getValueFormat(),x=F.indexOf("HH"),y=F.indexOf("H");v=v||this._$input.val();u=v;w=T._isHoursValue24(u,x,y);this._bValid=true;if(v!==""){i=this._parseValue(w?T._replace24HoursWithZero(v,x,y):v,true);if(!i){this._bValid=false;}else{v=this._formatValue(i);if(this.getMask()){this._setupMaskVariables();}}}u=this.getSupport2400()&&w?"24:"+v.replace(/[0-9]/g,"0").slice(0,-3):v;this.updateDomValue(u);if(i){u=v=this._formatValue(i,true);}this.setProperty("value",u,true);this._lastValue=v;if(this._bValid){this.setProperty("dateValue",i,true);}this.fireChangeEvent(u,{valid:this._bValid});return true;};n.prototype.onChange=function(i){var v=i?i.value:null;if(this.getEditable()&&this.getEnabled()){return this._handleInputChange(v);}return false;};n.prototype.setMinutesStep=function(i){var S=this._getSliders();i=Math.max(m,i||m);if(S){S.setMinutesStep(i);}return this.setProperty("minutesStep",i,true);};n.prototype.setSecondsStep=function(i){var S=this._getSliders();i=Math.max(m,i||m);if(S){S.setSecondsStep(i);}return this.setProperty("secondsStep",i,true);};n.prototype.setTitle=function(i){var S=this._getSliders();if(S){S.setLabelText(i);}this.setProperty("title",i,true);return this;};n.prototype._handleDateValidation=function(i){if(!i){this._bValid=false;g.warning("Value can not be converted to a valid date",this);}else{this._bValid=true;this.setProperty("dateValue",i,true);var v=this._formatValue(i);if(this.isActive()){this.updateDomValue(v);}else{this.setProperty("value",v,true);this._lastValue=v;this._sLastChangeValue=v;}}};n.prototype.setSupport2400=function(S){var i=this._getSliders();this.setProperty("support2400",S,true);if(i){i.setSupport2400(S);}this._initMask();return this;};n.prototype.setDisplayFormat=function(i){var S=this._getSliders();this.setProperty("displayFormat",i,true);this._initMask();if(S){S.setDisplayFormat(i);}var u=this.getDateValue();if(!u){return this;}var O=this._formatValue(u);this.updateDomValue(O);this._lastValue=O;return this;};n.prototype.setValue=function(v){var i,O,F=this.getValueFormat(),u=F.indexOf("HH"),w=F.indexOf("H"),S=this._getSliders();v=this.validateProperty("value",v);this._initMask();b.setValue.call(this,v);if(this.getMask()){this._setupMaskVariables();}this._sLastChangeValue=v;this._bValid=true;if(v){i=this._parseValue(T._isHoursValue24(v,u,w)?T._replace24HoursWithZero(v,u,w):v);if(!i){this._bValid=false;g.warning("Value can not be converted to a valid date",this);}}if(this._bValid){this.setProperty("dateValue",i,true);}if(i&&!this.getSupport2400()){O=this._formatValue(i);}else{O=v;}if(S){S.setValue(v);}this.updateDomValue(O);this._lastValue=O;return this;};n.prototype.setDateValue=function(v){this._initMask();return D.prototype.setDateValue.apply(this,arguments);};n.prototype.setTooltip=function(v){var i=this.getDomRef(),u;this._refreshTooltipBaseDelegate(v);this.setAggregation("tooltip",v,true);if(!i){return this;}u=this.getTooltip_AsString();if(u){i.setAttribute("title",u);}else{i.removeAttribute("title");}return this;};n.prototype.setLocaleId=function(i){var C=this.getValue(),S=this._getSliders();this.setProperty("localeId",i,true);this._initMask();this._oDisplayFormat=null;this._sValueFormat=null;if(C){this.setValue(C);}if(S){S.setLocaleId(i);}return this;};n.prototype._getDefaultDisplayStyle=function(){return o.Medium;};n.prototype._getDefaultValueStyle=function(){return o.Medium;};n.prototype._getLocale=function(){var i=this.getLocaleId();return i?new L(i):sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();};n.prototype._getFormatterInstance=function(F,i,u,C,v){var w=this._getLocale();if(i===o.Short||i===o.Medium||i===o.Long){F=d.getTimeInstance({style:i,strictParsing:true,relative:u},w);}else{F=d.getTimeInstance({pattern:i,strictParsing:true,relative:u},w);}if(v){this._sUsedDisplayPattern=i;this._oDisplayFormat=F;}else{this._sUsedValuePattern=i;this._sValueFormat=F;}return F;};n.prototype._getFormat=function(){var F=this._getDisplayFormatPattern();if(!F){F=o.Medium;}if(Object.keys(o).indexOf(F)!==-1){F=t();}return F;};n.prototype.onsappageup=function(i){this._increaseTime(1,p.Hour);i.preventDefault();};n.prototype.onsappageupmodifiers=function(i){if(!(i.ctrlKey||i.metaKey||i.altKey)&&i.shiftKey){this._increaseTime(1,p.Minute);}if(!i.altKey&&i.shiftKey&&(i.ctrlKey||i.metaKey)){this._increaseTime(1,p.Second);}i.preventDefault();};n.prototype.onsappagedown=function(i){this._increaseTime(-1,p.Hour);i.preventDefault();};n.prototype.onsappagedownmodifiers=function(i){if(!(i.ctrlKey||i.metaKey||i.altKey)&&i.shiftKey){this._increaseTime(-1,p.Minute);}if(!i.altKey&&i.shiftKey&&(i.ctrlKey||i.metaKey)){this._increaseTime(-1,p.Second);}i.preventDefault();};n.prototype.onkeydown=function(i){var u=K,v=i.which||i.keyCode,A=i.altKey,w;if(v===u.F4||(A&&(v===u.ARROW_UP||v===u.ARROW_DOWN))){w=this._getPicker()&&this._getPicker().isOpen();if(!w){this._openPicker();}else{this._closePicker();}i.preventDefault();}else{b.onkeydown.call(this,i);}};n.prototype._getPicker=function(){return this.getAggregation("_picker");};n.prototype._removePickerEvents=function(){var i,u=this._getPicker();if(u){i=u.getAggregation("_popup");if(typeof this._oPopoverKeydownEventDelegate==='function'){i.removeEventDelegate(this._oPopoverKeydownEventDelegate);}}};n.prototype._openPicker=function(){var i=this._getPicker(),S;if(!i){i=this._createPicker(this._getDisplayFormatPattern());}i.open();S=this._getSliders();setTimeout(S._updateSlidersValues.bind(S),0);return i;};n.prototype._closePicker=function(){var i=this._getPicker();if(i){i.close();}else{g.warning("There is no picker to close.");}return i;};n.prototype._createPicker=function(F){var i=this,u,v,w,O,C,x,y=this.getAggregation("_endIcon")[0],z=this._getLocale().getLanguage();w=sap.ui.getCore().getLibraryResourceBundle("sap.m");O=w.getText("TIMEPICKER_SET");C=w.getText("TIMEPICKER_CANCEL");x=this.getTitle();v=new R(i.getId()+"-RP",{showCloseButton:false,showHeader:false,horizontalScrolling:false,verticalScrolling:false,placement:P.VerticalPreferedBottom,beginButton:new B({text:O,type:k.Emphasized,press:q.proxy(this._handleOkPress,this)}),endButton:new B({text:C,press:q.proxy(this._handleCancelPress,this)}),content:[new T(this.getId()+"-sliders",{support2400:this.getSupport2400(),displayFormat:F,valueFormat:this.getValueFormat(),labelText:x?x:"",localeId:z,minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep()})._setShouldOpenSliderAfterRendering(true)],contentHeight:n._PICKER_CONTENT_HEIGHT,ariaLabelledBy:h.getStaticId("sap.m","TIMEPICKER_SET_TIME")});u=v.getAggregation("_popup");if(u.setShowArrow){u.setShowArrow(false);}u.oPopup.setAutoCloseAreas([y]);v.addStyleClass(this.getRenderer().CSS_CLASS+"DropDown").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachAfterClose(this.onAfterClose,this);v.open=function(){return this.openBy(i);};if(c.system.desktop){this._oPopoverKeydownEventDelegate={onkeydown:function(A){var G=K,H=A.which||A.keyCode,J=A.altKey;if((J&&(H===G.ARROW_UP||H===G.ARROW_DOWN))||H===G.F4){this._handleOkPress(A);this.focus();A.preventDefault();}}};u.addEventDelegate(this._oPopoverKeydownEventDelegate,this);u._afterAdjustPositionAndArrowHook=function(){i._getSliders()._onOrientationChanged();};}this.setAggregation("_picker",v,true);return v;};n.prototype._getSliders=function(){var i=this._getPicker();if(!i){return null;}return i.getContent()[0];};n.prototype._handleOkPress=function(i){var u=this._getSliders().getTimeValues(),v=this._formatValue(u);this.updateDomValue(v);this._handleInputChange();this._closePicker();};n.prototype._handleCancelPress=function(i){this._closePicker();};n.prototype._getLocaleBasedPattern=function(i){return e.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getTimePattern(i);};n.prototype._parseValue=function(v,i){if(i){v=this._oTimeSemanticMaskHelper.stripValueOfLeadingSpaces(v);v=v.replace(this._rPlaceholderRegEx,'');}return D.prototype._parseValue.call(this,v,i);};n.prototype._formatValue=function(i,v){var V=D.prototype._formatValue.apply(this,arguments),F=this.getValueFormat(),u=F.indexOf("HH"),w=F.indexOf("H");if(i){if(!v&&this._oTimeSemanticMaskHelper){V=this._oTimeSemanticMaskHelper.formatValueWithLeadingTrailingSpaces(V);}}if(this.getSupport2400()&&this._getSliders()&&this._getSliders()._getHoursSlider().getSelectedValue()==="24"){V=T._replaceZeroHoursWith24(V,u,w);}return V;};n.prototype._handleAriaOnExpandCollapse=function(){this.getFocusDomRef().setAttribute("aria-expanded",this._getPicker().isOpen());};n.prototype._increaseTime=function(N,u){var O=this.getDateValue(),i,v;if(O&&this.getEditable()&&this.getEnabled()){i=new Date(O.getTime());switch(u){case p.Hour:i.setHours(i.getHours()+N);v=60*60*1000;break;case p.Minute:i.setMinutes(i.getMinutes()+N);v=60*1000;break;case p.Second:v=1000;i.setSeconds(i.getSeconds()+N);}if(N<0&&i.getTime()-O.getTime()!==N*v){i=new Date(O.getTime()+N*v);}this.setDateValue(i);this.fireChangeEvent(this.getValue(),{valid:true});}};n.prototype._initMask=function(){if(this._oTimeSemanticMaskHelper){this._oTimeSemanticMaskHelper.destroy();}this._oTimeSemanticMaskHelper=new s(this);};n.prototype._isMaskEnabled=function(){return this.getMaskMode()===j.On;};n.prototype._shouldSetInitialFocusedDateValue=function(){if(!this._isValidValue()){return true;}return!this.getValue()&&!!this.getInitialFocusedDateValue();};n.prototype._isValidValue=function(){return this._bValid;};n.prototype.fireChangeEvent=function(v,i){if(v){v=v.trim();}if(v!==this._sLastChangeValue){this._sLastChangeValue=v;I.prototype.fireChangeEvent.call(this,v,i);}};var s=function(u){var v=u._getDisplayFormatPattern(),w,A,x=u._getLocale(),i;if(u._checkStyle(v)){w=e.getInstance(x).getTimePattern(v);}else{v=v.replace(/'/g,"");w=v;}this._oTimePicker=u;this.aOriginalAmPmValues=e.getInstance(x).getDayPeriods("abbreviated");this.aAmPmValues=this.aOriginalAmPmValues.slice(0);this.iAmPmValueMaxLength=Math.max(this.aAmPmValues[0].length,this.aAmPmValues[1].length);for(i=0;i<this.aAmPmValues.length;i++){while(this.aAmPmValues[i].length<this.iAmPmValueMaxLength){this.aAmPmValues[i]+=" ";}}this.b24H=v.indexOf("H")!==-1;this.bLeadingZero=v.indexOf("HH")!==-1||v.indexOf("hh")!==-1;this.sLeadingChar=this.bLeadingZero?"0":" ";this.sAlternativeLeadingChar=this.bLeadingZero?" ":"0";this.sLeadingRegexChar=this.bLeadingZero?"0":"\\s";u.setPlaceholderSymbol(r);w=w.replace(/hh/ig,"h").replace(/h/ig,"h9");if(this.b24H){A="["+this.sLeadingRegexChar+"012]";}else{A="["+this.sLeadingRegexChar+"1]";}this._maskRuleHours=new M({maskFormatSymbol:"h",regex:A});u.addRule(this._maskRuleHours);this.iHourNumber1Index=w.indexOf("h9");this.iHourNumber2Index=this.iHourNumber1Index!==-1?this.iHourNumber1Index+1:-1;this.iMinuteNumber1Index=w.indexOf("mm");w=w.replace(/mm/g,"59");this.iSecondNumber1Index=w.indexOf("ss");w=w.replace(/ss/g,"59");this._maskRuleMinSec=new M({maskFormatSymbol:"5",regex:"[0-5]"});u.addRule(this._maskRuleMinSec);this.aAllowedHours=J.call(this,this.b24H,this.sLeadingChar);this.aAllowedMinutesAndSeconds=N.call(this);this.iAmPmChar1Index=w.indexOf("a");this.iAfterAmPmValueIndex=-1;if(this.iAmPmChar1Index!==-1){this.iAfterAmPmValueIndex=this.iAmPmChar1Index+this.iAmPmValueMaxLength;var C=this.iAmPmValueMaxLength-"a".length;this.shiftIndexes(C);var y=65;var z="";var F="";var G="";for(i=0;i<this.iAmPmValueMaxLength;i++){F="[";if(this.aAmPmValues[0][i]){F+=this.aAmPmValues[0][i];}else{F+="\\s";}if(this.aAmPmValues[1][i]!==this.aAmPmValues[0][i]){if(this.aAmPmValues[1][i]){F+=this.aAmPmValues[1][i];}else{F+="\\s";}}F+="]";G=String.fromCharCode(y++);z+=G;this._maskRuleChars=new M({maskFormatSymbol:G,regex:F});u.addRule(this._maskRuleChars);}w=w.replace(/a/g,z);}u.setMask(w);function H(S,O,Q){var U=[],V,i;for(i=S;i<=O;i++){V=i.toString();if(i<10){V=Q+V;}U.push(V);}return U;}function J(O,Q){var S=O?0:1,U=this._oTimePicker.getSupport2400()?24:23,V=O?U:12;return H(S,V,Q);}function N(){return H(0,59,"0");}};s.prototype.replaceChar=function(C,u,v){var A=u-this.iAmPmChar1Index,w,x,y,S,z,F,i;if(u===this.iHourNumber1Index&&this.sAlternativeLeadingChar===C){if(this.aAllowedHours.indexOf(this.sLeadingChar+C)!==-1){return this.sLeadingChar+C;}else{return this.sLeadingChar;}}else if(u===this.iHourNumber1Index&&!this._oTimePicker._isCharAllowed(C,u)&&this.aAllowedHours.indexOf(this.sLeadingChar+C)!==-1){return this.sLeadingChar+C;}else if(u===this.iHourNumber2Index&&v[this.iHourNumber1Index]===r){this._oTimePicker._oTempValue.setCharAt(this.sLeadingChar,this.iHourNumber1Index);return C;}else if(u===this.iHourNumber2Index&&this.aAllowedHours.indexOf(v[this.iHourNumber1Index]+C)===-1){return"";}else if((u===this.iMinuteNumber1Index||u===this.iSecondNumber1Index)&&!this._oTimePicker._isCharAllowed(C,u)&&this.aAllowedMinutesAndSeconds.indexOf("0"+C)!==-1){return"0"+C;}else if(A>=0&&u<this.iAfterAmPmValueIndex){w=v.slice(this.iAmPmChar1Index,u);x=this.aAmPmValues[0].slice(0,A);y=this.aAmPmValues[1].slice(0,A);z=this.aAmPmValues[0].slice(A,this.iAfterAmPmValueIndex);F=this.aAmPmValues[1].slice(A,this.iAfterAmPmValueIndex);S=(x===y);var G="";for(i=A;i<this.iAmPmValueMaxLength;i++){if(this.aAmPmValues[0][i]===this.aAmPmValues[1][i]){G+=this.aAmPmValues[0][i];}else{break;}}if(i===this.iAmPmValueMaxLength||i!==A){return G;}else{if(!S){if(w===x){return z;}else if(w===y){return F;}else{return C;}}else{if(this.aAmPmValues[0][A].toLowerCase()===C.toLowerCase()&&this.aAmPmValues[0]===w+z){return z;}else if(this.aAmPmValues[1][A].toLowerCase()===C.toLowerCase()&&this.aAmPmValues[1]===w+F){return F;}else{return C;}}}}else{return C;}};s.prototype.formatValueWithLeadingTrailingSpaces=function(v){var i=this._oTimePicker.getMask().length;if(this.aOriginalAmPmValues[0]!==this.aAmPmValues[0]){v=v.replace(this.aOriginalAmPmValues[0],this.aAmPmValues[0]);}if(this.aOriginalAmPmValues[1]!==this.aAmPmValues[1]){v=v.replace(this.aOriginalAmPmValues[1],this.aAmPmValues[1]);}while(i>v.length){v=[v.slice(0,this.iHourNumber1Index)," ",v.slice(this.iHourNumber1Index)].join('');}return v;};s.prototype.stripValueOfLeadingSpaces=function(v){if(v[this.iHourNumber1Index]===" "){v=[v.slice(0,this.iHourNumber1Index),v.slice(this.iHourNumber1Index+1)].join('');}return v;};s.prototype.shiftIndexes=function(i){if(this.iAmPmChar1Index<this.iHourNumber1Index){this.iHourNumber1Index+=i;this.iHourNumber2Index+=i;}if(this.iAmPmChar1Index<this.iMinuteNumber1Index){this.iMinuteNumber1Index+=i;}if(this.iAmPmChar1Index<this.iSecondNumber1Index){this.iSecondNumber1Index+=i;}};s.prototype.destroy=function(){if(this._maskRuleHours){this._maskRuleHours.destroy();this._maskRuleHours=null;}if(this._maskRuleMinSec){this._maskRuleMinSec.destroy();this._maskRuleMinSec=null;}if(this._maskRuleChars){this._maskRuleChars.destroy();this._maskRuleChars=null;}};n.prototype._feedReplaceChar=function(C,i,u){return this._oTimeSemanticMaskHelper.replaceChar(C,i,u);};n.prototype._getAlteredUserInputValue=function(v){return v?this._formatValue(this._parseValue(v),true):v;};n.prototype.getAccessibilityInfo=function(){var i=this.getRenderer();var u=I.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var w=this.getDateValue();if(w){v=this._formatValue(w);}}q.extend(true,u,{role:i.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TIMEINPUT"),description:[v,i.getLabelledByAnnouncement(this),i.getDescribedByAnnouncement(this)].join(" ").trim(),autocomplete:"none",expanded:false,haspopup:true,owns:this.getId()+"-sliders"});return u;};function t(){var i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),u=e.getInstance(i);return u.getTimePattern(o.Medium);}n.prototype._revertKey=function(i,S){S=S||this._getTextSelection();var u=S.iFrom,v=S.iTo,w=u,x,y;if(!S.bHasSelection){if(i.bBackspace){w=u=this._oRules.previousTo(u);}else if(i.bDelete){x=this.getPlaceholderSymbol();y=this._oTempValue._aContent.length;while((this._oTempValue._aContent[u]===x||this._oTempValue._aInitial[u]!==x)&&u<y){u++;}v=u;}}if(i.bBackspace||(i.bDelete&&S.bHasSelection)){v=v-1;}this._resetTempValue(u,v);this.updateDomValue(this._oTempValue.toString());this._setCursorPosition(Math.max(this._iUserInputStartPosition,w));};n._PICKER_CONTENT_HEIGHT="25rem";return n;});
