/*!
 * SAPUI5

        (c) Copyright 2009-2019 SAP SE. All rights reserved
    
 */
sap.ui.define(['sap/ui/thirdparty/jquery','./CalendarDate','./library','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/IconPool','sap/ui/core/date/UniversalDate','sap/m/library','sap/ui/core/Icon','./CalendarRenderer','sap/ui/Device','sap/base/Log'],function(q,C,l,a,L,I,U,m,b,c,D,d){"use strict";var e=l.CalendarEventType;var f=l.CalendarSelectionMode;var g=l.CalendarDesign;var h=a.extend("sap.me.Calendar",{metadata:{library:"sap.me",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true},hideNavControls:{type:"boolean",group:"Misc",defaultValue:false},hideMonthTitles:{type:"boolean",group:"Misc",defaultValue:false},monthsPerRow:{type:"int",group:"Misc",defaultValue:1},dayWidth:{type:"int",group:"Misc",defaultValue:45},dayHeight:{type:"int",group:"Misc",defaultValue:50},weeksPerRow:{type:"int",group:"Misc",defaultValue:1},singleRow:{type:"boolean",group:"Misc",defaultValue:null},monthsToDisplay:{type:"int",group:"Misc",defaultValue:1},currentDate:{type:"string",group:"Misc",defaultValue:null},enableMultiselection:{type:"boolean",group:"Misc",defaultValue:false},firstDayOffset:{type:"int",group:"Misc",defaultValue:0},disabledWeekDays:{type:"any",group:"Misc",defaultValue:null},disabledDates:{type:"any",group:"Misc",defaultValue:null},swipeToNavigate:{type:"boolean",group:"Misc",defaultValue:false},design:{type:"sap.me.CalendarDesign",group:"Appearance",defaultValue:g.Approval},selectionMode:{type:"sap.me.CalendarSelectionMode",group:"Behavior",defaultValue:f.SINGLE},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},days:{type:"any",group:"Appearance",defaultValue:null},months:{type:"any",group:"Appearance",defaultValue:null}},events:{tapOnDate:{parameters:{date:{type:"string"},didSelect:{type:"boolean"}}},changeCurrentDate:{parameters:{currentDate:{type:"string"}}},changeRange:{parameters:{fromDate:{type:"string"},toDate:{type:"string"}}}}}});h.prototype.init=function(){this.__setCurrentDate((new C().toDateString()),true);var o=m.getLocaleData();this.setDays(o.getDays("abbreviated"));this.setMonths(o.getMonths("abbreviated"));var p=new b({src:I.getIconURI("navigation-left-arrow")});p.addStyleClass("sapMeCalendarPrevious");p.attachPress(null,this._gotoPrevious,this);p.setParent(this);this._oPrevBtn=p;var n=new b({src:I.getIconURI("navigation-right-arrow")});n.addStyleClass("sapMeCalendarNext");n.attachPress(null,this._gotoNext,this);n.setParent(this);this._oNextBtn=n;this._oDatesClasses={};this._$interactiveDates=null;this._oLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();this._oLocaleData=L.getInstance(this._oLocale);this._bRtl=sap.ui.getCore().getConfiguration().getRTL();};h.prototype.exit=function(){this._oPrevBtn.destroy();delete this._oPrevBtn;this._oNextBtn.destroy();delete this._oNextBtn;delete this._oDatesClasses;delete this._$interactiveDates;delete this._$fromDate;delete this._$toDate;};h.prototype.onBeforeRendering=function(){delete this._$interactiveDates;};h.prototype.onAfterRendering=function(){var $=this.$();var j=null;var k=this.getDisabledWeekDays()||[];var n=[];var i;var s;for(i=0;i<k.length;i++){n.push(".sapMeCalendarWeekDay"+k[i]);}var o=this.getSingleRow()||this.getMonthsToDisplay()===1;if(!o){n.push(".sapMeCalendarDayNotInCurrentMonth");}if(n.length){var t=n.join(", ");$.find(".sapMeCalendarMonth > div.sapMeCalendarMonthDays").children(t).css({"pointer-events":"none"});j=$.find(".sapMeCalendarMonth > div.sapMeCalendarMonthDays > .sapMeCalendarMonthDay:not("+t+")");}else{j=$.find(".sapMeCalendarMonth > div.sapMeCalendarMonthDays > .sapMeCalendarMonthDay");}var p=this.getDisabledDates()||[];for(i=0;i<p.length;i++){s=p[i];j.children("input[value='"+s+"']").parent().css({"pointer-events":"none"});}for(s in this._oDatesClasses){var S=this._oDatesClasses[s].join(" ");j.children("input[value='"+s+"']").parent().addClass(S);}this._$interactiveDates=j;var H=this.getHideNavControls();this._oPrevBtn.$().css({display:H?"none":""});this._oNextBtn.$().css({display:H?"none":""});};h.prototype.setEnableMultiselection=function(E){return this.setProperty("selectionMode",E?f.MULTIPLE:f.SINGLE,true);};h.prototype.getEnableMultiselection=function(){return this.getProperty("selectionMode")==f.MULTIPLE;};h.prototype.setHideNavControls=function(H){if(this.getDomRef()){this._oPrevBtn.$().css({display:H?"none":""});this._oNextBtn.$().css({display:H?"none":""});}return this.setProperty("hideNavControls",H,true);};h.prototype.setHideMonthTitles=function(H){if(this.getDomRef()){this.$().find(".sapMeCalendarMonthName").css({visibility:H?"hidden":""});}return this.setProperty("hideMonthTitles",H,true);};h.prototype.setFirstDayOffset=function(o){o=o%this.getDays().length;return this.setProperty("firstDayOffset",o);};h.prototype.setWeeksPerRow=function(w){w=w%5;return this.setProperty("weeksPerRow",w);};h.prototype.setDisabledWeekDays=function(w){w=w||[];return this.setProperty("disabledWeekDays",w);};h.prototype.setDisabledDates=function(j){j=j||[];var i;for(i=0;i<j.length;i++){var o=j[i];if(typeof o==="string"){o=C.parseFromToDateString(o);}var s=o.toDateString();j[i]=s;}return this.setProperty("disabledDates",j);};h.prototype.ontouchstart=function(E){if(!this.getSwipeToNavigate()){this._gestureStart(E);}};h.prototype._gestureStart=function(E){this._$fromDate=this.getEnableMultiselection()?this._getDateDomRef(E.target):null;};h.prototype.ontouchmove=function(E){if(!this.getSwipeToNavigate()){this._gestureMove(E);}};h.prototype._gestureMove=function(E){if(this._$fromDate){if(!this._$toDate){this._$fromDate.addClass("sapMeCalendarHighlight");this._$toDate=this._$fromDate;}E.stopPropagation();E.preventDefault();var o=E.target;if(E.touches.length){var t=E.touches[0];o=document.elementFromPoint(t.clientX,t.clientY);}var $=this._getDateDomRef(o);if($&&$!=this._$toDate){this._$toDate.removeClass("sapMeCalendarHighlight");this._$fromDate.addClass("sapMeCalendarHighlight");$.addClass("sapMeCalendarHighlight");this._$toDate=$;}}};h.prototype.ontouchend=function(E){if(!this.getSwipeToNavigate()){this._gestureEnd(E);}};h.prototype._gestureEnd=function(E){if(this._$fromDate&&this._$toDate){E.stopPropagation();E.preventDefault();var F=this._getDateValue(this._$fromDate);var t=this._getDateValue(this._$toDate);this._$fromDate.removeClass("sapMeCalendarHighlight");this._$toDate.removeClass("sapMeCalendarHighlight");this.toggleDatesRangeSelection(F,t,true);this.fireChangeRange({fromDate:F,toDate:t});}delete this._$fromDate;delete this._$toDate;};h.prototype.ontap=function(E){this._gestureSelect(E);};h.prototype._gestureSelect=function(E){var $=this._getDateDomRef(E.target);if(D.browser.msie&&D.browser.version<11){if($.css("pointer-events")=="none"){return;}}if($){var s=this._getDateValue($);var i=!$.hasClass("sapMeCalendarSelected");if(!this.getEnableMultiselection()){if(this.getSelectionMode()==f.SINGLE){this.unselectAllDates();}else if(this.getSelectedDates().length>1){this.unselectAllDates();}}if((this.getSelectionMode()==f.RANGE)&&(this.getSelectedDates().length==1)){var F=this.getSelectedDates()[0];this.toggleDatesRangeSelection(F,s,true);this.fireChangeRange({fromDate:F,toDate:s});}else{$.toggleClass("sapMeCalendarSelected",i);this._updateDatesWithClass("sapMeCalendarSelected",s,i);this.fireTapOnDate({didSelect:i,date:s});}}};h.prototype.onswipeleft=function(E){if(this.getSwipeToNavigate()){if(!this._bRtl){this._gotoNext();}else{this._gotoPrevious();}}};h.prototype.onswiperight=function(E){if(this.getSwipeToNavigate()){if(!this._bRtl){this._gotoPrevious();}else{this._gotoNext();}}};h.prototype.getSelectedDates=function(){return this._getDatesWithStyleClass("sapMeCalendarSelected");};h.prototype.toggleDatesSelection=function(i,s){this._toggleDatesStyleClass("sapMeCalendarSelected",i,s);};h.prototype.toggleDatesType=function(i,t,s){this._toggleDatesStyleClass("sapMeCalendar"+t,i,s);};h.prototype.removeTypesOfAllDates=function(){this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type00);this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type01);this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type04);this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type06);this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type07);this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type10);};h.prototype.unselectAllDates=function(){this._removeStyleClassOfAllDates("sapMeCalendarSelected");};h.prototype.toggleDatesRangeSelection=function(o,i,s){this._toggleDatesRangeStyleClass("sapMeCalendarSelected",o,i,s);};h.prototype._getDatesWithStyleClass=function(s){var i=[];var j;for(j in this._oDatesClasses){if(this._oDatesClasses[j]&&this._oDatesClasses[j].indexOf(s)!==-1){i.push(j);}}return i;};h.prototype._toggleDatesRangeStyleClass=function(s,o,i,A){var u;var j;if(typeof o=="string"){u=C.parseFromToDateString(o);}else if(o instanceof Date){u=new U(o.getTime());}if(typeof i=="string"){j=C.parseFromToDateString(i);}else if(i instanceof Date){j=new U(i.getTime());}if(u&&j&&typeof u.getTime=="function"&&typeof j.getTime=="function"){if(u.getTime()>j.getTime()){var t=new U(u.getTime());u=j;j=t;}var k=[];var n=new U(u.getTime());var p;while(j-n>=0){p=new Date(n.getTime());k.push(p.toDateString());n.setDate(n.getDate()+1);}this._toggleDatesStyleClass(s,k,A);}};h.prototype._toggleDatesStyleClass=function(s,j,A){var i;for(i=0;i<j.length;i++){var o=j[i];if(typeof o=="string"){o=C.parseFromToDateString(o);}else if(o instanceof Date){o=new U(o.getTime());}o=new Date(o.getTime());var k=o.toDateString();j[i]=k;this._updateDatesWithClass(s,k,A);if(this._$interactiveDates){this._$interactiveDates.children("input[value='"+k+"']").parent().toggleClass(s,A);}}};h.prototype._removeStyleClassOfAllDates=function(s){var i;for(i in this._oDatesClasses){this._updateDatesWithClass(s,i,false);}if(this._$interactiveDates){this._$interactiveDates.removeClass(s);}};h.prototype._gotoPrevious=function(){var s=this.getSingleRow();if(s){this._oInternalDate.previousWeek();}else{this._oInternalDate.previousMonth();}var i=this._oInternalDate.toDateString();this.setCurrentDate(i);this.fireChangeCurrentDate({currentDate:i});};h.prototype._gotoNext=function(){var s=this.getSingleRow();if(s){this._oInternalDate.nextWeek();}else{this._oInternalDate.nextMonth();}var i=this._oInternalDate.toDateString();this.setCurrentDate(i);this.fireChangeCurrentDate({currentDate:i});};h.prototype._updateDatesWithClass=function(s,j,A){var S=this._oDatesClasses[j]||[];var i=S.indexOf(s);if(A&&i===-1){S.push(s);}else if(!A&&i!==-1){S.splice(i,1);}if(S.length===0){this._oDatesClasses[j]=null;delete this._oDatesClasses[j];}else{this._oDatesClasses[j]=S;}};h.prototype._getDateValue=function($){return $.children("input").eq(0).val();};h.prototype._getMonthDate=function(o){var $=q(o);var i=q(this.getDomRef());while($&&$!=i&&!$.hasClass("sapMeCalendarMonthDay")){$=$.parent();}return $&&$.parent().hasClass("sapMeCalendarMonth")?$:null;};h.prototype._getDateDomRef=function(o){var $=o?q(o):null;var t=this.getId();var i=null;while($&&$[0].id!=t&&!$.hasClass("sapMeCalendarMonth")){if($.hasClass("sapMeCalendarMonthDay")&&$.parent().hasClass("sapMeCalendarMonthDays")){i=$;break;}$=$.parent();}return i;};h.prototype._checkLanguageRegion=function(i,r){return(r===this._oLocale.getRegion()&&i===this._oLocale.getLanguage());};h.prototype._getIntervalPattern=function(p){return this._oLocaleData.getIntervalPattern(p);};h.prototype.getCurrentDate=function(){return this._oInternalDate.toDateString();};h.prototype.setCurrentDate=function(s){this.__setCurrentDate(s,false);return this;};h.prototype.__setCurrentDate=function(s,S){this._oInternalDate=new C(C.parseFromToDateString(s));this.setProperty("currentDate",this._oInternalDate.toDateString(),S);};h.parseDate=function(s){var o=C.parseFromToDateString(s,true);return new Date(o.getTime());};h.prototype._getCalendarFirstDate=function(){var F=new U(this._oInternalDate._date.getTime());if(this.getSingleRow()){F.setHours(12);var i=F.getDay()-this.getFirstDayOffset();var j;if(i<0){j=(7-Math.abs(i))%7;}else{j=i;}F.setDate(F.getDate()-j);}else{d.error("You cannot use this method in a non single row calendar, returning current date.");}return F;};h.prototype.isWeekend=function(i){var s=this._oLocaleData.getWeekendStart(),j=this._oLocaleData.getWeekendEnd(),k=false;if(s<=j){k=(s<=i)&&(i<=j);}else{k=(i>=s)||(i<=j);}return k;};return h;});
