//@ui5-bundle sap/me/library-preload.js
/*!
 * SAPUI5

        (c) Copyright 2009-2019 SAP SE. All rights reserved
    
 */
sap.ui.predefine('sap/me/Calendar',['sap/ui/thirdparty/jquery','./CalendarDate','./library','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/IconPool','sap/ui/core/date/UniversalDate','sap/m/library','sap/ui/core/Icon','./CalendarRenderer','sap/ui/Device','sap/base/Log'],function(q,C,l,a,L,I,U,m,b,c,D,d){"use strict";var e=l.CalendarEventType;var f=l.CalendarSelectionMode;var g=l.CalendarDesign;
var h=a.extend("sap.me.Calendar",{metadata:{library:"sap.me",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true},hideNavControls:{type:"boolean",group:"Misc",defaultValue:false},hideMonthTitles:{type:"boolean",group:"Misc",defaultValue:false},monthsPerRow:{type:"int",group:"Misc",defaultValue:1},dayWidth:{type:"int",group:"Misc",defaultValue:45},dayHeight:{type:"int",group:"Misc",defaultValue:50},weeksPerRow:{type:"int",group:"Misc",defaultValue:1},singleRow:{type:"boolean",group:"Misc",defaultValue:null},monthsToDisplay:{type:"int",group:"Misc",defaultValue:1},currentDate:{type:"string",group:"Misc",defaultValue:null},enableMultiselection:{type:"boolean",group:"Misc",defaultValue:false},firstDayOffset:{type:"int",group:"Misc",defaultValue:0},disabledWeekDays:{type:"any",group:"Misc",defaultValue:null},disabledDates:{type:"any",group:"Misc",defaultValue:null},swipeToNavigate:{type:"boolean",group:"Misc",defaultValue:false},design:{type:"sap.me.CalendarDesign",group:"Appearance",defaultValue:g.Approval},selectionMode:{type:"sap.me.CalendarSelectionMode",group:"Behavior",defaultValue:f.SINGLE},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},days:{type:"any",group:"Appearance",defaultValue:null},months:{type:"any",group:"Appearance",defaultValue:null}},events:{tapOnDate:{parameters:{date:{type:"string"},didSelect:{type:"boolean"}}},changeCurrentDate:{parameters:{currentDate:{type:"string"}}},changeRange:{parameters:{fromDate:{type:"string"},toDate:{type:"string"}}}}}});
h.prototype.init=function(){this.__setCurrentDate((new C().toDateString()),true);var o=m.getLocaleData();this.setDays(o.getDays("abbreviated"));this.setMonths(o.getMonths("abbreviated"));var p=new b({src:I.getIconURI("navigation-left-arrow")});p.addStyleClass("sapMeCalendarPrevious");p.attachPress(null,this._gotoPrevious,this);p.setParent(this);this._oPrevBtn=p;var n=new b({src:I.getIconURI("navigation-right-arrow")});n.addStyleClass("sapMeCalendarNext");n.attachPress(null,this._gotoNext,this);n.setParent(this);this._oNextBtn=n;this._oDatesClasses={};this._$interactiveDates=null;this._oLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();this._oLocaleData=L.getInstance(this._oLocale);this._bRtl=sap.ui.getCore().getConfiguration().getRTL();};
h.prototype.exit=function(){this._oPrevBtn.destroy();delete this._oPrevBtn;this._oNextBtn.destroy();delete this._oNextBtn;delete this._oDatesClasses;delete this._$interactiveDates;delete this._$fromDate;delete this._$toDate;};
h.prototype.onBeforeRendering=function(){delete this._$interactiveDates;};
h.prototype.onAfterRendering=function(){var $=this.$();var j=null;var k=this.getDisabledWeekDays()||[];var n=[];var i;var s;for(i=0;i<k.length;i++){n.push(".sapMeCalendarWeekDay"+k[i]);}var o=this.getSingleRow()||this.getMonthsToDisplay()===1;if(!o){n.push(".sapMeCalendarDayNotInCurrentMonth");}if(n.length){var t=n.join(", ");$.find(".sapMeCalendarMonth > div.sapMeCalendarMonthDays").children(t).css({"pointer-events":"none"});j=$.find(".sapMeCalendarMonth > div.sapMeCalendarMonthDays > .sapMeCalendarMonthDay:not("+t+")");}else{j=$.find(".sapMeCalendarMonth > div.sapMeCalendarMonthDays > .sapMeCalendarMonthDay");}var p=this.getDisabledDates()||[];for(i=0;i<p.length;i++){s=p[i];j.children("input[value='"+s+"']").parent().css({"pointer-events":"none"});}for(s in this._oDatesClasses){var S=this._oDatesClasses[s].join(" ");j.children("input[value='"+s+"']").parent().addClass(S);}this._$interactiveDates=j;var H=this.getHideNavControls();this._oPrevBtn.$().css({display:H?"none":""});this._oNextBtn.$().css({display:H?"none":""});};
h.prototype.setEnableMultiselection=function(E){return this.setProperty("selectionMode",E?f.MULTIPLE:f.SINGLE,true);};
h.prototype.getEnableMultiselection=function(){return this.getProperty("selectionMode")==f.MULTIPLE;};
h.prototype.setHideNavControls=function(H){if(this.getDomRef()){this._oPrevBtn.$().css({display:H?"none":""});this._oNextBtn.$().css({display:H?"none":""});}return this.setProperty("hideNavControls",H,true);};
h.prototype.setHideMonthTitles=function(H){if(this.getDomRef()){this.$().find(".sapMeCalendarMonthName").css({visibility:H?"hidden":""});}return this.setProperty("hideMonthTitles",H,true);};
h.prototype.setFirstDayOffset=function(o){o=o%this.getDays().length;return this.setProperty("firstDayOffset",o);};
h.prototype.setWeeksPerRow=function(w){w=w%5;return this.setProperty("weeksPerRow",w);};
h.prototype.setDisabledWeekDays=function(w){w=w||[];return this.setProperty("disabledWeekDays",w);};
h.prototype.setDisabledDates=function(j){j=j||[];var i;for(i=0;i<j.length;i++){var o=j[i];if(typeof o==="string"){o=C.parseFromToDateString(o);}var s=o.toDateString();j[i]=s;}return this.setProperty("disabledDates",j);};
h.prototype.ontouchstart=function(E){if(!this.getSwipeToNavigate()){this._gestureStart(E);}};
h.prototype._gestureStart=function(E){this._$fromDate=this.getEnableMultiselection()?this._getDateDomRef(E.target):null;};
h.prototype.ontouchmove=function(E){if(!this.getSwipeToNavigate()){this._gestureMove(E);}};
h.prototype._gestureMove=function(E){if(this._$fromDate){if(!this._$toDate){this._$fromDate.addClass("sapMeCalendarHighlight");this._$toDate=this._$fromDate;}E.stopPropagation();E.preventDefault();var o=E.target;if(E.touches.length){var t=E.touches[0];o=document.elementFromPoint(t.clientX,t.clientY);}var $=this._getDateDomRef(o);if($&&$!=this._$toDate){this._$toDate.removeClass("sapMeCalendarHighlight");this._$fromDate.addClass("sapMeCalendarHighlight");$.addClass("sapMeCalendarHighlight");this._$toDate=$;}}};
h.prototype.ontouchend=function(E){if(!this.getSwipeToNavigate()){this._gestureEnd(E);}};
h.prototype._gestureEnd=function(E){if(this._$fromDate&&this._$toDate){E.stopPropagation();E.preventDefault();var F=this._getDateValue(this._$fromDate);var t=this._getDateValue(this._$toDate);this._$fromDate.removeClass("sapMeCalendarHighlight");this._$toDate.removeClass("sapMeCalendarHighlight");this.toggleDatesRangeSelection(F,t,true);this.fireChangeRange({fromDate:F,toDate:t});}delete this._$fromDate;delete this._$toDate;};
h.prototype.ontap=function(E){this._gestureSelect(E);};
h.prototype._gestureSelect=function(E){var $=this._getDateDomRef(E.target);if(D.browser.msie&&D.browser.version<11){if($.css("pointer-events")=="none"){return;}}if($){var s=this._getDateValue($);var i=!$.hasClass("sapMeCalendarSelected");if(!this.getEnableMultiselection()){if(this.getSelectionMode()==f.SINGLE){this.unselectAllDates();}else if(this.getSelectedDates().length>1){this.unselectAllDates();}}if((this.getSelectionMode()==f.RANGE)&&(this.getSelectedDates().length==1)){var F=this.getSelectedDates()[0];this.toggleDatesRangeSelection(F,s,true);this.fireChangeRange({fromDate:F,toDate:s});}else{$.toggleClass("sapMeCalendarSelected",i);this._updateDatesWithClass("sapMeCalendarSelected",s,i);this.fireTapOnDate({didSelect:i,date:s});}}};
h.prototype.onswipeleft=function(E){if(this.getSwipeToNavigate()){if(!this._bRtl){this._gotoNext();}else{this._gotoPrevious();}}};
h.prototype.onswiperight=function(E){if(this.getSwipeToNavigate()){if(!this._bRtl){this._gotoPrevious();}else{this._gotoNext();}}};
h.prototype.getSelectedDates=function(){return this._getDatesWithStyleClass("sapMeCalendarSelected");};
h.prototype.toggleDatesSelection=function(i,s){this._toggleDatesStyleClass("sapMeCalendarSelected",i,s);};
h.prototype.toggleDatesType=function(i,t,s){this._toggleDatesStyleClass("sapMeCalendar"+t,i,s);};
h.prototype.removeTypesOfAllDates=function(){this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type00);this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type01);this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type04);this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type06);this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type07);this._removeStyleClassOfAllDates("sapMeCalendar"+e.Type10);};
h.prototype.unselectAllDates=function(){this._removeStyleClassOfAllDates("sapMeCalendarSelected");};
h.prototype.toggleDatesRangeSelection=function(o,i,s){this._toggleDatesRangeStyleClass("sapMeCalendarSelected",o,i,s);};
h.prototype._getDatesWithStyleClass=function(s){var i=[];var j;for(j in this._oDatesClasses){if(this._oDatesClasses[j]&&this._oDatesClasses[j].indexOf(s)!==-1){i.push(j);}}return i;};
h.prototype._toggleDatesRangeStyleClass=function(s,o,i,A){var u;var j;if(typeof o=="string"){u=C.parseFromToDateString(o);}else if(o instanceof Date){u=new U(o.getTime());}if(typeof i=="string"){j=C.parseFromToDateString(i);}else if(i instanceof Date){j=new U(i.getTime());}if(u&&j&&typeof u.getTime=="function"&&typeof j.getTime=="function"){if(u.getTime()>j.getTime()){var t=new U(u.getTime());u=j;j=t;}var k=[];var n=new U(u.getTime());var p;while(j-n>=0){p=new Date(n.getTime());k.push(p.toDateString());n.setDate(n.getDate()+1);}this._toggleDatesStyleClass(s,k,A);}};
h.prototype._toggleDatesStyleClass=function(s,j,A){var i;for(i=0;i<j.length;i++){var o=j[i];if(typeof o=="string"){o=C.parseFromToDateString(o);}else if(o instanceof Date){o=new U(o.getTime());}o=new Date(o.getTime());var k=o.toDateString();j[i]=k;this._updateDatesWithClass(s,k,A);if(this._$interactiveDates){this._$interactiveDates.children("input[value='"+k+"']").parent().toggleClass(s,A);}}};
h.prototype._removeStyleClassOfAllDates=function(s){var i;for(i in this._oDatesClasses){this._updateDatesWithClass(s,i,false);}if(this._$interactiveDates){this._$interactiveDates.removeClass(s);}};
h.prototype._gotoPrevious=function(){var s=this.getSingleRow();if(s){this._oInternalDate.previousWeek();}else{this._oInternalDate.previousMonth();}var i=this._oInternalDate.toDateString();this.setCurrentDate(i);this.fireChangeCurrentDate({currentDate:i});};
h.prototype._gotoNext=function(){var s=this.getSingleRow();if(s){this._oInternalDate.nextWeek();}else{this._oInternalDate.nextMonth();}var i=this._oInternalDate.toDateString();this.setCurrentDate(i);this.fireChangeCurrentDate({currentDate:i});};
h.prototype._updateDatesWithClass=function(s,j,A){var S=this._oDatesClasses[j]||[];var i=S.indexOf(s);if(A&&i===-1){S.push(s);}else if(!A&&i!==-1){S.splice(i,1);}if(S.length===0){this._oDatesClasses[j]=null;delete this._oDatesClasses[j];}else{this._oDatesClasses[j]=S;}};
h.prototype._getDateValue=function($){return $.children("input").eq(0).val();};
h.prototype._getMonthDate=function(o){var $=q(o);var i=q(this.getDomRef());while($&&$!=i&&!$.hasClass("sapMeCalendarMonthDay")){$=$.parent();}return $&&$.parent().hasClass("sapMeCalendarMonth")?$:null;};
h.prototype._getDateDomRef=function(o){var $=o?q(o):null;var t=this.getId();var i=null;while($&&$[0].id!=t&&!$.hasClass("sapMeCalendarMonth")){if($.hasClass("sapMeCalendarMonthDay")&&$.parent().hasClass("sapMeCalendarMonthDays")){i=$;break;}$=$.parent();}return i;};
h.prototype._checkLanguageRegion=function(i,r){return(r===this._oLocale.getRegion()&&i===this._oLocale.getLanguage());};
h.prototype._getIntervalPattern=function(p){return this._oLocaleData.getIntervalPattern(p);};
h.prototype.getCurrentDate=function(){return this._oInternalDate.toDateString();};
h.prototype.setCurrentDate=function(s){this.__setCurrentDate(s,false);return this;};
h.prototype.__setCurrentDate=function(s,S){this._oInternalDate=new C(C.parseFromToDateString(s));this.setProperty("currentDate",this._oInternalDate.toDateString(),S);};
h.parseDate=function(s){var o=C.parseFromToDateString(s,true);return new Date(o.getTime());};
h.prototype._getCalendarFirstDate=function(){var F=new U(this._oInternalDate._date.getTime());if(this.getSingleRow()){F.setHours(12);var i=F.getDay()-this.getFirstDayOffset();var j;if(i<0){j=(7-Math.abs(i))%7;}else{j=i;}F.setDate(F.getDate()-j);}else{d.error("You cannot use this method in a non single row calendar, returning current date.");}return F;};
h.prototype.isWeekend=function(i){var s=this._oLocaleData.getWeekendStart(),j=this._oLocaleData.getWeekendEnd(),k=false;if(s<=j){k=(s<=i)&&(i<=j);}else{k=(i>=s)||(i<=j);}return k;};
return h;});
sap.ui.predefine('sap/me/CalendarDate',['sap/ui/base/Object','sap/ui/core/date/UniversalDate',"sap/base/Log"],function(B,U,L){"use strict";
var t=B.extend("sap.me.CalendarDate",{constructor:function(){if(arguments.length===0||!(arguments[0]instanceof Date||arguments[0]instanceof U)){var d=new Date();this._date=t.createDate(d.getFullYear(),d.getMonth(),d.getDate());}else{var i=arguments[0];if(i instanceof U){i=new Date(i.getTime());}this._date=t.createDate(i.getFullYear(),i.getMonth(),i.getDate());}}});
t.createDate=function(y,m,d){var D=new Date(y,m,d,12,0,0);return new U(D.getTime());};
t._regExpToDateString=/^(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d\d?) (\d\d\d\d)$/i;
t.prototype.getDateObject=function(){return this._date;};
t.prototype.getCopyDateObject=function(){var c=new U(this._date.getTime());return c;};
t.getMonthFromString=function(s){var m=["jan","feb","mar","apr","may","jun","jul","aug","sep","oct","nov","dec"];s=s.toLowerCase();return m.indexOf(s);};
t.parseFromToDateString=function(f,T){var p;var r=t._regExpToDateString.exec(f);if(r!==null&&r.length===4&&r[0]===f){p=t.createDate(parseInt(r[3]),t.getMonthFromString(r[1]),parseInt(r[2]));}else{L.warning("The provided string does not match the toDateString format: "+f);if(typeof T==="boolean"&&T){throw new Error("Unparseable string provided: "+f);}var d=new Date(f);p=new U(d.getTime());}return p;};
t.prototype.nextMonth=function(){this._date=t.getNextMonth(this._date);return this._date;};
t.getNextMonth=function(d){var n=new U(d);n.setMonth(n.getMonth()+1,1);n.setHours(12,0,0);return n;};
t.prototype.previousMonth=function(){this._date=t.getPreviousMonth(this._date);return this._date;};
t.getPreviousMonth=function(d){var p=new U(d);p.setMonth(p.getMonth()-1,1);p.setHours(12,0,0);return p;};
t.prototype.nextWeek=function(){this._date.setHours(12);this._date.setDate(this._date.getDate()+7);return this._date;};
t.prototype.previousWeek=function(){this._date.setHours(12);this._date.setDate(this._date.getDate()-7);return this._date;};
t.prototype.toDateString=function(){var d=new Date(this._date.getTime());return d.toDateString();};
return t;},true);
sap.ui.predefine('sap/me/CalendarLegend',["sap/ui/thirdparty/jquery",'./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/theming/Parameters',"sap/m/Label","sap/ui/core/Icon","./CalendarLegendRenderer"],function(q,l,C,I,P,L,a,b){"use strict";var c=l.CalendarDesign;
var d=C.extend("sap.me.CalendarLegend",{metadata:{library:"sap.me",properties:{legendForType00:{type:"string",group:"Misc",defaultValue:null},legendForType01:{type:"string",group:"Misc",defaultValue:null},legendForType04:{type:"string",group:"Misc",defaultValue:null},legendForType06:{type:"string",group:"Misc",defaultValue:null},legendForType07:{type:"string",group:"Misc",defaultValue:null},legendForToday:{type:"string",group:"Misc",defaultValue:null},legendForSelected:{type:"string",group:"Misc",defaultValue:null},legendForSelected00:{type:"string",group:"Misc",defaultValue:null},legendForNormal:{type:"string",group:"Misc",defaultValue:null},expandable:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},legendWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'12.5rem'},visible:{type:"boolean",group:"Appearance",defaultValue:true},design:{type:"sap.me.CalendarDesign",group:"Appearance",defaultValue:c.Approval}},aggregations:{labels:{type:"sap.m.Label",multiple:true,singularName:"label",visibility:"hidden"},colors:{type:"sap.ui.core.Control",multiple:true,singularName:"color",visibility:"hidden"},icon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}}});
d.prototype.init=function(){this._createIcon();I.insertFontFaceStyle();this._legendIndex=[];};
d.prototype.setLegendForType00=function(v){this._setLegendLabelByName("ForType00",v);return this;};
d.prototype.setLegendForType01=function(v){this._setLegendLabelByName("ForType01",v);return this;};
d.prototype.setLegendForType04=function(v){this._setLegendLabelByName("ForType04",v);return this;};
d.prototype.setLegendForType06=function(v){this._setLegendLabelByName("ForType06",v);return this;};
d.prototype.setLegendForType07=function(v){this._setLegendLabelByName("ForType07",v);return this;};
d.prototype.setLegendForToday=function(v){this._setLegendLabelByName("ForToday",v);return this;};
d.prototype.setLegendForSelected=function(v){this._setLegendLabelByName("ForSelected",v);return this;};
d.prototype.setLegendForSelected00=function(v){this._setLegendLabelByName("ForSelected00",v);return this;};
d.prototype.setLegendForNormal=function(v){this._setLegendLabelByName("ForNormal",v);return this;};
d.prototype.setExpanded=function(v){this.setProperty("expanded",v);this._changeIconSrc();return this;};
d.prototype._setLegendLabelByName=function(n,v){var o=sap.ui.getCore().byId(this.getId()+"-"+n);var e=sap.ui.getCore().byId(this.getId()+'-Color'+n);if(!o){o=new L(this.getId()+'-'+n,{width:"auto"});o.addStyleClass("sapUIMeCalendarLegendLabels");this.addAggregation("labels",o,true);o.setText(v);e=new L(this.getId()+'-Color'+n);e.addStyleClass("sapUIMeLegendColor");e.addStyleClass("sapUIMeLegendColor"+n);this.addAggregation("colors",e,true);this._legendIndex.push(n);}else{o.setText(v);if(!v){this.removeAggregation("colors",e,true);this.removeAggregation("labels",o,true);}else{var i=this._legendIndex.indexOf(n);this.insertAggregation("colors",e,i,true);this.insertAggregation("labels",o,i,true);}}this.setProperty("legend"+n,v);return this;};
d.prototype.setExpandable=function(v){this.setProperty("expandable",v);if(!v&&!this.getExpanded()){this.toggleExpandCollapse();}return this;};
d.prototype.setVisible=function(v){this.setProperty("visible",v);return this;};
d.prototype.toggleExpandCollapse=function(){if(!this.getExpandable()){return;}var e=!this.getExpanded();var $=this.$("LegendMenu");if(e){this.$("LegendMenu").css("display","none").css("height","auto");$.slideDown('600',"swing",q.proxy(this.onTransitionEnded,this));}else{$.slideUp('600',q.proxy(this.onTransitionEnded,this));}this.setProperty("expanded",e,true);this._changeIconSrc();};
d.prototype._createIcon=function(){var i=this.getExpanded()?"collapse":"expand";var s=P.get("sapUiLightIcon");var A=P.get("sapUiHighlight");var e=P.get("sapUiIconInverted");var o=new a(this.getId()+i,{src:I.getIconURI(i),color:s,activeBackgroundColor:A,activeColor:e,press:q.proxy(this.toggleExpandCollapse,this)});o.addStyleClass("sapUIMeLegendIcon");this.setAggregation("icon",o,true);};
d.prototype._getColorBoxStyle=function(i){var e=this.getId()+"-";var s=i.substr(i.indexOf(e)+e.length);s="sapUIMeLegendColor"+s;return s;};
d.prototype._changeIconSrc=function(){var i=this.getExpanded()?"collapse":"expand";this.getAggregation("icon").setSrc(I.getIconURI(i));};
return d;});
sap.ui.predefine('sap/me/CalendarLegendRenderer',[],function(){"use strict";var C={};
C.render=function(r,c){var l=c.getAggregation("labels");if(c.getVisible()&&l&&l.length>0){var m="";var w=c.getWidth();if(w){m+="width:"+w+";";}r.write("<div");r.writeControlData(c);r.addClass("sapUIMeLegendOuterContainer");r.writeAttribute("style",m);r.writeClasses();r.write(">");r.write("<div");r.addClass("sapMeCalendarLegend");r.addClass("sapMeCalendarLegend"+c.getDesign());r.writeClasses();r.write(">");r.write("<div  id='"+c.getId()+"-arrow'");r.addClass("sapUIMeLegend");r.writeClasses();r.write(">");if(c.getExpandable()){r.renderControl(c.getAggregation("icon"));}r.write("<div id='"+c.getId()+"-LegendMenuContainer'");r.addClass("sapUIMeLegendMenuContainer");r.writeClasses();r.write(">");r.write("<div id='"+c.getId()+"-LegendMenu'");r.addClass("sapUIMeLegendMenu");if(!c.getExpanded()){r.write("style = 'display:none'");}r.writeClasses();r.write(">");for(var i=0;i<l.length;i++){r.write("<div ");r.addClass("sapUIMeLegendLine");r.writeClasses();r.write(">");r.write("<div ");r.addClass("sapUIMeLegendColor");r.addClass(c._getColorBoxStyle(l[i].getId()));r.writeClasses();r.write("></div>");r.renderControl(l[i]);r.write("</div>");}r.write("</div>");r.write("</div>");r.write("</div>");r.write("</div>");r.write("</div>");}};
return C;},true);
sap.ui.predefine('sap/me/CalendarRenderer',['./CalendarDate','sap/ui/core/LocaleData','sap/ui/core/format/DateFormat','sap/ui/core/date/UniversalDate'],function(C,L,D,U){"use strict";var a={};
a.render=function(r,c){if(!c.getVisible()){return;}r.write("<div");r.writeControlData(c);r.addClass("sapMeCalendar");var s="sapMeCalendar"+c.getDesign();r.addClass(s);r.writeClasses();var w=c.getWidth();if(w!=undefined){r.addStyle("width",w);r.writeStyles();}r.write(">");r.renderControl(c._oPrevBtn);r.renderControl(c._oNextBtn);var S=c.getSingleRow();var m=S?1:c.getMonthsToDisplay();var n=new C();var N=n.toDateString();var i;if(m===1){this._renderMonth(r,c,c._oInternalDate.getDateObject(),N);}else{var b=c._oInternalDate.getCopyDateObject();var M=Math.floor(m/2);for(i=0;i<M;i++){b=C.getPreviousMonth(b);}for(i=0;i<m;i++){this._renderMonth(r,c,b,N);b=C.getNextMonth(b);}}r.write("</div>");};
a._getMonthTitle=function(c,s,t){var f={format:"yMMM"};var F;var T;if(s){T=new U(c.getTime());T.setDate(T.getDate()+t-1);f.interval=true;}F=D.getDateInstance(f);return f.interval?F.format([c,T]):F.format(c);};
a._renderMonth=function(r,c,m,d){var s=c.getSingleRow();var f=c.getFirstDayOffset();var w=c.getDays();var W=w.length;var b=c.getWeeksPerRow();var e=b*W;var g=(100/e);var h=c.getDayHeight();var M=(100/(s?1:c.getMonthsPerRow()));var t=new Date(m.getTime());var j=C.createDate(t.getFullYear(),t.getMonth(),t.getDate());var k=j.getDate();var l=j.getDay();j.setDate(1);var n=j.getDay();if(n<f){n+=7;}var o=j.getMonth();var p=new U(j);p.setMonth(o+1,0);var q=p.getDate();var u=s?l+1-f:k+n-f;var v=Math.ceil((q+u-k)/7);var T=s?e:(v*7);if(s){j=c._getCalendarFirstDate();}var x=this._getMonthTitle(j,s,T);if(!s){j.setDate(k-u+1);}r.write('<div');r.addClass("sapMeCalendarMonth");if(!s){r.addClass("sapMeCalendarMonthNotSingle");}r.writeClasses();r.addStyle("width",M+"%");r.writeStyles();r.write(">");r.write('<div');r.addClass("sapMeCalendarMonthName");r.writeClasses();if(c.getHideMonthTitles()){r.addStyle("visibility","hidden");r.writeStyles();}r.write(">");r.writeEscaped(x);r.write("</div>");r.write('<div');r.addClass("sapMeCalendarMonthDayNames");r.writeClasses();r.write(">");var i;for(i=0;i<e;i++){var y=w[(i+f)%W];this._renderDay(r,c,null,y,g);}r.write('</div>');r.write('<div');r.addClass("sapMeCalendarMonthDays");r.writeClasses();r.write(">");for(i=0;i<T;i++){var z=j.getMonth();var A=j.getDay();l=j.getDate();var N=z!==o;t=new Date(j.getTime());var I=t.toDateString();var B=I==d;this._renderDay(r,c,I,l+"",g,h,A,N,B);j.setDate(j.getDate()+1);}r.write('</div>');r.write('</div>');};
a._renderDay=function(r,c,i,s,d,b,e,n,I){r.write("<div");r.addClass("sapMeCalendarMonthDay");if(I){r.addClass("sapMeCalendarDayNow");}if(n&&!c.getSingleRow()){r.addClass("sapMeCalendarDayNotInCurrentMonth");}if(typeof e==="number"){r.addClass("sapMeCalendarWeekDay"+e);if(c.isWeekend(e)){r.addClass("sapMeCalendarWeekendDay");}}r.writeClasses();r.addStyle("width",d+"%");if(b){r.addStyle("height",b+"px");}r.writeStyles();if(i!=null){var f=i.replace(/\s/g,"-");r.writeAttribute('id',c.getId()+"-"+f);}r.write(">");r.write('<span>');r.writeEscaped(s);r.write("</span>");if(i!=null){r.write('<input type="hidden" value="'+i+'"></input>');}r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/me/OverlapCalendar',['sap/ui/thirdparty/jquery','./Calendar','./CalendarDate','./library','sap/ui/core/Control','sap/ui/core/theming/Parameters','sap/ui/core/date/UniversalDate','sap/m/Label','./OverlapCalendarRenderer','sap/base/Log','sap/ui/Device'],function(q,C,a,c,d,P,U,L,O,f,D){"use strict";
var g=d.extend("sap.me.OverlapCalendar",{metadata:{library:"sap.me",properties:{startDate:{type:"string",group:"Data",defaultValue:null},weeksPerRow:{type:"int",group:"Appearance",defaultValue:2},firstDayOffset:{type:"int",group:"Appearance",defaultValue:0},showOverlapIndicator:{type:"boolean",group:"Appearance",defaultValue:false},visible:{type:"boolean",group:"Appearance",defaultValue:true},swipeToNavigate:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'}},aggregations:{calendarEvents:{type:"sap.me.OverlapCalendarEvent",multiple:true,singularName:"calendarEvent"},calendar:{type:"sap.me.Calendar",multiple:false,visibility:"hidden"},typeLabels:{type:"sap.m.Label",multiple:true,singularName:"typeLabel",visibility:"hidden"},nameLabels:{type:"sap.m.Label",multiple:true,singularName:"nameLabel",visibility:"hidden"}},events:{endOfData:{parameters:{before:{type:"boolean"}}},changeDate:{parameters:{firstDate:{type:"object"},lastDate:{type:"object"}}}}}});
g.prototype.init=function(){this.setAggregation("calendar",new C({singleRow:true,weeksPerRow:this.getWeeksPerRow(),monthsPerRow:1,monthsToDisplay:1,dayWidth:48,dayHeight:48,swipeToNavigate:this.getSwipeToNavigate()}));this.getCalendar().attachChangeCurrentDate(this.onCurrentDateChanged,this);this._typeWithBgImages=["04","07"];this._oDaysOverlap={};this._bRtl=sap.ui.getCore().getConfiguration().getRTL();};
g.prototype.onswiperight=function(e){if(this.getSwipeToNavigate()){this.getCalendar().onswiperight(e);}};
g.prototype.onswipeleft=function(e){if(this.getSwipeToNavigate()){this.getCalendar().onswipeleft(e);}};
g.prototype.setSwipeToNavigate=function(s){this.getCalendar().setSwipeToNavigate(s);this.setProperty("swipeToNavigate",s,true);return this;};
g.prototype._getFirstDateDisplayed=function(){var F=this.getCalendar().getFirstDayOffset();var b=this._createDateInDays(this.getStartDate());var i=b.getDate();var e=b.getDay();b.setDate(1);var h=e+1-F;b.setDate(i-h+1);return b;};
g.prototype._getLastDateDisplayed=function(){var w=this.getCalendar().getDays();var W=w.length;var i=this.getCalendar().getWeeksPerRow();var b=i*W;var e=this._getFirstDateDisplayed();var t=this._createDateInDays(e.getTime());t.setDate(t.getDate()+b-1);return t;};
g.prototype.setWeeksPerRow=function(w){this.getCalendar().setWeeksPerRow(w);this.setProperty("weeksPerRow",w);return this;};
g.prototype.getCalendar=function(){return this.getAggregation("calendar");};
g._ctorSafeDate=function(b){var s=b;if(b instanceof U){s=b.getTime();}return s;};
g._getJSDate=function(b){var j=b;if(b instanceof U){j=new Date(b.getTime());}return j;};
g.prototype.setStartDate=function(s){var b=g._ctorSafeDate(s);this.getCalendar().setFirstDayOffset(0);this.getCalendar().setCurrentDate(b);this.setProperty("startDate",b);var o=this._getDaysOffset(this._createDateInDays(b),this._getFirstDateDisplayed());this.getCalendar().setFirstDayOffset(o);return this;};
g.prototype.onCurrentDateChanged=function(e){this.setProperty("startDate",e.getParameter("currentDate"),true);this.getCalendar().invalidate();this._renderCalendarEvents();this.fireChangeDate({firstDate:g._getJSDate(this._getFirstDateDisplayed()),endDate:g._getJSDate(this._getLastDateDisplayed())});};
g.prototype.onBeforeRendering=function(){this._cleanUp();this._aRows=[];this._lastDate=null;this._firstDate=null;var b=this.getCalendarEvents();q.each(b,q.proxy(this._parseCalendarEvent,this));};
g.prototype.onAfterRendering=function(){this._renderCalendarEvents();D.resize.attachHandler(this._onResize,this);};
g.prototype._onResize=function(){if(this._sDelayedResize){clearInterval(this._sDelayedResize);}this._sDelayedResize=setTimeout(this._fireRecomputeElementsSizes.bind(this),200);};
g.prototype.exit=function(){this._cleanUp();};
g.prototype._cleanUp=function(){D.resize.detachHandler(this._onResize,this);};
g.prototype._fireRecomputeElementsSizes=function(){var o=this.$();var e=o.find(".sapMeOverlapCalendarHalfDay");q.merge(e,o.find(".sapMeOverlapCalendarRowLabels"));this._sizeElementsToParent(e);};
g.prototype._getDayId=function(b){var e=this._createDateInDays(this._getFirstDateDisplayed());return this._getDaysOffset(e,this._createDateInDays(b));};
g.prototype._cleanUpDivs=function(){var o=this.$();o.find(".sapMeOverlapCalendarDay").removeClass().addClass("sapMeOverlapCalendarDay");o.find(".sapMeOverlapCalendarHalfDay").remove();o.find(".sapMeOverlapCalendarDay.sapMeOverlapCalendarDayWithHalf").removeClass(".sapMeOverlapCalendarDayWithHalf");o.find(".sapMeOverlapCalendarOverlap").css("background-color","transparent").css("border","none");o.find(".sapMeOverlapCalendarTypeLbl").remove();};
g.prototype._renderCalendarEvents=function(){var i;this._mHalfDays={};this._cleanUpDivs();this._oDaysOverlap={};var b=this.getCalendarEvents();q.each(b,q.proxy(this._renderCalendarEvent,this));q.each(this._mHalfDays,q.proxy(this._renderHalfDayCalendarEvent,this));if(this.getShowOverlapIndicator()){for(i in this._oDaysOverlap){if(this._oDaysOverlap[i]!=undefined&&this._oDaysOverlap[i]>1){var $=q(document.getElementById(this._provideId("overlap",i)));$.css("background-color",P.get("sapMeOverlapCalendarIndicator"));$.css("border-right","1px solid "+P.get("sapMeOverlapCalendarIndicator"));}}}if(this._firstDate&&this._lastDate){var e=this._getFirstDateDisplayed();e.setDate(e.getDate()+7);var h=this._getLastDateDisplayed();h.setDate(h.getDate()-7);if((this._dayIsBefore(this._lastDate,e))){this.fireEndOfData({before:false});}else if(this._dayIsAfter(this._firstDate,h)){this.fireEndOfData({before:true});}}};
g.prototype._provideId=function(){var s=q.makeArray(arguments).join("-");return this.getId()+"-"+s;};
g.prototype._addToDayOverlap=function(b){if(this._oDaysOverlap[b]==undefined){this._oDaysOverlap[b]=0;}this._oDaysOverlap[b]++;};
g.prototype._getDaysOffset=function(b,s){return Math.abs(this._getRawDaysDifference(b,s));};
g.prototype._getDaysDifference=function(b,s){return this._getRawDaysDifference(b,s);};
g.prototype._getRawDaysDifference=function(b,s){var e=86400000;var h=b.getTime();var i=s.getTime();var j=h-i;return Math.round(j/e);};
g.prototype._dayIsAfter=function(b,e){return(this._getDaysDifference(b,e)>0);};
g.prototype._dayIsBefore=function(b,e){return(this._getDaysDifference(b,e)<0);};
g.prototype._createDateInDays=function(b){var e=g._ctorSafeDate(b);var h=new Date(e);return a.createDate(h.getUTCFullYear(),h.getUTCMonth(),h.getUTCDate());};
g.prototype._sizeElementsToParent=function(e){var b=(e!==null&&e.length)?e.length:0;var $,j;var i,w,h;for(i=0;i<b;i++){$=q(e[i]);if($){j=$.parent();w=j.width();h=j.height();$.width(w).height(h);}}};
g.prototype._renderHalfDayCalendarEvent=function(k,h){var e=h[0];var $=q(document.getElementById(k));var t=e.getType();var b=this._typeWithBgImages.indexOf(t)>-1;$.addClass("sapMeOverlapCalendarDayWithHalf");var i=q("<div/>");i.addClass("sapMeOverlapCalendarHalfDay").addClass("sapMeOverlapCalendarType"+t+"HalfDayStart");$.append(i);var j=null;if(h.length>1){var l=h[1];var m=l.getType();j=q("<div/>");j.addClass("sapMeOverlapCalendarHalfDay").addClass("sapMeOverlapCalendarType"+m+"HalfDayEnd");}else if(b){j=q("<div/>");j.addClass("sapMeOverlapCalendarHalfDay").addClass("sapMeOverlapCalendarTypeHalfDayEnd");}if(j!==null){$.append(j);}this._sizeElementsToParent([i,j]);};
g.prototype._defineFirstAndLastDates=function(s,e){if(this._lastDate==undefined){this._lastDate=e;}if(this._dayIsAfter(e,this._lastDate)){this._lastDate=e;}if(this._firstDate==undefined){this._firstDate=s;}if(this._dayIsBefore(s,this._firstDate)){this._firstDate=s;}};
g.prototype._renderCalendarEvent=function(i,o){var s=this._createDateInDays(o.getStartDay());var e=this._createDateInDays(o.getEndDay());this._defineFirstAndLastDates(s,e);var b=this._getFirstDateDisplayed();var l=this._getLastDateDisplayed();if((!this._dayIsBefore(e,b))&&(!this._dayIsAfter(s,l))){var r=o.getRow();var h=this._dayIsAfter(s,b)?s:b;e=this._dayIsAfter(e,l)?l:e;var n=this._getDaysOffset(h,e)+1;var j=this._getDaysOffset(b,h);var k="sapMeOverlapCalendarType"+o.getType();var $;var m;if(o.getHalfDay()===true){m=this._getDayId(h);var p=this._provideId(r,m);if(this._mHalfDays[p]==undefined){this._mHalfDays[p]=[];$=q(document.getElementById(p));}this._mHalfDays[p].push(o);}else{while(!this._dayIsAfter(h,e)){m=this._getDayId(h);this._addToDayOverlap(m);$=q(document.getElementById(this._provideId(r,m)));$.addClass(k);h.setDate(h.getDate()+1);}}if($!=undefined){this._createEventLabel(o,h,n,j);}}};
g.prototype._createEventLabel=function(o,b,n,e){var t=o.getTypeName();if(t&&t.length>0){var r=o.getRow();var l=this._provideId(r,this._getDayId(b));var h=this._provideId("row",r,"lbls");var $=q(document.getElementById(h));$.width(q(document.getElementById(this.getId())).width());var i=this._provideId("lbl",l);if(q(document.getElementById(i)).length===0){var j=q("<label dir='Inherit' id='"+i+"'>"+t+"</label>");$.append(j);j.addClass("sapMeOverlapCalendarTypeLbl sapMLabel");this._modifyLabel(j,n,e);}}};
g.prototype._modifyLabel=function($,n,b){var e=(100/(this.getCalendar().getWeeksPerRow()*7));var w=(n*e);$.width(w+"%");var o=(b*e);var m=(b==0)?1:0.5;var l=o+"%";if(this._bRtl){$.css("right",l);$.css("padding-right",m+"rem");$.css("text-align","right");}else{$.css("left",l);$.css("padding-left",m+"rem");}};
g.prototype._parseCalendarEvent=function(i,o){var r=o.getRow();if(r!=-1){if(o.getName()!=undefined){if(this._aRows[r]==undefined&&o.getName()!=""){this._aRows[r]=o.getName();}}else{f.debug("Calendar event has no name");}}else{f.debug("Invalid calendar event row");}};
g.prototype._getLabelForRow=function(i){return this._getLabel(this._aRows[i],"nameLabels").addStyleClass("sapMeOverlapCalendarNameLbl");};
g.prototype._getLabel=function(t,A){var l=new L({text:t});this.addAggregation(A,l,true);return l;};
return g;},true);
sap.ui.predefine('sap/me/OverlapCalendarEvent',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var O=E.extend("sap.me.OverlapCalendarEvent",{metadata:{library:"sap.me",properties:{startDay:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},endDay:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},relevant:{type:"boolean",group:"Misc",defaultValue:null,bindable:"bindable"},type:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},typeName:{type:"string",group:"Appearance",defaultValue:null,bindable:"bindable"},halfDay:{type:"boolean",group:"Data",defaultValue:false,bindable:"bindable"},row:{type:"int",group:"Data",defaultValue:-1,bindable:"bindable"},name:{type:"string",group:"Misc",defaultValue:null,bindable:"bindable"}}}});
return O;});
sap.ui.predefine('sap/me/OverlapCalendarRenderer',[],function(){"use strict";var O={};
O.render=function(r,c){if(c.getVisible()==false){return;}r.write("<div");r.writeControlData(c);r.addClass("sapMeOverlapCalendar");r.writeClasses();var w=c.getWidth();if(w!=undefined){r.addStyle("width",w);r.writeStyles();}r.write(">");r.write("<div");r.addClass("sapMeOverlapCalendarCalendar");r.writeClasses();r.write(">");r.renderControl(c.getCalendar());r.write("</div>");r.write("<div");r.addClass("sapMeOverlapCalendarOverlapIndicator");r.writeClasses();r.write(">");var W=7;var a=c.getCalendar().getWeeksPerRow();var d=a*W;var b=new Date(c.getStartDate());var D=(100/d);for(var i=0;i<d;i++){r.write("<div");r.writeAttribute("id",c._provideId("overlap",i));r.addClass("sapMeOverlapCalendarOverlap");r.writeClasses();r.addStyle("width",D+"%");r.writeStyles();r.write("></div>");b.setDate(b.getDate()+1);}r.write("</div>");this._renderGrid(r,c);r.write("</div>");};
O._renderGrid=function(r,c){var w=7;var W=c.getCalendar().getWeeksPerRow();var d=W*w;var a=c._aRows;if(a){var n=a.length;r.write('<div');r.addClass("sapMeOverlapCalendarGrid");r.writeClasses();r.addStyle("width","100%");r.writeStyles();r.write(">");for(var i=0;i<n;i++){if(a[i]!=undefined){this._renderRow(r,c,d,i,new Date(c.getStartDate()));}}r.write('</div>');}};
O._renderRow=function(r,c,d,a,b){var D=(100/d);var e=c.getCalendar().getDayHeight();r.write('<div');r.writeAttribute("id",c._provideId("row",a));r.addClass("sapMeOverlapCalendarRow");r.writeClasses();r.addStyle("height",e+"px");r.writeStyles();r.write(">");r.write('<div');r.writeAttribute("id",c._provideId("row",a,"lbls"));r.addClass("sapMeOverlapCalendarRowLabels");r.writeClasses();r.write(">");r.renderControl(c._getLabelForRow(a));r.write('</div>');for(var i=0;i<d;i++){this._renderDay(r,c,D,e,a,i);b.setDate(b.getDate()+1);}r.write('</div>');};
O._renderDay=function(r,c,d,D,R,i){r.write("<div");r.writeAttribute("id",c._provideId(R,i));r.addClass("sapMeOverlapCalendarDay");r.writeClasses();r.addStyle("width",d+"%");if(D){r.addStyle("height",D+"px");}r.writeStyles();r.write("></div>");};
return O;},true);
sap.ui.predefine('sap/me/ProgressIndicator',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','sap/ui/core/library','./ProgressIndicatorRenderer'],function(q,l,C,c,P){"use strict";var B=c.BarColor;
var a=C.extend("sap.me.ProgressIndicator",{metadata:{deprecated:true,library:"sap.me",properties:{visible:{type:"boolean",group:"Behavior",defaultValue:true},enabled:{type:"boolean",group:"Behavior",defaultValue:true},barColor:{type:"sap.ui.core.BarColor",group:"Appearance",defaultValue:B.NEUTRAL},displayValue:{type:"string",group:"Appearance",defaultValue:'0%'},percentValue:{type:"int",group:"Data",defaultValue:0},showValue:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'}}}});
a.prototype.setEndBar=function(){var w=this.getPercentValue();var b;var t;this.oBar=this.getDomRef("bar");this.oEnd=this.getDomRef("end");this.oBox=this.getDomRef("box");q(this.oEnd).removeClass('sapUIMeProgIndEndHidden');q(this.oEnd).addClass('sapUIMeProgIndEnd');if(w>100){b=(10000/w)+'%';}else{b='100%';}if(w>100){t=(w-100)*20;}else{t=(100-w)*20;}q(this.oBox).animate({width:b},0,'linear');q(this.oEnd).animate({left:b},t,'linear');q(this.oBar).animate({width:w+'%'},t,'linear');if(!this.oThis){this.oThis=this.$();}};
a.prototype.setEndBarGoesBack=function(p){var w=this.getPercentValue();var b;var t;this.oBar=this.getDomRef("bar");this.oEnd=this.getDomRef("end");this.oBox=this.getDomRef("box");if(p>100){b=(10000/p)+'%';}else{b='100%';}q(this.oEnd).removeClass('sapUIMeProgIndEnd');q(this.oEnd).addClass('sapUIMeProgIndEndHidden');if(w>100){t=(w-100)*20;}else{t=(100-w)*20;}q(this.oBox).animate({width:b},0,'linear');q(this.oEnd).animate({left:b},t,'linear');q(this.oBar).animate({width:w+'%'},t,'linear');if(!this.oThis){this.oThis=this.$();}};
a.prototype.setPercentValue=function(p){var w=this.getPercentValue();var b;this.oBar=this.getDomRef("bar");this.oEnd=this.getDomRef("end");this.oBox=this.getDomRef("box");var t=this;var d;if(p<0){p=0;}if(p>100){b=(10000/p)+'%';}else{b='100%';}if(!this.oBar){d=p*20;this.setProperty('percentValue',p,true);q(this.oBar).animate({width:p+'%'},d,'linear');return this;}if(p>100&&w<=100){d=(100-w)*20;this.setProperty('percentValue',p,true);q(this.oBar).animate({width:'100%'},d,'linear',function(){t.setEndBar();});}else if(p<=100&&w>100){d=(w-100)*20;this.setProperty('percentValue',p,true);q(this.oBar).animate({width:'100%'},d,'linear',function(){t.setEndBarGoesBack();});}else if(p>100&&w>100){if(p>w){d=(p-w)*20;}else{d=(w-p)*20;}b=(10000/p)+'%';this.setProperty('percentValue',p,true);q(this.oBox).animate({width:b},0,'linear');q(this.oEnd).animate({left:b},d,'linear');q(this.oBar).animate({width:p+'%'},d,'linear',function(){});if(!this.oThis){this.oThis=this.$();}}else{if(p>w){d=(p-w)*20;}else{d=(w-p)*20;}this.setProperty('percentValue',p,true);q(this.oBar).animate({width:p+'%'},d,'linear');if(!this.oThis){this.oThis=this.$();}}return this;};
a.prototype.onselectstart=function(){return false;};
return a;});
sap.ui.predefine('sap/me/ProgressIndicatorRenderer',['sap/base/util/Version','sap/base/Log','sap/base/security/encodeXML'],function(V,L,e){"use strict";var P={};
P.render=function(r,p){var u=new V(sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMeProgressIndicator"));if(u.compareTo("1.16")>=0){L.error("The sap.me.ProgressIndicator control is not supported as of SAPUI5 version 1.16. Please us sap.m.ProgressIndicator instead.");return;}var w=p.getWidth();var a=p.getPercentValue();var b;if(!p.getVisible()){return;}if(a>100){b=(10000/a)+'%';}else{b='100%';}r.write('<DIV');r.writeControlData(p);r.writeAttribute('tabIndex','0');if(p.getWidth()&&p.getWidth()!=''){r.writeAttribute('style','width:'+w+';');}if(p.getTooltip_AsString()){r.writeAttributeEscaped('title',p.getDisplayValue()+'- '+p.getTooltip_AsString());}else{r.writeAttributeEscaped('title',p.getDisplayValue());}r.addClass('sapUIMeProgInd');r.writeClasses();r.write('>');r.write('<DIV');r.writeAttribute('id',p.getId()+'-box');if(p.getWidth()&&p.getWidth()!=''){r.writeAttribute('style','width:'+b+';');}r.addClass('sapUIMeProgIndBorder');r.writeClasses();r.write('>');r.write('<DIV');r.writeAttribute('id',p.getId()+'-bar');r.writeAttribute('style','width:'+p.getPercentValue()+'%;');var B=p.getBarColor();r.addClass("sapUIMeProgIndBar");if(B!=""){r.addClass("sapUIMeProgIndBar"+e(B));}r.writeClasses();r.write('>');r.write('<DIV');r.writeAttribute('id',p.getId()+'-end');if(a>100){r.addClass('sapUIMeProgIndEnd');}else{r.addClass('sapUIMeProgIndEndHidden');}r.writeClasses();r.writeAttribute('style','position: relative; left:'+b);r.write('>');r.write('</DIV>');r.write('<SPAN');r.addClass('sapUIMeProgIndFont');r.writeClasses();r.write('>');if(p.getShowValue()&&p.getShowValue()==true){if(p.getDisplayValue()&&p.getDisplayValue()!=''){r.writeEscaped(p.getDisplayValue());}}r.write('</SPAN>');r.write('</DIV>');r.write('</DIV>');r.write('</DIV>');};
return P;},true);
sap.ui.predefine('sap/me/TabContainer',['sap/ui/thirdparty/jquery','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/theming/Parameters','sap/m/ScrollContainer','sap/ui/core/Icon','sap/m/Label','./TabContainerRenderer'],function(q,l,C,I,P,S,a,L,T){"use strict";
var b=C.extend("sap.me.TabContainer",{metadata:{deprecated:true,library:"sap.me",properties:{selectedTab:{type:"int",group:"Data",defaultValue:null},badgeInfo:{type:"int",group:"Data",defaultValue:null},badgeNotes:{type:"int",group:"Data",defaultValue:null},badgeAttachments:{type:"int",group:"Data",defaultValue:null},badgePeople:{type:"int",group:"Data",defaultValue:null},expandable:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:true},visible:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{tabs:{type:"sap.ui.core.Icon",multiple:true,singularName:"tab",visibility:"hidden"},contentInfo:{type:"sap.ui.core.Control",multiple:false},contentAttachments:{type:"sap.ui.core.Control",multiple:false},contentNotes:{type:"sap.ui.core.Control",multiple:false},contentPeople:{type:"sap.ui.core.Control",multiple:false},badges:{type:"sap.ui.core.Control",multiple:true,singularName:"badge",visibility:"hidden"}},events:{select:{allowPreventDefault:true},expand:{},collapse:{}}}});
b.prototype.init=function(){this.addAggregation("tabs",this._createButton("Info"));this.addAggregation("tabs",this._createButton("Notes"));this.addAggregation("tabs",this._createButton("Attachments"));this.addAggregation("tabs",this._createButton("People"));I.insertFontFaceStyle();this._bFirstRendering=true;};
b.prototype.setBadgeInfo=function(v){this._setBadgeLabelByName("badgeInfo",v);return this;};
b.prototype.setBadgeAttachments=function(v){this._setBadgeLabelByName("badgeAttachments",v);return this;};
b.prototype.setBadgeNotes=function(v){this._setBadgeLabelByName("badgeNotes",v);return this;};
b.prototype.setBadgePeople=function(v){this._setBadgeLabelByName("badgePeople",v);return this;};
b.prototype.onBeforeRendering=function(){if(this.getSelectedTab()==undefined){this.setProperty("selectedTab",0,true);}};
b.prototype._setBadgeLabelByName=function(n,v){var c=sap.ui.getCore().byId(this.getId()+"-"+n);c.setText(v);this.setProperty(n,v);c.toggleStyleClass("sapUIMeTabContainerHiddenBadges",(v==0));};
b.prototype._placeElements=function(){var $=this.$("arrow");var B=this.getAggregation("tabs")[this.getSelectedTab()];if(B&&(B.$().outerWidth()>8)){var i=parseFloat(B.$()[0].offsetLeft)+parseFloat(B.$().outerWidth()/2)-parseFloat($.width()/2);$.css("left",i+"px");}};
b.prototype.onAfterRendering=function(){this.setProperty("expanded",true,true);if(this._bFirstRendering){this._bFirstRendering=false;setTimeout(q.proxy(this._placeElements,this),300);}else{this._placeElements();}};
b.prototype.onThemeChanged=function(){this._placeElements();};
b.prototype.onTransitionEnded=function(){var $=this.$("container");if(this.getExpanded()){this.$("arrow").show();$.css("display","block");this.$().find(".sapUIMeTabContainerContent").removeClass("sapUIMeTabContainerContentClosed");}else{$.css("display","none");this.$().find(".sapUIMeTabContainerContent").addClass("sapUIMeTabContainerContentClosed");}};
b.prototype.toggleExpandCollapse=function(){var e=!this.getExpanded();var $=this.$("container");var c=this.$("arrow");if(e){this.$().find(".sapUIMeTabContainerButtons").children().filter(":eq("+this.getSelectedTab()+")").addClass("sapUIMeTabContainerTabSelected");$.slideDown('400',q.proxy(this.onTransitionEnded,this));this.fireExpand();}else{c.hide();this.$().find(".sapUIMeTabContainerTabSelected").removeClass("sapUIMeTabContainerTabSelected");$.slideUp('400',q.proxy(this.onTransitionEnded,this));this.fireCollapse();}this.setProperty("expanded",e,true);};
b.prototype.onButtonTap=function(e){var B=e.getSource();var i=this.indexOfAggregation("tabs",B);if(i==this.getSelectedTab()&&this.getExpandable()){this.toggleExpandCollapse();}else{this.setProperty("expanded",true,true);var o=B.getId();var c=this._getContentForBtn(o);if(c){if(this.fireSelect()){this.setSelectedTab(i);}}}};
b.prototype._getContentForBtn=function(B){var i=this.getId()+"-";var c=B.substr(B.indexOf(i)+i.length);return this.getAggregation(c);};
b.prototype._getBagdeForBtn=function(B){var i=this.getId()+"-content";var c=B.substr(B.indexOf(i)+i.length);c.charAt(0).toUpperCase();c="badge"+c;return this.getProperty(c);};
b.prototype._getScrollContainer=function(c){return new S({content:c});};
b.prototype._createButton=function(i){var s=P.get("sapMeTabIcon"+i);var u=I.getIconURI(s);var c=P.get("sapMeTabColor"+i);var B=new a(this.getId()+'-content'+i,{src:u,backgroundColor:c,activeColor:P.get("sapUiIconInverted")});B.addStyleClass("sapUIMeTabContainerBtn");B.addStyleClass("sapUIMeTabContainerBtn"+i);B.attachPress(this.onButtonTap,this);var o=new L(this.getId()+'-badge'+i,{textAlign:"Center"});o.addStyleClass("sapUIMeTabContainerBadge");o.addStyleClass("sapUIMeTabContainerBadge"+i);this.addAggregation("badges",o);return B;};
return b;});
sap.ui.predefine('sap/me/TabContainerRenderer',['sap/base/util/Version','sap/base/Log'],function(V,L){"use strict";var T={};
T.render=function(r,c){var u=new V(sap.ui.getCore().getConfiguration().getCompatibilityVersion("sapMeTabContainer"));if(u.compareTo("1.16")>=0){L.error("The sap.me.TabContainer control is not supported as of SAPUI5 version 1.16. Please us sap.m.IconTabBar instead.");return;}if(!c.getVisible()){return;}r.write("<div");r.writeControlData(c);r.addClass("sapUIMeTabContainer");r.writeClasses();r.writeStyles();r.write(">");r.write("<div ");r.addClass("sapUIMeTabContainerButtons");r.writeClasses();r.write(">");var b=c.getAggregation("tabs");var I=c.getSelectedTab();var a=c.getAggregation("badges");if(b){if(Array.isArray(b)){for(var i=0;i<b.length;i++){if(c._getContentForBtn(b[i].getId())){r.write("<div ");r.addClass("sapUIMeTabContainerTab");if(i===I){r.addClass("sapUIMeTabContainerTabSelected");}r.writeClasses();r.write(">");if(a&&a[i].getText()!=""){r.renderControl(a[i]);}r.renderControl(b[i]);r.write("</div>");}}}else if(b){r.write("<div ");r.addClass("sapUIMeTabContainerTab");r.writeClasses();r.write(">");if(a&&a[0].getText()!=""){r.renderControl(a[0]);}r.renderControl(b);r.write("</div>");}}r.write("</div>");var C=c._getContentForBtn(b[I].getId());if(C!=undefined){r.write("<div ");r.addClass("sapUIMeTabContainerContent");r.writeClasses();r.write(">");r.write("<div id='"+c.getId()+"-arrow'");r.addClass("sapUIMeTabContainerContentArrow");r.writeClasses();r.write(">");r.write("</div>");r.write("<div id='"+c.getId()+"-container'");r.write(" style='height:auto'");r.addClass("sapUIMeTabContainerTabContent");r.writeClasses();r.write(">");r.renderControl(C);r.write("</div>");r.write("</div>");}r.write("</div>");};
return T;},true);
sap.ui.predefine('sap/me/library',['sap/ui/core/Core','sap/ui/core/library'],function(C){"use strict";sap.ui.getCore().initLibrary({name:"sap.me",version:"1.71.34",dependencies:["sap.ui.core"],types:["sap.me.CalendarDesign","sap.me.CalendarEventType","sap.me.CalendarSelectionMode"],interfaces:[],controls:["sap.me.Calendar","sap.me.CalendarLegend","sap.me.OverlapCalendar","sap.me.ProgressIndicator","sap.me.TabContainer"],elements:["sap.me.OverlapCalendarEvent"]});sap.me.CalendarDesign={Action:"Action",Approval:"Approval"};sap.me.CalendarEventType={Type00:"Type00",Type01:"Type01",Type04:"Type04",Type06:"Type06",Type07:"Type07",Type10:"Type10"};sap.me.CalendarSelectionMode={SINGLE:"SINGLE",MULTIPLE:"MULTIPLE",RANGE:"RANGE"};return sap.me;},true);
sap.ui.require.preload({
	"sap/me/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.me","type":"library","embeds":[],"applicationVersion":{"version":"1.71.34"},"title":"SAPUI5 library with controls specialized for mobile devices (extension).","description":"SAPUI5 library with controls specialized for mobile devices (extension).","ach":"MOB-UIA-LIB-CC","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_belize","sap_belize_hcb","sap_belize_hcw","sap_belize_plus","sap_bluecrystal","sap_fiori_3","sap_fiori_3_dark","sap_fiori_3_hcb","sap_fiori_3_hcw","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.34"}}},"library":{"i18n":false,"content":{"controls":["sap.me.Calendar","sap.me.CalendarLegend","sap.me.OverlapCalendar","sap.me.ProgressIndicator","sap.me.TabContainer"],"elements":["sap.me.OverlapCalendarEvent"],"types":["sap.me.CalendarDesign","sap.me.CalendarEventType","sap.me.CalendarSelectionMode"],"interfaces":[]}}}}'
},"sap/me/library-preload"
);
//# sourceMappingURL=library-preload.js.map