/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(['./library','./util/DateUtils','sap/ui/core/Control','sap/suite/ui/commons/DateRangeSliderInternal',"sap/base/Log","./DateRangeSliderRenderer"],function(l,D,C,a,L,b){"use strict";var c=C.extend("sap.suite.ui.commons.DateRangeSlider",{metadata:{deprecated:true,library:"sap.suite.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},enabled:{type:"boolean",group:"Appearance",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},visible:{type:"boolean",group:"Misc",defaultValue:true},showBubbles:{type:"boolean",group:"Misc",defaultValue:true},smallStepWidth:{type:"float",group:"Appearance",defaultValue:null},totalUnits:{type:"int",group:"Appearance",defaultValue:null},stepLabels:{type:"boolean",group:"Misc",defaultValue:false},labels:{type:"string[]",group:"Misc",defaultValue:null},min:{type:"object",group:"Behavior",defaultValue:null},max:{type:"object",group:"Behavior",defaultValue:null},value:{type:"object",group:"Behavior",defaultValue:null},value2:{type:"object",group:"Behavior",defaultValue:null},pinGrip:{type:"boolean",group:"Misc",defaultValue:false},pinGrip2:{type:"boolean",group:"Misc",defaultValue:false}},events:{change:{},liveChange:{}}}});var d="d";var M="m";c.prototype.init=function(){this._oDateRangeSliderInternal=new a({id:this.getId()+"-dateRangeSliderInternal"});c.setPropertiesBasedOnSliderInternal(this);this._oDateRangeSliderInternal.attachChange(function(e){this.handleChange(e);},this);this._oDateRangeSliderInternal.attachLiveChange(function(e){this.handleLiveChange(e);},this);};c.areDaysSameBasedOnGranularity=function(f,s,g){var S;switch(g){case(d):S=D.dateDaysEqual(f,s);break;case(M):S=D.dateMonthsEqual(f,s);break;default:S=false;}return S;};c.isMinBeforeMax=function(m,e,g){var f=false;if(m.getFullYear()<e.getFullYear()){f=true;}else if(m.getFullYear()===e.getFullYear()){if(m.getMonth()<e.getMonth()){f=true;}else if(m.getMonth()===e.getMonth()&&g===d){if(m.getDate()<e.getDate()){f=true;}}}if(!f){L.error("DateRangeSlider: Min Date = "+m+" should be before Max Date = "+e);}return f;};c.isValueEqualOrAfterMin=function(m,v,g){var V=false;if(m.getFullYear()<v.getFullYear()){V=true;}else if(m.getFullYear()===v.getFullYear()){if(m.getMonth()<v.getMonth()){V=true;}else if(m.getMonth()===v.getMonth()&&g===M){V=true;}else if(m.getMonth()===v.getMonth()&&g===d){if(m.getDate()<=v.getDate()){V=true;}}}if(!V){L.error("DateRangeSlider: Value Date = "+v+" should be after or equal to Min Date = "+m);}return V;};c.isValue2EqualOrBeforeMax=function(v,m,g){var V=false;if(v.getFullYear()<m.getFullYear()){V=true;}else if(v.getFullYear()===m.getFullYear()){if(v.getMonth()<m.getMonth()){V=true;}else if(v.getMonth()===m.getMonth()&&g===M){V=true;}else if(v.getMonth()===m.getMonth()&&g===d){if(v.getDate()<=m.getDate()){V=true;}}}if(!V){L.error("DateRangeSlider: Value2 Date = "+v+" should be before or equal to Max Date = "+m);}return V;};c.isValueBeforeOrEqualValue2=function(v,V,g){var e=false;if(v.getFullYear()<V.getFullYear()){e=true;}else if(v.getFullYear()===V.getFullYear()){if(v.getMonth()<V.getMonth()){e=true;}else if(v.getMonth()===V.getMonth()&&g===M){e=true;}else if(v.getMonth()===V.getMonth()&&g===d){if(v.getDate()<=V.getDate()){e=true;}}}if(!e){L.error("DateRangeSlider: Value Date = "+v+" should be before or equal to Value2 Date = "+V);}return e;};c.prototype.setMin=function(m){if(D.isValidDate(m)&&c.isMinBeforeMax(m,new Date(this.getMax()),this._sGranularity)&&!c.areDaysSameBasedOnGranularity(new Date(this.getMin()),m,this._sGranularity)){D.resetDateToStartOfDay(m);this._oDateRangeSliderInternal.setMinDate(m);c.setPropertiesBasedOnSliderInternal(this);}return this;};c.prototype.setMax=function(m){if(D.isValidDate(m)&&c.isMinBeforeMax(new Date(this.getMin()),m,this._sGranularity)&&!c.areDaysSameBasedOnGranularity(new Date(this.getMax()),m,this._sGranularity)){D.resetDateToEndOfDay(m);this._oDateRangeSliderInternal.setMaxDate(m);c.setPropertiesBasedOnSliderInternal(this);}return this;};c.prototype.setValue=function(v){if(D.isValidDate(v)&&c.isValueBeforeOrEqualValue2(v,new Date(this.getValue2()),this._sGranularity)&&c.isValueEqualOrAfterMin(new Date(this.getMin()),v,this._sGranularity)&&!c.areDaysSameBasedOnGranularity(new Date(this.getValue()),v,this._sGranularity)){D.resetDateToStartOfDay(v);this._oDateRangeSliderInternal.setValueDate(v);c.setPropertiesBasedOnSliderInternal(this);}return this;};c.prototype.getValue=function(){var v=this._oDateRangeSliderInternal.getValueDate();return v;};c.prototype.setValue2=function(v){if(D.isValidDate(v)&&c.isValueBeforeOrEqualValue2(new Date(this.getValue()),v,this._sGranularity)&&!c.areDaysSameBasedOnGranularity(new Date(this.getValue2()),v,this._sGranularity)&&c.isValue2EqualOrBeforeMax(v,new Date(this.getMax()),this._sGranularity)){D.resetDateToStartOfDay(v);this._oDateRangeSliderInternal.setValue2Date(v);c.setPropertiesBasedOnSliderInternal(this);}return this;};c.prototype.getValue2=function(){var v=this._oDateRangeSliderInternal.getValue2Date();return v;};c.prototype.setVisible=function(v){this._oDateRangeSliderInternal.setVisible(v);this.setProperty("visible",v);return this;};c.prototype.setEnabled=function(e){this._oDateRangeSliderInternal.setEnabled(e);this.setProperty("enabled",e);return this;};c.prototype.setLabels=function(e){this._oDateRangeSliderInternal.setLabels(e);this.setProperty("labels",e);return this;};c.prototype.setStepLabels=function(s){this._oDateRangeSliderInternal.setStepLabels(s);this.setProperty("stepLabels",s);return this;};c.prototype.setEditable=function(e){this._oDateRangeSliderInternal.setEditable(e);this.setProperty("editable",e);return this;};c.prototype.setWidth=function(t){this._oDateRangeSliderInternal.setWidth(t);this.setProperty("width",t);return this;};c.prototype.setShowBubbles=function(s){this._oDateRangeSliderInternal.setShowBubbles(s);this.setProperty("showBubbles",s);return this;};c.prototype.setSmallStepWidth=function(s){this._oDateRangeSliderInternal.setSmallStepWidth(s);this.setProperty("smallStepWidth",s);return this;};c.prototype.setTotalUnits=function(t){this._oDateRangeSliderInternal.setTotalUnits(t);this.setProperty("totalUnits",t);return this;};c.setPropertiesBasedOnSliderInternal=function(o){o.setProperty("min",o._oDateRangeSliderInternal.getMinDate());o.setProperty("max",o._oDateRangeSliderInternal.getMaxDate());o.setProperty("value",o._oDateRangeSliderInternal.getValueDate());o.setProperty("value2",o._oDateRangeSliderInternal.getValue2Date());o._sGranularity=o._oDateRangeSliderInternal._sGranularity;return this;};c.prototype.setDayGranularity=function(){this._oDateRangeSliderInternal.setDayGranularity();if(this._oDateRangeSliderInternal.isActive()){this._oDateRangeSliderInternal.rerender();}c.setPropertiesBasedOnSliderInternal(this);return this;};c.prototype.setMonthGranularity=function(){var m=D.numberOfMonthsApart(this.getMin(),this.getMax());if(m>=1){this._oDateRangeSliderInternal.setMonthGranularity();if(this._oDateRangeSliderInternal.isActive()){this._oDateRangeSliderInternal.rerender();}c.setPropertiesBasedOnSliderInternal(this);}else{L.error("DateRangeSlider.setMonthGranularity(): Max Date should be 1 month after Min Date.");}return this;};c.prototype.setDateFormat=function(o){this._oDateRangeSliderInternal.setDateFormat(o);if(this._oDateRangeSliderInternal.isActive()){this._oDateRangeSliderInternal.rerender();}return this;};c.prototype.setPinGrip=function(p){this._oDateRangeSliderInternal.setPinGrip(p);this.setProperty("pinGrip",p);return this;};c.prototype.setPinGrip2=function(p){this._oDateRangeSliderInternal.setPinGrip2(p);this.setProperty("pinGrip2",p);return this;};c.prototype.exit=function(){this._oDateRangeSliderInternal.destroy();this._oDateRangeSliderInternal=null;};c.prototype.handleChange=function(e){var v=e.getParameter("value");var V=e.getParameter("value2");this.fireChange({value:v,value2:V});};c.prototype.handleLiveChange=function(e){var v=e.getParameter("value");var V=e.getParameter("value2");this.fireLiveChange({value:v,value2:V});};return c;});
