sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/suite/ui/commons/library","sap/ui/core/library","sap/m/library","sap/base/Log","sap/ui/Device","sap/m/MessageToast","sap/ui/core/Icon","./ResizeHistoryItem","./RotateHistoryItem","./CropRectangleHistoryItem","./CropEllipseHistoryItem","./CropCustomShapeHistoryItem","./FilterHistoryItem","./FlipHistoryItem","./FilterUtils","sap/ui/core/util/File","sap/suite/ui/commons/Utils","./ImageEditorRenderer","sap/ui/thirdparty/jqueryui/jquery-ui-draggable","sap/ui/thirdparty/jqueryui/jquery-ui-resizable"],function(q,C,l,a,M,L,D,b,I,R,c,d,e,f,F,g,h,j,S){"use strict";var k=l.ImageEditorMode,m=l.ImageFormat,r=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.commons");var n=C.extend("sap.suite.ui.commons.imageeditor.ImageEditor",{metadata:{library:"sap.suite.ui.commons",properties:{src:{type:"any",defaultValue:""},customShapeSrc:{type:"any",defaultValue:""},mode:{type:"sap.suite.ui.commons.ImageEditorMode",defaultValue:k.Default},keepCropAspectRatio:{type:"boolean",defaultValue:true},keepResizeAspectRatio:{type:"boolean",defaultValue:true},scaleCropArea:{type:"boolean",defaultValue:false}},events:{loaded:{},error:{},customShapeLoaded:{},customShapeError:{},sizeChanged:{parameters:{width:{type:"int"},height:{type:"int"},originalWidth:{type:"int"},originalHeight:{type:"int"}}},cropAreaChanged:{parameters:{cropArea:{type:"object"},originalCropArea:{type:"object"}}},zoomChanged:{parameters:{zoom:{type:"int"}}},historyChanged:{history:{type:"sap.suite.ui.commons.imageeditor.HistoryItem[]"},index:{type:"int"}}}}});n.LIMITS=Object.freeze({WIDTH_MIN:1,WIDTH_MAX:8192,HEIGHT_MIN:1,HEIGHT_MAX:8192,MAX_CANVAS_SIZE:67108864,MAX_SAFARI_MOBILE_CANVAS_SIZE:16777216,ROTATION_MIN:-360,ROTATION_MAX:360,SEPIA_MIN:0,SEPIA_MAX:100,GRAYSCALE_MIN:0,GRAYSCALE_MAX:100,SATURATE_MIN:0,SATURATE_MAX:500,INVERT_MIN:0,INVERT_MAX:100,BRIGHTNESS_MIN:0,BRIGHTNESS_MAX:500,CONTRAST_MIN:0,CONTRAST_MAX:500,CROP_AREA_MIN:1});n.ZOOM_MILESTONES=[5,10,25,33,50,67,75,80,90,100,110,125,150,175,200,250,300,400,500];var o=Object.freeze({CROP_AREA_SHORTER_SIDE_OFFSET:0.8,DEFAULT_ZOOM_MILESTONE:100});n.prototype.init=function(){this._oCanvas=document.createElement("canvas");this._initCanvas();this._initOrigImg();this._initCustomShapeImg();this._fZoom=o.DEFAULT_ZOOM_MILESTONE;this._oSavedImg=document.createElement("canvas");this._oSavedImg.width=0;this._oSavedImg.height=0;};n.prototype._initOrigImg=function(){var t=this;this._oOrigImg=new Image();this._oOrigImg.crossOrigin="Anonymous";this._oOrigImg.onload=function(){t._bImageLoaded=true;t._drawImage(t._oOrigImg);t._storeCurrentImg();t._applyExifOrientation();if(t._isReady()){t._onAfterIsReady();}if(t.getCustomShapeLoaded()&&!D.browser.msie){t._renderCustomShapeMask();}t.fireLoaded();};this._oOrigImg.onerror=function(E){t.fireError();};};n.prototype._initCustomShapeImg=function(){var t=this;this._oCustomShapeImg=new Image();this._oCustomShapeImg.crossOrigin="Anonymous";this._oCustomShapeImg.onload=function(){t._bCustomShapeLoaded=true;t.$().addClass("sapSuiteUiCommonsImageEditorModeCropCustomShapeLoaded");t._renderCustomShapeMask();t.fireCustomShapeLoaded();};this._oCustomShapeImg.onerror=function(){t.fireCustomShapeError();};};n.prototype._getExifOrientation=function(p){var s=new FileReader(),O,t,v,u,w,x,T,i,V,E,o={FIRST_CHECK:65496,SECOND_CHECK:9,THIRD_CHECK:65505,CORRECT_FORMAT_CHECK:1165519206,LITTLE_CHECK:18761,FOURTH_CHECK:65280,EXIF_CHECK:274,ERR_GENERAL:-1,ERR_FILE_FORMAT:-2,OFFSET_STEP:2,OFFSET_STEP_MED:4,OFFSET_STEP_BIG:6};return new Promise(function(y){s.onload=function(z){t=z.target.result;v=new DataView(t);u=v.byteLength;O=2;E=0;try{V=v.getUint16(0,false);if(V!==o.FIRST_CHECK){E=o.ERR_FILE_FORMAT;}while(!E&&O<=u-1){V=v.getUint16(O+o.OFFSET_STEP,false);if(V<o.SECOND_CHECK){E=o.ERR_GENERAL;break;}w=v.getUint16(O,false);O=O+2;if(w===o.THIRD_CHECK){V=v.getUint32(O+=o.OFFSET_STEP,false);if(V!==o.CORRECT_FORMAT_CHECK){E=o.ERR_GENERAL;break;}x=v.getUint16(O+=o.OFFSET_STEP_BIG,false)===o.LITTLE_CHECK;O+=v.getUint32(O+o.OFFSET_STEP_MED,x);T=v.getUint16(O,x);O+=2;for(i=0;i<=T-1;i++){V=v.getUint16(O+(i*12),x);if(V===o.EXIF_CHECK){return y(v.getUint16(O+(i*12)+8,x));}}}else if((w&o.FOURTH_CHECK)!==o.FOURTH_CHECK){E=o.ERR_GENERAL;break;}else{O+=v.getUint16(O,false);}}return y(E);}catch(A){return y(o.ERR_FILE_FORMAT);}};s.readAsArrayBuffer(p);});};n.prototype._handleExifOrientation=function(i){var t=this;this._getExifOrientation(i).then(function(O){switch(O){case 1:t._iExifRotation=0;break;case 2:t._iExifRotation=0;t._bExifFlip=true;break;case 3:t._iExifRotation=180;break;case 4:t._bExifFlip=true;t._iExifRotation=180;break;case 5:t._bExifFlip=true;t._iExifRotation=90;break;case 6:t._iExifRotation=90;break;case 7:t._bExifFlip=true;t._iExifRotation=-90;break;case 8:t._iExifRotation=-90;break;default:t._iExifRotation=0;break;}t._applyExifOrientation();});};n.prototype._applyExifOrientation=function(){if(this.getLoaded()){if(this._iExifRotation){this._setRotation(this._iExifRotation);this._storeCurrentImg();}if(this._bExifFlip){this._flipHorizontal();this._storeCurrentImg();}}};n.prototype._renderCustomShapeMask=function(){var i=document.createElement("canvas"),p=i.getContext("2d"),w,H;this._oCustomShapeImg.width=500;this._oCustomShapeImg.height=this._oCustomShapeImg.naturalHeight*this._oCustomShapeImg.width/this._oCustomShapeImg.naturalWidth;q("body").prepend(this._oCustomShapeImg);w=this._oCustomShapeImg.clientWidth;H=this._oCustomShapeImg.clientHeight;q(this._oCustomShapeImg).remove();if(w>=H){i.width=this._oCanvas.width;i.height=H*(this._oCanvas.width/w);}else{i.height=this._oCanvas.height;i.width=w*(this._oCanvas.height/H);}this._oCustomShapeImg.width=i.width;this._oCustomShapeImg.height=i.height;p.drawImage(this._oCustomShapeImg,0,0,this._oCustomShapeImg.width,this._oCustomShapeImg.height);p.globalCompositeOperation="source-in";p.fillStyle="black";p.fillRect(0,0,i.width,i.height);this._sBlackCustomShapeUrl=i.toDataURL();if(this.$("overlayMaskCustomBlack")[0]){this.$("overlayMaskCustomBlack")[0].setAttributeNS("http://www.w3.org/1999/xlink","href",this._sBlackCustomShapeUrl);}p.fillStyle="white";p.fillRect(0,0,i.width,i.height);this._sWhiteCustomShapeUrl=i.toDataURL();if(this.$("overlayMaskCustomWhite")[0]){this.$("overlayMaskCustomWhite")[0].setAttributeNS("http://www.w3.org/1999/xlink","href",this._sWhiteCustomShapeUrl);}};n.prototype.onAfterRendering=function(){this._$Container=this.$("canvasInnerContainer");this._$Container.prepend(this._oCanvas);this._initContainer();this._initCropArea();if(this._isReady()){this._onAfterIsReady();}};n.prototype.setSrc=function(s){this.setProperty("src",s,true);var t=this,i,u;this._reset();if(typeof s==="string"){i=s;this._oOriginalBlob=this._fetchUrlAsBlob(i).then(function(B){t._handleExifOrientation(B);t._oOriginalBlob=B;t._sOriginalFileType=B.type;});if(!i.startsWith("data:image")){this._sOriginalFileName=this._getFileNameFromUrl(i);}}else if(s instanceof Blob){u=window.URL;i=u.createObjectURL(s);u.revokeObjectURL(s);t._handleExifOrientation(s);this._oOriginalBlob=s;this._sOriginalFileType=s.type;if(s instanceof File){this._sOriginalFileName=s.name;}}if(i){this._oOrigImg.src=i;}else{this.fireLoaded();}return this;};n.prototype.setScaleCropArea=function(s){this.setProperty("scaleCropArea",s,true);return this;};n.prototype.setCustomShapeSrc=function(s){this.setProperty("customShapeSrc",s,true);var t=this,i,u;t._bCustomShapeLoaded=false;if(typeof s==="string"){if((D.browser.msie||D.browser.firefox)&&s.startsWith("data:image/svg+xml;base64,")){this._handleSvgString(atob(s.slice("data:image/svg+xml;base64,".length)));}else{i=s;}}else if(s instanceof Blob){if(s instanceof File&&s.type==="image/svg+xml"){var p=new FileReader();p.onload=function(E){t._handleSvgString(E.target.result);};p.readAsText(s);}else{u=window.URL;i=u.createObjectURL(s);u.revokeObjectURL(s);this._setCustomShapeSrc(i);}}if(i){this._setCustomShapeSrc(i);}else if(!s){this._sBlackCustomShapeUrl="";this._sWhiteCustomShapeUrl="";if(this.$("overlayMaskCustomBlack")[0]){this.$("overlayMaskCustomBlack")[0].setAttributeNS("http://www.w3.org/1999/xlink","href",this._sBlackCustomShapeUrl);}if(this.$("overlayMaskCustomWhite")[0]){this.$("overlayMaskCustomWhite")[0].setAttributeNS("http://www.w3.org/1999/xlink","href",this._sWhiteCustomShapeUrl);}this.$().removeClass("sapSuiteUiCommonsImageEditorModeCropCustomShapeLoaded");this.fireCustomShapeLoaded();}return this;};n.prototype._handleSvgString=function(s){var i,p;if(D.browser.msie){throw Error("SVG files cannot be used as shapes for custom crop in Internet Explorer. Please use a different image source or a different browser.");}var t=new DOMParser().parseFromString(s,"image/svg+xml");if(t.documentElement.width.baseVal.value>0){t.documentElement.width.baseVal.valueAsString=t.documentElement.width.baseVal.value.toString()+"px";}if(t.documentElement.height.baseVal.value>0){t.documentElement.height.baseVal.valueAsString=t.documentElement.height.baseVal.value.toString()+"px";}p=new XMLSerializer().serializeToString(t);i="data:image/svg+xml;base64,"+btoa(p);this._setCustomShapeSrc(i);};n.prototype._setCustomShapeSrc=function(s){this._oCustomShapeImg.src=s;};n.prototype.setKeepCropAspectRatio=function(K){this.setProperty("keepCropAspectRatio",K,true);this._updateResizableCropAspectRatio();return this;};n.prototype.setKeepResizeAspectRatio=function(K){this.setProperty("keepResizeAspectRatio",K,true);this._updateResizableResizeAspectRatio();return this;};n.prototype.getLoaded=function(){return!!this.getSrc()&&this._bImageLoaded;};n.prototype.getCustomShapeLoaded=function(){return!!this.getCustomShapeSrc()&&this._bCustomShapeLoaded;};n.prototype.setSize=function(w,H,p){this._throwIfNotLoaded("setSize");var O,i,s;w=this._constraintValue(w,n.LIMITS.WIDTH_MIN,n.LIMITS.WIDTH_MAX);H=this._constraintValue(H,n.LIMITS.HEIGHT_MIN,n.LIMITS.HEIGHT_MAX);s=this._limitCanvasSize(w,H);w=s.width;H=s.height;this._cancelPreview();O=this.getWidth();i=this.getHeight();this._setCanvasSize(w,H);this._addHistory(new R({width:w,height:H,oldWidth:O,oldHeight:i}),p);return this;};n.prototype.getWidth=function(){this._throwIfNotLoaded("getWidth");return this._getLastImg().width;};n.prototype.getPreviewWidth=function(){this._throwIfNotLoaded("getPreviewWidth");return this._oCanvas.width;};n.prototype.setWidth=function(w,p){this._throwIfNotLoaded("setWidth");var O=this.getHeight(),i=this.getWidth(),H=this.getPreviewHeight(),s;w=this._constraintValue(w,n.LIMITS.WIDTH_MIN,n.LIMITS.WIDTH_MAX);if(this.getKeepResizeAspectRatio()){H=Math.round(w*H/this.getPreviewWidth());}s=this._limitCanvasSize(w,H);w=s.width;H=s.height;this._cancelPreview();this._setCanvasSize(w,H);this._addHistory(new R({width:w,height:H,oldWidth:i,oldHeight:O}),p);return this;};n.prototype.getHeight=function(){this._throwIfNotLoaded("getHeight");return this._getLastImg().height;};n.prototype.getPreviewHeight=function(){this._throwIfNotLoaded("getPreviewHeight");return this._oCanvas.height;};n.prototype.setHeight=function(H,p){this._throwIfNotLoaded("setHeight");var O=this.getWidth(),i=this.getHeight(),w=this.getPreviewWidth(),s;H=this._constraintValue(H,n.LIMITS.HEIGHT_MIN,n.LIMITS.HEIGHT_MAX);if(this.getKeepResizeAspectRatio()){w=Math.round(H*w/this.getPreviewHeight());}s=this._limitCanvasSize(w,H);w=s.width;H=s.height;this._cancelPreview();this._setCanvasSize(w,H);this._addHistory(new R({width:w,height:H,oldWidth:O,oldHeight:i}),p);return this;};n.prototype.rotate=function(i,p){this._throwIfNotLoaded("rotate");i=this._constraintValue(i,n.LIMITS.ROTATION_MIN,n.LIMITS.ROTATION_MAX);this._cancelPreview();this._setRotation(i);this._addHistory(new c({degrees:i}),p);return this;};n.prototype.flipVertical=function(p){this._throwIfNotLoaded("flipVertical");this._cancelPreview();this._flipVertical();this._addHistory(new g({vertical:true,horizontal:false}),p);return this;};n.prototype.flipHorizontal=function(p){this._throwIfNotLoaded("flipHorizontal");this._cancelPreview();this._flipHorizontal();this._addHistory(new g({vertical:false,horizontal:true}),p);return this;};n.prototype.flip=function(v,H,p){this._throwIfNotLoaded("flip");this._cancelPreview();this._flip(v,H);this._addHistory(new g({vertical:v,horizontal:H}),p);return this;};n.prototype.applyVisibleCrop=function(p){this._throwIfNotReady("applyVisibleCrop");switch(this.getMode()){case k.CropRectangle:{this._applyRectangleCrop(p);break;}case k.CropEllipse:{this._applyEllipseCrop(p);break;}case k.CropCustomShape:{this._throwIfCustomShapeNotLoaded("applyVisibleCrop CropCustomShape");this._applyCustomShapeCrop(p);break;}default:{L.warning("No cropping mode is selected, applyVisibleCrop does nothing");break;}}};n.prototype.rectangleCrop=function(x,y,w,H,p){this._throwIfNotLoaded("rectangleCrop");var O=this.getWidth(),i=this.getHeight();this._cancelPreview();this._rectangleCrop(x,y,w,H);this._addHistory(new d({x:Math.round(x),y:Math.round(y),width:Math.round(w),height:Math.round(H),oldWidth:O,oldHeight:i}),p);this._limitCurrentCropArea();};n.prototype.ellipseCrop=function(x,y,X,Y,p){this._throwIfNotLoaded("ellipseCrop");var O=this.getWidth(),i=this.getHeight();this._cancelPreview();this._ellipseCrop(x,y,X,Y);this._addHistory(new e({x:Math.round(x),y:Math.round(y),rx:Math.round(X),ry:Math.round(Y),width:Math.round(X*2),height:Math.round(Y*2),oldWidth:O,oldHeight:i}),p);this._limitCurrentCropArea();};n.prototype.customShapeCrop=function(x,y,w,H,p){this._throwIfNotLoaded("customShapeCrop");this._throwIfCustomShapeNotLoaded("customShapeCrop");var O=this.getWidth(),i=this.getHeight();this._cancelPreview();this._customShapeCrop(x,y,w,H);this._addHistory(new f({x:Math.round(x),y:Math.round(y),width:Math.round(w),height:Math.round(H),oldWidth:O,oldHeight:i}),p);this._limitCurrentCropArea();};n.prototype.setCropArea=function(x,y,w,H){this._throwIfNotLoaded("setCropArea");var i=this._limitCropArea(x,y,w,H);this._setCropArea(i.x,i.y,i.width,i.height);return this;};n.prototype.setCropAreaByRatio=function(w,H){this._throwIfNotLoaded("setCropAreaByRatio");var O=this._oCanvas.width/this._oCanvas.height,i=w/H,W,p,x,y,s;if(typeof w!=="number"||typeof H!=="number"){return this;}if(O>=i){p=o.CROP_AREA_SHORTER_SIDE_OFFSET;W=this._oCanvas.height*p*i;W=100*W/this._oCanvas.width;p*=100;x=(100-W)/2;y=(100-p)/2;}else{W=o.CROP_AREA_SHORTER_SIDE_OFFSET;p=this._oCanvas.width*W/i;p=100*p/this._oCanvas.height;W*=100;y=(100-p)/2;x=(100-W)/2;}s=this._transposePercentToImageCoordsPx(x,y,W,p);this._setCropArea(s.x,s.y,s.width,s.height);return this;};n.prototype.setCustomShapeCropAreaRatio=function(){this._throwIfNotLoaded("setCustomShapeCropAreaRatio");this._throwIfCustomShapeNotLoaded("setCustomShapeCropAreaRatio");this.setCropAreaByRatio(this._oCustomShapeImg.width,this._oCustomShapeImg.height);return this;};n.prototype.setCropAreaBySize=function(w,H){this._throwIfNotLoaded("setCropAreaBySize");var i=this._limitCropArea(null,null,w,H);this._setCropArea(null,null,i.width,i.height);return this;};n.prototype.getCropArea=function(){return this._oCropArea?q.extend({},this._oCropArea):null;};n.prototype.zoom=function(z,p){this._setZoom(z,p);return this;};n.prototype.zoomIn=function(p){this._zoomIn(p);return this;};n.prototype.zoomOut=function(p){this._zoomOut(p);return this;};n.prototype.zoomToFit=function(){this._throwIfNotReady("zoomToFit");this._zoomToFit();return this;};n.prototype.getZoomLevel=function(){return this._fZoom;};n.prototype.sepia=function(v,p){this._throwIfNotLoaded("sepia");this._constraintValue(v,n.LIMITS.SEPIA_MIN,n.LIMITS.SEPIA_MAX);this._cancelPreview();this._addHistory(new F({type:"sepia",value:v,unit:"%"}),p);};n.prototype.grayscale=function(v,p){this._throwIfNotLoaded("grayscale");this._constraintValue(v,n.LIMITS.GRAYSCALE_MIN,n.LIMITS.GRAYSCALE_MAX);this._cancelPreview();this._addHistory(new F({type:"grayscale",value:v,unit:"%"}),p);};n.prototype.saturate=function(v,p){this._throwIfNotLoaded("saturate");this._constraintValue(v,n.LIMITS.SATURATE_MIN,n.LIMITS.SATURATE_MAX);this._cancelPreview();this._addHistory(new F({type:"saturate",value:v,unit:"%"}),p);};n.prototype.invert=function(v,p){this._throwIfNotLoaded("invert");this._constraintValue(v,n.LIMITS.INVERT_MIN,n.LIMITS.INVERT_MAX);this._cancelPreview();this._addHistory(new F({type:"invert",value:v,unit:"%"}),p);};n.prototype.brightness=function(v,p){this._throwIfNotLoaded("brightness");this._constraintValue(v,n.LIMITS.BRIGHTNESS_MIN,n.LIMITS.BRIGHTNESS_MAX);this._cancelPreview();this._addHistory(new F({type:"brightness",value:v,unit:"%"}),p);};n.prototype.contrast=function(v,p){this._throwIfNotLoaded("contrast");this._constraintValue(v,n.LIMITS.CONTRAST_MIN,n.LIMITS.CONTRAST_MAX);this._cancelPreview();this._addHistory(new F({type:"contrast",value:v,unit:"%"}),p);};n.prototype.applyPreview=function(){this._throwIfNotLoaded("applyPreview");this._applyPreview();};n.prototype.cancelPreview=function(){this._throwIfNotLoaded("cancelPreview");this._cancelPreview();};n.prototype.undo=function(){this._throwIfNotLoaded("undo");this._jumpToHistory(this._iHistoryIndex+1);};n.prototype.redo=function(){this._throwIfNotLoaded("redo");this._jumpToHistory(this._iHistoryIndex-1);};n.prototype.jumpToHistory=function(i){this._throwIfNotLoaded("jumpToHistory");this._jumpToHistory(i);};n.prototype.getHistory=function(){return this._aHistory;};n.prototype.getHistoryIndex=function(){return this._iHistoryIndex;};n.prototype.getImagePngDataURL=function(){this._throwIfNotLoaded("getImagePngDataURL");return this._getFinalisedCanvas().toDataURL("image/png");};n.prototype.getImageJpegDataURL=function(Q){this._throwIfNotLoaded("getImageJpegDataURL");return this._getFinalisedCanvas().toDataURL("image/jpeg",Q);};n.prototype.getImageDataURL=function(s,Q){this._throwIfNotLoaded("getImageDataURL");s=this._convertImageFormatEnumToMime(s)||this._getFileFormat();return this._getFinalisedCanvas().toDataURL(s,Q);};n.prototype.getImageAsBlob=function(s,Q){this._throwIfNotLoaded("getImageAsBlob");var t=this,p;s=this._convertImageFormatEnumToMime(s)||this._getFileFormat();if(this._aHistory.length===0){p=this._getOriginalBlob();}else{p=new Promise(function(i,u){var v=t._getFinalisedCanvas();if(v.toBlob){v.toBlob(function(B){i(B);},s,Q);}else{t._createBlob(v,s,Q).then(function(B){i(B);});}});}return p;};n.prototype.openSaveDialog=function(s,i,Q){this._throwIfNotLoaded("openSaveDialog");var p,E;s=s||this._getFileName();i=this._convertImageFormatEnumToMime(i)||this._getFileFormat();E=i.split("/")[1];if(this._aHistory.length===0){this._getOriginalBlob().then(function(B){j.save(B,s,E,i);});}else{p=this._getFinalisedCanvas();if(p.toBlob){p.toBlob(function(B){j.save(B,s,E,i);},i,Q);}else{this._createBlob(p,i,Q).then(function(B){j.save(B,s,E,i);});}}};n.prototype.getFileName=function(){return this._getFullFileName();};n.prototype._throwIfNotLoaded=function(s){if(!this.getLoaded()){throw Error("Cannot call "+s+" before image is set and loaded");}};n.prototype._throwIfNotReady=function(s){if(!this._isReady()){throw Error("Cannot call "+s+" before image is set and loaded and control is rendered");}};n.prototype._throwIfCustomShapeNotLoaded=function(s){if(!this.getCustomShapeLoaded()){throw Error("Cannot call "+s+" before custom shape is set and loaded");}};n.prototype._onAfterIsReady=function(){var t=this;this.$().removeClass("sapSuiteUiCommonsImageEditorEmpty");t._refreshContainerSize();this._$Container.css({width:this._oCanvas.width*this._getScale(),height:this._oCanvas.height*this._getScale()});if(!this.getCropArea()){this.setCropAreaByRatio(this.getWidth(),this.getHeight());}else{this._setCropArea(this._oCropArea.x,this._oCropArea.y,this._oCropArea.width,this._oCropArea.height);}this.getDomRef().onmousewheel=this._onMouseWheel.bind(this);this.getDomRef().onmousedown=this._onMouseDown.bind(this);};n.prototype._isReady=function(){return!!this._$Container&&this.getLoaded();};n.prototype._createBlob=function(i,t,Q){var p=this;return new Promise(function(s,u){var v=i.toDataURL(t,Q).split(",")[1];setTimeout(function(){s(p._convertDataUriToBlob(v,t));});});};n.prototype._convertDataUriToBlob=function(B,s){var p=atob(B),t=p.length,A=new Uint8Array(t);for(var i=0;i<t;i++){A[i]=p.charCodeAt(i);}return new Blob([A],{type:s});};n.prototype._fetchUrlAsBlob=function(s){var p,i,B,t;if(window.fetch){p=fetch(s).then(function(u){return u.blob();}).then(function(u){return u;});}else{if(s.startsWith("data:image")){i=s.split(",");B=i[1];t=i[0].split(";")[0].split(":")[1];p=Promise.resolve(this._convertDataUriToBlob(B,t));}else{p=new Promise(function(u,v){var x=new XMLHttpRequest();x.open("GET",s);x.responseType="blob";x.onreadystatechange=function(){if(this.readyState===XMLHttpRequest.DONE){if(this.status===200){u(x.response);}else{v();}}};x.send();});}}return p;};n.prototype._getOriginalBlob=function(){var p;if(this._oOriginalBlob instanceof Promise){p=this._oOriginalBlob;}else{p=Promise.resolve(this._oOriginalBlob);}return p;};n.prototype._getFileNameFromUrl=function(u){return u.split("#")[0].split("?")[0].split("/").pop();};n.prototype._getFileName=function(){var s=this._sOriginalFileName||"image",i;i=s.lastIndexOf(".");if(i>0){s=s.slice(0,i);}return s;};n.prototype._getFullFileName=function(){return this._sOriginalFileName;};n.prototype._convertImageFormatEnumToMime=function(s){switch(s){case m.Png:s="image/png";break;case m.Jpeg:s="image/jpeg";break;default:break;}return s;};n.prototype._getFileFormat=function(){return this._sOriginalFileType;};n.prototype._updateTransformation=function(){this._oCanvas.style.transform="scale("+this._getScale()+")";};n.prototype._refreshContainerSize=function(){if(!this._$Container||!this._$Container[0]||!this._isReady()){return;}this._$Container.css({width:this._oCanvas.width*this._getScale(),height:this._oCanvas.height*this._getScale()});this._refreshOverlayMask();};n.prototype._refreshOverlayMask=function(){var O=this.$().find(".sapSuiteUiCommonsImageEditorCropOverlayContainer")[0];if(!O||!this._$Container){return;}this._$Container[0].removeChild(O);this._$Container[0].insertBefore(O,this._oCanvas.nextSibling);};n.prototype._refreshCropContainerSize=function(){var i=this.getCropArea(),p,$;if(i){p=this._transposeImageCoordsPxToPercent(i.x,i.y,i.width,i.height);$=this.$().find(".sapSuiteUiCommonsImageEditorCropInnerRectangle");$.css({left:p.x+"%",top:p.y+"%"});$.width(p.width+"%");$.height(p.height+"%");}};n.prototype._refreshCropContainerLook=function(){function i(P){return P/parseFloat(getComputedStyle(document.documentElement).fontSize);}var $=this.$().find(".sapSuiteUiCommonsImageEditorCropInnerRectangle"),p=i($.width()),s=i($.height()),t=Math.min(p,s);$.removeClass("sapSuiteUiCommonsImageEditorCropInnerRectangleSmall sapSuiteUiCommonsImageEditorCropInnerRectangleVerySmall sapSuiteUiCommonsImageEditorCropInnerRectangleExtraSmall");if(t<1.25){$.addClass("sapSuiteUiCommonsImageEditorCropInnerRectangleExtraSmall");}else if(t<2){$.addClass("sapSuiteUiCommonsImageEditorCropInnerRectangleVerySmall");}else if(t<3){$.addClass("sapSuiteUiCommonsImageEditorCropInnerRectangleSmall");}};n.prototype._initCanvas=function(){this._oCanvas.id=this.getId()+"-image";this._oCanvas.classList.add("sapSuiteUiCommonsImageEditorCanvas");this._oContext=this._oCanvas.getContext("2d");};n.prototype._initContainer=function(){var t=this,H=this.$().find(".sapSuiteUiCommonsImageEditorTransformHandlers .sapSuiteUiCommonsImageEditorHandlerContainer");this._$Container.resizable({containment:"parent",aspectRatio:this.getKeepResizeAspectRatio(),start:function(E,u){t.$("image").addClass("sapSuiteUiCommonsImageEditorCanvasResize");t.$("image").css("transform","");q(this).css({top:u.position.top,left:u.position.left,width:u.size.width,height:u.size.height});},stop:function(E,u){var N=u.size.width*t._oCanvas.width/u.originalSize.width,i=u.size.height*t._oCanvas.height/u.originalSize.height,O=t._oCanvas.width,p=t._oCanvas.height;t.$("image").removeClass("sapSuiteUiCommonsImageEditorCanvasResize");t._$Container.css({top:"",left:""});t.setSize(N,i,true);t._refreshContainerSize();t._updateTransformation();t.fireSizeChanged({width:t.getPreviewWidth(),height:t.getPreviewHeight(),originalWidth:O,originalHeight:p});},handles:{nw:H.filter(".ui-resizable-nw"),ne:H.filter(".ui-resizable-ne"),sw:H.filter(".ui-resizable-sw"),se:H.filter(".ui-resizable-se"),n:H.filter(".ui-resizable-n"),s:H.filter(".ui-resizable-s"),w:H.filter(".ui-resizable-w"),e:H.filter(".ui-resizable-e")}});S._setupMobileDraggable(this._$Container);};n.prototype._initCropArea=function(){var t=this,B=this.$().find(".sapSuiteUiCommonsImageEditorCropInnerRectangle"),H=this.$().find(".sapSuiteUiCommonsImageEditorCropInnerRectangle .sapSuiteUiCommonsImageEditorHandlerContainer"),i=this.$().find(".sapSuiteUiCommonsImageEditorDragHandlerContainer")[0];function p(E,u){var v=getComputedStyle(u.helper[0]);t._setOverlayMaskSize(u.position.left,u.position.top,u.size?u.size.width:parseFloat(v.width),u.size?u.size.height:parseFloat(v.height),"px");t._refreshCropContainerLook();}function s(E,u){var $=q(this),v=this.getBoundingClientRect(),P=$.position(),w=t._transposeViewportCoordsToImageCoords(P.left,P.top,v.width,v.height),O=t.getCropArea(),x;x=t._limitCropArea(w.x,w.y,w.width,w.height);t._setCropArea(x.x,x.y,x.width,x.height);x=t.getCropArea();t.fireCropAreaChanged({cropArea:x,originalCropArea:O});}B.resizable({aspectRatio:this.getKeepCropAspectRatio(),containment:"parent",minWidth:n.LIMITS.CROP_AREA_MIN,minHeight:n.LIMITS.CROP_AREA_MIN,resize:p,stop:s,handles:{nw:H.filter(".ui-resizable-nw"),ne:H.filter(".ui-resizable-ne"),sw:H.filter(".ui-resizable-sw"),se:H.filter(".ui-resizable-se"),n:H.filter(".ui-resizable-n"),s:H.filter(".ui-resizable-s"),w:H.filter(".ui-resizable-w"),e:H.filter(".ui-resizable-e")}});i.onmousewheel=this._onMouseWheel.bind(this);B.draggable({containment:"parent",handle:i,drag:p,stop:s});S._setupMobileDraggable(B);B.css("position","absolute");};n.prototype._getLastImg=function(){return this._oSavedImg;};n.prototype._storeCurrentImg=function(){this._oSavedImg.width=this._oCanvas.width;this._oSavedImg.height=this._oCanvas.height;this._oSavedImg.getContext("2d").drawImage(this._oCanvas,0,0);};n.prototype._addHistory=function(H,p){if(p){this._oPreview=H;}else{this._addNewHistory(H);this._oPreview=null;}this._updateFilters();};n.prototype._applyPreview=function(){if(!this._oPreview){return;}this._addNewHistory(this._oPreview);this._oPreview=null;};n.prototype._addNewHistory=function(N){this._aHistory=this._aHistory.slice(this._iHistoryIndex);this._iHistoryIndex=0;if(this._aHistory.length===0||!this._aHistory[0].compare(N)){this._aHistory.unshift(N);this._storeCurrentImg();this._fireHistoryChanged();}};n.prototype._cancelPreview=function(){if(!this._oPreview){return;}this._oPreview=null;this._updateFilters();this._drawImage(this._getLastImg());};n.prototype._jumpToHistory=function(p){var s=this._iHistoryIndex,H,i;this._iHistoryIndex=Math.min(this._aHistory.length,Math.max(0,p));if(s===this._iHistoryIndex){return;}if(s<this._iHistoryIndex){this._drawImage(this._oOrigImg);this._storeCurrentImg();this._applyExifOrientation();i=this._aHistory.length-1;}else{i=s-1;}for(i;i>=this._iHistoryIndex;i--){H=this._aHistory[i];switch(H.getMetadata().getName()){case"sap.suite.ui.commons.imageeditor.RotateHistoryItem":{this._setRotation(H.getDegrees());break;}case"sap.suite.ui.commons.imageeditor.ResizeHistoryItem":{this._setCanvasSize(H.getWidth(),H.getHeight());break;}case"sap.suite.ui.commons.imageeditor.FlipHistoryItem":{this._flip(H.getVertical(),H.getHorizontal());break;}case"sap.suite.ui.commons.imageeditor.FilterHistoryItem":{if(this._needsManualFilter()){this._applyFilterItem(H);}break;}case"sap.suite.ui.commons.imageeditor.CropRectangleHistoryItem":{this._rectangleCrop(H.getX(),H.getY(),H.getWidth(),H.getHeight());break;}case"sap.suite.ui.commons.imageeditor.CropEllipseHistoryItem":{this._ellipseCrop(H.getX(),H.getY(),H.getRx(),H.getRy());break;}case"sap.suite.ui.commons.imageeditor.CropCustomShapeHistoryItem":{this._customShapeCrop(H.getX(),H.getY(),H.getWidth(),H.getHeight());break;}default:{break;}}this._storeCurrentImg();}this._updateFilters();this._fireHistoryChanged();};n.prototype._fireHistoryChanged=function(){this.fireHistoryChanged({history:this._aHistory.slice(),index:this._iHistoryIndex});};n.prototype._onMouseDown=function(E){if(E.button!==0||(E.target!==this.getDomRef()&&E.target!==this._oCanvas)){return;}var t=this,s=E.clientX,i=E.clientY;E.preventDefault();function p(E){var v=E.clientX,w=E.clientY,x=v-s,y=w-i,z=t.getDomRef();z.scrollLeft-=x;z.scrollTop-=y;s=v;i=w;}function u(){document.removeEventListener("mousemove",p);document.removeEventListener("mouseup",u);}document.addEventListener("mousemove",p);document.addEventListener("mouseup",u);};n.prototype._onMouseWheel=function(E){if(!E.ctrlKey){return;}E.preventDefault();var z=E.wheelDeltaY>0?this._zoomIn.bind(this):this._zoomOut.bind(this);z({x:(E.clientX-this._$Container[0].getBoundingClientRect().x)/this.getZoomLevel()*100,y:(E.clientY-this._$Container[0].getBoundingClientRect().y)/this.getZoomLevel()*100});this.fireZoomChanged({zoom:this._fZoom});};n.prototype._limitCropArea=function(x,y,w,H,i){var p=this._getMaxCropAreaWidth(i),s=this._getMinCropAreaWidth(i),t=this._getMaxCropAreaHeight(i),u=this._getMinCropAreaHeight(i);x=x&&x<0?0:x;y=y&&y<0?0:y;w=this._constraintValue(w,s,p);H=this._constraintValue(H,u,t);if(x+w>this.getWidth()){x-=(x+w)-this.getWidth();}if(y+H>this.getHeight()){y-=(y+H)-this.getHeight();}return{x:x,y:y,width:w,height:H};};n.prototype._limitCurrentCropArea=function(){var i=this.getCropArea();if(i){this.setCropArea(i.x,i.y,i.width,i.height);}};n.prototype._getMaxCropAreaWidth=function(i){var p,s=this.getCropArea();if(i&&this.getKeepCropAspectRatio()&&s&&this.getWidth()/this.getHeight()>s.width/s.height){p=s.width*this._getMaxCropAreaHeight()/s.height;}else{p=this.getWidth();}return Math.round(p);};n.prototype._getMinCropAreaWidth=function(i){var p,s=this.getCropArea();if(i&&this.getKeepCropAspectRatio()&&s&&s.width>s.height){s=this.getCropArea();p=s.width*this._getMinCropAreaHeight()/s.height;}else{p=n.LIMITS.CROP_AREA_MIN;}return Math.round(p);};n.prototype._getMaxCropAreaHeight=function(i){var p,s=this.getCropArea();if(i&&this.getKeepCropAspectRatio()&&s&&this.getWidth()/this.getHeight()<s.width/s.height){s=this.getCropArea();p=s.height*this._getMaxCropAreaWidth()/s.width;}else{p=this.getHeight();}return Math.round(p);};n.prototype._getMinCropAreaHeight=function(i){var p,s=this.getCropArea();if(i&&this.getKeepCropAspectRatio()&&s&&s.width<s.height){s=this.getCropArea();p=s.height*this._getMinCropAreaWidth()/s.width;}else{p=n.LIMITS.CROP_AREA_MIN;}return Math.round(p);};n.prototype._scaleCropArea=function(O,N){var i=this.getCropArea();if(i&&typeof i.x==="number"&&typeof i.width==="number"){i.newWidth=i.width*(O/N);i.newHeight=i.height*(O/N);i.x+=(i.width-i.newWidth)/2;i.y+=(i.height-i.newHeight)/2;i=this._limitCropArea(i.x,i.y,i.newWidth,i.newHeight,true);this._setCropArea(i.x,i.y,i.width,i.height);}};n.prototype._setCropArea=function(x,y,w,H){this._oCropArea={x:x,y:y,width:w,height:H};if(!this._isReady()){return;}var p;if(typeof this._oCropArea.x!=="number"){this._oCropArea.x=(this.getWidth()-w)/2;this._oCropArea.y=(this.getHeight()-H)/2;}p=this._transposeImageCoordsPxToPercent(this._oCropArea.x,this._oCropArea.y,this._oCropArea.width,this._oCropArea.height);this._refreshCropContainerSize();this._setOverlayMaskSize(p.x,p.y,p.width,p.height,"%");this._refreshOverlayMask();this._refreshCropContainerLook();this._updateCropAreaHandlerColors();};n.prototype._setOverlayMaskSize=function(x,y,w,H,u){var $;$=this.$("overlayMaskRect");$.attr({x:x+u,y:y+u,width:w+u,height:H+u});$=this.$("overlayMaskEllipse");$.attr({cx:(x+w/2)+u,cy:(y+H/2)+u,rx:(w/2)+u,ry:(H/2)+u});$=this.$("overlayMaskCustomBlack");$.attr({x:x+u,y:y+u,width:w+u,height:H+u});$=this.$("overlayMaskCustomWhite");$.attr({x:x+u,y:y+u,width:w+u,height:H+u});};n.prototype._constraintValue=function(v,i,p){if(isNaN(v)||v<i){v=i;}else if(v>p){v=p;}return Math.round(v);};n.prototype._setZoom=function(z,p){var O=this._fZoom,t=this.getDomRef(),T,i,s,u,v,w,x,y;this._fZoom=parseFloat(z.toFixed(2));if(this._fZoom<=0){this._fZoom=1;}p=p||{};if(t){s=t.clientWidth;u=t.clientHeight;v=t.scrollLeft;w=t.scrollTop;}this._updateTransformation();this._refreshContainerSize();if(t){T=t.getBoundingClientRect();i=this._$Container[0].getBoundingClientRect();p.x=p.x||(t.clientWidth/2+T.x-(i.x-((s-t.clientWidth)/2)))/O*100;p.y=p.y||(t.clientHeight/2+T.y-(i.y-((u-t.clientHeight)/2)))/O*100;}if(p.x&&p.y){x=t.scrollLeft+(p.x/100*this.getZoomLevel()-t.scrollLeft)-(p.x/100*O-v);y=t.scrollTop+(p.y/100*this.getZoomLevel()-t.scrollTop)-(p.y/100*O-w);}if(t&&p.x){t.scrollLeft=x;}if(t&&p.y){t.scrollTop=y;}if(this.getScaleCropArea()){this._scaleCropArea(O,this._fZoom);}this._refreshCropContainerLook();};n.prototype._getScale=function(){return this._fZoom/100;};n.prototype._zoomIn=function(p){var s=n.ZOOM_MILESTONES.indexOf(this._fZoom),z=this._fZoom,i;if(s>=0&&s<n.ZOOM_MILESTONES.length-1){z=n.ZOOM_MILESTONES[s+1];}else{for(i=0;i<n.ZOOM_MILESTONES.length;i++){if(n.ZOOM_MILESTONES[i]>z){z=n.ZOOM_MILESTONES[i];break;}}}this._setZoom(z,p);};n.prototype._zoomOut=function(p){var s=n.ZOOM_MILESTONES.indexOf(this._fZoom),z=this._fZoom,i;if(s>0){z=n.ZOOM_MILESTONES[s-1];}else{for(i=n.ZOOM_MILESTONES.length-1;i>=0;i--){if(n.ZOOM_MILESTONES[i]<z){z=n.ZOOM_MILESTONES[i];break;}}}this._setZoom(z,p);};n.prototype._zoomToFit=function(){this._$Container.css({width:"",height:"",margin:"0px"});this._oCanvas.style.maxWidth="100%";this._oCanvas.style.maxHeight="100%";this._oCanvas.style.transform="";var z=this._oCanvas.getBoundingClientRect().width*100/this._oCanvas.width;this._oCanvas.style.maxWidth="";this._oCanvas.style.maxHeight="";this._$Container.css({margin:"auto"});this.zoom(z);};n.prototype._setCanvasSize=function(w,H){var i=this._getLastImg();this._oCanvas.width=w;this._oCanvas.height=H;this._oContext.drawImage(i,0,0,i.width,i.height,0,0,w,H);this._refreshContainerSize();};n.prototype._setRotation=function(i){var p=this._getLastImg(),s,t,u;s=this._degToRad(i);this._oCanvas.width=Math.abs(p.width*Math.cos(s))+Math.abs(p.height*Math.sin(s));this._oCanvas.height=Math.abs(p.width*Math.sin(s))+Math.abs(p.height*Math.cos(s));t=this._limitCanvasSize(this._oCanvas.width,this._oCanvas.height);u=t.width/this._oCanvas.width;this._oCanvas.width=t.width;this._oCanvas.height=t.height;this._oContext.save();this._oContext.translate(this._oCanvas.width/2,this._oCanvas.height/2);this._oContext.rotate(s);this._oContext.translate(-this._oCanvas.width/2,-this._oCanvas.height/2);this._oContext.drawImage(p,0,0,p.width,p.height,Math.round((this._oCanvas.width-p.width*u)/2),Math.round((this._oCanvas.height-p.height*u)/2),p.width*u,p.height*u);this._oContext.restore();this._refreshContainerSize();};n.prototype._flipVertical=function(){this._flip(true,false);};n.prototype._flipHorizontal=function(){this._flip(false,true);};n.prototype._flip=function(v,H){var i=this._getLastImg(),t=document.createElement("canvas"),p=t.getContext("2d");t.width=i.width;t.height=i.height;p.translate(H?i.width:0,v?i.height:0);p.scale(H?-1:1,v?-1:1);p.drawImage(i,0,0);this._oContext.clearRect(0,0,this._oCanvas.width,this._oCanvas.height);this._oContext.drawImage(t,0,0);};n.prototype._transposeViewportCoordsToImageCoords=function(x,y,w,H){if(!this._isReady()){return{x:0,y:0,width:0,height:0};}var i=this._oCanvas.getBoundingClientRect(),p=this._oCanvas.width/i.width,s=this._oCanvas.height/i.height;return{x:x*p,y:y*s,width:w*p,height:H*s};};n.prototype._transposeImageCoordsToViewportCoords=function(x,y,w,H){if(!this._isReady()){return{x:0,y:0,width:0,height:0};}var i=this._oCanvas.getBoundingClientRect(),p=this._oCanvas.width/i.width,s=this._oCanvas.height/i.height;return{x:x/p,y:y/s,width:w/p,height:H/s};};n.prototype._transposeImageCoordsPxToPercent=function(x,y,w,H){return{x:x*100/this._oCanvas.width,y:y*100/this._oCanvas.height,width:w*100/this._oCanvas.width,height:H*100/this._oCanvas.height};};n.prototype._transposePercentToImageCoordsPx=function(x,y,w,H){return{x:x*this._oCanvas.width/100,y:y*this._oCanvas.height/100,width:w*this._oCanvas.width/100,height:H*this._oCanvas.height/100};};n.prototype._transposeViewPortPxToPercent=function(x,y,w,H){var i=this._$Container[0].getBoundingClientRect();return{x:x*100/i.width,y:y*100/i.height,width:w*100/i.width,height:H*100/i.height};};n.prototype._updateCropAreaHandlerColors=function(){var s;if(!this.$().find(".sapSuiteUiCommonsImageEditorCropInnerRectangle").is(":visible")){return;}var t=this;this.$().find(".sapSuiteUiCommonsImageEditorCropInnerRectangle .sapSuiteUiCommonsImageEditorHandlerContainer").each(function(){var $=q(this);if(!$.is(":visible")||$.width()===0||$.height()===0){return;}s=t._getContrastColorForElement(this);for(var i=0;i<this.childElementCount;i++){this.children[i].style.background=s;}});};n.prototype._getContrastColorForElement=function(E){var i=this._oCanvas.getBoundingClientRect(),p=E.getBoundingClientRect(),s=this._transposeViewportCoordsToImageCoords(p.left-i.left,p.top-i.top,p.width,p.height),t=this._getContrastColorForRectangleArea(s.x,s.y,s.width,s.height);return t;};n.prototype._getContrastColorForRectangleArea=function(x,y,w,H){var A=this._getRectangleAreaAvg(x,y,w,H);return A>0.5*0.5?"white":"black";};n.prototype._getRectangleAreaAvg=function(x,y,w,H){if(w===0||H===0){return 0;}var p=this._oContext.getImageData(x,y,Math.ceil(w),Math.ceil(H)).data,s=0,t,G,B,A;for(var i=0;i<p.length;i+=4){t=1-(p[i]/255);G=1-(p[i+1]/255);B=1-(p[i+2]/255);A=p[i+3]/255;s+=(0.2126*t*t+0.7152*G*G+0.0722*B*B)*A;}return s/(p.length/4);};n.prototype._updateResizableCropAspectRatio=function(){var B=this.$().find(".sapSuiteUiCommonsImageEditorCropInnerRectangle"),K=this.getKeepCropAspectRatio();this._updateResizableAspectRatio(B,K);};n.prototype._updateResizableResizeAspectRatio=function(){var K=this.getKeepResizeAspectRatio();this._updateResizableAspectRatio(this._$Container,K);};n.prototype._updateResizableAspectRatio=function($,K){if($&&$.data("uiResizable")){$.resizable("option","aspectRatio",K).data("uiResizable")._aspectRatio=K;}};n.prototype._applyRectangleCrop=function(p){var i=this.$().find(".sapSuiteUiCommonsImageEditorCropInnerRectangle")[0].getBoundingClientRect(),s=this._oCanvas.getBoundingClientRect(),t=this._transposeViewportCoordsToImageCoords(i.left-s.left,i.top-s.top,i.width,i.height);this.rectangleCrop(t.x,t.y,t.width,t.height,p);};n.prototype._rectangleCrop=function(x,y,w,H){var t=document.createElement("canvas");t.width=Math.round(w);t.height=Math.round(H);t.getContext("2d").drawImage(this._oCanvas,x,y,w,H,0,0,w,H);this._drawImage(t);this._refreshCropContainerSize();};n.prototype._applyEllipseCrop=function(p){var i,s,t;i=this.$().find(".sapSuiteUiCommonsImageEditorCropInnerRectangle")[0].getBoundingClientRect();s=this._oCanvas.getBoundingClientRect();t=this._transposeViewportCoordsToImageCoords(i.left-s.left,i.top-s.top,i.width,i.height);this.ellipseCrop(t.width/2+t.x,t.height/2+t.y,t.width/2,t.height/2,p);};n.prototype._ellipseCrop=function(x,y,X,Y){var t=document.createElement("canvas"),i=X*2,p=Y*2,s=t.getContext("2d");t.width=Math.round(i);t.height=Math.round(p);if(!s.ellipse){s.save();s.translate(X,Y);s.scale(X,Y);s.arc(0,0,1,0,360);s.restore();}else{s.ellipse(X,Y,X,Y,0,0,2*Math.PI);}s.fill();s.globalCompositeOperation="source-in";s.drawImage(this._oCanvas,x-X,y-Y,i,p,0,0,i,p);this._drawImage(t);this._refreshCropContainerSize();};n.prototype._applyCustomShapeCrop=function(p){var i,s,t;i=this.$().find(".sapSuiteUiCommonsImageEditorCropInnerRectangle")[0].getBoundingClientRect();s=this._oCanvas.getBoundingClientRect();t=this._transposeViewportCoordsToImageCoords(i.left-s.left,i.top-s.top,i.width,i.height);this.customShapeCrop(t.x,t.y,t.width,t.height,p);};n.prototype._customShapeCrop=function(x,y,w,H){var t=document.createElement("canvas"),i=t.getContext("2d");t.width=w;t.height=H;i.drawImage(this._oCustomShapeImg,0,0,w,H);i.globalCompositeOperation="source-in";i.drawImage(this._oCanvas,x,y,w,H,0,0,w,H);i.globalCompositeOperation="source-over";this._drawImage(t);this._refreshCropContainerSize();};n.prototype._getFinalisedCanvas=function(){var w=this.getWidth(),H=this.getHeight(),i,t,p;i=this._getLastImg().getContext("2d").getImageData(0,0,w,H);this._applyFilterHistory(i);t=document.createElement("canvas");p=t.getContext("2d");t.width=w;t.height=H;p.putImageData(i,0,0);return t;};n.prototype._applyFilterHistory=function(p){var s;for(var i=this._aHistory.length-1;i>=this._iHistoryIndex;i--){if(this._aHistory[i].isA("sap.suite.ui.commons.imageeditor.FilterHistoryItem")){s=this._aHistory[i];h[s.getType()](p,s.getValue()/100);}}};n.prototype._applyFilterItem=function(i){var p=this._getLastImg(),s=p.getContext("2d"),t=s.getImageData(0,0,p.width,p.height);h[i.getType()](t,i.getValue()/100);this._oContext.putImageData(t,0,0);};n.prototype._updateFilters=function(){var s="",H;function p(t){return t.getType()+"("+t.getValue()+t.getUnit()+") ";}if(this._needsManualFilter()){if(this._isReady()){if(this._oPreview&&this._oPreview.isA("sap.suite.ui.commons.imageeditor.FilterHistoryItem")){this._applyFilterItem(this._oPreview);}}}else{for(var i=this._aHistory.length-1;i>=this._iHistoryIndex;i--){H=this._aHistory[i];if(H.isA("sap.suite.ui.commons.imageeditor.FilterHistoryItem")){s+=p(H);}}if(this._oPreview&&this._oPreview.isA("sap.suite.ui.commons.imageeditor.FilterHistoryItem")){s+=p(this._oPreview);}this._oCanvas.style.filter=s.trim();}};n.prototype._needsManualFilter=function(){return D.browser.msie||D.os.name===D.os.OS.IOS;};n.prototype._isMobileSafari=function(){return D.os.name===D.os.OS.IOS&&D.browser.name===D.browser.BROWSER.SAFARI;};n.prototype._reset=function(){this.$().addClass("sapSuiteUiCommonsImageEditorEmpty");this._aHistory=[];this._iHistoryIndex=0;this._oPreview=null;this._bImageLoaded=false;this._oCropArea=null;this._oCanvas.width=0;this._oCanvas.height=0;this._oOriginalBlob=null;this._sOriginalFileName=null;this._sOriginalFileType=null;this._iExifRotation=null;this._bExifFlip=false;this._updateFilters();this._refreshContainerSize();};n.prototype._drawImage=function(s){var i=this._limitCanvasSize(s.width,s.height);this._oCanvas.width=i.width;this._oCanvas.height=i.height;this._oContext.drawImage(s,0,0,s.width,s.height,0,0,this._oCanvas.width,this._oCanvas.height);this._refreshContainerSize();};n.prototype._limitCanvasSize=function(w,H,s){var i=this._isMobileSafari()?n.LIMITS.MAX_SAFARI_MOBILE_CANVAS_SIZE:n.LIMITS.MAX_CANVAS_SIZE,N=w,p=H,t;if(w*H>i){t=Math.sqrt(i/(w*H));N=Math.floor(w*t);p=Math.floor(p*N/w);if(!s){this.fireSizeChanged({width:N,height:p,originalWidth:w,originalHeight:H});b.show(r.getText("IMGEDITOR_SCALE_WARNING",[N,p,w,H]),{duration:6000});}}return{width:N,height:p};};n.prototype._degToRad=function(i){return i*Math.PI/180;};n.prototype._RadToDeg=function(i){return i*180/Math.PI;};n.prototype._getCropAreaDragIcon=function(){if(!this._cropAreaDragIcon){this._cropAreaDragIcon=new I({src:"sap-icon://move",useIconTooltip:false});}return this._cropAreaDragIcon;};return n;});
