sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/suite/ui/commons/library","sap/ui/core/library","sap/m/library","./ImageEditor","sap/m/OverflowToolbar","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarToggleButton","sap/m/OverflowToolbarLayoutData","sap/m/ToggleButton","sap/m/ToolbarSeparator","sap/m/ToolbarSpacer","sap/m/Label","sap/m/Slider","sap/m/Input","sap/m/CheckBox","sap/ui/model/json/JSONModel","sap/m/MenuButton","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/Select","sap/m/Button","sap/ui/core/Item","sap/m/ResponsivePopover","sap/m/List","sap/m/StandardListItem","sap/m/CustomListItem","sap/m/FlexBox","sap/m/FlexItemData","sap/m/IconTabBar","sap/m/IconTabFilter","sap/ui/core/Icon","sap/ui/core/HTML","sap/m/Switch","sap/suite/ui/commons/ControlProxy","sap/base/Log","sap/ui/unified/FileUploader","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","./ImageEditorContainerRenderer"],function(q,C,l,a,M,I,O,b,c,d,T,e,f,L,S,g,h,J,j,k,m,n,B,o,R,p,r,s,F,t,u,v,w,H,x,y,z,A,D,E){"use strict";var G=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.commons");var K=M.InputType,N=M.ListType,P=l.ImageEditorMode,Q=l.ImageEditorContainerMode,U=l.ImageEditorContainerButton,V=a.ValueState,W=M.ListMode,X=M.ButtonType,Y=M.FlexDirection,Z=M.FlexRendertype,$=M.FlexJustifyContent,_=M.FlexAlignItems,a1=M.IconTabDensityMode,b1=M.BackgroundDesign,c1=M.SwitchType,d1=a.TextAlign,e1=Object.freeze({WIDTH:{min:I.LIMITS.WIDTH_MIN,max:I.LIMITS.WIDTH_MAX,callback:"_setWidth"},HEIGHT:{min:I.LIMITS.HEIGHT_MIN,max:I.LIMITS.HEIGHT_MAX,callback:"_setHeight"},ROTATION:{min:I.LIMITS.ROTATION_MIN,max:I.LIMITS.ROTATION_MAX,callback:"_rotate"},FILTER:{callback:"_applyCurrentFilter"}}),f1=Object.freeze({CUSTOMSIZE:"sap-icon://write-new-document",ORIGINALSIZE:"sap-icon://table-view",ROTATELEFT:"sap-icon://response",ROTATERIGHT:"sap-icon://forward",CROPRECTANGLE:"sap-icon://color-fill",CROPELLIPSE:"sap-icon://circle-task-2",CROPCUSTOMSHAPE:"sap-icon://add-favorite",TRANSFORM:"sap-icon://draw-rectangle",FILTER:"sap-icon://palette",CROP:"sap-icon://crop",UNDO:"sap-icon://undo",DROPDOWN:"sap-icon://slim-arrow-down",ZONES:"sap-icon://tag",LOCK:"sap-icon://locked",RESET:"sap-icon://reset",FLIPVERTICAL:"sap-icon://resize-vertical",FLIPHORIZONTAL:"sap-icon://resize-horizontal",RELATIVE:"sap-icon://resize",ZOOMIN:"sap-icon://zoom-in",ZOOMOUT:"sap-icon://zoom-out",ZOOMFIT:"sap-icon://popup-window"});var g1=C.extend("sap.suite.ui.commons.imageeditor.ImageEditorContainer",{metadata:{library:"sap.suite.ui.commons",properties:{mode:{type:"sap.suite.ui.commons.ImageEditorContainerMode",defaultValue:Q.Filter},enabledButtons:{type:"sap.suite.ui.commons.ImageEditorContainerButton[]",defaultValue:[U.Filter,U.Transform,U.Crop]}},defaultAggregation:"imageEditor",aggregations:{imageEditor:{type:"sap.suite.ui.commons.imageeditor.ImageEditor",multiple:false,singularName:"imageEditor"},customToolbarControls:{type:"sap.ui.core.Control",multiple:true,singularName:"customToolbarControl"},customResizeItems:{type:"sap.suite.ui.commons.imageeditor.CustomSizeItem",multiple:true,singularName:"customResizeItem"},customRectangleCropItems:{type:"sap.suite.ui.commons.imageeditor.CustomSizeItem",multiple:true,singularName:"customRectangleCropItem"},customEllipseCropItems:{type:"sap.suite.ui.commons.imageeditor.CustomSizeItem",multiple:true,singularName:"customEllipseCropItem"}}}});var h1=Object.freeze({NUM_KEPT_ITEMS:2});g1.prototype.init=function(){var i={enabled:false,mode:null,zoom:100,transform:{keepAspectRatio:true,width:null,height:null,widthValueState:V.None,widthValueStateText:null,heightValueState:V.None,heightValueStateText:null,rotate:0,rotateValueState:V.None,rotateValueStateText:null,selectedTypeKey:"Resize",flipVertical:false,flipHorizontal:false,resizes:[{key:"custom",text:G.getText("IMGEDITOR_CUSTOM_SIZE"),icon:f1.CUSTOMSIZE,unlockRatio:true},{key:"original",text:G.getText("IMGEDITOR_ORIGINAL_SIZE"),icon:f1.ORIGINALSIZE}],rotates:[{key:"90left",text:G.getText("IMGEDITOR_ROTATE_90LEFT"),rotate:-90,icon:f1.ROTATELEFT},{key:"90right",text:G.getText("IMGEDITOR_ROTATE_90RIGHT"),rotate:90,icon:f1.ROTATERIGHT},{key:"45left",text:G.getText("IMGEDITOR_ROTATE_45LEFT"),rotate:-45,icon:f1.ROTATELEFT},{key:"45right",text:G.getText("IMGEDITOR_ROTATE_45RIGHT"),rotate:45,icon:f1.ROTATERIGHT}],flips:[{key:"vertical",text:G.getText("IMGEDITOR_FLIP_VERTICAL"),icon:f1.FLIPVERTICAL,flipVertical:true,flipHorizontal:false},{key:"horizontal",text:G.getText("IMGEDITOR_FLIP_HORIZONTAL"),icon:f1.FLIPHORIZONTAL,flipVertical:false,flipHorizontal:true}]},crop:{scaleCropArea:false,customShapeLoaded:false,zoom:100,zoomValueState:V.None,zoomValueStateText:null,width:null,widthValueState:V.None,widthValueStateText:null,height:null,heightValueState:V.None,heightValueStateText:null,keepAspectRatio:true,selectedTypeKey:"Rectangle",selectedType:null,enabled:true,areaRectangle:{x:10,y:10,width:80,height:80},types:[{key:"Rectangle",text:"\ue17b",icon:f1.CROPRECTANGLE,apply:"applyVisibleCrop"},{key:"Ellipse",text:"\ue255",icon:f1.CROPELLIPSE,apply:"applyVisibleCrop"},{key:"CustomShape",text:"\ue057",icon:f1.CROPCUSTOMSHAPE,apply:"applyVisibleCrop"}],ratiosRectangle:[{key:"custom",text:G.getText("IMGEDITOR_CUSTOM_SIZE"),icon:f1.CUSTOMSIZE,unlockRatio:true,relative:true},{key:"original",text:G.getText("IMGEDITOR_CROP_RATIO_ORIGINAL"),width:null,height:null,icon:f1.ORIGINALSIZE,relative:true}],ratiosCircle:[{key:"custom",text:G.getText("IMGEDITOR_CUSTOM_SIZE"),icon:f1.CUSTOMSIZE,unlockRatio:true,relative:true},{key:"original",text:G.getText("IMGEDITOR_CROP_RATIO_ORIGINAL"),width:null,height:null,icon:f1.ORIGINALSIZE,relative:true}],ratiosCustomShape:[{key:"custom",text:G.getText("IMGEDITOR_CUSTOM_SIZE"),icon:f1.CUSTOMSIZE,unlockRatio:true,relative:true},{key:"original",text:G.getText("IMGEDITOR_CROP_RATIO_ORIGINAL"),callback:"_setCustomShapeCropAreaRatio",icon:f1.ORIGINALSIZE,relative:true}]},filter:{filterValueState:V.None,filterValueStateText:null,selectedFilter:null,filters:[{text:G.getText("IMGEDITOR_FILTER_BRIGHTNESS"),type:"brightness",value:100,defaultValue:100,unit:"%",min:I.LIMITS.BRIGHTNESS_MIN,max:I.LIMITS.BRIGHTNESS_MAX},{text:G.getText("IMGEDITOR_FILTER_CONTRAST"),type:"contrast",value:100,defaultValue:100,unit:"%",min:I.LIMITS.CONTRAST_MIN,max:I.LIMITS.CONTRAST_MAX},{text:G.getText("IMGEDITOR_FILTER_SATURATION"),type:"saturate",value:100,defaultValue:100,unit:"%",min:I.LIMITS.SATURATE_MIN,max:I.LIMITS.SATURATE_MAX},{text:G.getText("IMGEDITOR_FILTER_GRAYSCALE"),type:"grayscale",value:0,defaultValue:0,unit:"%",min:I.LIMITS.GRAYSCALE_MIN,max:I.LIMITS.GRAYSCALE_MAX},{text:G.getText("IMGEDITOR_FILTER_INVERT"),type:"invert",value:0,defaultValue:0,unit:"%",min:I.LIMITS.INVERT_MIN,max:I.LIMITS.INVERT_MAX},{text:G.getText("IMGEDITOR_FILTER_SEPIA"),type:"sepia",value:0,defaultValue:0,unit:"%",min:I.LIMITS.SEPIA_MIN,max:I.LIMITS.SEPIA_MAX}]},history:[],historyIndex:0};this._bFirstTimeRendered=true;this._oObserver=new D(this._onManagedObjectChange.bind(this));this._oObserver.observe(this,{properties:["enabledButtons"],aggregations:["customToolbarControls"]});this._oModel=new J(i);this._oThumbnailCanvas=document.createElement("canvas");this._updateToolbarsContent();this["_setMode"+this.getMode()]();};g1.prototype.onBeforeRendering=function(){if(this._sResizeHandlerId){E.deregister(this._sResizeHandlerId);}};g1.prototype.onAfterRendering=function(){var i=this;this._bIsSmallSize=this._isSmallSize();function i1(){sap.ui.getCore().detachThemeChanged(i1);i._zoomToFit();}if(this._bFirstTimeRendered&&this.getImageEditor()){this._bFirstTimeRendered=false;if(sap.ui.getCore().isThemeApplied()){this._zoomToFit();}else{sap.ui.getCore().attachThemeChanged(i1);}}this._sResizeHandlerId=E.register(this,this._onResize.bind(this));};g1.prototype.onExit=function(){if(this._sResizeHandlerId){E.deregister(this._sResizeHandlerId);}};g1.prototype._onResize=function(){var i=this._isSmallSize();if(this._bIsSmallSize!==i){this._bIsSmallSize=i;this.rerender();}};g1.prototype._isSmallSize=function(){var i=(sap.m.ScreenSizes&&sap.m.ScreenSizes.table)||600;return this.$()[0]&&this.$().width()<i;};g1.prototype._zoomToFit=function(){var i=this.getImageEditor();if(i&&i._isReady()&&this.getDomRef()){i.zoomToFit();this._oModel.setProperty("/zoom",i.getZoomLevel());this._refreshCropAreaSize();}};g1.prototype.exit=function(){this._oObserver.disconnect();this._oObserver.destroy();};g1.prototype.setMode=function(i){this.setProperty("mode",i,true);this["_setMode"+this.getMode()]();return this;};g1.prototype.setImageEditor=function(i){this._detachEditorEvents(this.getImageEditor());this.setAggregation("imageEditor",i);this._attachEditorEvents(i);if(i&&i.getLoaded()){this._onImageLoaded();}if(i&&i.getCustomShapeLoaded()){this._onCustomShapeLoaded();}return this;};g1.prototype.destroyImageEditor=function(){this._detachEditorEvents(this.getImageEditor());this.destroyAggregation("imageEditor");this._oModel.setProperty("/enabled",false);return this;};g1.prototype.getToolbar=function(){return this._getHeaderToolbar();};g1.prototype.getToolbarIds=function(){return{filter:this.getId()+"-filterButton",crop:this.getId()+"-cropButton",transform:this.getId()+"-transformButton",undo:this.getId()+"-undoButton",history:this.getId()+"-historyButton",zoomIn:this.getId()+"-zoominButton",zoomOut:this.getId()+"-zoomoutButton",zoomToFit:this.getId()+"-zoomToFitButton",zoomLabel:this.getId()+"-zoomLabel",separator:this.getId()+"-separator"};};g1.prototype.getMobileHeaderToolbar=function(){return this._getMobileHeaderToolbar();};g1.prototype.getMobileZoomToolbar=function(){return this._getMobileZoomToolbar();};g1.prototype.getMobileZoomToolbarIds=function(){return{zoomIn:this.getId()+"-mobileZoominButton",zoomLabel:this.getId()+"-mobileZoomLabel",zoomOut:this.getId()+"-mobilezoomoutButton",zoomToFit:this.getId()+"-mobileZoomToFitButton",scaleSwitch:this.getId()+"-mobileScaleSwitch",scaleLabel:this.getId()+"-mobileScaleLabel"};};g1.prototype.getMobileFooterToolbar=function(){return this._getMobileFooterToolbar();};g1.prototype.getMobileFooterToolbarIds=function(){return{filter:this.getId()+"-mobileFilterButton",crop:this.getId()+"-mobileCropButton",transform:this.getId()+"-mobileTransformButton",undo:this.getId()+"-mobileUndoButton",history:this.getId()+"-mobileHistoryButton",apply:this.getId()+"-mobileApplyButton"};};g1.prototype._attachEditorEvents=function(i){if(!i){return;}i.attachLoaded(this._onImageLoaded,this);i.attachCustomShapeLoaded(this._onCustomShapeLoaded,this);i.attachError(this._onImageError,this);i.attachCropAreaChanged(this._onCropAreaChange,this);i.attachHistoryChanged(this._onHistoryChange,this);i.attachSizeChanged(this._onSizeChange,this);i.attachZoomChanged(this._onZoomChange,this);};g1.prototype._detachEditorEvents=function(i){if(!i){return;}i.detachLoaded(this._onImageLoaded,this);i.detachCustomShapeLoaded(this._onCustomShapeLoaded,this);i.detachError(this._onImageError,this);i.detachCropAreaChanged(this._onCropAreaChange,this);i.detachHistoryChanged(this._onHistoryChange,this);i.detachSizeChanged(this._onSizeChange,this);i.detachZoomChanged(this._onZoomChange,this);};g1.prototype._onManagedObjectChange=function(i){if(i.object===this._oMobileHeaderToolbar){this._oMobileHeaderToolbar.setVisible(i.object.getContent().length>0);}else if(i.object===this){this._updateToolbarsContent();}};g1.prototype._refreshImageSize=function(){if(!this.getImageEditor()||!this.getImageEditor().getLoaded()){return;}var i=this.getImageEditor().getWidth(),i1=this.getImageEditor().getHeight();this._oModel.setProperty("/transform/resizes/1/width",i);this._oModel.setProperty("/transform/resizes/1/height",i1);this._oModel.setProperty("/crop/ratiosRectangle/1/width",i);this._oModel.setProperty("/crop/ratiosRectangle/1/height",i1);this._oModel.setProperty("/crop/ratiosCircle/1/width",i);this._oModel.setProperty("/crop/ratiosCircle/1/height",i1);this._updateCurrentSize(i,i1);};g1.prototype._refreshCropAreaSize=function(){var i=this.getImageEditor().getCropArea();if(!i){return;}this._updateCropSize(Math.round(i.width),Math.round(i.height));};g1.prototype._onImageLoaded=function(){var i=this.getImageEditor();this._resetValueStates();this._oModel.setProperty("/enabled",!!i.getSrc());if(!i.getSrc()){this._changeOptionsPanelContent();return;}this["_setMode"+this.getMode()]();this._refreshImageSize();this._oModel.setProperty("/history",[]);this._oModel.setProperty("/historyIndex",0);this._zoomToFit();this._updateOrigThumbnail();this._resetCurrentPanel();};g1.prototype._onCustomShapeLoaded=function(){var i=this.getImageEditor();if(i.getCustomShapeSrc()&&i.getLoaded()&&i.getMode()===P.CropCustomShape){this._setCustomShapeCropAreaRatio();}this._oModel.setProperty("/crop/customShapeLoaded",!!i.getCustomShapeSrc());};g1.prototype._onImageError=function(){this._resetValueStates();this._changeOptionsPanelContent();this._oModel.setProperty("/enabled",false);};g1.prototype._onCropAreaChange=function(i){this._resetValueStates();this._updateCropSize(Math.round(i.getParameter("cropArea").width),Math.round(i.getParameter("cropArea").height));};g1.prototype._onHistoryChange=function(i){var i1=i.getParameter("history"),j1=i.getParameter("index");this._resetValueStates();this._refreshImageSize();i1.push({noChange:"NoChange"});this._oModel.setProperty("/history",i1);this._oModel.setProperty("/historyIndex",j1);};g1.prototype._onSizeChange=function(i){this._resetValueStates();this._updateCurrentSize(i.getParameter("width"),i.getParameter("height"));this._selectResizeCustomSizeItem(this.getImageEditor().getKeepResizeAspectRatio());};g1.prototype._onZoomChange=function(i){var i1=i.getParameter("zoom");this._oModel.setProperty("/zoom",i1);this._refreshCropAreaSize();};g1.prototype._updateCropSize=function(i,i1){this._oModel.setProperty("/crop/width",i);this._oModel.setProperty("/crop/height",i1);};g1.prototype._updateCurrentSize=function(i,i1){this._oModel.setProperty("/transform/width",i);this._oModel.setProperty("/transform/height",i1);};g1.prototype._updateOrigThumbnail=function(){var i=this.$("origThumbnail"),i1=this.getImageEditor(),j1,k1,l1=this._oThumbnailCanvas.getContext("2d");if(i1.getWidth()>=i1.getHeight()){j1=300;k1=Math.round(i1.getHeight()*j1/i1.getWidth());}else{k1=300;j1=Math.round(i1.getWidth()*k1/i1.getHeight());}this._oThumbnailCanvas.width=j1;this._oThumbnailCanvas.height=k1;l1.clearRect(0,0,j1,k1);l1.drawImage(i1._oCanvas,0,0,j1,k1);i.attr({"href":this._oThumbnailCanvas.toDataURL()});if(i[0]){i[0].setAttribute("viewBox","0 0 "+j1+" "+k1);}};g1.prototype._getHeaderToolbar=function(){if(!this._oHeaderToolbar){this._oHeaderToolbar=new O({enabled:"{/enabled}"}).addStyleClass("sapSuiteUiCommonsImageEditorContainerHeaderToolbar");this._oHeaderToolbar.setModel(this._oModel);this.addDependent(this._oHeaderToolbar);}return this._oHeaderToolbar;};g1.prototype._updateToolbarsContent=function(){var i1=this._getHeaderToolbar(),j1=this._getMobileHeaderToolbar(),k1=this._getMobileFooterToolbar(),l1=this.getEnabledButtons(),i;i1.removeAllContent();j1.removeAllContent();k1.removeAllContent();this._getHistoryItems().forEach(function(m1){i1.addContent(m1);});this._getMobileHistoryItems().forEach(function(m1){k1.addContent(m1);});this._getZoomItems().forEach(function(m1){i1.addContent(m1);});i1.addContent(this._getToolbarSeparator());for(i=0;i<l1.length;i++){switch(l1[i]){case U.Filter:{i1.addContent(this._getFilterButton());k1.addContent(this._getMobileFilterButton());break;}case U.Crop:{i1.addContent(this._getCropButton());k1.addContent(this._getMobileCropButton());break;}case U.Transform:{i1.addContent(this._getTransformButton());k1.addContent(this._getMobileTransformButton());break;}case U.History:{break;}default:break;}}i1.addContent(this._getToolbarSpacer());k1.addContent(this._getMobileFooterToolbarSpacer());k1.addContent(this._getMobileApplyButton());if(this.getCustomToolbarControls().length>0){j1.addContent(this._getMobileHeaderToolbarSpacer());}this.getCustomToolbarControls().forEach(function(m1){var n1=new y(),o1=new y();this.addDependent(n1);n1.setAssociation("control",m1);i1.addContent(n1);this.addDependent(o1);o1.setAssociation("control",m1);j1.addContent(o1);},this);};g1.prototype._getToolbarSpacer=function(){if(!this._oSpacer){this._oSpacer=new f({id:this.getId()+"-spacer"});this.addDependent(this._oSpacer);}return this._oSpacer;};g1.prototype._getMobileHeaderToolbarSpacer=function(){if(!this._oMobileHeaderSpacer){this._oMobileHeaderSpacer=new f({id:this.getId()+"-mobileSpacer"});this.addDependent(this._oMobileHeaderSpacer);}return this._oMobileHeaderSpacer;};g1.prototype._getMobileFooterToolbarSpacer=function(){if(!this._oMobileFooterSpacer){this._oMobileFooterSpacer=new f({id:this.getId()+"-mobileFooterSpacer"});this.addDependent(this._oMobileFooterSpacer);}return this._oMobileFooterSpacer;};g1.prototype._getMobileHeaderToolbar=function(){if(!this._oMobileHeaderToolbar){this._oMobileHeaderToolbar=new O({enabled:"{/enabled}",visible:false}).addStyleClass("sapSuiteUiCommonsImageEditorContainerMobileToolbar");this.addDependent(this._oMobileHeaderToolbar);this._oObserver.observe(this._oMobileHeaderToolbar,{aggregations:["content"]});}return this._oMobileHeaderToolbar;};g1.prototype._getMobileZoomToolbar=function(){if(!this._oMobileZoomToolbar){this._oMobileZoomToolbar=new O({enabled:"{/enabled}",content:[this._getMobileZoomInButton(),this._getMobileZoomLabel(),this._getMobileZoomOutButton(),this._getMobileZoomToFitButton(),this._getMobileScaleSwitch(),this._getMobileScaleLabel()]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerMobileToolbar");this._oMobileZoomToolbar.setModel(this._oModel);this.addDependent(this._oMobileZoomToolbar);}return this._oMobileZoomToolbar;};g1.prototype._getMobileFooterToolbar=function(){if(!this._oMobileFooterToolbar){this._oMobileFooterToolbar=new O({enabled:"{/enabled}"}).addStyleClass("sapSuiteUiCommonsImageEditorContainerMobileToolbar");this._oMobileFooterToolbar.setModel(this._oModel);this.addDependent(this._oMobileFooterToolbar);if(this._oMobileFooterToolbar._applyContextClassFor){this._oMobileFooterToolbar._applyContextClassFor("footer");}else{z.warning("ImageEditorContainer: _applyContextClassFor method doesn't exist, footer look is not applied on mobile footer toolbar");}}return this._oMobileFooterToolbar;};g1.prototype._getHistoryPopover=function(){var i=this;if(!this._oHistoryPopover){this._oHistoryPopover=new R({title:{path:"/history",formatter:function(i1){return G.getText("IMGEDITOR_HISTORY_TITLE",String(i1.length-1));}},endButton:new B({text:G.getText("IMGEDITOR_HISTORY_CLOSE"),press:function(){i._oHistoryPopover.close();}}),afterOpen:function(){var i1=i._oModel.getProperty("/historyIndex"),j1=i._oHistoryList.getItems()[i1];i._oHistoryList.setSelectedItem(j1);j1.focus();}});this._oHistoryList=new p({mode:W.SingleSelectMaster,selectionChange:function(i1){var j1=i1.getParameter("listItem"),k1=j1.getParent().indexOfItem(j1);i._jumpToHistory(k1);},items:{path:"/history",factory:this._historyItemFactory.bind(this)}});this._oHistoryPopover.setModel(this._oModel);this._oHistoryPopover.addContent(this._oHistoryList);this.addDependent(this._oHistoryPopover);}return this._oHistoryPopover;};g1.prototype._historyItemFactory=function(i,i1){var j1=this._oModel.getProperty("/history").indexOf(i1.getProperty()),k1=i1.getProperty(),l1,m1,n1,o1;switch(k1.noChange||k1.getMetadata().getName()){case"sap.suite.ui.commons.imageeditor.RotateHistoryItem":{m1=G.getText("IMGEDITOR_ROTATE");n1=k1.getDegrees();o1=f1.TRANSFORM;break;}case"sap.suite.ui.commons.imageeditor.ResizeHistoryItem":{m1=G.getText("IMGEDITOR_RESIZE");n1=G.getText("IMGEDITOR_HISTORY_TEXT",[k1.getOldWidth()+" x "+k1.getOldHeight(),k1.getWidth()+" x "+k1.getHeight()]);o1=f1.TRANSFORM;break;}case"sap.suite.ui.commons.imageeditor.FlipHistoryItem":{m1=G.getText("IMGEDITOR_FLIP");if(k1.getVertical()&&k1.getHorizontal()){n1=G.getText("IMGEDITOR_FLIP_BOTH");o1=f1.FLIPHORIZONTAL;}else{n1=k1.getVertical()?G.getText("IMGEDITOR_FLIP_VERTICAL"):G.getText("IMGEDITOR_FLIP_HORIZONTAL");o1=k1.getVertical()?f1.FLIPVERTICAL:f1.FLIPHORIZONTAL;}break;}case"sap.suite.ui.commons.imageeditor.FilterHistoryItem":{m1=k1.getType();m1=m1[0].toUpperCase()+m1.slice(1);n1=k1.getValue();o1=f1.FILTER;break;}case"sap.suite.ui.commons.imageeditor.CropRectangleHistoryItem":case"sap.suite.ui.commons.imageeditor.CropEllipseHistoryItem":case"sap.suite.ui.commons.imageeditor.CropCustomShapeHistoryItem":{m1=G.getText("IMGEDITOR_CROP");n1=G.getText("IMGEDITOR_HISTORY_TEXT",[k1.getOldWidth()+" x "+k1.getOldHeight(),k1.getWidth()+" x "+k1.getHeight()]);o1=f1.CROP;break;}case"NoChange":{m1=G.getText("IMGEDITOR_HISTORY_ORIGINAL");n1=G.getText("IMGEDITOR_HISTORY_ORIGINAL_TEXT");o1=f1.RESET;break;}default:{break;}}l1=new r({title:m1,description:n1,icon:o1,selected:{path:"/historyIndex",formatter:function(p1){return j1===p1;}}});return l1;};g1.prototype._getHistoryItems=function(){if(!this._aHistoryItems){this._aHistoryItems=[this._getUndoButton(),this._getHistoryArrowButton()];}return this._aHistoryItems;};g1.prototype._getMobileHistoryItems=function(){if(!this._aMobileHistoryItems){this._aMobileHistoryItems=[this._getMobileUndoButton(),this._getMobileHistoryArrowButton()];}return this._aMobileHistoryItems;};g1.prototype._getUndoButton=function(){if(!this._oHistoryButton){this._oHistoryButton=this._createUndoButton(this.getId()+"-undoButton");this.addDependent(this._oHistoryButton);}return this._oHistoryButton;};g1.prototype._getMobileUndoButton=function(){if(!this._oMobileHistoryButton){this._oMobileHistoryButton=this._createUndoButton(this.getId()+"-mobileUndoButton");this.addDependent(this._oMobileHistoryButton);}return this._oMobileHistoryButton;};g1.prototype._createUndoButton=function(i){var i1=this;return new b({id:i,type:X.Transparent,icon:f1.UNDO,enabled:{parts:["/history","/historyIndex"],formatter:function(j1,k1){return j1.length>1&&k1<j1.length-1;}},press:function(){i1._undo();},tooltip:G.getText("IMGEDITOR_PANEL_UNDO")});};g1.prototype._getHistoryArrowButton=function(){var i=this;if(!this._oHistoryArrowButton){this._oHistoryArrowButton=this._createHistoryArrowButton(this.getId()+"-historyButton",function(){i._resetValueStates();i._getHistoryPopover().openBy(i._oHistoryArrowButton);});this.addDependent(this._oHistoryArrowButton);}return this._oHistoryArrowButton;};g1.prototype._getMobileHistoryArrowButton=function(){var i=this;if(!this._oMobileHistoryArrowButton){this._oMobileHistoryArrowButton=this._createHistoryArrowButton(this.getId()+"-mobileHistoryButton",function(){i._resetValueStates();i._getHistoryPopover().openBy(i._oMobileHistoryArrowButton);});this.addDependent(this._oMobileHistoryArrowButton);}return this._oMobileHistoryArrowButton;};g1.prototype._createHistoryArrowButton=function(i,i1){return new b({id:i,type:X.Transparent,icon:f1.DROPDOWN,enabled:{path:"/history",formatter:function(j1){return j1.length>1;}},press:i1,tooltip:G.getText("IMGEDITOR_PANEL_HISTORY")});};g1.prototype._getZoomItems=function(){if(!this._aZoomItems){this._aZoomItems=[this._getZoomInButton(),this._getZoomLabel(),this._getZoomOutButton(),this._getZoomToFitButton()];}return this._aZoomItems;};g1.prototype._getZoomInButton=function(){if(!this._oZoomInButton){this._oZoomInButton=this._createZoomInButton(this.getId()+"-zoominButton");this.addDependent(this._oZoomInButton);}return this._oZoomInButton;};g1.prototype._getMobileZoomInButton=function(){if(!this._oMobileZoomInButton){this._oMobileZoomInButton=this._createZoomInButton(this.getId()+"-mobileZoominButton");this.addDependent(this._oMobileZoomInButton);}return this._oMobileZoomInButton;};g1.prototype._createZoomInButton=function(i){var i1=this;return new b({id:i,type:X.Transparent,icon:f1.ZOOMIN,press:function(){var j1=i1.getImageEditor();j1.zoomIn();i1._oModel.setProperty("/zoom",j1.getZoomLevel());i1._refreshCropAreaSize();},tooltip:G.getText("IMGEDITOR_PANEL_ZOOMIN")});};g1.prototype._getZoomLabel=function(){if(!this._oZoomLabel){this._oZoomLabel=this._createZoomLabel(this.getId()+"-zoomLabel");this.addDependent(this._oZoomLabel);}return this._oZoomLabel;};g1.prototype._getMobileZoomLabel=function(){if(!this._oMobileZoomLabel){this._oMobileZoomLabel=this._createZoomLabel(this.getId()+"-mobileZoomLabel");this.addDependent(this._oMobileZoomLabel);}return this._oMobileZoomLabel;};g1.prototype._createZoomLabel=function(i){return new L({id:i,text:{path:"/zoom",formatter:function(i1){return i1+"%";}}});};g1.prototype._getZoomOutButton=function(){if(!this._oZoomOutButton){this._oZoomOutButton=this._createZoomOutButton(this.getId()+"-zoomoutButton");this.addDependent(this._oZoomOutButton);}return this._oZoomOutButton;};g1.prototype._getMobileZoomOutButton=function(){if(!this._oMobileZoomOutButton){this._oMobileZoomOutButton=this._createZoomOutButton(this.getId()+"-mobileZoomoutButton");this.addDependent(this._oMobileZoomOutButton);}return this._oMobileZoomOutButton;};g1.prototype._createZoomOutButton=function(i){var i1=this;return new b({id:i,type:X.Transparent,icon:f1.ZOOMOUT,press:function(){var j1=i1.getImageEditor();j1.zoomOut();i1._oModel.setProperty("/zoom",j1.getZoomLevel());i1._refreshCropAreaSize();},tooltip:G.getText("IMGEDITOR_PANEL_ZOOMOUT")});};g1.prototype._getZoomToFitButton=function(){if(!this._oZoomToFit){this._oZoomToFit=this._createZoomToFitButton(this.getId()+"-zoomToFitButton");this.addDependent(this._oZoomToFit);}return this._oZoomToFit;};g1.prototype._getMobileZoomToFitButton=function(){if(!this._oMobileZoomToFit){this._oMobileZoomToFit=this._createZoomToFitButton(this.getId()+"-mobileZoomToFitButton");this.addDependent(this._oMobileZoomToFit);}return this._oMobileZoomToFit;};g1.prototype._createZoomToFitButton=function(i){var i1=this;return new b({id:i,type:X.Transparent,icon:f1.ZOOMFIT,press:i1._zoomToFit.bind(i1),tooltip:G.getText("IMGEDITOR_PANEL_ZOOMTOFIT")});};g1.prototype._getScaleSwitch=function(){if(!this._oScaleSwitch){this._oScaleSwitch=this._createScaleSwitch(this.getId()+"-scaleSwitch");this.addDependent(this._oScaleSwitch);}return this._oScaleSwitch;};g1.prototype._getMobileScaleSwitch=function(){if(!this._oMobileScaleSwitch){this._oMobileScaleSwitch=this._createScaleSwitch(this.getId()+"-mobileScaleSwitch");this.addDependent(this._oMobileScaleSwitch);}return this._oMobileScaleSwitch;};g1.prototype._createScaleSwitch=function(i){var i1=this;return new x({id:i,type:c1.AcceptReject,state:"{/crop/scaleCropArea}",visible:{path:"/mode",formatter:function(j1){return j1==="Crop";}},change:function(j1){i1._setScaleCropArea(j1.getParameter("state"));}}).addStyleClass("sapUiTinyMarginEnd");};g1.prototype._getScaleLabel=function(){if(!this._oScaleLabel){this._oScaleLabel=this._createScaleLabel(this.getId()+"-scaleLabel");this.addDependent(this._oScaleLabel);}return this._oScaleLabel;};g1.prototype._getMobileScaleLabel=function(){if(!this._oMobileScaleLabel){this._oMobileScaleLabel=this._createScaleLabel(this.getId()+"-mobileScaleLabel");this.addDependent(this._oMobileScaleLabel);}return this._oMobileScaleLabel;};g1.prototype._createScaleLabel=function(i){return new L({text:G.getText("IMGEDITOR_CROP_SCALE"),labelFor:i,visible:{path:"/mode",formatter:function(i1){return i1==="Crop";}}});};g1.prototype._getToolbarSeparator=function(){if(!this._oSeparator){this._oSeparator=new e({id:this.getId()+"-separator"});this.addDependent(this._oSeparator);}return this._oSeparator;};g1.prototype._getTransformButton=function(){if(!this._oTransformButton){this._oTransformButton=this._createTransformButton(this.getId()+"-transformButton");this.addDependent(this._oTransformButton);}return this._oTransformButton;};g1.prototype._getMobileTransformButton=function(){if(!this._oMobileTransformButton){this._oMobileTransformButton=this._createTransformButton(this.getId()+"-mobileTransformButton");this.addDependent(this._oMobileTransformButton);}return this._oMobileTransformButton;};g1.prototype._createTransformButton=function(i){return new c({id:i,icon:f1.TRANSFORM,type:X.Transparent,pressed:{path:"/mode",formatter:function(i1){return i1===Q.Transform;}},enabled:{path:"/mode",formatter:function(i1){return i1!==Q.Transform;}},press:this._onButtonPress.bind(this,this._setModeTransform.bind(this)),tooltip:G.getText("IMGEDITOR_PANEL_TRANSFORM")});};g1.prototype._getCropButton=function(){if(!this._oCropButton){this._oCropButton=this._createCropButton(this.getId()+"-cropButton");this.addDependent(this._oCropButton);}return this._oCropButton;};g1.prototype._getMobileCropButton=function(){if(!this._oMobileCropButton){this._oMobileCropButton=this._createCropButton(this.getId()+"-mobileCropButton");this.addDependent(this._oMobileCropButton);}return this._oMobileCropButton;};g1.prototype._createCropButton=function(i){return new c({id:i,icon:f1.CROP,type:X.Transparent,pressed:{path:"/mode",formatter:function(i1){return i1===Q.Crop;}},enabled:{path:"/mode",formatter:function(i1){return i1!==Q.Crop;}},press:this._onButtonPress.bind(this,this._setModeCrop.bind(this)),tooltip:G.getText("IMGEDITOR_PANEL_CROP")});};g1.prototype._getFilterButton=function(){if(!this._oFilterButton){this._oFilterButton=this._createFilterButton(this.getId()+"-filterButton");this.addDependent(this._oFilterButton);}return this._oFilterButton;};g1.prototype._getMobileFilterButton=function(){if(!this._oMobileFilterButton){this._oMobileFilterButton=this._createFilterButton(this.getId()+"-mobileFilterButton");this.addDependent(this._oMobileFilterButton);}return this._oMobileFilterButton;};g1.prototype._createFilterButton=function(i){return new c({id:i,icon:f1.FILTER,type:X.Transparent,pressed:{path:"/mode",formatter:function(i1){return i1===Q.Filter;}},enabled:{path:"/mode",formatter:function(i1){return i1!==Q.Filter;}},press:this._onButtonPress.bind(this,this._setModeFilter.bind(this)),tooltip:G.getText("IMGEDITOR_PANEL_FILTER")});};g1.prototype._getMobileApplyButton=function(){if(!this._oMobileApplyButton){this._oMobileApplyButton=new B({id:this.getId()+"-mobileApplyButton",text:G.getText("IMGEDITOR_APPLY"),type:X.Emphasized,press:this._applyPreview.bind(this)});}return this._oMobileApplyButton;};g1.prototype._changeOptionsPanelContent=function(i){var i1=this._getOptionsPanel();i1.removeAllItems();if(!this.getImageEditor()||!this.getImageEditor().getLoaded()||!i){return;}i().forEach(function(j1){i1.addItem(j1);});};g1.prototype._onButtonPress=function(i){this.getImageEditor()._cancelPreview();i();};g1.prototype._setModeTransform=function(i){this._changeOptionsPanelContent(this._getTransformPanelContent.bind(this));if(this.getImageEditor()){this.getImageEditor().setMode(P.Resize);}if(this.getMode()!==Q.Transform){this.setProperty("mode",Q.Transform,true);}this._setTransformTypeByKey(i||"Resize");this._oModel.setProperty("/mode",Q.Transform);};g1.prototype._setModeCrop=function(i){this._changeOptionsPanelContent(this._getCropPanelContent.bind(this));if(this.getImageEditor()){this._setCropTypeByKey(i||"Rectangle");}if(this.getMode()!==Q.Crop){this.setProperty("mode",Q.Crop,true);}this._oModel.setProperty("/mode",Q.Crop);this._setScaleCropArea(this._oModel.getProperty("/crop/scaleCropArea"));};g1.prototype._setModeFilter=function(){this._changeOptionsPanelContent(this._getFilterPanelContent.bind(this));if(this.getImageEditor()){this.getImageEditor().setMode(P.Default);}if(this.getMode()!==Q.Filter){this.setProperty("mode",Q.Filter,true);}this._resetFilterValues();this._selectFilterItem(0);this._oModel.setProperty("/mode",Q.Filter);};g1.prototype._constraintValue=function(i,i1,j1){var k1=j1.getBinding("value"),l1=j1.getBinding("valueState"),m1=j1.getBinding("valueStateText"),n1;if(isNaN(i)||i<i1.min||i>i1.max){n1=G.getText("IMGEDITOR_BAD_NUMBER",[i1.min,i1.max]);i=this._oModel.getProperty(k1.getPath());}if(n1){this._oModel.setProperty(l1.getPath(),V.Warning);this._oModel.setProperty(m1.getPath(),n1);}this._oModel.setProperty(k1.getPath(),i);j1.setValue(i);return i;};g1.prototype._onNumberInputChange=function(i,i1){var j1=i1.getParameter("value"),k1=i1.getParameter("newValue"),l1;this._resetValueStates();if(typeof j1==="number"){l1=j1;}else if(typeof k1==="number"){l1=k1;}else{l1=parseInt(i1.getParameter("value")||i1.getParameter("newValue"),10);}l1=this._constraintValue(l1,i,i1.getSource());this[i.callback](l1);};g1.prototype._setRatio=function(i,i1){if(!this.getImageEditor()||!this.getImageEditor().getLoaded()){return;}this.getImageEditor().setCropAreaByRatio(i,i1);this._refreshCropAreaSize();};g1.prototype._setCropAreaBySize=function(i,i1){this.getImageEditor().setCropAreaBySize(i,i1);this._refreshCropAreaSize();};g1.prototype._setRatioByKey=function(i){if(i==="Rectangle"){this._setRatio(this._oModel.getProperty("/crop/ratiosRectangle/1/width"),this._oModel.getProperty("/crop/ratiosRectangle/1/height"));}else if(i==="Ellipse"){this._setRatio(1,1);}else if(i==="CustomShape"&&this.getImageEditor().getCustomShapeLoaded()){this._setCustomShapeCropAreaRatio();}};g1.prototype._setCustomShapeCropAreaRatio=function(){this.getImageEditor().setCustomShapeCropAreaRatio();this._refreshCropAreaSize();};g1.prototype._setTransformTypeByKey=function(i){var i1=i==="Resize"?P.Resize:P.Default;if(i==="Resize"){this._refreshImageSize();this._selectResizeCustomSizeItem();}else if(i==="Rotate"){this._oModel.setProperty("/transform/rotate",0);}else if(i==="Flip"){this._resetFlips();}this._oModel.setProperty("/transform/selectedTypeKey",i);this._resetValueStates();if(this.getImageEditor()){this.getImageEditor()._cancelPreview();this.getImageEditor().setMode(i1);}};g1.prototype._setCropTypeByKey=function(i,i1){var j1=this._oModel.getProperty("/crop/types").filter(function(k1){return k1.key===i;})[0];this._setRatioByKey(i);this._oModel.setProperty("/crop/selectedTypeKey",i);this._oModel.setProperty("/crop/selectedType",j1);if(this["_select"+i+"CropCustomSizeItem"]){this["_select"+i+"CropCustomSizeItem"](i1);}this.getImageEditor().setMode("Crop"+i);this._resetValueStates();};g1.prototype._resetCurrentPanel=function(){this.getImageEditor().cancelPreview();switch(this.getMode()){case Q.Transform:{this._setTransformTypeByKey(this._oModel.getProperty("/transform/selectedTypeKey"));break;}case Q.Crop:{this._setCropTypeByKey(this._oModel.getProperty("/crop/selectedTypeKey"));break;}case Q.Filter:{this._selectFilterItem(this._getSelectedFilterIndex());break;}default:break;}this._resetValueStates();};g1.prototype._undo=function(){this.getImageEditor().undo();this._resetCurrentPanel();};g1.prototype._redo=function(){this.getImageEditor().redo();this._resetCurrentPanel();};g1.prototype._jumpToHistory=function(i){this.getImageEditor().jumpToHistory(i);this._resetCurrentPanel();};g1.prototype._setZoom=function(i){this._oModel.setProperty("/zoom",i);this.getImageEditor().zoom(i);this._refreshCropAreaSize();};g1.prototype._setWidth=function(i){this.getImageEditor().setWidth(i,true);this._oModel.setProperty("/transform/height",this.getImageEditor().getPreviewHeight());this._selectResizeCustomSizeItem(this.getImageEditor().getKeepResizeAspectRatio());};g1.prototype._setHeight=function(i){this.getImageEditor().setHeight(i,true);this._oModel.setProperty("/transform/width",this.getImageEditor().getPreviewWidth());this._selectResizeCustomSizeItem(this.getImageEditor().getKeepResizeAspectRatio());};g1.prototype._setSize=function(i,i1,j1){if(j1){i=this.getImageEditor().getWidth()*i;i1=this.getImageEditor().getHeight()*i1;}this._updateCurrentSize(i,i1);if(this.getImageEditor().getPreviewWidth()===i&&this.getImageEditor().getPreviewHeight()===i1){return;}this.getImageEditor().setSize(i,i1,true);};g1.prototype._rotate=function(i){i=i>I.LIMITS.ROTATION_MAX?I.LIMITS.ROTATION_MAX:i;i=i<I.LIMITS.ROTATION_MIN?I.LIMITS.ROTATION_MIN:i;this._oModel.setProperty("/transform/rotate",i);this.getImageEditor().rotate(i,true);};g1.prototype._flip=function(i,i1){this.getImageEditor().flip(i,i1,true);};g1.prototype._setKeepResizeAspectRatio=function(i){this._oModel.setProperty("/transform/keepAspectRatio",i);if(this.getImageEditor()){this.getImageEditor().setKeepResizeAspectRatio(i);}};g1.prototype._getKeepCropAspectRatio=function(){return this._oModel.getProperty("/crop/keepAspectRatio");};g1.prototype._setKeepCropAspectRatio=function(i){this._oModel.setProperty("/crop/keepAspectRatio",i);if(this.getImageEditor()){this.getImageEditor().setKeepCropAspectRatio(i);}};g1.prototype._setScaleCropArea=function(i){this._oModel.setProperty("/crop/scaleCropArea",i);if(this.getImageEditor()){this.getImageEditor().setScaleCropArea(i);}};g1.prototype._applyCurrentFilter=function(i){var i1=this._oModel.getProperty("/filter/selectedFilter");if(typeof i!=="undefined"){this._oModel.setProperty("/filter/selectedFilter/value",i);}this.getImageEditor()[i1.type](i1.value,true);};g1.prototype._resetFilterValues=function(){var i=this._oModel.getProperty("/filter/filters");i.forEach(function(i1,j1){this._oModel.setProperty("/filter/filters/"+j1+"/value",i1.defaultValue);},this);};g1.prototype._resetValueStates=function(){var i=["/transform/widthValueState","/transform/heightValueState","/transform/rotateValueState","/crop/widthValueState","/crop/heightValueState","/filter/filterValueState"];i.forEach(function(i1){this._oModel.setProperty(i1,V.None);},this);};g1.prototype._resetFlips=function(){this._oModel.setProperty("/transform/flipVertical",false);this._oModel.setProperty("/transform/flipHorizontal",false);};g1.prototype._applyPreview=function(){this.getImageEditor().applyPreview();this._resetValueStates();switch(this.getMode()){case Q.Transform:{switch(this._oModel.getProperty("/transform/selectedTypeKey")){case"Resize":{this._refreshImageSize();break;}case"Rotate":{this._oModel.setProperty("/transform/rotate",0);this._refreshImageSize();break;}case"Flip":{this._resetFlips();break;}default:break;}break;}case Q.Crop:{var i=this._oModel.getProperty("/crop/selectedType/apply");if(i){this.getImageEditor()[i]();}this._refreshImageSize();this._setRatioByKey(this._oModel.getProperty("/crop/selectedTypeKey"));this._deselectCropItem();this.getImageEditor().setMode(P.Default);break;}case Q.Filter:{this._resetFilterValues();break;}default:break;}};g1.prototype._createGridList=function(i,i1,j1){var k1=this;var l1=new p({width:"auto",mode:"SingleSelectMaster",itemPress:function(m1){k1._resetValueStates();j1.call(k1,m1);},items:{path:i,factory:i1.bind(this)}}).addStyleClass("sapSuiteUiCommonsImageEditorContainerGridList");l1.setModel(this._oModel);if(!l1._oItemNavigation){l1._startItemNavigation();}if(l1._oItemNavigation){l1._oItemNavigation.setColumns(2);}return l1;};g1.prototype._selectResizeCustomSizeItem=function(i){var i1=this._getResizeGridList(),j1=i1.getItems()[0];i1.setSelectedItem(j1);this._setKeepResizeAspectRatio(!!i);};g1.prototype._deselectCropItem=function(){this._getRectangleCropGridList().removeSelections();this._getEllipseCropGridList().removeSelections();this._disableCrop();};g1.prototype._disableCrop=function(){this._oModel.setProperty("/crop/enabled",false);};g1.prototype._enableCrop=function(){this._oModel.setProperty("/crop/enabled",true);};g1.prototype._selectRectangleCropCustomSizeItem=function(i){var i1=this._getRectangleCropGridList(),j1=i1.getItems()[0];i1.setSelectedItem(j1);this._setKeepCropAspectRatio(!!i);this._enableCrop();};g1.prototype._selectEllipseCropCustomSizeItem=function(i){var i1=this._getEllipseCropGridList(),j1=i1.getItems()[0];i1.setSelectedItem(j1);this._setKeepCropAspectRatio(!!i);this._enableCrop();};g1.prototype._selectCustomShapeCropCustomSizeItem=function(i){var i1=this._getCustomShapeCropGridList(),j1=i1.getItems()[0];i1.setSelectedItem(j1);this._setKeepCropAspectRatio(!!i);this._enableCrop();};g1.prototype._selectFilterItem=function(i){var i1=this._getFilterGridList(),j1=i1.getItems()[i];this._oModel.setProperty("/filter/selectedFilter",j1.getBindingContext().getProperty());this._oModel.setProperty("/filter/selectedFilter/value",this._oModel.getProperty("/filter/selectedFilter/defaultValue"));i1.setSelectedItem(j1);};g1.prototype._getSelectedFilterIndex=function(){var i=this._oModel.getProperty("/filter/selectedFilter"),i1=i?this._oModel.getProperty("/filter/filters").indexOf(i):0;return i1;};g1.prototype._getResizeGridList=function(){if(!this._oGridListResize){this._oGridListResize=this._createGridList("/transform/resizes",this._gridRectShapeItemFactory,this._onResizeGridListSelectionChange);}return this._oGridListResize;};g1.prototype._onResizeGridListSelectionChange=function(i){var i1=i.getParameter("listItem"),j1=i1.getBindingContext();if(j1.getProperty("width")){this._setSize(j1.getProperty("width"),j1.getProperty("height"),j1.getProperty("relative"));}this._setKeepResizeAspectRatio(!j1.getProperty("unlockRatio"));};g1.prototype._getRotateGridList=function(){if(!this._oGridListRotate){this._oGridListRotate=this._createGridList("/transform/rotates",this._gridRectShapeItemFactory,this._onRotateGridListSelectionChange);}return this._oGridListRotate;};g1.prototype._onRotateGridListSelectionChange=function(i){var i1=i.getParameter("listItem"),j1=i1.getBindingContext();this._getRotateGridList().removeSelections();this._rotate(this._oModel.getProperty("/transform/rotate")+j1.getProperty("rotate"));};g1.prototype._getFlipGridList=function(){if(!this._oGridListFlip){this._oGridListFlip=this._createGridList("/transform/flips",this._gridRectShapeItemFactory,this._onFlipGridListSelectionChange);}return this._oGridListFlip;};g1.prototype._onFlipGridListSelectionChange=function(i){var i1=i.getParameter("listItem"),j1=i1.getBindingContext(),k1=this._oModel.getProperty("/transform/flipVertical"),l1=this._oModel.getProperty("/transform/flipHorizontal");this._getFlipGridList().removeSelections();k1=k1!==j1.getProperty("flipVertical");l1=l1!==j1.getProperty("flipHorizontal");this._oModel.setProperty("/transform/flipVertical",k1);this._oModel.setProperty("/transform/flipHorizontal",l1);this._flip(k1,l1);};g1.prototype._getRectangleCropGridList=function(){if(!this._oGridListRectCrop){this._oGridListRectCrop=this._createGridList("/crop/ratiosRectangle",this._gridRectShapeItemFactory,this._onRectCropGridListSelectionChange);}return this._oGridListRectCrop;};g1.prototype._onRectCropGridListSelectionChange=function(i){var i1=i.getParameter("listItem");this._onGridListSelectionChange(i1,P.CropRectangle);};g1.prototype._getEllipseCropGridList=function(){if(!this._oGridListEllipseCrop){this._oGridListEllipseCrop=this._createGridList("/crop/ratiosCircle",this._gridCircleShapeItemFactory,this._onEllipseCropGridListSelectionChange);}return this._oGridListEllipseCrop;};g1.prototype._onEllipseCropGridListSelectionChange=function(i){var i1=i.getParameter("listItem");this._onGridListSelectionChange(i1,P.CropEllipse);};g1.prototype._getCustomShapeCropGridList=function(){if(!this._oGridListCustomShapeCrop){this._oGridListCustomShapeCrop=this._createGridList("/crop/ratiosCustomShape",this._gridRectShapeItemFactory,this._onCustomShapeCropGridListSelectionChange);this._oGridListCustomShapeCrop.setModel(this._oModel);}return this._oGridListCustomShapeCrop;};g1.prototype._onCustomShapeCropGridListSelectionChange=function(i){var i1=i.getParameter("listItem");this._onGridListSelectionChange(i1,P.CropCustomShape);};g1.prototype._onGridListSelectionChange=function(i,i1){var j1=i.getBindingContext(),k1=this.getImageEditor();k1.setMode(i1);if(j1.getProperty("callback")){this[j1.getProperty("callback")]();}if(j1.getProperty("width")&&j1.getProperty("relative")){this._setRatio(j1.getProperty("width"),j1.getProperty("height"));}else if(j1.getProperty("width")&&!j1.getProperty("relative")){this._setCropAreaBySize(j1.getProperty("width"),j1.getProperty("height"));}this._enableCrop();this._setKeepCropAspectRatio(!j1.getProperty("unlockRatio"));};g1.prototype._getFilterGridList=function(){if(!this._oGridListFilter){this._oGridListFilter=this._createGridList("/filter/filters",this._gridFilterItemFactory,this._onFilterGridListSelectionChange);}return this._oGridListFilter;};g1.prototype._onFilterGridListSelectionChange=function(i){var i1=i.getParameter("listItem"),j1=i1.getBindingContext();this._resetFilterValues();this._oModel.setProperty("/filter/selectedFilter",j1.getProperty());this.getImageEditor().cancelPreview();this.getImageEditor()[j1.getProperty("type")](j1.getProperty("value"),true);};g1.prototype._gridRectShapeItemFactory=function(i,i1){var j1;if(i1.getProperty("icon")){j1=new F({renderType:Z.Bare,alignItems:_.Center,justifyContent:$.Center,items:[new w({src:"{icon}"})]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerGridItemIcon");}else{j1=this._createGridItemRectShape(i1.getProperty("width"),i1.getProperty("height"));}return this._createGridListItem(j1);};g1.prototype._gridCircleShapeItemFactory=function(i,i1){var j1;if(i1.getProperty("icon")){j1=new F({renderType:Z.Bare,alignItems:_.Center,justifyContent:$.Center,items:[new w({src:"{icon}"})]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerGridItemIcon");}else{j1=this._createGridItemCircleShape(i1.getProperty("width"),i1.getProperty("height"));}return this._createGridListItem(j1);};g1.prototype._refreshGridListsItems=function(){var i=this,i1=[{path:"/transform/resizes",fnGetItems:this.getCustomResizeItems.bind(this)},{path:"/crop/ratiosRectangle",fnGetItems:this.getCustomRectangleCropItems.bind(this)},{path:"/crop/ratiosCircle",fnGetItems:this.getCustomEllipseCropItems.bind(this)}];this.getCustomResizeItems().forEach(function(j1){if(j1.getRelative()&&!j1.getIcon()){j1.setIcon(f1.RELATIVE);}});i1.forEach(function(j1){var k1=i._oModel.getProperty(j1.path),l1=k1.slice(0,h1.NUM_KEPT_ITEMS);j1.fnGetItems().forEach(function(m1){if(m1.getWidth()>0&&m1.getHeight()>0){l1.push({width:m1.getWidth(),height:m1.getHeight(),text:m1.getLabel(),icon:m1.getIcon(),relative:m1.getRelative()});}});i._oModel.setProperty(j1.path,l1);});};g1.prototype._createGridListItem=function(i){return new s({type:N.Active,content:[i,new L({text:"{text}",wrapping:false,textAlign:d1.Center,layoutData:[new t({growFactor:0,shrinkFactor:0,baseSize:"auto"})]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerGridItemLabel")]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerGridItem");};g1.prototype._createGridItemRectShape=function(i,i1){var j1,k1;if(i<100){i*=10;i1*=10;}else if(i>100){i/=10;i1/=10;}j1=document.createElementNS("http://www.w3.org/2000/svg","svg");j1.setAttribute("class","sapSuiteUiCommonsImageEditorContainerGridItemHeaderContent");j1.setAttribute("viewBox","-1 -1 "+(i+2)+" "+(i1+2));k1=document.createElement("rect");k1.setAttribute("x","0");k1.setAttribute("y","0");k1.setAttribute("width",i);k1.setAttribute("height",i1);j1.appendChild(k1);return new H({content:new XMLSerializer().serializeToString(j1)});};g1.prototype._createGridItemCircleShape=function(i,i1){var j1,k1;i*=100;i1*=100;j1=document.createElementNS("http://www.w3.org/2000/svg","svg");j1.setAttribute("class","sapSuiteUiCommonsImageEditorContainerGridItemHeaderContent");j1.setAttribute("viewBox","-"+(i+2)+" -"+(i1+2)+" "+(i*2+4)+" "+(i1*2+4));k1=document.createElement("ellipse");k1.setAttribute("cx","0");k1.setAttribute("cy","0");k1.setAttribute("rx",i);k1.setAttribute("ry",i1);j1.appendChild(k1);return new H({content:new XMLSerializer().serializeToString(j1)});};g1.prototype._gridFilterItemFactory=function(i,i1){var j1,k1,l1;k1=document.createElementNS("http://www.w3.org/2000/svg","svg");k1.setAttribute("class","sapSuiteUiCommonsImageEditorContainerGridItemHeaderContent sapSuiteUiCommonsImageEditorContainerGridItemHeaderFilterContent");l1=document.createElementNS("http://www.w3.org/2000/svg","use");l1.setAttribute("href","#"+this.getId()+"-origThumbnail");l1.setAttribute("filter","url(#"+this.getId()+"-"+i1.getProperty("type")+")");k1.appendChild(l1);j1=new H({content:new XMLSerializer().serializeToString(k1)});return this._createGridListItem(j1);};g1.prototype._getTransformPanelContent=function(){var i=this;if(!this._oTransformToolbarContent){this._oTransformToolbarContent=[new S({min:I.LIMITS.ROTATION_MIN,max:I.LIMITS.ROTATION_MAX,showAdvancedTooltip:true,visible:{path:"/transform/selectedTypeKey",formatter:function(i1){return i1==="Rotate";}},value:{path:"/transform/rotate",mode:"OneWay"},liveChange:this._onNumberInputChange.bind(this,e1.ROTATION),progress:true,ariaLabelledBy:[this.getId()+"-transformAngle"]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerMobileSlider"),new u({tabDensityMode:a1.Compact,backgroundDesign:b1.Transparent,headerBackgroundDesign:b1.Transparent,expandable:false,select:function(i1){var j1=i1.getParameter("key");i._setTransformTypeByKey(j1);},selectedKey:"{/transform/selectedTypeKey}",items:[new v({key:"Resize",text:G.getText("IMGEDITOR_RESIZE"),content:[this._getResizeGridList(),new F({renderType:Z.Bare,direction:Y.Column,items:[new F({renderType:Z.Bare,justifyContent:$.SpaceBetween,items:[new F({renderType:Z.Bare,direction:Y.Column,items:[new L({text:G.getText("IMGEDITOR_WIDTH"),labelFor:this.getId()+"-transformWidth"}),new g({id:this.getId()+"-transformWidth",type:K.Number,textAlign:d1.Right,change:this._onNumberInputChange.bind(this,e1.WIDTH),value:{path:"/transform/width",type:"sap.ui.model.type.Integer",mode:"OneWay"},valueState:"{/transform/widthValueState}",valueStateText:"{/transform/widthValueStateText}",width:"5.9375rem",fieldWidth:"4.375rem",description:G.getText("IMGEDITOR_PX")})]}),new F({renderType:Z.Bare,direction:Y.Column,justifyContent:$.End,items:[new T({tooltip:G.getText("IMGEDITOR_LOCK_RATIO"),icon:f1.LOCK,type:X.Transparent,pressed:{path:"/transform/keepAspectRatio"},press:function(i1){i._resetValueStates();i.getImageEditor().setKeepResizeAspectRatio(i1.getParameter("pressed"));i._selectResizeCustomSizeItem(i1.getParameter("pressed"));}})]}),new F({renderType:Z.Bare,direction:Y.Column,items:[new L({text:G.getText("IMGEDITOR_HEIGHT"),labelFor:this.getId()+"-transformHeight"}),new g({id:this.getId()+"-transformHeight",type:K.Number,textAlign:d1.Right,change:this._onNumberInputChange.bind(this,e1.HEIGHT),value:{path:"/transform/height",type:"sap.ui.model.type.Integer",mode:"OneWay"},valueState:"{/transform/heightValueState}",valueStateText:"{/transform/heightValueStateText}",width:"5.9375rem",fieldWidth:"4.375rem",description:G.getText("IMGEDITOR_PX")})]})]}),new B({width:"50%",text:G.getText("IMGEDITOR_APPLY"),type:X.Emphasized,press:this._applyPreview.bind(this)})]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerPanelArea")]}),new v({key:"Rotate",text:G.getText("IMGEDITOR_ROTATE"),content:[this._getRotateGridList(),new F({renderType:Z.Bare,direction:Y.Column,items:[new L({id:this.getId()+"-transformAngle",text:G.getText("IMGEDITOR_TRANSFORM_ANGLE")}),new S({min:I.LIMITS.ROTATION_MIN,max:I.LIMITS.ROTATION_MAX,value:{path:"/transform/rotate",mode:"OneWay"},liveChange:this._onNumberInputChange.bind(this,e1.ROTATION),progress:true,ariaLabelledBy:[this.getId()+"-transformAngle"]}),new g({type:K.Number,textAlign:d1.Right,width:"50%",fieldWidth:"50%",description:G.getText("IMGEDITOR_TRANSFORM_DEG"),change:this._onNumberInputChange.bind(this,e1.ROTATION),value:{path:"/transform/rotate",type:"sap.ui.model.type.Integer",mode:"OneWay"},valueState:"{/transform/rotateValueState}",valueStateText:"{/transform/rotateValueStateText}",ariaLabelledBy:[this.getId()+"-transformAngle"]}),new B({width:"50%",text:G.getText("IMGEDITOR_APPLY"),type:X.Emphasized,press:this._applyPreview.bind(this)})]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerPanelArea")]}),new v({key:"Flip",text:G.getText("IMGEDITOR_FLIP"),content:[this._getFlipGridList(),new F({renderType:Z.Bare,direction:Y.Column,items:[new B({width:"50%",text:G.getText("IMGEDITOR_APPLY"),type:X.Emphasized,press:this._applyPreview.bind(this)})]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerPanelArea")]})]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerTabBar")];this._oTransformToolbarContent.forEach(function(i1){this.addDependent(i1);},this);}return this._oTransformToolbarContent;};g1.prototype._onCropSizeInputChange=function(i,i1){var j1=this._oModel.getProperty("/crop/width"),k1=this._oModel.getProperty("/crop/height"),l1=this._getKeepCropAspectRatio(),m1,n1,o1,p1,q1,r1=parseInt(i1.getParameter("value"),10);r1=isNaN(r1)?0:r1;if(i==="width"){o1=j1;m1=r1;n1=l1?m1*k1/j1:k1;q1=this.getImageEditor()._getMaxCropAreaWidth(true);p1=this.getImageEditor()._getMinCropAreaWidth(true);}else{o1=k1;n1=r1;m1=l1?n1*j1/k1:j1;q1=this.getImageEditor()._getMaxCropAreaHeight(true);p1=this.getImageEditor()._getMinCropAreaHeight(true);}this._resetValueStates();if(r1>q1||r1<p1){i1.getSource().setValue(o1);this._oModel.setProperty("/crop/"+i+"ValueState",V.Warning);this._oModel.setProperty("/crop/"+i+"ValueStateText",G.getText("IMGEDITOR_BAD_NUMBER",[p1,q1]));}else{this._setCropAreaBySize(m1,n1);}};g1.prototype._getCropPanelContent=function(){var i=this;if(!this._oCropToolbarContent){this._oCropToolbarContent=[new u({tabDensityMode:a1.Compact,backgroundDesign:b1.Transparent,headerBackgroundDesign:b1.Transparent,expandable:false,select:function(i1){var j1=i1.getParameter("key");i._setCropTypeByKey(j1);},selectedKey:"{/crop/selectedTypeKey}",items:[new v({tooltip:G.getText("IMGEDITOR_CROP_RECTANGLE"),key:"Rectangle",text:"\ue17b",content:[this._getRectangleCropGridList()]}),new v({tooltip:G.getText("IMGEDITOR_CROP_ELLIPSE"),key:"Ellipse",text:"\ue255",content:[this._getEllipseCropGridList()]}),new v({tooltip:G.getText("IMGEDITOR_CROP_CUSTOM"),key:"CustomShape",text:"\ue057",content:[this._getCustomShapeCropGridList(),this._getCustomShapeCropContent()]})]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerTabBar").addStyleClass("sapSuiteUiCommonsImageEditorContainerFilterIcons"),new F({renderType:Z.Bare,direction:Y.Column,items:[new F({renderType:Z.Bare,justifyContent:$.SpaceBetween,items:[new F({renderType:Z.Bare,direction:Y.Column,items:[new L({text:G.getText("IMGEDITOR_WIDTH"),labelFor:this.getId()+"-cropWidth"}),new g({id:this.getId()+"-cropWidth",type:K.Number,textAlign:d1.Right,value:{path:"/crop/width",mode:"OneWay",type:"sap.ui.model.type.Integer"},valueState:"{/crop/widthValueState}",valueStateText:"{/crop/widthValueStateText}",width:"5.9375rem",fieldWidth:"4.375rem",description:G.getText("IMGEDITOR_PX"),change:this._onCropSizeInputChange.bind(this,"width"),enabled:{parts:["/crop/selectedTypeKey","/crop/customShapeLoaded","/crop/enabled"],formatter:function(i1,j1,k1){return!(i1==="CustomShape"&&!j1)&&k1;}}})]}),new F({renderType:Z.Bare,direction:Y.Column,justifyContent:$.End,items:[new T({tooltip:G.getText("IMGEDITOR_LOCK_RATIO"),icon:f1.LOCK,type:X.Transparent,pressed:{path:"/crop/keepAspectRatio"},press:function(i1){var j1=i.getImageEditor().getMode(),k1,l1;i._resetValueStates();if(i._oModel.getProperty("/crop/selectedTypeKey")==="Rectangle"){k1=P.CropRectangle;l1=i._selectRectangleCropCustomSizeItem.bind(i);}else if(i._oModel.getProperty("/crop/selectedTypeKey")==="Ellipse"){k1=P.CropEllipse;l1=i._selectEllipseCropCustomSizeItem.bind(i);}else{k1=P.CropCustomShape;l1=i._selectCustomShapeCropCustomSizeItem.bind(i);}if(j1!==k1){i.getImageEditor().setMode(k1);}if(l1){l1(i1.getParameter("pressed"));}}})]}),new F({renderType:Z.Bare,direction:Y.Column,items:[new L({text:G.getText("IMGEDITOR_HEIGHT"),labelFor:this.getId()+"-cropHeight"}),new g({id:this.getId()+"-cropHeight",type:K.Number,textAlign:d1.Right,value:{path:"/crop/height",mode:"OneWay",type:"sap.ui.model.type.Integer"},valueState:"{/crop/heightValueState}",valueStateText:"{/crop/heightValueStateText}",width:"5.9375rem",fieldWidth:"4.375rem",description:G.getText("IMGEDITOR_PX"),change:this._onCropSizeInputChange.bind(this,"height"),enabled:{parts:["/crop/selectedTypeKey","/crop/customShapeLoaded","/crop/enabled"],formatter:function(i1,j1,k1){return!(i1==="CustomShape"&&!j1)&&k1;}}})]})]}),new F({renderType:Z.Bare,alignItems:_.Center,items:[this._getScaleSwitch(),this._getScaleLabel()]}).addStyleClass("sapUiSmallMarginTopBottom"),new B({width:"50%",text:G.getText("IMGEDITOR_APPLY"),type:X.Emphasized,press:this._applyPreview.bind(this),enabled:{parts:["/crop/selectedTypeKey","/crop/customShapeLoaded","/crop/enabled"],formatter:function(i1,j1,k1){return!(i1==="CustomShape"&&!j1)&&k1;}}})]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerPanelArea")];this._oCropToolbarContent.forEach(function(i1){this.addDependent(i1);},this);}return this._oCropToolbarContent;};g1.prototype._getCustomShapeCropContent=function(){var i=this;if(!this.oCustomShapeContent){this.oCustomShapeContent=new F({renderType:Z.Bare,direction:Y.Column,items:[new L({text:G.getText("IMGEDITOR_CROP_CUSTOM_FILE"),labelFor:this.getId()+"-customFile"}),new A({id:this.getId()+"-customFile",mimeType:"image/*",change:function(i1){var j1=i1.getParameter("files")[0];if(!j1){return;}i._resetValueStates();i._enableCrop();i.getImageEditor().setMode(P.CropCustomShape);i.getImageEditor().setCustomShapeSrc(j1);}})]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerPanelArea").addStyleClass("sapSuiteUiCommonsImageEditorContainerPanelAreaMobile");this.addDependent(this.oCustomShapeContent);}return this.oCustomShapeContent;};g1.prototype._getFilterPanelContent=function(){var i=this;if(!this._oFilterToolbarContent){this._oFilterToolbarContent=[new S({min:"{/filter/selectedFilter/min}",max:"{/filter/selectedFilter/max}",showAdvancedTooltip:true,value:{path:"/filter/selectedFilter/value",mode:"OneWay"},liveChange:this._onNumberInputChange.bind(this,e1.FILTER),progress:true,ariaLabelledBy:[this.getId()+"-filterValue"]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerMobileSlider"),this._getFilterGridList(),new F({renderType:Z.Bare,direction:Y.Column,items:[new S({min:"{/filter/selectedFilter/min}",max:"{/filter/selectedFilter/max}",value:{path:"/filter/selectedFilter/value",mode:"OneWay"},liveChange:this._onNumberInputChange.bind(this,e1.FILTER),progress:true,ariaLabelledBy:[this.getId()+"-filterValue"]}),new L({id:this.getId()+"-filterValue",text:G.getText("IMGEDITOR_FILTER_VALUE")}),new g({type:K.Number,textAlign:d1.Right,width:"5.9375rem",fieldWidth:"4.375rem",description:"{/filter/selectedFilter/unit}",change:function(i1){i._onNumberInputChange(q.extend(e1.FILTER,i._oModel.getProperty("/filter/selectedFilter")),i1);},value:{path:"/filter/selectedFilter/value",type:"sap.ui.model.type.Integer",mode:"OneWay"},valueState:"{/filter/filterValueState}",valueStateText:"{/filter/filterValueStateText}",ariaLabelledBy:[this.getId()+"-filterValue"]}),new B({width:"50%",text:G.getText("IMGEDITOR_APPLY"),type:X.Emphasized,press:this._applyPreview.bind(this)})]}).addStyleClass("sapSuiteUiCommonsImageEditorContainerPanelArea")];this._oFilterToolbarContent.forEach(function(i1){this.addDependent(i1);},this);}return this._oFilterToolbarContent;};g1.prototype._getOptionsPanel=function(){if(!this._oOptionsPanel){this._oOptionsPanel=new F({renderType:Z.Bare,direction:Y.Column});this._oOptionsPanel.addStyleClass("sapSuiteUiCommonsImageEditorContainerPanel");this._oOptionsPanel.setModel(this._oModel);this.addDependent(this._oOptionsPanel);}return this._oOptionsPanel;};g1.prototype.onkeydown=function(i){var i1=this;function j1(){return i1._oModel.getProperty("/historyIndex")<i1._oModel.getProperty("/history").length-1;}if(i.ctrlKey&&i.key!=="Control"&&i.shiftKey&&i.key!=="Shift"){switch(i.key){case"z":case"Z":if(j1()){this.getImageEditor().undo();if(j1()){this._getUndoButton().focus();}else{this._getHistoryArrowButton().focus();}}i.preventDefault();break;case"y":case"Y":if(this._oModel.getProperty("/historyIndex")>0){this.getImageEditor().redo();this._getUndoButton().focus();}i.preventDefault();break;case"h":case"H":if(this._oModel.getProperty("/history").length>1){this._getHistoryArrowButton().focus();this._getHistoryPopover().openBy(this._oHistoryArrowButton);}i.preventDefault();break;default:break;}}else if(i.ctrlKey&&i.key!=="Control"&&!i.shiftKey){switch(i.key){case"u":case"U":this._focusOnToolbar();i.preventDefault();break;case"g":case"G":this._focusOnPanel();i.preventDefault();break;case"i":case"I":this._focusOnImageEditor();i.preventDefault();break;case"e":case"E":this._setModeTransform("Resize");this._focusOnItem(this._getResizeGridList().getItems()[0]);i.preventDefault();break;case"r":case"R":this._setModeTransform("Rotate");this._focusOnItem(this._getRotateGridList().getItems()[0]);i.preventDefault();break;case"f":case"F":this._setModeTransform("Flip");this._focusOnItem(this._getFlipGridList().getItems()[0]);i.preventDefault();break;case"j":case"J":this._setModeCrop("Rectangle");this._focusOnItem(this._getRectangleCropGridList().getItems()[0]);i.preventDefault();break;case"s":case"S":this._setModeFilter();this._focusOnItem(this._getFilterGridList().getItems()[0]);i.preventDefault();break;case"Enter":this._applyPreview();break;default:break;}}else if(i.altKey&&i.key!=="Alt"){switch(i.key){case"Enter":this._switchFocusPanelImage();i.preventDefault();break;default:break;}}};g1.prototype._focusFirstTabbable=function(i){var i1=i.find(":tabbable").get(0);if(i1){i1.focus();}};g1.prototype._focusOnToolbar=function(){this._focusFirstTabbable(this._getHeaderToolbar().$());};g1.prototype._focusOnPanel=function(){this._focusFirstTabbable(this._getOptionsPanel().$());};g1.prototype._focusOnImageEditor=function(){this._focusFirstTabbable(this.getImageEditor().$());};g1.prototype._focusOnItem=function(i){if(i.getDomRef()){if(!this._getHistoryPopover().isOpen()){i.focus();}}else{var i1={onAfterRendering:function(){i.removeEventDelegate(i1);i.focus();if(i.getParent()&&i.getParent().isA("sap.m.List")){i.getParent()._startItemNavigation();}}};i.addEventDelegate(i1);}};g1.prototype._switchFocusPanelImage=function(){var i=document.activeElement;if(this._getOptionsPanel().getDomRef().contains(i)){this._focusOnImageEditor();}else{this._focusOnPanel();}};return g1;});
