/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/Object","./Group","./Node","./Line","sap/ui/events/KeyCodes","sap/ui/dom/containsOrEquals","sap/base/Log"],function(q,B,G,N,L,K,c,b){"use strict";var d={LEFT:"left",RIGHT:"right",UP:"up",DOWN:"down"};var r=/^on.*|setFocus|setItems$/;function w(k){var s,p=k.prototype;for(s in p){if(p.hasOwnProperty(s)&&(typeof p[s]==="function")&&r.test(s)){p[s]=e(p[s]);}}}function e(o){return function(){try{return o.apply(this,arguments);}catch(E){this._handleError(E);}return undefined;};}var f=B.extend("sap.suite.ui.commons.networkgraph.KeyboardNavigator",{constructor:function(g){B.apply(this,arguments);this._oGraph=g;this._aItems=[[]];this._iRows=0;this._iColumns=0;this._iPageSize=5;this._oFocus=null;this._oFocusPosition=null;this._oWrapperDom=null;}});f.prototype.getFocus=function(){var g=this._oGraph.getFocus();if(this._oFocus!==g){this._oFocus=g?{item:g.item,button:g.button}:null;this._oFocusPosition=null;}return this._oFocus?{item:this._oFocus.item,button:this._oFocus.button}:null;};f.prototype.getFocusPosition=function(){var F=this.getFocus();if(!this._oFocusPosition){var x,y;this._oFocusPosition={iX:null,iY:null};if(!F){return this._oFocusPosition;}for(y=0;y<this._aItems.length;y++){for(x=0;x<this._aItems[y].length;x++){if(this._aItems[y][x]===F.item){this._oFocusPosition={iX:x,iY:y};return this._oFocusPosition;}}}}return this._oFocusPosition;};f.prototype.setItems=function(i){this._aItems=i;this._iRows=i.length;this._iColumns=0;i.forEach(function(R){if(this._iColumns<R.length){this._iColumns=R.length;}},this);};f.prototype.setWrapperDom=function(D){this._oWrapperDom=D;};f.prototype.setPageSize=function(s){this._iPageSize=s;};f.prototype.onsapend=function(E){this._moveThroughMatrix(E,true,true);};f.prototype.onsaphome=function(E){this._moveThroughMatrix(E,true,false);};f.prototype.onsapendmodifiers=function(E){if(E.ctrlKey){this._moveThroughMatrix(E,false,true);}};f.prototype.onsaphomemodifiers=function(E){if(E.ctrlKey){this._moveThroughMatrix(E,false,false);}};f.prototype.onsappagedown=function(E){this._moveThroughMatrix(E,false,true,this._iPageSize);};f.prototype.onsappageup=function(E){this._moveThroughMatrix(E,false,false,this._iPageSize);};f.prototype.onsappagedownmodifiers=function(E){if(E.altKey){this._moveThroughMatrix(E,true,true,this._iPageSize);}};f.prototype.onsappageupmodifiers=function(E){if(E.altKey){this._moveThroughMatrix(E,true,false,this._iPageSize);}};f.prototype.onsapspace=function(E){if(this._oGraph.getFocusDomRef()===document.activeElement){this._selectElement(false);E.stopPropagation();E.preventDefault();}};f.prototype.onsapspacemodifiers=function(E){if(E.ctrlKey&&this._oGraph.getFocusDomRef()===document.activeElement){this._selectElement(true);E.stopPropagation();E.preventDefault();}};f.prototype.onsapenter=function(E){this._handleEnter();};f.prototype.onsaptabnext=function(E){this._handleTab(E,d.RIGHT);};f.prototype.onsaptabprevious=function(E){this._handleTab(E,d.LEFT);};f.prototype.onsapleft=function(E){this._handleArrow(E,d.LEFT);};f.prototype.onsapright=function(E){this._handleArrow(E,d.RIGHT);};f.prototype.onsapup=function(E){this._handleArrow(E,d.UP);};f.prototype.onsapdown=function(E){this._handleArrow(E,d.DOWN);};f.prototype.onkeydown=function(E){var i,o,F=this.getFocus();if(!F){return;}i=F.item;o=F.button;if(E.ctrlKey&&E.keyCode===K.A){this._onCtrlA(E);}else if(E.keyCode===K.F2){if(i instanceof N){if(i.hasVisibleActionButtons()){i._detailClick();}}else if(i instanceof L){i.getParent()._tooltip.openDetail({item:i,point:i._getArrowFragmentVector().apex});}else if(i instanceof G){i._openDetail();}E.stopPropagation();}else if(E.keyCode===K.F6){if(i&&o){F.button=null;this._oGraph.setFocus(F);}this._handleArrow(E,E.shiftKey?d.LEFT:d.RIGHT);}else if(E.keyCode===K.F7&&!E.shiftKey){if(i&&o){F.button=null;this._oGraph.setFocus(F);}}else if(E.ctrlKey&&(E.keyCode===K.DIGIT_0||E.keyCode===K.NUMPAD_0)){this._onCtrl0(E);}else if(E.ctrlKey&&(E.keyCode===K.PLUS||E.keyCode===K.NUMPAD_PLUS)){this._onCtrlPlus(E);}else if(E.ctrlKey&&(E.keyCode===K.SLASH||E.keyCode===K.NUMPAD_MINUS)){this._onCtrlMinus(E);}};f.prototype._handleEnter=function(){var i,o,F=this.getFocus();if(!F){return;}i=F.item;o=F.button;if(i instanceof N){if(o){this._oGraph._isUseNodeHtml()?q(o).trigger("click"):q(o).children().first().trigger("click");}else{i._mouseDown(false);if(!i.getSelected()){i.$().removeClass(i.HIGHLIGHT_CLASS);i._setStatusColors("");}}}else if(i instanceof L){var C=i._getArrowFragmentVector();i._click({ctrlKey:false,clientX:C.apex.x,clientY:C.apex.y,skipConversion:true});}else if(i instanceof G){if(o===G.BUTTONS.MENU){i._openDetail();}else if(o===G.BUTTONS.COLLAPSE){i._collapse();}else{i._openDetail();}}};f.prototype._handleTab=function(E,D){if(this._ignoreEvent(E)){return;}if(this._handleTabOverNodeWithButtons(E,D)||this._handleTabOverGroupWithButtons(E,D)){E.preventDefault();E.stopPropagation();return;}this._moveItemFocus(E,D);};f.prototype._handleTabOverNodeWithButtons=function(E,D){var F=this.getFocus(),I,$,a,A=false,g;if(!F){return false;}I=F.item;$=F.button;a=I&&I.getEnabledActionButtons?I.getEnabledActionButtons():[];if(!(I instanceof N)||!I.hasVisibleActionButtons()||a.length===0){return false;}if($){g=0;for(var i=0;i<a.length;i++){if(a[i].isEqualNode($)){g=i;break;}}if(D===d.RIGHT){if(g===(a.length-1)){return false;}else{this._setActionButtonFocus(a[g+1]);}A=true;}else if(D===d.LEFT){if(g===0){this._moveItemFocus(E,this.getFocusPosition());}else{this._setActionButtonFocus(a[g-1]);}A=true;}}else if(D===d.RIGHT){this._setActionButtonFocus(a[0]);A=true;}return A;};f.prototype._handleTabOverGroupWithButtons=function(E,D){var F=this.getFocus(),i,o;if(!F){return false;}i=F.item;o=F.button;if(i instanceof G){if(!o){o=G.BUTTONS.MENU;}if(o){if(o===G.BUTTONS.MENU){if(D===d.RIGHT){F.button=G.BUTTONS.COLLAPSE;this._oGraph.setFocus(F);return true;}else if(D===d.LEFT){return false;}}else if(o===G.BUTTONS.COLLAPSE){if(D===d.RIGHT){return false;}else if(D===d.LEFT){F.button=G.BUTTONS.MENU;this._oGraph.setFocus(F);return true;}}}}return false;};f.prototype._setActionButtonFocus=function(a){var F=this.getFocus();if(!F){return;}F.button=a;this._oGraph.setFocus(F);};f.prototype._selectElement=function(C){var F=this.getFocus(),i;if(!F){return;}i=F.item;if(i instanceof N){i.getParent()._selectNode({element:i,setFocus:false,renderActionButtons:false,preventDeselect:C});}else if(i instanceof L){i.getParent()._selectLine({element:i,setFocus:false,preventDeselect:C});}};f.prototype._moveThroughMatrix=function(E,R,t,T){var F=this.getFocus(),I,C,a,n,A=this.getFocusPosition().iX,g=this.getFocusPosition().iY;if(this._ignoreEvent(E)||!F){return;}I=F.item;a=0;T=T||Number.POSITIVE_INFINITY;do{for(var i=(R?A:g)+(t?1:-1);(t&&i<(R?this._iColumns:this._iRows))||(!t&&i>=0);i+=(t?1:-1)){C=(R&&g>=0&&g<this._iRows)||(!R&&A>=0&&A<this._iColumns)?this._aItems[R?g:i][R?i:A]:null;if(C&&a<T){n=C;a++;if(a>=T){break;}}}if(T<Number.POSITIVE_INFINITY&&a<T){if(R){if(t){A=-1;g++;}else{A=this._iColumns;g--;}}else if(t){A++;g=-1;}else{A--;g=this._iRows;}}}while(T<Number.POSITIVE_INFINITY&&a<T&&g>=-1&&g<=this._iRows&&A>=-1&&A<=this._iColumns);if(n&&n!==I){F.item=n;F.button=null;this._oGraph.setFocus(F);E.stopPropagation();}};f.prototype._handleArrow=function(E,D){if(this._ignoreEvent(E)||!this.getFocus()){return;}this._moveItemFocus(E,D,true);};f.prototype._moveItemFocus=function(E,D,s){var F,a=(D===d.LEFT&&E.key==="Tab"),p,n,g;if(typeof D==="string"){p=this._findNextPosition(D);}else{p=D;}n=this._getItemAtPosition(p);F={item:n,button:null};if(a&&n!==null){if(n instanceof N&&n.hasVisibleActionButtons()){g=n.getEnabledActionButtons();if(g.length>0){F.button=g[g.length-1];}}else if(n instanceof G){F.button=G.BUTTONS.COLLAPSE;}}if(n||!s){this._oGraph.setFocus(F);}if(E&&n){E.preventDefault();E.stopPropagation();}};f.prototype._getItemAtPosition=function(p){var a;if(!p||p.iX===null){return null;}else{a=this._aItems[p.iY];return a?a[p.iX]:null;}};f.prototype._findNextPosition=function(D){var x,y;if(this.getFocusPosition().iX===null){if(D===d.LEFT){x=this._iColumns-1;y=this._iRows-1;}else{x=0;y=0;}if(this._aItems[y][x]!==null){return{iX:x,iY:y};}}else{x=this.getFocusPosition().iX;y=this.getFocusPosition().iY;}do{switch(D){case d.RIGHT:x+=1;if(x>=this._iColumns){y+=1;x=0;}break;case d.LEFT:x-=1;if(x<0){y-=1;x=this._iColumns-1;}break;case d.UP:y-=1;if(y<0&&x>0){x-=1;y=this._iRows-1;}break;case d.DOWN:y+=1;if(y>=this._iRows&&x<this._iColumns-1){x+=1;y=0;}break;default:throw new Error("Unexpected direction: "+D);}}while(y>=0&&y<this._iRows&&this._aItems[y][x]===null);if(y<0||y>=this._iRows){return null;}else{return{iX:x,iY:y};}};f.prototype._onCtrlA=function(E){if(this._ignoreEvent(E)){return;}var a=true;this._forEach(function(i){if(i instanceof G){return false;}if(!i.getSelected()){a=false;return true;}return false;});a=!a;this._forEach(function(i){if(!(i instanceof G)){i.setSelected(a);}});E.preventDefault();E.stopPropagation();};f.prototype._forEach=function(C){var x,y,i,a;for(y=0;y<this._iRows;y++){for(x=0;x<this._iColumns;x++){i=this._aItems[y][x];if(i){a=C.call(this,i,x,y);if(a){return;}}}}};f.prototype._onCtrl0=function(E){this._oGraph._zoom({zoomLevel:this._oGraph.ZOOM_100});E.preventDefault();E.stopPropagation();};f.prototype._onCtrlPlus=function(E){this._oGraph._zoom({deltaY:1});E.preventDefault();E.stopPropagation();};f.prototype._onCtrlMinus=function(E){this._oGraph._zoom({deltaY:-1});E.preventDefault();E.stopPropagation();};f.prototype._ignoreEvent=function(E){return!c(this._oWrapperDom,E.target);};f.prototype._handleError=function(E){b.error("An error in KeyboardNavigator: "+E);};w(f);return f;});
