/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/suite/ui/commons/library","./LayoutAlgorithm","./Geometry","./KlayWrapper","./LayoutTask","sap/ui/performance/Measurement"],function(l,L,G,K,a,M){"use strict";var O=l.networkgraph.Orientation,N=l.networkgraph.NodePlacement,b=l.networkgraph.LayoutRenderType;var c=34,d=25,e=17,f=4,g="N_",h="G_",i=2;var n=(function(){var m={};m[N.BrandesKoepf]="BRANDES_KOEPF";m[N.LinearSegments]="LINEAR_SEGMENTS";m[N.Simple]="SIMPLE";return Object.freeze(m);})();var j=L.extend("sap.suite.ui.commons.networkgraph.layout.LayeredLayout",{metadata:{library:"sap.suite.ui.commons",properties:{nodeSpacing:{type:"float",defaultValue:55},lineSpacingFactor:{type:"float",defaultValue:0.25},nodePlacement:{type:"sap.suite.ui.commons.networkgraph.NodePlacement",defaultValue:N.BrandesKoepf},mergeEdges:{type:"boolean",defaultValue:false}}}});j.prototype.getLayoutRenderType=function(){return b.LayeredWithGroups;};j.prototype.layout=function(){return new a(function(r,R,o){var k=this.getParent();if(!k){R("The algorithm must be associated with a graph.");return;}if(this._hasHierarchicalGroups()){R("Layered layout algorithm doesn't support hierarchical groups.");return;}this.oGraph=k;this.oKGraph={children:[],edges:[]};this.mLineMap={};M.start("NetworkGraph - LayeredLayout","Layouting of a graph "+k.getId());k.getGroups().forEach(this._addGroupToKlay,this);k.getNodes().forEach(this._addNodeToKlay,this);k.getLines().forEach(this._addLineToKlay,this);K.layout({graph:this.oKGraph,options:this._getOptions(),success:function(m){if(o.isTerminated()){r();return;}this._copyStuffWithoutPrefixes(m);m.children.forEach(function(p){this._extractNodeFromKlay(p);},this);m.edges.forEach(function(p){this._extractLineFromKlay(p);},this);this._dealWithOrientation();this._makeExpandedGroupsBoxesAroundNodes();this._shrinkGroupsDownward();this._stretchLinesToCircleNodeAxes();this._alignCoordinatesWithView();M.end("NetworkGraph - LayeredLayout");r();}.bind(this),error:function(m){R(m);}});}.bind(this));};j.prototype._buildNodeForKlay=function(o){var p={},I=o._isCircle();if(I||(o.getCoreNodeSize()&&o._isCustom())){var k=I?o._getCircleSize():o.getCoreNodeSize();if(this.oGraph.getOrientation()!==O.TopBottom&&this.oGraph.getOrientation()!==O.BottomTop){var B=o._iHeight-k+f;p={additionalPortSpace:"top="+f+", bottom="+B};}else{var s=(o._iWidth-k)/2+f;p={additionalPortSpace:"top="+s+", bottom="+s};}}return{id:g+o.getKey(),width:o._iWidth,height:o._iHeight,properties:p};};j.prototype._addGroupToKlay=function(o){if(o._isIgnored()){return;}var B=2*o._getBorderSize(),k={id:h+o.getKey(),width:o._iWidth+B,height:o._iHeight+B};this.oKGraph.children.push(k);if(!o.getCollapsed()){o.aNodes.forEach(function(m){if(!m._isIgnored()){if(!k.children){k.children=[];}k.children.push(this._buildNodeForKlay(m));}},this);}};j.prototype._addNodeToKlay=function(o){if(!o._oGroup&&!o._isIgnored()){this.oKGraph.children.push(this._buildNodeForKlay(o));}};j.prototype._addLineToKlay=function(o){var s,t,k;if(!o._isIgnored()){s=o.getFromNode()._oGroup&&o.getFromNode()._oGroup.getCollapsed()?h+o.getFromNode()._oGroup.getKey():g+o.getFrom();t=o.getToNode()._oGroup&&o.getToNode()._oGroup.getCollapsed()?h+o.getToNode()._oGroup.getKey():g+o.getTo();k=s+"->"+t+"["+this.oKGraph.edges.length+"]";this.oKGraph.edges.push({id:k,source:s,target:t});this.mLineMap[k]=o;}};j.prototype._getOptions=function(){var o=this.oGraph.getOrientation(),D;switch(o){case O.LeftRight:case O.RightLeft:D="RIGHT";break;case O.TopBottom:case O.BottomTop:D="DOWN";break;default:D="RIGHT";}return{direction:D,spacing:this.getNodeSpacing(),nodePlace:n[this.getNodePlacement()],edgeSpacingFactor:this.getLineSpacingFactor(),mergeEdges:this.getMergeEdges()};};j.prototype._extractNodeFromKlay=function(k){var I=k.id.substring(0,i)===g?this.oGraph.getNodeByKey(k.originalId):undefined,o;if(!I){I=this.oGraph.mGroups[k.originalId];if(I&&!I.getCollapsed()&&k.children){k.children.forEach(function(m){o=this.oGraph.getNodeByKey(m.originalId);if(o){o.setX(Math.round(m.x+k.x));o.setY(Math.round(m.y+k.y));}},this);}}if(I){I.setX(Math.round(k.x));I.setY(Math.round(k.y));}};j.prototype._extractLineFromKlay=function(k){var o=this.mLineMap[k.id];o.setSource({x:Math.round(k.sourcePoint.x),y:Math.round(k.sourcePoint.y)});o.setTarget({x:Math.round(k.targetPoint.x),y:Math.round(k.targetPoint.y)});o.clearBends();if(k.bendPoints){k.bendPoints.forEach(function(m){o.addBend({x:Math.round(m.x),y:Math.round(m.y)});});}if(o.getFromNode()._oGroup&&!o.getFromNode()._oGroup.getCollapsed()){o._shift({x:o.getFromNode()._oGroup.getX(),y:o.getFromNode()._oGroup.getY()});}};j.prototype._dealWithOrientation=function(){if((!this.oGraph._bIsRtl&&this.oGraph.getOrientation()===O.RightLeft)||(this.oGraph._bIsRtl&&this.oGraph.getOrientation()!==O.RightLeft)){this._verticalMirror(true);}if(this.oGraph.getOrientation()===O.BottomTop){this._horizontalMirror(true);}};j.prototype._makeExpandedGroupsBoxesAroundNodes=function(){var p=[],B;this.oGraph.getGroups().forEach(function(o){if(o.getCollapsed()||o.aNodes.length===0){return;}p=this._getNodesPoints(o.aNodes);B=G.getBoundingBox(p);G.enlargeBox(B,d);o.setX(Math.round(B.p1.x));o.setY(Math.round(B.p1.y-c));o._iWidth=B.p2.x-B.p1.x;o._iHeight=B.p2.y-B.p1.y+c;},this);};j.prototype._shrinkGroupsDownward=function(){var k;this.oGraph.getGroups().forEach(function(o){if(o.getCollapsed()){return;}o.aNodes.forEach(function(m){k=(o.getY()+o._iHeight-m.getY())/o._iHeight;m.setY(m.getY()+k);});o.setY(o.getY()+e);o._iHeight-=e;});};j.prototype._copyStuffWithoutPrefixes=function(k){k.children.forEach(function(o){o.originalId=o.id.substring(i);if(o.children){o.children.forEach(function(m){m.originalId=m.id.substring(i);});}});k.edges.forEach(function(o){o.originalSource=o.source.substring(i);o.originalTarget=o.target.substring(i);});};return j;});
