/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/thirdparty/jquery","../library","sap/ui/core/Control","sap/suite/ui/commons/util/HtmlElement","sap/suite/ui/commons/statusindicator/util/ThemingUtil","sap/base/Log"],function(q,l,C,H,T,L){"use strict";var F=l.statusindicator.FillingType;var a=l.statusindicator.FillingDirectionType;var V=l.statusindicator.VerticalAlignmentType;var b=l.statusindicator.HorizontalAlignmentType;var S=C.extend("sap.suite.ui.commons.statusindicator.Shape",{metadata:{"abstract":true,library:"sap.suite.ui.commons",properties:{fullAnimationDuration:{type:"int",defaultValue:0},fillColor:{type:"sap.m.ValueCSSColor",defaultValue:"Neutral"},animationOnStartup:{type:"boolean",defaultValue:false},animationOnChange:{type:"boolean",defaultValue:true},animationOnStartupDelay:{type:"int",defaultValue:0},fillingDirection:{type:"sap.suite.ui.commons.statusindicator.FillingDirectionType",defaultValue:a.Up},fillingType:{type:"sap.suite.ui.commons.statusindicator.FillingType",defaultValue:F.Linear},fillingAngle:{type:"int",defaultValue:undefined},verticalAlignment:{type:"sap.suite.ui.commons.statusindicator.VerticalAlignmentType",defaultValue:V.Middle},horizontalAlignment:{type:"sap.suite.ui.commons.statusindicator.HorizontalAlignmentType",defaultValue:b.Middle}}},renderer:null});S.prototype.GRADIENT_ID="gradient";S.prototype.STOP_ID="stop";S.prototype.getDisplayedValue=function(){L.fatal("Must be overridden!");};S.prototype._setInitialValue=function(i){L.fatal("Must be overridden!");};S.prototype._updateDom=function(d,D){L.fatal("Must be overridden!");};S.prototype.init=function(){if(C.prototype.init){C.prototype.init.apply(this,arguments);}this._oAnimationPropertiesResolver=null;};S.prototype.onBeforeRendering=function(){if(C.prototype.onBeforeRendering){C.prototype.onBeforeRendering.apply(this,arguments);}this._clearBoundingBox();};S.prototype._getCssFillColor=function(){return T.resolveColor(this.getFillColor());};S.prototype._resolveFillColor=function(){return this._oAnimationPropertiesResolver.getColor(this,this.getDisplayedValue());};S.prototype._injectAnimationPropertiesResolver=function(A){this._oAnimationPropertiesResolver=A;};S.prototype.getDisplayedFillColor=function(d){return this._oAnimationPropertiesResolver.getColor(this,d);};S.prototype.getFullAnimationDuration=function(){return 250;};S.prototype._buildPreserveAspectRatioAttribute=function(){var r="x";switch(this.getHorizontalAlignment()){case b.Left:r+="Min";break;case b.Middle:r+="Mid";break;case b.Right:r+="Max";break;}r+="Y";switch(this.getVerticalAlignment()){case V.Top:r+="Min";break;case V.Middle:r+="Mid";break;case V.Bottom:r+="Max";break;}r+=" meet";return r;};S.prototype._getGradientElement=function(d){var g=new H(this.getFillingType()===F.Linear?"linearGradient":"radialGradient");g.setId(this._buildIdString(this.getId(),this.GRADIENT_ID));if(this.getFillingType()===F.Linear){var i=this.computeLinearFillingAngle();g.setAttribute("x1",i===90?1:0);g.setAttribute("y1",i===0?1:0);g.setAttribute("x2",i===270?1:0);g.setAttribute("y2",i===180?1:0);}var o=this._getDisplayedGradientOffset(d);var s=new H(this.STOP_ID);s.setAttribute("offset",o);s.setAttribute("stop-color","white");g.addChild(s);var e=new H(this.STOP_ID);e.setAttribute("offset",o);e.setAttribute("stop-color","transparent");g.addChild(e);return g;};S.prototype.getPolygonElement=function(d){var p=new H("polygon");p.setId(this._buildIdString(this.getId(),"polygon"));p.setAttribute("fill","white");return p;};S.prototype.computeLinearFillingAngle=function(){if(this.getFillingAngle()!==undefined){return this._getNormalizedFillingAngle();}switch(this.getFillingDirection()){case a.Up:return 0;case a.Down:return 180;case a.Left:return 90;case a.Right:return 270;default:L.error("Unknown FillingDirection '"+this.getFillingDirection()+"'");return 0;}};S.prototype._useGradientForAnimation=function(){var n=this._getNormalizedFillingAngle();var f=this.getFillingType();return f===F.Radial||(f===F.Linear&&(n===undefined||[0,90,180,270].indexOf(n)>-1));};S.prototype._getPolygonPoints=function(v){var r;switch(this.getFillingType()){case F.Linear:r=this._getPolygonPointsForLinearFilling(v);break;case F.Circular:r=this._getPolygonPointsForCircularFilling(v);break;default:L.error("Unknown FillingType '"+this.getFillingType()+"' given.");r=this._getPolygonPointsForLinearFilling(v);}r=r.map(function(p){p.x=Number(p.x.toFixed(3));p.y=Number(p.y.toFixed(3));return p;});return r;};S.prototype._getPolygonPointsForLinearFilling=function(v){var n=180-this._getNormalizedFillingAngle();var t=Math.tan(n*Math.PI/180);var B=this._getBoundingPoints();var s=B.start;var e=B.end;var d=s.y-(t*s.x);var f=e.y-(t*e.x);var k=d+((f-d)/100)*v;var x=s.x;var y=x*t+k;var g=s.y;var h=(g-k)/t;var r=[s,{x:x,y:y},{x:h,y:g}];return r;};S.prototype._getPolygonPointsForCircularFilling=function(v){var t=this,A=3.6*v,B=this._getBoundingBox(),p=[];var x,y,P;var s=c(B.x+B.width/2,B.y);var o=c(B.x+B.width/2,B.y+B.height/2);function d(f){var r=Object.assign({},f);if(t.getFillingDirection()===a.CounterClockwise){var X=f.x-o.x;r.x=o.x-X;}return r;}function e(A,i,f){var g=Math.tan((i-A)*Math.PI/180);return g*f/2;}p.push(s);if(0<A&&A<45){x=e(A,0,B.height);P=c(s.x-x,s.y);p.push(d(P));}if(45<=A){p.push(d(c(B.x+B.width,B.y)));}if(45<A&&A<135){y=e(A,90,B.width);P=c(B.x+B.width,B.y+B.height/2-y);p.push(d(P));}if(135<=A){p.push(d(c(B.x+B.width,B.y+B.height)));}if(135<A&&A<225){x=e(A,180,B.height);P=c(B.x+B.width/2+x,B.y+B.height);p.push(d(P));}if(225<=A){p.push(d(c(B.x,B.y+B.height)));}if(225<A&&A<315){y=e(A,270,B.width);P=c(B.x,B.y+B.height/2+y);p.push(d(P));}if(315<=A){p.push(d(c(B.x,B.y)));}if(315<A&&A<=360){x=e(A,360,B.height);P=c(B.x+B.width/2-x,B.y);p.push(d(P));}p.push(o);return p;};S.prototype._isFillingAngleInFirstQuadrant=function(){var A=this._getNormalizedFillingAngle();return 0<A&&A<90;};S.prototype._isFillingAngleInSecondQuadrant=function(){var A=this._getNormalizedFillingAngle();return 90<A&&A<180;};S.prototype._isFillingAngleInThirdQuadrant=function(){var A=this._getNormalizedFillingAngle();return 180<A&&A<270;};S.prototype._isFillingAngleInForthQuadrant=function(){var A=this._getNormalizedFillingAngle();return 270<A&&A<360;};S.prototype._getBoundingPoints=function(){var B=this._getBoundingBox();var s=B.x+B.width;var o=B.y+B.height;var e=B.x;var E=B.y;if(this._isFillingAngleInFirstQuadrant()){}else if(this._isFillingAngleInSecondQuadrant()){s=B.x+B.width;o=B.y;e=B.x;E=B.y+B.height;}else if(this._isFillingAngleInThirdQuadrant()){s=B.x;o=B.y;e=B.x+B.width;E=B.y+B.height;}else if(this._isFillingAngleInForthQuadrant()){s=B.x;o=B.y+B.height;e=B.x+B.width;E=B.y;}else{L.error("Invalid call of _getBoundingPoints. FillingAngle '"+this.getFillingAngle()+"' is not in any quadrant");}return{start:c(s,o),end:c(e,E)};};S.prototype._getBoundingBox=function(){if(!this._oBoundingBox){this._oBoundingBox=this.$()[0].getBBox();}return this._oBoundingBox;};S.prototype._clearBoundingBox=function(){this._oBoundingBox=null;};S.prototype._getNormalizedFillingAngle=function(){if(this.getFillingAngle()===undefined){return this.getFillingAngle();}var r=this.getFillingAngle()%360;if(r<0){r+=360;}return r;};S.prototype.isFillable=function(){return this.getFillingType()!==F.None;};S.prototype._getDisplayedGradientOffset=function(d){if(this.isFillable()){var r=d/100;return r;}else{return 1;}};S.prototype._getMaskElement=function(m){var M=new H("mask");M.setId(m);if(this._useGradientForAnimation()){var o=this._getSimpleShapeElement(this._buildIdString(this.getId(),"mask-shape"));o.setAttribute("stroke-width",0);o.setAttribute("stroke","white");o.setAttribute("fill",this._buildSvgUrlString(this.getId(),this.GRADIENT_ID));M.addChild(o);}else{M.addChild(this.getPolygonElement(this._iDisplayedValue));}return M;};S.prototype._buildSvgUrlString=function(){return"url(#"+this._buildIdString.apply(this,arguments)+")";};S.prototype._buildIdString=function(){var s=q.makeArray(arguments).join("-");return s;};function c(x,y){return{x:x,y:y};}return S;});
