/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["../library","sap/m/library","sap/ui/core/Control","sap/ui/core/Core","sap/suite/ui/commons/statusindicator/util/AnimationPropertiesResolver","sap/suite/ui/commons/statusindicator/util/ThemingUtil","sap/m/Text","sap/base/Log","./StatusIndicatorRenderer"],function(l,s,C,c,A,T,d,L,S){"use strict";var f=l.statusindicator.SizeType;var g=l.statusindicator.LabelPositionType;var V=s.ValueColor;var h=C.extend("sap.suite.ui.commons.statusindicator.StatusIndicator",{metadata:{library:"sap.suite.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},value:{type:"int",defaultValue:0},viewBox:{type:"string",defaultValue:null},ariaLabel:{type:"string",defaultValue:null},size:{type:"sap.suite.ui.commons.statusindicator.SizeType",defaultValue:f.None},labelPosition:{type:"sap.suite.ui.commons.statusindicator.LabelPositionType",defaultValue:g.Left},showLabel:{type:"boolean",defaultValue:false}},defaultAggregation:"groups",aggregations:{groups:{type:"sap.suite.ui.commons.statusindicator.ShapeGroup",multiple:true},propertyThresholds:{type:"sap.suite.ui.commons.statusindicator.PropertyThreshold",multiple:true},discreteThresholds:{type:"sap.suite.ui.commons.statusindicator.DiscreteThreshold",multiple:true},label:{type:"sap.m.Text",multiple:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});h.prototype.init=function(){if(C.prototype.init){C.prototype.init.apply(this,arguments);}this._sortedPropertyThresholds=[];this._sortedDiscreteThresholds=[];this._bStarted=false;this._oCurrentAnimationPromise=null;this._oAnimationPropertiesResolver=new A(this);this._oDefaultLabel=null;if(!sap.ui.getCore().isInitialized()){sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};h.prototype._handleCoreInitialized=function(){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);};h.prototype._handleThemeApplied=function(){this.invalidate();};h.prototype._internalIds=Object.freeze({svgNodeId:"svg"});h.prototype.getLabel=function(){var o=this.getAggregation("label");if(o!==null){return o;}if(this._oDefaultLabel!==null){return this._oDefaultLabel;}this._oDefaultLabel=new d(this.getId()+"-label");this.addDependent(this._oDefaultLabel);return this._oDefaultLabel;};h.prototype.addPropertyThreshold=function(t){this.addAggregation("propertyThresholds",t,true);if(this._sortedPropertyThresholds.filter(function(e){return e.getToValue()===t.getToValue();}).length>0){L.fatal("There are two or more property thresholds with the same toValue in thresholds "+"aggregation. The last threshold from them has the highest priority");}this._sortedPropertyThresholds.push(t);this._sortedPropertyThresholds.sort(function(a,b){return a.getToValue()-b.getToValue();});return this;};h.prototype.addDiscreteThreshold=function(t){this.addAggregation("discreteThresholds",t,true);if(this._sortedDiscreteThresholds.filter(function(e){return e.getValue()===t.getValue();}).length>0){L.fatal("There are two or more discrete thresholds with the same value in thresholds "+"aggregation. The last threshold from them has the highest priority");}this._sortedDiscreteThresholds.push(t);this._sortedDiscreteThresholds.sort(function(a,b){return a.getValue()-b.getValue();});return this;};h.prototype._discreteThresholdsEnabled=function(){return this._sortedDiscreteThresholds.length>0;};h.prototype._getDiscreteThresholdForValue=function(v){var r=null;this._sortedDiscreteThresholds.every(function(t){if(v>=t.getValue()){r=t;return true;}return false;});return r;};h.prototype._propertyThresholdsEnabled=function(){return this._sortedPropertyThresholds.length>0;};h.prototype._getPropertyThresholdForValue=function(v){var r=null;this._sortedPropertyThresholds.some(function(t){if(v<=t.getToValue()){r=t;return true;}return false;});return r;};h.prototype._getFullId=function(i){return this.getId()+"-"+i;};h.prototype.onBeforeRendering=function(){var t=this;this.getGroups().forEach(function(G){G._injectAnimationPropertiesResolver(t._oAnimationPropertiesResolver);});};h.prototype.onAfterRendering=function(){this._setValueToLabel(this.getValue());this._start();};h.prototype._start=function(){this._bStarted=true;this._propagateValueToGroups();};h.prototype._shouldInvertGroupUpdateOrder=function(G){var t;G.some(function(o,I){t=I;return o.newValue!==100;});var i;this.getGroups().some(function(o,I){i=I;return!o._showsFullProgress();});return(t<i);};h.prototype._propagateValueToGroups=function(){var n=this.getSize()===f.Small;var G=this._computeGroupValueDistribution();var i=this._shouldInvertGroupUpdateOrder(G);if(i){G=G.reverse();}this._updateAccessibilityDOM();this._oCurrentAnimationPromise=G.reduce(function(a,o){return a.then(function(r){if(r&&r.cancelled){L.debug("Group animation cancelled.");return r;}else{return o.group._setValue(o.newValue,n);}});},Promise.resolve());return this._oCurrentAnimationPromise;};h.prototype._computeGroupValueDistribution=function(){var v=this.getValue();var t=this._getTotalWeight();return this.getGroups().map(function(G){var a=G.getWeight()/t;var n;if(v===0){n=0;}else if(v>=100*a){n=100;}else{n=v/a;}v-=n*a;return{group:G,newValue:Number(n.toFixed(3))};});};h.prototype.setValue=function(v){v=Math.round(v);if(v>100){v=100;}if(v<0){v=0;}this.setProperty("value",v,true);this._setValueToLabel(v);if(this._bStarted){this._propagateValueToGroups();}return this;};h.prototype._setValueToLabel=function(v){var o=this.getLabel();var a;o.setText(Math.floor(v)+"%");a=T.resolveColor(V.Neutral);if(this._propertyThresholdsEnabled()){var p=this._getPropertyThresholdForValue(v);if(p){a=p._getCssFillColor();}}var $=o.$();if($){$.css("color",a);}};h.prototype._getTotalWeight=function(){return this.getGroups().reduce(function(a,G){return a+G.getWeight();},0);};h.prototype.ontap=h.prototype.firePress;h.prototype.onsapenter=h.prototype.firePress;h.prototype.onsapspace=h.prototype.firePress;h.prototype._getGroupShapes=function(){return this.getGroups().reduce(function(a,G){return a.concat(G.getShapes());},[]);};h.prototype._updateAccessibilityDOM=function(){var v=this.getValue();this.$().attr("aria-valuenow",v);this.$().attr("aria-valuetext",this._createValueTextMessage(v));};h.prototype._createValueTextMessage=function(v){var D=null;var a=null;var p=null;var r=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.commons");if(this._discreteThresholdsEnabled()){var o=this._getDiscreteThresholdForValue(v);if(o){D=o.getAriaLabel();a=true;}else{D=this._sortedDiscreteThresholds[0].getAriaLabel();a=false;}}if(this._propertyThresholdsEnabled()){var P=this._getPropertyThresholdForValue(v);if(P){p=P.getAriaLabel();}}var b;if(D){if(p){if(a){b=r.getText("STATUS_INDICATOR_VALUE_ABOVE_THRESHOLD_COLOR",[v,D,p]);}else{b=r.getText("STATUS_INDICATOR_VALUE_BELOW_THRESHOLD_COLOR",[v,D,p]);}}else{if(a){b=r.getText("STATUS_INDICATOR_VALUE_ABOVE_THRESHOLD",[v,D]);}else{b=r.getText("STATUS_INDICATOR_VALUE_BELOW_THRESHOLD",[v,D]);}}}else if(p){b=r.getText("STATUS_INDICATOR_VALUE_COLOR",[v,p]);}else{b=r.getText("STATUS_INDICATOR_VALUE",[v]);}return b;};return h;});
