/*!
 * 
		SAP UI development toolkit for HTML5 (SAPUI5)
		(c) Copyright 2009-2015 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/base/Log"],function(L){"use strict";var D=function(){throw new Error();};D.resetDateToStartOfDay=function(d){if(D.isValidDate(d)){d.setHours(0);d.setMinutes(0);d.setSeconds(0);d.setMilliseconds(0);}};D.resetDateToEndOfDay=function(d){if(D.isValidDate(d)){d.setHours(23);d.setMinutes(59);d.setSeconds(59);d.setMilliseconds(999);}};D.resetDateToStartOfMonth=function(d){if(D.isValidDate(d)){d.setDate(1);D.resetDateToStartOfDay(d);}};D.resetDateToEndOfMonth=function(d){if(D.isValidDate(d)){d.setDate(1);d.setMonth(d.getMonth()+1);d.setDate(0);D.resetDateToEndOfDay(d);}};D.resetDateToStartOfYear=function(d){if(D.isValidDate(d)){d.setMonth(0);D.resetDateToStartOfMonth(d);}};D.resetDateToEndOfYear=function(d){if(D.isValidDate(d)){d.setMonth(11);D.resetDateToEndOfMonth(d);}};D.resetDateToStartOfWeek=function(d,f){if(D.isValidDate(d)){if(f===undefined){f=1;}else if(isNaN(f)||!isFinite(f)){L.error("DateUtils iFirstDayOfWeek value ='"+f+"' is invalid.");return;}d.setDate(d.getDate()-(d.getDay()-f+7)%7);D.resetDateToStartOfDay(d);}};D.resetDateToEndOfWeek=function(d,s){if(D.isValidDate(d)){var a;if(s&&!(s instanceof Object)){L.error("DateUtils oSettings is not an object.");return;}if(!s){s={};}if(s.iDuration===undefined){a=7;}else{a=s.iDuration;if(isNaN(a)||!isFinite(a)){L.error("DateUtils duration value ='"+a+"' is invalid.");return;}}D.resetDateToStartOfWeek(d,s.iFirstDayOfWeek);d.setDate(d.getDate()+a-1);D.resetDateToEndOfDay(d);}};D.isValidDate=function(d){if(Object.prototype.toString.call(d)!=="[object Date]"||isNaN(d.getTime())){L.error("DateUtils invalid date="+d);return false;}return true;};D.dateDaysEqual=function(d,a){if(D.isValidDate(d)&&D.isValidDate(a)){return(d.getFullYear()===a.getFullYear()&&d.getMonth()===a.getMonth()&&d.getDate()===a.getDate());}return false;};D.dateMonthsEqual=function(d,a){if(D.isValidDate(d)&&D.isValidDate(a)){return(d.getFullYear()===a.getFullYear()&&d.getMonth()===a.getMonth());}return false;};D.incrementDateByIndex=function(s,i){var r=null;if(D.isValidDate(s)&&isFinite(i)){r=new Date(s);r.setDate(s.getDate()+parseInt(i,10));}return r;};D.incrementMonthByIndex=function(s,i){var r=null;if(D.isValidDate(s)&&isFinite(i)){r=new Date(s);D.resetDateToStartOfMonth(r);r.setMonth(s.getMonth()+parseInt(i,10));}return r;};D.numberOfMonthsApart=function(s,e){s=new Date(s);e=new Date(e);D.resetDateToStartOfMonth(s);D.resetDateToStartOfMonth(e);var f=s.getTime()<=e.getTime();var F=0,b=0,n=0;for(F=0,b=0;!(s.getDate()===e.getDate()&&s.getMonth()===e.getMonth()&&s.getFullYear()===e.getFullYear());F++,b--){if(f){s.setMonth(s.getMonth()+1);}else{s.setMonth(s.getMonth()-1);}}if(f){n=F;}else{n=b;}return n;};D.numberOfDaysApart=function(s,e){s=new Date(s);e=new Date(e);D.resetDateToStartOfDay(s);D.resetDateToStartOfDay(e);var m=24*60*60*1000;var d=Math.round(Math.abs((s.getTime()-e.getTime())/m));if(s.getTime()>e.getTime()){return-d;}else{return d;}};D.parseDate=function(d,p){if(d instanceof Date||d===null){return d;}p=(p!==false);if(typeof d==="string"){var r=/Date\((-*\d+)\)/.exec(d);if(r===null){if(p){var a=Date.parse(d);if(!isNaN(a)){d=new Date(a);}else if(!isNaN(d)){d=new Date(parseInt(d,10));}}}else{d=new Date(parseInt(r[1],10));}}else{d=new Date(parseInt(d,10));}return d;};return D;},true);
