/*!
 * SAPUI5

(c) Copyright 2009-2019 SAP SE. All rights reserved
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/m/library","sap/ui/core/Control","sap/suite/ui/microchart/RadialMicroChartRenderer","sap/ui/Device","sap/ui/core/ResizeHandler","sap/base/Log","sap/ui/events/KeyCodes","sap/suite/ui/microchart/MicroChartUtils","./RadialMicroChartRenderer"],function(q,l,M,C,R,D,a,L,K,b){"use strict";var V=M.ValueColor;var c=C.extend("sap.suite.ui.microchart.RadialMicroChart",{constructor:function(i,s){var p;if(s&&typeof s.percentage==="number"){p=true;}else if(i&&typeof i.percentage==="number"){p=true;}else{p=false;}try{C.apply(this,arguments);this._bPercentageMode=p;}catch(e){this.destroy();throw e;}},metadata:{library:"sap.suite.ui.microchart",properties:{total:{group:"Data",type:"float",defaultValue:null},fraction:{group:"Data",type:"float",defaultValue:null},percentage:{group:"Data",type:"float",defaultValue:null},valueColor:{group:"Appearance",type:"sap.m.ValueCSSColor",defaultValue:"Neutral"},size:{group:"Misc",type:"sap.m.Size",defaultValue:"Auto"},width:{group:"Misc",type:"sap.ui.core.CSSSize"},height:{group:"Misc",type:"sap.ui.core.CSSSize"},alignContent:{group:"Misc",type:"sap.suite.ui.microchart.HorizontalAlignmentType",defaultValue:"Left"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});c.THRESHOLD_LOOK_XS=1.125;c.THRESHOLD_LOOK_S=3.5;c.THRESHOLD_LOOK_M=4.5;c.THRESHOLD_LOOK_L=5.875;c.THRESHOLD_WIDTH_NO_LABEL=6;c.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};c.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};c.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};c.prototype.onBeforeRendering=function(){if(!this._getPercentageMode()){if(this.getTotal()===0){L.info("Total cannot be 0. Please add a valid total value.");}else{this.setProperty("percentage",Math.round((this.getFraction()*100/this.getTotal())*10)/10,true);}}this._unbindMouseEnterLeaveHandler();};c.prototype.onAfterRendering=function(){this._bindMouseEnterLeaveHandler();this._sResizeHandlerId=a.register(this,this._onResize.bind(this));this._onResize();};c.prototype.ontouchstart=function(e){if(this.hasListeners("press")===true){e.setMarked();}};c.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}if(this.hasListeners("press")===true){e.setMarked();}this.firePress();};c.prototype.onkeydown=function(e){if(e.which===K.SPACE){if(this.hasListeners("press")===true){e.setMarked();}e.preventDefault();}};c.prototype.onkeyup=function(e){if(e.which===K.ENTER||e.which===K.SPACE){if(this.hasListeners("press")===true){e.setMarked();}this.firePress();e.preventDefault();}};c.prototype.attachEvent=function(e,d,f,g){C.prototype.attachEvent.call(this,e,d,f,g);if(e==="press"){this.rerender();}return this;};c.prototype.detachEvent=function(e,f,d){C.prototype.detachEvent.call(this,e,f,d);if(e==="press"){this.rerender();}return this;};c.prototype.exit=function(){this._deregisterResizeHandler();};c.prototype._getPercentageMode=function(){return this._bPercentageMode;};c.prototype.setPercentage=function(p){if(q.type(p)==="number"){var f=Math.floor(p*10)/10;this._bPercentageMode=true;if(f!==this.getPercentage()){this.setProperty("percentage",f);}}else{this._bPercentageMode=false;this.setProperty("percentage",null);}return this;};c.prototype._onResize=function(){var $=this.$(),i=$.height(),d=$.width(),o=$.find(".sapSuiteRMCOutsideLabel"),I=$.find(".sapSuiteRMCInsideLabel"),e=$.find(".sapSuiteRMCInnerContainer");$.removeClass("sapSuiteRMCLookL sapSuiteRMCLookM sapSuiteRMCLookS sapSuiteRMCLookXS");o.removeClass("sapSuiteRMCLabelHide");I.removeClass("sapSuiteRMCLabelHide");e.css("width",e.height());if(i<this.convertRemToPixels(c.THRESHOLD_LOOK_S)){$.addClass("sapSuiteRMCLookXS");I.addClass("sapSuiteRMCLabelHide");}else if(i<this.convertRemToPixels(c.THRESHOLD_LOOK_M)||d<this.convertRemToPixels(c.THRESHOLD_LOOK_M)){$.addClass("sapSuiteRMCLookS");o.addClass("sapSuiteRMCLabelHide");}else if(i<this.convertRemToPixels(c.THRESHOLD_LOOK_L)||d<this.convertRemToPixels(c.THRESHOLD_LOOK_L)){$.addClass("sapSuiteRMCLookM");o.addClass("sapSuiteRMCLabelHide");}else{$.addClass("sapSuiteRMCLookL");o.addClass("sapSuiteRMCLabelHide");}if(this._isAnyLabelTruncated(o)){o.addClass("sapSuiteRMCLabelHide");}if(this._isAnyLabelTruncated(I)){I.addClass("sapSuiteRMCLabelHide");}};c.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_RADIALMICROCHART");};c.prototype._isValueColorValid=function(){return V.hasOwnProperty(this.getValueColor());};c.prototype._isTooltipSuppressed=function(){var t=this.getTooltip_Text();if(t&&q.trim(t).length===0){return true;}else{return false;}};c.prototype._getAltHeaderText=function(i){var t=this._oRb.getText("RADIALMICROCHART");if(i){t+=" "+this._oRb.getText("IS_ACTIVE");}t+="\n";if(!this._hasData()){t+=this._oRb.getText("NO_DATA");return t;}var p=this.getPercentage();if(p>100){p=100;}else if(p<0){p=0;}if(this._isValueColorValid()){t+=this._oRb.getText("RADIALMICROCHART_ARIA_LABEL",[this.getPercentage(),this._getStatusText()]);}else{t+=this._oRb.getText("RADIALMICROCHART_PERCENTAGE_TEXT",p);}return t;};c.prototype._getStatusText=function(){var v=this.getValueColor();switch(v){case V.Error:return this._oRb.getText("SEMANTIC_COLOR_ERROR");case V.Critical:return this._oRb.getText("SEMANTIC_COLOR_CRITICAL");case V.Good:return this._oRb.getText("SEMANTIC_COLOR_GOOD");case V.Neutral:return this._oRb.getText("SEMANTIC_COLOR_NEUTRAL");default:return"";}};c.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};c.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};c.prototype._bindMouseEnterLeaveHandler=function(){this.$().bind("mouseenter.tooltip",this._addTitleAttribute.bind(this));this.$().bind("mouseleave.tooltip",this._removeTitleAttribute.bind(this));};c.prototype._unbindMouseEnterLeaveHandler=function(){this.$().unbind("mouseenter.tooltip");this.$().unbind("mouseleave.tooltip");};c.prototype._hasData=function(){return true;};c.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};c.prototype._deregisterResizeHandler=function(){if(this._sResizeHandlerId){a.deregister(this._sResizeHandlerId);this._sResizeHandlerId=null;}};b.extendMicroChart(c);return c;});
