//@ui5-bundle sap/suite/ui/microchart/library-preload.js
/*!
 * SAPUI5

(c) Copyright 2009-2019 SAP SE. All rights reserved
 */
sap.ui.predefine('sap/suite/ui/microchart/AreaMicroChart',["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/Device","sap/m/FlexBox","sap/suite/ui/microchart/MicroChartUtils","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/core/theming/Parameters","sap/m/library","sap/ui/core/ResizeHandler","./AreaMicroChartRenderer"],function(q,l,C,D,F,M,L,K,P,b,R){"use strict";var V=b.ValueColor;var S=b.Size;var A=l.AreaMicroChartViewType;
var c=C.extend("sap.suite.ui.microchart.AreaMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{size:{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{type:"sap.ui.core.CSSSize",group:"Misc"},maxXValue:{type:"float",group:"Misc",defaultValue:null},minXValue:{type:"float",group:"Misc",defaultValue:null},maxYValue:{type:"float",group:"Misc",defaultValue:null},minYValue:{type:"float",group:"Misc",defaultValue:null},view:{type:"sap.suite.ui.microchart.AreaMicroChartViewType",group:"Appearance",defaultValue:"Normal"},colorPalette:{type:"string[]",group:"Appearance",defaultValue:[]},showLabel:{type:"boolean",group:"Misc",defaultValue:true},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}},defaultAggregation:"lines",aggregations:{chart:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem",bindable:"bindable"},maxThreshold:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem"},innerMaxThreshold:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem"},innerMinThreshold:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem"},minThreshold:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem"},target:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartItem",bindable:"bindable"},firstXLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},firstYLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},lastXLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},lastYLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},maxLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},minLabel:{multiple:false,type:"sap.suite.ui.microchart.AreaMicroChartLabel"},lines:{multiple:true,type:"sap.suite.ui.microchart.AreaMicroChartItem",bindable:"bindable"}}}});
c.THRESHOLD_LOOK_XS=1.125;c.THRESHOLD_LOOK_S=3.5;c.THRESHOLD_LOOK_M=4.5;c.THRESHOLD_LOOK_L=5.875;c.THRESHOLD_WIDTH_NO_LABEL=6;c.THRESHOLD_WIDE_HEIGHT_NO_LABEL=2.25;c.ITEM_NEUTRAL_COLOR="sapSuiteAMCSemanticColorNeutral";c.ITEM_NEUTRAL_NOTHRESHOLD_CSSCLASS="sapSuiteAMCNeutralNoThreshold";c._CHARTITEM_AGGREGATIONS=["chart","target","minThreshold","maxThreshold","innerMinThreshold","innerMaxThreshold"];
c.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
c.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);sap.ui.getCore().attachLocalizationChanged(this._handleThemeApplied,this);};
c.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();};
c.prototype._getCssValues=function(){this._$CssHelper.className=Array.prototype.slice.call(arguments).join(" ");var s=window.getComputedStyle(this._$CssHelper);if(!s.backgroundColor){s.backgroundColor=s["background-color"];}if(!s.outlineStyle){s.outlineStyle=s["outline-style"];}if(!s.outlineWidth){s.outlineWidth=s["outline-width"];}return s;};
c.prototype.__fillThresholdArea=function(a,p,d,e){a.beginPath();a.moveTo(p[0].x,p[0].y);for(var i=1,f=p.length;i<f;i++){a.lineTo(p[i].x,p[i].y);}for(var j=d.length-1;j>=0;j--){a.lineTo(d[j].x,d[j].y);}a.closePath();a.fillStyle="white";a.fill();a.fillStyle=e;a.fill();a.lineWidth=1;a.strokeStyle="white";a.stroke();a.strokeStyle=e;a.stroke();};
c.prototype._renderDashedLine=function(a,p,d){if(a.setLineDash){a.setLineDash(d);this._renderLine(a,p);a.setLineDash([]);}else{a.beginPath();for(var i=0,e=p.length-1;i<e;i++){a._dashedLine(p[i].x,p[i].y,p[i+1].x,p[i+1].y,d);}a.stroke();}};
c.prototype._renderLine=function(a,p){a.beginPath();a.moveTo(p[0].x,p[0].y);for(var i=1,d=p.length;i<d;i++){a.lineTo(p[i].x,p[i].y);}a.stroke();};
c.prototype._getItemColor=function(a,t){var i;if(t&&this.getTarget()){i="sapSuiteAMCSemanticColor"+this.getTarget().getColor();}else if(!t&&this.getChart()){i="sapSuiteAMCSemanticColor"+this.getChart().getColor();}if((i===c.ITEM_NEUTRAL_COLOR)&&!this._isThresholdPresent(a)){return c.ITEM_NEUTRAL_NOTHRESHOLD_CSSCLASS;}else{return i;}};
c.prototype._isThresholdPresent=function(a){var t=[a.minThreshold.length,a.maxThreshold.length,a.innerMinThreshold.length,a.innerMaxThreshold.length];for(var i=0;i<t.length;i++){if(t[i]>1){return true;}}return false;};
c.prototype._renderTarget=function(a,d){if(d.target.length>1){var s=this._getItemColor(d,true);var o=this._getCssValues("sapSuiteAMCTarget",s);a.strokeStyle=o.color;a.lineWidth=parseFloat(o.width);if(o.outlineStyle=="dotted"){this._renderDashedLine(a,d.target,[parseFloat(o.outlineWidth),3]);}else{this._renderLine(a,d.target,d);}}else if(d.target.length==1){L.warning("Target is not rendered because only 1 point was given");}};
c.prototype._renderThresholdLine=function(a,p){if(p&&p.length){var s=this._getCssValues("sapSuiteAMCThreshold");a.strokeStyle=s.color;a.lineWidth=s.width;this._renderLine(a,p);}};
c.prototype._fillMaxThreshold=function(a,d){if(d.maxThreshold.length>1){var s=this._getCssValues("sapSuiteAMCThreshold","sapSuiteAMCSemanticColor"+this.getMaxThreshold().getColor());this.__fillThresholdArea(a,d.maxThreshold,[{x:d.maxThreshold[0].x,y:d.minY},{x:d.maxThreshold[d.maxThreshold.length-1].x,y:d.minY}],s.backgroundColor);this._renderThresholdLine(a,d.maxThreshold,d);}else if(d.maxThreshold.length==1){L.warning("Max Threshold is not rendered because only 1 point was given");}};
c.prototype._fillMinThreshold=function(a,d){if(d.minThreshold.length>1){var s=this._getCssValues("sapSuiteAMCThreshold","sapSuiteAMCSemanticColor"+this.getMinThreshold().getColor());this.__fillThresholdArea(a,d.minThreshold,[{x:d.minThreshold[0].x,y:d.maxY},{x:d.minThreshold[d.minThreshold.length-1].x,y:d.maxY}],s.backgroundColor);}else if(d.minThreshold.length==1){L.warning("Min Threshold is not rendered because only 1 point was given");}};
c.prototype._fillThresholdArea=function(a,d){if(d.minThreshold.length>1&&d.maxThreshold.length>1){var s=this._getCssValues("sapSuiteAMCThreshold","sapSuiteAMCSemanticColorCritical");this.__fillThresholdArea(a,d.maxThreshold,d.minThreshold,s.backgroundColor);}};
c.prototype._fillInnerThresholdArea=function(a,d){if(d.innerMinThreshold.length>1&&d.innerMaxThreshold.length>1){var s=this._getCssValues("sapSuiteAMCThreshold","sapSuiteAMCSemanticColor"+this.getInnerMaxThreshold().getColor());this.__fillThresholdArea(a,d.innerMaxThreshold,d.innerMinThreshold,s.backgroundColor);}else if(d.innerMinThreshold.length||d.innerMaxThreshold.length){L.warning("Inner threshold area is not rendered because inner min and max threshold were not correctly set");}};
c.prototype._renderChart=function(a,d){if(d.chart.length>1){var s=this._getItemColor(d);var o=this._getCssValues("sapSuiteAMCChart",s);a.strokeStyle=o.color;a.lineWidth=parseFloat(o.width);this._renderLine(a,d.chart,d);}else if(d.chart.length==1){L.warning("Actual values are not rendered because only 1 point was given");}};
c.prototype._renderLines=function(a,d){var e=this.getColorPalette().length,f=0,s=this._getCssValues("sapSuiteAMCLine"),g=d.lines.length;var n=function(h){if(e){if(f===e){f=0;}h=this.getColorPalette()[f++].trim();}if(V[h]){s=this._getCssValues("sapSuiteAMCLine","sapSuiteAMCSemanticColor"+h);return s.color;}return P.get(h)||h;}.bind(this);a.lineWidth=parseFloat(s.width);for(var i=0;i<g;i++){if(d.lines[i].length>1){a.strokeStyle=n(this.getLines()[i].getColor());this._renderLine(a,d.lines[i],d);}}};
c.prototype._renderCanvas=function(){if(!this._hasData()){return;}this._$CssHelper=this.getDomRef("css-helper");var $=this.$();var o=this.getDomRef("canvas");var a=window.getComputedStyle(o);var w=parseFloat(a.width);o.setAttribute("width",w||360);var h=parseFloat(a.height);o.setAttribute("height",h||242);var r=o.getContext("2d");r.lineJoin="round";r._dashedLine=this._drawDashedLine;var d=this._calculateDimensions(o.width,o.height);if(this._isThresholdPresent(d)){$.find(".sapSuiteAMCCanvasContainer").addClass("sapSuiteAMCWithThreshold");}this._fillMaxThreshold(r,d);this._fillMinThreshold(r,d);this._fillThresholdArea(r,d);this._renderThresholdLine(r,d.minThreshold,d);this._renderThresholdLine(r,d.maxThreshold,d);this._fillInnerThresholdArea(r,d);this._renderThresholdLine(r,d.innerMinThreshold,d);this._renderThresholdLine(r,d.innerMaxThreshold,d);this._renderTarget(r,d);this._renderChart(r,d);this._renderLines(r,d);};
c.prototype._drawDashedLine=function(x,y,a,d,e){var f=e.length;this.moveTo(x,y);var g=(a-x),h=(d-y),s=g?h/g:1e15,r=Math.sqrt(g*g+h*h),i=0,j=true;while(r>=0.1){var k=e[i++%f];if(k>r){k=r;}var m=Math.sqrt(k*k/(1+s*s));if(g<0){m=-m;}x+=m;y+=s*m;this[j?"lineTo":"moveTo"](x,y);r-=k;j=!j;}};
c.prototype._calculateDimensions=function(w,h){var m,f,d,e;function g(){if(!this._isMinXValue||!this._isMaxXValue||!this._isMinYValue||!this._isMaxYValue){var u=this.getLines();if(this.getMaxThreshold()){u.push(this.getMaxThreshold());}if(this.getMinThreshold()){u.push(this.getMinThreshold());}if(this.getChart()){u.push(this.getChart());}if(this.getTarget()){u.push(this.getTarget());}if(this.getInnerMaxThreshold()){u.push(this.getInnerMaxThreshold());}if(this.getInnerMinThreshold()){u.push(this.getInnerMinThreshold());}for(var i=0,v=u.length;i<v;i++){var x=u[i].getPoints();for(var k=0,a=x.length;k<a;k++){var y=x[k].getXValue();if(y>m||m===undefined){m=y;}if(y<d||d===undefined){d=y;}var z=x[k].getYValue();if(z>f||f===undefined){f=z;}if(z<e||e===undefined){e=z;}}}}if(this._isMinXValue){d=this.getMinXValue();}if(this._isMaxXValue){m=this.getMaxXValue();}if(this._isMinYValue){e=this.getMinYValue();}if(this._isMaxYValue){f=this.getMaxYValue();}}g.call(this);var r={minY:0,minX:0,maxY:h,maxX:w,lines:[]};var j;var n=m-d;if(n>0){j=w/n;}else if(n==0){j=0;r.maxX/=2;}else{L.warning("Min X is greater than max X.");}var o;var p=f-e;if(p>0){o=h/(f-e);}else if(p==0){o=0;r.maxY/=2;}else{L.warning("Min Y is greater than max Y.");}function s(a){var k=sap.ui.getCore().getConfiguration().getRTL();var u=function(N){var x=j*(N-d);if(k){x=r.maxX-x;}return x;};var v=function(x){return r.maxY-o*(x-e);};var y=[];if(a&&j!==undefined&&o!==undefined){var z=a.getPoints();var t=z.length;var B,E,G,H;if(t==1){G=z[0].getXValue();H=z[0].getYValue();if(G==undefined^H==undefined){var I,J;if(G==undefined){J=E=v(H);B=r.minX;I=r.maxX;}else{I=B=u(G);E=r.minY;J=r.maxY;}y.push({x:B,y:E},{x:I,y:J});}else{L.warning("Point with coordinates ["+G+" "+H+"] ignored");}}else{for(var i=0;i<t;i++){G=z[i].getXValue();H=z[i].getYValue();if(G!=undefined&&H!=undefined){B=u(G);E=v(H);y.push({x:B,y:E});}else{L.warning("Point with coordinates ["+G+" "+H+"] ignored");}}}}return y;}r.maxThreshold=s(this.getMaxThreshold());r.minThreshold=s(this.getMinThreshold());r.chart=s(this.getChart());r.target=s(this.getTarget());r.innerMaxThreshold=s(this.getInnerMaxThreshold());r.innerMinThreshold=s(this.getInnerMinThreshold());var t=this.getLines().length;for(var i=0;i<t;i++){r.lines.push(s(this.getLines()[i]));}return r;};
c.prototype.setMinXValue=function(v,s){this._isMinXValue=this._isNumber(v);return this.setProperty("minXValue",this._isMinXValue?v:NaN,s);};
c.prototype.setMaxXValue=function(v,s){this._isMaxXValue=this._isNumber(v);return this.setProperty("maxXValue",this._isMaxXValue?v:NaN,s);};
c.prototype.setMinYValue=function(v,s){this._isMinYValue=this._isNumber(v);return this.setProperty("minYValue",this._isMinYValue?v:NaN,s);};
c.prototype.setMaxYValue=function(v,s){this._isMaxYValue=this._isNumber(v);return this.setProperty("maxYValue",this._isMaxYValue?v:NaN,s);};
c.prototype._isNumber=function(n){return typeof n==="number"&&!isNaN(n)&&isFinite(n);};
c.prototype.onBeforeRendering=function(){if(this._bUseIndex){this._indexChartItems();}if(this._sChartResizeHandlerId){R.deregister(this._sChartResizeHandlerId);}this._unbindMouseEnterLeaveHandler();};
c.prototype.onAfterRendering=function(){l._checkControlIsVisible(this,this._onControlIsVisible);this._bindMouseEnterLeaveHandler();};
c.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true);}else{this.setProperty("isResponsive",false);}this.setProperty("size",s);}return this;};
c.prototype.setIsResponsive=function(i){var s,a=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=a===S.Responsive?S.Auto:a;}this.setProperty("size",s);return this;};
c.prototype._onControlIsVisible=function(){this._onResize();this._sChartResizeHandlerId=R.register(this,this._onResize.bind(this));};
c.prototype._indexChartItems=function(){var o,n=c._CHARTITEM_AGGREGATIONS.length;for(var i=0;i<n;i++){o=this.getAggregation(c._CHARTITEM_AGGREGATIONS[i]);if(o){this._indexChartItemPoints(o);}}};
c.prototype._indexChartItemPoints=function(a){var p=a.getPoints();for(var i=0;i<p.length;i++){p[i].setProperty("x",i,true);}};
c.prototype.enableXIndexing=function(u){this._bUseIndex=u;};
c.prototype._onResize=function(){var $=this.$(),i=parseInt($.width()),a=parseInt($.height()),m=$.find(".sapSuiteAMCPositionCenter"),t=$.find(".sapSuiteAMCPositionTop .sapSuiteAMCPositionLeft, .sapSuiteAMCPositionTop .sapSuiteAMCPositionRight,"+".sapSuiteAMCSideLabels .sapSuiteAMCLbl:first-child");$.removeClass("sapSuiteAMCNoLabels sapSuiteAMCLookM sapSuiteAMCLookS sapSuiteAMCLookXS sapSuiteAMCNoMinMaxLabels sapSuiteAMCNoTopLabels");if(i<=this.convertRemToPixels(c.THRESHOLD_WIDTH_NO_LABEL)){$.addClass("sapSuiteAMCNoLabels");}if(a<this.convertRemToPixels(c.THRESHOLD_WIDE_HEIGHT_NO_LABEL)){$.addClass("sapSuiteAMCLookXS");}else if(a<this.convertRemToPixels(c.THRESHOLD_LOOK_S)&&this.getView()===A.Normal){$.addClass("sapSuiteAMCLookXS");}else if(a<this.convertRemToPixels(c.THRESHOLD_LOOK_M)){$.addClass("sapSuiteAMCLookS");}else if(a<this.convertRemToPixels(c.THRESHOLD_LOOK_L)){$.addClass("sapSuiteAMCLookM");}if(this._isAnyLabelTruncated(t)||this._isAnyLabelVerticallyTruncated(t)){$.addClass("sapSuiteAMCNoMinMaxLabels");if(this._isAnyLabelTruncated(t)){$.removeClass("sapSuiteAMCNoMinMaxLabels");$.addClass("sapSuiteAMCNoTopLabels");}}if(this._isAnyLabelTruncated(m)){$.addClass("sapSuiteAMCNoMinMaxLabels");}this._renderCanvas();};
c.prototype._isLabelTruncated=function(a){var s;if(D.browser.msie||D.browser.edge){s=1;}else{s=0;}return a.offsetWidth<a.scrollWidth-s;};
c.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
c.prototype.onkeydown=function(e){if(e.which==K.SPACE){e.preventDefault();}};
c.prototype.onkeyup=function(e){if(e.which==K.ENTER||e.which==K.SPACE){this.firePress();e.preventDefault();}};
c.prototype.attachEvent=function(){C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};
c.prototype.detachEvent=function(){C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};
c.prototype._getLocalizedColorMeaning=function(a){return V[a]?this._oRb.getText(("SEMANTIC_COLOR_"+a).toUpperCase()):"";};
c.prototype._getAltHeaderText=function(I){var a=this._oRb.getText("AREAMICROCHART");if(I){a+=" "+this._oRb.getText("IS_ACTIVE");}if(!this._hasData()){a+="\n"+this._oRb.getText("NO_DATA");return a;}var f=this.getFirstXLabel();var o=this.getFirstYLabel();var d=this.getLastXLabel();var e=this.getLastYLabel();var m=this.getMinLabel();var g=this.getMaxLabel();var h=this.getChart();var t=this.getTarget();if(f&&f.getLabel()||o&&o.getLabel()){a+="\n"+this._oRb.getText(("AREAMICROCHART_START"))+": "+(f?f.getLabel():"")+" "+(o?o.getLabel()+" "+this._getLocalizedColorMeaning(o.getColor()):"");}if(d&&d.getLabel()||e&&e.getLabel()){a+="\n"+this._oRb.getText(("AREAMICROCHART_END"))+": "+(d?d.getLabel():"")+" "+(e?e.getLabel()+" "+this._getLocalizedColorMeaning(e.getColor()):"");}if(m&&m.getLabel()){a+="\n"+this._oRb.getText(("AREAMICROCHART_MINIMAL_VALUE"))+": "+m.getLabel()+" "+this._getLocalizedColorMeaning(m.getColor());}if(g&&g.getLabel()){a+="\n"+this._oRb.getText(("AREAMICROCHART_MAXIMAL_VALUE"))+": "+g.getLabel()+" "+this._getLocalizedColorMeaning(g.getColor());}if(h&&h.getPoints()&&h.getPoints().length>0){a+="\n"+this._oRb.getText(("AREAMICROCHART_ACTUAL_VALUES"))+":";var k=h.getPoints();for(var i=0;i<k.length;i++){a+=" "+k[i].getY();}}if(t&&t.getPoints()&&t.getPoints().length>0){a+="\n"+this._oRb.getText(("AREAMICROCHART_TARGET_VALUES"))+":";var T=t.getPoints();for(var j=0;j<T.length;j++){a+=" "+T[j].getY();}}return a;};
c.prototype._getAltSubText=function(i){var a="";for(var k=0;k<this.getLines().length;k++){var o=this.getLines()[k],s=o.getTooltip_AsString(),d="",t="";if(!s){continue;}if(o.getPoints()&&o.getPoints().length>0){t+=(i?"":"\n")+(o.getTitle()?o.getTitle():this._oRb.getText("AREAMICROCHART_LINE",[k+1]))+":";var e=o.getPoints();for(var y=0;y<e.length;y++){d+=" "+e[y].getY();}if(this.getColorPalette().length===0){d+=" "+this._getLocalizedColorMeaning(o.getColor());}}d=s.split("((AltText))").join(d);if(d){a+=t+d;i=false;}}return a;};
c.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_AREAMICROCHART");};
c.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments);o._isMinXValue=this._isMinXValue;o._isMaxXValue=this._isMaxXValue;o._isMinYValue=this._isMinYValue;o._isMaxYValue=this._isMaxYValue;return o;};
c.prototype.exit=function(){R.deregister(this._sChartResizeHandlerId);sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);sap.ui.getCore().detachLocalizationChanged(this._handleThemeApplied,this);};
c.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};
c.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};
c.prototype._bindMouseEnterLeaveHandler=function(){if(!this._oMouseEnterLeaveHandler){this._oMouseEnterLeaveHandler={mouseEnterChart:this._addTitleAttribute.bind(this),mouseLeaveChart:this._removeTitleAttribute.bind(this)};}this.$().bind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().bind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);};
c.prototype._unbindMouseEnterLeaveHandler=function(){if(this._oMouseEnterLeaveHandler){this.$().unbind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().unbind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);}};
c.prototype._hasData=function(){return this.getLines().length>0||this.getChart();};
c.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};
M.extendMicroChart(c);return c;});
sap.ui.predefine('sap/suite/ui/microchart/AreaMicroChartItem',["./library","sap/ui/core/Element"],function(l,E){"use strict";
var A=E.extend("sap.suite.ui.microchart.AreaMicroChartItem",{metadata:{library:"sap.suite.ui.microchart",properties:{color:{group:"Misc",type:"sap.m.ValueCSSColor",defaultValue:"Neutral"},title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"points",aggregations:{"points":{multiple:true,type:"sap.suite.ui.microchart.AreaMicroChartPoint",bindable:"bindable"}}}});
A.prototype.init=function(){this.setAggregation("tooltip","((AltText))",true);};
return A;});
sap.ui.predefine('sap/suite/ui/microchart/AreaMicroChartLabel',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var A=E.extend("sap.suite.ui.microchart.AreaMicroChartLabel",{metadata:{library:"sap.suite.ui.microchart",properties:{color:{group:"Misc",type:"sap.m.ValueCSSColor",defaultValue:"Neutral"},label:{type:"string",group:"Misc",defaultValue:""}}}});
return A;});
sap.ui.predefine('sap/suite/ui/microchart/AreaMicroChartPoint',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var A=E.extend("sap.suite.ui.microchart.AreaMicroChartPoint",{metadata:{library:"sap.suite.ui.microchart",properties:{x:{type:"float",group:"Misc",defaultValue:null},y:{type:"float",group:"Misc",defaultValue:null}}}});
A.prototype.setX=function(v,s){this._isXValue=this._isNumber(v);return this.setProperty("x",this._isXValue?v:NaN,s);};
A.prototype.setY=function(v,s){this._isYValue=this._isNumber(v);return this.setProperty("y",this._isYValue?v:NaN,s);};
A.prototype.getXValue=function(){return this._isXValue?this.getX():undefined;};
A.prototype.getYValue=function(){return this._isYValue?this.getY():undefined;};
A.prototype._isNumber=function(n){return typeof n=='number'&&!isNaN(n)&&isFinite(n);};
A.prototype.clone=function(i,L,o){var c=E.prototype.clone.apply(this,arguments);c._isXValue=this._isXValue;c._isYValue=this._isYValue;return c;};
return A;});
sap.ui.predefine('sap/suite/ui/microchart/AreaMicroChartRenderer',["./library","sap/suite/ui/microchart/MicroChartRenderUtils","sap/base/security/encodeXML"],function(l,M,e){"use strict";var A=l.AreaMicroChartViewType;var a={};
a.render=function(r,c){if(!c._bThemeApplied){return;}if(c._hasData()){var w=c.getView()===A.Wide;var s=c.getShowLabel();var S=(s&&((!w&&(c.getFirstYLabel()||c.getLastYLabel()))||c.getMaxLabel()));var b=(s&&((!w&&(c.getFirstXLabel()||c.getLastXLabel()))||c.getMinLabel()));var d=(s&&w&&(c.getFirstYLabel()||c.getFirstXLabel()));var f=(s&&w&&(c.getLastYLabel()||c.getLastXLabel()));r.write("<div");this._writeMainProperties(r,c);if(w){r.addClass("sapSuiteAMCWideMode");}r.writeStyles();r.writeClasses();r.write(">");r.write("<div");r.addClass("sapSuiteAMCVerticalAlignmentContainer");r.writeClasses();r.write(">");if(S){r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-top-labels");r.addClass("sapSuiteAMCLabels");r.addClass("sapSuiteAMCPositionTop");r.writeClasses();r.write(">");if(!w){this._writeLabel(r,c,c.getFirstYLabel(),"-top-left-lbl","sapSuiteAMCPositionLeft");}this._writeLabel(r,c,c.getMaxLabel(),"-top-center-lbl","sapSuiteAMCPositionCenter");if(!w){this._writeLabel(r,c,c.getLastYLabel(),"-top-right-lbl","sapSuiteAMCPositionRight");}r.write("</div>");}if(w){r.write("<div");r.addClass("sapSuiteAMCHorizontalContainer");r.writeClasses();r.write(">");}if(d){r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-left-labels");r.addClass("sapSuiteAMCSideLabels");r.addClass("sapSuiteAMCPositionLeft");r.writeClasses();r.write(">");this._writeLabel(r,c,c.getFirstYLabel(),"-top-left-lbl","sapSuiteAMCPositionLeft");this._writeLabel(r,c,c.getFirstXLabel(),"-btm-left-lbl","sapSuiteAMCPositionLeft");r.write("</div>");}r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-canvas-cont");r.addClass("sapSuiteAMCCanvasContainer");r.writeClasses();r.write(">");r.write("<canvas");r.writeAttributeEscaped("id",c.getId()+"-canvas");r.addClass("sapSuiteAMCCanvas");r.writeClasses();r.writeStyles();r.write("></canvas>");r.write("</div>");if(f){r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-right-labels");r.addClass("sapSuiteAMCSideLabels");r.addClass("sapSuiteAMCPositionRight");r.writeClasses();r.write(">");this._writeLabel(r,c,c.getLastYLabel(),"-top-right-lbl","sapSuiteAMCPositionRight");this._writeLabel(r,c,c.getLastXLabel(),"-btm-right-lbl","sapSuiteAMCPositionRight");r.write("</div>");}if(w){r.write("</div>");}if(b){r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-bottom-labels");r.addClass("sapSuiteAMCLabels");r.addClass("sapSuiteAMCPositionBtm");r.writeClasses();r.write(">");if(!w){this._writeLabel(r,c,c.getFirstXLabel(),"-btm-left-lbl","sapSuiteAMCPositionLeft");}this._writeLabel(r,c,c.getMinLabel(),"-btm-center-lbl","sapSuiteAMCPositionCenter");if(!w){this._writeLabel(r,c,c.getLastXLabel(),"-btm-right-lbl","sapSuiteAMCPositionRight");}r.write("</div>");}r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-css-helper");r.addStyle("display","none");r.writeStyles();r.write("></div>");r.write("</div>");r.write("</div>");}else{r.write("<div");this._writeMainProperties(r,c);r.writeClasses();r.writeStyles();r.write(">");this._renderNoData(r);r.write("</div>");}};
a._writeMainProperties=function(r,c){var i=c.hasListeners("press");this._renderActiveProperties(r,c);var s=c.getTooltip_AsString(i);r.writeAttribute("role","img");if(c.getAriaLabelledBy().length){r.writeAccessibilityState(c);}else{r.writeAttributeEscaped("aria-label",s);}r.writeControlData(c);r.addClass("sapSuiteAMC");r.addClass("sapSuiteAMCSize"+c.getSize());r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());};
a._writeLabel=function(r,c,L,i,C){if(!L){return;}var s=L?L.getLabel():"";r.write("<div");r.writeAttribute("id",c.getId()+i);r.addClass(e("sapSuiteAMCSemanticColor"+L.getColor()));r.addClass("sapSuiteAMCLbl");r.addClass(e(C));r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");};
M.extendMicroChartRenderer(a);return a;},true);
sap.ui.predefine('sap/suite/ui/microchart/BulletMicroChart',["sap/ui/thirdparty/jquery","./library","sap/m/library","sap/ui/core/Control","sap/m/FlexBox","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/events/KeyCodes","sap/m/Size","sap/suite/ui/microchart/MicroChartUtils","./BulletMicroChartRenderer"],function(q,l,M,C,F,D,R,K,S,a){"use strict";
var B=C.extend("sap.suite.ui.microchart.BulletMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{size:{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},mode:{type:"sap.suite.ui.microchart.BulletMicroChartModeType",group:"Misc",defaultValue:"Actual"},scale:{type:"string",group:"Misc",defaultValue:""},forecastValue:{type:"float",group:"Misc",defaultValue:null},targetValue:{type:"float",group:"Misc",defaultValue:null},minValue:{type:"float",group:"Misc",defaultValue:null},maxValue:{type:"float",group:"Misc",defaultValue:null},showActualValue:{type:"boolean",group:"Misc",defaultValue:true},showDeltaValue:{type:"boolean",group:"Misc",defaultValue:true},showActualValueInDeltaMode:{type:"boolean",group:"Misc",defaultValue:false},showTargetValue:{type:"boolean",group:"Misc",defaultValue:true},showValueMarker:{type:"boolean",group:"Misc",defaultValue:false},showThresholds:{type:"boolean",group:"Misc",defaultValue:true},actualValueLabel:{type:"string",group:"Misc",defaultValue:""},deltaValueLabel:{type:"string",group:"Misc",defaultValue:""},targetValueLabel:{type:"string",group:"Misc",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{type:"sap.ui.core.CSSSize",group:"Misc"},scaleColor:{type:"sap.suite.ui.microchart.CommonBackgroundType",group:"Misc",defaultValue:"MediumLight"},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},defaultAggregation:"actual",aggregations:{actual:{type:"sap.suite.ui.microchart.BulletMicroChartData",multiple:false,bindable:"bindable"},thresholds:{type:"sap.suite.ui.microchart.BulletMicroChartData",multiple:true,singularName:"threshold",bindable:"bindable"}},events:{press:{}}}});
B.THRESHOLD_SMALL_LABEL=3.5;B.THRESHOLD_BIG_LABEL=4.5;B.THRESHOLD_SMALL_LOOK=3.5;B.THRESHOLD_EXTRASMALL_LOOK=1.3125;B.THRESHOLD_THRESHOLDS=6;
B.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
B.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
B.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
B.prototype._calculateChartData=function(){var s=98,t=this.getThresholds(),c=[],T=this.getTargetValue(),f=this.getForecastValue(),A=this.getActual()&&this.getActual().getValue()?this.getActual().getValue():0,v=[],L=0,h=0,b=0,i;if(this.getActual()&&this.getActual()._isValueSet){v.push(A);}if(this._isForecastValueSet){v.push(f);}if(this._isTargetValueSet){v.push(T);}if(this._isMinValueSet){v.push(this.getMinValue());}if(this._isMaxValueSet){v.push(this.getMaxValue());}for(i=0;i<t.length;i++){v.push(t[i].getValue());}if(v.length>0){L=h=v[0];for(i=0;i<v.length;i++){if(v[i]<L){L=v[i];}if(v[i]>h){h=v[i];}}h=(h<0&&h<3*(L-h))?0:h;L=(L>0&&L>3*(h-L))?0:L;b=h-L;for(i=0;i<t.length;i++){c[i]={color:t[i].getColor(),valuePct:(!t[i]._isValueSet||b===0)?0:((t[i].getValue()-L)*s/b).toFixed(2)};}}var n,d;if(this.getMode()===l.BulletMicroChartModeType.Delta){n=(!this.getActual()||!this.getActual()._isValueSet||b===0)?49:(0.05+(A-L)*s/b).toFixed(2);d=(!this._isTargetValueSet||b===0)?49:((T-L)*s/b).toFixed(2);}else{n=(!this.getActual()||!this.getActual()._isValueSet||b===0||L===0&&this.getActual().getValue()===0)?0:(0.05+(A-L)*s/b).toFixed(2);d=(!this._isTargetValueSet||b===0)?0:((T-L)*s/b).toFixed(2);}return{actualValuePct:n,targetValuePct:d,forecastValuePct:(!this._isForecastValueSet||b===0)?0:((f-L)*s/b).toFixed(2),thresholdsPct:c,fScaleWidthPct:s};};
B.prototype._calculateDeltaValue=function(){if(!this.getActual()._isValueSet||!this._isTargetValueSet){return 0;}else{var A=this.getActual().getValue();var t=this.getTargetValue();return Math.abs(A-t).toFixed(Math.max(this._digitsAfterDecimalPoint(A),this._digitsAfterDecimalPoint(t)));}};
B.prototype.setMinValue=function(m){this._isMinValueSet=this._fnIsNumber(m);return this.setProperty("minValue",this._isMinValueSet?m:NaN);};
B.prototype.setMaxValue=function(m){this._isMaxValueSet=this._fnIsNumber(m);return this.setProperty("maxValue",this._isMaxValueSet?m:NaN);};
B.prototype.setTargetValue=function(t){this._isTargetValueSet=this._fnIsNumber(t);return this.setProperty("targetValue",this._isTargetValueSet?t:NaN);};
B.prototype.setForecastValue=function(f){this._isForecastValueSet=this._fnIsNumber(f);return this.setProperty("forecastValue",this._isForecastValueSet?f:NaN);};
B.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true);}else{this.setProperty("isResponsive",false);}this.setProperty("size",s,false);}return this;};
B.prototype.setIsResponsive=function(i){var s,c=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=c===S.Responsive?S.Auto:c;}this.setProperty("size",s);return this;};
B.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
B.prototype.onkeydown=function(e){if(e.which===K.SPACE){e.preventDefault();}};
B.prototype.onkeyup=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
B.prototype._fnIsNumber=function(v){return typeof v==='number'&&!isNaN(v)&&isFinite(v);};
B.prototype.attachEvent=function(e,d,f,L){C.prototype.attachEvent.call(this,e,d,f,L);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};
B.prototype.detachEvent=function(e,f,L){C.prototype.detachEvent.call(this,e,f,L);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};
B.prototype.onBeforeRendering=function(){if(this._sChartResizeHandlerId){R.deregister(this._sChartResizeHandlerId);}this._unbindMouseEnterLeaveHandler();};
B.prototype.onAfterRendering=function(){l._checkControlIsVisible(this,this._onControlIsVisible);this._bindMouseEnterLeaveHandler();};
B.prototype._onControlIsVisible=function(){this._onResize();this._sChartResizeHandlerId=R.register(this,this._onResize.bind(this));};
B.prototype._onResize=function(){var $=this.$(),c=parseInt($.css("height")),i=parseInt($.css("width"));if(this.getShowValueMarker()){this._adjustValueToMarker();}$.removeClass("sapSuiteBMCSmallFont sapSuiteBMCNoLabels sapSuiteBMCSmallLook sapSuiteBMCExtraSmallLook sapSuiteBMCThresholdHidden");if(c<=this.convertRemToPixels(B.THRESHOLD_EXTRASMALL_LOOK)){$.addClass("sapSuiteBMCExtraSmallLook");}else if(c<=this.convertRemToPixels(B.THRESHOLD_SMALL_LOOK)){$.addClass("sapSuiteBMCSmallLook");}if(c>=this.convertRemToPixels(B.THRESHOLD_SMALL_LABEL)&&c<=this.convertRemToPixels(B.THRESHOLD_BIG_LABEL)){$.addClass("sapSuiteBMCSmallFont");}if(c<this.convertRemToPixels(B.THRESHOLD_SMALL_LABEL)||this._isAnyChartLabelTruncated()){$.addClass("sapSuiteBMCNoLabels");}if(i<this.convertRemToPixels(B.THRESHOLD_THRESHOLDS)){$.addClass("sapSuiteBMCThresholdHidden");}this._adjustLabelsPos();};
B.prototype._isAnyChartLabelTruncated=function(){var L=this.$().find(".sapSuiteBMCItemValue, .sapSuiteBMCTargetValue");return this._isAnyLabelTruncated(L);};
B.prototype.exit=function(){R.deregister(this._sChartResizeHandlerId);};
B.prototype._adjustLabelsPos=function(){var r=sap.ui.getCore().getConfiguration().getRTL();var t=this.$("bc-target-bar-value");var c=this.$("chart-bar");var f=c.width();if(f){var T=0;if(t&&t.offset()){T=t.offset().left-c.offset().left;if(r){T=f-T;}this._adjustLabelPos(this.$("bc-target-value"),f,T,r);}var b=this.$("bc-bar-value");if(b&&b.offset()){var A=b.offset().left+b.width()-c.offset().left;if(r){A=f-(b.offset().left-c.offset().left);}if(this.getMode()===l.BulletMicroChartModeType.Delta){A=b.width();if(!this.getShowActualValueInDeltaMode()){A=A/2;}var s=this.getTargetValue()<this.getActual().getValue()?1:-1;A=t.offset().left-c.offset().left+(A*s);}this._adjustLabelPos(this.$("bc-item-value"),f,A,r);}}};
B.prototype._adjustLabelPos=function(L,f,o,r){var d=r?"right":"left";var b=L.width();if(b>f){L.css(d,"0");}else{var c=o-0.5*b;if(c<0){c=0;}if(c+b>f){c=f-b;}L.css(d,c);}};
B.prototype._adjustValueToMarker=function(){var v=this.$("bc-bar-value");var m=this.$("bc-bar-value-marker");var c=this.$().find(".sapSuiteBMCVerticalAlignmentContainer");if(v.offset()&&m.offset()){var V=v.width();var f=v.offset().left;var b=m.width();var d=m.offset().left;if(sap.ui.getCore().getConfiguration().getRTL()){if(d<f){m.css("right","");m.offset({left:f});}if(d+b>f+V){m.css("right","");m.offset({left:f+V-b});}}else{if(d<f){m.offset({left:f});}if(d+b>f+V){v.width((d+b-f)/c.width()*100+"%");}}}};
B.prototype._getLocalizedColorMeaning=function(c){return this._oRb.getText(("SEMANTIC_COLOR_"+c).toUpperCase());};
B.prototype._getAltHeaderText=function(i){var A=this._oRb.getText("BULLETMICROCHART");if(i){A+=" "+this._oRb.getText("IS_ACTIVE");}if(!this._hasData()){A+="\n"+this._oRb.getText("NO_DATA");return A;}var I=this.getActual()&&this.getActual()._isValueSet;var s=this.getScale();var t=this.getTargetValueLabel();var m=!this.getActual()||!this.getActual().getColor()?"":this._getLocalizedColorMeaning(this.getActual().getColor());if(I){var b=this.getActualValueLabel();var c=(b)?b:""+this.getActual().getValue();A+="\n"+this._oRb.getText("BULLETMICROCHART_ACTUAL_TOOLTIP",[c+s,m]);}if(this.getMode()===l.BulletMicroChartModeType.Delta){if(this._isTargetValueSet&&I){var d=this.getDeltaValueLabel();var e=(d)?d:""+this._calculateDeltaValue();A+="\n"+this._oRb.getText("BULLETMICROCHART_DELTA_TOOLTIP",[e+s,m]);}}else if(this._isForecastValueSet){A+=(this._isForecastValueSet)?"\n"+this._oRb.getText("BULLETMICROCHART_FORECAST_TOOLTIP",[this.getForecastValue()+s,m]):"";}if(this._isTargetValueSet){var T=(t)?t:""+this.getTargetValue();A+="\n"+this._oRb.getText("BULLETMICROCHART_TARGET_TOOLTIP",[T+s]);}return A;};
B.prototype._getAltSubText=function(I){var A="";var t=this.getThresholds().sort(function(f,o){return f.getValue()-o.getValue();});for(var i=0;i<t.length;i++){var T=t[i],s=T.getTooltip_AsString(),b="";if(!s){continue;}b+=(I?"":"\n")+this._oRb.getText("BULLETMICROCHART_THRESHOLD_TOOLTIP",[T.getValue()+this.getScale(),this._getLocalizedColorMeaning(T.getColor())]);b=s.split("((AltText))").join(b);if(b){A+=b;I=false;}}return A;};
B.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_BULLETMICROCHART");};
B.prototype.clone=function(i,L,o){var c=C.prototype.clone.apply(this,arguments);c._isMinValueSet=this._isMinValueSet;c._isMaxValueSet=this._isMaxValueSet;c._isForecastValueSet=this._isForecastValueSet;c._isTargetValueSet=this._isTargetValueSet;return c;};
B.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};
B.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};
B.prototype._bindMouseEnterLeaveHandler=function(){if(!this._oMouseEnterLeaveHandler){this._oMouseEnterLeaveHandler={mouseEnterChart:this._addTitleAttribute.bind(this),mouseLeaveChart:this._removeTitleAttribute.bind(this)};}this.$().bind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().bind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);};
B.prototype._unbindMouseEnterLeaveHandler=function(){if(this._oMouseEnterLeaveHandler){this.$().unbind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().unbind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);}};
B.prototype._hasData=function(){return this.getActual();};
B.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};
a.extendMicroChart(B);return B;});
sap.ui.predefine('sap/suite/ui/microchart/BulletMicroChartData',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var B=E.extend("sap.suite.ui.microchart.BulletMicroChartData",{metadata:{library:"sap.suite.ui.microchart",properties:{value:{type:"float",group:"Misc",defaultValue:"0"},color:{type:"sap.m.ValueColor",group:"Misc",defaultValue:"Neutral"}}}});
B.prototype.init=function(){this.setAggregation("tooltip","((AltText))",true);};
B.prototype.setValue=function(v){this._isValueSet=this._fnIsNumber(v);return this.setProperty("value",this._isValueSet?v:NaN);};
B.prototype._fnIsNumber=function(n){return typeof n=='number'&&!isNaN(n)&&isFinite(n);};
B.prototype.clone=function(i,L,o){var c=E.prototype.clone.apply(this,arguments);c._isValueSet=this._isValueSet;return c;};
return B;});
sap.ui.predefine('sap/suite/ui/microchart/BulletMicroChartRenderer',['./library','sap/m/library','sap/suite/ui/microchart/MicroChartRenderUtils',"sap/base/security/encodeXML"],function(l,M,a,e){"use strict";var B={};
B.render=function(r,c){if(!c._bThemeApplied){return;}if(c._hasData()){var C=c._calculateChartData();var f=+C.forecastValuePct;var s;if(c._isResponsive()){s="sapSuiteBMCResponsive";}else{s="sapSuiteBMCSize"+c.getSize();}var S=c.getScale();var d=sap.ui.getCore().getConfiguration().getRTL()?"right":"left";var m="sapSuiteBMCModeType"+c.getMode();var D=c.getMode()===l.BulletMicroChartModeType.Delta?c._calculateDeltaValue():0;var I=c.getActual()&&c.getActual()._isValueSet;var b=c.getShowActualValue()&&c.getSize()!==M.Size.XS&&c.getMode()===l.BulletMicroChartModeType.Actual;var g=c.getShowActualValueInDeltaMode()&&c.getSize()!==M.Size.XS&&c.getMode()===l.BulletMicroChartModeType.Delta;var h=c.getShowDeltaValue()&&c.getSize()!==M.Size.XS&&c.getMode()===l.BulletMicroChartModeType.Delta;var j=c.getShowTargetValue()&&c.getSize()!==M.Size.XS;var k=c.getShowThresholds();var A=c.getActualValueLabel();var n=c.getDeltaValueLabel();var t=c.getTargetValueLabel();var o=c.getThresholds();var p;if(I){p="sapSuiteBMCSemanticColor"+c.getActual().getColor();}r.write("<div");this._writeMainProperties(r,c);r.writeClasses();r.writeStyles();r.writeAttribute("id",c.getId()+"-bc-content");r.write(">");r.write("<div");r.addClass("sapSuiteBMCVerticalAlignmentContainer");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapSuiteBMCChart");r.addClass(e(s));r.writeClasses();r.writeAttribute("id",c.getId()+"-bc-chart");r.write(">");if((I&&(b||g))||(I&&c._isTargetValueSet&&h)){var v="";r.write("<div");r.addClass("sapSuiteBMCTopLabel");r.writeClasses();r.write(">");if(I&&(b||g)){var q=A?A:""+c.getActual().getValue();v=q+S;r.write("<div");r.addClass("sapSuiteBMCItemValue");r.addClass(e(p));r.addClass(e(s));r.writeClasses();r.writeStyles();r.writeAttribute("id",c.getId()+"-bc-item-value");r.write(">");r.writeEscaped(v);r.write("</div>");}else if(I&&c._isTargetValueSet&&h){var u=n?n:""+D;v=u+S;r.write("<div");r.addClass("sapSuiteBMCItemValue");r.addClass(e(p));r.addClass(e(s));r.writeClasses();r.writeStyles();r.writeAttribute("id",c.getId()+"-bc-item-value");r.write(">");r.write("&Delta;");r.writeEscaped(v);r.write("</div>");}r.write("</div>");}r.write("<div");r.addClass("sapSuiteBMCChartCanvas");r.writeClasses();r.write(">");if(k){for(var i=0;i<C.thresholdsPct.length;i++){if(o[i]._isValueSet){this.renderThreshold(r,c,C.thresholdsPct[i],s);}}}r.write("<div");r.writeAttribute("id",c.getId()+"-chart-bar");r.addClass("sapSuiteBMCBar");r.addClass(e(s));r.addClass("sapSuiteBMCScaleColor"+c.getScaleColor());r.writeClasses();r.write(">");r.write("</div>");if(I){if(c._isForecastValueSet&&c.getMode()===l.BulletMicroChartModeType.Actual){r.write("<div");r.addClass("sapSuiteBMCForecastBarValue");r.addClass(e(p));r.addClass(e(s));r.writeClasses();r.addStyle("width",f+"%");r.writeStyles();r.writeAttribute("id",c.getId()+"-forecast-bar-value");r.write("></div>");}r.write("<div");r.addClass("sapSuiteBMCBarValueMarker");r.addClass(m);if(!c.getShowValueMarker()){r.addClass("sapSuiteBMCBarValueMarkerHidden");}r.addClass(e(p));r.addClass(e(s));r.writeClasses();r.addStyle(e(d),e(parseFloat(C.actualValuePct)+parseFloat(1)+"%"));if(c.getMode()===l.BulletMicroChartModeType.Delta&&C.actualValuePct<=C.targetValuePct){r.addStyle("margin","0");}r.writeStyles();r.writeAttribute("id",c.getId()+"-bc-bar-value-marker");r.write("></div>");if(c.getMode()===l.BulletMicroChartModeType.Actual&&C.actualValuePct!==0){r.write("<div");r.addClass("sapSuiteBMCBarValue");r.addClass(e(p));r.addClass(e(s));if(c._isForecastValueSet){r.addClass("sapSuiteBMCForecast");}r.writeClasses();r.addStyle("width",e(C.actualValuePct+"%"));r.writeStyles();r.writeAttribute("id",c.getId()+"-bc-bar-value");r.write("></div>");}else if(c._isTargetValueSet&&c.getMode()===l.BulletMicroChartModeType.Delta){r.write("<div");r.addClass("sapSuiteBMCBarValue");r.addClass(e(p));r.addClass(e(s));r.writeClasses();r.addStyle("width",e(Math.abs(C.actualValuePct-C.targetValuePct)+"%"));r.addStyle(e(d),e(1+Math.min(C.actualValuePct,C.targetValuePct)+"%"));r.writeStyles();r.writeAttribute("id",c.getId()+"-bc-bar-value");r.write("></div>");}}if(c._isTargetValueSet){r.write("<div");r.addClass("sapSuiteBMCTargetBarValue");r.addClass(e(s));r.writeClasses();r.addStyle(e(d),e(parseFloat(C.targetValuePct).toFixed(2)+"%"));r.writeStyles();r.writeAttribute("id",c.getId()+"-bc-target-bar-value");r.write("></div>");r.write("</div>");if(j){r.write("<div");r.addClass("sapSuiteBMCBottomLabel");r.writeClasses();r.write(">");var T=t?t:""+c.getTargetValue();var w=T+S;r.write("<div");r.addClass("sapSuiteBMCTargetValue");r.addClass(e(s));r.writeClasses();r.writeStyles();r.writeAttribute("id",c.getId()+"-bc-target-value");r.write(">");r.writeEscaped(w);r.write("</div>");r.write("</div>");}}else{r.write("</div>");}r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-info");r.writeAttribute("aria-hidden","true");r.addStyle("display","none");r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");r.write("</div>");}else{r.write("<div");this._writeMainProperties(r,c);r.writeClasses();r.writeStyles();r.write(">");this._renderNoData(r);r.write("</div>");}};
B._writeMainProperties=function(r,c){var i=c.hasListeners("press");this._renderActiveProperties(r,c);var A=c.getTooltip_AsString(i);r.writeAttribute("role","img");if(c.getAriaLabelledBy().length){r.writeAccessibilityState(c);}else{r.writeAttributeEscaped("aria-label",A);}r.writeControlData(c);r.addClass("sapSuiteBMC");r.addClass("sapSuiteBMCContent");r.addClass(c._isResponsive()?"sapSuiteBMCResponsive":"sapSuiteBMCSize"+c.getSize());r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());};
B.renderThreshold=function(r,c,t,s){var d=sap.ui.getCore().getConfiguration().getRTL()?"right":"left",v=0.98*t.valuePct+1,C="sapSuiteBMCSemanticColor"+t.color;if(C==="sapSuiteBMCSemanticColor"+M.ValueColor.Error){r.write("<div");r.addClass("sapSuiteBMCDiamond");r.addClass(e(s));r.addClass(e(C));r.writeClasses();r.addStyle(e(d),e(v+"%"));r.writeStyles();r.write("></div>");}r.write("<div");r.addClass("sapSuiteBMCThreshold");r.addClass(e(s));r.addClass(e(C));r.writeClasses();r.addStyle(e(d),e(v+"%"));r.writeStyles();r.write("></div>");};
a.extendMicroChartRenderer(B);return B;},true);
sap.ui.predefine('sap/suite/ui/microchart/ColumnMicroChart',["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/m/Size","sap/ui/Device","sap/ui/core/ResizeHandler","sap/base/Log","sap/ui/events/KeyCodes","sap/suite/ui/microchart/MicroChartUtils","sap/m/library","./ColumnMicroChartRenderer","sap/ui/dom/jquery/Selectors"],function(q,l,C,S,D,R,L,K,M,m){"use strict";var V=m.ValueColor;
var a=C.extend("sap.suite.ui.microchart.ColumnMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{size:{group:"Misc",type:"sap.m.Size",defaultValue:"Auto"},width:{group:"Misc",type:"sap.ui.core.CSSSize"},height:{group:"Misc",type:"sap.ui.core.CSSSize"},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false},showTopLabels:{type:"boolean",defaultValue:true},showBottomLabels:{type:"boolean",defaultValue:true},allowColumnLabels:{type:"boolean",group:"Appearance",defaultValue:false}},events:{press:{}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},defaultAggregation:"columns",aggregations:{columns:{multiple:true,type:"sap.suite.ui.microchart.ColumnMicroChartData",defaultValue:null,bindable:"bindable"},leftTopLabel:{multiple:false,type:"sap.suite.ui.microchart.ColumnMicroChartLabel",defaultValue:null},rightTopLabel:{multiple:false,type:"sap.suite.ui.microchart.ColumnMicroChartLabel",defaultValue:null},leftBottomLabel:{multiple:false,type:"sap.suite.ui.microchart.ColumnMicroChartLabel",defaultValue:null},rightBottomLabel:{multiple:false,type:"sap.suite.ui.microchart.ColumnMicroChartLabel",defaultValue:null}}}});
a.THRESHOLD_LOOK_XS=1.125;a.THRESHOLD_LOOK_S=3.5;a.THRESHOLD_LOOK_M=4.5;a.THRESHOLD_LOOK_L=5.875;a.THRESHOLD_WIDTH_NO_LABEL=6;
a.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
a.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
a.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
a.prototype.onBeforeRendering=function(){this.$().unbind("mouseenter");this.$().unbind("mouseleave");};
a.prototype.onAfterRendering=function(){if(this._sChartResizeHandlerId){R.deregister(this._sChartResizeHandlerId);}l._checkControlIsVisible(this,this._onControlIsVisible);this.$().bind("mouseenter",this._addTitleAttribute.bind(this));this.$().bind("mouseleave",this._removeTitleAttribute.bind(this));};
a.prototype._onControlIsVisible=function(){this._fChartHeight=undefined;this._aBars=[];var c=this.getColumns().length;for(var i=0;i<c;i++){this._aBars.push({});}this._onResize();this._sChartResizeHandlerId=R.register(this,this._onResize.bind(this));};
a.prototype.exit=function(){R.deregister(this._sChartResizeHandlerId);};
a.prototype._onResize=function(){this._calcColumns();var c=this.$(),i=parseInt(c.width()),b=parseInt(c.height()),t=c.find(".sapSuiteClMCPositionTop").children(),$=c.find(".sapSuiteClMCLabelColumn.sapSuiteClMCLabelColumnTop,.sapSuiteClMCLabelColumn.sapSuiteClMCLabelColumnBottom"),B=c.find(".sapSuiteClMCBars")[0],d=this.getColumns(),e=d.length;c.removeClass("sapSuiteClMCNoLabels sapSuiteClMCNoColumnLabels sapSuiteClMCNoTopLabels sapSuiteClMCLookM sapSuiteClMCLookS sapSuiteClMCLookXS");if(i<=this.convertRemToPixels(a.THRESHOLD_WIDTH_NO_LABEL)){c.addClass("sapSuiteClMCNoLabels");}if(b<this.convertRemToPixels(a.THRESHOLD_LOOK_S)){c.addClass("sapSuiteClMCLookXS");}else if(b<this.convertRemToPixels(a.THRESHOLD_LOOK_M)){if(this.getAllowColumnLabels()){c.addClass("sapSuiteClMCNoColumnLabels");}c.addClass("sapSuiteClMCLookS");}else if(b<this.convertRemToPixels(a.THRESHOLD_LOOK_L)){c.addClass("sapSuiteClMCLookM");}if(this._isAnyLabelTruncated(t)){c.addClass("sapSuiteClMCNoTopLabels");}if(this.getAllowColumnLabels()&&this._isAnyLabelTruncated($)){c.addClass("sapSuiteClMCNoColumnLabels");}if(e>0&&B){c.find(".sapSuiteClMCBar").show();while(B.scrollWidth>B.offsetWidth){d[--e].$().hide();L.warning(this.toString()+" Chart overflow","Column "+e+" was not rendered");}}};
a.prototype._calcColumns=function(){var c=this.getColumns();if(c&&c.length===this._aBars.length){var f=parseFloat(this.$().css("height"));if(f!==this._fChartHeight){this._fChartHeight=f;this._calcColumnsHeight(f,this._aBars);}for(var i=0;i<c.length;i++){c[i].$().css(this._aBars[i]);}}};
a.prototype._calcColumnsHeight=function(c,b){var d=this.getColumns().length;if(d!==b.length){return;}var f,e,v;f=e=0;for(var i=0;i<d;i++){var o=this.getColumns()[i];if(f<o.getValue()){f=o.getValue();}else if(e>o.getValue()){e=o.getValue();}}if(f===0&&e===0){for(var g=0;g<d;g++){b[g].top="calc(100% - 1px)";b[g].height="1px";}return;}var h=f-e;var O=h/c;var j,t;j=t=0;for(var k=0;k<d;k++){v=this.getColumns()[k].getValue();if(Math.abs(v)<O){if(v>=0){if(v===f){t=O-v;}}else if(v===e){j=O+v;}}}if(t){f+=t;e-=t;}if(j){f-=j;e+=j;}var n=0-O;for(var p=0;p<d;p++){v=this.getColumns()[p].getValue();var r=v;if(v>=0){r=Math.max(r+t-j,O);}else{r=Math.min(r+t-j,n);}b[p].value=r;}function s(v){return(v/h*100).toFixed(2)+"%";}var z=s(f);for(var g=0;g<d;g++){v=b[g].value;b[g].top=(v<0)?z:s(f-v);b[g].height=s(Math.abs(v));}};
a.prototype.attachEvent=function(e,d,f,o){C.prototype.attachEvent.call(this,e,d,f,o);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};
a.prototype.detachEvent=function(e,f,o){C.prototype.detachEvent.call(this,e,f,o);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};
a.prototype.getLocalizedColorMeaning=function(c){return V[c]?this._oRb.getText(("SEMANTIC_COLOR_"+c).toUpperCase()):"";};
a.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true);}else{this.setProperty("isResponsive",false);}this.setProperty("size",s,false);}return this;};
a.prototype.setIsResponsive=function(i){var s,c=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=c===S.Responsive?S.Auto:c;}this.setProperty("size",s);return this;};
a.prototype._getAltHeaderText=function(i){var A=this._oRb.getText("COLUMNMICROCHART");if(i){A+=" "+this._oRb.getText("IS_ACTIVE");}if(!this._hasData()){A+="\n"+this._oRb.getText("NO_DATA");return A;}var o=this.getLeftTopLabel();var r=this.getRightTopLabel();var b=this.getLeftBottomLabel();var c=this.getRightBottomLabel();var s;if(o&&o.getLabel()||b&&b.getLabel()){if(o){s=o.getColor();}else if(b){s=b.getColor();}else{s="";}A+="\n"+this._oRb.getText(("COLUMNMICROCHART_START"))+": "+(b?b.getLabel()+" ":"")+(o?o.getLabel()+" ":"")+this.getLocalizedColorMeaning(s);}if(r&&r.getLabel()||c&&c.getLabel()){if(r){s=r.getColor();}else if(c){s=c.getColor();}else{s="";}A+="\n"+this._oRb.getText(("COLUMNMICROCHART_END"))+": "+(c?c.getLabel()+" ":"")+(r?r.getLabel()+" ":"")+this.getLocalizedColorMeaning(s);}return A;};
a.prototype._getAltSubText=function(I){var A="";var c=this.getColumns();for(var i=0;i<c.length;i++){var b=c[i],s=b.getTooltip_AsString(),d="";if(!s){continue;}d+=(I?"":"\n")+this._getBarAltText(b);d=s.split("((AltText))").join(d);if(d){A+=d;I=false;}}return A;};
a.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_COLUMNMICROCHART");};
a.prototype.ontap=function(e){if(D.browser.edge){this.onclick(e);}};
a.prototype.onclick=function(e){if(!this.fireBarPress(e)){if(D.browser.msie||D.browser.edge){this.$().focus();}this.firePress();}};
a.prototype.onkeydown=function(e){var t,f;switch(e.keyCode){case K.SPACE:e.preventDefault();break;case K.ARROW_LEFT:case K.ARROW_UP:f=this.$().find(":focusable");t=f.index(e.target);if(f.length>1){if(t===-1){f.eq(f.length-2).get(0).focus();}else{f.eq((t-1>=0)?t-1:f.length-1).get(0).focus();}e.preventDefault();e.stopPropagation();}break;case K.ARROW_DOWN:case K.ARROW_RIGHT:f=this.$().find(":focusable");t=f.index(e.target);if(f.length>0){f.eq((t+1<f.length)?t+1:0).get(0).focus();e.preventDefault();e.stopPropagation();}break;default:}};
a.prototype.onkeyup=function(e){if(e.which===K.ENTER||e.which===K.SPACE){if(!this.fireBarPress(e)){this.firePress();e.preventDefault();}}};
a.prototype.fireBarPress=function(e){var c=e.srcControl;if(c&&c.isA("sap.suite.ui.microchart.ColumnMicroChartData")){if(c.hasListeners("press")){c.firePress();e.preventDefault();e.stopPropagation();if(D.browser.msie){c.$().focus();}return true;}}return false;};
a.prototype._getBarAltText=function(b){var s=this.getLocalizedColorMeaning(b.getColor());return b.getLabel()+" "+b.getValue()+" "+s;};
a.prototype.setBarPressable=function(b,p){var $=b.$();if(p){var B=this._getBarAltText(b);$.addClass("sapSuiteUiMicroChartPointer").attr("tabindex",0).attr("title",B).attr("role","presentation").attr("aria-label",B);}else{$.removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer").removeAttr("title").removeAttr("role").removeAttr("aria-label");}};
a.prototype.onsaptabnext=function(e){var o=this.$().find(":focusable").last();if(o){this._bIgnoreFocusEvt=true;o.get(0).focus();}};
a.prototype.onsaptabprevious=function(e){if(e.target.id!==e.currentTarget.id){var f=this.$().find(":focusable").first();if(f){f.get(0).focus();}}};
a.prototype.onfocusin=function(e){if(this._bIgnoreFocusEvt){this._bIgnoreFocusEvt=false;return;}if(this.getId()+"-hidden"===e.target.id){this.$().focus();e.preventDefault();e.stopPropagation();}};
a.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};
a.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};
a.prototype._hasData=function(){return this.getColumns().length>0;};
a.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};
M.extendMicroChart(a);return a;});
sap.ui.predefine('sap/suite/ui/microchart/ColumnMicroChartData',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var C=E.extend("sap.suite.ui.microchart.ColumnMicroChartData",{metadata:{library:"sap.suite.ui.microchart",properties:{color:{group:"Misc",type:"sap.m.ValueCSSColor",defaultValue:"Neutral"},label:{type:"string",group:"Misc",defaultValue:""},displayValue:{type:"string",group:"Appearance"},value:{type:"float",group:"Misc"}},events:{press:{}}}});
C.prototype.init=function(){this.setAggregation("tooltip","((AltText))",true);};
C.prototype.attachEvent=function(e,d,f,L){E.prototype.attachEvent.call(this,e,d,f,L);if(this.getParent()&&e==="press"){this.getParent().setBarPressable(this,true);}return this;};
C.prototype.detachEvent=function(e,f,L){E.prototype.detachEvent.call(this,e,f,L);if(this.getParent()&&e==="press"){this.getParent().setBarPressable(this,false);}return this;};
return C;});
sap.ui.predefine('sap/suite/ui/microchart/ColumnMicroChartLabel',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var C=E.extend("sap.suite.ui.microchart.ColumnMicroChartLabel",{metadata:{library:"sap.suite.ui.microchart",properties:{color:{group:"Misc",type:"sap.m.ValueCSSColor",defaultValue:"Neutral"},label:{type:"string",group:"Misc",defaultValue:""}}}});
return C;});
sap.ui.predefine('sap/suite/ui/microchart/ColumnMicroChartRenderer',['./library',"sap/base/security/encodeXML",'sap/suite/ui/microchart/MicroChartRenderUtils','sap/ui/core/theming/Parameters','sap/m/library',"./ColumnMicroChartRenderer"],function(l,e,M,P,m){"use strict";var V=m.ValueColor;var a=m.ValueCSSColor;var D="sapUiChartNeutral",b="sapUiChartCategoryAxisLabelFontColor";var C={};
C.render=function(r,c){if(!c._bThemeApplied){return;}var d=c.getAllowColumnLabels();var A=c.getColumns().some(function(o){return o.getLabel();});if(c._hasData()){r.write("<div");this._writeMainProperties(r,c);if(d){r.addClass("sapSuiteClMCColumnLabels");}if(!A){r.addClass("sapSuiteClMCNoBottomColumnLabels");}r.writeClasses();r.writeStyles();r.write(">");var L=c.getLeftTopLabel()&&c.getLeftTopLabel().getLabel()!==""&&c.getShowTopLabels();var R=c.getRightTopLabel()&&c.getRightTopLabel().getLabel()!==""&&c.getShowTopLabels();var f=c.getLeftBottomLabel()&&c.getLeftBottomLabel().getLabel()!==""&&c.getShowBottomLabels();var g=c.getRightBottomLabel()&&c.getRightBottomLabel().getLabel()!==""&&c.getShowBottomLabels();r.write("<div");r.addClass("sapSuiteClMCVerticalAlignmentContainer");r.writeClasses();r.write(">");if(L||R){r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-top-lbls");r.addClass("sapSuiteClMCLabels");r.addClass("sapSuiteClMCPositionTop");r.writeClasses();r.write(">");var w=L^R;if(L){this._writeEdgeLabel(r,c,c.getLeftTopLabel(),"-left-top-lbl","sapSuiteClMCPositionLeft",w);}if(R){this._writeEdgeLabel(r,c,c.getRightTopLabel(),"-right-top-lbl","sapSuiteClMCPositionRight",w);}r.write("</div>");}var h=c.getColumns();var j=h.length;var t,B;var o,v,i;if(d){for(i=0;i<j;i++){o=h[i];v=o.getValue();if(v&&v>=0){t=true;}else if(v&&v<0){B=true;}if(t&&B){break;}}}if(d&&t){r.write("<div");r.addClass("sapSuiteClMCColumnLabelDivider");r.writeClasses();r.write("></div>");}r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-bars");r.addClass("sapSuiteClMCBars");r.writeClasses();r.write(">");for(i=0;i<j;i++){o=h[i];v=o.getValue();r.write("<div");r.writeElementData(o);r.addClass("sapSuiteClMCBar");if(o.hasListeners("press")){r.writeAttribute("tabindex","0");r.writeAttribute("role","presentation");var s=c._getBarAltText(o);r.writeAttributeEscaped("title",s);r.writeAttributeEscaped("aria-label",s);r.addClass("sapSuiteUiMicroChartPointer");}r.writeClasses();r.write(">");if(d&&jQuery.isNumeric(v)&&v>=0){this._writeColumnValueLabel(r,o,"sapSuiteClMCLabelColumnTop");}r.write("<div");r.addClass("sapSuiteClMCInnerBar");this._setHexColor(r,o.getColor(),D,"background-color");r.writeClasses();r.writeStyles();r.write(">");r.write("</div>");if(d&&jQuery.isNumeric(v)&&v<0){this._writeColumnValueLabel(r,o,"sapSuiteClMCLabelColumnBottom");}r.write("</div>");}r.write("</div>");if(d&&B){r.write("<div");r.addClass("sapSuiteClMCColumnLabelDivider");r.writeClasses();r.write("></div>");}if(f||g){r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-btm-lbls");r.addClass("sapSuiteClMCLabels");r.addClass("sapSuiteClMCPositionBtm");r.writeClasses();r.write(">");var W=f^g;if(f){this._writeEdgeLabel(r,c,c.getLeftBottomLabel(),"-left-btm-lbl","sapSuiteClMCPositionLeft",W);}if(g){this._writeEdgeLabel(r,c,c.getRightBottomLabel(),"-right-btm-lbl","sapSuiteClMCPositionRight",W);}r.write("</div>");}if(d&&A){r.write("<div");r.addClass("sapSuiteClMCLabels");r.addClass("sapSuiteClMCBottomColumnLabels");r.writeClasses();r.write(">");h.forEach(function(o){this._writeColumnLabel(r,o);},this);r.write("</div>");}r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-hidden");r.writeAttribute("aria-hidden","true");r.writeAttribute("tabindex","0");r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");r.write("</div>");}else{r.write("<div");this._writeMainProperties(r,c);r.writeClasses();r.writeStyles();r.write(">");this._renderNoData(r);r.write("</div>");}};
C._writeMainProperties=function(r,c){var i=c.hasListeners("press");this._renderActiveProperties(r,c);var A=c.getTooltip_AsString(i);r.writeAttribute("role","img");if(c.getAriaLabelledBy().length){r.writeAccessibilityState(c);}else{r.writeAttributeEscaped("aria-label",A);}r.writeControlData(c);r.addClass("sapSuiteClMC");r.addClass("sapSuiteClMCSize"+c.getSize());r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());};
C._getHexColor=function(c,d){c=a.isValid(c)?c:d;return P.get(c)||c;};
C._setHexColor=function(r,c,d,s){V[c]?r.addClass(e("sapSuiteClMCSemanticColor"+c)):r.addStyle(s,this._getHexColor(c,d));};
C._writeEdgeLabel=function(r,c,L,i,s,w){r.write("<div");r.writeAttributeEscaped("id",c.getId()+i);r.addClass("sapSuiteClMCLabel");r.addClass("sapSuiteClMCEdgeLabel");r.addClass(e(s));this._setHexColor(r,L.getColor(),b,"color");if(w){r.addClass("sapSuiteClMCWideBtmLbl");}r.writeClasses();r.writeStyles();r.write(">");r.writeEscaped(L.getLabel());r.write("</div>");};
C._writeColumnValueLabel=function(r,c,s){var v=c.getDisplayValue()?c.getDisplayValue():c.getValue();r.write("<div");r.addClass("sapSuiteClMCLabel");r.addClass("sapSuiteClMCLabelColumn");r.addClass(s);this._setHexColor(r,c.getColor(),D,"background-color");r.writeStyles();r.writeClasses();r.write(">");r.write(v);r.write("</div>");};
C._writeColumnLabel=function(r,c){var L=c.getLabel();r.write("<div");r.addClass("sapSuiteClMCLabel");r.addClass("sapSuiteClMCLabelColumn");r.addClass("sapSuiteClMCBottomColumnLabel");r.writeClasses();r.write(">");r.write(L);r.write("</div>");};
M.extendMicroChartRenderer(C);return C;},true);
sap.ui.predefine('sap/suite/ui/microchart/ComparisonMicroChart',["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/m/Size","sap/ui/Device","sap/m/FlexBox","sap/suite/ui/microchart/MicroChartUtils","sap/m/library","sap/ui/core/ResizeHandler","./ComparisonMicroChartRenderer"],function(q,l,C,S,D,F,M,m,R){"use strict";var V=m.ValueColor;var a=l.ComparisonMicroChartViewType;
var b=C.extend("sap.suite.ui.microchart.ComparisonMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{size:{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},scale:{type:"string",group:"Misc",defaultValue:""},minValue:{type:"float",group:"Appearance",defaultValue:null},maxValue:{type:"float",group:"Appearance",defaultValue:null},view:{type:"sap.suite.ui.microchart.ComparisonMicroChartViewType",group:"Appearance",defaultValue:"Normal"},colorPalette:{type:"string[]",group:"Appearance",defaultValue:[]},shrinkable:{type:"boolean",group:"Misc",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",group:"Appearance"},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},defaultAggregation:"data",aggregations:{data:{type:"sap.suite.ui.microchart.ComparisonMicroChartData",multiple:true,bindable:"bindable"}},events:{press:{}}}});
b.THRESHOLD_LOOK_XS=6;b.THRESHOLD_LOOK_S=8.25;b.THRESHOLD_LOOK_M=10.5;b.THRESHOLD_LOOK_L=12;
b.prototype.attachEvent=function(e,d,f,L){C.prototype.attachEvent.call(this,e,d,f,L);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};
b.prototype.detachEvent=function(e,f,L){C.prototype.detachEvent.call(this,e,f,L);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};
b.prototype.ontap=function(e){if(D.browser.edge){this.onclick(e);}};
b.prototype.onclick=function(e){if(!this.fireBarPress(e)){this.firePress();if(D.browser.msie||D.browser.edge){this.$().focus();e.preventDefault();}}};
b.prototype.fireBarPress=function(e){var B=q(e.target);if(B&&B.attr("data-bar-index")){var i=parseInt(B.attr("data-bar-index"));var c=this.getData()[i];if(c&&c.hasListeners("press")){c.firePress();e.preventDefault();e.stopImmediatePropagation();if(D.browser.msie){q(document.getElementById(this.getId()+"-chart-item-bar-"+i)).focus();}var $=this.$().find(".sapSuiteCpMCChartBar");var d=$.index(this.$().find(".sapSuiteCpMCChartBar[tabindex='0']"));this._switchTabindex(d,i,$);return true;}}return false;};
b.prototype.onsaptabprevious=function(){this.$().css("outline-color","");};
b.prototype.onsaptabnext=function(){var n=this.$().next();if(n.hasClass("sapSuiteCpMC")&&n.attr("tabindex")){n.css("outline-color","");}};
b.prototype.onsapenter=function(e){if(!this.fireBarPress(e)){this.firePress();e.preventDefault();e.stopImmediatePropagation();}};
b.prototype.onsapspace=b.prototype.onsapenter;
b.prototype.onsapup=function(e){var B=this.$().find(".sapSuiteUiMicroChartPointer");if(B.length>0){var i=B.index(e.target);this._switchTabindex(i,i-1,B);}e.preventDefault();e.stopImmediatePropagation();};
b.prototype.onsapdown=function(e){var B=this.$().find(".sapSuiteUiMicroChartPointer");if(B.length>0){var i=B.index(e.target);this._switchTabindex(i,i+1,B);}e.preventDefault();e.stopImmediatePropagation();};
b.prototype.onsaphome=function(e){var B=this.$().find(".sapSuiteUiMicroChartPointer");var i=B.index(e.target);if(i!==0&&B.length>0){this._switchTabindex(i,0,B);}e.preventDefault();e.stopImmediatePropagation();};
b.prototype.onsapend=function(e){var B=this.$().find(".sapSuiteUiMicroChartPointer");var i=B.index(e.target),L=B.length;if(i!==L-1&&L>0){this._switchTabindex(i,L-1,B);}e.preventDefault();e.stopImmediatePropagation();};
b.prototype.onsapleft=b.prototype.onsapup;b.prototype.onsapright=b.prototype.onsapdown;
b.prototype.setMinValue=function(f){this._isMinValueSet=q.isNumeric(f);return this.setProperty("minValue",this._isMinValueSet?f:NaN);};
b.prototype.setMaxValue=function(f){this._isMaxValueSet=q.isNumeric(f);return this.setProperty("maxValue",this._isMaxValueSet?f:NaN);};
b.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true);}else{this.setProperty("isResponsive",false);}this.setProperty("size",s,false);}return this;};
b.prototype.setIsResponsive=function(i){var s,c=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=c===S.Responsive?S.Auto:c;}this.setProperty("size",s);return this;};
b.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._isMinValueSet=false;this._isMaxValueSet=false;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
b.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
b.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
b.prototype.onBeforeRendering=function(){if(this._sChartResizeHandlerId){R.deregister(this._sChartResizeHandlerId);}this._unbindMouseEnterLeaveHandler();};
b.prototype.onAfterRendering=function(){l._checkControlIsVisible(this,this._onControlIsVisible);this._bindMouseEnterLeaveHandler();};
b.prototype._onControlIsVisible=function(){this._onResize();this._sChartResizeHandlerId=R.register(this,this._onResize.bind(this));};
b.prototype.setBarPressable=function(B,p){if(p){var s=this._getBarAltText(B);q(document.getElementById(this.getId()+"-chart-item-bar-"+B)).addClass("sapSuiteUiMicroChartPointer").attr("tabindex",0).attr("title",s).attr("role","presentation").attr("aria-label",s);}else{q(document.getElementById(this.getId()+"-chart-item-bar-"+B)).removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer").removeAttr("title").removeAttr("role").removeAttr("aria-label");}};
b.prototype._getAltHeaderText=function(i){var A=this._oRb.getText("COMPARISONMICROCHART");if(i){A+=" "+this._oRb.getText("IS_ACTIVE");}if(!this._hasData()){A+="\n"+this._oRb.getText("NO_DATA");return A;}return A;};
b.prototype._getAltSubText=function(I){var A="";for(var i=0;i<this.getData().length;i++){var B=this.getData()[i],s=this._getBarAltText(i),c=B.getTooltip_AsString(),d="";if(!c){continue;}d=c.split("((AltText))").join(s);if(d){A+=(I?"":"\n")+d;I=false;}}return A;};
b.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_COMPARISONMICROCHART");};
b.prototype.exit=function(){R.deregister(this._sChartResizeHandlerId);};
b.prototype._calculateChartData=function(){var r=[];var d=this.getData();var c=d.length;var e=0;var f=0;var t;var g;var h;var i;for(i=0;i<c;i++){var j=isNaN(d[i].getValue())?0:d[i].getValue();e=Math.max(e,j);f=Math.min(f,j);}if(this._isMinValueSet){f=Math.min(f,this.getMinValue());}if(this._isMaxValueSet){e=Math.max(e,this.getMaxValue());}t=e-f;g=(t==0)?0:Math.round(e*100/t);if(g==0&&e!=0){g=1;}else if(g==100&&f!=0){g=99;}h=100-g;for(i=0;i<c;i++){var I={};var k=isNaN(d[i].getValue())?0:d[i].getValue();I.value=(t==0)?0:Math.round(k*100/t);if(I.value==0&&k!=0){I.value=(k>0)?1:-1;}else if(I.value==100){I.value=g;}else if(I.value==-100){I.value=-h;}if(I.value>=0){I.negativeNoValue=h;I.positiveNoValue=g-I.value;}else{I.value=-I.value;I.negativeNoValue=h-I.value;I.positiveNoValue=g;}r.push(I);}return r;};
b.prototype._getLocalizedColorMeaning=function(c){return V[c]?this._oRb.getText(("SEMANTIC_COLOR_"+c).toUpperCase()):"";};
b.prototype._getBarAltText=function(B){var o=this.getData()[B],s=C.prototype.getTooltip_AsString.apply(o,arguments),c=this.getColorPalette().length?"":this._getLocalizedColorMeaning(o.getColor()),d=o.getTitle()+" "+(o.getDisplayValue()?o.getDisplayValue():o.getValue())+this.getScale()+" "+c;if(!s){return"";}return s.split("((AltText))").join(d);};
b.prototype._onResize=function(){this.$().find(".sapSuiteCpMCChartItem").show();this._resizeHorizontally();this._resizeVertically();};
b.prototype._resizeVertically=function(){var I,f,B,c,s,d,e,r,g,h=this.getData(),$=this.$(),j,k=$.find(".sapSuiteCpMCChartItem"),n=$.find(".sapSuiteCpMCChartBar");k.css("margin-bottom","");k.css("height","");n.css("height","");if(h.length>0&&h[0].getDomRef()){I=h[0].getDomRef().getBoundingClientRect().height;f=parseFloat(h[0].$().css("margin-bottom"));B=n.height();d=$.width();e=this._getCurrentBaseWidth();if(e>0){r=e/I;I=d/r;k.css("height",I);r=e/f;f=d/r;k.css("margin-bottom",f);r=e/B;n.css("height",d/r);}c=$.find(".sapSuiteCpMCVerticalAlignmentContainer")[0].getBoundingClientRect().height;s=0;for(var i=0;i<h.length;i++){s+=I;if(s>c){h[i].$().hide();}s+=f;}j=this.$().find(".sapSuiteCpMCVerticalAlignmentContainer .sapSuiteCpMCChartItem:visible:last");if(j.length===1&&!this.getShrinkable()){j.css("margin-bottom","");g=this.getDomRef().getBoundingClientRect().bottom-j[0].getBoundingClientRect().bottom;if(g<f){j.css("margin-bottom",g<0?0:g);}}}};
b.prototype._resizeHorizontally=function(){var $=this.$();var f=0;var c=0;var d=this.$().find(".sapSuiteCpMCChartItemTitle");var e=this.$().find(".sapSuiteCpMCChartItemValue");var B;var L;$.removeClass("sapSuiteCpMCLookL sapSuiteCpMCLookM sapSuiteCpMCLookS sapSuiteCpMCLookXS sapSuiteCpMCLookWide");L=this._getCurrentLookClass();$.addClass(L);if(!$.hasClass("sapSuiteCpMCLookXS")){this._hideTruncatedLabels(".sapSuiteCpMCChartItemValue");}d.width("auto");e.width("auto");if($.hasClass("sapSuiteCpMCLookWide")){d.each(function(){B=this.getBoundingClientRect();if(B.width>f){f=Math.ceil(B.width);}});d.width(f);e.each(function(){B=this.getBoundingClientRect();if(B.width>c){c=Math.ceil(B.width);}});e.width(c);}};
b.prototype._getCurrentBaseWidth=function(){var $=this.$();var w=parseInt($.width());var B;if(this.getView()===a.Wide||w>this.convertRemToPixels(b.THRESHOLD_LOOK_L)||this.getSize()!==S.Responsive){B=0;}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_M)){B=this.convertRemToPixels(b.THRESHOLD_LOOK_L);}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_S)){B=this.convertRemToPixels(b.THRESHOLD_LOOK_M);}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_XS)){B=this.convertRemToPixels(b.THRESHOLD_LOOK_S);}else{B=0;}return B;};
b.prototype._getCurrentLookClass=function(){var $=this.$();var w=parseInt($.width());var L;if(this._shouldUseWideView()){L="sapSuiteCpMCLookWide";}else if(this.getSize()!==S.Responsive){L="sapSuiteCpMCLook"+this._getSize();}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_M)){L="sapSuiteCpMCLookL";}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_S)){L="sapSuiteCpMCLookM";}else if(w>this.convertRemToPixels(b.THRESHOLD_LOOK_XS)){L="sapSuiteCpMCLookS";}else{L="sapSuiteCpMCLookXS";}return L;};
b.prototype._getSize=function(){var s=this.getSize();if(s===S.Auto){if(D.system.phone){s=S.S;}else{s=S.M;}}return s;};
b.prototype._shouldUseWideView=function(){var w=parseInt(this.$().width());return this.getView()===a.Wide||(this.getView()===a.Responsive&&w>this.convertRemToPixels(b.THRESHOLD_LOOK_L));};
b.prototype._hideTruncatedLabels=function(c){var $=this.$();var L=$.find(c);for(var i=0;i<L.length;i++){q(L[i]).removeClass("sapSuiteCpMCChartItemHiddenLabel");if(this._isLabelTruncated(L[i])){q(L[i]).addClass("sapSuiteCpMCChartItemHiddenLabel");}}};
b.prototype._addTitleAttribute=function(){var t=this.getTooltip_AsString();if(!l._isTooltipSuppressed(t)&&this._hasData()){if(this.getIsResponsive()){this.$().find(".sapSuiteCpMCVerticalAlignmentContainer").attr("title",t);}else{this.$().attr("title",t);}}};
b.prototype._removeTitleAttribute=function(){if(this.getIsResponsive()){this.$().find(".sapSuiteCpMCVerticalAlignmentContainer").removeAttr("title");}else{this.$().removeAttr("title");}};
b.prototype._resolveFocus=function(e){var B=q(e.target);if(B&&B.attr("data-bar-index")){var i=parseInt(B.attr("data-bar-index"));var d=this.getData()[i];if(d&&d.hasListeners("press")){this.$().css("outline-color","transparent");}else{this.$().css("outline-color","");}}else{this.$().css("outline-color","");}};
b.prototype._switchTabindex=function(o,n,c){if(o>=0&&o<c.length&&n>=0&&n<c.length){c.eq(o).removeAttr("tabindex");c.eq(n).attr("tabindex","0").focus();}};
b.prototype._bindMouseEnterLeaveHandler=function(){if(!this._oMouseEnterLeaveHandler){this._oMouseEnterLeaveHandler={mouseEnterChart:this._addTitleAttribute.bind(this),mouseLeaveChart:this._removeTitleAttribute.bind(this),mouseDownChart:this._resolveFocus.bind(this)};}this.$().bind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().bind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);this.$().bind("mousedown",this._oMouseEnterLeaveHandler.mouseDownChart);};
b.prototype._unbindMouseEnterLeaveHandler=function(){if(this._oMouseEnterLeaveHandler){this.$().unbind("mouseenter",this._oMouseEnterLeaveHandler.mouseEnterChart);this.$().unbind("mouseleave",this._oMouseEnterLeaveHandler.mouseLeaveChart);this.$().unbind("mousedown",this._oMouseEnterLeaveHandler.mouseDownChart);}};
b.prototype._hasData=function(){return this.getData().length>0;};
b.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};
M.extendMicroChart(b);return b;});
sap.ui.predefine('sap/suite/ui/microchart/ComparisonMicroChartData',['./library','sap/ui/core/Element','sap/ui/core/Control'],function(l,E,C){"use strict";
var a=E.extend("sap.suite.ui.microchart.ComparisonMicroChartData",{metadata:{library:"sap.suite.ui.microchart",properties:{value:{type:"float",group:"Misc",defaultValue:"0"},color:{type:"sap.m.ValueCSSColor",group:"Misc",defaultValue:"Neutral"},title:{type:"string",group:"Misc",defaultValue:""},displayValue:{type:"string",group:"Misc",defaultValue:""}},events:{press:{}}}});
a.prototype.init=function(){this.setAggregation("tooltip","((AltText))",true);};
a.prototype.setValue=function(v,s){this._isValueSet=this._fnIsNumber(v);return this.setProperty("value",this._isValueSet?v:NaN,s);};
a.prototype._fnIsNumber=function(n){return typeof n=='number'&&!isNaN(n)&&isFinite(n);};
a.prototype.clone=function(i,L,o){var c=C.prototype.clone.apply(this,arguments);c._isValueSet=this._isValueSet;return c;};
a.prototype.attachEvent=function(e,d,f,L){C.prototype.attachEvent.call(this,e,d,f,L);if(this.getParent()){this.getParent().setBarPressable(this.getParent().getData().indexOf(this),true);}return this;};
a.prototype.detachEvent=function(e,f,L){C.prototype.detachEvent.call(this,e,f,L);if(this.getParent()){this.getParent().setBarPressable(this.getParent().getData().indexOf(this),false);}return this;};
return a;});
sap.ui.predefine('sap/suite/ui/microchart/ComparisonMicroChartRenderer',['./library',"sap/base/security/encodeXML",'sap/suite/ui/microchart/MicroChartRenderUtils','sap/ui/core/theming/Parameters','sap/m/library'],function(l,e,M,P,m){"use strict";var V=m.ValueColor;var C={};
C.render=function(r,c){if(!c._bThemeApplied){return;}if(c._hasData()){var a=c.getTooltip_AsString(c.hasListeners("press"));r.write("<div");this._writeMainProperties(r,c);if(c.getShrinkable()){r.addClass("sapSuiteCpMCShrinkable");r.addStyle("height","auto");}r.writeClasses();r.writeStyles();r.write(">");this._renderInnerContent(r,c,a);r.write("<div");r.writeAttribute("id",c.getId()+"-info");r.writeAttribute("aria-hidden","true");r.addStyle("display","none");r.writeStyles();r.write(">");r.writeEscaped(a);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-hidden");r.writeAttribute("aria-hidden","true");r.writeAttribute("focusable","false");r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");}else{r.write("<div");this._writeMainProperties(r,c);r.writeClasses();r.writeStyles();r.write(">");this._renderNoData(r);r.write("</div>");}};
C._writeMainProperties=function(r,c){var i=c.hasListeners("press");this._renderActiveProperties(r,c);var a=c.getTooltip_AsString(i);r.writeAttribute("role","img");if(c.getAriaLabelledBy().length){r.writeAccessibilityState(c);}else{r.writeAttributeEscaped("aria-label",a);}r.writeControlData(c);r.addClass("sapSuiteCpMC");r.addClass("sapSuiteCpMCChartContent");r.addClass(c._isResponsive()?"sapSuiteCpMCResponsive":"sapSuiteCpMCSize"+c.getSize());r.addClass("sapSuiteCpMCViewType"+c.getView());r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());};
C._renderInnerContent=function(r,c){var a=c.getColorPalette().length,b=0,d=c.getData(),f=c._calculateChartData();var n=function(s){if(a){if(b===a){b=0;}s=c.getColorPalette()[b++].trim();}return P.get(s)||s;};r.write("<div");r.addClass("sapSuiteCpMCVerticalAlignmentContainer");r.writeClasses();r.write(">");for(var i=0;i<f.length;i++){this._renderChartItem(r,c,f[i],i,n(d[i].getColor()));}r.write("</div>");};
C._renderChartItem=function(r,c,o,i,s){var d=c.getData();r.write("<div");r.addClass("sapSuiteCpMCChartItem");r.writeElementData(d[i]);r.writeClasses();r.write(">");this._renderChartTitle(r,c,i);this._renderChartBar(r,c,o,i,s);this._renderChartValue(r,c,i,s);r.write("</div>");};
C._renderChartBar=function(r,c,o,i,s){var d=c.getData()[i];r.write("<div");r.writeAttribute("id",c.getId()+"-chart-item-bar-"+i);r.addClass("sapSuiteCpMCChartBar");if(c.getData()[i].hasListeners("press")){if(i===0){r.writeAttribute("tabindex","0");}r.writeAttribute("role","presentation");r.writeAttributeEscaped("aria-label",c._getBarAltText(i));if(!l._isTooltipSuppressed(c._getBarAltText(i))){r.writeAttributeEscaped("title",c._getBarAltText(i));}else{r.writeAttribute("title","");}r.writeAttribute("data-bar-index",i);r.addClass("sapSuiteUiMicroChartPointer");}r.writeClasses();r.write(">");if(o.negativeNoValue>0){r.write("<div");r.writeAttribute("data-bar-index",i);r.addClass("sapSuiteCpMCChartBarNegNoValue");if(o.value>0||o.positiveNoValue>0){r.addClass("sapSuiteCpMCNotLastBarPart");}r.writeClasses();r.addStyle("width",e(o.negativeNoValue+"%"));r.writeStyles();r.write("></div>");}if(o.value>0){r.write("<div");r.writeAttribute("data-bar-index",i);r.addClass("sapSuiteCpMCChartBarValue");r.addClass(e("sapSuiteCpMCSemanticColor"+d.getColor()));r.writeClasses();r.addStyle("background-color",s?e(s):"");r.addStyle("width",e(o.value+"%"));r.writeStyles();r.write("></div>");}if(o.positiveNoValue>0){r.write("<div");r.writeAttribute("data-bar-index",i);r.addClass("sapSuiteCpMCChartBarNoValue");if(!!o.negativeNoValue&&!o.value){r.addClass("sapSuiteCpMCNegPosNoValue");}else if(!!o.negativeNoValue||!!o.value){r.addClass("sapSuiteCpMCNotFirstBarPart");}r.writeClasses();r.addStyle("width",e(o.positiveNoValue+"%"));r.writeStyles();r.write("></div>");}r.write("</div>");};
C._renderChartTitle=function(r,c,i){var d=c.getData()[i];r.write("<div");r.writeAttribute("id",c.getId()+"-chart-item-"+i+"-title");r.addClass("sapSuiteCpMCChartItemTitle");r.writeClasses();r.write(">");r.writeEscaped(d.getTitle());r.write("</div>");};
C._renderChartValue=function(r,c,i,s){var d=c.getData()[i];var S=c.getScale();var D=d.getDisplayValue();var a=D?D:""+d.getValue();var v=a+S;r.write("<div");r.writeAttribute("id",c.getId()+"-chart-item-"+i+"-value");r.addClass("sapSuiteCpMCChartItemValue");if(V[s]){r.addClass(e("sapSuiteCpMCSemanticColor"+d.getColor()));}if(d.getTitle()){r.addClass("sapSuiteCpMCTitle");}r.writeClasses();r.write(">");if(!isNaN(d.getValue())){r.writeEscaped(v);}r.write("</div>");};
M.extendMicroChartRenderer(C);return C;},true);
sap.ui.predefine('sap/suite/ui/microchart/DeltaMicroChart',["sap/ui/thirdparty/jquery","./library","sap/m/library","sap/m/FlexBox","sap/ui/core/Control","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/events/KeyCodes","sap/suite/ui/microchart/MicroChartUtils","./DeltaMicroChartRenderer"],function(q,l,M,F,C,D,R,K,a){"use strict";var V=M.ValueColor;var S=M.Size;var b=l.DeltaMicroChartViewType;
var c=C.extend("sap.suite.ui.microchart.DeltaMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{value1:{type:"float",group:"Misc",defaultValue:null},value2:{type:"float",group:"Misc",defaultValue:null},title1:{type:"string",group:"Misc",defaultValue:null},title2:{type:"string",group:"Misc",defaultValue:null},displayValue1:{type:"string",group:"Misc",defaultValue:null},displayValue2:{type:"string",group:"Misc",defaultValue:null},deltaDisplayValue:{type:"string",group:"Misc",defaultValue:null},color:{type:"sap.m.ValueCSSColor",group:"Misc",defaultValue:"Neutral"},view:{type:"sap.suite.ui.microchart.DeltaMicroChartViewType",group:"Appearance",defaultValue:"Normal"},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{group:"Misc",type:"sap.ui.core.CSSSize"},size:{type:"sap.m.Size",group:"Misc",defaultValue:"Auto"},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
c.THRESHOLD_LOOK_XS=1.125;c.THRESHOLD_LOOK_S=3.5;c.THRESHOLD_LOOK_M=4.5;c.THRESHOLD_LOOK_L=5.875;c.THRESHOLD_WIDTH_NO_LABEL=6;c.THRESHOLD_WIDTH_WIDE_MODE=12;
c.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
c.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true,true);}else{this.setProperty("isResponsive",false,true);}this.setProperty("size",s,false);}return this;};
c.prototype.setIsResponsive=function(i){var s,d=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=d===S.Responsive?S.Auto:d;}this.setProperty("size",s);return this;};
c.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
c.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
c.prototype._calcChartData=function(){var v=this.getValue1();var f=this.getValue2();var m=Math.min(v,f,0);var d=Math.max(v,f,0);var t=d-m;function e(h){return(t===0?0:Math.abs(h)/t*100).toFixed(2);}var o={};var g=v-f;o.delta={left:d===0,width:e(g),isFirstStripeUp:v<f,isMax:(v<0&&f>=0)||(v>=0&&f<0),isZero:v===0&&f===0,isEqual:g===0};o.bar1={left:f>=0,width:e(v),isSmaller:Math.abs(v)<Math.abs(f)};o.bar2={left:v>=0,width:e(f),isSmaller:Math.abs(f)<Math.abs(v)};return o;};
c.prototype._getDeltaValue=function(){var v=this.getValue1(),f=this.getValue2();return Math.abs(v-f).toFixed(Math.max(this._digitsAfterDecimalPoint(v),this._digitsAfterDecimalPoint(f)));};
c.prototype._getLocalizedColorMeaning=function(s){return V[s]?this._oRb.getText(("SEMANTIC_COLOR_"+s).toUpperCase()):"";};
c.prototype._getAltHeaderText=function(i){var A=this._oRb.getText("DELTAMICROCHART");if(i){A+=" "+this._oRb.getText("IS_ACTIVE");}A+="\n";if(!this._hasData()){A+=this._oRb.getText("NO_DATA");return A;}var d=this.getDisplayValue1();var s=this.getDisplayValue2();var e=this.getDeltaDisplayValue();var v=this.getValue1();var f=this.getValue2();var g=d?d:""+v;var h=s?s:""+f;var j=e?e:""+Math.abs(v-f).toFixed(Math.max(this._digitsAfterDecimalPoint(v),this._digitsAfterDecimalPoint(f)));var m=this._getLocalizedColorMeaning(this.getColor());A+=this.getTitle1()+" "+g+"\n"+this.getTitle2()+" "+h+"\n"+this._oRb.getText("DELTAMICROCHART_DELTA_TOOLTIP",[j,m]);return A;};
c.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_DELTAMICROCHART");};
c.prototype.onBeforeRendering=function(){this._oChartData=this._calcChartData();if(this._sResizeHandlerId){R.deregister(this._sResizeHandlerId);}this.$().unbind("mouseenter");this.$().unbind("mouseleave");};
c.prototype.onAfterRendering=function(){l._checkControlIsVisible(this,this._onControlIsVisible);this.$().bind("mouseenter",this._addTitleAttribute.bind(this));this.$().bind("mouseleave",this._removeTitleAttribute.bind(this));};
c.prototype._onControlIsVisible=function(){if(this._hasData()){this._onResize();this._sResizeHandlerId=R.register(this,this._onResize.bind(this));}};
c.prototype.exit=function(){R.deregister(this._sResizeHandlerId);};
c.prototype._onResize=function(){var $=this.$(),i=parseInt($.width()),d=parseInt($.height()),r=$.find(".sapSuiteDMCLbls .sapSuiteDMCLabel"),v=this.getView();$.removeClass("sapSuiteDMCNoLabels sapSuiteDMCNoRightLabels sapSuiteDMCLookM sapSuiteDMCLookS sapSuiteDMCLookXS");if(v===b.Responsive){$.removeClass("sapSuiteDMCWideMode");}if(i<=this.convertRemToPixels(c.THRESHOLD_WIDTH_NO_LABEL)||d<=this.convertRemToPixels(c.THRESHOLD_LOOK_XS)){$.addClass("sapSuiteDMCNoLabels");}if(v===b.Responsive&&i>this.convertRemToPixels(c.THRESHOLD_WIDTH_WIDE_MODE)){$.addClass("sapSuiteDMCWideMode");}if(d<this.convertRemToPixels(c.THRESHOLD_LOOK_S)){$.addClass("sapSuiteDMCLookXS");}else if(d<this.convertRemToPixels(c.THRESHOLD_LOOK_M)){$.addClass("sapSuiteDMCLookS");}else if(d<this.convertRemToPixels(c.THRESHOLD_LOOK_L)){$.addClass("sapSuiteDMCLookM");}if(this._isAnyLabelTruncated(r)){$.addClass("sapSuiteDMCNoRightLabels");}};
c.prototype.attachEvent=function(e,d,f,L){C.prototype.attachEvent.call(this,e,d,f,L);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};
c.prototype.detachEvent=function(e,f,L){C.prototype.detachEvent.call(this,e,f,L);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};
c.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
c.prototype.onkeydown=function(e){if(e.which===K.SPACE){e.preventDefault();}};
c.prototype.onkeyup=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
c.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};
c.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};
c.prototype._hasData=function(){return true;};
c.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};
a.extendMicroChart(c);return c;});
sap.ui.predefine('sap/suite/ui/microchart/DeltaMicroChartRenderer',['./library',"sap/base/security/encodeXML",'sap/suite/ui/microchart/MicroChartRenderUtils','sap/ui/core/theming/Parameters','sap/m/library'],function(l,e,M,P,a){"use strict";var V=a.ValueColor;var D=l.DeltaMicroChartViewType;var b={};
b.render=function(r,c){function g(L){return L?"sapSuiteDMCDirectionLeft":"sapSuiteDMCDirectionRight";}if(c._hasData()){if(!c._bThemeApplied){return;}var d=c.getDisplayValue1();var s=c.getDisplayValue2();var v=c.getValue1();var f=c.getValue2();var h=c.getDeltaDisplayValue();var A=d?d:""+v;var i=s?s:""+f;var j=h?h:""+c._getDeltaValue();var C=c.getColor();var S=function(C,m){if(V[C]){r.addClass("sapSuiteDMCSemanticColor"+C);}else{r.addStyle(m,P.get(C)||C);r.writeStyles();}};var t=c.getTitle1();var T=c.getTitle2();var k=c.getView();r.write("<div");this._writeMainProperties(r,c);if(!t){r.addClass("sapSuiteDMCNoTitleTop");}if(!T){r.addClass("sapSuiteDMCNoTitleBottom");}if(k===D.Wide){r.addClass("sapSuiteDMCWideMode");}r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapSuiteDMCVerticalAlignmentContainer");r.writeClasses();r.write(">");if((t||T)&&(k===D.Wide||k===D.Responsive)){r.write("<div");r.addClass("sapSuiteDMCWideTitles");r.addClass("sapSuiteDMCLabel");r.writeClasses();r.write(">");this._renderTitle(r,t,"sapSuiteDMCPositionTop");this._renderTitle(r,T,"sapSuiteDMCPositionBtm");r.write("</div>");r.write("<div");r.addClass("sapSuiteDMCSpacer");r.addClass("sapSuiteDMCSpacerLeft");r.writeClasses();r.write(">");r.write("</div>");}r.write("<div");r.addClass("sapSuiteDMCCnt");r.writeClasses();r.write(">");if(t&&(k===D.Normal||k===D.Responsive)){this._renderTitle(r,t,"sapSuiteDMCPositionTop");}r.write("<div");r.addClass("sapSuiteDMCChart");r.writeClasses();r.writeAttribute("id",c.getId()+"-dmc-chart");r.write(">");r.write("<div");r.addClass("sapSuiteDMCBar");r.addClass("sapSuiteDMCBar1");if(c._oChartData.delta.isMax){r.addClass("sapSuiteDMCBarDeltaMaxDelta");}if(c._oChartData.bar1.isSmaller){r.addClass("sapSuiteDMCBarSizeSmaller");}if(parseFloat(c._oChartData.bar1.width)===0){r.addClass("sapSuiteDMCBarZeroWidth");}else if(parseFloat(c._oChartData.bar2.width)===0){r.addClass("sapSuiteDMCBarUniqueNonzero");}r.addClass(e(g(c._oChartData.bar1.left)));r.writeClasses();r.addStyle("width",e(c._oChartData.bar1.width+"%"));r.writeStyles();r.writeAttribute("id",c.getId()+"-dmc-bar1");r.write(">");r.write("<div");r.addClass("sapSuiteDMCBarInternal");r.addClass(e(g(c._oChartData.bar2.left)));r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");r.write("<div");r.addClass("sapSuiteDMCBar");r.addClass("sapSuiteDMCBar2");if(c._oChartData.delta.isMax){r.addClass("sapSuiteDMCBarDeltaMaxDelta");}if(c._oChartData.bar2.isSmaller){r.addClass("sapSuiteDMCBarSizeSmaller");}if(parseFloat(c._oChartData.bar2.width)===0){r.addClass("sapSuiteDMCBarZeroWidth");}else if(parseFloat(c._oChartData.bar1.width)===0){r.addClass("sapSuiteDMCBarUniqueNonzero");}r.addClass(e(g(c._oChartData.bar2.left)));r.writeClasses();r.addStyle("width",e(c._oChartData.bar2.width+"%"));r.writeStyles();r.writeAttribute("id",c.getId()+"-dmc-bar2");r.write(">");r.write("<div");r.addClass("sapSuiteDMCBarInternal");r.addClass(e(g(c._oChartData.bar1.left)));r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");r.write("<div");r.addClass("sapSuiteDMCBar");r.addClass("sapSuiteDMCBarDelta");if(!c._oChartData.delta.isMax){r.addClass("sapSuiteDMCBarDeltaNotMax");}if(c._oChartData.delta.isZero){r.addClass("sapSuiteDMCBarDeltaZero");}if(c._oChartData.delta.isEqual){r.addClass("sapSuiteDMCBarDeltaEqual");}r.addClass(e(g(c._oChartData.delta.left)));r.writeClasses();r.addStyle("width",e(c._oChartData.delta.width+"%"));r.writeStyles();r.writeAttribute("id",c.getId()+"-dmc-bar-delta");r.write(">");r.write("<div");S(C,"background-color");r.addClass("sapSuiteDMCBarDeltaInt");r.writeClasses();r.write(">");r.write("</div>");r.write("<div");r.addClass("sapSuiteDMCBarDeltaStripe");r.addClass(e(g(true)));if(c._oChartData.delta.isEqual){r.addClass("sapSuiteDMCBarDeltaEqual");}r.addClass("sapSuiteDMCBarDeltaFirstStripe"+(c._oChartData.delta.isFirstStripeUp?"Up":"Down"));r.writeClasses();r.write(">");r.write("</div>");r.write("<div");r.addClass("sapSuiteDMCBarDeltaStripe");r.addClass(e(g(false)));r.addClass("sapSuiteDMCBarDeltaFirstStripe"+(c._oChartData.delta.isFirstStripeUp?"Down":"Up"));r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");r.write("</div>");if(T&&(k===D.Normal||k===D.Responsive)){this._renderTitle(r,T,"sapSuiteDMCPositionBtm");}r.write("</div>");r.write("<div");r.addClass("sapSuiteDMCSpacer");r.addClass("sapSuiteDMCSpacerRight");r.writeClasses();r.write(">");r.write("</div>");r.write("<div");r.addClass("sapSuiteDMCLbls");r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-value1");r.addClass("sapSuiteDMCLabel");r.addClass("sapSuiteDMCValue1");r.writeClasses();r.write(">");r.writeEscaped(A);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-delta");r.addClass("sapSuiteDMCLabel");r.addClass("sapSuiteDMCDelta");S(C,"color");r.writeClasses();r.write(">");r.writeEscaped(j);r.write("</div>");r.write("<div");r.writeAttribute("id",c.getId()+"-value2");r.addClass("sapSuiteDMCLabel");r.addClass("sapSuiteDMCValue2");r.writeClasses();r.write(">");r.writeEscaped(i);r.write("</div>");r.write("</div>");r.write("</div>");r.write("</div>");}else{r.write("<div");this._writeMainProperties(r,c);r.writeClasses();r.writeStyles();r.write(">");this._renderNoData(r);r.write("</div>");}};
b._renderTitle=function(r,t,c){r.write("<div");r.addClass("sapSuiteDMCLabel");r.addClass("sapSuiteDMCTitle");r.addClass(c);r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</div>");};
b._writeMainProperties=function(r,c){var i=c.hasListeners("press");this._renderActiveProperties(r,c);var A=c.getTooltip_AsString(i);r.writeAttribute("role","img");if(c.getAriaLabelledBy().length){r.writeAccessibilityState(c);}else{r.writeAttributeEscaped("aria-label",A);}r.writeControlData(c);r.addClass("sapSuiteDMC");r.addClass("sapSuiteDMCSize"+c.getSize());r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());};
M.extendMicroChartRenderer(b);return b;},true);
sap.ui.predefine('sap/suite/ui/microchart/HarveyBallMicroChart',["sap/ui/thirdparty/jquery","./library","sap/m/library","sap/ui/core/Control","sap/ui/Device","sap/ui/events/KeyCodes","sap/suite/ui/microchart/MicroChartUtils","sap/ui/core/ResizeHandler","./HarveyBallMicroChartRenderer"],function(q,l,M,C,D,K,a,R){"use strict";var V=M.ValueColor;var S=M.Size;
var H=C.extend("sap.suite.ui.microchart.HarveyBallMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{total:{group:"Misc",type:"float",defaultValue:null},totalLabel:{group:"Misc",type:"string"},totalScale:{group:"Misc",type:"string"},formattedLabel:{group:"Misc",type:"boolean",defaultValue:false},showTotal:{group:"Misc",type:"boolean",defaultValue:true},showFractions:{group:"Misc",type:"boolean",defaultValue:true},size:{group:"Misc",type:"sap.m.Size",defaultValue:"Auto"},colorPalette:{type:"string[]",group:"Appearance",defaultValue:[]},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{type:"sap.ui.core.CSSSize",group:"Misc"},alignContent:{group:"Misc",type:"sap.suite.ui.microchart.HorizontalAlignmentType",defaultValue:"Left"},isResponsive:{type:"boolean",group:"Appearance",defaultValue:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},defaultAggregation:"items",aggregations:{items:{multiple:true,type:"sap.suite.ui.microchart.HarveyBallMicroChartItem",bindable:"bindable"}},events:{press:{}}}});
H.VALUE_TRUNCATION_DIGITS=5;H.THRESHOLD_LOOK_XS=1.125;H.THRESHOLD_LOOK_S=3.5;H.THRESHOLD_LOOK_M=4.5;H.THRESHOLD_LOOK_L=5.875;
H.prototype._getAltHeaderText=function(i){var A=this._oRb.getText("HARVEYBALLMICROCHART");if(i){A+=" "+this._oRb.getText("IS_ACTIVE");}if(!this._hasData()){A+="\n"+this._oRb.getText("NO_DATA");return A;}return A;};
H.prototype._getAltSubText=function(i){var A="";var I=this.getItems();I.forEach(function(o){var s=o.getColor(),b=o.getTooltip_AsString(),c="";if(!b){return;}var d=(this.getColorPalette().length===0&&V[s])?this._oRb.getText(("SEMANTIC_COLOR_"+s).toUpperCase()):"";var L=o.getFractionLabel();var e=o.getFractionScale();if(!L&&e){L=o.getFormattedLabel()?o.getFraction():o.getFraction()+o.getFractionScale().substring(0,3);}else if(!o.getFormattedLabel()&&o.getFractionLabel()&&e){L+=o.getFractionScale().substring(0,3);}c+=L+" "+d;c=b.split("((AltText))").join(c);if(c){A+="\n"+c;i=false;}}.bind(this));if(this.getTotal()){var t=this.getTotalLabel();if(!t){t=this.getFormattedLabel()?this.getTotal():this.getTotal()+this.getTotalScale().substring(0,3);}else if(!this.getFormattedLabel()&&this.getTotalScale()){t+=this.getTotalScale().substring(0,3);}A+=(i?"":"\n")+this._oRb.getText("HARVEYBALLMICROCHART_TOTAL_TOOLTIP")+" "+t;}return A;};
H.prototype.getTooltip_AsString=function(i){var t=C.prototype.getTooltip_AsString.apply(this,arguments),T=this._getAltHeaderText(i),I=false;if(t){T=t.split("((AltText))").join(T);}if(!t||!T){T="";I=true;}T+=this._getAltSubText(I);return T;};
H.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_HARVEYBALLMICROCHART");};
H.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);D.media.attachHandler(this.rerender,this,D.media.RANGESETS.SAP_STANDARD);this._sChartResizeHandlerId=null;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
H.prototype.setSize=function(s){if(this.getSize()!==s){if(s===S.Responsive){this.setProperty("isResponsive",true);}else{this.setProperty("isResponsive",false);}this.setProperty("size",s,false);}return this;};
H.prototype.setIsResponsive=function(i){var s,c=this.getSize();this.setProperty("isResponsive",i);if(i){s=S.Responsive;}else{s=c===S.Responsive?S.Auto:c;}this.setProperty("size",s);return this;};
H.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
H.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
H.prototype.onBeforeRendering=function(){if(this._sChartResizeHandlerId){R.deregister(this._sChartResizeHandlerId);}this._unbindMouseEnterLeaveHandler();};
H.prototype.onAfterRendering=function(){l._checkControlIsVisible(this,this._onControlIsVisible);this._bindMouseEnterLeaveHandler();};
H.prototype._onControlIsVisible=function(){this._onResize();this._sChartResizeHandlerId=R.register(this,this._onResize.bind(this));};
H.prototype._onResize=function(){var c=this.$(),f=c.height(),p=c.find(".sapSuiteHBMCChart").first(),t=c.find(".sapSuiteHBMCTextContainer").first(),b,P;c.removeClass("sapSuiteHBMCLookL sapSuiteHBMCLookM sapSuiteHBMCLookS sapSuiteHBMCLookXS");t.removeClass("sapSuiteHBMCTextContainerHide");p.css("width",p.css("height"));var s=c.find(".sapSuiteHBMCChartSvg")[0];if(s){s.setAttribute("viewBox","0 0 72 72");}if(f<this.convertRemToPixels(H.THRESHOLD_LOOK_S)){c.addClass("sapSuiteHBMCLookXS");if(s){s.setAttribute("viewBox","5 5 62 62");}}else if(f<this.convertRemToPixels(H.THRESHOLD_LOOK_M)){c.addClass("sapSuiteHBMCLookS");}else if(f<this.convertRemToPixels(H.THRESHOLD_LOOK_L)){c.addClass("sapSuiteHBMCLookM");}else{c.addClass("sapSuiteHBMCLookL");}b=c.width();P=p.width()+t.outerWidth();if(b<P){t.addClass("sapSuiteHBMCTextContainerHide");}};
H.prototype._parseFormattedValue=function(v){return{scale:v.replace(/.*?([^+-.,\d]*)$/g,"$1").trim(),value:v.replace(/(.*?)[^+-.,\d]*$/g,"$1").trim()};};
H.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
H.prototype.onkeydown=function(e){if(e.which==K.SPACE){e.preventDefault();}};
H.prototype.onkeyup=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
H.prototype.attachEvent=function(e,d,f,L){C.prototype.attachEvent.call(this,e,d,f,L);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};
H.prototype.detachEvent=function(e,f,L){C.prototype.detachEvent.call(this,e,f,L);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};
H.prototype.exit=function(e){D.media.detachHandler(this.rerender,this,D.media.RANGESETS.SAP_STANDARD);R.deregister(this._sChartResizeHandlerId);};
H.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};
H.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};
H.prototype._bindMouseEnterLeaveHandler=function(){this.$().bind("mouseenter.tooltip",this._addTitleAttribute.bind(this));this.$().bind("mouseleave.tooltip",this._removeTitleAttribute.bind(this));};
H.prototype._unbindMouseEnterLeaveHandler=function(){this.$().unbind("mouseenter.tooltip");this.$().unbind("mouseleave.tooltip");};
H._truncateValue=function(v,d){var h=v[d-1]==="."||v[d-1]===",";if(v.length>=d&&h){return v.substring(0,d-1);}else{return v.substring(0,d);}};
H.prototype._hasData=function(){return this.getItems().length>0;};
H.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};
a.extendMicroChart(H);return H;});
sap.ui.predefine('sap/suite/ui/microchart/HarveyBallMicroChartItem',["./library","sap/ui/core/Element"],function(l,E){"use strict";
var H=E.extend("sap.suite.ui.microchart.HarveyBallMicroChartItem",{metadata:{library:"sap.suite.ui.microchart",properties:{color:{group:"Misc",type:"sap.m.ValueCSSColor",defaultValue:"Neutral"},fraction:{group:"Misc",type:"float",defaultValue:0},fractionLabel:{group:"Misc",type:"string"},fractionScale:{group:"Misc",type:"string"},formattedLabel:{group:"Misc",type:"boolean",defaultValue:false}}}});
H.prototype.init=function(){this.setAggregation("tooltip","((AltText))",true);};
return H;});
sap.ui.predefine('sap/suite/ui/microchart/HarveyBallMicroChartRenderer',["sap/ui/thirdparty/jquery","sap/m/library","sap/ui/Device","./library","sap/base/security/encodeXML","sap/suite/ui/microchart/MicroChartRenderUtils","sap/ui/core/theming/Parameters"],function(q,M,D,l,e,a,P,V,b){"use strict";var V=M.ValueColor;var b=M.ValueCSSColor;var H;var c={};c._iReferenceControlSize=72;c._iReferenceControlCenter=c._iReferenceControlSize/2;
c.render=function(r,C){H=H||sap.ui.require("sap/suite/ui/microchart/HarveyBallMicroChart");if(!C._hasData()){r.write("<div");this._writeMainProperties(r,C);r.writeClasses();r.writeStyles();r.write(">");this._renderNoData(r);r.write("</div>");return;}if(!C._bThemeApplied){return;}this._calculatePath(C);var d=C.getColorPalette();var t="";var v="";var s="";var f=false;var g=0;var h="";var G=function(i){if(V[i]){h="sapSuiteHBMCSemanticColor"+e(i);}else if(b.isValid(i)){return P.get(i)||i;}return null;};var i=d.length>0?G(d[0]):null;var j=this._oPath.center;if(C._isThemeHighContrast()){j-=1;}if(C.getItems().length){var p=C.getItems()[0];g=p.getFraction();v=p.getFractionLabel()?p.getFractionLabel():v+p.getFraction();s=p.getFractionScale()?p.getFractionScale().substring(0,3):s;f=p.getFormattedLabel();if(!i&&!h){i=G(p.getColor());}}if(f){var F=C._parseFormattedValue(v);s=F.scale.substring(0,3);v=F.value;}var T=C.getTotal();var k=C.getTotalLabel()?C.getTotalLabel():""+C.getTotal();if(C.getTotalScale()){t=C.getTotalScale().substring(0,3);}if(C.getFormattedLabel()){var o=C._parseFormattedValue(k);t=o.scale.substring(0,3);k=o.value;}if(v){v=H._truncateValue(v,H.VALUE_TRUNCATION_DIGITS);}if(k){k=H._truncateValue(k,H.VALUE_TRUNCATION_DIGITS);}r.write("<div");this._writeMainProperties(r,C);r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapSuiteHBMCAlign"+C.getAlignContent());r.addClass("sapSuiteHBMCVerticalAlignmentContainer");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapSuiteHBMCChart");r.writeClasses();r.write(">");r.write("<svg");r.addClass("sapSuiteHBMCChartSvg");r.writeClasses();r.writeAttribute("id",C.getId()+"-harvey-ball");r.writeAttributeEscaped("viewBox","0 0 72 72");r.writeAttribute("focusable",false);r.write(">");r.write("<g>");r.write("<circle");r.writeAttributeEscaped("cx",this._oPath.center);r.writeAttributeEscaped("cy",this._oPath.center);r.writeAttributeEscaped("r",j);r.addClass("sapSuiteHBMCBackgroundCircle");r.writeClasses();r.write("/>");if(g&&g>=T){r.write("<circle");r.writeAttributeEscaped("cx",this._oPath.center);r.writeAttributeEscaped("cy",this._oPath.center);r.writeAttributeEscaped("r",j-this._oPath.border);r.addClass("sapSuiteHBMCSegment");if(i){r.addStyle("fill",i);r.writeStyles();}else{r.addClass(e(h));}r.writeClasses();r.write("/>");}else if(g>0){r.write("<path");r.writeAttribute("id",C.getId()+"-segment");r.addClass("sapSuiteHBMCSegment");if(i){r.addStyle("fill",i);r.writeStyles();}else{r.addClass(e(h));}r.writeClasses();r.writeAttributeEscaped("d",this._serializePieChart());r.write("/>");}r.write("</g>");r.write("</svg>");r.write("</div>");r.write("<div");r.addClass("sapSuiteHBMCTextContainer");r.writeClasses();r.write(">");if(C.getShowFractions()){r.write("<div");r.addClass("sapSuiteHBMCValueContainer");r.writeClasses();r.write(">");this.renderLabel(r,C,[h,"sapSuiteHBMCValue"],v,i,"-fraction");this.renderLabel(r,C,[h,"sapSuiteHBMCValueScale"],s,i,"-fraction-scale");r.write("</div>");}if(C.getShowTotal()){r.write("<div");r.addClass("sapSuiteHBMCTotalContainer");r.writeClasses();r.write(">");this.renderLabel(r,C,[h,"sapSuiteHBMCTotal"],k,i,"-total");this.renderLabel(r,C,[h,"sapSuiteHBMCTotalScale"],t,i,"-total-scale");r.write("</div>");}r.write("</div>");r.write("</div>");r.write("</div>");};
c._writeMainProperties=function(r,C){var i=C.hasListeners("press");this._renderActiveProperties(r,C);var A=C.getTooltip_AsString(i);r.writeAttribute("role","img");if(C.getAriaLabelledBy().length){r.writeAccessibilityState(C);}else{r.writeAttributeEscaped("aria-label",A);}r.writeControlData(C);r.addClass("sapSuiteHBMC");r.addClass("sapSuiteHBMCSize"+C.getSize());r.addStyle("width",C.getWidth());r.addStyle("height",C.getHeight());};
c.renderLabel=function(r,C,d,L,s,I){var u=!(d.indexOf("sapSuiteHBMCTotal")>-1||d.indexOf("sapSuiteHBMCTotalScale")>-1);r.write("<span");r.writeAttribute("id",C.getId()+I);for(var i=0;i<d.length;i++){if(!(i===0&&s&&u)){r.addClass(e(d[i]));}}r.writeClasses();r.write(">");if(L){r.writeEscaped(L);}r.write("</span>");};
c._calculatePath=function(C){var t=C.getTotal();var f=0;if(C.getItems().length){f=C.getItems()[0].getFraction();}var i=c._iReferenceControlCenter;var B=5;this._oPath={initial:{x:i,y:i},lineTo:{x:i,y:B},arc:{x1:i-B,y1:i-B,largeArc:0,x2:"",y2:""},size:c._iReferenceControlSize,border:B,center:i};var A=f/t*360;var r=Math.PI/180.0;var R=this._oPath.center-this._oPath.border;var d=R*Math.cos((A-90)*r)+this._oPath.center;var g=this._oPath.size-(R*Math.sin((A+90)*r)+this._oPath.center);this._oPath.arc.x2=d.toFixed(2);this._oPath.arc.y2=g.toFixed(2);var L=t/f<2?1:0;this._oPath.arc.largeArc=L;};
c._serializePieChart=function(){var p=this._oPath;return["M",p.initial.x,",",p.initial.y," L",p.initial.x,",",p.lineTo.y," A",p.arc.x1,",",p.arc.y1," 0 ",p.arc.largeArc,",1 ",p.arc.x2,",",p.arc.y2," L",p.initial.x,",",p.initial.y," z"].join("");};
a.extendMicroChartRenderer(c);return c;},true);
sap.ui.predefine('sap/suite/ui/microchart/InteractiveBarChart',["sap/ui/thirdparty/jquery",'./library','sap/m/library','sap/ui/core/Control','sap/ui/Device','sap/m/FlexBox','sap/ui/core/ResizeHandler',"sap/base/Log","./InteractiveBarChartRenderer"],function(q,l,M,C,D,F,R,L){"use strict";
var I=C.extend("sap.suite.ui.microchart.InteractiveBarChart",{metadata:{library:"sap.suite.ui.microchart",properties:{displayedBars:{type:"int",group:"Appearance",defaultValue:3},labelWidth:{type:"sap.ui.core.Percentage",group:"Appearance",defaultValue:"40%"},selectionEnabled:{type:"boolean",group:"Behavior",defaultValue:true},min:{type:"float",group:"Appearance"},max:{type:"float",group:"Appearance"}},defaultAggregation:"bars",aggregations:{bars:{type:"sap.suite.ui.microchart.InteractiveBarChartBar",multiple:true,bindable:"bindable"}},events:{selectionChanged:{parameters:{selectedBars:{type:"sap.suite.ui.microchart.InteractiveBarChartBar[]"},bar:{type:"sap.suite.ui.microchart.InteractiveBarChartBar"},selected:{type:"boolean"}}},press:{}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
I.MIN_BAR_WIDTH_IN_PX=1;I.BAR_VALUE_PADDING_LEFT_IN_PX=4;I.BAR_VALUE_PADDING_RIGHT_IN_PX=4;I.SELECTION_AREA_BORDER_IN_PX=1;I.DIVIDER_WIDTH_IN_PX=1;I.AREA_HEIGHT_MINVALUE=18;I.BAR_HEIGHT_FONT_SMALLER=22;I.BAR_HEIGHT_MINVALUE=6;I.BAR_HEIGHT_LABEL_HIDE=16;I.CHART_WIDTH_FONT_SMALLER=288;I.LABEL_WIDTH_MINVALUE=80;I.CHART_WIDTH_MINVALUE=130;I.AREA_HEIGHT_INTERACTIVE_MINVALUE=48;I.AREA_HEIGHT_INTERACTIVE_MINVALUE_COMPACT=32;I.AREA_HEIGHT_PADDING_STAGE1=34;I.AREA_HEIGHT_PADDING_STAGE1_COMPACT=32;I.AREA_HEIGHT_PADDING_STAGE2=28;I.AREA_HEIGHT_PADDING_STAGE2_COMPACT=31;
I.prototype.init=function(){this._iVisibleBars=0;this._bInteractiveMode=true;this._bMinMaxValid=null;this._fDividerPositionRight=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this._fMin=null;this._fMax=null;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
I.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);};
I.prototype.onBeforeRendering=function(){this._bCompact=this._isCompact();this._bInteractiveMode=true;this._setResponsivenessData();this._setInternalMinMax();this._bMinMaxValid=this._checkIfMinMaxValid();if(this.getAggregation("bars")&&this.getDisplayedBars()){this._iVisibleBars=Math.min(this.getAggregation("bars").length,this.getDisplayedBars());}if(!this.data("_parentRenderingContext")&&q.isFunction(this.getParent)){this.data("_parentRenderingContext",this.getParent());}this._deregisterResizeHandler();this._updateUseSemanticTooltip();};
I.prototype.onAfterRendering=function(){this._adjustToParent();l._checkControlIsVisible(this,this._onControlIsVisible);};
I.prototype._updateUseSemanticTooltip=function(){var b=this.getBars();this._bUseSemanticTooltip=false;for(var i=0;i<this._iVisibleBars;i++){if(b[i].getColor()!==M.ValueColor.Neutral){this._bUseSemanticTooltip=true;return;}}};
I.prototype._onControlIsVisible=function(){this._sResizeHandlerId=R.register(this,this._onResize.bind(this));this._calcBarsWidth();this._onResize();if(this.$().length>0){var c=this._isCompact();if(c!==this._bCompact){this._bCompact=c;this.invalidate();}}};
I.prototype.exit=function(){this._deregisterResizeHandler();};
I.prototype.onclick=function(e){if(!this.getSelectionEnabled()){return;}if(this._bInteractiveMode){var i=q(e.target).attr("id")||q(e.target).parents(".sapSuiteIBCBarInteractionArea").attr("id"),f=this.$().find(".sapSuiteIBCBarInteractionArea"),a,h;if(i){a=i.substring(i.lastIndexOf("-")+1);if(isNaN(a)){return;}else{a=parseInt(a);}this._toggleSelected(a);h=f.index(this.$().find(".sapSuiteIBCBarInteractionArea[tabindex='0']"));this._switchTabindex(h,a,f);}}else{this.firePress();if(D.browser.msie){this.$().focus();e.preventDefault();}}};
I.prototype.onsapenter=function(e){if(this._bInteractiveMode){var i=this.$().find(".sapSuiteIBCBarInteractionArea").index(e.target);if(i!==-1){this._toggleSelected(i);}e.preventDefault();e.stopImmediatePropagation();}else{this.firePress();}};
I.prototype.onsapspace=I.prototype.onsapenter;
I.prototype.onsapup=function(e){var f=this.$().find(".sapSuiteIBCBarInteractionArea");var i=f.index(e.target);if(f.length>0){this._switchTabindex(i,i-1,f);}e.preventDefault();e.stopImmediatePropagation();};
I.prototype.onsapdown=function(e){var f=this.$().find(".sapSuiteIBCBarInteractionArea");var i=f.index(e.target);if(f.length>0){this._switchTabindex(i,i+1,f);}e.preventDefault();e.stopImmediatePropagation();};
I.prototype.onsaphome=function(e){var f=this.$().find(".sapSuiteIBCBarInteractionArea");var i=f.index(e.target);if(i!==0&&f.length>0){this._switchTabindex(i,0,f);}e.preventDefault();e.stopImmediatePropagation();};
I.prototype.onsapend=function(e){var f=this.$().find(".sapSuiteIBCBarInteractionArea"),i=f.index(e.target),a=f.length;if(i!==a-1&&a>0){this._switchTabindex(i,a-1,f);}e.preventDefault();e.stopImmediatePropagation();};
I.prototype.onsapleft=I.prototype.onsapup;I.prototype.onsapright=I.prototype.onsapdown;
I.prototype.getSelectedBars=function(){var b=this.getAggregation("bars"),s=[],i;for(i=0;i<b.length;i++){if(b[i].getSelected()){s.push(b[i]);}}return s;};
I.prototype.setSelectedBars=function(s){var b=this.getAggregation("bars"),i,a;this._deselectAllSelectedBars();if(!s){return this;}if(s instanceof l.InteractiveBarChartBar){s=[s];}if(Array.isArray(s)){for(i=0;i<s.length;i++){a=this.indexOfAggregation("bars",s[i]);if(a>=0){b[a].setProperty("selected",true,true);}else{L.warning("setSelectedBars method called with invalid InteractiveBarChartBar element");}}}this.invalidate();return this;};
I.prototype.getTooltip_AsString=function(){var t=this.getTooltip_Text();if(!t){t=this._createTooltipText();}else if(l._isTooltipSuppressed(t)){t=null;}return t;};
I.prototype._isCompact=function(){return q("body").hasClass("sapUiSizeCompact")||this.$().is(".sapUiSizeCompact")||this.$().closest(".sapUiSizeCompact").length>0;};
I.prototype._setResponsivenessData=function(){if(this._bCompact){this._iAreaHeightInteractiveMinValue=I.AREA_HEIGHT_INTERACTIVE_MINVALUE_COMPACT;this._iAreaHeightPaddingStage1=I.AREA_HEIGHT_PADDING_STAGE1_COMPACT;this._iAreaHeightPaddingStage2=I.AREA_HEIGHT_PADDING_STAGE2_COMPACT;}else{this._iAreaHeightInteractiveMinValue=I.AREA_HEIGHT_INTERACTIVE_MINVALUE;this._iAreaHeightPaddingStage1=I.AREA_HEIGHT_PADDING_STAGE1;this._iAreaHeightPaddingStage2=I.AREA_HEIGHT_PADDING_STAGE2;}};
I.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._bCompact=this._isCompact();this.invalidate();};
I.prototype._adjustToParent=function(){var $=this.$();if(this.data("_parentRenderingContext")&&this.data("_parentRenderingContext")instanceof F){var p=this.data("_parentRenderingContext").$();var P=p.width()-2;var i=p.height()-2;$.outerWidth(P);$.outerHeight(i);}};
I.prototype._calcBarsWidth=function(){var $=this.$(),b=$.find(".sapSuiteIBCBarLabel"),d=I.DIVIDER_WIDTH_IN_PX,f=parseFloat(this.getLabelWidth()),B,t,a,c,e,g,v,E,h,j,r=sap.ui.getCore().getConfiguration().getRTL();if(!this._bMinMaxValid){return this;}if(this._bFullWidth){f=100;B=100;}else{B=100-f;}t=Math.abs(this._fMax-this._fMin);if(this._fMin>=0&&this._fMax>=0){a=0;c=1;}else if(this._fMin<0&&this._fMax<0){a=1;c=0;}else{a=Math.abs(this._fMin/t);c=Math.abs(this._fMax/t);}if(this._bFullWidth){if(c>=a){e=c*100;g=a*100;}else{e=a*100;g=0;}b.css("width",e+"%");b.css(r?"right":"left",g+"%");}else{b.css("width",f+"%");b.css(r?"right":"left","");}$.find(".sapSuiteIBCBarWrapper").css("width",B+"%");if(a>0){$.find(".sapSuiteIBCBarWrapperNegative").width("calc("+a*100+"% - "+d+"px)");}else{$.find(".sapSuiteIBCBarWrapperNegative").width("0%");}if(c>0){$.find(".sapSuiteIBCBarWrapperPositive").width("calc("+c*100+"% - "+d+"px)");}else{$.find(".sapSuiteIBCBarWrapperPositive").width("0%");}for(var i=0;i<this._iVisibleBars;i++){v=this.getBars()[i].getValue();h=this.$("bar-negative-"+i);j=this.$("bar-positive-"+i);if(this.getBars()[i]._bNullValue||v===0){j.add(h).css("min-width",0);}else if(!this.getBars()[i]._bNullValue){if(v>0){E=Math.min(Math.max(v,this._fMin),this._fMax);j.css({"width":this._calcPercent(E,t,Math.max(0,this._fMin),c),"min-width":1});h.css("min-width",0);}else{E=Math.max(Math.min(v,this._fMax),this._fMin);h.css({"width":this._calcPercent(E,t,Math.min(0,this._fMax),a),"min-width":1});j.css("min-width",0);}}}};
I.prototype._calcPercent=function(v,t,s,a){return Math.abs((v-s)/(t*a)*100).toFixed(5)+"%";};
I.prototype._deselectAllSelectedBars=function(){var b=this.getAggregation("bars"),B=b.length,i;for(i=0;i<B;i++){b[i].setProperty("selected",false,true);}};
I.prototype._toggleSelected=function(i){var b=this.getAggregation("bars"),B=b[i];if(i<0||i>=b.length){return;}var $=this.$("interactionArea-"+i);if(B.getSelected()){$.removeClass("sapSuiteIBCBarSelected");B.setProperty("selected",false,true);}else{$.addClass("sapSuiteIBCBarSelected");B.setProperty("selected",true,true);}$.attr("aria-selected",B.getSelected());this.fireSelectionChanged({selectedBars:this.getSelectedBars(),bar:B,selected:B.getSelected()});};
I.prototype._showValueOutsideBar=function(){var $=this.$(),b,v,B,V,f,a,c,d,e=this.$("bar-positive-0").parent().width(),g=this.$("bar-negative-0").parent().width(),r=sap.ui.getCore().getConfiguration().getRTL();b=$.find(".sapSuiteIBCBarValue");if(b.length===0){return;}for(var i=0;i<this._iVisibleBars;i++){V=this.getBars()[i].getValue();B=(b.eq(i).width()+I.BAR_VALUE_PADDING_LEFT_IN_PX+I.BAR_VALUE_PADDING_RIGHT_IN_PX);f=this.$("bar-positive-"+i).width();a=this.$("bar-negative-"+i).width();c=e-f;d=g-a;if(V>0||((this.getBars()[i]._bNullValue||V===0)&&this._fMin+this._fMax>=0)){if(B>f&&B>c){b.eq(i).css("visibility","hidden");}else{b.eq(i).css("visibility","inherit");}if(B>f){v=(this.$("bar-positive-"+i).width()+I.BAR_VALUE_PADDING_LEFT_IN_PX)+"px";b.eq(i).addClass("sapSuiteIBCBarValueOutside");}else{v="";b.eq(i).removeClass("sapSuiteIBCBarValueOutside");}if(r){b.eq(i).css({"right":v});}else{b.eq(i).css({"left":v});}}else{if(B>a&&B>d){b.eq(i).css("visibility","hidden");}else{b.eq(i).css("visibility","inherit");}if(B>a){v=(this.$("bar-negative-"+i).width()+I.BAR_VALUE_PADDING_RIGHT_IN_PX)+"px";b.eq(i).addClass("sapSuiteIBCBarValueOutside");}else{v="";b.eq(i).removeClass("sapSuiteIBCBarValueOutside");}if(r){b.eq(i).css({"left":v});}else{b.eq(i).css({"right":v});}}}};
I.prototype._checkIfMinMaxValid=function(){if(this._fMin>this._fMax){L.warning("Min value for InteractiveBarChart is larger than Max value.");return false;}return true;};
I.prototype._setInternalMinMax=function(){var m=null,f=null,b,B=this.getBars(),r=Math.min(this.getDisplayedBars(),B.length);for(var i=0;i<r;i++){if(!B[i]._bNullValue){b=B[i].getValue();m=Math.min(m,b);f=Math.max(f,b);}}this._fMin=this.getMin();this._fMax=this.getMax();if(!q.isNumeric(this._fMin)||!q.isNumeric(this._fMax)){if(m>=0&&f>=0){if(!q.isNumeric(this._fMin)){this._fMin=0;}if(!q.isNumeric(this._fMax)){this._fMax=f;}}else if(m<0&&f<0){if(!q.isNumeric(this._fMin)){this._fMin=m;}if(!q.isNumeric(this._fMax)){this._fMax=0;}}else{if(!q.isNumeric(this._fMin)){this._fMin=m;}if(!q.isNumeric(this._fMax)){this._fMax=f;}}}};
I.prototype.validateProperty=function(p,v){if(p==="labelWidth"&&(v!==null||v!==undefined)){var V=parseFloat(v);if(V<0||V>100){L.warning("LabelWidth for InteractiveBarChart is not between 0 and 100.");v=null;}}return C.prototype.validateProperty.apply(this,[p,v]);};
I.prototype._switchTabindex=function(o,n,f){if(o>=0&&o<f.length&&n>=0&&n<f.length){f.eq(o).removeAttr("tabindex");f.eq(n).attr("tabindex","0");f.eq(n).focus();}};
I.prototype._isChartEnabled=function(){return this.getSelectionEnabled()&&this._bInteractiveMode;};
I.prototype._resizeVertically=function(f){var a,m,b,$=this.$(),s=false,S=$.find(".sapSuiteIBCBarInteractionArea"),c=$.height(),i=0,v=this._iVisibleBars;if(this._bInteractiveMode){i=1;}m=parseInt(S.css("margin-bottom"))+parseInt(S.css("margin-top"));a=((c-((m+2*I.SELECTION_AREA_BORDER_IN_PX)*v))/v);if(a+i<this._iAreaHeightInteractiveMinValue){if(this._bInteractiveMode){this._bInteractiveMode=false;s=true;$.addClass("sapSuiteIBCNonInteractive");if(this.getSelectionEnabled()){var A=this.$().find(".sapSuiteIBCBarInteractionArea[tabindex='0']");this._iActiveElement=S.index(A);A.removeAttr("tabindex");this.$().attr("tabindex","0");}this.$().attr({"role":"button","aria-multiselectable":"false","aria-disabled":!this._isChartEnabled()});}}else if(!this._bInteractiveMode){this._bInteractiveMode=true;s=true;$.removeClass("sapSuiteIBCNonInteractive");if(this.getSelectionEnabled()){this.$().removeAttr("tabindex");if(!this._iActiveElement||this._iActiveElement<0){this._iActiveElement=0;}S.eq(this._iActiveElement).attr("tabindex","0");}this.$().attr({"role":"listbox","aria-multiselectable":"true","aria-disabled":!this._isChartEnabled()});}if(s){if(this._isChartEnabled()){$.removeAttr("title");this._addInteractionAreaTooltip(S);}else{S.removeAttr("title");$.attr("title",this.getTooltip_AsString());}}S.height(a);if(a<=this._iAreaHeightPaddingStage2){$.addClass("sapSuiteIBCStage2");}else{$.removeClass("sapSuiteIBCStage2");if(a<=this._iAreaHeightPaddingStage1){$.addClass("sapSuiteIBCStage1");}else{$.removeClass("sapSuiteIBCStage1");}}var B=this.$().find(".sapSuiteIBCBar");if(B.length>0&&B[0].getBoundingClientRect()){b=B[0].getBoundingClientRect().height;}if(b<=I.BAR_HEIGHT_FONT_SMALLER){$.addClass("sapSuiteIBCSmallFont");}if(b<=I.BAR_HEIGHT_LABEL_HIDE){$.find(".sapSuiteIBCBarValue").css("visibility","hidden");f.labelsVisible=false;}else{$.find(".sapSuiteIBCBarValue").css("visibility","inherit");}if(a<I.AREA_HEIGHT_MINVALUE){$.css("visibility","hidden");f.labelsVisible=false;f.chartVisible=false;}};
I.prototype._resizeHorizontally=function(f){if(!f.chartVisible){return;}var $=this.$(),s=$.find(".sapSuiteIBCBarInteractionArea"),b=$.find(".sapSuiteIBCBarLabel"),B=parseFloat(this.getLabelWidth())/100*s.eq(0).width(),a=0,c=$.width(),d,e=false;if(c<I.CHART_WIDTH_FONT_SMALLER){$.addClass("sapSuiteIBCSmallFont");B=parseFloat(this.getLabelWidth())/100*s.eq(0).width();}if(this._bFullWidth){a=6;}for(var i=0;i<b.length;i++){b.eq(i).css("width",B+"px");if(b.eq(i).children(".sapSuiteIBCBarLabelText").prop("clientWidth")<b.eq(i).children(".sapSuiteIBCBarLabelText").prop("scrollWidth")-a){e=true;}b.eq(i).css("width","100%");}if(B<I.LABEL_WIDTH_MINVALUE&&e){$.addClass("sapSuiteIBCFullWidth");this._bFullWidth=true;this._calcBarsWidth();}else{$.removeClass("sapSuiteIBCFullWidth");this._bFullWidth=false;this._calcBarsWidth();}var g=this.$().find(".sapSuiteIBCBar");if(g.length>0&&g[0].getBoundingClientRect()){d=g[0].getBoundingClientRect().height;}if(c<I.CHART_WIDTH_MINVALUE||d<I.BAR_HEIGHT_MINVALUE){$.css("visibility","hidden");f.labelsVisible=false;f.chartVisible=false;}else if(d<=I.BAR_HEIGHT_LABEL_HIDE){$.find(".sapSuiteIBCBarValue").css("visibility","hidden");f.labelsVisible=false;}};
I.prototype._onResize=function(){var $=this.$(),f={chartVisible:true,labelsVisible:true};$.css("visibility","visible");$.removeClass("sapSuiteIBCSmallFont");this._resizeVertically(f);this._resizeHorizontally(f);if(f.labelsVisible){this._showValueOutsideBar();}};
I.prototype._deregisterResizeHandler=function(){if(this._sResizeHandlerId){R.deregister(this._sResizeHandlerId);this._sResizeHandlerId=null;}};
I.prototype._addInteractionAreaTooltip=function(s){var b=this.getBars(),e,S;s.each(function(i,a){e=q(a);S=parseInt(e.attr("data-sap-ui-ibc-selection-index"));e.attr("title",b[S].getTooltip_AsString());});};
I.prototype._createTooltipText=function(){var b=true,B=this.getBars(),s,t="";for(var i=0;i<this._iVisibleBars;i++){s=B[i]._getBarTooltip(this._bUseSemanticTooltip);if(s){t+=(b?"":"\n")+s;b=false;}}return t;};
return I;});
sap.ui.predefine('sap/suite/ui/microchart/InteractiveBarChartBar',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var I=E.extend("sap.suite.ui.microchart.InteractiveBarChartBar",{metadata:{library:"sap.suite.ui.microchart",properties:{label:{type:"string",group:"Misc",defaultValue:null},selected:{type:"boolean",group:"Appearance",defaultValue:false},displayedValue:{type:"string",group:"Data",defaultValue:null},color:{type:"sap.m.ValueColor",group:"Misc",defaultValue:"Neutral"},value:{type:"float",group:"Data"}}}});
I.prototype.init=function(){this._bNullValue=true;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");};
I.prototype.validateProperty=function(p,v){if(p==="value"&&(v===null||v===undefined||isNaN(v))){this._bNullValue=true;}else if(p==="value"){this._bNullValue=false;}return E.prototype.validateProperty.apply(this,arguments);};
I.prototype.getTooltip_AsString=function(){var t=this.getTooltip_Text();this._bCustomTooltip=true;if(!t){t=this._createTooltipText();this._bCustomTooltip=false;}else if(l._isTooltipSuppressed(t)){t=null;}return t;};
I.prototype._createTooltipText=function(){var t="",L=this.getLabel(),i=this.getParent()&&this.getParent()._bUseSemanticTooltip,c,s;if(L&&L.length>0){t=L+":\n";}if(this._bNullValue){t+=this._oRb.getText("INTERACTIVECHART_NA");}else{t+=this.getValue();}if(i){c=this.getColor();s=this._oRb.getText(("SEMANTIC_COLOR_"+c).toUpperCase());t+=" "+s;}return t;};
I.prototype._getBarTooltip=function(){var t=this.getTooltip_AsString();if(t&&!this._bCustomTooltip){t=t.replace("\n"," ");}return t;};
return I;});
sap.ui.predefine('sap/suite/ui/microchart/InteractiveBarChartRenderer',["sap/ui/thirdparty/jquery","sap/m/library"],function(q,M){"use strict";var I={};I.BAR_DIRECTION_POSITIVE={NAME:"positive",WRAPPER_CSSCLASS:"sapSuiteIBCBarWrapperPositive",CSSCLASS:"sapSuiteIBCBarPositive"};I.BAR_DIRECTION_NEGATIVE={NAME:"negative",WRAPPER_CSSCLASS:"sapSuiteIBCBarWrapperNegative",CSSCLASS:"sapSuiteIBCBarNegative"};
I.render=function(r,c){if(!c._bThemeApplied){return;}var b=c.getBars(),B=Math.min(c.getDisplayedBars(),b.length);r.write("<div");r.writeControlData(c);r.addClass("sapSuiteIBC");r.writeClasses();r.writeStyles();if(!c._isChartEnabled()){var a=c.getTooltip_AsString();if(q.type(a)==="string"){r.writeAttributeEscaped("title",a);}}var A={};A.role="listbox";A.multiselectable=true;A.disabled=!c._isChartEnabled();A.labelledby=c.getAriaLabelledBy();A.describedby=this._getAriaDescribedBy(c,B);r.writeAccessibilityState(c,A);r.write(">");if(!c.getSelectionEnabled()){this.renderDisabledOverlay(r,c);}for(var i=0;i<B;i++){this._renderBar(r,c,b[i],i,B);}r.write("</div>");};
I._renderBar=function(r,c,b,a,d){var v,l,t,A,C,L;r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-interactionArea-"+a);r.writeAttributeEscaped("data-sap-ui-ibc-selection-index",a);r.addClass("sapSuiteIBCBarInteractionArea");if(b.getSelected()){r.addClass("sapSuiteIBCBarSelected");}if(a===0&&c._isChartEnabled()){r.writeAttribute("tabindex","0");}if(c._isChartEnabled()){t=b.getTooltip_AsString();if(q.type(t)==="string"){r.writeAttributeEscaped("title",t);}}l=b.getLabel();A=l;if(c._bMinMaxValid){v=this._getDisplayValue(b,c);var t=b.getTooltip_Text();if(t&&q.trim(t).length>0){A=t;}else{if(A){A=A+" "+v;}else{A=v;}if(c._bUseSemanticTooltip){C=b.getColor();L=c._oRb.getText(("SEMANTIC_COLOR_"+C.toUpperCase()));A+=" "+L;}}}var o={};o.role="option";o.label=A;o.selected=b.getSelected();o.posinset=a+1;o.setsize=d;r.writeAccessibilityState(b,o);r.writeStyles();r.writeClasses();r.write(">");l=b.getLabel();if(b.getColor()!==M.ValueColor.Neutral){r.write("<div");r.addClass("sapSuiteIBCSemanticMarker");r.addClass("sapSuiteIBCSemantic"+b.getColor());r.writeClasses();r.write("></div>");}r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-label-"+a);r.addClass("sapSuiteIBCBarLabel");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapSuiteIBCBarLabelText");r.writeClasses();r.write(">");r.writeEscaped(l);r.write("</div>");r.write("</div>");if(c._bMinMaxValid){r.write("<div");r.addClass("sapSuiteIBCBarWrapper");r.writeClasses();r.write(">");this._renderBarDirection(r,c,b,a,v,I.BAR_DIRECTION_NEGATIVE);r.write("<div");r.addClass("sapSuiteIBCDivider");r.writeClasses();r.write("></div>");this._renderBarDirection(r,c,b,a,v,I.BAR_DIRECTION_POSITIVE);r.write("</div>");}r.write("</div>");};
I._renderBarDirection=function(r,c,b,a,d,e){var v=b.getValue();r.write("<div");r.addClass(e.WRAPPER_CSSCLASS);r.writeClasses();r.write(">");r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-bar-"+e.NAME+"-"+a);r.addClass("sapSuiteIBCBar");r.addClass(e.CSSCLASS);if(v>0){r.addClass("sapSuiteIBCValuePositive");}else if(v===0||b._bNullValue){r.addClass("sapSuiteIBCBarValueNull");}else{r.addClass("sapSuiteIBCValueNegative");}r.writeClasses();r.write(">");this._renderDisplayedValue(r,c,b,c.getId(),a,d,e);r.write("</div>");r.write("</div>");};
I._renderDisplayedValue=function(r,c,b,a,d,e,f){var i=b.getValue()===0,p;if(b._bNullValue||i){if(c._fMin<0&&c._fMax>0){p=Math.abs(c._fMax)>=Math.abs(c._fMin);}else{p=c._fMin>=0;}}else{p=b.getValue()>=0;}if(f===I.BAR_DIRECTION_POSITIVE&&p||f===I.BAR_DIRECTION_NEGATIVE&&!p){if(b._bNullValue||i){r.addClass("sapSuiteIBCBarValueAutoAlignment");r.addClass("sapSuiteIBCBarValueOutside");}r.write("<span");r.writeAttributeEscaped("id",a+"-displayedValue-"+d);r.addClass("sapSuiteIBCBarValue");r.writeClasses();r.write(">");r.writeEscaped(e);r.write("</span>");}};
I.renderDisabledOverlay=function(r,c){r.write("<div");r.addClass("sapSuiteIBCDisabledOverlay");r.writeClasses();r.write(">");r.write("</div>");};
I._getDisplayValue=function(b,c){var v,V;v=b.getDisplayedValue();V=b.getValue();if(b._bNullValue){v=c._oRb.getText("INTERACTIVECHART_NA");}else if(!v){v=V.toString();}return v;};
I._getAriaDescribedBy=function(c,b){var a=[];for(var i=0;i<b;i++){a.push(c.getId()+"-interactionArea-"+i);}return a.join(",");};
return I;},true);
sap.ui.predefine('sap/suite/ui/microchart/InteractiveDonutChart',["sap/ui/thirdparty/jquery","./library","sap/m/library","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/Device","sap/m/FlexBox","sap/base/Log","./InteractiveDonutChartRenderer"],function(q,l,M,C,R,D,F,L){"use strict";
var I=C.extend("sap.suite.ui.microchart.InteractiveDonutChart",{metadata:{library:"sap.suite.ui.microchart",properties:{displayedSegments:{type:"int",group:"Appearance",defaultValue:3},selectionEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"segments",aggregations:{segments:{type:"sap.suite.ui.microchart.InteractiveDonutChartSegment",multiple:true,bindable:"bindable"}},events:{selectionChanged:{parameters:{selectedSegments:{type:"sap.suite.ui.microchart.InteractiveDonutChartSegment[]"},segment:{type:"sap.suite.ui.microchart.InteractiveDonutChartSegment"},selected:{type:"boolean"}}},press:{}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
I.SEGMENT_CSSCLASS_SELECTED="sapSuiteIDCLegendSegmentSelected";I.SEGMENT_CSSCLASS_HIGHLIGHT="sapSuiteIDCLegendSegmentHover";I.CHART_SEGMENT_LABEL_MAXLENGTH=7;I.CHART_SEGMENT={CSSCLASS:"sapSuiteIDCChartSegment",CSSCLASS_HIGHLIGHT:"sapSuiteIDCChartSegmentHighlight",CSSCLASS_SELECTED:"sapSuiteIDCChartSegmentSelected"};I.CHART_SEGMENT_GHOST={CSSCLASS:"sapSuiteIDCChartSegmentGhost",CSSCLASS_HIGHLIGHT:"sapSuiteIDCChartSegmentGhostHighlight",CSSCLASS_SELECTED:"sapSuiteIDCChartSegmentGhostSelected"};I.AREA_HEIGHT_INTERACTIVE_MINVALUE=48;I.AREA_HEIGHT_INTERACTIVE_MINVALUE_COMPACT=32;I.AREA_HEIGHT_SMALLFONT=36;I.AREA_HEIGHT_SMALLFONT_COMPACT=32;I.AREA_HEIGHT_MINVALUE=18;I.LEGEND_HEIGHT_PADDING=6;I.CHART_HEIGHT_MINVALUE=110;I.CHART_WIDTH_MINVALUE=130;I.CHART_WIDTH_HIDEDONUT_MINVALUE=225;I.CHART_WIDTH_LEGENDPADDING_MINVALUE=300;I.CHART_WIDTH_FULLWIDTH_SMALLFONT_MINVALUE=180;
I.prototype.onclick=function(e){if(!this.getSelectionEnabled()){return;}if(this._bInteractiveMode){var t=q(e.target),i=t.data("sap-ui-idc-selection-index"),s=this.getAggregation("segments"),f=this.$().find(".sapSuiteIDCLegendSegment"),h;if(!(i>=0)){i=t.closest(".sapSuiteIDCLegendSegment").data("sap-ui-idc-selection-index");}if(isNaN(i)||i<0||i>=s.length){return;}this._toggleSelected(i);h=f.index(this.$().find(".sapSuiteIDCLegendSegment[tabindex='0']"));this._switchTabindex(h,i,f);}else{this.firePress();if(D.browser.msie){this.$().focus();e.preventDefault();}}};
I.prototype.onsapup=function(e){var f=this.$().find(".sapSuiteIDCLegendSegment");var i=f.index(e.target);if(f.length>0){this._switchTabindex(i,i-1,f);}e.preventDefault();e.stopImmediatePropagation();};
I.prototype.onsapdown=function(e){var f=this.$().find(".sapSuiteIDCLegendSegment");var i=f.index(e.target);if(f.length>0){this._switchTabindex(i,i+1,f);}e.preventDefault();e.stopImmediatePropagation();};
I.prototype.onsaphome=function(e){var f=this.$().find(".sapSuiteIDCLegendSegment");var i=f.index(e.target);if(i!==0&&f.length>0){this._switchTabindex(i,0,f);}e.preventDefault();e.stopImmediatePropagation();};
I.prototype.onsapend=function(e){var f=this.$().find(".sapSuiteIDCLegendSegment");var i=f.index(e.target);var a=f.length;if(i!==a-1&&a>0){this._switchTabindex(i,a-1,f);}e.preventDefault();e.stopImmediatePropagation();};
I.prototype.onsapenter=function(e){if(this._bInteractiveMode){var i=this.$().find(".sapSuiteIDCLegendSegment").index(e.target);if(i!==-1){this._toggleSelected(i);}e.preventDefault();e.stopImmediatePropagation();}else{this.firePress();}};
I.prototype.onsapleft=I.prototype.onsapup;I.prototype.onsapright=I.prototype.onsapdown;I.prototype.onsapspace=I.prototype.onsapenter;
I.prototype.getTooltip_AsString=function(){var t=this.getTooltip_Text();if(!t){t=this._createTooltipText();}else if(l._isTooltipSuppressed(t)){t=null;}return t;};
I.prototype.getSelectedSegments=function(){var s,S;s=this.getAggregation("segments");S=[];for(var i=0;i<s.length;i++){if(s[i].getSelected()){S.push(s[i]);}}return S;};
I.prototype.setSelectedSegments=function(s){var S,a,b;S=this.getAggregation("segments");this._deselectAllSelectedSegments();if(!s){return this;}if(s instanceof l.InteractiveDonutChartSegment){s=[s];}if(Array.isArray(s)){b=s.length;for(var i=0;i<b;i++){a=this.indexOfAggregation("segments",s[i]);if(a>=0&&S[a]){S[a].setProperty("selected",true,true);}else{L.warning("Method setSelectedSegments called with invalid InteractiveDonutChartSegment element");}}}this.invalidate();return this;};
I.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
I.prototype.onBeforeRendering=function(){this._bCompact=this._isCompact();this._bInteractiveMode=true;var s=this.getSegments();this._iVisibleSegments=Math.min(this.getDisplayedSegments(),s.length);this._setResponsivenessData();var S=this.$().find(".sapSuiteIDCChartSegment, .sapSuiteIDCLegendSegment, .sapSuiteIDCChartSegmentGhost");S.off();if(!this.data("_parentRenderingContext")&&q.isFunction(this.getParent)){this.data("_parentRenderingContext",this.getParent());}this._deregisterResizeHandler();this._bSemanticTooltip=false;for(var i=0;i<this._iVisibleSegments;i++){if(s[i].getColor()!==M.ValueColor.Neutral){this._bSemanticTooltip=true;break;}}};
I.prototype.onAfterRendering=function(){this._adjustToParent(this.$());l._checkControlIsVisible(this,this._onControlIsVisible);};
I.prototype._onControlIsVisible=function(){if(this._bInteractiveMode){this._sResizeHandlerId=R.register(this,this._onResize.bind(this));this._onResize();if(this.$().length>0){var c=this._isCompact();if(c!==this._bCompact){this._bCompact=c;this.invalidate();}}if(D.system.desktop){this._attachHoverHandlers();}}};
I.prototype.exit=function(){this._deregisterResizeHandler();};
I.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);};
I.prototype._deselectAllSelectedSegments=function(){var s=this.getAggregation("segments");for(var i=0;i<s.length;i++){if(s[i].getSelected()){s[i].setProperty("selected",false,true);}}};
I.prototype._attachHoverHandlers=function(){var t=this,s=this.$().find(".sapSuiteIDCChartSegment, .sapSuiteIDCLegendSegment, .sapSuiteIDCChartSegmentGhost");s.on({mousemove:function(){t._handleHoverSync(q(this).data("sap-ui-idc-selection-index"));},mouseleave:function(){t._handleHoverSync(q(this).data("sap-ui-idc-selection-index"),true);}});};
I.prototype._handleHoverSync=function(i,o){if(this._bInteractiveMode){var s=this.getAggregation("segments"),S=s[i].getSelected();this._setSegmentInteractionState(I.CHART_SEGMENT,i,S,o);this._setSegmentInteractionState(I.CHART_SEGMENT_GHOST,i,S,o);this._setLegendEntryInteractionState(i,S,o);}};
I.prototype._setSegmentInteractionState=function(s,i,a,o){var S=this.$().find("."+s.CSSCLASS+"[data-sap-ui-idc-selection-index='"+i+"']");S.removeClass(s.CSSCLASS_SELECTED);S.removeClass(s.CSSCLASS_HIGHLIGHT);if(!o){S.addClass(s.CSSCLASS_HIGHLIGHT);}if(a){S.addClass(s.CSSCLASS_SELECTED);}};
I.prototype._setLegendEntryInteractionState=function(i,s,o){var e=this.$().find(".sapSuiteIDCLegendSegment[data-sap-ui-idc-selection-index='"+i+"']");e.removeClass(I.SEGMENT_CSSCLASS_SELECTED);e.removeClass(I.SEGMENT_CSSCLASS_HIGHLIGHT);if(!o){e.addClass(I.SEGMENT_CSSCLASS_HIGHLIGHT);}if(s){e.addClass(I.SEGMENT_CSSCLASS_SELECTED);}};
I.prototype._switchModeInteractive=function(a){var $=this.$(),s=false;if(a<this._iAreaHeightInteractiveMinValue){s=true;if(this._bInteractiveMode){this._bInteractiveMode=false;$.addClass("sapSuiteIDCNonInteractive");if(this.getSelectionEnabled()){var A=$.find(".sapSuiteIDCLegendSegment[tabindex='0']");this._iActiveElement=$.find(".sapSuiteIDCLegendSegment").index(A);A.removeAttr("tabindex");$.attr("tabindex","0");}$.attr({"role":"button","aria-multiselectable":"false","aria-disabled":!this._isChartEnabled()});}}else if(!this._bInteractiveMode){s=true;this._bInteractiveMode=true;$.removeClass("sapSuiteIDCNonInteractive");if(this.getSelectionEnabled()){$.removeAttr("tabindex");if(!this._iActiveElement||this._iActiveElement<0){this._iActiveElement=0;}$.find(".sapSuiteIDCLegendSegment").eq(this._iActiveElement).attr("tabindex","0");}$.attr({"role":"listbox","aria-multiselectable":"true","aria-disabled":!this._isChartEnabled()});}if(s){if(this._isChartEnabled()){$.removeAttr("title");this._addInteractionAreaTooltip();}else{$.find(".sapSuiteIDCChartSegment title, .sapSuiteIDCChartSegmentGhost title").remove();$.find(".sapSuiteIDCLegendSegment").removeAttr("title");$.attr("title",this.getTooltip_AsString());}}};
I.prototype._addInteractionAreaTooltip=function(){var t,e,s,$=this.$(),S=this.getSegments();$.find(".sapSuiteIDCChartSegment, .sapSuiteIDCChartSegmentGhost").each(function(i,a){e=q(a);s=parseInt(e.attr("data-sap-ui-idc-selection-index"));t=q("<div/>").text(S[s].getTooltip_AsString());e.html("<title>"+t.getEncodedText()+"</title>");});$.find(".sapSuiteIDCLegendSegment").each(function(i,a){e=q(a);s=parseInt(e.attr("data-sap-ui-idc-selection-index"));e.attr("title",S[s].getTooltip_AsString());});};
I.prototype._onResize=function(){var i,a,$=this.$(),b=$.find(".sapSuiteIDCLegendSegment"),d=$.find(".sapSuiteIDCChart"),c=parseInt(d.css("padding-right"))+parseInt(d.css("padding-left")),e=$.height(),f=$.width();if(this._bInteractiveMode){a=2;}else{a=1;}i=((e-I.LEGEND_HEIGHT_PADDING-(b.length*a))/b.length);b.height(i+"px");if(f<I.CHART_WIDTH_MINVALUE||e<I.CHART_HEIGHT_MINVALUE||i<I.AREA_HEIGHT_MINVALUE){$.css("visibility","hidden");return;}$.css("visibility","");if(f<I.CHART_WIDTH_HIDEDONUT_MINVALUE){$.addClass("sapSuiteIDCFullWidth");if(f<I.CHART_WIDTH_FULLWIDTH_SMALLFONT_MINVALUE){$.addClass("sapSuiteIDCFullWidthSmallFont");}else{$.removeClass("sapSuiteIDCFullWidthSmallFont");}}else{$.removeClass("sapSuiteIDCFullWidth");if(d.innerWidth()<d.innerHeight()){$.find(".sapSuiteIDCChartSVG").css("width","100%").css("height",d.innerWidth()+"px");}else{$.find(".sapSuiteIDCChartSVG").css("height","100%").css("width",(d.innerHeight()-c)+"px");}if(f<I.CHART_WIDTH_LEGENDPADDING_MINVALUE){$.addClass("sapSuiteIDCSmallLegendPadding");}else{$.removeClass("sapSuiteIDCSmallLegendPadding");}}if(i<this._iAreaHeightSmallFontMinValue){$.addClass("sapSuiteIDCSmallFont");}else{$.removeClass("sapSuiteIDCSmallFont");}this._handleLegendEntrySizing();this._switchModeInteractive(i);};
I.prototype._handleLegendEntrySizing=function(){var $=this.$().find(".sapSuiteIDCLegend"),a=$.find(".sapSuiteIDCLegendLabel"),v=$.find(".sapSuiteIDCLegendValue"),V=0;v.each(function(){var i=q(this).outerWidth(true);V=Math.max(V,i);});a.css("width","calc(100% - "+V+"px)");v.css("width",V+"px");};
I.prototype._isChartEnabled=function(){return this.getSelectionEnabled()&&this._bInteractiveMode;};
I.prototype._isCompact=function(){return q("body").hasClass("sapUiSizeCompact")||this.$().is(".sapUiSizeCompact")||this.$().closest(".sapUiSizeCompact").length>0;};
I.prototype._toggleSelected=function(i){var s=this.getSegments()[i],S=!s.getSelected(),$=this.$("interactionArea-"+i),a=this.$().find("."+I.CHART_SEGMENT.CSSCLASS+"[data-sap-ui-idc-selection-index='"+i+"']"),g=this.$().find("."+I.CHART_SEGMENT_GHOST.CSSCLASS+"[data-sap-ui-idc-selection-index='"+i+"']");s.setProperty("selected",S,true);$.attr("aria-selected",s.getSelected());if(S){$.addClass(I.SEGMENT_CSSCLASS_SELECTED);a.addClass(I.CHART_SEGMENT.CSSCLASS_SELECTED);g.addClass(I.CHART_SEGMENT_GHOST.CSSCLASS_SELECTED);}else{$.removeClass(I.SEGMENT_CSSCLASS_SELECTED);a.removeClass(I.CHART_SEGMENT.CSSCLASS_SELECTED);g.removeClass(I.CHART_SEGMENT_GHOST.CSSCLASS_SELECTED);}this.fireSelectionChanged({selectedSegments:this.getSelectedSegments(),segment:s,selected:S});};
I.prototype._switchTabindex=function(o,n,f){if(o!==n&&o>=0&&o<f.length&&n>=0&&n<f.length){f.eq(o).removeAttr("tabindex");f.eq(n).attr("tabindex","0");f.eq(n).focus();}};
I.prototype._adjustToParent=function(c){var p=this.data("_parentRenderingContext");if(p&&p instanceof F){var P=p.$();var i=parseFloat(P.innerWidth());var a=parseFloat(P.innerHeight());c.outerWidth(i);c.outerHeight(a);}};
I.prototype._setResponsivenessData=function(){if(this._bCompact){this._iAreaHeightInteractiveMinValue=I.AREA_HEIGHT_INTERACTIVE_MINVALUE_COMPACT;this._iAreaHeightSmallFontMinValue=I.AREA_HEIGHT_SMALLFONT_COMPACT;}else{this._iAreaHeightInteractiveMinValue=I.AREA_HEIGHT_INTERACTIVE_MINVALUE;this._iAreaHeightSmallFontMinValue=I.AREA_HEIGHT_SMALLFONT;}};
I.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._bCompact=this._isCompact();this.invalidate();};
I.prototype._deregisterResizeHandler=function(){if(this._sResizeHandlerId){R.deregister(this._sResizeHandlerId);this._sResizeHandlerId=null;}};
I.prototype._createTooltipText=function(){var b=true,s,t="",S=this.getSegments();for(var i=0;i<this._iVisibleSegments;i++){if(!S[i]){break;}s=S[i]._getSegmentTooltip();if(s){t+=(b?"":"\n")+s;b=false;}}return t;};
return I;});
sap.ui.predefine('sap/suite/ui/microchart/InteractiveDonutChartRenderer',["sap/ui/thirdparty/jquery",'./library',"sap/ui/core/theming/Parameters","sap/ui/Device","sap/m/library","sap/base/Log"],function(q,l,P,D,M,L){"use strict";var I={};I.TOTAL_RADIUS_ABSOLUTE=3.625;I.OUTER_RADIUS_ABSOLUTE=3.25;I.SELECTION_THICKNESS_ABSOLUTE=0.375;I.HOLE_SIZE_RATIO_COMPACT=0.48;I.HOLE_SIZE_RATIO_COZY=0.48;I.SEGMENT_HALF_GAP_SIZE=0;I.SEGMENT_HALF_GAP_SIZE_HCB=0.5;I.GHOST_BORDER_HALF_THICKNESS_HCB=0.5;
I.render=function(r,c){if(!c._bThemeApplied){return;}this._aSegments=c.getSegments();var s=c._iVisibleSegments;this._fSegmentHalfGapSize=this.SEGMENT_HALF_GAP_SIZE;this._fGhostHalfGapSize=0;if(this._isThemeHighContrast()){this._fSegmentHalfGapSize=this.SEGMENT_HALF_GAP_SIZE_HCB;this._fGhostHalfGapSize=this.GHOST_BORDER_HALF_THICKNESS_HCB;}r.write("<div");r.addClass("sapSuiteIDC");r.writeControlData(c);r.writeClasses();if(!c._isChartEnabled()){var a=c.getTooltip_AsString();if(q.type(a)==="string"){r.writeAttributeEscaped("title",a);}}var A={};A.role="listbox";A.multiselectable=true;A.disabled=!c._isChartEnabled();A.labelledby=c.getAriaLabelledBy();A.describedby=this._getAriaDescribedBy(c,s);r.writeAccessibilityState(c,A);r.write(">");if(!c.getSelectionEnabled()){this._renderDisabledOverlay(r,c);}this._renderDonut(r,c,s);this._renderLegend(r,c,s);r.write("</div>");};
I._renderDonut=function(r,c,s){var S,f,a,b,t,d,o,h,C=c._bCompact;r.write("<div");r.addClass("sapSuiteIDCChart");r.writeClasses();r.write(">");r.write("<svg");r.addClass("sapSuiteIDCChartSVG");r.writeClasses();r.writeAttribute("viewBox","-2 -2 104 104");r.writeAttribute("focusable","false");r.write(">");r.write("<g");r.writeAttribute("transform","translate(50.5 50.5)");r.write(">");t=50;o=(this.OUTER_RADIUS_ABSOLUTE/this.TOTAL_RADIUS_ABSOLUTE)*t;if(C){d=this.HOLE_SIZE_RATIO_COMPACT*o;}else{d=this.HOLE_SIZE_RATIO_COZY*o;}h=t*(this.SELECTION_THICKNESS_ABSOLUTE/this.TOTAL_RADIUS_ABSOLUTE);f=this._calculateSum(c);a=0.0;var i;for(i=0;i<s;i++){S=this._aSegments[i];if(S.getValue()>0){b=this._calculateSegmentPath(f,S.getValue(),a,o+h,d-h,this._fGhostHalfGapSize);r.write("<path");r.writeAttributeEscaped("d",b);r.writeAttribute("data-sap-ui-idc-selection-index",i);r.addClass(l.InteractiveDonutChart.CHART_SEGMENT_GHOST.CSSCLASS);if(S.getSelected()){r.addClass(l.InteractiveDonutChart.CHART_SEGMENT_GHOST.CSSCLASS_SELECTED);}r.writeClasses();r.writeStyles();r.write(">");if(c._isChartEnabled()){this._renderTitle(S.getTooltip_AsString(),r);}r.write("</path>");a+=this._aSegments[i].getValue();}}a=0.0;for(i=0;i<s;i++){S=this._aSegments[i];if(S.getValue()>0){b=this._calculateSegmentPath(f,S.getValue(),a,o,d,0);r.write("<path");r.writeAttributeEscaped("d",b);r.writeAttributeEscaped("fill",this._getSegmentColor(i,s));r.writeAttribute("cursor","pointer");r.writeAttribute("data-sap-ui-idc-selection-index",i);r.addClass(l.InteractiveDonutChart.CHART_SEGMENT.CSSCLASS);if(S.getSelected()){r.addClass(l.InteractiveDonutChart.CHART_SEGMENT.CSSCLASS_SELECTED);}r.writeClasses();r.write(">");if(c._isChartEnabled()){this._renderTitle(S.getTooltip_AsString(),r);}r.write("</path>");a+=this._aSegments[i].getValue();}}r.write("</g>");r.write("</svg>");r.write("</div>");};
I._renderLegend=function(r,c,s){r.write("<div");r.addClass("sapSuiteIDCLegend");r.writeClasses();r.write(">");for(var i=0;i<s;i++){this._renderLegendSegment(r,c,i,s);}r.write("</div>");};
I._renderLegendSegment=function(r,c,i,s){var S=this._aSegments[i],a=S.getLabel(),d=S.getDisplayedValue()||String(S.getValue()),t,C=S._getSemanticColor();if(S._bNullValue){d=c._oRb.getText("INTERACTIVECHART_NA");}d=d.substring(0,l.InteractiveDonutChart.CHART_SEGMENT_LABEL_MAXLENGTH);var t=S.getTooltip_Text();var A;if(t&&q.trim(t).length>0){A=t;}else{A=a;if(A){A=A+" "+d;}else{A=d;}if(C){A+=" "+C;}}var o={};o.role="option";o.label=A.trim();o.selected=S.getSelected();o.posinset=i+1;o.setsize=s;r.write("<div");r.writeAccessibilityState(S,o);r.writeAttributeEscaped("id",c.getId()+"-interactionArea-"+i);r.writeAttributeEscaped("data-sap-ui-idc-selection-index",i);r.addClass("sapSuiteIDCLegendSegment");if(S.getSelected()){r.addClass(l.InteractiveDonutChart.SEGMENT_CSSCLASS_SELECTED);}if(i===0&&c.getSelectionEnabled()){r.writeAttribute("tabindex","0");}if(c._isChartEnabled()){t=S.getTooltip_AsString();if(q.type(t)==="string"){r.writeAttributeEscaped("title",t);}}r.writeClasses();r.write(">");C=S.getColor();if(C!==M.ValueColor.Neutral){r.write("<div");r.addClass("sapSuiteIDCSemanticMarker");r.addClass("sapSuiteICSemanticColor"+C);r.writeClasses();r.write(">");r.write("</div>");}r.write("<div");r.addClass("sapSuiteIDCLegendMarker");r.writeClasses();r.writeAttributeEscaped("style","background-color: "+this._getSegmentColor(i,s));r.write(">");r.write("</div>");r.write("<div");r.addClass("sapSuiteIDCLegendLabelValue");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapSuiteIDCLegendLabel");r.writeClasses();r.write(">");r.writeEscaped(a);r.write("</div>");r.write("<div");r.addClass("sapSuiteIDCLegendValue");r.writeClasses();r.write(">");r.writeEscaped(d);r.write("</div>");r.write("</div>");r.write("</div>");};
I._getSegmentColor=function(p,s){var w=1-(s-p)/s,c=P.get("_sap_suite_ui_microchart_InteractiveDonutChart_SegmentFillColor")||"white";if(this._isThemeHighContrast()){return c;}return this._mixColors(c,"#ffffff",w);};
I._calculateSegmentPath=function(s,a,b,o,i,c){var m=0.01,S,d,e,f,g,h,E,j,k,n=this._fSegmentHalfGapSize+c,G=Math.pow(2*n,2),p,r,t,u;o=this._formatFloat(o);i=this._formatFloat(i);h=this._calculateCircleFraction(s,b);E=this._calculateCircleFraction(s,b+a);j=this._calculateCircleFraction(s,a);if(j<=Math.PI){k=0;}else{k=1;}if(s===a){p=i;r=o;t=0;u=0;}else{p=Math.sqrt(Math.pow(i,2)+G);r=Math.sqrt(Math.pow(o,2)+G);t=Math.atan(n/i);u=Math.atan(n/o);}d={"x":this._formatFloat(p*Math.sin(h+t)),"y":this._formatFloat(-p*Math.cos(h+t))};e={"x":this._formatFloat(r*Math.sin(h+u)),"y":this._formatFloat(-r*Math.cos(h+u))};f={"x":this._formatFloat(o*Math.sin(E-u)-m),"y":this._formatFloat(-o*Math.cos(E-u))};g={"x":this._formatFloat(i*Math.sin(E-t)-m),"y":this._formatFloat(-i*Math.cos(E-t))};S="";S+="M"+d.x+" "+d.y+" ";S+="L"+e.x+" "+e.y+" ";S+="A"+o+","+o+" 0 "+k+",1"+" "+f.x+","+f.y+" ";S+="L"+g.x+" "+g.y+" ";S+="A"+i+","+i+" 0 "+k+",0"+" "+d.x+","+d.y;return S;};
I._formatFloat=function(v){return parseFloat(v.toFixed(2));};
I._calculateSum=function(c){var s=0;var d=c.getDisplayedSegments();for(var i=0;i<this._aSegments.length&&i<d;i++){var v=this._aSegments[i].getValue();if(v>0){s+=v;}}return s;};
I._calculateCircleFraction=function(s,a){return(2*Math.PI*a)/s;};
I._renderDisabledOverlay=function(r){r.write("<div");r.addClass("sapSuiteIDCDisabledOverlay");r.writeClasses();r.write(">");r.write("</div>");};
I._getAriaDescribedBy=function(c,s){var a=[];for(var i=0;i<s;i++){a.push(c.getId()+"-interactionArea-"+i);}return a.join(",");};
I._mixColors=function(c,a,w){if(w===1||c.toLowerCase()===a.toLowerCase()){return c;}var C=this._hexToRgb(c);var b=this._hexToRgb(a);var s=Math.round((C[0]+(Math.abs(C[0]-b[0])*w))%255);var d=Math.round((C[1]+(Math.abs(C[1]-b[1])*w))%255);var e=Math.round((C[2]+(Math.abs(C[2]-b[2])*w))%255);return"#"+this._intToHex(s)+this._intToHex(d)+this._intToHex(e);};
I._isThemeHighContrast=function(){return/(hcw|hcb)/g.test(sap.ui.getCore().getConfiguration().getTheme());};
I._hexToRgb=function(h){var c=[];h=h.replace(/[^0-9a-f]+/ig,'');if(h.length===3){c=h.split('');}else if(h.length===6){c=h.match(/(\w{2})/g);}else{L.warning("Invalid color input: hex string must be in the format #FFFFFF or #FFF");}return c.map(function(x){return parseInt(x,16);});};
I._intToHex=function(v){var h=v.toString(16);if(h.length===1){h='0'+h;}return h;};
I._renderTitle=function(t,r){if(q.type(t)==="string"){r.write("<title>");if(D.browser.msie){t=t.split("\n");for(var j=0;j<t.length;j++){r.writeEscaped(t[j]);if(j<t.length-1){r.write("<br>");}}}else{r.writeEscaped(t);}r.write("</title>");}};
return I;},true);
sap.ui.predefine('sap/suite/ui/microchart/InteractiveDonutChartSegment',["./library","sap/ui/core/Element"],function(l,E){"use strict";
var I=E.extend("sap.suite.ui.microchart.InteractiveDonutChartSegment",{metadata:{library:"sap.suite.ui.microchart",properties:{label:{type:"string",group:"Misc",defaultValue:null},selected:{type:"boolean",group:"Appearance",defaultValue:false},value:{type:"float",group:"Data",defaultValue:null},displayedValue:{type:"string",group:"Data",defaultValue:null},color:{type:"sap.m.ValueColor",group:"Misc",defaultValue:"Neutral"}}}});
I.prototype.init=function(){this._bNullValue=true;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");};
I.prototype.validateProperty=function(p,v){if(p==="value"){this._bNullValue=(v===null)||isNaN(v)||(typeof v==="undefined")||(v<0);}return E.prototype.validateProperty.apply(this,arguments);};
I.prototype.getTooltip_AsString=function(){var t=this.getTooltip_Text();this._bCustomTooltip=true;if(!t){t=this._createTooltipText();this._bCustomTooltip=false;}else if(l._isTooltipSuppressed(t)){t=null;}return t;};
I.prototype._createTooltipText=function(){var t="";var L=this.getLabel();if(L&&L.length>0){t=L+":\n";}if(this._bNullValue){t+=this._oRb.getText("INTERACTIVECHART_NA");}else{t+=this.getDisplayedValue()?this.getDisplayedValue():this.getValue();}var c=this._getSemanticColor();if(c){t+=" "+c;}return t;};
I.prototype._getSemanticColor=function(){var c=this.getColor();var p=this.getParent();if(p&&p._bSemanticTooltip){return this._oRb.getText("SEMANTIC_COLOR_"+c.toUpperCase());}return"";};
I.prototype._getSegmentTooltip=function(){var t=this.getTooltip_AsString();if(t&&!this._bCustomTooltip){t=t.replace("\n"," ");}return t;};
return I;});
sap.ui.predefine('sap/suite/ui/microchart/InteractiveLineChart',["sap/ui/thirdparty/jquery",'./library','sap/m/library','sap/ui/core/Control','sap/suite/ui/microchart/InteractiveLineChartPoint','sap/ui/Device','sap/ui/core/ResizeHandler','sap/m/FlexBox',"sap/base/Log","./InteractiveLineChartRenderer"],function(q,l,M,C,I,D,R,F,L){"use strict";
var a=C.extend("sap.suite.ui.microchart.InteractiveLineChart",{metadata:{library:"sap.suite.ui.microchart",properties:{displayedPoints:{type:"int",group:"Appearance",defaultValue:6},precedingPoint:{type:"float",group:"Data",defaultValue:0},succeedingPoint:{type:"float",group:"Data",defaultValue:0},selectionEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"points",aggregations:{points:{type:"sap.suite.ui.microchart.InteractiveLineChartPoint",multiple:true,bindable:"bindable"}},events:{selectionChanged:{parameters:{selectedPoints:{type:"sap.suite.ui.microchart.InteractiveLineChartPoint[]"},point:{type:"sap.suite.ui.microchart.InteractiveLineChartPoint"},selected:{type:"boolean"}}},press:{}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
a.MAX_SCALED_CANVAS_VALUE=99;a.MIN_SCALED_CANVAS_VALUE=1;a.AREA_WIDTH_INTERACTIVE_MINVALUE=48;a.AREA_WIDTH_INTERACTIVE_MINVALUE_COMPACT=32;a.CHART_HEIGHT_MINVALUE=106;a.AREA_WIDTH_MINVALUE=24;a.LABEL_WIDTH_MINVALUE=32;a.AREA_WIDTH_SMALLFONT=36;
a.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this._aNormalizedValues=[];this._iAreaWidthInteractiveMinValue=a.AREA_WIDTH_INTERACTIVE_MINVALUE;this._bInteractiveMode=true;this._fNormalizedZero=0;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
a.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);};
a.prototype.onBeforeRendering=function(){this._bCompact=this._isCompact();this._bInteractiveMode=true;var p=this.getPoints();this._iVisiblePointsCount=Math.min(this.getDisplayedPoints(),p.length);this._setResponsivenessData();if(!this.data("_parentRenderingContext")&&q.isFunction(this.getParent)){this.data("_parentRenderingContext",this.getParent());}this._updateNormalizedValues();this._deregisterResizeHandler();this._bSemanticTooltip=false;for(var i=0;i<this._iVisiblePointsCount;i++){if(p[i].getColor()!==M.ValueColor.Neutral){this._bSemanticTooltip=true;break;}}};
a.prototype.onAfterRendering=function(){this._adjustToParent();l._checkControlIsVisible(this,this._onControlIsVisible);};
a.prototype._onControlIsVisible=function(){this._sResizeHandlerId=R.register(this,this._onResize.bind(this));this._onResize();};
a.prototype.exit=function(){this._deregisterResizeHandler();};
a.prototype.onclick=function(e){if(!this.getSelectionEnabled()){return;}if(this._bInteractiveMode){var i=q(e.target).parent();var h,f=this.$().find(".sapSuiteILCInteractionArea");var b=this.$().find(".sapSuiteILCSection").index(i);if(b>=0){this._toggleSelected(b);h=f.index(this.$().find(".sapSuiteILCInteractionArea[tabindex='0']"));this._switchTabindex(h,b,f);}}else{this.firePress();if(D.browser.msie){this.$().focus();e.preventDefault();}}};
a.prototype.onsapleft=function(e){var f=this.$().find(".sapSuiteILCInteractionArea");var i=f.index(e.target);if(f.length>0){this._switchTabindex(i,i-1,f);}e.preventDefault();e.stopImmediatePropagation();};
a.prototype.onsapright=function(e){var f=this.$().find(".sapSuiteILCInteractionArea");var i=f.index(e.target);if(f.length>0){this._switchTabindex(i,i+1,f);}e.preventDefault();e.stopImmediatePropagation();};
a.prototype.onsapup=a.prototype.onsapleft;a.prototype.onsapdown=a.prototype.onsapright;
a.prototype.onsapenter=function(e){if(this._bInteractiveMode){var i=this.$().find(".sapSuiteILCInteractionArea").index(e.target);if(i!==-1){this._toggleSelected(i);}e.preventDefault();e.stopImmediatePropagation();}else{this.firePress();}};
a.prototype.onsapspace=a.prototype.onsapenter;
a.prototype.onsaphome=function(e){var f=this.$().find(".sapSuiteILCInteractionArea");var i=f.index(e.target);if(i!==0&&f.length>0){this._switchTabindex(i,0,f);}e.preventDefault();e.stopImmediatePropagation();};
a.prototype.onsapend=function(e){var f=this.$().find(".sapSuiteILCInteractionArea");var i=f.index(e.target),b=f.length;if(i!==b-1&&b>0){this._switchTabindex(i,b-1,f);}e.preventDefault();e.stopImmediatePropagation();};
a.prototype.getTooltip_AsString=function(){var t=this.getTooltip_Text();if(!t){t=this._createTooltipText();}else if(l._isTooltipSuppressed(t)){t=null;}return t;};
a.prototype.getSelectedPoints=function(){var s=[],p=this.getAggregation("points");for(var i=0;i<p.length;i++){if(p[i].getSelected()){s.push(p[i]);}}return s;};
a.prototype.setSelectedPoints=function(s){var p=this.getAggregation("points"),b;this._deselectAllSelectedPoints();if(!s){return this;}if(s instanceof I){s=[s];}if(Array.isArray(s)){for(var i=0;i<s.length;i++){b=this.indexOfAggregation("points",s[i]);if(b>=0){p[b].setProperty("selected",true,true);}else{L.warning("setSelectedPoints method called with invalid InteractiveLineChartPoint element");}}}this.invalidate();return this;};
a.prototype._fnIsNumber=function(v){return typeof v==='number'&&!isNaN(v)&&isFinite(v);};
a.prototype._isCompact=function(){return q("body").hasClass("sapUiSizeCompact")||this.$().is(".sapUiSizeCompact")||this.$().closest(".sapUiSizeCompact").length>0;};
a.prototype._setResponsivenessData=function(){if(this._bCompact){this._iAreaWidthInteractiveMinValue=a.AREA_WIDTH_INTERACTIVE_MINVALUE_COMPACT;}else{this._iAreaWidthInteractiveMinValue=a.AREA_WIDTH_INTERACTIVE_MINVALUE;}};
a.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._bCompact=this._isCompact();this.invalidate();};
a.prototype._deselectAllSelectedPoints=function(){var p=this.getPoints();for(var i=0;i<p.length;i++){if(p[i].getSelected()){p[i].setProperty("selected",false,true);}}};
a.prototype._switchTabindex=function(o,n,f){if(o>=0&&o<f.length&&n>=0&&n<f.length){f.eq(o).removeAttr("tabindex");f.eq(n).attr("tabindex","0");f.eq(n).focus();}};
a.prototype._toggleSelected=function(i){var p=this.getPoints()[i],s=this.$("point-area-"+i),P=this.$("point-"+i);if(p.getSelected()){s.add(P).removeClass("sapSuiteILCSelected");p.setProperty("selected",false,true);}else{s.add(P).addClass("sapSuiteILCSelected");p.setProperty("selected",true,true);}s.find(".sapSuiteILCInteractionArea").attr("aria-selected",p.getSelected());this.fireSelectionChanged({selectedPoints:this.getSelectedPoints(),point:p,selected:p.getSelected()});};
a.prototype._updateNormalizedValues=function(){var p=this.getPoints(),n=p.length,i=0;this.nMax=-Number.MAX_VALUE;this.nMin=Number.MAX_VALUE;this._aNormalizedValues=[];for(i=0;i<n;i++){if(!p[i]._bNullValue){var v=p[i].getValue();this.nMax=Math.max(this.nMax,v);this.nMin=Math.min(this.nMin,v);}}var b=(this.nMax!=-Number.MAX_VALUE&&this.nMin!==Number.MAX_VALUE)?this.nMax-this.nMin:0;var s=function(v){if(typeof v!=="undefined"){var c=(v-this.nMin)/b;return a.MIN_SCALED_CANVAS_VALUE+c*(a.MAX_SCALED_CANVAS_VALUE-a.MIN_SCALED_CANVAS_VALUE);}return null;}.bind(this);for(i=0;i<n;i++){if(p[i]._bNullValue){this._aNormalizedValues.push(0);}else{this._aNormalizedValues.push(b?s(p[i].getValue()):50);}}if(p.length>0){this._fNormalizedPrecedingPoint=this._bIsPrecedingPointSet&&!p[0]._bNullValue?s(this.getPrecedingPoint()):null;this._fNormalizedSucceedingPoint=this._bIsSucceedingPointSet&&!p[p.length-1]._bNullValue?s(this.getSucceedingPoint()):null;}if(this.nMin<0&&this.nMax>0){this._fNormalizedZero=(Math.max(0-this.nMin,0)/b)*100;}else{this._fNormalizedZero=null;}};
a.prototype._adjustToParent=function(){if(this.data("_parentRenderingContext")&&this.data("_parentRenderingContext")instanceof F){var p=this.data("_parentRenderingContext").$();var P=parseFloat(p.width())-2;var i=parseFloat(p.height())-2;this.$().outerWidth(P);this.$().outerHeight(i);}};
a.prototype._isChartEnabled=function(){return this.getSelectionEnabled()&&this._bInteractiveMode;};
a.prototype._switchModeInteractive=function(b){var $=this.$(),s=false;if(b<this._iAreaWidthInteractiveMinValue){if(this._bInteractiveMode){this._bInteractiveMode=false;s=true;$.addClass("sapSuiteILCNonInteractive");if(this.getSelectionEnabled()){var A=$.find(".sapSuiteILCInteractionArea[tabindex='0']");this._iActiveElement=$.find(".sapSuiteILCInteractionArea").index(A);A.removeAttr("tabindex");$.attr("tabindex","0");}$.attr({"role":"button","aria-multiselectable":"false","aria-disabled":!this._isChartEnabled()});}}else if(!this._bInteractiveMode){this._bInteractiveMode=true;s=true;$.removeClass("sapSuiteILCNonInteractive");if(this.getSelectionEnabled()){$.removeAttr("tabindex");if(!this._iActiveElement||this._iActiveElement<0){this._iActiveElement=0;}$.find(".sapSuiteILCInteractionArea").eq(this._iActiveElement).attr("tabindex","0");}$.attr({"role":"listbox","aria-multiselectable":"true","aria-disabled":!this._isChartEnabled()});}if(s){if(this._isChartEnabled()){$.removeAttr("title");this._addInteractionAreaTooltip();}else{$.find(".sapSuiteILCInteractionArea").removeAttr("title");$.attr("title",this.getTooltip_AsString());}}};
a.prototype._addInteractionAreaTooltip=function(){var i=this.$().find(".sapSuiteILCInteractionArea"),p=this.getPoints();i.each(function(b,e){q(e).attr("title",p[b].getTooltip_AsString());});};
a.prototype._onResize=function(){var b,B=false,$=this.$(),t=$.find(".sapSuiteILCToplabel"),c=$.find(".sapSuiteILCBottomText"),d=$.find(".sapSuiteILCInteractionArea"),e=$.height(),f=$.width(),n=this.getPoints().length,g=$.find(".sapSuiteILCSection:first-child .sapSuiteILCBottomText"),h=$.find(".sapSuiteILCSection:last-child .sapSuiteILCBottomText");if(d.length>0){b=d[0].getBoundingClientRect().width;}if(b<a.AREA_WIDTH_MINVALUE||e<a.CHART_HEIGHT_MINVALUE){$.css("visibility","hidden");return;}else{$.css("visibility","");}this._switchModeInteractive(b);if(b<=a.AREA_WIDTH_SMALLFONT){$.addClass("sapSuiteILCSmallFont");}else{$.removeClass("sapSuiteILCSmallFont");}$.removeClass("sapSuiteILCExpandedLabels");g.add(h).css("width","");for(var i=0;i<n;i++){if(t.eq(i).prop("offsetWidth")<t.eq(i).prop("scrollWidth")){t.eq(i).css("visibility","hidden");}else{t.eq(i).css("visibility","");}if(c.eq(i).prop("offsetWidth")<c.eq(i).prop("scrollWidth")){B=true;}}if(b<a.LABEL_WIDTH_MINVALUE&&B){$.addClass("sapSuiteILCExpandedLabels");g.add(h).css("width",(f/2)-4+"px");}else{$.removeClass("sapSuiteILCExpandedLabels");g.add(h).css("width","");}};
a.prototype._deregisterResizeHandler=function(){if(this._sResizeHandlerId){R.deregister(this._sResizeHandlerId);this._sResizeHandlerId=null;}};
a.prototype._createTooltipText=function(){var b=true,A,t="",p=this.getPoints();for(var i=0;i<this._iVisiblePointsCount;i++){A=p[i]._getAreaTooltip();if(A){t+=(b?"":"\n")+A;b=false;}}return t;};
a.prototype.setPrecedingPoint=function(v){this._bIsPrecedingPointSet=this._fnIsNumber(v);return this.setProperty("precedingPoint",this._bIsPrecedingPointSet?v:NaN);};
a.prototype.setSucceedingPoint=function(v){this._bIsSucceedingPointSet=this._fnIsNumber(v);return this.setProperty("succeedingPoint",this._bIsSucceedingPointSet?v:NaN);};
return a;});
sap.ui.predefine('sap/suite/ui/microchart/InteractiveLineChartPoint',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var I=E.extend("sap.suite.ui.microchart.InteractiveLineChartPoint",{metadata:{library:"sap.suite.ui.microchart",properties:{label:{type:"string",group:"Misc",defaultValue:null},secondaryLabel:{type:"string",group:"Misc",defaultValue:null},selected:{type:"boolean",group:"Appearance",defaultValue:false},value:{type:"float",group:"Data",defaultValue:null},displayedValue:{type:"string",group:"Data",defaultValue:null},color:{type:"sap.m.ValueColor",group:"Misc",defaultValue:"Neutral"}}}});
I.prototype.init=function(){this._bNullValue=true;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");};
I.prototype.validateProperty=function(p,v){if(p==="value"&&(v===null||v===undefined)){this._bNullValue=true;}else if(p==="value"){this._bNullValue=false;}return E.prototype.validateProperty.apply(this,arguments);};
I.prototype.getTooltip_AsString=function(){var t=this.getTooltip_Text();this._bCustomTooltip=true;if(!t){t=this._createTooltipText();this._bCustomTooltip=false;}else if(l._isTooltipSuppressed(t)){t=null;}return t;};
I.prototype._createTooltipText=function(){var t="";var L=this.getLabel();if(L&&L.length>0){t=L+":\n";}if(this._bNullValue){t+=this._oRb.getText("INTERACTIVECHART_NA");}else{t+=this.getValue();}var c=this._getSemanticColor();if(c){t+=" "+c;}return t;};
I.prototype._getSemanticColor=function(){var c=this.getColor();var p=this.getParent();if(p&&p._bSemanticTooltip){return this._oRb.getText("SEMANTIC_COLOR_"+c.toUpperCase());}return"";};
I.prototype._getAreaTooltip=function(){var t=this.getTooltip_AsString();if(t&&!this._bCustomTooltip){t=t.replace("\n"," ");}return t;};
return I;});
sap.ui.predefine('sap/suite/ui/microchart/InteractiveLineChartRenderer',["sap/ui/thirdparty/jquery","sap/m/library","sap/base/security/encodeXML"],function(q,M,e){"use strict";var I={};
I.render=function(r,c){if(!c._bThemeApplied){return;}var n=c._iVisiblePointsCount,a=100/n;r.write("<div");r.writeControlData(c);r.addClass("sapSuiteILC");r.writeClasses();var A={};A.role="listbox";A.multiselectable=true;A.disabled=!c._isChartEnabled();A.labelledby=c.getAriaLabelledBy();A.describedby=this._getAriaDescribedBy(c,n);r.writeAccessibilityState(c,A);if(!c._isChartEnabled()){var s=c.getTooltip_AsString();if(q.type(s)==="string"){r.writeAttributeEscaped("title",s);}}r.write(">");r.write("<div class=\"sapSuiteILCWrapperChild\">");r.write("<div class=\"sapSuiteILCInner\">");if(!c.getSelectionEnabled()){this._renderDisabledOverlay(r,c);}this._renderChartCanvas(r,c,n,a);r.write("<div");r.addClass("sapSuiteILCBottomLabelArea");if(c._fNormalizedZero){r.addClass("sapSuiteILCBottomLabelAreaNoDivider");}r.writeClasses();r.write(">");r.write("</div>");r.write("<div");r.addClass("sapSuiteILCInteraction");r.writeClasses();r.write(">");for(var b=0;b<n;b++){this._renderPoint(r,c,b,n,a);}r.write("</div>");r.write("</div>");var l="",R=false,p=c.getPoints();for(var i=0;i<n;i++){var C=p[i],S=C.getSecondaryLabel();if(S&&l!==S){l=S;if(!R){R=true;r.write("<div class=\"sapSuiteILCInnerBottom\">");}this._renderSecondaryLabel(r,C,i,a,l);}}if(R){r.write("</div>");}r.write("</div>");r.write("</div>");};
I._renderSecondaryLabel=function(r,c,i,p,l){r.write("<div class=\"sapSuiteILCSecondaryLabel\"");r.addStyle("width",e(p+"%"));r.addStyle("left",e(i*p+"%"));r.writeStyles();r.writeAttributeEscaped("aria-label",e(l));r.write(">");r.write(e(l));r.write("</div>");};
I._renderPoint=function(r,c,i,p,a){var P=c.getPoints()[i];r.write("<div");r.writeAttributeEscaped("id",c.getId()+"-point-area-"+i);r.addClass("sapSuiteILCSection");r.addClass("sapSuiteILCCanvasLayout");if(P.getSelected()){r.addClass("sapSuiteILCSelected");}r.writeClasses();r.addStyle("width",e(a+"%"));r.addStyle("left",e(i*a+"%"));r.writeStyles();r.write(">");var C=P.getColor();r.write("<div");if(!P._bNullValue){if(P.getSelected()){r.addClass("sapSuiteILCSelected");}if(C!==M.ValueColor.Neutral){r.addClass("sapSuiteICSemanticColor"+C);}r.writeAttributeEscaped("id",c.getId()+"-point-"+i);r.addClass("sapSuiteILCPoint");r.addStyle("bottom",e(c._aNormalizedValues[i]+"%"));}r.writeClasses();r.writeStyles();r.write("></div>");r.write("<div");r.addClass("sapSuiteILCBackgroundArea");r.writeClasses();r.write("></div>");var A=this._renderPointLabel(r,c,i,p);var s=P._getSemanticColor();if(s){A+=" "+s;}var t=P.getTooltip_Text();if(t&&q.trim(t).length>0){A=t;}r.write("<div");r.addClass("sapSuiteILCInteractionArea");r.addClass("sapMPointer");r.writeClasses();if(i===0&&c._isChartEnabled()){r.writeAttribute("tabindex","0");}var o={};o.role="option";o.label=A;o.selected=P.getSelected();o.posinset=i+1;o.setsize=p;r.writeAccessibilityState(P,o);if(c._isChartEnabled()){var b=P.getTooltip_AsString();if(q.type(b)==="string"){r.writeAttributeEscaped("title",b);}}r.write("></div>");r.write("</div>");};
I._renderChartCanvas=function(r,c,d,p){var i,P=c.getPoints();r.write("<div");r.addClass("sapSuiteILCChartCanvas");r.addClass("sapSuiteILCCanvasLayout");r.writeClasses();r.write(">");r.write("<svg");r.addClass("sapSuiteILCSvgElement");r.writeClasses();r.writeAttribute("focusable","false");r.write(">");if(c._fNormalizedZero){r.write("<line");r.writeAttribute("x1","1%");r.writeAttributeEscaped("y1",100-c._fNormalizedZero+"%");r.writeAttribute("x2","99%");r.writeAttributeEscaped("y2",100-c._fNormalizedZero+"%");r.writeAttribute("stroke-width","1");r.addClass("sapSuiteILCDivider");r.writeClasses();r.write("/>");}var C=function(i,y,a){r.write("<line");r.writeAttributeEscaped("x1",p/2+(i-1)*p+"%");r.writeAttributeEscaped("y1",100-y+"%");r.writeAttributeEscaped("x2",p/2+(i*p)+"%");r.writeAttributeEscaped("y2",100-a+"%");r.writeAttribute("stroke-width","2");r.write("/>");};for(i=1;i<d;i++){if(!P[i-1]._bNullValue&&!P[i]._bNullValue){C(i,c._aNormalizedValues[i-1],c._aNormalizedValues[i]);}}if(c._fNormalizedPrecedingPoint!==null){C(0,c._fNormalizedPrecedingPoint,c._aNormalizedValues[0]);}if(c._fNormalizedSucceedingPoint!==null){C(i,c._aNormalizedValues[i-1],c._fNormalizedSucceedingPoint);}r.write("</svg>");r.write("</div>");};
I._renderPointLabel=function(r,c,i,p){var P=c.getPoints()[i];var B=P.getLabel()||"",t=P.getDisplayedValue();var h;r.write("<div");r.addClass("sapSuiteILCTextElement");r.addClass("sapSuiteILCBottomText");r.addClass("sapMPointer");r.writeClasses();r.write(">");r.writeEscaped(B);r.write("</div>");r.write("<div");r.addClass("sapSuiteILCTextElement");r.addClass("sapSuiteILCToplabel");r.addClass("sapMPointer");if(!P._bNullValue){if(!t){t=P.getValue().toString();}h=[c._aNormalizedValues[i]];if(i>0&&!c.getPoints()[i-1]._bNullValue){h.push((c._aNormalizedValues[i]+c._aNormalizedValues[i-1])/2);}if(i<p-1&&!c.getPoints()[i+1]._bNullValue){h.push((c._aNormalizedValues[i]+c._aNormalizedValues[i+1])/2);}h.sort(function(a,b){return a-b;});if(P.getValue()===c.nMax&&c.nMax!==c.nMin){r.addStyle("bottom",e(h[h.length-1]+"%"));r.addClass("sapSuiteILCShiftAbove");}else if(P.getValue()===c.nMin&&c.nMax!==c.nMin){r.addStyle("bottom",e(h[0]+"%"));r.addClass("sapSuiteILCShiftBelow");}else if(Math.abs(c._aNormalizedValues[i]-h[0])<Math.abs(c._aNormalizedValues[i]-h[h.length-1])){r.addStyle("bottom",e(h[0]+"%"));r.addClass("sapSuiteILCShiftBelow");}else{r.addStyle("bottom",e(h[h.length-1]+"%"));r.addClass("sapSuiteILCShiftAbove");}}else{t=c._oRb.getText("INTERACTIVECHART_NA");r.addClass("sapSuiteILCShiftBelow");r.addClass("sapSuiteILCNaLabel");}r.writeClasses();r.writeStyles();r.write(">");r.writeEscaped(t);r.write("</div>");return B+" "+t;};
I._renderDisabledOverlay=function(r,c){r.write("<div");r.addClass("sapSuiteILCDisabledOverlay");r.writeClasses();r.write(">");r.write("</div>");};
I._getAriaDescribedBy=function(c,p){var a=[];for(var i=0;i<p;i++){a.push(c.getId()+"-point-area-"+i);}return a.join(",");};
return I;},true);
sap.ui.predefine('sap/suite/ui/microchart/LineMicroChart',["sap/ui/thirdparty/jquery","./library","sap/m/library","sap/ui/core/Control","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/events/KeyCodes","sap/base/Log","sap/suite/ui/microchart/MicroChartUtils","sap/suite/ui/microchart/LineMicroChartLine","./LineMicroChartRenderer"],function(q,l,M,C,D,R,K,L,a,b){"use strict";
var c=C.extend("sap.suite.ui.microchart.LineMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{size:{type:"sap.m.Size",group:"Appearance",defaultValue:"Auto"},threshold:{type:"float",group:"Appearance",defaultValue:0},showThresholdLine:{type:"boolean",group:"Appearance",defaultValue:true},showThresholdValue:{type:"boolean",group:"Appearance",defaultValue:false},thresholdDisplayValue:{type:"string",group:"Appearance"},minXValue:{type:"float",group:"Appearance"},maxXValue:{type:"float",group:"Appearance"},minYValue:{type:"float",group:"Appearance"},maxYValue:{type:"float",group:"Appearance"},leftTopLabel:{type:"string",group:"Data",defaultValue:null},rightTopLabel:{type:"string",group:"Data",defaultValue:null},leftBottomLabel:{type:"string",group:"Data",defaultValue:null},rightBottomLabel:{type:"string",group:"Data",defaultValue:null},showTopLabels:{type:"boolean",defaultValue:true},showBottomLabels:{type:"boolean",defaultValue:true},color:{type:"any",group:"Appearance",defaultValue:"Neutral"},showPoints:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{type:"sap.ui.core.CSSSize",group:"Misc"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},defaultAggregation:"points",aggregations:{points:{type:"sap.suite.ui.microchart.LineMicroChartPoint",multiple:true,bindable:"bindable",forwarding:{getter:"_getInternalLine",aggregation:"points"}},lines:{type:"sap.suite.ui.microchart.LineMicroChartLine",multiple:true,bindable:"bindable"},_line:{type:"sap.suite.ui.microchart.LineMicroChartLine",multiple:false,visibility:"hidden"}},events:{press:{}}}});
c.THRESHOLD_LOOK_XS=1.125;c.THRESHOLD_LOOK_S=3.5;c.THRESHOLD_LOOK_M=4.5;c.THRESHOLD_LOOK_L=5.875;c.THRESHOLD_WIDTH_NO_LABEL=6;
c.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}this.firePress();};
c.prototype.onkeydown=function(e){if(e.which===K.SPACE){e.preventDefault();}};
c.prototype.onkeyup=function(e){if(e.which===K.ENTER||e.which===K.SPACE){this.firePress();e.preventDefault();}};
c.prototype.attachEvent=function(e,d,f,o){C.prototype.attachEvent.call(this,e,d,f,o);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};
c.prototype.detachEvent=function(e,f,o){C.prototype.detachEvent.call(this,e,f,o);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};
c.prototype.onclick=function(){if(D.browser.msie||D.browser.edge){this.$().focus();}this.firePress();};
c.prototype.onsapspace=c.prototype.onclick;c.prototype.onsapenter=c.prototype.onclick;
c.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_LINEMICROCHART");};
c.prototype.getThreshold=function(){if(this._bThresholdNull){return null;}else{return this.getProperty("threshold");}};
c.prototype.init=function(){this._minXScale=null;this._maxXScale=null;this._minYScale=null;this._maxYScale=null;this._fNormalizedThreshold=0;this._bScalingValid=false;this._bThresholdNull=false;this._bNoTopLabels=false;this._bNoBottomLabels=false;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
c.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
c.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
c.prototype.onBeforeRendering=function(){if(this._hasData()){this._setModeFlags();this._normalizePoints();}this._unbindMouseEnterLeaveHandler();};
c.prototype.onAfterRendering=function(){this._sResizeHandlerId=R.register(this,this._onResize.bind(this));this._onResize();this._bindMouseEnterLeaveHandler();};
c.prototype.exit=function(){this._deregisterResizeHandler();};
c.prototype.validateProperty=function(p,v){if(p==="threshold"){this._bThresholdNull=v===null;}if(v===null||v===undefined){return C.prototype.validateProperty.apply(this,[p,null]);}if(p==="color"&&!this.isColorCorrect(v)){L.warning("Color property of LineMicroChart must be of type sap.m.ValueCSSColor either as single value or as composite value (above: value, below: value)");v=null;}else if(["minXValue","maxXValue","minYValue","maxYValue"].indexOf(p)>=0){if(!q.isNumeric(v)){L.warning("Property "+p+" of LineMicroChart is not numeric and it will be reset to default");v=null;}}return C.prototype.validateProperty.apply(this,[p,v]);};
c.prototype._getInternalLine=function(){var o=this.getAggregation("_line");if(!o){o=new b();this.setAggregation("_line",o);}return o;};
c.prototype._getLines=function(){var o=this.getAggregation("_line");return(o&&o._getPoints().length>0)?[o]:this.getLines();};
c.prototype._setModeFlags=function(){var p;this._minXScale=Infinity;this._maxXScale=-Infinity;if(this._bThresholdNull){this._minYScale=Infinity;this._maxYScale=-Infinity;}else{this._minYScale=this._maxYScale=this.getThreshold();}this._getLines().forEach(function(o){p=o._getPoints();o._bFocusMode=false;o._bSemanticMode=false;for(var i=0;i<p.length;i++){this._minXScale=Math.min(p[i].getX(),this._minXScale);this._maxXScale=Math.max(p[i].getX(),this._maxXScale);this._minYScale=Math.min(p[i].getY(),this._minYScale);this._maxYScale=Math.max(p[i].getY(),this._maxYScale);if(p[i].getMetadata().getName()==="sap.suite.ui.microchart.LineMicroChartEmphasizedPoint"){o._bFocusMode=true;if(p[i].getColor()!==M.ValueColor.Neutral&&p[i].getShow()){o._bSemanticMode=true;}}}if(!o._bFocusMode){o._bSemanticMode=(o.getColor()&&o.getColor().above&&o.getColor().below&&!this._bThresholdNull);}if(o._bFocusMode&&o._bSemanticMode&&o.getColor()!==M.ValueColor.Neutral){L.info("Property Color of LineMicroChart has no effect if EmphasizedPoints with colors different from Neutral are used.");}if(o._bFocusMode&&o.getShowPoints()){L.info("Property ShowPoints of LineMicroChart has no effect if EmphasizedPoints are used.");}if(o.getColor()&&o.getColor().above&&o.getColor().below&&this._bThresholdNull){L.info("Property Color of LineMicroChart has no effect if it is composed of colors for above and below when property Threshold is null");}},this);var s=this.getLeftTopLabel(),r=this.getRightTopLabel(),d=this.getLeftBottomLabel(),e=this.getRightBottomLabel();this._bNoBottomLabels=(e.length===0&&d.length===0);this._bNoTopLabels=(s.length===0&&r.length===0);};
c.prototype._normalizePoints=function(){var m=this._minXScale,d=this._maxXScale,e=this._minYScale,f=this._maxYScale;if(q.isNumeric(this.getMinXValue())){this._minXScale=this.getMinXValue();if(!q.isNumeric(this.getMaxXValue())&&this._minXScale>d){L.error("Property minXValue of LineMicroChart must be smaller to at least one X value of the points aggregation if property maxXValue is not set");}}if(q.isNumeric(this.getMaxXValue())){this._maxXScale=this.getMaxXValue();if(!q.isNumeric(this.getMinXValue())&&this._maxXScale<m){L.error("Property maxXValue of LineMicroChart must be greater to at least one X value of the points aggregation if property minXValue is not set");}}if(q.isNumeric(this.getMinYValue())){this._minYScale=this.getMinYValue();if(!q.isNumeric(this.getMaxYValue())&&this._minYScale>f){L.error("Property minYValue of LineMicroChart must be greater to threshold or at least one Y value of the points aggregation if property maxYValue is not set");}}if(q.isNumeric(this.getMaxYValue())){this._maxYScale=this.getMaxYValue();if(!q.isNumeric(this.getMinYValue())&&this._maxYScale<e){L.error("Property maxYValue of LineMicroChart must be smaller to threshold or at least one Y value of the points aggregation if property minYValue is not set");}}if(this.getMaxYValue()<this.getMinYValue()){L.error("Property maxYValue of LineMicroChart must not be smaller to minYValue");}if(this.getMaxXValue()<this.getMinXValue()){L.error("Property maxXValue of LineMicroChart must not be smaller to minXValue");}var p,x=this._maxXScale-this._minXScale,y=this._maxYScale-this._minYScale,n,N;this._bScalingValid=x>=0&&y>=0;if(this._bScalingValid){this._getLines().forEach(function(o){p=o._getPoints();o._aNormalizedPoints=[];for(var i=0;i<p.length;i++){if(this._minXScale===this._maxXScale&&p[i].getX()===this._maxXScale){n=50;}else{n=(((p[i].getX()-this._minXScale)/x)*100);}if(this._minYScale===this._maxYScale&&p[i].getY()===this._maxYScale){N=50;}else{N=(((p[i].getY()-this._minYScale)/y)*100);}o._aNormalizedPoints.push({x:n,y:N});}},this);this._fNormalizedThreshold=((this.getThreshold()-this._minYScale)/y)*100;}};
c.prototype._onResize=function(){var $=this.$(),i=parseInt($.width()),d=parseInt($.height()),t=$.find(".sapSuiteLMCLeftTopLabel, .sapSuiteLMCRightTopLabel"),T=$.find(".sapSuiteLMCThresholdLabel");$.removeClass("sapSuiteLMCNoLabels sapSuiteLMCLookM sapSuiteLMCLookS sapSuiteLMCLookXS");if(i<=this.convertRemToPixels(c.THRESHOLD_WIDTH_NO_LABEL)){$.addClass("sapSuiteLMCNoLabels");}if(this.getShowTopLabels()){$.removeClass("sapSuiteLMCNoTopLabels");}if(this.getShowBottomLabels()){$.removeClass("sapSuiteLMCNoBottomLabels");}if(d<this.convertRemToPixels(c.THRESHOLD_LOOK_S)){$.addClass("sapSuiteLMCLookXS");}else if(d<this.convertRemToPixels(c.THRESHOLD_LOOK_M)){$.addClass("sapSuiteLMCLookS");}else if(d<this.convertRemToPixels(c.THRESHOLD_LOOK_L)){$.addClass("sapSuiteLMCLookM");}if(this.getShowThresholdValue()){$.removeClass("sapSuiteLMCNoThresholdLabel");}if(this._isAnyLabelTruncated(t)){$.addClass("sapSuiteLMCNoTopLabels");}if(this._isAnyLabelTruncated(T)){$.addClass("sapSuiteLMCNoThresholdLabel");}this._adjustThresholdLabelPos();};
c.prototype._adjustThresholdLabelPos=function(){var $=this.$();var i=$.find(".sapSuiteLMCThresholdLabelWrapper").height();var d=$.find(".sapSuiteLMCThresholdLabel");var e=d.outerHeight();var t=(i*(100-this._fNormalizedThreshold))*0.01;var f=t-(e/2);if(f<0){f=0;}else if(f+e>i){f=i-e;}d.css("top",f*100/i+"%");};
c.prototype._getAltHeaderText=function(i){var t=this._oRb.getText("LINEMICROCHART");if(i){t+=" "+this._oRb.getText("IS_ACTIVE");}t+="\n";if(!this._hasData()){t+=this._oRb.getText("NO_DATA");return t;}var s=this.getLeftTopLabel();var S=this.getLeftBottomLabel();var e=this.getRightTopLabel();var E=this.getRightBottomLabel();var I=true;if(s||S){t+=this._oRb.getText(("LINEMICROCHART_START"))+": "+S+" "+s;I=false;}if(e||E){t+=(I?"":"\n")+this._oRb.getText(("LINEMICROCHART_END"))+": "+E+" "+e;}return t;};
c.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};
c.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};
c.prototype._bindMouseEnterLeaveHandler=function(){this.$().bind("mouseenter.tooltip",this._addTitleAttribute.bind(this));this.$().bind("mouseleave.tooltip",this._removeTitleAttribute.bind(this));};
c.prototype._unbindMouseEnterLeaveHandler=function(){this.$().unbind("mouseenter.tooltip");this.$().unbind("mouseleave.tooltip");};
c.prototype._deregisterResizeHandler=function(){if(this._sResizeHandlerId){R.deregister(this._sResizeHandlerId);this._sResizeHandlerId=null;}};
c.prototype._hasData=function(){return this._getLines().length>0;};
c.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};
a.extendMicroChart(c);return c;});
sap.ui.predefine('sap/suite/ui/microchart/LineMicroChartEmphasizedPoint',["sap/m/library","sap/suite/ui/microchart/LineMicroChartPoint"],function(m,L){"use strict";var V=m.ValueCSSColor;
var a=L.extend("sap.suite.ui.microchart.LineMicroChartEmphasizedPoint",{metadata:{properties:{color:{type:"sap.m.ValueCSSColor",group:"Misc",defaultValue:"Neutral"},show:{type:"boolean",group:"Appearance",defaultValue:false}}}});
a.prototype.setColor=function(v){this.setProperty("color",V.isValid(v)?v:null);return this;};
return a;});
sap.ui.predefine('sap/suite/ui/microchart/LineMicroChartLine',["./library","sap/ui/core/Element","sap/suite/ui/microchart/LineMicroChartEmphasizedPoint","sap/base/Log","sap/suite/ui/microchart/MicroChartUtils"],function(l,E,L,a,M){"use strict";var b=l.LineType;
var c=E.extend("sap.suite.ui.microchart.LineMicroChartLine",{metadata:{library:"sap.suite.ui.microchart",properties:{color:{type:"any",group:"Appearance"},showPoints:{type:"boolean",group:"Appearance"},type:{type:"sap.suite.ui.microchart.LineType",group:"Appearance",defaultValue:b.Solid}},defaultAggregation:"points",aggregations:{points:{type:"sap.suite.ui.microchart.LineMicroChartPoint",multiple:true,bindable:"bindable"}}}});
c.getMetadata().getAllAggregations()["points"]._doesNotRequireFactory=true;
c.prototype.bindAggregation=function(n,B){if(n==="points"){if(!B.factory&&!B.template){this._bNoFactory=true;}}E.prototype.bindAggregation.apply(this,arguments);};
c.prototype.updatePoints=function(r){if(!this._bNoFactory){return this.updateAggregation("points");}else{this.rerender();}};
c.prototype.clone=function(){var C=E.prototype.clone.apply(this,arguments);C._bNoFactory=this._bNoFactory;return C;};
c.prototype._getPoints=function(){var t=this;if(!this._bNoFactory){var p=this.getAggregation("points");return p===null?[]:p;}return this.getBinding("points").getContexts().map(function(P){return{getX:function(){return P.getProperty("x");},getY:function(){return P.getProperty("y");},getShow:function(){return P.getProperty("show")?P.getProperty("show"):t._getEmphPointPropDefaultValue("show");},getColor:function(){return P.getProperty("color")?P.getProperty("color"):t._getEmphPointPropDefaultValue("color");},getMetadata:function(){return{getName:function(){return P.getProperty("emphasized")?"sap.suite.ui.microchart.LineMicroChartEmphasizedPoint":"sap.suite.ui.microchart.LineMicroChartPoint";}};}};});};
c.prototype._getEmphPointPropDefaultValue=function(p){return L.getMetadata().getProperty(p).getDefaultValue();};
c.prototype.getColor=function(){var C=this.getProperty("color"),p=this.getParent();if(C===undefined||C===null){if(p&&p.isA("sap.suite.ui.microchart.LineMicroChart")){C=p.getColor();}}return C;};
c.prototype.validateProperty=function(p,v){if(v===null||v===undefined){return E.prototype.validateProperty.apply(this,[p,null]);}if(p==="color"&&!this.isColorCorrect(v)){a.warning("Color property of LineMicroChartLine must be of type sap.m.ValueCSSColor either as single value or as composite value (above: value, below: value)");v=null;}return E.prototype.validateProperty.apply(this,[p,v]);};
c.prototype.getShowPoints=function(){var p=this.getParent(),C=this.getProperty("showPoints");if(C===undefined||C===null){if(p&&p.isA("sap.suite.ui.microchart.LineMicroChart")){C=p.getShowPoints();}}return C;};
M.extendMicroChart(c);return c;});
sap.ui.predefine('sap/suite/ui/microchart/LineMicroChartPoint',['sap/ui/core/Element'],function(E){"use strict";
var L=E.extend("sap.suite.ui.microchart.LineMicroChartPoint",{metadata:{properties:{x:{type:"float",group:"Data",defaultValue:0},y:{type:"float",group:"Data",defaultValue:0}}}});
return L;});
sap.ui.predefine('sap/suite/ui/microchart/LineMicroChartRenderer',['./library','sap/ui/core/theming/Parameters',"sap/base/security/encodeXML",'sap/suite/ui/microchart/MicroChartRenderUtils','sap/m/library'],function(l,P,e,M,m){"use strict";var L={};var a=l.LineType;var V=m.ValueColor;L.QUALITATIVE_CLASS="sapUiChartPaletteQualitativeHue";L.QUALITATIVE_MAX=22;
L.render=function(r,c){if(c._hasData()){r.write("<div");this._writeMainProperties(r,c);r.writeStyles();if(c._bSemanticMode){r.addClass("sapSuiteLMCSemanticMode");}if(c._bFocusMode){r.addClass("sapSuiteLMCFocusMode");}if(c._bNoBottomLabels||!c.getShowBottomLabels()){r.addClass("sapSuiteLMCNoBottomLabels");}if(c._bNoTopLabels||!c.getShowTopLabels()){r.addClass("sapSuiteLMCNoTopLabels");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapSuiteLMCVerticalAlignmentContainer");r.writeClasses();r.write(">");this._renderLabelsTop(r,c);r.write("<div");r.addClass("sapSuiteLMCContentWrapper");r.writeClasses();r.write(">");this._renderCanvas(r,c);this._renderThresholdLabel(r,c);r.write("</div>");this._renderLabelsBottom(r,c);r.write("</div>");r.write("</div>");}else{r.write("<div");this._writeMainProperties(r,c);r.writeClasses();r.writeStyles();r.write(">");this._renderNoData(r);r.write("</div>");}};
L._writeMainProperties=function(r,c){var i=c.hasListeners("press");this._renderActiveProperties(r,c);var A=c.getTooltip_AsString(i);r.writeAttribute("role","img");if(c.getAriaLabelledBy().length){r.writeAccessibilityState(c);}else{r.writeAttributeEscaped("aria-label",A);}r.writeControlData(c);r.addClass("sapSuiteLMC");r.addClass("sapSuiteLMCSize"+c.getSize());r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());};
L._renderCanvas=function(r,c){var p;var b;r.write("<div");r.addClass("sapSuiteLMCSvgCanvas");r.writeClasses();r.write(">");if(c._bScalingValid){r.write("<svg");r.writeAttributeEscaped("id",c.getId()+"-sapSuiteLMCSvgElement");r.writeAttribute("focusable","false");r.addClass("sapSuiteLMCSvgElement");r.writeClasses();r.write(">");this._renderThresholdLine(r,c);c._getLines().forEach(function(o,I){r.write("<g");r.writeElementData(o);r.write(">");b=o._getPoints().length;for(var i=1;i<b;i++){this._renderLine(r,c,I,o._aNormalizedPoints[i-1].x,o._aNormalizedPoints[i-1].y,o._aNormalizedPoints[i].x,o._aNormalizedPoints[i].y);}r.write("</g>");},this);r.write('</svg>');r.write("<div");r.addClass("sapSuiteLMCPointsContainer");r.writeAttributeEscaped("id",c.getId()+"-sapSuiteLMCPointsContainer");r.writeClasses();r.write(">");c._getLines().forEach(function(o,i){p=o._getPoints();b=p.length;var s=o.getShowPoints(),d,f;if(o._bFocusMode||s){for(var j=0;j<b;j++){d=p[j];f=this._isPointEmphasized(d);if(!o._bFocusMode&&s||o._bFocusMode&&f&&d.getShow()){this._renderPoint(r,c,i,d,j,f);}}}},this);r.write("</div>");}r.write("</div>");};
L._renderThresholdLabel=function(r,c){var v=c.getThresholdDisplayValue();if(this._isThresholdValue(c)&&c.getShowThresholdLine()&&c.getShowThresholdValue()){r.write("<div");r.addClass("sapSuiteLMCThresholdLabelWrapper");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapSuiteLMCThresholdLabel");r.writeClasses();r.write(">");v=v?v:c.getThreshold();r.writeEscaped(v);r.write("</div>");r.write("</div>");}};
L._renderPoint=function(r,c,i,p,b,E){var o=c._getLines()[i],t=o.getType(),n=o._aNormalizedPoints[b],C=o.getColor(),d,s;if(n.x<0||n.x>100||n.y<0||n.y>100){return;}r.write("<div");r.addStyle("left",e(n.x+"%"));r.addStyle("top",e(100-n.y+"%"));s=(t===a.Dotted)?"border-color":"background-color";r.addClass("sapSuiteLMCPoint"+t);if(o._bFocusMode&&o._bSemanticMode){d=p.getColor();if(V[d]){r.addClass("sapSuiteLMCPoint"+e(d));}else{r.addStyle(s,e(this._getHexColor(d)));}}else if(!o._bFocusMode&&o._bSemanticMode){if(p.getY()>=c.getThreshold()){if(V[C.above]){r.addClass("sapSuiteLMCPoint"+e(C.above));}else{r.addStyle(s,e(this._getHexColor(C.above)));}}else if(V[C.below]){r.addClass("sapSuiteLMCPoint"+e(C.below));}else{r.addStyle(s,e(this._getHexColor(C.below)));}}else if(!o._bSemanticMode&&typeof C==="string"){if(o.getColor()===V.Neutral){r.addStyle(s,e(this._getQualitativeColor(i+1)));}else if(V[C]){r.addClass("sapSuiteLMCPoint"+e(C));}else{r.addStyle(s,e(this._getHexColor(C)));}}else{r.addStyle(s,e(this._getQualitativeColor(i+1)));}r.addClass("sapSuiteLMCPoint");if(E&&p.getShow()){r.addClass("sapSuiteLMCPointEmphasized");}r.writeClasses();r.writeStyles();r.write("></div>");};
L._renderThresholdLine=function(r,c){if(this._isThresholdValue(c)&&c.getShowThresholdLine()){r.write("<line");r.writeAttribute("x1","0%");r.writeAttributeEscaped("y1",(100-c._fNormalizedThreshold)+"%");r.writeAttribute("x2","100%");r.writeAttributeEscaped("y2",(100-c._fNormalizedThreshold)+"%");r.addClass("sapSuiteLMCLineThreshold");r.writeClasses();r.write("/>");}};
L._isThresholdValue=function(c){return c._fNormalizedThreshold>=0&&c._fNormalizedThreshold<=100&&!c._bThresholdNull;};
L._renderLine=function(r,c,i,s,S,E,b){if(this._isDimensionLineOutsideCanvas(c,s,E,"X")||this._isDimensionLineOutsideCanvas(c,S,b,"Y")){return;}var I,f,d=E-s,g=b-S;if((S-c._fNormalizedThreshold)*(b-c._fNormalizedThreshold)<0){I=s+(c._fNormalizedThreshold-S)*d/g;this._renderLine(r,c,i,s,S,I,c._fNormalizedThreshold);this._renderLine(r,c,i,I,c._fNormalizedThreshold,E,b);}else if(S*b<0){I=s-S*d/g;this._renderLine(r,c,i,s,S,I,0);this._renderLine(r,c,i,I,0,E,b);}else if((S-100)*(b-100)<0){I=s+(100-S)*d/g;this._renderLine(r,c,i,s,S,I,100);this._renderLine(r,c,i,I,100,E,b);}else if(s*E<0){f=S-s*g/d;this._renderLine(r,c,i,s,S,0,f);this._renderLine(r,c,i,0,f,E,b);}else if((s-100)*(E-100)<0){f=S+(100-s)*g/d;this._renderLine(r,c,i,s,S,100,f);this._renderLine(r,c,i,100,f,E,b);}else{this._displayLine(r,c,i,s,S,E,b);}};
L._displayLine=function(r,c,i,s,S,E,b){var o=c._getLines()[i],C=o.getColor();r.write("<line");r.writeAttributeEscaped("x1",s+"%");r.writeAttributeEscaped("y1",(100-S)+"%");r.writeAttributeEscaped("x2",E+"%");r.writeAttributeEscaped("y2",(100-b)+"%");r.addClass("sapSuiteLMCLine");r.addClass("sapSuiteLMCLine"+o.getType());if(o._bSemanticMode&&o._bFocusMode){r.addClass("sapSuiteLMCLineNeutral");}else if(o._bSemanticMode&&!o._bFocusMode){if(S>=c._fNormalizedThreshold&&b>=c._fNormalizedThreshold){if(V[C.above]){r.addClass("sapSuiteLMCLine"+e(C.above));}else{r.addStyle("stroke",e(this._getHexColor(C.above)));}}else if(V[C.below]){r.addClass("sapSuiteLMCLine"+e(C.below));}else{r.addStyle("stroke",e(this._getHexColor(C.below)));}}else if(!o._bSemanticMode&&typeof C==="string"){if(C===V.Neutral){r.addStyle("stroke",e(this._getQualitativeColor(i+1)));}else if(V[C]){r.addClass("sapSuiteLMCLine"+e(C));}else{r.addStyle("stroke",e(this._getHexColor(C)));}}else{r.addStyle("stroke",e(this._getQualitativeColor(i+1)));}r.writeStyles();r.writeClasses();r.write("/>");};
L._getQualitativeColor=function(i){return this._getHexColor(this.QUALITATIVE_CLASS+(i%this.QUALITATIVE_MAX));};
L._renderLabelsBottom=function(r,c){var s=c.getLeftBottomLabel(),R=c.getRightBottomLabel();if(!c.getShowBottomLabels()||(!s&&!R)){return;}r.write("<div");r.addClass("sapSuiteLMCLabels");r.addClass("sapSuiteLMCLabelsBottom");r.writeClasses();r.write(">");if((s&&s.length>0)||(R&&R.length>0)){r.write("<div");r.addClass("sapSuiteLMCLeftBottomLabel");r.addClass("sapSuiteLMCLabel");r.writeClasses();r.write(">");r.writeEscaped(s);r.write("</div>");r.write("<div");r.addClass("sapSuiteLMCRightBottomLabel");r.addClass("sapSuiteLMCLabel");r.writeClasses();r.write(">");r.writeEscaped(R);r.write("</div>");}r.write("</div>");};
L._renderLabelsTop=function(r,c){var s=c.getLeftTopLabel(),R=c.getRightTopLabel(),o=c._getLines()[0];if(!c.getShowTopLabels()||(!s&&!R)){return;}var t="",T="",b="",d="",p,i,f,g,C;var A=function(j){r.addStyle("color",j);r.writeStyles();};var S=function(j,I){var k="",n="";if(this._isPointEmphasized(j)&&j.getShow()){C=j.getColor();if(V[C]){k="sapSuiteLMCLabel"+C;}else{n=this._getHexColor(C);}}else{k="sapSuiteLMCLabelNeutral";}if(I){d=n;T=k;}else{b=n;t=k;}}.bind(this);if(o&&o._getPoints().length>1){p=o._getPoints();i=p.length;f=p[0];g=p[i-1];var h=o.getColor();if(o._bFocusMode&&o._bSemanticMode&&c._bScalingValid){S(f,false);S(g,true);}else if(!o._bFocusMode&&o._bSemanticMode&&c._bScalingValid&&o.getShowPoints()&&V[h.above]&&V[h.below]){if(f.getY()>=c.getThreshold()){t="sapSuiteLMCLabel"+h.above;}else{t="sapSuiteLMCLabel"+h.below;}if(g.getY()>=c.getThreshold()){T="sapSuiteLMCLabel"+h.above;}else{T="sapSuiteLMCLabel"+h.below;}}else{t="sapSuiteLMCLabelNeutral";T="sapSuiteLMCLabelNeutral";}}r.write("<div");r.addClass("sapSuiteLMCLabels");r.addClass("sapSuiteLMCLabelsTop");r.writeClasses();r.write(">");if((s&&s.length>0)||(R&&R.length>0)){r.write("<div");r.addClass("sapSuiteLMCLeftTopLabel");r.addClass("sapSuiteLMCLabel");r.addClass(e(t));r.writeClasses();if(b){A(b);}r.write(">");r.writeEscaped(s);r.write("</div>");r.write("<div");r.addClass("sapSuiteLMCRightTopLabel");r.addClass("sapSuiteLMCLabel");r.addClass(e(T));r.writeClasses();if(d){A(d);}r.write(">");r.writeEscaped(c.getRightTopLabel());r.write("</div>");}r.write("</div>");};
L._isPointEmphasized=function(p){return p&&p.getMetadata().getName()==="sap.suite.ui.microchart.LineMicroChartEmphasizedPoint";};
L._getHexColor=function(c){return P.get(c)||c;};
L._isDimensionLineOutsideCanvas=function(c,s,b,d){var i=100,f=0;if(d==="X"&&c._minXScale===c._maxXScale){i=50;f=50;}else if(d==="Y"&&c._minYScale===c._maxYScale){i=50;f=50;}return((s>=i&&b>=i)&&!(s===i&&b===i))||((s<=f&&b<=f)&&!(s===f&&b===f));};
M.extendMicroChartRenderer(L);return L;},true);
sap.ui.predefine('sap/suite/ui/microchart/MicroChartRenderUtils',[],function(){"use strict";var M={extendMicroChartRenderer:function(a){a._renderNoData=function(r){r.write("<div");r.addClass("sapSuiteUiMicroChartNoData");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapSuiteUiMicroChartNoDataTextWrapper");r.writeClasses();r.write(">");var R=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");var t=R.getText("NO_DATA");r.write("<span>");r.writeEscaped(t);r.write("</span>");r.write("</div>");r.write("</div>");};a._renderActiveProperties=function(r,c){var i=c.hasListeners("press");if(i){if(c._hasData()){r.addClass("sapSuiteUiMicroChartPointer");}r.writeAttribute("tabindex","0");}};}};return M;},true);
sap.ui.predefine('sap/suite/ui/microchart/MicroChartUtils',["sap/ui/core/Control","sap/ui/Device","sap/m/library","sap/ui/thirdparty/jquery"],function(C,D,M,q){"use strict";var S=M.Size;var a={extendMicroChart:function(b){b.prototype._isResponsive=function(){return this.getSize()===S.Responsive;};b.prototype._digitsAfterDecimalPoint=function(v){var A=(""+v).match(/[.,](\d+)/g);return(A)?(""+A).length-1:0;};b.prototype.getAccessibilityInfo=function(){return{type:this._getAccessibilityControlType(),description:this.getTooltip_AsString()};};b.prototype._isThemeHighContrast=function(){return/(hcw|hcb)/g.test(sap.ui.getCore().getConfiguration().getTheme());};b.prototype.convertRemToPixels=function(r){return r*parseFloat(window.getComputedStyle(document.documentElement).fontSize);};b.prototype._isAnyLabelTruncated=function(l){return l.toArray().some(this._isLabelTruncated);};b.prototype._isAnyLabelVerticallyTruncated=function(l){return l.toArray().some(this._isLabelVerticallyTruncated);};b.prototype._isLabelTruncated=function(l){if(D.browser.edge||D.browser.msie){return Math.abs(l.scrollWidth-l.offsetWidth)>1;}else{return l.scrollWidth>l.offsetWidth;}};b.prototype._isLabelVerticallyTruncated=function(l){return Math.abs(l.scrollHeight-l.offsetHeight)>1;};b.prototype._isAnyLabelNumericAndTruncated=function(l){return l.toArray().some(this._isLabelNumericAndTruncated.bind(this));};b.prototype._isLabelNumericAndTruncated=function(l){return(!q.isNumeric(l.textContent))?false:this._isLabelTruncated(l);};b.prototype.isColorCorrect=function(c){return((M.ValueCSSColor.isValid(c)&&c!=="")||(M.ValueCSSColor.isValid(c.below)&&c.below!==""&&M.ValueCSSColor.isValid(c.above)&&c.above!==""));};b.prototype.getTooltip_AsString=function(i){var t=C.prototype.getTooltip_AsString.apply(this,arguments),T=this._getAltHeaderText(i),I=false;if(t){t=t.split("((AltText))").join(T);}if(!t){t="";I=true;}if(this._getAltSubText){t+=this._getAltSubText(I);}return t;};}};return a;},true);
sap.ui.predefine('sap/suite/ui/microchart/RadialMicroChart',["sap/ui/thirdparty/jquery","./library","sap/m/library","sap/ui/core/Control","sap/suite/ui/microchart/RadialMicroChartRenderer","sap/ui/Device","sap/ui/core/ResizeHandler","sap/base/Log","sap/ui/events/KeyCodes","sap/suite/ui/microchart/MicroChartUtils","./RadialMicroChartRenderer"],function(q,l,M,C,R,D,a,L,K,b){"use strict";var V=M.ValueColor;
var c=C.extend("sap.suite.ui.microchart.RadialMicroChart",{
constructor:function(i,s){var p;if(s&&typeof s.percentage==="number"){p=true;}else if(i&&typeof i.percentage==="number"){p=true;}else{p=false;}try{C.apply(this,arguments);this._bPercentageMode=p;}catch(e){this.destroy();throw e;}},
metadata:{library:"sap.suite.ui.microchart",properties:{total:{group:"Data",type:"float",defaultValue:null},fraction:{group:"Data",type:"float",defaultValue:null},percentage:{group:"Data",type:"float",defaultValue:null},valueColor:{group:"Appearance",type:"sap.m.ValueCSSColor",defaultValue:"Neutral"},size:{group:"Misc",type:"sap.m.Size",defaultValue:"Auto"},width:{group:"Misc",type:"sap.ui.core.CSSSize"},height:{group:"Misc",type:"sap.ui.core.CSSSize"},alignContent:{group:"Misc",type:"sap.suite.ui.microchart.HorizontalAlignmentType",defaultValue:"Left"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}
});
c.THRESHOLD_LOOK_XS=1.125;c.THRESHOLD_LOOK_S=3.5;c.THRESHOLD_LOOK_M=4.5;c.THRESHOLD_LOOK_L=5.875;c.THRESHOLD_WIDTH_NO_LABEL=6;
c.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
c.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};
c.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};
c.prototype.onBeforeRendering=function(){if(!this._getPercentageMode()){if(this.getTotal()===0){L.info("Total cannot be 0. Please add a valid total value.");}else{this.setProperty("percentage",Math.round((this.getFraction()*100/this.getTotal())*10)/10,true);}}this._unbindMouseEnterLeaveHandler();};
c.prototype.onAfterRendering=function(){this._bindMouseEnterLeaveHandler();this._sResizeHandlerId=a.register(this,this._onResize.bind(this));this._onResize();};
c.prototype.ontouchstart=function(e){if(this.hasListeners("press")===true){e.setMarked();}};
c.prototype.ontap=function(e){if(D.browser.msie){this.$().focus();}if(this.hasListeners("press")===true){e.setMarked();}this.firePress();};
c.prototype.onkeydown=function(e){if(e.which===K.SPACE){if(this.hasListeners("press")===true){e.setMarked();}e.preventDefault();}};
c.prototype.onkeyup=function(e){if(e.which===K.ENTER||e.which===K.SPACE){if(this.hasListeners("press")===true){e.setMarked();}this.firePress();e.preventDefault();}};
c.prototype.attachEvent=function(e,d,f,g){C.prototype.attachEvent.call(this,e,d,f,g);if(e==="press"){this.rerender();}return this;};
c.prototype.detachEvent=function(e,f,d){C.prototype.detachEvent.call(this,e,f,d);if(e==="press"){this.rerender();}return this;};
c.prototype.exit=function(){this._deregisterResizeHandler();};
c.prototype._getPercentageMode=function(){return this._bPercentageMode;};
c.prototype.setPercentage=function(p){if(q.type(p)==="number"){var f=Math.floor(p*10)/10;this._bPercentageMode=true;if(f!==this.getPercentage()){this.setProperty("percentage",f);}}else{this._bPercentageMode=false;this.setProperty("percentage",null);}return this;};
c.prototype._onResize=function(){var $=this.$(),i=$.height(),d=$.width(),o=$.find(".sapSuiteRMCOutsideLabel"),I=$.find(".sapSuiteRMCInsideLabel"),e=$.find(".sapSuiteRMCInnerContainer");$.removeClass("sapSuiteRMCLookL sapSuiteRMCLookM sapSuiteRMCLookS sapSuiteRMCLookXS");o.removeClass("sapSuiteRMCLabelHide");I.removeClass("sapSuiteRMCLabelHide");e.css("width",e.height());if(i<this.convertRemToPixels(c.THRESHOLD_LOOK_S)){$.addClass("sapSuiteRMCLookXS");I.addClass("sapSuiteRMCLabelHide");}else if(i<this.convertRemToPixels(c.THRESHOLD_LOOK_M)||d<this.convertRemToPixels(c.THRESHOLD_LOOK_M)){$.addClass("sapSuiteRMCLookS");o.addClass("sapSuiteRMCLabelHide");}else if(i<this.convertRemToPixels(c.THRESHOLD_LOOK_L)||d<this.convertRemToPixels(c.THRESHOLD_LOOK_L)){$.addClass("sapSuiteRMCLookM");o.addClass("sapSuiteRMCLabelHide");}else{$.addClass("sapSuiteRMCLookL");o.addClass("sapSuiteRMCLabelHide");}if(this._isAnyLabelTruncated(o)){o.addClass("sapSuiteRMCLabelHide");}if(this._isAnyLabelTruncated(I)){I.addClass("sapSuiteRMCLabelHide");}};
c.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_RADIALMICROCHART");};
c.prototype._isValueColorValid=function(){return V.hasOwnProperty(this.getValueColor());};
c.prototype._isTooltipSuppressed=function(){var t=this.getTooltip_Text();if(t&&q.trim(t).length===0){return true;}else{return false;}};
c.prototype._getAltHeaderText=function(i){var t=this._oRb.getText("RADIALMICROCHART");if(i){t+=" "+this._oRb.getText("IS_ACTIVE");}t+="\n";if(!this._hasData()){t+=this._oRb.getText("NO_DATA");return t;}var p=this.getPercentage();if(p>100){p=100;}else if(p<0){p=0;}if(this._isValueColorValid()){t+=this._oRb.getText("RADIALMICROCHART_ARIA_LABEL",[this.getPercentage(),this._getStatusText()]);}else{t+=this._oRb.getText("RADIALMICROCHART_PERCENTAGE_TEXT",p);}return t;};
c.prototype._getStatusText=function(){var v=this.getValueColor();switch(v){case V.Error:return this._oRb.getText("SEMANTIC_COLOR_ERROR");case V.Critical:return this._oRb.getText("SEMANTIC_COLOR_CRITICAL");case V.Good:return this._oRb.getText("SEMANTIC_COLOR_GOOD");case V.Neutral:return this._oRb.getText("SEMANTIC_COLOR_NEUTRAL");default:return"";}};
c.prototype._addTitleAttribute=function(){if(!this.$().attr("title")&&this._hasData()){this.$().attr("title",this.getTooltip_AsString());}};
c.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this.$().removeAttr("title");}};
c.prototype._bindMouseEnterLeaveHandler=function(){this.$().bind("mouseenter.tooltip",this._addTitleAttribute.bind(this));this.$().bind("mouseleave.tooltip",this._removeTitleAttribute.bind(this));};
c.prototype._unbindMouseEnterLeaveHandler=function(){this.$().unbind("mouseenter.tooltip");this.$().unbind("mouseleave.tooltip");};
c.prototype._hasData=function(){return true;};
c.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};
c.prototype._deregisterResizeHandler=function(){if(this._sResizeHandlerId){a.deregister(this._sResizeHandlerId);this._sResizeHandlerId=null;}};
b.extendMicroChart(c);return c;});
sap.ui.predefine('sap/suite/ui/microchart/RadialMicroChartRenderer',["sap/ui/Device","sap/m/ValueColor",'./library',"sap/base/security/encodeXML","sap/base/Log","sap/suite/ui/microchart/MicroChartRenderUtils","sap/ui/core/theming/Parameters"],function(D,V,l,e,L,M,P){"use strict";var R={};R.FORM_RATIO=100;R.BACKGROUND_CIRCLE_BORDER_WIDTH=1;R.BACKGROUND_CIRCLE_RADIUS=(R.FORM_RATIO/2.0)-(R.BACKGROUND_CIRCLE_BORDER_WIDTH/2.0);R.RING_WIDTH=8.75;R.RING_CORE_RADIUS=R.BACKGROUND_CIRCLE_RADIUS-(R.RING_WIDTH/2.0)-R.BACKGROUND_CIRCLE_BORDER_WIDTH;R.SVG_VIEWBOX_CENTER_FACTOR="50%";R.X_ROTATION=0;R.SWEEP_FLAG=1;R.PADDING_WIDTH=0.22;R.NUMBER_FONT_SIZE=23.5;R.EDGE_CASE_SIZE_USE_SMALL_FONT=54;R.EDGE_CASE_SIZE_SHOW_TEXT=46;R.EDGE_CASE_SIZE_MICRO_CHART=24;
R.render=function(r,c){if(!c._bThemeApplied){return;}if(c._hasData()){this._writeDivStartElement(c,r);this._writeOuterContainerElement(c,r);r.write("</div>");}else{r.write("<div");this._writeMainProperties(r,c);r.writeClasses();r.writeStyles();r.write(">");this._renderNoData(r);r.write("</div>");}};
R._writeOuterContainerElement=function(c,r){this._writeDivVerticalContainerElement(c,r);this._writeDivInnerContainerElement(c,r);if(this._renderingOfInnerContentIsRequired(c)){this._writeLabelInside(c,r);}this._writeSVGStartElement(c,r);this._writeBackground(r);if(this._renderingOfInnerContentIsRequired(c)){this._writeBorders(r);if(this._innerCircleRequired(c)){this._writeCircle(c,r);}else{this._writeCircleWithPathElements(c,r);}}r.write("</svg>");r.write("</div>");if(this._renderingOfInnerContentIsRequired(c)){this._writeLabelOutside(c,r);}r.write("</div>");};
R._writeMainProperties=function(r,c){var i=c.hasListeners("press");this._renderActiveProperties(r,c);var a=c.getTooltip_AsString(i);r.writeAttribute("role","img");if(c.getAriaLabelledBy().length){r.writeAccessibilityState(c);}else{r.writeAttributeEscaped("aria-label",a);}r.writeControlData(c);r.addClass("sapSuiteRMC");r.addClass("sapSuiteRMCSize"+c.getSize());r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());};
R._writeDivStartElement=function(c,r){r.write("<div");this._writeMainProperties(r,c);r.writeClasses();r.writeStyles();r.write(">");};
R._writeDivVerticalContainerElement=function(c,r){r.write("<div");r.addClass("sapSuiteRMCVerticalAlignmentContainer");r.addClass("sapSuiteRMCAlign"+c.getAlignContent());r.writeClasses();r.writeStyles();r.write(">");};
R._writeDivInnerContainerElement=function(c,r){r.write("<div");r.addClass("sapSuiteRMCInnerContainer");r.writeClasses();r.writeStyles();r.write(">");};
R._writeSVGStartElement=function(c,r){r.write("<svg class=\"sapSuiteRMCSvg"+"\" focusable=\"false"+"\" viewBox=\"0 0 "+R.FORM_RATIO+' '+R.FORM_RATIO+"\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\">");};
R._writeBackground=function(r){r.write("<circle class=\"sapSuiteRMCCircleBackground\" cx=\""+R.SVG_VIEWBOX_CENTER_FACTOR+"\" cy=\""+R.SVG_VIEWBOX_CENTER_FACTOR+"\" r=\""+R.BACKGROUND_CIRCLE_RADIUS+"\" stroke-width=\""+this.BACKGROUND_CIRCLE_BORDER_WIDTH+"\" />");};
R._writeBorders=function(r){var f=R.RING_CORE_RADIUS+(R.RING_WIDTH/2.0)-(R.BACKGROUND_CIRCLE_BORDER_WIDTH/2.0),a=R.RING_CORE_RADIUS-(R.RING_WIDTH/2.0)+(R.BACKGROUND_CIRCLE_BORDER_WIDTH/2.0);r.write("<circle");r.addClass("sapSuiteRMCRing");r.writeClasses();r.writeAttribute("cx",R.SVG_VIEWBOX_CENTER_FACTOR);r.writeAttribute("cy",R.SVG_VIEWBOX_CENTER_FACTOR);r.writeAttribute("r",f);r.writeAttribute("stroke-width",R.BACKGROUND_CIRCLE_BORDER_WIDTH);r.write("/>");r.write("<circle");r.addClass("sapSuiteRMCRing");r.writeClasses();r.writeAttribute("cx",R.SVG_VIEWBOX_CENTER_FACTOR);r.writeAttribute("cy",R.SVG_VIEWBOX_CENTER_FACTOR);r.writeAttribute("r",a);r.writeAttribute("stroke-width",R.BACKGROUND_CIRCLE_BORDER_WIDTH);r.write("/>");};
R._writeCircle=function(c,r){var C=this._getFullCircleColor(c);r.write("<circle");if(c._isValueColorValid()||C==="sapSuiteRMCRemainingCircle"){r.addClass(e(C));}else{r.writeAttributeEscaped("stroke",P.get(C)||C);}r.writeClasses();r.writeStyles();r.write("cx=\""+R.SVG_VIEWBOX_CENTER_FACTOR+"\" cy=\""+R.SVG_VIEWBOX_CENTER_FACTOR+"\" r=\""+R.RING_CORE_RADIUS+"\" fill=\"transparent\" stroke-width=\""+R.RING_WIDTH+"px\" />");};
R._writeCircleWithPathElements=function(c,r){var i=c.getPercentage()>50?1:0;var p=this._getPercentageForCircleRendering(c)-R.PADDING_WIDTH;var a=this._calculatePathCoordinates(c,p,false);this._writePath1(i,a,c,r);p=this._getPercentageForCircleRendering(c)+R.PADDING_WIDTH;a=this._calculatePathCoordinates(c,p,true);this._writePath2(i,a,c,r);};
R._writePath1=function(a,p,c,r){var s="M"+p[0]+" "+p[1]+" A "+R.RING_CORE_RADIUS+" "+R.RING_CORE_RADIUS+", "+R.X_ROTATION+", "+a+", "+R.SWEEP_FLAG+", "+p[2]+" "+p[3];var C=this._getPathColor(c);r.write("<path");r.addClass("sapSuiteRMCPath");if(c._isValueColorValid()||C==="sapSuiteRMCRemainingCircle"){r.addClass(e(C));}else{r.writeAttributeEscaped("stroke",P.get(C)||C);}r.writeClasses();r.writeStyles();r.write("d=\""+e(s)+"\" fill=\"transparent\" stroke-width=\""+R.RING_WIDTH+"px\" />");};
R._writePath2=function(a,p,c,r){var s="M"+p[2]+" "+p[3]+" A "+R.RING_CORE_RADIUS+" "+R.RING_CORE_RADIUS+", "+R.X_ROTATION+", "+(1-a)+", "+R.SWEEP_FLAG+", "+p[0]+" "+p[1];r.write("<path class=\"sapSuiteRMCPath sapSuiteRMCRemainingCircle\" d=\""+e(s)+"\" fill=\"transparent\" stroke-width=\""+R.RING_WIDTH+"px\" />");};
R._writeLabelInside=function(c,r){r.write("<div");r.addClass("sapSuiteRMCInsideLabel sapSuiteRMCFont "+this._getTextColorClass(c));r.writeClasses();r.writeStyles();r.write(">");r.write(e(this._generateTextContent(c)));r.write("</div>");};
R._writeLabelOutside=function(c,r){r.write("<div");r.addClass("sapSuiteRMCOutsideLabel sapSuiteRMCFont sapSuiteRMCLabelHide "+this._getTextColorClass(c));r.writeClasses();r.writeStyles();r.write(">");r.write(e(this._generateTextContent(c)));r.write("</div>");};
R._renderingOfInnerContentIsRequired=function(c){return c._hasData();};
R._getVerticalViewboxCenterFactorForText=function(){if(D.browser.msie||D.browser.mozilla||D.browser.edge){return"57%";}else{return"51%";}};
R._innerCircleRequired=function(c){return c.getPercentage()>=100||c.getPercentage()<=0;};
R._calculatePathCoordinates=function(c,p,h){var C=[];var f=0;var a=R.FORM_RATIO/2;if(h){f=2*R.PADDING_WIDTH/100*2*Math.PI;}C.push(a+R.RING_CORE_RADIUS*Math.cos(-Math.PI/2.0-f));C.push(a+R.RING_CORE_RADIUS*Math.sin(-Math.PI/2.0-f));C.push(a+R.RING_CORE_RADIUS*Math.cos(-Math.PI/2.0+p/100*2*Math.PI));C.push(a+R.RING_CORE_RADIUS*Math.sin(-Math.PI/2.0+p/100*2*Math.PI));return C;};
R._getPercentageForCircleRendering=function(c){var p=c.getPercentage();var f=p;if(p>99-R.PADDING_WIDTH){f=99-R.PADDING_WIDTH;}if(p<1+R.PADDING_WIDTH){f=1+R.PADDING_WIDTH;}return f;};
R._getTextColorClass=function(c){switch(c.getValueColor()){case V.Good:return"sapSuiteRMCGoodTextColor";case V.Error:return"sapSuiteRMCErrorTextColor";case V.Critical:return"sapSuiteRMCCriticalTextColor";default:return"sapSuiteRMCNeutralTextColor";}};
R._getFullCircleColor=function(c){if(c.getPercentage()>=100){return this._getPathColor(c);}if(c.getPercentage()<=0){return"sapSuiteRMCRemainingCircle";}};
R._getPathColor=function(c){var v=c.getValueColor();if(c._isValueColorValid()){switch(v){case V.Good:return"sapSuiteRMCPathGood";case V.Error:return"sapSuiteRMCPathError";case V.Critical:return"sapSuiteRMCPathCritical";default:return"sapSuiteRMCPathNeutral";}}else{return v;}};
R._generateTextContent=function(c){if(c.getPercentage()===100){return c._oRb.getText("RADIALMICROCHART_PERCENTAGE_TEXT",[100]);}if(c.getPercentage()===0){return c._oRb.getText("RADIALMICROCHART_PERCENTAGE_TEXT",[0]);}if(c.getPercentage()>=100){L.error("Values over 100%("+c.getPercentage()+"%) are not supported");return c._oRb.getText("RADIALMICROCHART_PERCENTAGE_TEXT",[100]);}if(c.getPercentage()<=0){L.error("Values below 0%("+c.getPercentage()+"%) are not supported");return c._oRb.getText("RADIALMICROCHART_PERCENTAGE_TEXT",[0]);}return c._oRb.getText("RADIALMICROCHART_PERCENTAGE_TEXT",[c.getPercentage()]);};
M.extendMicroChartRenderer(R);return R;},true);
sap.ui.predefine('sap/suite/ui/microchart/StackedBarMicroChart',["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/m/library","sap/ui/Device","sap/m/FlexBox","sap/suite/ui/microchart/MicroChartUtils","sap/ui/core/ResizeHandler","./StackedBarMicroChartRenderer"],function(q,l,C,M,D,F,c,R){"use strict";var S=M.Size;var V=M.ValueColor;
var d=C.extend("sap.suite.ui.microchart.StackedBarMicroChart",{metadata:{library:"sap.suite.ui.microchart",properties:{size:{type:"sap.m.Size",group:"Appearance",defaultValue:S.Auto},maxValue:{type:"float",group:"Appearance",defaultValue:null},precision:{type:"int",group:"Appearance",defaultValue:1},displayZeroValue:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Misc"},height:{type:"sap.ui.core.CSSSize",group:"Misc"},showLabels:{type:"boolean",group:"Misc",defaultValue:true}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},defaultAggregation:"bars",aggregations:{bars:{type:"sap.suite.ui.microchart.StackedBarMicroChartBar",multiple:true,bindable:"bindable"}},events:{press:{}}}});
d.THRESHOLD_SMALL_LOOK=1.125;d.BAR_COLOR_PARAM_DEFAULT="sapUiChartPaletteQualitativeHue";d.BAR_LABEL_CSSCLASS=".sapSuiteStackedMCBarLabel";d.BAR_CSSCLASS=".sapSuiteStackedMCBar";
d.prototype.attachEvent=function(){C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapSuiteUiMicroChartPointer");}return this;};
d.prototype.detachEvent=function(){C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapSuiteUiMicroChartPointer");}return this;};
d.prototype.onclick=function(e){if(D.browser.msie||D.browser.edge){this.$().focus();}if(this.hasListeners("press")){e.stopPropagation();this.firePress();}};
d.prototype.onsapspace=d.prototype.onclick;d.prototype.onsapenter=d.prototype.onclick;
d.prototype.setMaxValue=function(m){var b=q.isNumeric(m);this.setProperty("maxValue",b?m:null);return this;};
d.prototype.setTooltip=function(t){this._title=null;this.setAggregation("tooltip",t,true);return this;};
d.prototype._getAccessibilityControlType=function(){return this._oRb.getText("ACC_CTR_TYPE_STACKEDBARMICROCHART");};
d.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.suite.ui.microchart");this.setAggregation("tooltip","((AltText))",true);this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};
d.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);};
d.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this.invalidate();};
d.prototype.onBeforeRendering=function(){if(this._sChartResizeHandlerId){R.deregister(this._sChartResizeHandlerId);}this.$().unbind("mouseenter");this.$().unbind("mouseleave");};
d.prototype.onAfterRendering=function(){l._checkControlIsVisible(this,this._onControlIsVisible);};
d.prototype._onControlIsVisible=function(){this._sChartResizeHandlerId=R.register(this,this._onResize.bind(this));this._onResize();this.$().bind("mouseenter",this._addTitleAttribute.bind(this));this.$().bind("mouseleave",this._removeTitleAttribute.bind(this));};
d.prototype.exit=function(){R.deregister(this._sChartResizeHandlerId);};
d.prototype._getLocalizedColorMeaning=function(a){return this._oRb.getText(("SEMANTIC_COLOR_"+a).toUpperCase());};
d.prototype._calculateChartData=function(){var e=[];var f=this.getBars();var I=f.length;var g=12;var h=1;var p=this.getPrecision();var n=function(){if(g){if(h===g){h=1;}return d.BAR_COLOR_PARAM_DEFAULT+(h++);}};var t=0;var m=this.getMaxValue();var i=0;for(i;i<I;i++){if(!isNaN(f[i].getValue())){t=t+f[i].getValue();}}var T=Math.max(m,t);var v=m>=t;var P=0;var w=0;var o;for(i=0;i<I;i++){o={oBarData:f[i]};o.color=f[i].getValueColor();if(!o.color){o.color=n();}var j=isNaN(f[i].getValue())?0:f[i].getValue();var k=T===0?0:j*100/T;o.value=this._roundFloat(k,p);o.width=this._roundFloat(k,2);P=P+o.value;w=w+o.width;if(v){o.displayValue=f[i].getDisplayValue()||String(j);}else{o.displayValue=f[i].getDisplayValue()||String(o.value+"%");}e.push(o);}P=this._roundFloat(P,p);w=this._roundFloat(w,2);var r;if(w>100&&e.length>0){r=e.slice(0).sort(function(a,b){return b.width-a.width;})[0];r.width=this._roundFloat(r.width-w+100,2);}var s=function(f){return f.some(function(a){return a.width>0;});};if(m>t){o={value:this._roundFloat(100-P,p),width:this._roundFloat(100-w,2)};e.push(o);}else if(e.length>0&&w<100&&(!this.getDisplayZeroValue()||s(e))){r=e.slice(0).sort(function(a,b){return b.width-a.width;})[0];r.width=this._roundFloat(r.width-w+100,2);}return e;};
d.prototype._roundFloat=function(n,p){return parseFloat(n.toFixed(p));};
d.prototype._onResize=function(){this._resizeVertically();this._resizeHorizontally();};
d.prototype._resizeVertically=function(){var $=this.$();var i=parseFloat($.height());if(i<=this.convertRemToPixels(d.THRESHOLD_SMALL_LOOK)){$.addClass("sapSuiteStackedMCSmallLook");}else{$.removeClass("sapSuiteStackedMCSmallLook");}};
d.prototype._resizeHorizontally=function(){this._hideTruncatedLabels(d.BAR_LABEL_CSSCLASS);};
d.prototype._hideTruncatedLabels=function(a){var $=this.$();var L=$.find(a);L.removeClass("sapSuiteStackedMCBarLabelHidden");for(var i=0;i<L.length;i++){if(this._isLabelTruncated(L[i])){$.find(L[i]).addClass("sapSuiteStackedMCBarLabelHidden");}}};
d.prototype._getAltHeaderText=function(I){var a=this._calculateChartData(),t=this._oRb.getText("STACKEDBARMICROCHART");if(I){t+=" "+this._oRb.getText("IS_ACTIVE");}t+="\n";if(!this._hasData()){t+=this._oRb.getText("NO_DATA");return t;}var o,b,B,A=false;for(var i=0;i<a.length;i++){o=a[i];b=o.oBarData;B=b&&b.getTooltip_AsString();if(b&&b._isTooltipSuppressed()){continue;}if(A){t+="\n";}A=true;if(B){t+=B;}else if(o.displayValue){t+=o.displayValue;if(V[o.color]){t+=" "+this._getLocalizedColorMeaning(o.color);}}}return t;};
d.prototype._isTooltipSuppressed=function(){var t=this.getTooltip_AsString();return t&&q.trim(t).length===0;};
d.prototype._addTitleAttribute=function(){if(this.$().attr("title")){return;}if(!this._title&&this._hasData()){this._title=this.getTooltip_AsString();}if(this._title){this.$().attr("title",this._title);}};
d.prototype._removeTitleAttribute=function(){if(this.$().attr("title")){this._title=this.$().attr("title");this.$().removeAttr("title");}};
d.prototype._hasData=function(){return this.getBars().length>0;};
d.prototype.firePress=function(){if(this._hasData()){C.prototype.fireEvent.call(this,"press",arguments);}};
c.extendMicroChart(d);return d;});
sap.ui.predefine('sap/suite/ui/microchart/StackedBarMicroChartBar',["sap/ui/thirdparty/jquery",'./library','sap/ui/core/Element',"sap/m/library"],function(q,l,E,m){"use strict";var V=m.ValueCSSColor;
var S=E.extend("sap.suite.ui.microchart.StackedBarMicroChartBar",{metadata:{library:"sap.suite.ui.microchart",properties:{value:{type:"float",group:"Data",defaultValue:"0"},valueColor:{type:"sap.m.ValueCSSColor",group:"Appearance",defaultValue:null},displayValue:{type:"string",group:"Data",defaultValue:null}}}});
S.prototype.setValue=function(v,s){var i=q.isNumeric(v);return this.setProperty("value",i?v:NaN,s);};
S.prototype.setValueColor=function(v,s){var i=V.isValid(v);return this.setProperty("valueColor",i?v:null,s);};
S.prototype._isTooltipSuppressed=function(){var t=this.getTooltip();return t&&q.trim(t).length===0;};
return S;});
sap.ui.predefine('sap/suite/ui/microchart/StackedBarMicroChartRenderer',['sap/m/library','sap/ui/core/theming/Parameters','./library','sap/suite/ui/microchart/MicroChartRenderUtils','sap/base/security/encodeXML'],function(m,P,l,M,e){"use strict";var V=m.ValueColor;var S={};S.LABEL_COLOR_LIGHT="#ffffff";S.LABEL_COLOR_DARK="#000000";S.COLORNAME_TO_HEX_MAP={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgrey:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",grey:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};S.SEMANTIC_COLORS={Good:"Positive",Error:"Negative"};
S.render=function(r,c){if(c._hasData()){var C=c._calculateChartData();if(!c._bThemeApplied){return;}this._aBars=c.getAggregation("bars");r.write("<div");this._writeMainProperties(r,c);r.writeClasses();var t=c.getTooltip_AsString();if(t&&typeof t==="string"){r.writeAttributeEscaped("title",t);}r.writeStyles();r.write(">");this._renderInnerContent(r,c,C);r.write("</div>");}else{r.write("<div");this._writeMainProperties(r,c);r.writeClasses();r.writeStyles();r.write(">");this._renderNoData(r);r.write("</div>");}};
S._writeMainProperties=function(r,c){var i=c.hasListeners("press");this._renderActiveProperties(r,c);r.writeAttribute("role","img");if(c.getAriaLabelledBy().length){r.writeAccessibilityState(c);}else{r.writeAttributeEscaped("aria-label",c.getTooltip_AsString(i));}r.writeControlData(c);r.addClass("sapSuiteStackedMC");r.addClass("sapSuiteStackedMCSize"+c.getSize());r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());};
S._renderInnerContent=function(r,c,a){r.write("<div");r.addClass("sapSuiteStackedMCContainer");r.writeClasses();r.write(">");for(var i=0;i<a.length;i++){this._renderChartBar(r,c,a[i],i);}r.write("</div>");};
S._renderChartBar=function(r,c,d){if(!c.getDisplayZeroValue()&&d.width===0){return;}var C,R=c.getShowLabels();r.write("<div");r.addClass("sapSuiteStackedMCBar");if(d.oBarData){r.writeElementData(d.oBarData);}if(!d.color){r.addStyle("background-color","transparent");}else if(V[d.color]){r.addClass("sapSuiteStackedMCBarSemanticColor"+e(d.color));C=P.get(this._getValueCssParameter(d.color));}else{C=P.get(d.color);if(!C){C=d.color;}r.addStyle("background-color",e(C));}r.addStyle("width",e(d.width+"%"));r.writeClasses();r.writeStyles();r.write(">");if(C&&R){this._renderChartBarLabel(r,c,d.displayValue,C);}r.write("</div>");};
S._renderChartBarLabel=function(r,c,d,b){if(!d){return;}r.write("<div");r.addClass("sapSuiteStackedMCBarLabel");r.writeClasses();r.addStyle("color",e(this._getLabelColor(b)));r.writeStyles();r.write(">");r.writeEscaped(d);r.write("</div>");};
S._getLabelColor=function(b){var h=this._colorNameToHex(b);if(!h&&b.length===4){h="#"+new Array(3).join(b.substring(1,2))+new Array(3).join(b.substring(2,3))+new Array(3).join(b.substring(3,4));}else if(!h){h=b;}var r=parseInt(h.substring(1,3),16),g=parseInt(h.substring(3,5),16),B=parseInt(h.substring(5,7),16);var d=((r*299)+(g*587)+(B*114))/1000;if(d>127.5){return S.LABEL_COLOR_DARK;}else{return S.LABEL_COLOR_LIGHT;}};
S._getValueCssParameter=function(c){var s=this.SEMANTIC_COLORS[c]||c;return"sapUi"+s+"Element";};
S._colorNameToHex=function(c){return S.COLORNAME_TO_HEX_MAP[c];};
M.extendMicroChartRenderer(S);return S;},true);
sap.ui.predefine('sap/suite/ui/microchart/library',["sap/ui/thirdparty/jquery","sap/ui/core/library","sap/m/library"],function(q){"use strict";sap.ui.getCore().initLibrary({name:"sap.suite.ui.microchart",version:"1.71.34",dependencies:["sap.ui.core","sap.m"],types:["sap.suite.ui.microchart.AreaMicroChartViewType","sap.suite.ui.microchart.BulletMicroChartModeType","sap.suite.ui.microchart.CommonBackgroundType","sap.suite.ui.microchart.ComparisonMicroChartViewType","sap.suite.ui.microchart.DeltaMicroChartViewType","sap.suite.ui.microchart.HorizontalAlignmentType","sap.suite.ui.microchart.LoadStateType","sap.suite.ui.microchart.LineType"],interfaces:[],controls:["sap.suite.ui.microchart.AreaMicroChart","sap.suite.ui.microchart.BulletMicroChart","sap.suite.ui.microchart.ColumnMicroChart","sap.suite.ui.microchart.ComparisonMicroChart","sap.suite.ui.microchart.DeltaMicroChart","sap.suite.ui.microchart.HarveyBallMicroChart","sap.suite.ui.microchart.LineMicroChart","sap.suite.ui.microchart.InteractiveBarChart","sap.suite.ui.microchart.InteractiveDonutChart","sap.suite.ui.microchart.InteractiveLineChart","sap.suite.ui.microchart.RadialMicroChart","sap.suite.ui.microchart.StackedBarMicroChart"],elements:["sap.suite.ui.microchart.AreaMicroChartPoint","sap.suite.ui.microchart.AreaMicroChartItem","sap.suite.ui.microchart.AreaMicroChartLabel","sap.suite.ui.microchart.BulletMicroChartData","sap.suite.ui.microchart.ColumnMicroChartData","sap.suite.ui.microchart.ColumnMicroChartLabel","sap.suite.ui.microchart.ComparisonMicroChartData","sap.suite.ui.microchart.HarveyBallMicroChartItem","sap.suite.ui.microchart.LineMicroChartPoint","sap.suite.ui.microchart.LineMicroChartEmphasizedPoint","sap.suite.ui.microchart.LineMicroChartLine","sap.suite.ui.microchart.InteractiveBarChartBar","sap.suite.ui.microchart.InteractiveDonutChartSegment","sap.suite.ui.microchart.InteractiveLineChartPoint","sap.suite.ui.microchart.StackedBarMicroChartBar"]});sap.suite.ui.microchart.AreaMicroChartViewType={Normal:"Normal",Wide:"Wide"};sap.suite.ui.microchart.BulletMicroChartModeType={Actual:"Actual",Delta:"Delta"};sap.suite.ui.microchart.CommonBackgroundType={Lightest:"Lightest",ExtraLight:"ExtraLight",Light:"Light",MediumLight:"MediumLight",Medium:"Medium",Dark:"Dark",ExtraDark:"ExtraDark",Darkest:"Darkest",Transparent:"Transparent"};sap.suite.ui.microchart.LineType={Solid:"Solid",Dashed:"Dashed",Dotted:"Dotted"};sap.suite.ui.microchart.HorizontalAlignmentType={Left:"Left",Center:"Center",Right:"Right"};sap.suite.ui.microchart.ComparisonMicroChartViewType={Normal:"Normal",Wide:"Wide",Responsive:"Responsive"};sap.suite.ui.microchart.DeltaMicroChartViewType={Normal:"Normal",Wide:"Wide",Responsive:"Responsive"};sap.suite.ui.microchart.LoadStateType={Loading:"Loading",Loaded:"Loaded",Failed:"Failed",Disabled:"Disabled"};sap.suite.ui.microchart._aStandardMarginClassNames=["sapUiTinyMargin","sapUiSmallMargin","sapUiMediumMargin","sapUiLargeMargin","sapUiTinyMarginBeginEnd","sapUiTinyMarginTopBottom","sapUiSmallMarginBeginEnd","sapUiSmallMarginTopBottom","sapUiMediumMarginBeginEnd","sapUiMediumMarginTopBottom","sapUiLargeMarginBeginEnd","sapUiLargeMarginTopBottom","sapUiTinyMarginTop","sapUiTinyMarginBottom","sapUiTinyMarginBegin","sapUiTinyMarginEnd","sapUiSmallMarginTop","sapUiSmallMarginBottom","sapUiSmallMarginBegin","sapUiSmallMarginEnd","sapUiMediumMarginTop","sapUiMediumMarginBottom","sapUiMediumMarginBegin","sapUiMediumMarginEnd","sapUiLargeMarginTop","sapUiLargeMarginBottom","sapUiLargeMarginBegin","sapUiLargeMarginEnd","sapUiResponsiveMargin","sapUiNoMargin","sapUiNoMarginTop","sapUiNoMarginBottom","sapUiNoMarginBegin","sapUiNoMarginEnd"];
sap.suite.ui.microchart._removeStandardMargins=function(c){for(var i=0;i<sap.suite.ui.microchart._aStandardMarginClassNames.length;i++){if(c.hasStyleClass(sap.suite.ui.microchart._aStandardMarginClassNames[i])){c.removeStyleClass(sap.suite.ui.microchart._aStandardMarginClassNames[i]);}}};
sap.suite.ui.microchart._passParentContextToChild=function(c,C){if(c.data("_parentRenderingContext")){C.data("_parentRenderingContext",c.data("_parentRenderingContext"));}else if(q.isFunction(c.getParent)){C.data("_parentRenderingContext",c.getParent());}};
sap.suite.ui.microchart._isTooltipSuppressed=function(t){return t!==null&&t!==undefined&&!t.trim();};
sap.suite.ui.microchart._checkControlIsVisible=function(c,a){function i(){return c.getVisible()&&c.getDomRef()&&c.$().is(":visible")&&c.getDomRef().getBoundingClientRect().width!==0;}function d(){if(i()){sap.ui.getCore().detachIntervalTimer(d);a.call(c);}}var o=c.exit;c.exit=function(){sap.ui.getCore().detachIntervalTimer(d);if(o){o.call(c);}};if(i()){a.call(c);}else{sap.ui.getCore().attachIntervalTimer(d);}};
return sap.suite.ui.microchart;});
sap.ui.require.preload({
	"sap/suite/ui/microchart/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.suite.ui.microchart","type":"library","embeds":[],"applicationVersion":{"version":"1.71.34"},"title":"UI5 library: sap.suite.ui.microchart","description":"UI5 library: sap.suite.ui.microchart","ach":"CA-UI5-SC","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_belize","sap_belize_hcb","sap_belize_hcw","sap_belize_plus","sap_bluecrystal","sap_fiori_3","sap_fiori_3_dark","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.34"},"sap.m":{"minVersion":"1.71.34"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.suite.ui.microchart.AreaMicroChart","sap.suite.ui.microchart.BulletMicroChart","sap.suite.ui.microchart.ColumnMicroChart","sap.suite.ui.microchart.ComparisonMicroChart","sap.suite.ui.microchart.DeltaMicroChart","sap.suite.ui.microchart.HarveyBallMicroChart","sap.suite.ui.microchart.LineMicroChart","sap.suite.ui.microchart.InteractiveBarChart","sap.suite.ui.microchart.InteractiveDonutChart","sap.suite.ui.microchart.InteractiveLineChart","sap.suite.ui.microchart.RadialMicroChart","sap.suite.ui.microchart.StackedBarMicroChart"],"elements":["sap.suite.ui.microchart.AreaMicroChartPoint","sap.suite.ui.microchart.AreaMicroChartItem","sap.suite.ui.microchart.AreaMicroChartLabel","sap.suite.ui.microchart.BulletMicroChartData","sap.suite.ui.microchart.ColumnMicroChartData","sap.suite.ui.microchart.ColumnMicroChartLabel","sap.suite.ui.microchart.ComparisonMicroChartData","sap.suite.ui.microchart.HarveyBallMicroChartItem","sap.suite.ui.microchart.LineMicroChartPoint","sap.suite.ui.microchart.LineMicroChartEmphasizedPoint","sap.suite.ui.microchart.LineMicroChartLine","sap.suite.ui.microchart.InteractiveBarChartBar","sap.suite.ui.microchart.InteractiveDonutChartSegment","sap.suite.ui.microchart.InteractiveLineChartPoint","sap.suite.ui.microchart.StackedBarMicroChartBar"],"types":["sap.suite.ui.microchart.AreaMicroChartViewType","sap.suite.ui.microchart.BulletMicroChartModeType","sap.suite.ui.microchart.CommonBackgroundType","sap.suite.ui.microchart.ComparisonMicroChartViewType","sap.suite.ui.microchart.DeltaMicroChartViewType","sap.suite.ui.microchart.HorizontalAlignmentType","sap.suite.ui.microchart.LoadStateType","sap.suite.ui.microchart.LineType"],"interfaces":[]}}}}'
},"sap/suite/ui/microchart/library-preload"
);
//# sourceMappingURL=library-preload.js.map