/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['sap/m/Link','sap/m/ResponsivePopover','sap/m/Button','sap/m/Title','sap/m/Image','sap/m/Text','sap/m/VBox','sap/m/HBox','sap/m/ResponsivePopoverRenderer','./Factory','./LinkData','sap/ui/model/json/JSONModel','sap/ui/base/ManagedObjectObserver','sap/m/FlexItemData','sap/ui/model/BindingMode','sap/ui/Device','sap/m/library','sap/base/Log'],function(L,R,B,T,I,a,V,H,b,F,c,J,M,d,e,D,l,f){"use strict";var P=l.PlacementType;var g=l.FlexJustifyContent;var h=l.ButtonType;var N=R.extend("sap.ui.comp.navpopover.NavigationPopover",{metadata:{library:"sap.ui.comp",properties:{semanticObjectName:{type:"string",group:"Misc",defaultValue:null},semanticAttributes:{type:"object",group:"Misc",defaultValue:null},appStateKey:{type:"string",group:"Misc",defaultValue:null},mainNavigationId:{type:"string",group:"Misc",defaultValue:null},availableActionsPersonalizationText:{type:"string",group:"Misc",defaultValue:undefined}},aggregations:{availableActions:{type:"sap.ui.comp.navpopover.LinkData",multiple:true,singularName:"availableAction"},mainNavigation:{type:"sap.ui.comp.navpopover.LinkData",multiple:false},ownNavigation:{type:"sap.ui.comp.navpopover.LinkData",multiple:false}},associations:{source:{type:"sap.ui.core.Control",multiple:false},extraContent:{type:"sap.ui.core.Control",multiple:false},component:{type:"sap.ui.core.Element",multiple:false}},events:{targetsObtained:{},navigate:{parameters:{text:{type:"string"},href:{type:"string"}}},availableActionsPersonalizationPress:{}}},renderer:b.render});N.prototype.init=function(){R.prototype.init.call(this);var m=new J({mainNavigationLink:{title:undefined,subtitle:undefined,href:undefined,target:undefined},ownNavigation:undefined,availableActions:[],availableActionsPersonalizationText:undefined,extraContent:undefined});m.setDefaultBindingMode(e.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapuicompNavigationPopover");this._bUseExternalContent=false;this.addStyleClass("navigationPopover");this.setContentWidth("380px");this.setHorizontalScrolling(false);this.setShowHeader(D.system.phone);this.setPlacement(P.Auto);this._oObserver=null;};N.prototype.applySettings=function(s){if(s&&s.customData&&s.customData.getProperty("key")==="useExternalContent"){this._bUseExternalContent=true;}this._createContent();R.prototype.applySettings.apply(this,arguments);};N.prototype.exit=function(C){if(this._getInternalModel()){this._getInternalModel().destroy();}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}R.prototype.exit.apply(this,arguments);};N.prototype.retrieveNavTargets=function(){var x=F.getService("CrossApplicationNavigation");var u=F.getService("URLParsing");if(!x||!u){f.error("Service 'CrossApplicationNavigation' could not be obtained");this.fireTargetsObtained();return;}var t=this;this.setMainNavigation(null);this.setOwnNavigation(null);this.removeAllAvailableActions();var p=x.getLinks({semanticObject:this.getSemanticObjectName(),params:this.getSemanticAttributes(),appStateKey:this.getAppStateKey(),ui5Component:this._getComponent(),sortResultOnTexts:true});p.done(function(i){if(!i||!i.length){t.fireTargetsObtained();return;}var C=x.hrefForExternal();if(C&&C.indexOf("?")!==-1){C=C.split("?")[0];}i.forEach(function(o){if(o.intent.indexOf(C)===0){t.setOwnNavigation(new c({href:o.intent,text:o.text}));return;}var s=u.parseShellHash(o.intent);if(s.action&&(s.action==='displayFactSheet')){t.setMainNavigation(new c({href:o.intent,text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.comp").getText("POPOVER_FACTSHEET")}));return;}t.addAvailableAction(new c({href:o.intent,text:o.text}));});t.fireTargetsObtained();});p.fail(function(){f.error("'retrieveNavTargets' failed");});};N.prototype.show=function(o){var C=o||this._getControl();if(!C){f.error("no source assigned");return;}this.openBy(C);};N.prototype.getDirectLink=function(){if(this._bUseExternalContent){return this.getContent()[0].getDirectLink();}var m=this._getInternalModel();if(m.getProperty('/extraContent')){return null;}if(m.getProperty('/mainNavigationLink/href')&&!m.getProperty('/availableActions').length){return this._oHeaderArea.getItems()[0];}if(m.getProperty('/availableActions').length===1&&!m.getProperty('/mainNavigationLink/href')){return this._oActionArea.getItems()[0].getItems()[0];}return null;};N.prototype.hasContent=function(){if(this._bUseExternalContent){return this.getContent()[0].hasContent();}var m=this._getInternalModel();return!!m.getProperty("/mainNavigationLink/href")||!!m.getProperty("/availableActions").length||!!m.getProperty('/extraContent');};N.prototype.setMainNavigationId=function(m){if(this._bUseExternalContent){throw"The API should not be used in case that the external content has been set";}this.setProperty("mainNavigationId",m,true);var o=this._getInternalModel();if(typeof m==="string"){o.setProperty("/mainNavigationLink/title",m);}return this;};N.prototype.setAvailableActionsPersonalizationText=function(A){if(this._bUseExternalContent){throw"The API should not be used in case that the external content has been set";}this.setProperty("availableActionsPersonalizationText",A,true);var m=this._getInternalModel();m.setProperty("/availableActionsPersonalizationText",A);return this;};N.prototype.setExtraContent=function(C){if(this._bUseExternalContent){throw"The API should not be used in case that the external content has been set";}var m=this._getInternalModel();if(m.getProperty("/extraContent")){this._getContentContainer().removeItem(1);}if(typeof C==="string"){C=sap.ui.getCore().byId(C);}this._getContentContainer().insertItem(C,1);this.setAssociation("extraContent",C);m.setProperty("/extraContent",C);return this;};N.prototype.setMainNavigation=function(o){if(this._bUseExternalContent){throw"The API should not be used in case that the external content has been set";}this.setAggregation("mainNavigation",o,true);if(!o){return this;}var m=this._getInternalModel();if(o.getHref()){m.setProperty("/mainNavigationLink/href",this._convertToExternal(o.getHref()));m.setProperty("/mainNavigationLink/target",o.getTarget());}if(!m.getProperty("/mainNavigationLink/title")&&m.getProperty("/mainNavigationLink/title")!==''){m.setProperty("/mainNavigationLink/title",o.getText());}m.setProperty("/mainNavigationLink/subtitle",o.getDescription());return this;};N.prototype.addAvailableAction=function(o){if(this._bUseExternalContent){throw"The API should not be used in case that the external content has been set";}this.addAggregation("availableActions",o);if(!o){return this;}o.setHref(this._convertToExternal(o.getHref()));o.setPress(this._onLinkPress.bind(this));var m=this._getInternalModel();m.setProperty("/availableActions/"+this.indexOfAvailableAction(o)+"/",o.getJson());return this;};N.prototype.insertAvailableAction=function(o,i){if(this._bUseExternalContent){throw"The API should not be used in case that the external content has been set";}this.insertAggregation("availableActions",o,i);if(!o){return this;}o.setHref(this._convertToExternal(o.getHref()));o.setPress(this._onLinkPress.bind(this));var m=this._getInternalModel();m.setProperty("/availableActions/"+i+"/",o.getJson());return this;};N.prototype.removeAvailableAction=function(o){if(this._bUseExternalContent){throw"The API should not be used in case that the external content has been set";}var i=this.indexOfAvailableAction(o);if(i>-1){var m=this._getInternalModel();m.getData().availableActions.splice(i,1);m.refresh(true);}o=this.removeAggregation("availableActions",o);return o;};N.prototype.removeAllAvailableActions=function(){if(this._bUseExternalContent){throw"The API should not be used in case that the external content has been set";}var A=this.removeAllAggregation("availableActions");var m=this._getInternalModel();m.setProperty("/availableActions",[]);m.refresh(true);return A;};N.prototype.onAfterRenderingActionForm=function(){var m=this._getInternalModel();var C=m.getProperty("/extraContent")?m.getProperty("/extraContent").$()[0]:undefined;if(C&&C.scrollHeight>C.clientHeight){this._getContentContainer().setFitContainer(false).setJustifyContent(g.Start);}};N.prototype._createContent=function(){if(this._bUseExternalContent){return;}var t=this;var o=new L({href:{path:'/mainNavigationLink/href'},text:{path:'/mainNavigationLink/title'},target:{path:'/mainNavigationLink/target'},visible:{path:'/mainNavigationLink/title',formatter:function(i){return!!i;}},enabled:{path:'/mainNavigationLink/href',formatter:function(v){return!!v;}},press:this._onLinkPress.bind(this)});o.addStyleClass("navigationPopoverTitle");var s=new a({text:{path:'/mainNavigationLink/subtitle'},visible:{path:'/mainNavigationLink/subtitle',formatter:function(v){return!!v;}}});this._oHeaderArea=new V({items:[o,s],visible:{path:'/mainNavigationLink/title',formatter:function(i){return!!i;}}});this._oHeaderArea.addStyleClass("navigationPopoverTitleH1");this._oHeaderArea.addStyleClass("navigationPopoverHeader");this._oHeaderArea.setModel(this._getInternalModel());this._oObserver=new M(function(i){if(i.type==="property"&&i.name==="visible"){var m=this._getInternalModel().getProperty("/availableActions").filter(function(j){return j.visible===true;});S.setVisible(m.length>0||this._getInternalModel().getProperty("/enableAvailableActionsPersonalization"));this._oActionArea.setVisible(m.length>0);}}.bind(this));var S=new V();S.setModel(this._getInternalModel());S.addStyleClass("navigationPopoverSeparator");this._oActionArea=new V({items:{path:'/availableActions',templateShareable:false,factory:function(i,j){var k=new L({visible:"{visible}",text:"{text}",href:"{href}",target:"{target}",press:j.getProperty("press")});this._oObserver.observe(k,{properties:["visible"]});return new V({visible:"{visible}",layoutData:new d({styleClass:j.getProperty("description")?"navigationPopoverAvailableLinkGroup":"navigationPopoverAvailableLinkWithoutGroup"}),items:[k,new a({visible:"{visible}",text:"{description}"})]});}.bind(this)}});this._oActionArea.addEventDelegate({onAfterRendering:this.onAfterRenderingActionForm.bind(this)});this._oActionArea.addStyleClass("navigationPopoverAvailableLinks");this._oActionArea.setModel(this._getInternalModel());this._oPersonalizationButton=new H({visible:{parts:[{path:'/enableAvailableActionsPersonalization'}],formatter:function(E){return!!E;}},justifyContent:"End",items:new B({type:h.Transparent,text:{path:'/availableActionsPersonalizationText'},press:function(){t.fireAvailableActionsPersonalizationPress();}})});this._oPersonalizationButton.setModel(this._getInternalModel());this._oPersonalizationButton.addStyleClass("navigationPopoverPersonalizationButton");var C=new V({fitContainer:true,justifyContent:g.Start,items:[this._oHeaderArea]});if(this._getInternalModel().getProperty("/extraContent")){C.addItem(this._getInternalModel().getProperty("/extraContent"));}C.addItem(S).addItem(this._oActionArea).addItem(this._oPersonalizationButton);this.addContent(C);};N.prototype._onLinkPress=function(E){this.fireNavigate({text:E.getSource().getText(),href:E.getSource().getHref()});};N.prototype._convertToExternal=function(s){var x=F.getService("CrossApplicationNavigation");if(!x){return s;}return x.hrefForExternal({target:{shellHash:s}},this._getComponent());};N.prototype._getControl=function(){var C=this.getAssociation("source");if(typeof C==="string"){C=sap.ui.getCore().byId(C);}return C;};N.prototype._getComponent=function(){var C=this.getComponent();if(typeof C==="string"){C=sap.ui.getCore().getComponent(C);}return C;};N.prototype._getContentContainer=function(){return this.getContent()[0];};N.prototype._getInternalModel=function(){return this.getModel("$sapuicompNavigationPopover");};return N;},true);
