/*!
 * SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(["sap/ui/comp/library","sap/ui/base/ManagedObject","sap/m/Token",'sap/ui/comp/util/FormatUtil'],function(l,M,T,F){"use strict";var V=l.valuehelpdialog.ValueHelpRangeOperation;var a=function(d){this._sDefaultOperation=d;this._aKeyFields=[];this._mTypeOperations={"default":["EQ","BT","LT","LE","GT","GE","NE"],"string":["Empty","ExcludeEmpty","Contains","EQ","BT","StartsWith","EndsWith","LT","LE","GT","GE","NE"],"date":["EQ","BT","LT","LE","GT","GE","NE"],"time":["EQ","BT","LT","LE","GT","GE","NE"],"numeric":["EQ","BT","LT","LE","GT","GE","NE"],"numc":["Contains","EQ","BT","EndsWith","LT","LE","GT","GE","NE"],"boolean":["EQ"]};this._init();};a.prototype._init=function(){var e=F.getFormattedRangeText(V.Empty,null,null,false);var E=F.getFormattedRangeText(V.Empty,null,null,true);var s=E.replace("(","\\(").replace(")","\\)");this.createOperation("Empty",e,new RegExp("^"+e+"$","i"),e,function(t){return[];});this.createOperation("ExcludeEmpty",E,new RegExp("^"+s+"$","i"),E,function(t){return[];}).exclude=true;this.createOperation("BT","foo...bar",/^(.+)\.\.\.(.+)$/,"$0...$1",function(t){var v=this.re.exec(t);if(v){var b=v[1];if(b&&b.trim){b=b.trim();}var c=v[2];if(c&&c.trim){c=c.trim();}return[b,c];}return[];});this.createOperation("EQ","=foo",/^\=(.+)$/,"=$0");this.createOperation("Contains","*foo*",/^\*(.+)\*$/,"*$0*");this.createOperation("StartsWith","foo*",/^([^\*].*)\*$/,"$0*");this.createOperation("EndsWith","*foo",/^\*(.*[^\*])$/,"*$0");this.createOperation("LT","< foo",/^\<([^\=].*)$/,"<$0");this.createOperation("LE","<=foo",/^\<\=(.+)$/,"<=$0");this.createOperation("GT","> foo",/^\>([^\=].*)$/,">$0");this.createOperation("GE",">=foo",/^\>\=(.+)$/,">=$0");this.createOperation("NE","!=foo",/^\!\=(.+)|\!\(\=(.+)\)$/,"!(=$0)").exclude=true;};a.prototype.destroy=function(){if(this._oInput){this._oInput.removeValidator(this._validator);if(this._aOrgValidators&&this._aOrgValidators.length>0){this._oInput.addValidator(this._aOrgValidators);}this._oInput=null;}this._aOrgValidators=null;this._aKeyFields=null;this._mTypeOperations=null;};a.prototype.setDefaultOperation=function(o){this._sDefaultOperation=o;};a.prototype.getDefaultOperation=function(){return this._sDefaultOperation;};a.prototype.getOperations=function(){return this._mOperations;};a.prototype.getOperation=function(o){return this._mOperations&&this._mOperations[o];};a.prototype._getKeyFieldByLabel=function(L){var k;this._aKeyFields.some(function(K){if(K.label.toUpperCase()===L.toUpperCase()){k=K;}},this);return k;};a.prototype.addKeyField=function(k){this._aKeyFields.push(k);};a.prototype.getKeyFields=function(){return this._aKeyFields;};a.prototype.addTypeOperations=function(t,o){this._mTypeOperations[t]=o;};a.prototype.removeTypeOperations=function(t){delete this._mTypeOperations[t];};a.prototype.getTypeOperations=function(t){return this._mTypeOperations[t]||this._mTypeOperations["default"];};a.prototype.createOperation=function(o,e,r,t,p){if(!this._mOperations){this._mOperations={};}this._mOperations[o]={key:o,example:e,re:r,template:t,exclude:false,parser:this,match:function(s,k){var b=this.re.exec(s);if(b){var v=this.parse(s);if(k){v.forEach(function(c){if(k.hasOwnProperty("maxLength")&&k.maxLength>=0&&c.length>k.maxLength){b=null;}if(k.oType){try{c=k.oType.parseValue(c,"string");k.oType.validateValue(c);}catch(d){b=null;}}},this);}}return b;},parse:p||function(s){var v=this.re.exec(s);if(v){var b=v[1]||v[2];if(b&&b.trim){b=b.trim();}return[b];}return[];},getFilledTemplate:function(s,k){var v=this.parse(s);var b=[];var c="";for(var i=0;i<v.length;i++){b[i]=this.formatValue(v[i],false,k);}c=a._templateReplace(this.template,b);return c;},getConditionData:function(s,k){var b={};b.exclude=this.exclude;if(this.exclude){if(this.key=="NE"){b.operation="EQ";}else if(this.key=="ExcludeEmpty"){b.operation="Empty";}else{b.operation=this.key;}}else{b.operation=this.key;}var v=this.parse(s);for(var i=0;i<v.length;i++){b["value"+(i+1)]=this.formatValue(v[i],true,k);}return b;},formatValue:function(v,P,k){if(!k){return v;}if(k.hasOwnProperty("maxLength")){if(k.maxLength>=0){v=v.substring(0,k.maxLength);}}if(k.displayFormat){if(k.displayFormat==="UpperCase"){v=v.toUpperCase();}}if(k.oType){try{v=k.oType.parseValue(v,"string");k.oType.validateValue(v);}catch(b){return"ERROR";}if(!P){v=k.oType.formatValue(v,"string");}}return v;}};return this._mOperations[o];};a.prototype.removeOperation=function(o){delete this._mOperations[o];};a.prototype.removeAllOperations=function(){var o=Object.keys(this._mOperations);o.forEach(function(b){delete this._mOperations[b];},this);};a.prototype.getTranslatedText=function(t,o,r){var s=o.key;t=t!=="default"?"_"+t.toUpperCase()+"_":"";if(t==="_STRING_"||t==="_BOOLEAN_"||t==="_NUMC_"){t="";}if(t==="_TIME_"){t="_DATE_";}if(!r){r="sap.m";}s="CONDITIONPANEL_OPTION"+t+s;var b=sap.ui.getCore().getLibraryResourceBundle(r).getText(s)||s;if(b.startsWith("CONDITIONPANEL_OPTION")){s="CONDITIONPANEL_OPTION"+o.key;b=sap.ui.getCore().getLibraryResourceBundle(r).getText(s);}return b;};a.prototype.associateInput=function(i){this._oInput=i;this._aOrgValidators=this._oInput._tokenizer?this._oInput._tokenizer._aTokenValidators.slice():[];this._oInput.removeAllValidators();this._oInput.addValidator(this._validator.bind(this));};a.prototype._validator=function(b){if(this._aOrgValidators){var t;this._aOrgValidators.some(function(v){t=v(b);return t;},this);if(t){return t;}}if(b.text){return this._onValidate(b.text);}return null;};a._templateReplace=function(t,v){return t.replace(/\$\d/g,function(m){return v[parseInt(m.substr(1))];});};a.prototype._onValidate=function(t){var k=this._aKeyFields.length>0?this._aKeyFields[0]:null;if(this._oInput._getIsSuggestionPopupOpen&&this._oInput._getIsSuggestionPopupOpen()&&this._oInput._oSuggestionTable&&this._oInput._oSuggestionTable.getSelectedItem()){return null;}if(k){var b=/^\w+\:\s/.exec(t);if(b){var K=b[0];k=this._getKeyFieldByLabel(K.slice(0,K.indexOf(":")));if(k){t=t.slice(b[0].length).trim();}}}var c=k&&k.type||"default";var d=this.getTypeOperations(c);var C=function(o,t){if(o.match(t,k)){var r=o.getConditionData(t,k);r.keyField=k?k.key:null;if(k.hasOwnProperty("maxLength")&&k.maxLength==1){if(["Contains","EndsWith","StartsWith"].indexOf(o.key)!=-1){return;}}if(c=="numc"){if(["Contains","EndsWith"].indexOf(o.key)!=-1){r.value1=k.oType.formatValue(r.value1,"string");}}var s=(k&&k.label&&this._aKeyFields.length>1?k.label+": ":"")+o.getFilledTemplate(t,k);s=M.escapeSettingsValue(s);return new T({text:s,tooltip:s}).data("range",r);}return null;}.bind(this);var e;if(d.some(function(o){e=C(this._mOperations[o],t);return e;},this)){return e;}if(this._sDefaultOperation&&this._mOperations[this._sDefaultOperation]){t=a._templateReplace(this._mOperations[this._sDefaultOperation].template,[t]);return C(this._mOperations[this._sDefaultOperation],t);}return null;};return a;},true);
