/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['sap/ui/comp/util/DateTimeUtil','sap/m/DateTimePicker','sap/m/Select','sap/ui/core/Item','sap/m/ComboBox','sap/m/DatePicker','sap/m/DateRangeSelection','sap/m/TimePicker','sap/m/Input','sap/m/MultiComboBox','sap/ui/comp/smartfilterbar/SFBMultiInput','sap/m/SearchField','sap/m/Token','sap/ui/comp/odata/MetadataAnalyser','sap/ui/comp/providers/ValueHelpProvider','sap/ui/comp/providers/ValueListProvider','sap/ui/model/Filter','sap/ui/model/json/JSONModel','sap/ui/comp/odata/ODataType','sap/ui/comp/util/FormatUtil','sap/ui/base/EventProvider','sap/ui/comp/util/IdentifierUtil','sap/ui/comp/providers/TokenParser','sap/ui/core/format/DateFormat','sap/ui/comp/library','sap/ui/core/library','sap/ui/model/analytics/odata4analytics','sap/ui/model/FilterOperator',"sap/base/Log","sap/base/util/UriParameters","sap/base/security/encodeURL","sap/base/util/merge"],function(D,a,S,I,C,b,c,T,d,M,f,g,h,l,V,m,F,J,O,o,E,p,q,r,s,t,u,v,L,U,w,x){"use strict";var y=s.smartfilterbar.ControlType;var z=s.smartfilterbar.DisplayBehaviour;var A=s.smartfilterbar.FilterType;var B=t.ValueState;var G=s.valuehelpdialog.ValueHelpRangeOperation;var H=s.smartfilterbar.MandatoryType;var K=function(P){if(!m){m=sap.ui.require("sap/ui/comp/providers/ValueListProvider");}if(!V){V=sap.ui.require("sap/ui/comp/providers/ValueHelpProvider");}this._bInitialized=false;this._bPending=true;this._bConsiderAnalyticalParameters=false;this._bAttachInitializedDone=false;this._sDeferredGroupId;if(P){this._oParentODataModel=P.model;this._sServiceURL=P.serviceUrl;this._sBasicSearchFieldName=P.basicSearchFieldName;this._isBasicSearchEnabled=P.enableBasicSearch;this._bUseContainsAsDefault=P.useContainsAsDefaultFilter==="true";this.sEntityType=P.entityType;this.sEntitySet=P.entitySet;this._isRunningInValueHelpDialog=P.isRunningInValueHelpDialog;this._oAdditionalConfiguration=P.additionalConfiguration;this.sDefaultDropDownDisplayBehaviour=P.defaultDropDownDisplayBehaviour;this.sDefaultTokenDisplayBehaviour=P.defaultTokenDisplayBehaviour;if(typeof P.dateFormatSettings==="string"){try{this._oDateFormatSettings=P.dateFormatSettings?JSON.parse(P.dateFormatSettings):undefined;}catch(e){}}else{this._oDateFormatSettings=P.dateFormatSettings;}if(!this._oDateFormatSettings){this._oDateFormatSettings={};}if(!this._oDateFormatSettings.hasOwnProperty("UTC")){this._oDateFormatSettings["UTC"]=true;}this._oSmartFilter=P.smartFilter;this._bConsiderAnalyticalParameters=P.considerAnalyticalParameters;this._bUseDateRangeType=P.useDateRangeType;this._bConsiderSelectionVariants=P.considerSelectionVariants;this._aConsiderNavigations=P.considerNavigations;}this.sFilterModelName=K.FILTER_MODEL_NAME;this._sBasicFilterAreaID=K.BASIC_FILTER_AREA_ID;this._aAnalyticalParameters=[];this._aFilterBarViewMetadata=[];this._aFilterBarFieldNames=[];this._aFilterBarMultiValueFieldMetadata=[];this._aFilterBarStringDateFieldNames=[];this._aFilterBarDateFieldNames=[];this._aFilterBarTimeFieldNames=[];this._aFilterBarTimeIntervalFieldNames=[];this._aFilterBarDateTimeMultiValueFieldNames=[];this._aFilterBarStringFieldNames=[];this._aFilterBarDateTimeFieldNames=[];this._aFieldGroupAnnotation=[];this._oMetadataAnalyser=new l(this._oParentODataModel||this._sServiceURL);this.oModel=new J();this._aValueListProvider=[];this._aValueHelpDialogProvider=[];this._mTokenHandler={};this._mConditionTypeFields={};this._aSelectionVariants=[];this._oParameterization=null;this._oNonAnaParameterization=null;this._aPromises=[];};K.FILTER_MODEL_NAME="fi1t3rM0d31";K.BASIC_FILTER_AREA_ID="_BASIC";K.BASIC_SEARCH_FIELD_ID="_BASIC_SEARCH_FIELD";K.CUSTOM_FIELDS_MODEL_PROPERTY="_CUSTOM";K.FIELD_NAME_REGEX=/\./g;K._createFilterProvider=function(P){var e=new K(P);return e._intialiseMetadata();};K.prototype._intialiseMetadata=function(){var e,k,n,N,P,i,j,Q,R,W,X,Y;this._aPromises=[];this._aFilterBarViewMetadata.push({groupName:this._sBasicFilterAreaID,index:0,fields:[]});if(!this.sEntitySet&&this.sEntityType){this.sEntitySet=this._oMetadataAnalyser.getEntitySetNameFromEntityTypeName(this.sEntityType);}this.sEntityType=this._oMetadataAnalyser.getEntityTypeNameFromEntitySetName(this.sEntitySet);P=this._oMetadataAnalyser.getAllFilterableFieldsByEntitySetName(this.sEntitySet,this._bConsiderAnalyticalParameters,this._aConsiderNavigations);if(P){this._updateDisplayBehaviour();this._aFieldGroupAnnotation=this._oMetadataAnalyser.getFieldGroupsByFilterFacetsAnnotation(this.sEntityType);n=this._oMetadataAnalyser.getSelectionFieldsAnnotation(this.sEntityType);if(n&&n.selectionFields){this._aSelectionFields=n.selectionFields;}if(this._aFieldGroupAnnotation){e=this._aFieldGroupAnnotation.length;for(i=0;i<e;i++){N=this._aFieldGroupAnnotation[i];W=this._createGroupMetadata(N);W.index=this._aFilterBarViewMetadata.length;this._aFilterBarViewMetadata.push(W);}}e=P.length;for(i=0;i<e;i++){N=P[i];k=N.fields.length;W=this._createGroupMetadata(N);this._aFilterBarViewMetadata.push(W);for(j=0;j<k;j++){Q=N.fields[j];if(Q.type.indexOf("Edm.")===0){R=this._createFieldMetadata(Q);W.fields.push(R);this._aFilterBarFieldNames.push(R.fieldName);}}}}Y=this._getAdditionalConfigurationForCustomGroups(P);e=Y.length;for(j=0;j<e;j++){W=this._createGroupMetadataForCustomGroup(Y[j]);if(W){this._aFilterBarViewMetadata.push(W);}}X=this._getAdditionalConfigurationForCustomFilterFields();k=X.length;for(j=0;j<k;j++){R=this._createFieldMetadataForCustomFilterFields(X[j]);if(R){this._aFilterBarViewMetadata[0].fields.push(R);}}if(this._hasBasicSearch()){R=this._createBasicSearchFieldMetadata();this._aFilterBarViewMetadata[0].fields.push(R);}if(!this._isRunningInValueHelpDialog){this._createParameters();}return new Promise(function(Z){Promise.all(this._aPromises).then(function(){if(this._bConsiderSelectionVariants){this._createSelectionVariants();}this._applyGroupId();this._applyIndexes();this._createInitialModel(true);this._initializeConditionTypeFields();this.setPending(this.isPending());this._bInitialized=true;Z(this);}.bind(this));}.bind(this));};K.prototype._createSelectionVariants=function(){this._aSelectionVariants=this._oMetadataAnalyser.getSelectionVariantAnnotationList(this.sEntityType);};K.prototype._createParameters=function(){if(this._oMetadataAnalyser.isSemanticAggregation(this.sEntityType)){if(this._bConsiderAnalyticalParameters){var e=sap.ui.require("sap/ui/model/analytics/odata4analytics");if(e){this._createAnalyticalParameters(e);}else{var P=new Promise(function(R){sap.ui.require(["sap/ui/model/analytics/odata4analytics"],function(e){this._createAnalyticalParameters(e);R();}.bind(this));}.bind(this));this._aPromises.push(P);}}}else{this._createNonAnalyticalParameters();}};K.prototype._createAnalyticalParameters=function(e){this._oParameterization=this._getAnalyticParameterization(e);this._createAnalyticParameters(this._oParameterization);};K.prototype._getAnalyticParameterization=function(i){var j,Q;try{j=new i.Model(new i.Model.ReferenceByModel(this._oParentODataModel));}catch(e){throw"Failed to instantiate analytical extensions for given OData model: "+e.message;}Q=j&&j.findQueryResultByName(this.sEntitySet);return(Q&&Q.getParameterization());};K.prototype._createNonAnalyticalParameters=function(){if(this.sEntitySet){this._oNonAnaParameterization=this._oMetadataAnalyser.getParametersByEntitySetName(this.sEntitySet);if(this._oNonAnaParameterization){this._createParametersByEntitySetName(this._oNonAnaParameterization.entitySetName,this._oNonAnaParameterization.parameters);}}};K.prototype.attachPendingChange=function(e){if(!this._oEventProvider){this._oEventProvider=new E();}this._oEventProvider.attachEvent("PendingChange",e);};K.prototype.detachPendingChange=function(e){if(this._oEventProvider){this._oEventProvider.detachEvent("PendingChange",e);}};K.prototype.setPending=function(e){var i=this._bPending!==e;this._bPending=e;if(i&&this._oEventProvider){var P={};P.pending=e;this._oEventProvider.fireEvent("PendingChange",P);}};K.prototype.isPending=function(){if(!this._bInitialized){return true;}for(var n in this._mConditionTypeFields){if(this._mConditionTypeFields[n].conditionType.isPending()){return true;}}return false;};K.prototype._updateDisplayBehaviour=function(){this._sTextArrangementDisplayBehaviour=this._oMetadataAnalyser.getTextArrangementValue(this.sEntityType);if(!this.sDefaultDropDownDisplayBehaviour){if(this._sTextArrangementDisplayBehaviour){this.sDefaultDropDownDisplayBehaviour=this._sTextArrangementDisplayBehaviour;}else{this.sDefaultDropDownDisplayBehaviour=z.descriptionOnly;}}if(!this.sDefaultTokenDisplayBehaviour){if(this._sTextArrangementDisplayBehaviour){this.sDefaultTokenDisplayBehaviour=this._sTextArrangementDisplayBehaviour;}else{this.sDefaultTokenDisplayBehaviour=z.descriptionAndId;}}};K.prototype._hasBasicSearch=function(){return this._isBasicSearchEnabled;};K.prototype._getAdditionalConfigurationForCustomFilterFields=function(){var e,j,i,R;if(!this._oAdditionalConfiguration){return[];}e=this._oAdditionalConfiguration.getControlConfiguration();if(!this._aFilterBarFieldNames||!this._aFilterBarFieldNames.length){return e;}R=[];j=e.length;for(i=0;i<j;i++){if(this._aFilterBarFieldNames.indexOf(e[i].key)<0){R.push(e[i]);}}return R;};K.prototype._getAdditionalConfigurationForCustomGroups=function(e){var k,n,N,i,R,j,P,Q;if(!this._oAdditionalConfiguration){return[];}k=this._oAdditionalConfiguration.getGroupConfiguration();if(!e||!e.length){return k;}R=[];N=e.length;n=k.length;for(i=0;i<n;i++){P=false;for(j=0;j<N;j++){Q=e[j].groupName||e[j].groupEntitySetName;if(Q===k[i].key){P=true;break;}}if(!P){R.push(k[i]);}}return R;};K.prototype._createInitialModelForField=function(j,e,i){var k=false,n,N,P=false,Q=false,R=null,W=null,X,Y=null,Z=[],$=[];if(!e||e.isCustomFilterField){return;}if(e.filterRestriction!==A.multiple){Q=true;}if((e.filterType==="date")||(e.filterType==="time")||(e.filterType==="datetime")){k=true;}if(i){n=e.defaultFilterValues;P=n&&n.length;if(!P){if(e.defaultPropertyValue&&e.isParameter){N=e.defaultPropertyValue;if(e.filterType==="numeric"){N=this._getType(e).parseValue(N,"string");}n=[{low:N}];P=true;}else if(e.defaultFilterValue){N=e.defaultFilterValue;n=[{low:N,high:N,operator:"EQ",sign:"I"}];P=true;}}}if(e.filterRestriction===A.single){if(P){N=n[0];R=k?this._createDateTimeValue(e,N.low):N.low;}j[e.fieldName]=R;}else if(e.filterRestriction===A.interval&&e.type!=="Edm.Time"){if(P){N=n[0];R=k?this._createDateTimeValue(e,N.low):N.low;W=k?this._createDateTimeValue(e,N.high):N.high;}j[e.fieldName]={low:R,high:W};}else{if(P){X=n.length;while(X--){N=n[X];if(Q){Y={"exclude":N.sign==="E","operation":N.operator==="CP"?"Contains":N.operator,"keyField":e.fieldName,"value1":k?this._createDateTimeValue(e,N.low):N.low,"value2":k?null:N.high};if((e.filterType==="time")&&N.high){Y.value2=new Date(N.high);}}else{Y={key:k?this._createDateTimeValue(e,N.low):N.low,text:k?"":N.low};}Z.push(Y);}}this._aFilterBarMultiValueFieldMetadata.push(e);j[e.fieldName]={value:null};if(Q){$=Z.slice(0);Z=[];j[e.fieldName].ranges=$;}j[e.fieldName].items=Z;this._updateMultiValueControl(e.control,Z,$);}};K.prototype._createDateTimeValue=function(e,i){switch(e.type){case"Edm.Time":if(i.indexOf("PT")===0){return this._getTime(i);}else{L.error("Default value for "+e.fieldName+" could not be parsed.");}break;case"Edm.DateTime":if(typeof i=="string"&&e.displayFormat&&e.displayFormat.toLowerCase()=="date"){var P=i.split('T');i=P[0]+"T00:00:00";return new Date(i);}else{L.error("Default value for "+e.fieldName+" could not be parsed.");}break;case"Edm.DateTimeOffset":return new Date(i);default:L.error("Default value for "+e.fieldName+" could not be parsed.");}};K.prototype._createInitialModel=function(e){var k,n,N,P,j,i;k={};this._bCreatingInitialModel=true;this._aFilterBarMultiValueFieldMetadata=[];if(this._aFilterBarViewMetadata){n=this._aFilterBarViewMetadata.length;for(i=0;i<n;i++){P=this._aFilterBarViewMetadata[i];N=P.fields.length;for(j=0;j<N;j++){this._createInitialModelForField(k,P.fields[j],e);}}}if(this._aAnalyticalParameters){N=this._aAnalyticalParameters.length;for(j=0;j<N;j++){this._createInitialModelForField(k,this._aAnalyticalParameters[j],e);}}this.oModel.setData(k);if(!e){this._clearConditionTypeFields();}this._updateConditionTypeFields();this._bCreatingInitialModel=false;};K.prototype._updateMultiValueControl=function(e,j,R,k){var i=0,n=null,N=null,P=null,Q=null,W=null,X,Y,Z;if(e&&j){i=j.length;if(e instanceof f){n=[];while(i--){Q=j[i].text||j[i].key;var N=new h();N.setKey(j[i].key);N.setText(Q);N.setTooltip(Q);n.push(N);}if(R){i=R.length;while(i--){P=R[i];if((P.value1==="")&&(P.operation===v.EQ)){P.operation=G.Empty;P.tokenText=o.getFormattedRangeText(P.operation,null,null,P.exclude);}if(P.tokenText){Q=P.tokenText;}else{X=P.value1;Y=P.value2;if(k){var $=["date","datetime","time"];if($.indexOf(k.filterType)>-1){Z=this._getType(k);if(Z){if(X){X=Z.formatValue(X,"string");}if(Y){Y=Z.formatValue(Y,"string");}}}else if((k.filterType==="numeric")){Z=this._getType(k);if(Z){if(X!==""&&(X!==undefined)){if((k.filterType==="numeric")&&typeof X==="string"&&!isNaN(X)){X=parseFloat(X);P.value1=X;}X=Z.formatValue(X,"string");}if(Y!==""&&(Y!==undefined)){if((k.filterType==="numeric")&&typeof Y==="string"&&!isNaN(Y)){Y=parseFloat(Y);P.value2=Y;}Y=Z.formatValue(Y,"string");}}}else if((k.filterType==="boolean")){Z=this._getType(k);if(Z){if(X!==""&&(X!==undefined)&&X==="false"){X=Z.formatValue(false,"string");}else{X=Z.formatValue(X,"string");}if(Y!==""&&(Y!==undefined)&&Y==="false"){Y=Z.formatValue(false,"string");}else{Y=Z.formatValue(X,"string");}}}else{var _=k.isCalendarDate||((X instanceof Date)||(Y instanceof Date));if(_){Z=this._getType(k);if(X){X=Z.formatValue(X,"string");}if(Y){Y=Z.formatValue(Y,"string");}}}}Q=o.getFormattedRangeText(P.operation,X,Y,P.exclude);}N=new h();N.setText(Q);N.setTooltip(Q);N.data("range",P);n.push(N);}}e.setTokens(n);e.fireTokenUpdate();}if(e instanceof M){W=[];while(i--){W.push(j[i].key);}e.setSelectedKeys(W);}}};K.prototype._applyIndexes=function(){var e,i;if(!this._aFilterBarViewMetadata){return;}this._aFilterBarViewMetadata=this._sortByIndex(this._aFilterBarViewMetadata);e=this._aFilterBarViewMetadata.length;for(i=0;i<e;i++){if(this._aFilterBarViewMetadata[i].fields){this._aFilterBarViewMetadata[i].fields=this._sortByIndex(this._aFilterBarViewMetadata[i].fields);}}};K.prototype._sortByIndex=function(e){var j,i,k,R,n,N;if(!e||!e.length){return e;}R=[];j=[];k=e.length;for(i=0;i<k;i++){N=e[i];n=N.index;if(n>=0){j.push(N);}else{R.push(N);}}k=j.length;if(k){j=j.sort(function(P,Q){return P.index-Q.index;});if(!R.length){R=j;}else{for(i=0;i<k;i++){N=j[i];if(N.index>=R.length){R.push(N);}else{R.splice(N.index,0,N);}}}}return R;};K.prototype._applyGroupId=function(){var e,i,n,j,N,P,k;e=this._aFilterBarViewMetadata.length;for(i=0;i<e;i++){if(!this._aFilterBarViewMetadata[i].fields){continue;}n=this._aFilterBarViewMetadata[i].fields.length;for(j=0;j<n;j++){N=this._aFilterBarViewMetadata[i].fields[j];if(N&&N.groupId&&N.groupId!==this._aFilterBarViewMetadata[i].groupName){P=undefined;for(k=0;k<e;k++){if(this._aFilterBarViewMetadata[k].groupName===N.groupId){P=this._aFilterBarViewMetadata[k];break;}}if(P){this._aFilterBarViewMetadata[i].fields.splice(j,1);j--;n--;P.fields=P.fields||[];P.fields.push(N);}}}}};K.prototype._createFilterControlId=function(e){var i=this._oSmartFilter?this._oSmartFilter.getId():"unit-test";var j=p.replace(e.groupId||"");var n=p.replace(e.fieldName);return i+"-filterItemControl"+j+"-"+n;};K.prototype._createGroupMetadata=function(e){var i,j=null,k;k=e.groupName||e.groupEntitySetName;if(this._oAdditionalConfiguration){j=this._oAdditionalConfiguration.getGroupConfigurationByKey(k);}i={};i.groupName=k;i.groupLabel=this._getGroupLabel(e,j);i.fields=[];i.index=this._getGroupIndex(j);return i;};K.prototype._createGroupMetadataForCustomGroup=function(e){var i;i={};i.groupName=e.key;i.groupLabel=e.label;i.fields=[];i.index=this._getGroupIndex(e);return i;};K.prototype._getTime=function(e){var i=r.getTimeInstance({pattern:"'PT'hh'H'mm'M'ss'S'"});return i.parse(e);};K.prototype._checkMetadataDefaultValue=function(e){var i=e.defaultFilterValue||e.defaultPropertyValue;if(i){try{if((e.type==="Edm.Time")&&(i.indexOf("PT")===0)){this._getTime(i);}else{this._getType(e);}}catch(j){e.defaultPropertyValue=null;e.defaultFilterValue=null;L.error("default value for "+e.fieldName+" could not be parsed.");}}};K.prototype._getType=function(e){if(e.ui5Type){return e.ui5Type;}var i,j={},k={};if(e.precision||e.scale){k.precision=e.precision;k.scale=e.scale;}if(e.maxLength){k.maxLength=e.maxLength;}if(e.displayFormat){k.displayFormat=e.displayFormat;}if(e.isDigitSequence){k.isDigitSequence=e.isDigitSequence;}if((e.filterType==="date")||(e.filterType==="time")||(e.filterType==="datetime")||e.isCalendarDate){j=Object.assign({},this._oDateFormatSettings,{UTC:false});}i=O.getType(e.type,j,k,e.isCalendarDate);return i;};K.prototype._setControlDisplayFormat=function(e,i){var j;if(!i){return;}j=i.style||i.pattern;if(!j){return;}e.setDisplayFormat(j);};K.prototype._createControl=function(e){var i,j,k=false,n,N;if(e.customControl){return e.customControl;}j=this._getType(e);i=new e.fControlConstructor(this._createFilterControlId(e));if(e.fControlConstructor===c){this._setControlDisplayFormat(i,this._oDateFormatSettings);if(e.isCalendarDate){i.bindProperty("dateValue",{path:this.sFilterModelName+">/"+e.fieldName+"/low",type:j});i.bindProperty("secondDateValue",{path:this.sFilterModelName+">/"+e.fieldName+"/high",type:j});}else{i.bindProperty("dateValue",this.sFilterModelName+">/"+e.fieldName+"/low");i.bindProperty("secondDateValue",this.sFilterModelName+">/"+e.fieldName+"/high");}}else if((e.fControlConstructor===C)||(e.fControlConstructor===S)){if(i.setForceSelection){i.setForceSelection(true);}if(e.fControlConstructor===S){i.addItem(new I({key:"",text:""}));i.addItem(new I({key:false,text:j.formatValue(false,"string")}));i.addItem(new I({key:true,text:j.formatValue(true,"string")}));}else{this._associateValueList(i,"items",e);i.attachSelectionChange(function(){if(this._bUpdatingFilterData||this._bCreatingInitialModel){return;}i.fireChange({filterChangeReason:e.fieldName,value:""});}.bind(this));}i.bindProperty('selectedKey',this.sFilterModelName+">/"+e.fieldName);}else if(e.fControlConstructor===M){this._associateValueList(i,"items",e);i.attachSelectionChange(function(Q){if(this._bUpdatingFilterData||this._bCreatingInitialModel){return;}var R=Q.getSource(),W=null,X=[],Y;W=R.getSelectedItems();if(W){Y=W.length;while(Y--){X.push({key:W[Y].getKey(),text:W[Y].getText()});}}if(this.oModel){this.oModel.setProperty("/"+e.fieldName+"/items",X);}R.fireChange({filterChangeReason:e.fieldName,value:""});}.bind(this));i.bindProperty("value",this.sFilterModelName+">/"+e.fieldName+"/value");}else if(e.fControlConstructor===f){if(e.controlType===y.date||e.type==="Edm.Time"||e.type==="Edm.DateTimeOffset"){i.setValueHelpOnly(true);if(e.filterRestriction===A.interval){this._associateValueHelpDialog(i,e,false,false);}else{this._associateValueHelpDialog(i,e,true,true);}}else{if(e.hasValueHelpDialog){this._associateValueHelpDialog(i,e,e.filterRestriction!==A.multiple,true);}else{i.setShowValueHelp(false);}i.bindProperty("value",{path:this.sFilterModelName+">/"+e.fieldName+"/value",type:j});}this._handleMultiInput(i,e,j);}else if(e.fControlConstructor===d){if(e.filterRestriction===A.interval){k=true;i.bindProperty("value",this.sFilterModelName+">/"+e.fieldName+"/low");if(!this.oResourceBundle){this.oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.comp");}if(!this.sIntervalPlaceholder){this.sIntervalPlaceholder=this.oResourceBundle.getText("INTERVAL_PLACEHOLDER_TEXT");}i.setPlaceholder(this.sIntervalPlaceholder);}else{i.bindProperty('value',{path:this.sFilterModelName+">/"+e.fieldName,type:j});}if(e.hasValueHelpDialog){i.setShowValueHelp(true);this._associateValueHelpDialog(i,e,false,false);}}else if(e.isCalendarDate){this._setControlDisplayFormat(i,this._oDateFormatSettings);i.bindProperty("dateValue",{path:this.sFilterModelName+">/"+e.fieldName,type:j});}else if(e.fControlConstructor===b){i.bindProperty("dateValue",this.sFilterModelName+">/"+e.fieldName);this._setControlDisplayFormat(i,this._oDateFormatSettings);}else if(e.fControlConstructor===T||e.fControlConstructor===a){i.bindProperty("dateValue",this.sFilterModelName+">/"+e.fieldName);if(this._oDateFormatSettings&&this._oDateFormatSettings.style){i.setDisplayFormat(this._oDateFormatSettings.style);}}if(i instanceof b){i.attachChange(function(Q){var R=Q.getParameter("valid");i.data("__mandatoryEmpty",null);if(R){i.setValueState(B.None);i.setValueStateText();}else{var W=i._parseValue(Q.getParameter("newValue")),X=this._getSelectedDateRange(W);i.setValueState(B.Error);if(X[0]&&X[1]){var Y=sap.ui.getCore().getLibraryResourceBundle("sap.ui.comp"),Z=this._getDateFieldOutOfRangeErrorText(i,X,j,Y);i.setValueStateText(Z);}else if(j){try{j.parseValue("foo","string");}catch($){i.setValueStateText($.message);}}}}.bind(this));}if(e.hasTypeAhead){i.setShowSuggestion(true);i.setFilterSuggests(false);this._associateValueList(i,"suggestionRows",e,true);}if((e.displayFormat==="UpperCase")&&(e.controlType!==y.dropDownList)&&i.attachChange&&i.getValue&&i.setValue){i.attachChange(function(Q){var R=i.getValue();if(R){i.setValue(R.toUpperCase());}});if(this._mTokenHandler[i.getId()]&&this._mTokenHandler[i.getId()].parser){var P=this._mTokenHandler[i.getId()].parser;P.getKeyFields()[0].displayFormat=e.displayFormat;}}if(i instanceof d){if(e.maxLength){n=parseInt(e.maxLength);if(!isNaN(n)){if(this._mTokenHandler[i.getId()]&&this._mTokenHandler[i.getId()].parser){var P=this._mTokenHandler[i.getId()].parser;P.getKeyFields()[0].maxLength=n;}else{if(!e.hasValueListAnnotation&&!k){i.setMaxLength(n);}}}}}N=function(Q){var R=Q.getParameter("exception");var W=Q.getParameter("element");if(i&&W&&(i.getId()===W.getId())){if(R){if(i.setValueStateText){i.setValueStateText(R.message);}}if(i.setValueState){i.setValueState(B.Error);}i.data("__mandatoryEmpty",null);}};i.attachParseError(N);i.attachFormatError(N);i.attachValidationError(N);i.attachValidationSuccess(function(Q){var R=Q.getParameter("element");if(i&&R&&(i.getId()===R.getId())){if(i.setValueState){i.setValueState(B.None);}if(i.setValueStateText){i.setValueStateText();}i.data("__mandatoryEmpty",null);delete i.__sValidationText;}});return i;};K.prototype._getControlConstructor=function(e,P){var i=d,j,k,n;n=P?P+e.fieldName:e.fieldName;if(e.isCustomFilterField){i=undefined;}else{j=(e.filterRestriction===A.single);k=(e.filterRestriction===A.interval);if(e.controlType===y.date){if(j){i=b;}else{i=k?c:f;}if(e.isCalendarDate){this._aFilterBarStringDateFieldNames.push(n);}else{this._aFilterBarDateFieldNames.push(n);}if(e.filterRestriction===A.multiple){this._aFilterBarDateTimeMultiValueFieldNames.push(n);}}else if(e.controlType===y.dropDownList){if(j){i=this._isBooleanWithFixedValuedButWithoutValueListAnnotation(e)?S:C;}else{i=M;}if(!j){e.filterRestriction=A.multiple;}}else if(e.type==="Edm.Time"){if(j){i=T;}else{i=f;}this._aFilterBarTimeFieldNames.push(n);if(k){this._aFilterBarTimeIntervalFieldNames.push(n);}else if(e.filterRestriction===A.multiple){this._aFilterBarDateTimeMultiValueFieldNames.push(n);}}else if(!k&&e.controlType===y.dateTimePicker){if(j){i=a;}else{i=f;}this._aFilterBarDateTimeFieldNames.push(n);if(e.filterRestriction===A.multiple){this._aFilterBarDateTimeMultiValueFieldNames.push(n);}}else if(k&&e.type==="Edm.DateTimeOffset"){this._aFilterBarDateTimeFieldNames.push(n);}else if(!j&&!k){i=f;}}return i;};K.prototype._handleTokenUpdate=function(e,i){this._tokenUpdate({control:i.control,fieldViewMetadata:i.fieldViewMetadata,removedTokens:e&&e.getParameter("removedTokens")});};K.prototype._tokenUpdate=function(e){var R=e.removedTokens,i=e.control,j=e.fieldViewMetadata,k,n=[],N,P,Q,W=[],X="/"+j.fieldName;if(this._bUpdatingFilterData||this._bCreatingInitialModel){return;}k=i.getTokens();if(R){k=k.filter(function(P){return R.indexOf(P)===-1;});}if(Array.isArray(k)&&k.length>0){N=k.length;while(N--){P=k[N];Q=P.data("range");if(Q){Q.tokenText=P.getText();if(Q&&(P.getKey().indexOf("range_")===0)){if(j.type==="Edm.Time"){if(Q.value1&&(Q.value1.ms||Q.value1.ms===0)){Q.value1=D.utcToLocal(new Date(Q.value1.ms));}if(Q.value2&&(Q.value2.ms||Q.value2.ms===0)){Q.value2=D.utcToLocal(new Date(Q.value2.ms));}}}W.push(Q);}else{n.push({key:P.getKey(),text:P.getText()});}}}if(this.oModel){this.oModel.setProperty(X+"/items",n);this.oModel.setProperty(X+"/ranges",W);}if(i.__bValidatingToken){delete i.__bValidatingToken;}if(!i._pendingAutoTokenGeneration){i.fireChange({filterChangeReason:j.fieldName,value:""});}};K.prototype._handleMultiInput=function(e,i,j){e._setFilterProvider(this);e._setFieldViewMetadata(i);e.attachTokenUpdate({control:e,fieldViewMetadata:i},this._handleTokenUpdate,this);var k,n=((i.type==="Edm.DateTime"&&i.displayFormat==="Date"));if(i.hasValueListAnnotation||(i.type==="Edm.String")||n){e.attachEvent("_validateOnPaste",function(N){var P=N.getParameter("texts"),Q,R,W,X,Y;R=P?P.length:0;if(R>1){N.preventDefault();Q=this.oModel.getProperty("/"+i.fieldName);Y=Q.ranges||[];e.setValue("");while(R--){W=P[R];if(W){X=null;if(n){k=this._getDateValue(W,j);if(isNaN(k.getDate())){continue;}else{X=W;W=k;}}Y.push({"exclude":false,"operation":"EQ","keyField":i.fieldName,"value1":W,"value2":null,"tokenText":X});}}this.oModel.setProperty("/"+i.fieldName+"/ranges",Y);this._updateMultiValueControl(e,Q.items,Y,i);}}.bind(this));}};K.prototype._associateValueHelpDialog=function(e,i,j,k){var P={fieldName:i.fieldName,control:e,model:this._oParentODataModel,filterModel:this.oModel,filterProvider:this,dateFormatSettings:this._oDateFormatSettings,fieldViewMetadata:i,displayFormat:i.displayFormat,displayBehaviour:i.displayBehaviour,loadAnnotation:i.hasValueListAnnotation,fullyQualifiedFieldName:i.fullName,metadataAnalyser:this._oMetadataAnalyser,preventInitialDataFetchInValueHelpDialog:i.preventInitialDataFetchInValueHelpDialog,supportMultiSelect:k,supportRanges:j,isSingleIntervalRange:i.filterRestriction===A.interval,isUnrestrictedFilter:i.filterRestriction!==A.multiple,type:i.filterType,maxLength:i.maxLength,scale:i.scale,precision:i.precision};if(i.isCalendarDate){P.oType=this._getType(i);}var n=new V(P);n.attachValueListChanged(function(Q){if(this._oSmartFilter){this._oSmartFilter.fireFilterChange(Q);this._oSmartFilter.validateMandatoryFields();}}.bind(this));if(i.visibleInAdvancedArea||(i.groupId===K.BASIC_FILTER_AREA_ID)){n.loadAnnotation();}this._aValueHelpDialogProvider.push(n);if(j&&e.addValidator){var N=new q();N.addKeyField({key:i.fieldName,label:i.label,type:i.filterType,oType:i.ui5Type});if(i.filterType==="numeric"){N.setDefaultOperation("EQ");}N.associateInput(e);this._mTokenHandler[e.getId()]={parser:N};}};K.prototype._determineFieldLabel=function(e){var i,j=e.label;if(this._oSmartFilter&&this._oSmartFilter.determineFilterItemByName){i=this._oSmartFilter.determineFilterItemByName(e.name);if(i){j=i.getLabel();}}return j;};K.prototype._associateValueList=function(e,i,j,k){var n;if(this._oSmartFilter&&!this._bAttachInitializedDone&&new U(window.location.href).get("sap-ui-comp-filterbar-data-defer")){var P=this._oParentODataModel;this._sDeferredGroupId="sapUiCompFilterBarData";var N=P.getDeferredGroups?this._oParentODataModel.getDeferredGroups():null;if(N!==null){N.push(this._sDeferredGroupId);P.setDeferredGroups(N);var Q=function(){P.submitChanges({groupId:this._sDeferredGroupId});var N=P.getDeferredGroups().filter(function(R){return R!==this._sDeferredGroupId;}.bind(this));P.setDeferredGroups(N);delete this._sDeferredGroupId;this._oSmartFilter.detachInitialized(Q);}.bind(this);this._oSmartFilter.attachInitialized(Q);this._bAttachInitializedDone=true;}}if(j.hasValueListAnnotation){n=new m({fieldName:j.fieldName,control:e,model:this._oParentODataModel,filterModel:this.oModel,filterProvider:this,displayFormat:j.displayFormat,dateFormatSettings:this._oDateFormatSettings,fieldViewMetadata:j,displayBehaviour:j.displayBehaviour,loadAnnotation:true,fullyQualifiedFieldName:j.fullName,metadataAnalyser:this._oMetadataAnalyser,type:j.filterType,aggregation:i,typeAheadEnabled:k,deferredGroupId:this._sDeferredGroupId,context:"SmartFilterBar"});n.attachValueListChanged(function(R){if(this._oSmartFilter){this._oSmartFilter.fireFilterChange(R);this._oSmartFilter.validateMandatoryFields();}}.bind(this));if(j.visibleInAdvancedArea||(j.groupId===K.BASIC_FILTER_AREA_ID)){n.loadAnnotation();}this._aValueListProvider.push(n);}else if(this._mTokenHandler[e.getId()]&&this._mTokenHandler[e.getId()].parser){this._mTokenHandler[e.getId()].parser.setDefaultOperation("EQ");}};K.prototype._createAnalyticParameters=function(P){var e,i;if(P){i=P.getAllParameterNames();e=P.getEntitySet();if(e){this._createParametersByEntitySetName(e.getQName(),i);}}};K.prototype._createParametersByEntitySetName=function(e,P){var j,k=this._oMetadataAnalyser.getFieldsByEntitySetName(e);for(var i=0;i<k.length;i++){if(P.indexOf(k[i].name)>=0){j=this._createAnalyticParameterMetadata(k[i]);if(j&&j.visible){if(this._oNonAnaParameterization&&j.isCustomFilterField){continue;}this._aAnalyticalParameters.push(j);}}}};K.prototype._createAnalyticParameterMetadata=function(P){var e,i=s.ANALYTICAL_PARAMETER_PREFIX,j=function(e){return e.type==="Edm.String"&&e["sap:parameter"]==="optional";};P.filterRestriction="single-value";e=this._createFieldMetadata(P,i);if(e){e.fieldName=i+P.name;e.isMandatory=j(e)?false:true;e.isParameter=true;e.visibleInAdvancedArea=true;}else{L.error("_createAnalyticParameterMetadata issue with property: "+P.name);}return e;};K.prototype.getAnalyticParameters=function(){return this._aAnalyticalParameters;};K.prototype.getSelectionVariants=function(){return this._aSelectionVariants;};K.prototype.getAnalyticBindingPath=function(){var e,P=[],i=this.getAnalyticParameters();i.forEach(function(j){P.push(j.fieldName);});e=this.getFilledFilterData(P);if(this._oParameterization){return this._createAnalyticBindingPath(i,e);}else{return this._createNonAnalyticBindingPath(i,e);}};K.prototype._createAnalyticBindingPath=function(P,e){var i,j="",k;k=this._getParameterizationRequest(this._oParameterization);if(k){P.forEach(function(n){i=e[n.fieldName];if(!i){i="";}else if(n.type==="Edm.Time"&&i instanceof Date){if(this._oDateFormatSettings&&!this._oDateFormatSettings.UTC){i=D.utcToLocal(i);}i=D.localToUtc(i);i={__edmType:"Edm.Time",ms:i.valueOf()};}else if((n.type!=="Edm.DateTimeOffset")&&this._oDateFormatSettings&&this._oDateFormatSettings.UTC&&i instanceof Date){i=D.localToUtc(i);}k.setParameterValue(n.name,i);}.bind(this));j=k.getURIToParameterizationEntry()+'/'+this._oParameterization.getNavigationPropertyToQueryResult();}return j;};K.prototype._createNonAnalyticBindingPath=function(P,e){var i,j="",k="";if(this._oNonAnaParameterization){j="/"+this._oNonAnaParameterization.entitySetName+'(';P.forEach(function(n){i=e[n.fieldName];if(!i){i="";}else if(n.type==="Edm.Time"&&i instanceof Date){i=D.localToUtc(i);i={__edmType:"Edm.Time",ms:i.valueOf()};}else if((n.type!=="Edm.DateTimeOffset")&&this._oDateFormatSettings&&this._oDateFormatSettings.UTC&&i instanceof Date){i=D.localToUtc(i);}j+=(k+n.name+"="+w(this._oParentODataModel.formatValue(i,n.type)));k=",";}.bind(this));j+=(")/"+this._oNonAnaParameterization.navPropertyName);}return j;};K.prototype._getParameterizationRequest=function(){return this._oParameterization?new u.ParameterizationRequest(this._oParameterization):null;};K.prototype._constructContextUrl=function(e,i){var j=e._getServerUrl();if(j&&(j.lastIndexOf('/')===(j.length-1))){j=j.substr(0,j.length-1);}return j+e.sServiceUrl+"/$metadata#"+i;};K.prototype.getFilterContextUrl=function(){var e,i=null;if(this._oParentODataModel&&this._oParentODataModel.isA("sap.ui.model.odata.v2.ODataModel")&&this._oParentODataModel.getMetaModel()){e=this._oParentODataModel.getMetaModel().getODataEntitySet(this.sEntitySet);if(e){i=this._constructContextUrl(this._oParentODataModel,e.name);}}return i;};K.prototype.getParameterContextUrl=function(){var e,i=null;if(this._oParentODataModel&&this._oParentODataModel.isA("sap.ui.model.odata.v2.ODataModel")&&this._oParentODataModel.getMetaModel()){if(this._oParameterization&&this._oParameterization.getEntitySet()){e=this._oParameterization.getEntitySet().getQName();}else if(this._oNonAnaParameterization){e=this._oNonAnaParameterization.entitySetName;}if(e){i=this._constructContextUrl(this._oParentODataModel,e);}}return i;};K.prototype._createFieldMetadata=function(e,P){var i,j,k;e.fieldName=this._getFieldName(e);e.fieldNameOData=e.fieldName.replace(K.FIELD_NAME_REGEX,"/");j=this._oAdditionalConfiguration?this._oAdditionalConfiguration.getControlConfigurationByKey(e.fieldName):null;i=Object.assign({},e);i.filterRestriction=this._getFilterRestriction(e,j);this._updateValueListMetadata(i,e);i.hasValueHelpDialog=this._hasValueHelpDialog(i,j);i.preventInitialDataFetchInValueHelpDialog=j?j.preventInitialDataFetchInValueHelpDialog:true;i.controlType=this._getControlType(i,j);if(j&&j.displayBehaviour&&j.displayBehaviour!=="auto"){i.displayBehaviour=j.displayBehaviour;}i.isCustomFilterField=!!(j&&j.customControl);i.visibleInAdvancedArea=!!(j&&j.visibleInAdvancedArea);i.label=this._getLabel(e,j);i.isMandatory=this._isMandatory(e,j);i.width=this._getWidth(j);i.isVisible=this._isVisible(j);i.groupId=this._getGroupID(e,j);i.index=this._getIndex(e,j);i.fControlConstructor=this._getControlConstructor(i,P);i.filterType=this._getFilterType(i);i.hasTypeAhead=this._hasTypeAhead(i,e,j);i.customControl=j?j.customControl:undefined;i.ui5Type=this._getType(i);if(i.ui5Type&&i.ui5Type.isA("sap.ui.model.odata.type.DateTime")){i.ui5Type.formatValue(new Date(),"string");i.ui5Type.oFormat.oFormatOptions.UTC=false;}i.fCreateControl=function(W){var X,Y;W.control=this._createControl(W);X=this.oModel.getData();Y=X[W.fieldName];if(Y){this._updateMultiValueControl(W.control,Y.items,Y.ranges,W);}}.bind(this);this._applyWidth(i);i.defaultFilterValues=j?j.defaultFilterValues:undefined;if(i.type==="Edm.String"){this._aFilterBarStringFieldNames.push(i.fieldName);}i.conditionType=null;var n=j?j.conditionType:null;if(!n&&this._bUseDateRangeType&&(i.fControlConstructor===c)){n="sap.ui.comp.config.condition.DateRangeType";}if(n){var N="";if(typeof n==="object"){N=n.module;delete n.module;}else{N=n;n=null;}try{N=N.replace(/\./g,"/");var Q=sap.ui.require(N);if(Q){this._enhanceConditionTypeInfo(Q,N,n,i);}else{k=new Promise(function(W){sap.ui.require([N],function(Q){this._enhanceConditionTypeInfo(Q,N,n,i);W();}.bind(this));}.bind(this));this._aPromises.push(k);}}catch(R){L.error("Module "+N+" could not be loaded");}}else{this._checkMetadataDefaultValue(i);}return i;};K.prototype._requireConditionType=function(e,i,j){var e=e.replace(/\./g,"/");var k=sap.ui.require(e);if(k){this._enhanceConditionTypeInfo(k,e,i,j);}else{sap.ui.require([e],function(k){this._enhanceConditionTypeInfo(k,e,i,j);}.bind(this));}};K.prototype._enhanceConditionTypeInfo=function(e,i,j,k){var n=e;k.conditionType=new n(k.fieldName,this,k);this._mConditionTypeFields[k.fieldName]=k;if(j&&!this._bUseDateRangeType){k.conditionType.applySettings(j);}this._checkMetadataDefaultValue(k);};K.prototype._getFilterType=function(e){return o._getFilterType(e);};K.prototype._updateValueListMetadata=function(e,i){e.hasValueListAnnotation=i["sap:value-list"]!==undefined;if(e.hasValueListAnnotation){e.hasFixedValues=i["sap:value-list"]==="fixed-values";}else if(i["com.sap.vocabularies.Common.v1.ValueList"]){e.hasValueListAnnotation=true;e.hasFixedValues=this._oMetadataAnalyser.getValueListSemantics(i["com.sap.vocabularies.Common.v1.ValueList"])==="fixed-values";if(!e.hasFixedValues){e.hasFixedValues=l.isValueListWithFixedValues(i);}}};K.prototype._createBasicSearchFieldMetadata=function(){var e;var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.comp");e={};e.filterRestriction=A.single;e.name=K.BASIC_SEARCH_FIELD_ID;e.fieldName=K.BASIC_SEARCH_FIELD_ID;e.label=undefined;e.isMandatory=false;e.isVisible=true;e.groupId=K.BASIC_FILTER_AREA_ID;e.index=-1;e.control=new g(this._oSmartFilter.getId()+"-btnBasicSearch",{showSearchButton:true});if(!this._isRunningInValueHelpDialog){e.control.setPlaceholder(R.getText("FILTER_BAR_BSEARCH_PLACE_HOLDER"));}e.control.bindProperty('value',this.sFilterModelName+">/"+e.fieldName);this._oBasicSearchControl=e.control;return e;};K.prototype._applyWidth=function(e){if(e&&e.width&&e.control&&e.control.setWidth&&(typeof e.control.setWidth==='function')){e.control.setWidth(e.width);}};K.prototype._createFieldMetadataForCustomFilterFields=function(e){var i;if(!e||!e.customControl){return undefined;}i={};i.name=e.key;i.fieldName=e.key;i.label=e.label;i.visibleInAdvancedArea=!!(e&&e.visibleInAdvancedArea);i.isVisible=this._isVisible(e);i.groupId=e.groupId;i.isMandatory=this._isMandatory(undefined,e);i.index=e.index;i.width=this._getWidth(e);i.control=e.customControl;i.isCustomFilterField=true;this._applyWidth(i);return i;};K.prototype._getFieldName=function(e){if(!e.parentPropertyName){return e.name;}else{return e.parentPropertyName+"."+e.name;}};K.prototype._hasValueHelpDialog=function(e,i){var j=true;if(i){if(i.controlType===y.dropDownList){j=false;}else if(i.hasValueHelpDialog!==true){j=false;}}if(e&&!e.hasValueListAnnotation){if(e.filterRestriction===A.single||e.filterRestriction===A.multiple){j=false;}}return j;};K.prototype._isVisible=function(e){if(e&&e.isVisible===false){return false;}return true;};K.prototype._getWidth=function(e){if(e&&e.width){return e.width;}return undefined;};K.prototype._isMandatory=function(e,i){if(i&&i.mandatory!==H.auto){return i.mandatory===H.mandatory;}if(e){return e.requiredFilterField;}return false;};K.prototype._getFilterRestriction=function(e,i){var j;if(i&&i.filterType&&i.filterType!==A.auto){j=i.filterType;}else if(e.filterRestriction==="single-value"){j=A.single;}else if(e.filterRestriction==="multi-value"){j=A.multiple;}else if(e.filterRestriction==="interval"){j=A.interval;}else{j=A.auto;}return j;};K.prototype._getControlType=function(e,i){var j;if(i&&i.controlType&&i.controlType!==y.auto){j=i.controlType;}else if(e.type==="Edm.DateTime"&&e.displayFormat==="Date"||e.isCalendarDate){j=y.date;}else if(e.type==="Edm.DateTimeOffset"){j=y.dateTimePicker;}else if(e.hasValueListAnnotation&&e.hasFixedValues){j=y.dropDownList;}else if(this._isBooleanWithFixedValuedButWithoutValueListAnnotation(e)){j=y.dropDownList;}else{j=y.input;}return j;};K.prototype._isBooleanWithFixedValuedButWithoutValueListAnnotation=function(e){if(e.type==="Edm.Boolean"&&!e.hasFixedValues&&!e.hasValueListAnnotation&&(e.filterRestriction==="single")){return true;}return false;};K.prototype._getGroupID=function(e,i){if(i&&i.groupId){return i.groupId;}else if(e&&(e.requiredFilterField||(this._aSelectionFields&&this._aSelectionFields.indexOf(e.fieldNameOData)>-1))){return this._sBasicFilterAreaID;}return this._getGroupIDFromFieldGroup(e);};K.prototype._getGroupIDFromFieldGroup=function(e){var i=0,j=null,k;if(e&&this._aFieldGroupAnnotation&&this._aFieldGroupAnnotation.length){i=this._aFieldGroupAnnotation.length;while(i--){j=this._aFieldGroupAnnotation[i];if(j&&j.fields&&j.fields.indexOf(e.fieldNameOData)>-1){k=j.groupName;break;}}}return k;};K.prototype._getLabel=function(e,i){if(i&&i.label){return i.label;}return this._getLabelFromFieldGroup(e)||e.fieldLabel||e.fieldName;};K.prototype._getLabelFromFieldGroup=function(e){var i=0,j=null,k;if(e&&this._aFieldGroupAnnotation&&this._aFieldGroupAnnotation.length){i=this._aFieldGroupAnnotation.length;while(i--){j=this._aFieldGroupAnnotation[i];if(j&&j.fields&&j.fields.indexOf(e.fieldNameOData)>-1){k=j.labels[e.fieldNameOData];break;}}}return k;};K.prototype._getIndex=function(e,i){if(i&&(i.index>=0)){return i.index;}else if(this._aSelectionFields&&this._aSelectionFields.indexOf(e.fieldNameOData)>-1){return this._aSelectionFields.indexOf(e.fieldNameOData);}return this._getIndexFromFieldGroup(e);};K.prototype._getIndexFromFieldGroup=function(e){var i=0,j=null,k;if(e&&this._aFieldGroupAnnotation&&this._aFieldGroupAnnotation.length){i=this._aFieldGroupAnnotation.length;while(i--){j=this._aFieldGroupAnnotation[i];if(j&&j.fields){k=j.fields.indexOf(e.fieldNameOData);if(k>-1){break;}k=undefined;}}}return k;};K.prototype._getGroupIndex=function(e){if(e&&(e.index||e.index===0)){return e.index;}};K.prototype._getGroupLabel=function(e,i){if(i&&i.label){return i.label;}return e.groupLabel||e.groupName||e.groupEntitySetName;};K.prototype._hasTypeAhead=function(e,i,j){var k;k=true;if(j){k=j.hasTypeAhead;}else if(i.type!=="Edm.String"){return false;}if(!(e.fControlConstructor===d||e.fControlConstructor===f)){return false;}return k;};K.prototype.getModel=function(){return this.oModel;};K.prototype.getFilterBarViewMetadata=function(){return this._aFilterBarViewMetadata;};K.prototype.getAssociatedValueHelpProviders=function(){return this._aValueHelpDialogProvider;};K.prototype.getAssociatedValueListProviders=function(){return this._aValueListProvider;};K.prototype.getParameters=function(){var P,e=null;if(this.oModel){e=this.oModel.getProperty("/"+K.BASIC_SEARCH_FIELD_ID);}if(this._sBasicSearchFieldName||e){P={custom:{}};if(this._sBasicSearchFieldName){P.custom["search-focus"]=this._sBasicSearchFieldName;}P.custom["search"]=e||"";}return P;};K.prototype.getFilters=function(e){var i=null;if(this.oModel){i=this.oModel.getData();}return K.generateFilters(e,i,{dateSettings:this._oDateFormatSettings,useContainsAsDefault:this._bUseContainsAsDefault,stringFields:this._aFilterBarStringFieldNames,timeFields:this._aFilterBarTimeFieldNames,dateTimeOffsetValueFields:this._aFilterBarDateTimeFieldNames,viewMetadataData:this._aFilterBarViewMetadata});};K.prototype.getFilterData=function(){return this.oModel?this.oModel.getData():null;};K.prototype.getFilterDataAsString=function(){return this.oModel?this.oModel.getJSON():null;};K.prototype.getFilledFilterData=function(e){var i,j={},k,n,N;i=this.oModel?this.oModel.getData():null;if(i&&e){k=e.length;while(k--){n=e[k];if(n&&n!==K.BASIC_SEARCH_FIELD_ID){N=i[n];if(N&&N.hasOwnProperty("low")){if(N.low){j[n]=N;}}else if(N&&N.hasOwnProperty("items")){if(N.value&&typeof N.value==="string"){N.value=N.value.trim();}if(N.items.length||(N.ranges&&N.ranges.length)||N.value||(typeof N.value==="boolean")){j[n]=N;}}else if(N){if(typeof N==="string"){N=N.trim();}if(N){j[n]=N;}}}if(k===0){n=K.CUSTOM_FIELDS_MODEL_PROPERTY;N=i[n];if(N){j[n]=N;}}}}return x({},j);};K.prototype.getFilledFilterDataAsString=function(e){return JSON.stringify(this.getFilledFilterData(e));};K.prototype.setFilterData=function(j,R){var e=null,i=null,k=null;if(this.oModel&&j){this._bUpdatingFilterData=true;try{if(R){this._createInitialModel(false);}e=this._parseFilterData(j,R);if(e){this.oModel.setData(e,true);i=[];var n=arguments[2];if(n){i.push(n);}for(k in e){i.push(k);}this._handleFilterDataUpdate(i);}}finally{this._bUpdatingFilterData=false;}}};K.prototype.setFilterDataAsString=function(j,R){if(j){this.setFilterData(JSON.parse(j),R);}};K.prototype._parseFilterData=function(j,R){return K.parseFilterData(this.oModel.getData(),j,{stringDateFields:this._aFilterBarStringDateFieldNames,dateFields:this._aFilterBarDateFieldNames,timeFields:this._aFilterBarTimeFieldNames,timeIntervalFields:this._aFilterBarTimeIntervalFieldNames,dateTimeMultiValueFields:this._aFilterBarDateTimeMultiValueFieldNames,conditionTypeFields:this._mConditionTypeFields,dateTimeOffsetValueFields:this._aFilterBarDateTimeFieldNames,viewMetadataData:this._aFilterBarViewMetadata,filterProvider:this},R);};K.prototype._handleFilterDataUpdate=function(e){var i=0,j,k,n;if(this._aFilterBarMultiValueFieldMetadata){i=this._aFilterBarMultiValueFieldMetadata.length;while(i--){if(!k){k=this.oModel.getData();}if(k){j=this._aFilterBarMultiValueFieldMetadata[i];if(e.indexOf(j.fieldName)>-1){n=k[j.fieldName];if(n){this._updateMultiValueControl(j.control,n.items,n.ranges,j);}}}}this._updateConditionTypeFields();}};K.prototype.clear=function(){this._createInitialModel(false);};K.prototype.reset=function(){this._createInitialModel(true);};K.prototype._initializeConditionTypeFields=function(){var e=function(i){this.setPending(this.isPending());}.bind(this);for(var n in this._mConditionTypeFields){this._mConditionTypeFields[n].conditionType.initialize(this.oModel.getData()[n]);if(this._mConditionTypeFields[n].conditionType.getAsync()){this._mConditionTypeFields[n].conditionType.attachPendingChange(e);}}};K.prototype._updateConditionTypeFields=function(){var e=this._oldData;var i=this.oModel.getData();this._oldData=x({},i);if(e!==undefined){var j=[],n;for(n in i){var N=JSON.stringify(i[n]);var k=JSON.stringify(e[n]);if(N!==k){j.push(n);}}if(j.length>0){for(n in this._mConditionTypeFields){this._mConditionTypeFields[n].conditionType.providerDataUpdated(j,i);}}}};K.prototype._clearConditionTypeFields=function(){var e=this.oModel.getData();for(var n in this._mConditionTypeFields){this._mConditionTypeFields[n].conditionType.initialize(e[n]);}};K.prototype._validateConditionTypeFields=function(){var i=false;for(var n in this._mConditionTypeFields){var e=this._mConditionTypeFields[n].conditionType.validate();if(!e&&!i){i=true;}}return i;};K.prototype._getFieldMetadata=function(e){return K._getFieldMetadata(this.getFilterBarViewMetadata(),e);};K._getFieldMetadata=function(e,i){var j=null;e.some(function(k){if(k&&k.fields){k.fields.some(function(n){if(n&&n.fieldName===i){j=n;}return j!==null;});}return j!==null;});return j;};K.prototype._getSelectedDateRange=function(e){if(!Array.isArray(e)){e=[e,e];}return e;};K.prototype._getDateFieldOutOfRangeErrorText=function(e,i,j,R){var k=e.getMinDate()||e._oMinDate,n=e.getMaxDate()||e._oMaxDate;if(i[0].getTime()<k.getTime()){return R.getText("FILTER_BAR_DATE_FIELD_MIN_DATE_ERROR",[j.formatValue(k,"string")]);}if(i[1].getTime()>n.getTime()){return R.getText("FILTER_BAR_DATE_FIELD_MAX_DATE_ERROR",[j.formatValue(n,"string")]);}};K.generateFilters=function(e,i,j){var k=[],n=null,N=null,P=null,Q=null,R=K.FIELD_NAME_REGEX,W=null,X,Y,Z=null,$=0,_=0;var a1,b1,c1,d1,e1,f1,g1,h1,i1,j1=[];if(j){a1=j.dateSettings;b1=j.useContainsAsDefault;c1=j.stringFields;d1=j.timeFields;g1=j.dateTimeOffsetValueFields;j1=j.viewMetadataData||[];}if(e&&i){_=e.length;while(_--){f1=false;h1=false;Q=e[_];i1=K._getFieldMetadata(j1,Q);if(Q&&Q!==K.BASIC_SEARCH_FIELD_ID){Z=null;e1=false;if(b1&&c1){if(c1.indexOf(Q)>-1){e1=true;}}else if(d1&&d1.indexOf(Q)>-1){f1=true;}else if(g1&&g1.indexOf(Q)>-1){h1=true;}W=i[Q];Q=Q.replace(R,"/");if(W&&W.hasOwnProperty("low")){if(W.low&&W.high){X=W.low;Y=W.high;if(!h1&&a1&&a1.UTC&&X instanceof Date&&Y instanceof Date){X=D.localToUtc(X);Y=D.localToUtc(Y);}X=K.adaptTime(X,i1);Y=K.adaptTime(Y,i1);k.push(new F(Q,v.BT,X,Y));}else if(W.low){if(W.low instanceof Date){X=W.low;if(!h1&&a1&&a1.UTC){X=D.localToUtc(X);}X=K.adaptTime(X,i1);k.push(new F(Q,v.EQ,X));}else if(typeof W.low==="string"){if(h1&&i1){Z=o.parseDateTimeOffsetInterval(W.low);Z[0]=i1.ui5Type.parseValue(Z[0],"string");if(Z.length===2){Z[1]=i1.ui5Type.parseValue(Z[1],"string");}}else{Z=o.parseFilterNumericIntervalData(W.low);}if(Z&&Z.length===2){W[0]=K.adaptTime(W[0],i1);W[1]=K.adaptTime(W[1],i1);k.push(new F(Q,v.BT,Z[0],Z[1]));}else if(Z&&Z.length===1){W[0]=K.adaptTime(W[0],i1);k.push(new F(Q,v.EQ,Z[0]));}else{k.push(new F(Q,e1?v.Contains:v.EQ,W.low));}}}}else if(W&&W.hasOwnProperty("items")){n=[];P=[];N=null;if(W&&W.hasOwnProperty("ranges")){Z=W.ranges;$=Z.length;while($--){X=Z[$].value1;Y=Z[$].value2;if(f1){if(X instanceof Date){X=o.getEdmTimeFromDate(X);}if(Y instanceof Date){Y=o.getEdmTimeFromDate(Y);}}else if(i1&&i1.isCalendarDate){if(X instanceof Date){X=i1.ui5Type.parseValue(X);}if(Y instanceof Date){Y=i1.ui5Type.parseValue(Y);}}else if(!h1&&a1&&a1.UTC){if(X instanceof Date){X=D.localToUtc(X);}if(Y instanceof Date){Y=D.localToUtc(Y);}}X=K.adaptTime(X,i1);Y=K.adaptTime(Y,i1);if(Z[$].exclude){if(Z[$].operation===G.Empty){P.push(K._getStringEmptyFilter(Q,i1,true));}else if(Z[$].operation===v.EQ){P.push(new F(Q,v.NE,X));}}else{if(Z[$].operation===G.Empty){n.push(K._getStringEmptyFilter(Q,i1));}else if(Z[$].operation===sap.ui.model.FilterOperator.BT){n.push(new F(Q,Z[$].operation,X,Y));}else{n.push(new F(Q,Z[$].operation,X));}}}if(P.length){N=new F(P,true);}}Z=W.items;$=Z.length;while($--){n.push(new F(Q,v.EQ,Z[$].key));}if(W.value||W.value===0||W.value===false){if(typeof W.value==="string"){W.value=W.value.trim();}n.push(new F(Q,e1?v.Contains:v.EQ,W.value));}if(n.length){if(N){k.push(new F([new F(n,false),N],true));}else{k.push(new F(n,false));}}else if(N){k.push(N);}}else if(W||W===0||W===false){if(typeof W==="string"){W=W.trim();}if(W&&W instanceof Date){if(f1){W=o.getEdmTimeFromDate(W);}else if(!h1&&a1&&a1.UTC){W=D.localToUtc(W);}}if(W||W===0||W===false){W=K.adaptTime(W,i1);k.push(new F(Q,e1?v.Contains:v.EQ,W));}}}}}return(k.length>1)?[new F(k,true)]:k;};K._getStringEmptyFilter=function(e,i,j){var k=j?v.NE:v.EQ;if(i&&i.nullable==="false"){return new F(e,k,"");}else{return new F({and:!!j,filters:[new F(e,k,""),new F(e,k,null)]});}};K.parseFilterData=function(e,j,k,R){var n={},N=null,P=null,Q=null,W,X,i,Y,Z,$,_,a1,b1,c1,d1,e1,f1,g1;if(k){$=k.stringDateFields;_=k.dateFields;a1=k.timeFields;b1=k.timeIntervalFields;c1=k.dateTimeMultiValueFields;N=k.conditionTypeFields||{};d1=k.dateTimeOffsetValueFields;e1=k.viewMetadataData||[];g1=k.filterProvider||null;}if(!$){$=[];}if(!_){_=[];}if(!a1){a1=[];}if(!b1){b1=[];}if(!c1){c1=[];}if(!d1){d1=[];}if(e&&j){X=Object.assign({},j,true);for(P in X){f1=K._getFieldMetadata(e1,P);if(e.hasOwnProperty(P)&&P!==K.CUSTOM_FIELDS_MODEL_PROPERTY){Q=e[P];W=X[P];if(P in N){if(W&&(("conditionTypeInfo"in W)||(!("conditionTypeInfo"in W)&&W.ranges))){N[P].conditionType.initialize(W);}}else if(Q&&Q.hasOwnProperty("low")){n[P]=W;if(W){if((W.low||W.low===0)&&(W.high||W.high===0)){if((_.indexOf(P)>-1)||(a1.indexOf(P)>-1)){if(!(W.low instanceof Date)){n[P].low=new Date(W.low);}if(!(W.high instanceof Date)){n[P].high=new Date(W.high);}}else if(g1&&f1&&(d1.indexOf(P)>-1)){n[P].low=f1.ui5Type.formatValue(W.low,"string")+'-'+f1.ui5Type.formatValue(W.high,"string");n[P].high=null;}else if($.indexOf(P)===-1){n[P].low=W.low+'-'+W.high;n[P].high=null;}}else if((W.low||(W.low===0)||W.value)&&!W.high){if(!W.low&&W.value){W.low=W.value;}if(((_.indexOf(P)>-1)||(a1.indexOf(P)>-1)||(d1.indexOf(P)>-1))&&!(W.low instanceof Date)){n[P].low=new Date(W.low);}else{n[P].low=W.low;}n[P].high=null;}}}else if(Q&&Q.hasOwnProperty("items")){if(W&&(W.items||W.ranges)){if(W.ranges&&W.ranges.length){if(b1.indexOf(P)>-1){Y=W.ranges.length;for(i=0;i<Y;i++){Z=W.ranges[i];if(!Z.exclude&&(Z.operation==="EQ"||Z.operation==="BT")){break;}Z=null;}if(Z){if(Z.value1&&typeof Z.value1==="string"){Z.value1=new Date(Z.value1);}if(Z.value2&&typeof Z.value2==="string"){Z.value2=new Date(Z.value2);}n[P]={ranges:[Z],items:[],value:""};}continue;}else if(_.indexOf(P)>-1||a1.indexOf(P)>-1||d1.indexOf(P)>-1){Y=W.ranges.length;for(i=0;i<Y;i++){Z=W.ranges[i];if(Z.value1&&typeof Z.value1==="string"){Z.value1=new Date(Z.value1);}if(Z.value2&&typeof Z.value2==="string"){Z.value2=new Date(Z.value2);}}}else if(f1&&f1.isCalendarDate){Y=W.ranges.length;for(i=0;i<Y;i++){Z=W.ranges[i];if(Z.value1&&(typeof Z.value1==="string")&&!Z.value1.match(/([1-9][0-9]{3,}|0[0-9]{3})(0[1-9]|1[0-2])(0[1-9]|[12][0-9]|3[01])/)){Z.value1=f1.ui5Type.parseValue(new Date(Z.value1),"date");}if(Z.value2&&(typeof Z.value2==="string")&&!Z.value2.match(/([1-9][0-9]{3,}|0[0-9]{3})(0[1-9]|1[0-2])(0[1-9]|[12][0-9]|3[01])/)){Z.value2=f1.ui5Type.parseValue(new Date(Z.value2),"date");}}}else if(f1&&f1.filterType==="boolean"){Y=W.ranges.length;for(i=0;i<Y;i++){Z=W.ranges[i];if(Z.hasOwnProperty("value1")){if(typeof Z.value1==="string"){Z.value1=(Z.value1==="true");}}if(Z.hasOwnProperty("value2")){if(typeof Z.value2==="string"){Z.value2=(Z.value2==="true");}}}}}n[P]=W;if(!R&&n[P].ranges){for(i=0;i<n[P].ranges.length;i++){n[P].ranges[i].tokenText=null;}}}else if(typeof W==="string"||typeof W==="number"||W instanceof Date){if(W&&(_.indexOf(P)>-1||a1.indexOf(P)>-1)){if(typeof W==="string"){W=new Date(W);}n[P]={ranges:[{"exclude":false,"operation":"EQ","keyField":P,"value1":W,"value2":null}],items:[],value:""};}else{n[P]={value:W,items:[]};}}}else{n[P]=null;if(typeof W==="string"||typeof W==="boolean"||typeof W==="number"||W instanceof Date){if(typeof W==="string"&&(_.indexOf(P)>-1||a1.indexOf(P)>-1||d1.indexOf(P)>-1)){n[P]=new Date(W);}else{n[P]=W;}}else if(W&&(W.value||W.value===0||W.value===false)){n[P]=W.value;}else if(W&&W.items&&W.items.length){n[P]=W.items[0].key;}else if(W&&W.ranges&&W.ranges.length){Y=W.ranges.length;for(i=0;i<Y;i++){Z=W.ranges[i];if(!Z.exclude&&Z.operation==="EQ"){break;}Z=null;}if(Z&&Z.value1){if(typeof Z.value1==="string"&&(_.indexOf(P)>-1||a1.indexOf(P)>-1||d1.indexOf(P)>-1)){n[P]=new Date(Z.value1);}else{n[P]=Z.value1;}}}}}else if(R||P===K.CUSTOM_FIELDS_MODEL_PROPERTY){n[P]=X[P];}}}return n;};K.adaptTime=function(e,i){var P;if(!(e instanceof Date)||!i){return e;}if(i.displayFormat==="Date"){return D.normalizeDate(e,true);}P=parseInt(i.precision);return D.adaptPrecision(e,P);};K.prototype.destroy=function(){var e=function(N){var i;if(N){i=N.length;while(i--){N[i].destroy();}}};this._oParentODataModel=null;this._aAnalyticalParameters=null;this._aFilterBarViewMetadata=null;this._oParameterization=null;this._oNonAnaParameterization=null;this._aFilterBarFieldNames=null;this._aFilterBarStringDateFieldNames=null;this._aFilterBarDateFieldNames=null;this._aFilterBarTimeFieldNames=null;this._aFilterBarTimeIntervalFieldNames=null;this._aFilterBarDateTimeMultiValueFieldNames=null;this._aFilterBarStringFieldNames=null;this._aFilterBarMultiValueFieldMetadata=null;this._aFilterBarDateTimeFieldNames=null;this._aFieldGroupAnnotation=null;this._aSelectionFields=null;this._aSelectionVariants=null;if(this._oBasicSearchControl&&this._oBasicSearchControl.destroy){this._oBasicSearchControl.destroy();}this._oBasicSearchControl=null;if(this._oMetadataAnalyser&&this._oMetadataAnalyser.destroy){this._oMetadataAnalyser.destroy();}this._oMetadataAnalyser=null;e(this._aValueHelpDialogProvider);this._aValueHelpDialogProvider=null;e(this._aValueListProvider);this._aValueListProvider=null;if(this._mTokenHandler){for(var j in this._mTokenHandler){var k=this._mTokenHandler[j];if(k.parser){k.parser.destroy();k.parser=null;}}delete this._mTokenHandler;}this.oResourceBundle=null;this.sIntervalPlaceholder=null;this.sDefaultDropDownDisplayBehaviour=null;this.sDefaultTokenDisplayBehaviour=null;this._oSmartFilter=null;if(this._oEventProvider){if(this._oEventProvider.destroy){this._oEventProvider.destroy();}this._oEventProvider=null;}for(var n in this._mConditionTypeFields){this._mConditionTypeFields[n].conditionType.destroy();}this._mConditionTypeFields=null;if(this.oModel){this.oModel.destroy();this.oModel=null;}this._aPromises=[];this.bIsDestroyed=true;};return K;},true);
