/*!
 * SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['sap/ui/comp/util/DateTimeUtil','sap/ui/model/CompositeType','sap/ui/model/FormatException','sap/ui/model/ParseException','sap/ui/model/ValidateException','sap/ui/core/LocaleData'],function(D,C,F,P,V,L){"use strict";var I=C.extend("sap.ui.comp.type.Interval",{constructor:function(){C.apply(this,arguments);this.sName="Interval";this.bUseInternalValues=true;}});I.prototype.formatValue=function(v,i){if(v==undefined||v==null){return null;}if(!Array.isArray(v)){throw new F("Cannot format interval: "+v+" is expected as an Array but given the wrong format");}if(v.length<1||v.length>2){throw new F("Cannot format interval: "+v+" is expected as an Array with 1 or 2 entries");}if(!i){i="string";}switch(this.getPrimitiveType(i)){case"string":case"any":if(v[0]===null&&(v.length===1||v[1]===null)){return"";}var t=this.oFormatOptions.type;var p=_.call(this,t);var s;var d;var r;if(t){if(t.isA("sap.ui.model.odata.type.Time")){s=t.formatValue(b(v[0]),"string");}else{s=t.formatValue(v[0],"string");}}else{s=v[0];}if(v.length===1||v[1]===null){r=s;}else{if(t){if(t.isA("sap.ui.model.odata.type.Time")){d=t.formatValue(b(v[1]),"string");}else{d=t.formatValue(v[1],"string");}}else{d=v[1];}r=p.replace(/\{0\}/g,s).replace(/\{1\}/g,d);}return r;default:throw new F("Don't know how to format Interval to "+i);}};I.prototype.parseValue=function(v,i,d){if((!i||i==="any")&&typeof v==="string"){i="string";}switch(this.getPrimitiveType(i)){case"string":if(!v){return[null,null];}var t=this.oFormatOptions.type;var p=_.call(this,t);var s=a.call(this,t);var r=[];var e=v.indexOf(s);var f=null;var g=null;if(e<0&&s.length>1){s=s.replace(/\s+/g,'');e=v.indexOf(s);}if(e<0&&s!==" - "&&s!=="-"){s=" - ";e=v.indexOf(s);}if(e<0&&s!=="-"){s="-";e=v.indexOf(s);}if(e===0&&s==="-"){e=v.slice(1).indexOf(s);if(e>=0){e++;}}if(e<0){f=v;if(!f){throw new P(v+" is not a valid interval");}}else if(e===0){f="";g=v.slice(s.length);if(!g){throw new P(v+" is not a valid interval");}}else{f=v.slice(0,e);g=v.slice(e+s.length);if(!f||!g){throw new P(v+" is not a valid interval");}}if(t){f=t.parseValue(f,"string");if(t.isA("sap.ui.model.odata.type.Time")){f=c(f);}if(e>=0){g=t.parseValue(g,"string");if(t.isA("sap.ui.model.odata.type.Time")){g=c(g);}}}if(p.indexOf("{0}")<p.indexOf("{1}")){r.push(f);r.push(g);}else{r.push(g);r.push(f);}return r;default:throw new P("Don't know how to parse Interval from "+i);}};I.prototype.validateValue=function(v){if(v==undefined||v==null){return;}if(!Array.isArray(v)){throw new V("An array is expected");}if(v.length<1||v.length>2){throw new V("There must be only one or two values in the array");}if(v.length===2&&v[1]!==null&&typeof v[0]!==typeof v[1]){throw new V("Low and high value must have the same type");}var t=this.oFormatOptions.type;if(t){if(t.isA("sap.ui.model.odata.type.Time")){t.validateValue(b(v[0]));}else{t.validateValue(v[0]);}if(v.length===2&&v[1]!==null){if(t.isA("sap.ui.model.odata.type.Time")){t.validateValue(b(v[1]));}else{t.validateValue(v[1]);}}}if(typeof v[0]==="number"){if(v.length===2&&v[1]!==null&&v[0]>v[1]){throw new V("Low value must be smaller than high value");}}else if(v[0]instanceof Date){if(v.length===2&&v[1]instanceof Date&&v[0]>v[1]){throw new V("Low value must be smaller than high value");}}};I.prototype._handleLocalizationChange=function(){delete this._sPattern;delete this._sDelimiter;};function _(t){if(this.oFormatOptions.delimiter){return"{0} "+this.oFormatOptions.delimiter+" {1}";}else if(!this._sPattern){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=L.getInstance(l);if(t&&(t.isA("sap.ui.model.type.Time")||t.isA("sap.ui.model.odata.type.Time")||t.isA("sap.ui.model.type.Date")||t.isA("sap.ui.model.odata.type.Date")||t.isA("sap.ui.model.type.DateTime")||t.isA("sap.ui.model.odata.type.DateTime")||t.isA("sap.ui.model.odata.type.DateTimeOffset")||t.isA("sap.ui.model.odata.type.TimeOfDay"))){this._sPattern=o.getIntervalPattern();}else{this._sPattern=o.getMiscPattern("range");}return this._sPattern;}else{return this._sPattern;}}function a(t){if(this.oFormatOptions.delimiter){return this.oFormatOptions.delimiter;}else if(!this._sDelimiter){var p=_.call(this,t);this._sDelimiter=p.replace(/\{0\}/g,"").replace(/\{1\}/g,"");return this._sDelimiter;}else{return this._sDelimiter;}}function b(d){if(d instanceof Date){d=D.localToUtc(d);return{__edmType:"Edm.Time",ms:d.valueOf()};}else{return d;}}function c(t){if(t&&t.ms){return D.utcToLocal(new Date(t.ms));}else{return t;}}return I;});
