/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData','sap/base/Log','sap/base/assert','sap/ui/thirdparty/jquery'],function(B,L,a,b,c,q){"use strict";var N=B.extend("sap.ui.core.format.NumberFormat",{constructor:function(F){throw new Error();}});var r=/0+(\.0+)?/;var d=/^0+$/;var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var R={FLOOR:"floor",CEILING:"ceiling",TOWARDS_ZERO:"towards_zero",AWAY_FROM_ZERO:"away_from_zero",HALF_FLOOR:"half_floor",HALF_CEILING:"half_ceiling",HALF_TOWARDS_ZERO:"half_towards_zero",HALF_AWAY_FROM_ZERO:"half_away_from_zero"};var m={};m[R.FLOOR]=Math.floor;m[R.CEILING]=Math.ceil;m[R.TOWARDS_ZERO]=function(i){return i>0?Math.floor(i):Math.ceil(i);};m[R.AWAY_FROM_ZERO]=function(i){return i>0?Math.ceil(i):Math.floor(i);};m[R.HALF_TOWARDS_ZERO]=function(i){return i>0?Math.ceil(i-0.5):Math.floor(i+0.5);};m[R.HALF_AWAY_FROM_ZERO]=function(i){return i>0?Math.floor(i+0.5):Math.ceil(i-0.5);};m[R.HALF_FLOOR]=function(i){return Math.ceil(i-0.5);};m[R.HALF_CEILING]=Math.round;N.RoundingMode=R;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",customCurrencies:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true,ignorePrecision:true};N.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.UNIT,showMeasure:true,style:"standard",customUnits:undefined,allowedUnits:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.getInstance=function(F,i){return this.getFloatInstance(F,i);};N.getFloatInstance=function(F,i){var s=this.createInstance(F,i),t=this.getLocaleFormatOptions(s.oLocaleData,n.FLOAT);s.oFormatOptions=q.extend(false,{},this.oDefaultFloatFormat,t,F);return s;};N.getIntegerInstance=function(F,i){var s=this.createInstance(F,i),t=this.getLocaleFormatOptions(s.oLocaleData,n.INTEGER);s.oFormatOptions=q.extend(false,{},this.oDefaultIntegerFormat,t,F);return s;};N.getCurrencyInstance=function(F,i){var s=this.createInstance(F,i),C=F&&F.currencyContext,t=this.getLocaleFormatOptions(s.oLocaleData,n.CURRENCY,C);s.oFormatOptions=q.extend(false,{},this.oDefaultCurrencyFormat,t,F);s._defineCustomCurrencySymbols();return s;};N.getUnitInstance=function(F,i){var s=this.createInstance(F,i),t=this.getLocaleFormatOptions(s.oLocaleData,n.UNIT);s.oFormatOptions=q.extend(false,{},this.oDefaultUnitFormat,t,F);return s;};N.getPercentInstance=function(F,i){var s=this.createInstance(F,i),t=this.getLocaleFormatOptions(s.oLocaleData,n.PERCENT);s.oFormatOptions=q.extend(false,{},this.oDefaultPercentFormat,t,F);return s;};N.createInstance=function(F,i){var s=Object.create(this.prototype),P;if(F instanceof L){i=F;F=undefined;}if(!i){i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}s.oLocale=i;s.oLocaleData=a.getInstance(i);s.oOriginalFormatOptions=F;if(F){if(F.pattern){P=this.parseNumberPattern(F.pattern);q.each(P,function(t,O){F[t]=O;});}if(F.emptyString!==undefined){c(F.emptyString===""||F.emptyString===0||F.emptyString===null||F.emptyString!==F.emptyString,"The format option 'emptyString' must be either 0, null or NaN");}}return s;};N.getDefaultUnitPattern=function(s){return"{0} "+s;};N.getLocaleFormatOptions=function(i,t,C){var s,u;switch(t){case n.PERCENT:u=i.getPercentPattern();break;case n.CURRENCY:u=i.getCurrencyPattern(C);break;case n.UNIT:u=i.getDecimalPattern();break;default:u=i.getDecimalPattern();}s=this.parseNumberPattern(u);s.plusSign=i.getNumberSymbol("plusSign");s.minusSign=i.getNumberSymbol("minusSign");s.decimalSeparator=i.getNumberSymbol("decimal");s.groupingSeparator=i.getNumberSymbol("group");s.percentSign=i.getNumberSymbol("percentSign");s.pattern=u;switch(t){case n.UNIT:case n.FLOAT:case n.PERCENT:s.minFractionDigits=0;s.maxFractionDigits=99;break;case n.INTEGER:s.minFractionDigits=0;s.maxFractionDigits=0;s.groupingEnabled=false;break;case n.CURRENCY:s.minFractionDigits=undefined;s.maxFractionDigits=undefined;break;}return s;};N.parseNumberPattern=function(F){var M=0,s=0,t=0,G=false,u=0,v=0,S=F.indexOf(";"),w={Integer:0,Fraction:1},x=w.Integer;if(S!==-1){F=F.substring(0,S);}for(var i=0;i<F.length;i++){var C=F[i];switch(C){case",":if(G){u=v;v=0;}G=true;break;case".":x=w.Fraction;break;case"0":if(x===w.Integer){M++;if(G){v++;}}else{s++;t++;}break;case"#":if(x===w.Integer){if(G){v++;}}else{t++;}break;}}if(!u){u=v;v=0;}return{minIntegerDigits:M,minFractionDigits:s,maxFractionDigits:t,groupingEnabled:G,groupingSize:u,groupingBaseSize:v};};N.prototype._defineCustomCurrencySymbols=function(){var O=this.oFormatOptions;var C=this.oLocaleData.getCurrencySymbols();var F=function(s,i){var u=[];var S;for(var K in s){S=s[K];if(u.indexOf(S)===-1){u.push(S);}else if(S!==undefined){i[S]=true;b.error("Symbol '"+S+"' is defined multiple times in custom currencies.",undefined,"NumberFormat");}}};if(O.customCurrencies&&typeof O.customCurrencies==="object"){this.mKnownCurrencySymbols={};this.mKnownCurrencyCodes={};Object.keys(O.customCurrencies).forEach(function(K){if(O.customCurrencies[K].symbol){this.mKnownCurrencySymbols[K]=O.customCurrencies[K].symbol;}else{var i=O.customCurrencies[K].isoCode;if(i){this.mKnownCurrencySymbols[K]=C[i];}}this.mKnownCurrencyCodes[K]=K;}.bind(this));}else{this.mKnownCurrencySymbols=C;this.mKnownCurrencyCodes=this.oLocaleData.getCustomCurrencyCodes();}this.mDuplicatedSymbols={};F(this.mKnownCurrencySymbols,this.mDuplicatedSymbols);};N.prototype.format=function(v,M){if(Array.isArray(v)){M=v[1];v=v[0];}var i="",F="",G="",s="",t="",P="",u=0,w=0,x=0,y=0,z=v<0,D=-1,O=q.extend({},this.oFormatOptions),A=this.oOriginalFormatOptions,I=O.type===n.CURRENCY&&M==="INR"&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",C,S,E,H,U,J;if(v===O.emptyString||(isNaN(v)&&isNaN(O.emptyString))){return"";}if(M&&O.customCurrencies&&!O.customCurrencies[M]){b.error("Currency '"+M+"' is unknown.");return"";}if(O.type===n.UNIT){if(O.customUnits&&typeof O.customUnits==="object"){U=O.customUnits[M];}else{J=this.oLocaleData.getUnitFromMapping(M)||M;U=this.oLocaleData.getUnitFormat(J);}O.decimals=(U&&(typeof U.decimals==="number"&&U.decimals>=0))?U.decimals:O.decimals;O.precision=(U&&(typeof U.precision==="number"&&U.precision>=0))?U.precision:O.precision;}if(O.type==n.CURRENCY){if(O.customCurrencies&&O.customCurrencies[M]){O.decimals=O.customCurrencies[M].decimals!==undefined?O.customCurrencies[M].decimals:O.decimals;}}if(O.decimals!==undefined){O.minFractionDigits=O.decimals;O.maxFractionDigits=O.decimals;}if(O.shortLimit===undefined||Math.abs(v)>=O.shortLimit){E=O.shortRefNumber===undefined?v:O.shortRefNumber;S=g(E,O,this.oLocaleData,I);if(S&&S.formatString!="0"){v=v/S.magnitude;if(O.shortDecimals!==undefined){O.minFractionDigits=O.shortDecimals;O.maxFractionDigits=O.shortDecimals;}else{if(A.minFractionDigits===undefined&&A.maxFractionDigits===undefined&&A.decimals===undefined&&A.precision===undefined&&A.pattern===undefined){O.precision=2;O.minFractionDigits=0;O.maxFractionDigits=99;}if(A.maxFractionDigits===undefined&&A.decimals===undefined){O.maxFractionDigits=99;}}O.roundingMode=N.RoundingMode.HALF_AWAY_FROM_ZERO;}}if((S||!O.ignorePrecision)&&O.precision!==undefined){O.maxFractionDigits=Math.min(O.maxFractionDigits,k(v,O.precision));O.minFractionDigits=Math.min(O.minFractionDigits,O.maxFractionDigits);}if(O.type==n.PERCENT){v=N._shiftDecimalPoint(v,2);}if(O.type==n.CURRENCY){var K=this.oLocaleData.getCurrencyDigits(M);if(O.customCurrencies&&O.customCurrencies[M]&&O.customCurrencies[M].decimals!==undefined){K=O.customCurrencies[M].decimals;}if(O.maxFractionDigits===undefined){O.maxFractionDigits=K;}if(O.minFractionDigits===undefined){O.minFractionDigits=K;}}if(typeof v==="number"){v=h(v,O.maxFractionDigits,O.roundingMode);}if(v==0){z=false;}t=this.convertToDecimal(v);if(t=="NaN"){return t;}if(z){t=t.substr(1);}D=t.indexOf(".");if(D>-1){i=t.substr(0,D);F=t.substr(D+1);}else{i=t;}if(i.length<O.minIntegerDigits){i=i.padStart(O.minIntegerDigits,"0");}else if(i.length>O.maxIntegerDigits){i="".padStart(O.maxIntegerDigits,"?");}if(F.length<O.minFractionDigits){F=F.padEnd(O.minFractionDigits,"0");}else if(F.length>O.maxFractionDigits){F=F.substr(0,O.maxFractionDigits);}w=i.length;if(O.groupingEnabled){if(I){var Q=[3,2,2],T,V=0;u=i.length;while(u>0){T=Q[V%3];u-=T;if(V>0){G=O.groupingSeparator+G;}if(u<0){T+=u;u=0;}G=i.substr(u,T)+G;V++;}}else{x=O.groupingSize;y=O.groupingBaseSize||x;u=Math.max(w-y,0)%x||x;G=i.substr(0,u);while(w-u>=y){G+=O.groupingSeparator;G+=i.substr(u,x);u+=x;}G+=i.substr(u);}}else{G=i;}if(z){s=O.minusSign;}s+=G;if(F){s+=O.decimalSeparator+F;}if(S&&S.formatString&&O.showScale&&O.type!==n.CURRENCY){H=this.oLocaleData.getPluralCategory(i+"."+F);S.formatString=this.oLocaleData.getDecimalFormat(O.style,S.key,H);s=S.formatString.replace(S.valueSubString,s);s=s.replace(/'.'/g,".");}if(O.type===n.CURRENCY){P=O.pattern;if(S&&S.formatString&&O.showScale){H=this.oLocaleData.getPluralCategory(i+"."+F);if(I){P=f("short",S.key,H);}else{P=this.oLocaleData.getCurrencyFormat("short",S.key,H);}P=P.replace(/'.'/g,".");}C=P.split(";");if(C.length===2){P=z?C[1]:C[0];if(z){s=s.substring(O.minusSign.length);}}if(!O.currencyCode){var W;if(O.customCurrencies&&typeof O.customCurrencies==="object"){W=this.mKnownCurrencySymbols[M];}else{W=this.oLocaleData.getCurrencySymbol(M);}if(W&&W!==M){M=W;}}s=this._composeCurrencyResult(P,s,M,{showMeasure:O.showMeasure,negative:z,minusSign:O.minusSign});}if(O.type===n.PERCENT){P=O.pattern;s=P.replace(/[0#.,]+/,s);s=s.replace(/%/,O.percentSign);}if(O.showMeasure&&O.type===n.UNIT){H=this.oLocaleData.getPluralCategory(i+"."+F);c(H,"Cannot find plural category for "+(i+"."+F));var X=!O.allowedUnits||O.allowedUnits.indexOf(M)>=0;if(!X){c(X,"The given unit '"+M+"' is not part of the allowed unit types: ["+O.allowedUnits.join(",")+"].");return"";}if(U){P=U["unitPattern-count-"+H];if(!P){P=U["unitPattern-count-other"];}c(P,"Cannot find pattern 'unitPattern-count-"+H+"' in '"+M+"'");if(!P){return"";}s=P.replace("{0}",s);}else if(!O.unitOptional){c(U,"Unit '"+M+"' is unknown");return"";}}if(sap.ui.getCore().getConfiguration().getOriginInfo()){s=new String(s);s.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return s;};N.prototype._composeCurrencyResult=function(P,F,M,O){var s=O.minusSign;P=P.replace(/[0#.,]+/,F);if(O.showMeasure&&M){var i="\u00a4",t={"[:digit:]":/\d/,"[:^S:]":/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6]/},u=P.indexOf(i),v=u<P.length/2?"after":"before",S=this.oLocaleData.getCurrencySpacing(v),C=(v==="after"?M.charAt(M.length-1):M.charAt(0)),w,x=t[S.currencyMatch],y=t[S.surroundingMatch],I;P=P.replace(i,M);w=(v==="after"?P.charAt(u+M.length):P.charAt(u-1));if(x&&x.test(C)&&y&&y.test(w)){if(v==="after"){I=u+M.length;}else{I=u;}P=P.slice(0,I)+S.insertBetween+P.slice(I);}else if(O.negative&&v==="after"){s="\ufeff"+O.minusSign;}}else{P=P.replace(/\s*\u00a4\s*/,"");}if(O.negative){P=P.replace(/-/,s);}return P;};N.prototype.parse=function(v){var O=this.oFormatOptions,P=O.plusSign+this.oLocaleData.getLenientNumberSymbols("plusSign"),M=O.minusSign+this.oLocaleData.getLenientNumberSymbols("minusSign"),s=j(P+M),G=j(O.groupingSeparator),D=j(O.decimalSeparator),t="^\\s*(["+s+"]?(?:[0-9"+G+"]+|[0-9"+G+"]*"+D+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",u="^\\s*(["+s+"]?[0-9"+G+"]+)\\s*$",w=new RegExp(G,"g"),x=new RegExp(D,"g"),y=this.oLocaleData.getNumberSymbol("percentSign"),I=O.type===n.CURRENCY&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",z,A,C,E,F=0,S,H;if(v===""){H=O.emptyString;if(O.parseAsString&&(O.emptyString===0||isNaN(O.emptyString))){H=O.emptyString+"";}if(O.type===n.CURRENCY||O.type===n.UNIT){return[H,undefined];}else{return H;}}E=O.type===n.PERCENT?O.pattern:this.oLocaleData.getPercentPattern();if(E.charAt(0)==="%"){t=t.slice(0,1)+"%?"+t.slice(1);}else if(E.charAt(E.length-1)==="%"){t=t.slice(0,t.length-1)+"%?"+t.slice(t.length-1);}var U;if(O.type===n.UNIT){var J;if(O.customUnits&&typeof O.customUnits==="object"){J=O.customUnits;}else{J=this.oLocaleData.getUnitFormats();}c(J,"Unit patterns cannot be loaded");if(O.allowedUnits){var K={};for(var i=0;i<O.allowedUnits.length;i++){var Q=O.allowedUnits[i];K[Q]=J[Q];}J=K;}var T=p(J,v);var V=false;U=T.cldrCode;if(U.length===1){C=U[0];}else if(U.length===0){if((O.unitOptional||!O.showMeasure)&&typeof v==="string"){T.numberValue=v;}else{c(U.length===1,"Cannot find unit for input: '"+(v)+"'");return null;}}else{c(U.length===1,"Ambiguous unit ["+U.join(", ")+"] for input: '"+(v)+"'");C=undefined;V=true;}if(O.strictParsing){if((C&&!O.showMeasure)||V){return null;}}v=T.numberValue||v;}var W;if(O.type===n.CURRENCY){W=o({value:v,currencySymbols:this.mKnownCurrencySymbols,customCurrencyCodes:this.mKnownCurrencyCodes,duplicatedSymbols:this.mDuplicatedSymbols,customCurrenciesAvailable:!!O.customCurrencies});if(!W){return null;}if(O.strictParsing){if((O.showMeasure&&!W.currencyCode)||W.duplicatedSymbolFound){return null;}}v=W.numberValue;C=W.currencyCode;if((O.customCurrencies&&C===null)||(!O.showMeasure&&C)){return null;}}if(typeof v==="string"||v instanceof String){v=v.replace(/[\u202a\u200e\u202c\u202b\u200f]/g,"");v=v.replace(/\s/g,"");}S=e(v,this.oLocaleData,I);if(S){v=S.number;}if(O.isInteger&&!S){z=new RegExp(u);}else{z=new RegExp(t);}if(!z.test(v)){return O.type===n.CURRENCY||O.type===n.UNIT?null:NaN;}v=v.replace(w,"");var X=v.length;for(var Y=0;Y<X;Y++){var Z=v[Y];if(P.includes(Z)){v=v.replace(Z,"+");break;}else if(M.includes(Z)){v=v.replace(Z,"-");break;}}v=v.replace(/^\+/,"");if(S){v=v.replace(x,".");v=N._shiftDecimalPoint(v,Math.round(Math.log(S.factor)/Math.LN10));}if(O.isInteger){F=O.parseAsString?v:parseInt(v);}else{v=v.replace(x,".");if(v.indexOf(y)!==-1){A=true;v=v.replace(y,"");}F=O.parseAsString?v:parseFloat(v);if(A){F=N._shiftDecimalPoint(F,-2);}}if(O.parseAsString){F=N._shiftDecimalPoint(v,0);}if(O.type===n.CURRENCY||O.type===n.UNIT){return[F,C];}return F;};N.prototype.convertToDecimal=function(v){var V=""+v,s,t,D,F,E,P;if(V.indexOf("e")==-1&&V.indexOf("E")==-1){return V;}var u=V.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);s=u[1]=="-";t=u[2].replace(/\./g,"");D=u[3]?u[3].length:0;F=u[4]?u[4].length:0;E=parseInt(u[5]);if(E>0){if(E<F){P=D+E;V=t.substr(0,P)+"."+t.substr(P);}else{V=t;E-=F;for(var i=0;i<E;i++){V+="0";}}}else{if(-E<D){P=D+E;V=t.substr(0,P)+"."+t.substr(P);}else{V=t;E+=D;for(var i=0;i>E;i--){V="0"+V;}V="0."+V;}}if(s){V="-"+V;}return V;};N.prototype.getScale=function(){if((this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long")||this.oFormatOptions.shortRefNumber===undefined){return;}var s=g(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),S;if(s&&s.formatString){S=s.formatString.replace(r,"").replace(/'.'/g,".").trim();if(S){return S;}}};N._shiftDecimalPoint=function(v,s){if(typeof s!=="number"){return NaN;}var M="";var E=v.toString().toLowerCase().split("e");if(typeof v==="number"){s=E[1]?(+E[1]+s):s;return+(E[0]+"e"+s);}else if(typeof v==="string"){if(parseFloat(v)===0&&s>=0){return d.test(v)?"0":v;}var F=E[0].charAt(0);M=F==="-"?F:"";if(M){E[0]=E[0].slice(1);}v=E[0];var D=v.indexOf("."),A,i,t;if(D===-1){v=v+".";D=v.length-1;}if(E[1]){D+=(+E[1]);}A=D+s;if(A<=0){v=v.padStart(v.length-A+1,'0');A=1;}else if(A>=v.length-1){v=v.padEnd(A+1,'0');A=v.length-1;}v=v.replace(".","");i=v.substring(0,A);t=v.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return M+i+(t?("."+t):"");}else{return null;}};function g(v,O,s,I){var S,K,t,C,u=O.style,P=O.precision!==undefined?O.precision:2;if(u!="short"&&u!="long"){return undefined;}for(var i=0;i<15;i++){K=Math.pow(10,i);if(h(Math.abs(v)/K,P-1)<10){break;}}t=K.toString();if(O.type===n.CURRENCY){if(I){C=f(u,t,"other",true);}else{C=s.getCurrencyFormat(u,t,"other");}}else{C=s.getDecimalFormat(u,t,"other");}if(!C||C=="0"){return undefined;}else{S={};S.key=t;S.formatString=C;var w=C.match(r);if(w){S.valueSubString=w[0];var x=S.valueSubString.indexOf(".");if(x==-1){S.decimals=0;S.magnitude=K*Math.pow(10,1-S.valueSubString.length);}else{S.decimals=S.valueSubString.length-x-1;S.magnitude=K*Math.pow(10,1-x);}}else{return undefined;}}return S;}function e(v,s,I){var t,F=1,K=10,P=s.getPluralCategories(),C,u={number:undefined,factor:F},G=function(x,K,S,y){if(y){C=f(S,K.toString(),x,true);}else{C=s.getDecimalFormat(S,K.toString(),x);}if(C){C=C.replace(/[\s\u00a0\u200F]/g,"");C=C.replace(/'.'/g,".");var z=C.match(r);if(z){var V=z[0];var U=C.replace(V,"");if(!U){return;}var A=v.indexOf(U);if(A>=0){t=v.replace(U,"");t=t.replace(/\u200F/g,"");F=K;F*=Math.pow(10,1-V.length);if(u.number===undefined||t.length<u.number.length){u.number=t;u.factor=F;}}}}};["long","short"].forEach(function(S){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var w=P[i];G(w,K,S);}K=K*10;}});if(I&&!t){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var w=P[i];G(w,K,"short",true);}K=K*10;}}if(!t){return;}return u;}function f(s,K,P,D){var F,i={"short":{"1000-one":"\xa40000","1000-other":"\xa40000","10000-one":"\xa400000","10000-other":"\xa400000","100000-one":"\xa40 Lk","100000-other":"\xa40 Lk","1000000-one":"\xa400 Lk","1000000-other":"\xa400 Lk","10000000-one":"\xa40 Cr","10000000-other":"\xa40 Cr","100000000-one":"\xa400 Cr","100000000-other":"\xa400 Cr","1000000000-one":"\xa4000 Cr","1000000000-other":"\xa4000 Cr","10000000000-one":"\xa40000 Cr","10000000000-other":"\xa40000 Cr","100000000000-one":"\xa400000 Cr","100000000000-other":"\xa400000 Cr","1000000000000-one":"\xa40 Lk Cr","1000000000000-other":"\xa40 Lk Cr","10000000000000-one":"\xa400 Lk Cr","10000000000000-other":"\xa400 Lk Cr","100000000000000-one":"\xa40 Cr Cr","100000000000000-other":"\xa40 Cr Cr"}};s="short";if(P!=="one"){P="other";}F=i[s][K+"-"+P];if(F&&D){F=F.substr(1);}return F;}function h(v,M,s){if(typeof v!=="number"){return NaN;}s=s||N.RoundingMode.HALF_AWAY_FROM_ZERO;M=parseInt(M);if(typeof s==="function"){v=s(v,M);}else{if(!M){return m[s](v);}v=N._shiftDecimalPoint(m[s](N._shiftDecimalPoint(v,M)),-M);}return v;}function j(s){return s.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1");}function k(v,P){var i=Math.floor(Math.log(Math.abs(v))/Math.LN10);return Math.max(0,P-i-1);}function p(u,v){var i={numberValue:undefined,cldrCode:[]};if(typeof v!=="string"){return i;}var s=Number.POSITIVE_INFINITY;var U,K;for(U in u){for(K in u[U]){if(K.indexOf("unitPattern")===0){var t=u[U][K];var w=t.indexOf("{0}");var C=w>-1;if(C){var P=t.substring(0,w);var x=t.substring(w+"{0}".length);var M=v.startsWith(P)&&v.endsWith(x);var y=M&&v.substring(P.length,v.length-x.length);if(y){if(y.length<s){s=y.length;i.numberValue=y;i.cldrCode=[U];}else if(y.length===s&&i.cldrCode.indexOf(U)===-1){i.cldrCode.push(U);}}}else if(t===v){i.cldrCode=[U];var z;if(K.endsWith("-zero")){z="0";}else if(K.endsWith("-one")){z="1";}else if(K.endsWith("-two")){z="2";}i.numberValue=z;return i;}}}}return i;}function l(v,C){var s="",i,t;for(var u in C){t=C[u];if(v.indexOf(t)>=0&&s.length<t.length){s=t;i=u;}}return{symbol:s,code:i};}function o(C){var v=C.value;var M=l(v,C.currencySymbols);if(!M.code){M=l(v,C.customCurrencyCodes);if(!M.code&&!C.customCurrenciesAvailable){var i=v.match(/(^[A-Z]{3}|[A-Z]{3}$)/);M.code=i&&i[0];}}if(M.code){var s=M.code.length-1;var t=M.code.charAt(s);var D;var u=/[\-\s]+/;if(/\d$/.test(t)){if(v.startsWith(M.code)){D=s+1;if(!u.test(v.charAt(D))){return undefined;}}}else if(/^\d/.test(M.code)){if(v.endsWith(M.code)){D=v.indexOf(M.code)-1;if(!u.test(v.charAt(D))){return undefined;}}}v=v.replace(M.symbol||M.code,"");}var w=false;if(C.duplicatedSymbols&&C.duplicatedSymbols[M.symbol]){M.code=undefined;w=true;b.error("The parsed currency symbol '"+M.symbol+"' is defined multiple "+"times in custom currencies.Therefore the result is not distinct.");}return{numberValue:v,currencyCode:M.code||undefined,duplicatedSymbolFound:w};}return N;});
