/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/dt/TaskManager","sap/ui/dt/Util","sap/base/Log"],function(T,D,B){"use strict";var a=function(p){if(!p||!p.taskManager||!(p.taskManager instanceof T)){throw D.createError("TaskRunner#constructor","sap.ui.dt.TaskRunner: TaskManager required");}this._oTaskManager=p.taskManager;this._sInitialTaskType=p.taskType;this._sObservedTaskType=p.taskType;this._iRequestId=undefined;this.bIsStopped=true;};a.prototype._shouldObserveBreak=function(){if(this.bIsStopped||!this._oTaskManager||this._oTaskManager.bIsDestroyed){this.bIsStopped=true;return true;}return false;};a.prototype._observe=function(){this._checkTasks();if(!this._shouldObserveBreak()){this._iRequestId=window.requestAnimationFrame(this._observe.bind(this));}};a.prototype._unobserve=function(){if(this._iRequestId){window.cancelAnimationFrame(this._iRequestId);this._iRequestId=undefined;}};a.prototype._checkTasks=function(){var t=this._oTaskManager.getList(this._sObservedTaskType);if(t.length){this._runTasks(t);}};a.prototype._runTasks=function(t){for(var i=0,n=t.length;i<n;i++){if(t[i].callbackFn){try{t[i].callbackFn();}catch(e){B.error(D.errorToString(e));}}this._oTaskManager.complete(t[i].id);}};a.prototype.run=function(t){this._sObservedTaskType=t||this._sInitialTaskType;this.bIsStopped=false;this._observe();};a.prototype.stop=function(){this.bIsStopped=true;this._unobserve();};return a;});
