//@ui5-bundle sap/ui/generic/app/library-preload.js
/*
 * ! @copyright@
 */
sap.ui.predefine('sap/ui/generic/app/navigation/service/NavigationHandler',["./NavError","./SelectionVariant","sap/ui/generic/app/library","sap/ui/base/Object","sap/ui/model/resource/ResourceModel","sap/ui/core/UIComponent","sap/ui/core/routing/HashChanger","sap/ui/thirdparty/jquery","sap/base/Log","sap/base/assert"],function(E,S,N,B,R,U,H,q,L,a){"use strict";
var b=B.extend("sap.ui.generic.app.navigation.service.NavigationHandler",{
metadata:{publicMethods:["navigate","parseNavigation","storeInnerAppState","openSmartLinkPopover","mixAttributesAndSelectionVariant","setModel"]},
constructor:function(c,p){if(!c){throw new E("NavigationHandler.INVALID_INPUT");}if(c instanceof U){this.oRouter=c.getRouter();this.oComponent=c;}else{if(typeof c.getOwnerComponent!=="function"){throw new E("NavigationHandler.INVALID_INPUT");}this.oRouter=this._getRouter(c);this.oComponent=c.getOwnerComponent();}if(this.oComponent&&this.oComponent.getAppComponent){this.oComponent=this.oComponent.getAppComponent();}if(typeof this.oRouter==="undefined"||typeof this.oComponent==="undefined"||typeof this.oComponent.getComponentData!=="function"){throw new E("NavigationHandler.INVALID_INPUT");}try{this.oCrossAppNavService=this._getAppNavigationService();if(!this.oCrossAppNavService){L.error("NavigationHandler: CrossApplicationNavigation is not available.");throw new E("NavigationHandler.NO.XAPPSERVICE");}}catch(e){L.error("NavigationHandler: UShell service API for CrossApplicationNavigation is not available.");}this.IAPP_STATE="sap-iapp-state";this.sDefaultedParamProp="sap-ushell-defaultedParameterNames";this.sSAPSystemProp="sap-system";this._aTechnicalParamaters=["hcpApplicationId"];this._oLastSavedInnerAppData={sAppStateKey:"",oAppData:{},iCacheHit:0,iCacheMiss:0};this._rIAppStateOld=new RegExp("/"+this.IAPP_STATE+"=([^/?]+)");this._rIAppStateOldAtStart=new RegExp("^"+this.IAPP_STATE+"=([^/?]+)");this._rIAppStateNew=new RegExp("[\?&]"+this.IAPP_STATE+"=([^&]+)");if(p===sap.ui.generic.app.navigation.service.ParamHandlingMode.URLParamWins||p===sap.ui.generic.app.navigation.service.ParamHandlingMode.InsertInSelOpt){this.sParamHandlingMode=p;}else{this.sParamHandlingMode=sap.ui.generic.app.navigation.service.ParamHandlingMode.SelVarWins;}},
_getAppNavigationService:function(){return sap.ushell.Container.getService("CrossApplicationNavigation");},
_getRouter:function(c){return U.getRouterFor(c);},
navigate:function(s,A,n,i,o,e,c){var d,p,x,C,f,g=false,t={};C=this.oComponent.getComponentData();if(C){f=C.startupParameters;if(f&&f["sap-ushell-next-navmode"]&&f["sap-ushell-next-navmode"].length>0){g=(f["sap-ushell-next-navmode"][0]==="explace");}}if(c&&((c==="inplace")||(c==="explace"))){g=(c==="explace");}else if(c){throw new E("NavigationHandler.INVALID_NAV_MODE");}if((e===undefined)||(e===null)){x={};}else{x=e;}if(typeof n==="string"){d=n;}else if(typeof n==="object"){var h=this._splitInboundNavigationParameters(new S(),n,[]).oNavigationSelVar;d=h.toJSONString();}else{throw new E("NavigationHandler.INVALID_INPUT");}t.selectionVariant=new S(d).toJSONObject();t=this._removeMeasureBasedInformation(t);t=this._checkIsPotentiallySensitive(t);if(t.selectionVariant){p=this._getURLParametersFromSelectionVariant(new S(t.selectionVariant));d=new S(t.selectionVariant).toJSONString();}else{p={};d=null;}var j=this;var k={target:{semanticObject:s,action:A},params:p||{}};if(c){k.params["sap-ushell-navmode"]=g?"explace":"inplace";}var l=j.oCrossAppNavService.isNavigationSupported([k],j.oComponent);l.done(function(T){if(T[0].supported){var r;if(!g){r=j.storeInnerAppStateWithImmediateReturn(i,true);if(r&&r.appStateKey){j.replaceHash(r.appStateKey);}}if(!x.selectionVariant){x.selectionVariant=d;}x=j._removeMeasureBasedInformation(x);r=j._saveAppStateWithImmediateReturn(x,o);if(r){k.appStateKey=r.appStateKey;j.oCrossAppNavService.toExternal(k,j.oComponent);}}else{if(o){var m=new E("NavigationHandler.isIntentSupported.notSupported");o(m);}}});if(o){l.fail(function(){var m=j._createTechnicalError("NavigationHandler.isIntentSupported.failed");o(m);});}},
parseNavigation:function(){var A=H.getInstance().getHash();var i=this._getInnerAppStateKey(A);var c=this.oComponent.getComponentData();if(c===undefined){L.warning("The navigation Component's data was not set properly; assuming instead that no parameters are provided.");c={};}var s=c.startupParameters;var d=[];if(s&&s[this.sDefaultedParamProp]&&s[this.sDefaultedParamProp].length>0){d=JSON.parse(s[this.sDefaultedParamProp][0]);}var m=q.Deferred();var n=this;if(i){this._loadAppState(i,m);}else{var I=c["sap-xapp-state"]!==undefined;if(I){var o=this.oCrossAppNavService.getStartupAppState(this.oComponent);o.done(function(g){var f=g.getData();if(f){try{f=JSON.parse(JSON.stringify(f));}catch(x){var h=n._createTechnicalError("NavigationHandler.AppStateData.parseError");m.reject(h,s,sap.ui.generic.app.navigation.service.NavType.xAppState);return m.promise();}}if(f){var j=new S(f.selectionVariant);var e=n._splitInboundNavigationParameters(j,s,d);f.selectionVariant=e.oNavigationSelVar.toJSONString();f.oSelectionVariant=e.oNavigationSelVar;f.oDefaultedSelectionVariant=e.oDefaultedSelVar;f.bNavSelVarHasDefaultsOnly=e.bNavSelVarHasDefaultsOnly;m.resolve(f,s,sap.ui.generic.app.navigation.service.NavType.xAppState);}else{h=n._createTechnicalError("NavigationHandler.getDataFromAppState.failed");m.reject(h,s||{},sap.ui.generic.app.navigation.service.NavType.xAppState);}});o.fail(function(){var g=n._createTechnicalError("NavigationHandler.getStartupState.failed");m.reject(g,{},sap.ui.generic.app.navigation.service.NavType.xAppState);});}else{if(s){var e=n._splitInboundNavigationParameters(new S(),s,d);if(e.oNavigationSelVar.isEmpty()&&e.oDefaultedSelVar.isEmpty()){m.resolve({},s,sap.ui.generic.app.navigation.service.NavType.initial);}else{var f={};f.selectionVariant=e.oNavigationSelVar.toJSONString();f.oSelectionVariant=e.oNavigationSelVar;f.oDefaultedSelectionVariant=e.oDefaultedSelVar;f.bNavSelVarHasDefaultsOnly=e.bNavSelVarHasDefaultsOnly;m.resolve(f,s,sap.ui.generic.app.navigation.service.NavType.URLParams);}}else{m.resolve({},{},sap.ui.generic.app.navigation.service.NavType.initial);}}}return m.promise();},
setTechnicalParameters:function(t){if(!t){t=[];}if(!Array.isArray(t)){L.error("NavigationHandler: parameter incorrect, array of strings expected");throw new E("NavigationHandler.INVALID_INPUT");}this._aTechnicalParamaters=t;},
getTechnicalParameters:function(){return this._aTechnicalParamaters.concat([]);},
_isTechnicalParameter:function(p){if(p){if(p.toLowerCase().indexOf("sap-")===0){return true;}else if(this._aTechnicalParamaters.indexOf(p)>=0){return true;}}return false;},
_splitInboundNavigationParameters:function(s,o,d){if(!Array.isArray(d)){throw new E("NavigationHandler.INVALID_INPUT");}var p,i;var c={};for(p in o){if(!o.hasOwnProperty(p)){continue;}if(this._isTechnicalParameter(p)){continue;}if(typeof o[p]==="string"){c[p]=o[p];}else if(q.type(o[p])==="array"&&o[p].length===1){c[p]=o[p][0];}else if(q.type(o[p])==="array"&&o[p].length>1){c[p]=o[p];}else{throw new E("NavigationHandler.INVALID_INPUT");}}var D=new S();var n=new S();var e=s.getParameterNames().concat(s.getSelectOptionsPropertyNames());for(i=0;i<e.length;i++){p=e[i];if(p in c){if(d.indexOf(p)>-1){n.massAddSelectOption(p,s.getValue(p));this._addParameterValues(D,p,"I","EQ",c[p]);}else{switch(this.sParamHandlingMode){case sap.ui.generic.app.navigation.service.ParamHandlingMode.SelVarWins:n.massAddSelectOption(p,s.getValue(p));break;case sap.ui.generic.app.navigation.service.ParamHandlingMode.URLParamWins:this._addParameterValues(n,p,"I","EQ",c[p]);break;case sap.ui.generic.app.navigation.service.ParamHandlingMode.InsertInSelOpt:n.massAddSelectOption(p,s.getValue(p));this._addParameterValues(n,p,"I","EQ",c[p]);break;default:throw new E("NavigationHandler.INVALID_INPUT");}}}else{if(d.indexOf(p)>-1){D.massAddSelectOption(p,s.getValue(p));}else{n.massAddSelectOption(p,s.getValue(p));}}}for(p in c){if(e.indexOf(p)>-1){continue;}if(d.indexOf(p)>-1){this._addParameterValues(D,p,"I","EQ",c[p]);}else{this._addParameterValues(n,p,"I","EQ",c[p]);}}var f=false;if(n.isEmpty()){f=true;var P=D.getSelectOptionsPropertyNames();for(i=0;i<P.length;i++){n.massAddSelectOption(P[i],D.getValue(P[i]));}}return{oNavigationSelVar:n,oDefaultedSelVar:D,bNavSelVarHasDefaultsOnly:f};},
_addParameterValues:function(s,p,c,o,v){if(Array.isArray(v)){for(var i=0;i<v.length;i++){s.addSelectOption(p,c,o,v[i]);}}else{s.addSelectOption(p,c,o,v);}},
replaceHash:function(A){var h=this.oRouter.oHashChanger?this.oRouter.oHashChanger:H.getInstance();var s=h.getHash();var c=this._replaceInnerAppStateKey(s,A);h.replaceHash(c);},
storeInnerAppState:function(i,I){if(typeof I!=="boolean"){I=true;}var n=this;var m=q.Deferred();var r=function(s){var h=n.oRouter.oHashChanger?n.oRouter.oHashChanger:H.getInstance();var d=h.getHash();var e=n._replaceInnerAppStateKey(d,s);h.replaceHash(e);};if(i===null){m.resolve("");return m.promise();}var A=this._oLastSavedInnerAppData.sAppStateKey;if(q.isEmptyObject(i)&&!A){m.resolve("");return m.promise();}var c=(JSON.stringify(i)===JSON.stringify(this._oLastSavedInnerAppData.oAppData));if(c&&A){this._oLastSavedInnerAppData.iCacheHit++;r(A);m.resolve(A);return m.promise();}this._oLastSavedInnerAppData.iCacheMiss++;var o=function(s){if(!I){r(s);}n._oLastSavedInnerAppData.oAppData=i;n._oLastSavedInnerAppData.sAppStateKey=s;m.resolve(s);};var O=function(e){m.reject(e);};var s=this._saveAppState(i,o,O);if(s!==undefined){if(I){r(s);}}return m.promise();},
storeInnerAppStateWithImmediateReturn:function(i,I){if(typeof I!=="boolean"){I=false;}var t=this;var A=q.Deferred();if(i===null){return{appStateKey:"",promise:A.resolve("")};}var s=this._oLastSavedInnerAppData.sAppStateKey;if(q.isEmptyObject(i)&&!s){return{appStateKey:"",promise:A.resolve("")};}var c=(JSON.stringify(i)===JSON.stringify(this._oLastSavedInnerAppData.oAppData));if(c&&s){this._oLastSavedInnerAppData.iCacheHit++;return{appStateKey:s,promise:A.resolve(s)};}this._oLastSavedInnerAppData.iCacheMiss++;var o=function(d){if(!I){t.replaceHash(d);}t._oLastSavedInnerAppData.oAppData=i;t._oLastSavedInnerAppData.sAppStateKey=d;A.resolve(d);};var O=function(e){A.reject(e);};var d=this._saveAppState(i,o,O);return{appStateKey:d,promise:A.promise()};},
processBeforeSmartLinkPopoverOpens:function(t,s,i,e){var m=q.Deferred();var c=t.semanticAttributes;var x,n=this;if(e===undefined){x={};}else{x=e;}var f=function(c,s){s=x.selectionVariant||s||"{}";var d=sap.ui.generic.app.navigation.service.SuppressionBehavior.raiseErrorOnNull|sap.ui.generic.app.navigation.service.SuppressionBehavior.raiseErrorOnUndefined;var M=n.mixAttributesAndSelectionVariant(c,s,d);s=M.toJSONString();var T={};T.selectionVariant=M.toJSONObject();T=n._removeMeasureBasedInformation(T);T=n._checkIsPotentiallySensitive(T);c=T.selectionVariant?n._getURLParametersFromSelectionVariant(new S(T.selectionVariant)):{};var O=function(A){t.setSemanticAttributes(c);t.setAppStateKey(A);t.open();m.resolve(t);};var g=function(h){m.reject(h);};x.selectionVariant=s;x=n._removeMeasureBasedInformation(x);n._saveAppState(x,O,g);};if(i){var o=this.storeInnerAppState(i,true);o.done(function(){f(c,s);});o.fail(function(d){m.reject(d);});}else{f(c,s);}return m.promise();},
mixAttributesAndSelectionVariant:function(s,c,d){if(d===undefined){d=sap.ui.generic.app.navigation.service.SuppressionBehavior.standard;}var o=new S(c);var n=new S();if(o.getFilterContextUrl()){n.setFilterContextUrl(o.getFilterContextUrl());}if(o.getParameterContextUrl()){n.setParameterContextUrl(o.getParameterContextUrl());}for(var p in s){if(s.hasOwnProperty(p)){var v=s[p];if(q.type(v)==="array"||q.type(v)==="object"){v=JSON.stringify(v);}else if(q.type(v)==="date"){v=v.toJSON();}else if(q.type(v)==="number"||q.type(v)==="boolean"){v=v.toString();}if(v===""){if(d&sap.ui.generic.app.navigation.service.SuppressionBehavior.ignoreEmptyString){L.info("Semantic attribute "+p+" is an empty string and due to the chosen Suppression Behiavour is being ignored.");continue;}}if(v===null){if(d&sap.ui.generic.app.navigation.service.SuppressionBehavior.raiseErrorOnNull){throw new E("NavigationHandler.INVALID_INPUT");}else{L.warning("Semantic attribute "+p+" is null and ignored for mix in to selection variant");continue;}}if(v===undefined){if(d&sap.ui.generic.app.navigation.service.SuppressionBehavior.raiseErrorOnUndefined){throw new E("NavigationHandler.INVALID_INPUT");}else{L.warning("Semantic attribute "+p+" is undefined and ignored for mix in to selection variant");continue;}}if(q.type(v)==="string"){n.addSelectOption(p,"I","EQ",v);}else{throw new E("NavigationHandler.INVALID_INPUT");}}}var P=o.getParameterNames();for(var i=0;i<P.length;i++){if(!n.getSelectOption(P[i])){n.addSelectOption(P[i],"I","EQ",o.getParameter(P[i]));}}var e=o.getSelectOptionsPropertyNames();for(i=0;i<e.length;i++){if(!n.getSelectOption(e[i])){var f=o.getSelectOption(e[i]);for(var j=0;j<f.length;j++){n.addSelectOption(e[i],f[j].Sign,f[j].Option,f[j].Low,f[j].High);}}}return n;},
_ensureSelectionVariantFormatString:function(s){if(s===undefined){return undefined;}var c=s;if(typeof s==="object"){c=JSON.stringify(s);}return c;},
_saveAppState:function(A,o,O){var r=this._saveAppStateWithImmediateReturn(A,O);if(r){r.promise.done(function(){if(o){o(r.appStateKey);}});if(O){var n=this;r.promise.fail(function(){var e=n._createTechnicalError("NavigationHandler.AppStateSave.failed");O(e);});}return r.appStateKey;}return undefined;},
_saveAppStateWithImmediateReturn:function(A,o){var c=this.oCrossAppNavService.createEmptyAppState(this.oComponent);var s=c.getKey();var d={selectionVariant:{},tableVariantId:"",customData:{}};if(A.hasOwnProperty("selectionVariant")){d.selectionVariant=A.selectionVariant;if(A.selectionVariant){if(typeof A.selectionVariant==="string"){try{d.selectionVariant=JSON.parse(A.selectionVariant);}catch(x){var e=this._createTechnicalError("NavigationHandler.AppStateSave.parseError");if(o){o(e);}return undefined;}}}}if(A.tableVariantId){d.tableVariantId=A.tableVariantId;}if(A.customData){d.customData=A.customData;}if(A.presentationVariant){d.presentationVariant=A.presentationVariant;}if(A.valueTexts){d.valueTexts=A.valueTexts;}d=this._checkIsPotentiallySensitive(d);c.setData(d);var f=c.save();return{appStateKey:s,promise:f.promise()};},
_loadAppState:function(A,d){var o=this.oCrossAppNavService.getAppState(this.oComponent,A);var n=this;o.done(function(c){var e={selectionVariant:"{}",oSelectionVariant:new S(),oDefaultedSelectionVariant:new S(),bNavSelVarHasDefaultsOnly:false,tableVariantId:"",customData:{},appStateKey:A,presentationVariant:{},valueTexts:{}};var f=c.getData();if(typeof f==="undefined"){var g=n._createTechnicalError("NavigationHandler.getDataFromAppState.failed");d.reject(g,{},sap.ui.generic.app.navigation.service.NavType.iAppState);}else{if(f.selectionVariant){e.selectionVariant=n._ensureSelectionVariantFormatString(f.selectionVariant);e.oSelectionVariant=new S(e.selectionVariant);}if(f.tableVariantId){e.tableVariantId=f.tableVariantId;}if(f.customData){e.customData=f.customData;}if(f.presentationVariant){e.presentationVariant=f.presentationVariant;}if(f.valueTexts){e.valueTexts=f.valueTexts;}}d.resolve(e,{},sap.ui.generic.app.navigation.service.NavType.iAppState);});o.fail(function(){var e=n._createTechnicalError("NavigationHandler.getAppState.failed");d.reject(e,{},sap.ui.generic.app.navigation.service.NavType.iAppState);});},
_getInnerAppStateKey:function(A){if(!A){return undefined;}var m=this._rIAppStateNew.exec(A);if(m===null){m=this._rIAppStateOld.exec(A);}if(m===null){m=this._rIAppStateOldAtStart.exec(A);}if(m===null){return undefined;}return m[1];},
_replaceInnerAppStateKey:function(A,s){var n=this.IAPP_STATE+"="+s;if(!A){return"?"+n;}var f=function(A){if(A.indexOf("?")!==-1){return A+"&"+n;}return A+"?"+n;};if(!this._getInnerAppStateKey(A)){return f(A);}if(this._rIAppStateNew.test(A)){return A.replace(this._rIAppStateNew,function(c){return c.replace(/\=.*/ig,"="+s);});}var r=function(c,A){A=A.replace(c,"");return f(A);};if(this._rIAppStateOld.test(A)){return r(this._rIAppStateOld,A);}if(this._rIAppStateOldAtStart.test(A)){return r(this._rIAppStateOldAtStart,A);}a(false,"internal inconsistency: Approach of sap-iapp-state not known, but _getInnerAppStateKey returned it");return undefined;},
_getURLParametersFromSelectionVariant:function(s){var u={};var i=0;if(typeof s==="string"){var o=new S(s);}else if(typeof s==="object"){o=s;}else{throw new E("NavigationHandler.INVALID_INPUT");}var c=o.getSelectOptionsPropertyNames();for(i=0;i<c.length;i++){var d=o.getSelectOption(c[i]);if(d.length===1&&d[0].Sign==="I"&&d[0].Option==="EQ"){u[c[i]]=d[0].Low;}}var p=o.getParameterNames();for(i=0;i<p.length;i++){var P=o.getParameter(p[i]);u[p[i]]=P;}return u;},
_createTechnicalError:function(e){return new E(e);},
setModel:function(m){this._oModel=m;},
_getModel:function(){return this._oModel||this.oComponent.getModel();},
_removeAllProperties:function(d){if(d){if(d.selectionVariant){d.selectionVariant=null;}if(d.valueTexts){d.valueTexts=null;}}},
_removeProperties:function(f,p,d){if(f.length&&d&&(d.selectionVariant||d.valueTexts)){f.forEach(function(n){if(d.selectionVariant.SelectOptions){d.selectionVariant.SelectOptions.some(function(v,c){if(n===v.PropertyName){d.selectionVariant.SelectOptions.splice(c,1);return true;}return false;});}if(d.valueTexts&&d.valueTexts.Texts){d.valueTexts.Texts.forEach(function(t){if(t.PropertyTexts){t.PropertyTexts.some(function(v,c){if(n===v.PropertyName){t.PropertyTexts.splice(c,1);return true;}return false;});}});}});}if(p.length&&d&&d.selectionVariant&&d.selectionVariant.Parameters){p.forEach(function(n){d.selectionVariant.Parameters.some(function(v,c){if((n===v.PropertyName)||(("$Parameter."+n)===v.PropertyName)){d.selectionVariant.Parameters.splice(c,1);return true;}return false;});});}},
_isTermTrue:function(p,t){var i=function(T){if(T){return T.Bool?T.Bool!=="false":true;}return false;};return(!!p[t]&&i(p[t]));},
_isExcludedFromNavigationContext:function(p){return this._isTermTrue(p,"com.sap.vocabularies.UI.v1.ExcludeFromNavigationContext");},
_isPotentiallySensitive:function(p){return this._isTermTrue(p,"com.sap.vocabularies.PersonalData.v1.IsPotentiallySensitive");},
_isMeasureProperty:function(p){return this._isTermTrue(p,"com.sap.vocabularies.Analytics.v1.Measure");},
_isToBeExcluded:function(p){return this._isPotentiallySensitive(p)||this._isExcludedFromNavigationContext(p);},
constructContextUrl:function(e,m){if(!e){throw new E("NavigationHandler.NO_ENTITY_SET_PROVIDED");}if(m===undefined){m=this._getModel();}if(!(m&&m.isA("sap.ui.model.odata.v2.ODataModel"))){throw new E("NavigationHandler.NO_V2_MODEL_PROVIDED");}return this._constructContextUrl(m)+"#"+e;},
_constructContextUrl:function(m){var s=m._getServerUrl();if(s&&(s.lastIndexOf('/')===(s.length-1))){s=s.substr(0,s.length-1);}return s+m.sServiceUrl+"/$metadata";},
_checkIsPotentiallySensitive:function(d){var A=d,s=[],c=[];var i,m,M,e,o,f,g,F=[],p=[];if(d&&d.selectionVariant&&(d.selectionVariant.FilterContextUrl&&d.selectionVariant.SelectOptions||d.selectionVariant.ParameterContextUrl&&d.selectionVariant.Parameters)){m=this._getModel();if(this.oComponent&&m&&m.isA("sap.ui.model.odata.v2.ODataModel")){M=m.getMetaModel();if(m.getServiceMetadata()&&M&&M.oModel){if(d.selectionVariant.FilterContextUrl){F=d.selectionVariant.FilterContextUrl.split('#');}if((F.length===2)&&d.selectionVariant.SelectOptions&&(this._constructContextUrl(m).indexOf(F[0])===0)){e=M.getODataEntitySet(F[1]);if(e){o=M.getODataEntityType(e.entityType);}else{o=M.getODataEntityType(F[1]);}if(o){if(o&&o.property){for(i=0;i<o.property.length;i++){if(this._isToBeExcluded(o.property[i])){s.push(o.property[i].name);}}}if(o.navigationProperty){for(i=0;i<o.navigationProperty.length;i++){g=M.getODataAssociationEnd(o,o.navigationProperty[i].name);if(!g||(g.type===d.selectionVariant.FilterContextUrl)){continue;}if(g.multiplicity==="1"||g.multiplicity==="0..1"){f=M.getODataEntityType(g.type);if(f&&f.property){for(var j=0;j<f.property.length;j++){if(this._isToBeExcluded(f.property[j])){s.push(o.navigationProperty[i].name+'.'+f.property[j].name);}}}}}}}}if(d.selectionVariant.ParameterContextUrl){p=d.selectionVariant.ParameterContextUrl.split('#');}if((p.length===2)&&d.selectionVariant.Parameters&&(this._constructContextUrl(m).indexOf(p[0])===0)){e=M.getODataEntitySet(p[1]);if(e){o=M.getODataEntityType(e.entityType);}else{o=M.getODataEntityType(F[1]);}if(o){if(o.property){for(i=0;i<o.property.length;i++){if(this._isToBeExcluded(o.property[i])){c.push(o.property[i].name);}}}}}if(s.length||c.length){A=q.extend(true,{},A);this._removeProperties(s,c,A);}}else{this._removeAllProperties(A);L.error("NavigationHandler: oMetadata are not fully loaded!");}}}return A;},
_removeMeasureBasedInformation:function(A){var o=A;if(A.selectionVariant){if(typeof A.selectionVariant==="string"){try{o.selectionVariant=JSON.parse(A.selectionVariant);}catch(x){L.error("NavigationHandler: _removeMeasureBasedInformation parse error");}}o=this._removeMeasureBasedProperties(o);}return o;},
_removeMeasureBasedProperties:function(d){var A=d,m=[],M=[];var i,o,c,e,f,s,g,F=[],p=[];if(d&&d.selectionVariant&&(d.selectionVariant.FilterContextUrl&&d.selectionVariant.SelectOptions||d.selectionVariant.ParameterContextUrl&&d.selectionVariant.Parameters)){o=this._getModel();if(this.oComponent&&o&&o.isA("sap.ui.model.odata.v2.ODataModel")){c=o.getMetaModel();if(o.getServiceMetadata()&&c&&c.oModel){if(d.selectionVariant.FilterContextUrl){F=d.selectionVariant.FilterContextUrl.split('#');}if((F.length===2)&&d.selectionVariant.SelectOptions&&(this._constructContextUrl(o).indexOf(F[0])===0)){e=c.getODataEntitySet(F[1]);if(e){f=c.getODataEntityType(e.entityType);}else{f=c.getODataEntityType(F[1]);}if(f){if(f&&f.property){for(i=0;i<f.property.length;i++){if(this._isMeasureProperty(f.property[i])){m.push(f.property[i].name);}}}if(f.navigationProperty){for(i=0;i<f.navigationProperty.length;i++){g=c.getODataAssociationEnd(f,f.navigationProperty[i].name);if(!g||(g.type===d.selectionVariant.FilterContextUrl)){continue;}if(g.multiplicity==="1"||g.multiplicity==="0..1"){s=c.getODataEntityType(g.type);if(s&&s.property){for(var j=0;j<s.property.length;j++){if(this._isMeasureProperty(s.property[j])){m.push(f.navigationProperty[i].name+'.'+s.property[j].name);}}}}}}}}if(d.selectionVariant.ParameterContextUrl){p=d.selectionVariant.ParameterContextUrl.split('#');}if((p.length===2)&&d.selectionVariant.Parameters&&(this._constructContextUrl(o).indexOf(p[0])===0)){e=c.getODataEntitySet(p[1]);if(e){f=c.getODataEntityType(e.entityType);}else{f=c.getODataEntityType(F[1]);}if(f){if(f.property){for(i=0;i<f.property.length;i++){if(this._isMeasureProperty(f.property[i])){M.push(f.property[i].name);}}}}}if(m.length||M.length){A=q.extend(true,{},A);this._removeProperties(m,M,A);}}else{this._removeAllProperties(A);L.error("NavigationHandler: oMetadata are not fully loaded!");}}}return A;}
});
return b;});
/*!
 * @copyright@
 */
sap.ui.predefine('sap/ui/generic/app/navigation/service/PresentationVariant',["./NavError","sap/ui/base/Object","sap/ui/thirdparty/jquery","sap/base/Log"],function(E,B,q,L){"use strict";
var P=B.extend("sap.ui.generic.app.navigation.service.PresentationVariant",{
constructor:function(p){this._sId="";if(p!==undefined){if(typeof p==="string"){this._parseFromString(p);}else if(typeof p==="object"){this._parseFromObject(p);}else{throw new E("PresentationVariant.INVALID_INPUT_TYPE");}}},
getID:function(){return this._sId;},
setID:function(i){this._sId=i;},
setText:function(n){if(typeof n!=="string"){throw new E("PresentationVariant.INVALID_INPUT_TYPE");}this._sText=n;},
getText:function(){return this._sText;},
setContextUrl:function(u){if(typeof u!=="string"){throw new E("PresentationVariant.INVALID_INPUT_TYPE");}this._sCtxUrl=u;},
getContextUrl:function(){return this._sCtxUrl;},
isEmpty:function(){return((Object.keys(this.getTableVisualization()).length===0)&&(Object.keys(this.getChartVisualization()).length===0)&&(Object.keys(this.getProperties()).length===0));},
setProperties:function(p){this._mProperties=q.extend(true,{},p);},
getProperties:function(){return this._mProperties;},
setTableVisualization:function(p){this._mVisTable=q.extend(true,{},p);},
getTableVisualization:function(){return this._mVisTable;},
setChartVisualization:function(p){this._mVisChart=q.extend(true,{},p);},
getChartVisualization:function(){return this._mVisChart;},
toJSONObject:function(){var e={Version:{Major:"1",Minor:"0",Patch:"0"},PresentationVariantID:this._sId};if(this._sCtxUrl){e.ContextUrl=this._sCtxUrl;}if(this._sText){e.Text=this._sText;}else{e.Text="Presentation Variant with ID "+this._sId;}this._serializeProperties(e);this._serializeVisualizations(e);return e;},
toJSONString:function(){return JSON.stringify(this.toJSONObject());},
_serializeProperties:function(e){if(!this.getProperties()){return;}q.extend(true,e,this.getProperties());},
_serializeVisualizations:function(e){if(this.getTableVisualization()){if(!e.Visualizations){e.Visualizations=[];}e.Visualizations.push(this.getTableVisualization());}if(this.getChartVisualization()){if(!e.Visualizations){e.Visualizations=[];}e.Visualizations.push(this.getChartVisualization());}},
_parseFromString:function(j){if(j===undefined){throw new E("PresentationVariant.UNABLE_TO_PARSE_INPUT");}if(typeof j!=="string"){throw new E("PresentationVariant.INVALID_INPUT_TYPE");}var i=JSON.parse(j);this._parseFromObject(i);},
_parseFromObject:function(i){if(i.PresentationVariantID===undefined){L.warning("PresentationVariantID is not defined");i.PresentationVariantID="";}var I=q.extend(true,{},i);delete I.Version;this.setID(i.PresentationVariantID);delete I.PresentationVariantID;if(i.ContextUrl!==undefined&&i.ContextUrl!==""){this.setContextUrl(i.ContextUrl);delete I.ContextUrl;}if(i.Text!==undefined){this.setText(i.Text);delete I.Text;}if(i.Visualizations){this._parseVisualizations(i.Visualizations);delete I.Visualizations;}this._parseProperties(I);},
_parseProperties:function(i){var p={};q.each(i,function(k,v){p[k]=v;});this.setProperties(p);},
_parseVisualizations:function(v){if(!Array.isArray(v)){throw new E("PresentationVariant.INVALID_INPUT_TYPE");}if(typeof v.length>2){throw new E("PresentationVariant.TOO_MANY_VISUALIZATIONS");}for(var i=0;i<v.length;i++){if(v[i].Type&&(v[i].Type.indexOf("Chart")>=0)){this.setChartVisualization(v[i]);}else{this.setTableVisualization(v[i]);}}}
});
return P;});
sap.ui.predefine('sap/ui/generic/app/navigation/service/SelectionVariant',["./NavError","sap/ui/base/Object","sap/ui/thirdparty/jquery","sap/base/Log"],function(E,B,q,L){"use strict";
var S=B.extend("sap.ui.generic.app.navigation.service.SelectionVariant",{
_rVALIDATE_SIGN:new RegExp("[E|I]"),
_rVALIDATE_OPTION:new RegExp("EQ|NE|LE|GE|LT|GT|BT|CP"),
constructor:function(s){this._mParameters={};this._mSelectOptions={};this._sId="";if(s!==undefined){if(typeof s==="string"){this._parseFromString(s);}else if(typeof s==="object"){this._parseFromObject(s);}else{throw new E("SelectionVariant.INVALID_INPUT_TYPE");}}},
getID:function(){return this._sId;},
setID:function(i){this._sId=i;},
setText:function(n){if(typeof n!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}this._sText=n;},
getText:function(){return this._sText;},
setParameterContextUrl:function(u){if(typeof u!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}this._sParameterCtxUrl=u;},
getParameterContextUrl:function(){return this._sParameterCtxUrl;},
getFilterContextUrl:function(){return this._sFilterCtxUrl;},
setFilterContextUrl:function(u){if(typeof u!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}this._sFilterCtxUrl=u;},
addParameter:function(n,v){if(typeof n!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}if(typeof v!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}if(n===""){throw new E("SelectionVariant.PARAMETER_WITHOUT_NAME");}if(this._mSelectOptions[n]){throw new E("SelectionVariant.PARAMETER_SELOPT_COLLISION");}this._mParameters[n]=v;return this;},
removeParameter:function(n){if(typeof n!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}if(n===""){throw new E("SelectionVariant.PARAMETER_WITHOUT_NAME");}delete this._mParameters[n];return this;},
renameParameter:function(n,N){if(typeof n!=="string"||typeof N!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}if(n===""||N===""){throw new E("SelectionVariant.PARAMETER_WITHOUT_NAME");}if(this._mParameters[n]!==undefined){if(this._mSelectOptions[N]){throw new E("SelectionVariant.PARAMETER_SELOPT_COLLISION");}if(this._mParameters[N]){throw new E("SelectionVariant.PARAMETER_COLLISION");}this._mParameters[N]=this._mParameters[n];delete this._mParameters[n];}return this;},
getParameter:function(n){if(typeof n!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}return this._mParameters[n];},
getParameterNames:function(){return Object.keys(this._mParameters);},
addSelectOption:function(p,s,o,l,h){if(typeof p!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}if(p===""){throw new E("SelectionVariant.INVALID_PROPERTY_NAME");}if(typeof s!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}if(typeof o!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}if(typeof l!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}if(o==="BT"&&typeof h!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}if(!this._rVALIDATE_SIGN.test(s.toUpperCase())){throw new E("SelectionVariant.INVALID_SIGN");}if(!this._rVALIDATE_OPTION.test(o.toUpperCase())){throw new E("SelectionVariant.INVALID_OPTION");}if(this._mParameters[p]){throw new E("SelectionVariant.PARAMETER_SELOPT_COLLISION");}if(o!=="BT"){if((h!==undefined)&&(h!=="")&&(h!==null)){throw new E("SelectionVariant.HIGH_PROVIDED_THOUGH_NOT_ALLOWED");}}if(this._mSelectOptions[p]===undefined){this._mSelectOptions[p]=[];}var e={Sign:s.toUpperCase(),Option:o.toUpperCase(),Low:l};if(o==="BT"){e.High=h;}else{e.High=null;}for(var i=0;i<this._mSelectOptions[p].length;i++){var a=this._mSelectOptions[p][i];if(a.Sign===e.Sign&&a.Option===e.Option&&a.Low===e.Low&&a.High===e.High){return this;}}this._mSelectOptions[p].push(e);return this;},
removeSelectOption:function(n){if(typeof n!=="string"){throw new E("SelectionVariant.SELOPT_WRONG_TYPE");}if(n===""){throw new E("SelectionVariant.SELOPT_WITHOUT_NAME");}delete this._mSelectOptions[n];return this;},
renameSelectOption:function(n,N){if(typeof n!=="string"||typeof N!=="string"){throw new E("SelectionVariant.SELOPT_WRONG_TYPE");}if(n===""||N===""){throw new E("SelectionVariant.SELOPT_WITHOUT_NAME");}if(this._mSelectOptions[n]!==undefined){if(this._mSelectOptions[N]){throw new E("SelectionVariant.SELOPT_COLLISION");}if(this._mParameters[N]){throw new E("SelectionVariant.PARAMETER_SELOPT_COLLISION");}this._mSelectOptions[N]=this._mSelectOptions[n];delete this._mSelectOptions[n];}return this;},
getSelectOption:function(p){if(typeof p!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}if(p===""){throw new E("SelectionVariant.INVALID_PROPERTY_NAME");}var e=this._mSelectOptions[p];if(!e){return undefined;}return JSON.parse(JSON.stringify(e));},
getSelectOptionsPropertyNames:function(){return Object.keys(this._mSelectOptions);},
getPropertyNames:function(){return this.getParameterNames().concat(this.getSelectOptionsPropertyNames());},
massAddSelectOption:function(p,s){if(!Array.isArray(s)){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}for(var i=0;i<s.length;i++){var o=s[i];this.addSelectOption(p,o.Sign,o.Option,o.Low,o.High);}return this;},
getValue:function(n){var v=this.getSelectOption(n);if(v!==undefined){return v;}var p=this.getParameter(n);if(p!==undefined){v=[{Sign:"I",Option:"EQ",Low:p,High:null}];return v;}return undefined;},
isEmpty:function(){return this.getParameterNames().length===0&&this.getSelectOptionsPropertyNames().length===0;},
toJSONObject:function(){var e={Version:{Major:"1",Minor:"0",Patch:"0"},SelectionVariantID:this._sId};if(this._sParameterCtxUrl){e.ParameterContextUrl=this._sParameterCtxUrl;}if(this._sFilterCtxUrl){e.FilterContextUrl=this._sFilterCtxUrl;}if(this._sText){e.Text=this._sText;}else{e.Text="Selection Variant with ID "+this._sId;}this._determineODataFilterExpression(e);this._serializeParameters(e);this._serializeSelectOptions(e);return e;},
toJSONString:function(){return JSON.stringify(this.toJSONObject());},
_determineODataFilterExpression:function(e){e.ODataFilterExpression="";},
_serializeParameters:function(e){if(this._mParameters.length===0){return;}e.Parameters=[];q.each(this._mParameters,function(p,P){var o={PropertyName:p,PropertyValue:P};e.Parameters.push(o);});},
_serializeSelectOptions:function(e){if(this._mSelectOptions.length===0){return;}e.SelectOptions=[];q.each(this._mSelectOptions,function(p,a){var s={PropertyName:p,Ranges:a};e.SelectOptions.push(s);});},
_parseFromString:function(j){if(j===undefined){throw new E("SelectionVariant.UNABLE_TO_PARSE_INPUT");}if(typeof j!=="string"){throw new E("SelectionVariant.INVALID_INPUT_TYPE");}var i=JSON.parse(j);this._parseFromObject(i);},
_parseFromObject:function(i){if(i.SelectionVariantID===undefined){L.warning("SelectionVariantID is not defined");i.SelectionVariantID="";}this.setID(i.SelectionVariantID);if(i.ParameterContextUrl!==undefined&&i.ParameterContextUrl!==""){this.setParameterContextUrl(i.ParameterContextUrl);}if(i.FilterContextUrl!==undefined&&i.FilterContextUrl!==""){this.setFilterContextUrl(i.FilterContextUrl);}if(i.Text!==undefined){this.setText(i.Text);}if(i.Parameters){this._parseFromStringParameters(i.Parameters);}if(i.SelectOptions){this._parseFromStringSelectOptions(i.SelectOptions);}},
_parseFromStringParameters:function(p){q.each(p,q.proxy(function(i,e){this.addParameter(e.PropertyName,e.PropertyValue);},this));},
_parseFromStringSelectOptions:function(s){q.each(s,q.proxy(function(i,o){if(!o.Ranges){L.warning("Select Option object does not contain a Ranges entry; ignoring entry");return true;}if(!Array.isArray(o.Ranges)){throw new E("SelectionVariant.SELECT_OPTION_RANGES_NOT_ARRAY");}q.each(o.Ranges,q.proxy(function(I,r){this.addSelectOption(o.PropertyName,r.Sign,r.Option,r.Low,r.High);},this));},this));}
});
return S;},true);
/*
 * SAPUI5

(c) Copyright 2009-2019 SAP SE. All rights reserved
 */
sap.ui.predefine('sap/ui/generic/app/ApplicationController',["sap/ui/thirdparty/jquery","./transaction/BaseController","./transaction/TransactionController","sap/ui/generic/app/util/ModelUtil","sap/base/Log"],function(q,B,T,M,L){"use strict";
var A=B.extend("sap.ui.generic.app.ApplicationController",{constructor:function(m,v){B.apply(this,[m]);this._oGroupChanges={};this.sName="sap.ui.generic.app.ApplicationController";this._initModel(m);this.registerView(v);}});
A.prototype.propertyChanged=function(P,c){var t=this,m={batchGroupId:"Changes",changeSetId:"Changes",onlyIfPending:true,noShowResponse:true,noBlockUI:true,draftSave:true},s,e={};if(c&&c instanceof sap.ui.model.Context){var E=M.getEntitySetFromContext(c);var o=c.getModel().getMetaModel();var a=o.getODataEntitySet(E).entityType;e=o.getODataEntityType(a);}for(var p in e){if(p.startsWith("com.sap.vocabularies.Common.v1.SideEffects")){s=e[p];if(s.SourceProperties&&s.SourceProperties.length){for(var i=0;i<s.SourceProperties.length;i++){if(s.SourceProperties[i].PropertyPath===P){t.registerGroupChange(t._getSideEffectsQualifier(p));}}}}}return new Promise(function(r,b){setTimeout(function(){t.triggerSubmitChanges(m).then(function(R){r(R);},function(d){b(d);});});});};
A.prototype.registerGroupChange=function(g){this._oGroupChanges[g]=true;};
A.prototype.registerView=function(v){var t=this;if(v){this._fnAttachValidateFieldGroup=function(e){var I,o,l,i,a=[];var b=this.getBindingContext();if(!b){return false;}if(!t.getTransactionController().getDraftController().getDraftContext().hasDraft(b)){this.detachValidateFieldGroup(t._fnAttachValidateFieldGroup);return false;}if(e.mParameters.fieldGroupIds){l=e.mParameters.fieldGroupIds.length;}for(i=0;i<l;i++){I=e.mParameters.fieldGroupIds[i];o=v.data(I);if(o){a.push({uuid:I,objid:o});}}t._onValidateFieldGroup(a,v);};v.attachValidateFieldGroup(this._fnAttachValidateFieldGroup);}};
A.prototype._initModel=function(m){if(m.getDefaultBindingMode()!==sap.ui.model.BindingMode.TwoWay){L.error("ApplicationController: The model's DefaultBindingMode wasn't but is now set to 'TwoWay'.");m.setDefaultBindingMode(sap.ui.model.BindingMode.TwoWay);}if(m.getRefreshAfterChange()!==false){L.error("ApplicationController: The model's setting 'RefreshAfterChange' wasn't but is now set to 'false'.");m.setRefreshAfterChange(false);}m.setDeferredBatchGroups(["Changes"]);m.setChangeBatchGroups({"*":{batchGroupId:"Changes",changeSetId:"Changes",single:false}});};
A.prototype._onValidateFieldGroup=function(g,v){var i,l=g.length,r,R={bGlobal:false,aRequests:[]};for(i=0;i<l;i++){this._executeFieldGroup(g[i],R,v);}l=R.aRequests.length;for(i=0;i<l;i++){r=R.aRequests[i];r(R.bGlobal);}if(R.bGlobal){this._oModel.refresh(true,false,"Changes");}var p=this.triggerSubmitChanges({batchGroupId:"Changes",noShowSuccessToast:true,forceSubmit:true,noBlockUI:true,urlParameters:{},draftSave:this._oModel.hasPendingChanges()});this.fireEvent("beforeSideEffectExecution",{promise:p,valueChange:R.bValueChange,validationMessage:R.bValidationMessage,fieldControl:R.bFieldControl});return p;};
A.prototype._executeFieldGroup=function(g,r,v){var s,c,S,p={batchGroupId:"Changes",changeSetId:"SideEffects",noShowSuccessToast:true,forceSubmit:true,noBlockUI:true,urlParameters:{}};s=this._getSideEffectsQualifier(g.objid.name);p.urlParameters.SideEffectsQualifier=s;c=g.objid.contextObject;S=this._getSideEffect(g.objid);if(this._hasClientErrors(g.uuid,v)){return false;}if(!this._oGroupChanges[s]&&!this._oModel.hasPendingChanges()){return false;}this._oGroupChanges[s]=false;this._executeSideEffects(S,c,p,r);return true;};
A.prototype._getSideEffectsQualifier=function(a){var s=a.replace("com.sap.vocabularies.Common.v1.SideEffects","");if(s.indexOf("#")===0){s=s.replace("#","");}return s;};
A.prototype._executeSideEffectsForActions=function(s,c,t){var r;var C="_it/";var R={bGlobal:false,aRequests:[]};var p={batchGroupId:"Changes",changeSetId:"SideEffects",noShowSuccessToast:true,forceSubmit:true,noBlockUI:true,urlParameters:{}};var i=0;if(t===false){p.batchGroupId="NonDraftChanges";}if(s.TargetEntities&&s.TargetEntities.length){for(i=0;i<s.TargetEntities.length;i++){if(s.TargetEntities[i].NavigationPropertyPath.indexOf(C)===0){s.TargetEntities[i].NavigationPropertyPath=s.TargetEntities[i].NavigationPropertyPath.substr(4);}}}if(s.TargetProperties&&s.TargetProperties.length){for(i=0;i<s.TargetProperties.length;i++){if(s.TargetProperties[i].PropertyPath.indexOf(C)===0){s.TargetProperties[i].PropertyPath=s.TargetProperties[i].PropertyPath.substr(4);}}}for(i=0;i<c.length;i++){this._executeSideEffects(s,c[i],p,R);if(R.aRequests[0]){r=R.aRequests[0];r(R.bGlobal);R.aRequests=[];}}if(R.bGlobal){this._oModel.refresh(true,false,p.batchGroupId);}};
A.prototype._executeSideEffects=function(s,c,p,r){var t=this,f,m,a={"ValidationMessage":"validateDraft","ValueChange":"prepareDraft"};if(!s.EffectTypes||!s.EffectTypes.EnumMember){s.EffectTypes={EnumMember:"ValueChange"};}if(t.getTransactionController().getDraftController().getDraftContext().hasDraft(c)){m=a[s.EffectTypes.EnumMember];}r.bValueChange=s.EffectTypes.EnumMember==="ValueChange"?true:r.bValueChange;r.bValidationMessage=s.EffectTypes.EnumMember==="ValidationMessage"?true:r.bValidationMessage;r.bFieldControl=s.EffectTypes.EnumMember==="FieldControlChange"?true:r.bFieldControl;this._setSelect(s,p,r,c);f=function(g){if(m){t.getTransactionController().getDraftController()[m](c,p);}if(!g){var R=q.extend({},p);R.context=c;t._read("",R);}};r.aRequests.push(f);};
A.prototype._hasClientErrors=function(g,v){var i,l,c,C;C=v.getControlsByFieldGroupId(g);if(C){l=C.length;for(i=0;i<l;i++){c=C[i];if(c&&c.getParent){c=c.getParent();if(c&&c.checkClientError&&c.checkClientError()){return true;}}}}return false;};
A.prototype._setSelect=function(s,p,r,c){var i,l=0,t,S=[],e=[],a=[],n;if(!r.bGlobal){if((!s.TargetEntities||s.TargetEntities.length===0)&&(!s.TargetProperties||s.TargetProperties.length===0)){r.bGlobal=true;return;}if(s.TargetEntities){l=s.TargetEntities.length;if(l>0){for(i=0;i<l;i++){t=s.TargetEntities[i];if(t.NavigationPropertyPath===""){S.push('*');}else{S.push(t.NavigationPropertyPath);if(e.indexOf(t.NavigationPropertyPath)===-1){e.push(t.NavigationPropertyPath);}}a.push(t.NavigationPropertyPath);}}}if(s.TargetProperties){l=s.TargetProperties.length;if(l>0){for(i=0;i<l;i++){t=s.TargetProperties[i];n="";if(t.PropertyPath.indexOf("/")!==-1){var E=M.getEntitySetFromContext(c);var m=this._oModel.getMetaModel();var b=m.getODataEntitySet(E).entityType;var o=m.getODataEntityType(b);var P=t.PropertyPath.split("/");var d;if(P.length>1){for(var j=0;j<(P.length-1);j++){d=m.getODataAssociationEnd(o,P[j]);if(d){o=m.getODataEntityType(d.type);if(n){n=n+"/";}n=n+P[j];}else{break;}}}}if(a.indexOf(n)===-1){if(n&&e.indexOf(n)===-1){e.push(n);}S.push(t.PropertyPath);}}}}}if(S.length>0){p.readParameters=["$select="+S.join(",")];if(e.length>0){p.readParameters.push("$expand="+e.join(','));}}};
A.prototype._getSideEffect=function(i){var m,r,s,f;m=this._oModel.getMetaModel();s="getOData"+i.originType.substring(0,1).toUpperCase()+i.originType.substring(1);if(i.originNamespace){f=i.originNamespace+"."+i.originName;}else{f=i.originName;}if(m[s]){r=m[s](f);if(r){return r[i.name];}}throw"Unknown SideEffect originType: "+i.originType;};
A.prototype.getTransactionController=function(){if(!this._oTransaction){this._oTransaction=new T(this._oModel,this._oQueue,{noBatchGroups:true});}return this._oTransaction;};
A.prototype.invokeActions=function(f,c,P){var C,i,l,a,b=[],s;P=P||{};l=c.length;a=this._getChangeSetFunc(f,c,P.operationGrouping);if(l===0){b.push(this._invokeAction(f,null,null,P));}else{for(i=0;i<l;i++){b.push(this._invokeAction(f,c[i],a(i),P));}}var F=this._oModel.getMetaModel().getODataFunctionImport(f);for(var p in F){if(p.startsWith("com.sap.vocabularies.Common.v1.SideEffects")){s=F[p];break;}}if(s){this._executeSideEffectsForActions(s,c,P.triggerChanges);}if(P.triggerChanges!==false){P={batchGroupId:"Changes",changeSetId:"Action"+a(i+1),successMsg:"Call of action succeeded",failedMsg:"Call of action failed",forceSubmit:true,context:C};b.push(this.triggerSubmitChanges(P));}return this._newPromiseAll(b).then(function(r){var i,d=false;if(r&&P.triggerChanges!==false&&r.length>c.length){r.pop();}if(c.length<=r.length){for(i=0;i<c.length;i++){r[i].actionContext=c[i];if(!r[i].error){d=true;}}if(c.length===0){for(i=0;i<r.length;i++){if(!r[i].error){d=true;}}}}if(d){return r;}else{return Promise.reject(r);}});};
A.prototype.executeSideEffects=function(c,s,S,f){var o,n,P,e,r,Q;var b=false;var g=!s&&!S;var R={bGlobal:false,aRequests:[]};var m={batchGroupId:"Changes",changeSetId:"SideEffects",noShowSuccessToast:true,forceSubmit:true,noBlockUI:true,urlParameters:{}};var E=M.getEntitySetFromContext(c);var a=c.getModel().getMetaModel();var d=a.getODataEntitySet(E).entityType;var h=a.getODataEntityType(d);var i=0;f=!(f===false);S=S||[];s=s||[];var j=function(o){if(Q){m.urlParameters.SideEffectsQualifier=Q;}else{delete m.urlParameters.SideEffectsQualifier;}this._executeSideEffects(o,c,m,R);if(R.aRequests[0]){r=R.aRequests[0];r(R.bGlobal);R.aRequests=[];}}.bind(this);for(var p in h){if(p.startsWith("com.sap.vocabularies.Common.v1.SideEffects")){o=h[p];e=false;Q=this._getSideEffectsQualifier(p);if(g){if(!o.SourceProperties&&!o.SourceEntities){j(o);e=true;b=true;break;}}else{if(o.SourceEntities&&o.SourceEntities.length){for(i=0;i<o.SourceEntities.length;i++){n=o.SourceEntities[i].NavigationPropertyPath;if(S.indexOf(n)!==-1){e=true;}}}if(!e&&o.SourceProperties&&o.SourceProperties.length){for(i=0;i<o.SourceProperties.length;i++){P=o.SourceProperties[i].PropertyPath;if(s.indexOf(P)!==-1){e=true;}}}if(e){j(o);b=true;}}}}if(R.bGlobal||(g&&!e)){if(g){j({});b=true;}if(f){this._oModel.refresh(true,false,"Changes");b=true;}}var k=null;if(b){k=this.triggerSubmitChanges({batchGroupId:"Changes",noShowSuccessToast:true,forceSubmit:true,noBlockUI:true,urlParameters:{},draftSave:this._oModel.hasPendingChanges()});}else{k=Promise.resolve();}this.fireEvent("beforeSideEffectExecution",{promise:k,valueChange:R.bValueChange,validationMessage:R.bValidationMessage,fieldControl:R.bFieldControl});return k;};
A.prototype._newPromiseAll=function(p){var r=[];var R=Promise.resolve(null);p.forEach(function(P){R=R.then(function(){return P;}).then(function(o){r.push({response:o});},function(e){r.push({error:e});});});return R.then(function(){return Promise.resolve(r);});};
A.prototype._getChangeSetFunc=function(f,c,o){var l=c.length;var s=function(){return"Changes";};if(l===1){return s;}if(o==="com.sap.vocabularies.UI.v1.OperationGroupingType/ChangeSet"){return s;}return function(i){return"Changes"+i;};};
A.prototype.getNewActionContext=function(f,e,p){var t=this;p=q.extend({batchGroupId:"Changes",changeSetId:"SingleAction",successMsg:"Call of action succeeded",failedMsg:"Call of action failed",forceSubmit:true,context:e,functionImport:this._oMeta.getODataFunctionImport(f.split("/")[1])},p);var F=this._createFunctionContext(e,p);F.result=F.result.then(function(r){return t._normalizeResponse(r,true);},function(r){var o=t._normalizeError(r);throw o;});return F;};
A.prototype.submitActionContext=function(e,a,f){var s;var F=this._oModel.getMetaModel().getODataFunctionImport(f);for(var p in F){if(p.startsWith("com.sap.vocabularies.Common.v1.SideEffects")){s=F[p];break;}}if(s){this._executeSideEffectsForActions(s,[e]);}this.triggerSubmitChanges({batchGroupId:"Changes",successMsg:"Call of action succeeded",failedMsg:"Call of action failed",forceSubmit:true,context:a});};
A.prototype._invokeAction=function(f,c,C,p){var t=this;var P={batchGroupId:"Changes",changeSetId:C,successMsg:"Call of action succeeded",failedMsg:"Call of action failed",urlParameters:p.urlParameters,forceSubmit:true,context:c};if(p.triggerChanges===false){P.batchGroupId="NonDraftChanges";}return this._callAction(f,c,P).then(function(r){return t._normalizeResponse(r,true);},function(r){var o=t._normalizeError(r);throw o;});};
A.prototype.destroy=function(){B.prototype.destroy.apply(this,[]);if(this._oTransaction){this._oTransaction.destroy();}this._oModel=null;this._oTransaction=null;this._oGroupChanges=null;};
return A;},true);
sap.ui.predefine('sap/ui/generic/app/library',['sap/ui/core/library'],function(l){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.generic.app",version:"1.71.34",dependencies:["sap.ui.core"],types:["sap.ui.generic.app.navigation.service.NavType","sap.ui.generic.app.navigation.service.ParamHandlingMode","sap.ui.generic.app.navigation.service.SuppressionBehavior"],interfaces:[],controls:[],elements:[],noLibraryCSS:true});sap.ui.generic.app.navigation.service.ParamHandlingMode={SelVarWins:"SelVarWins",URLParamWins:"URLParamWins",InsertInSelOpt:"InsertInSelOpt"};sap.ui.generic.app.navigation.service.NavType={initial:"initial",URLParams:"URLParams",xAppState:"xAppState",iAppState:"iAppState"};sap.ui.generic.app.navigation.service.SuppressionBehavior={standard:0,ignoreEmptyString:1,raiseErrorOnNull:2,raiseErrorOnUndefined:4};sap.ui.lazyRequire("sap.ui.generic.app.AppComponent","new extend getMetadata");return sap.ui.generic.app;},false);
sap.ui.predefine('sap/ui/generic/app/navigation/service/NavError',["sap/ui/base/Object"],function(B){"use strict";
var N=B.extend("sap.ui.generic.app.navigation.service.NavError",{
metadata:{publicMethods:["getErrorCode"],properties:{},library:"sap.ui.generic.app"},
constructor:function(e){B.apply(this);this._sErrorCode=e;}
});
N.prototype.getErrorCode=function(){return this._sErrorCode;};
return N;});
sap.ui.predefine('sap/ui/generic/app/transaction/BaseController',["sap/ui/base/EventProvider","sap/ui/generic/app/util/ModelUtil","sap/ui/generic/app/util/DraftUtil","sap/ui/generic/app/util/Queue","sap/base/Log"],function(E,M,D,Q,L){"use strict";
var B=E.extend("sap.ui.generic.app.transaction.BaseController",{
metadata:{publicMethods:["hasClientMessages","triggerSubmitChanges","attachFatalError","detachFatalError","destroy"]},
constructor:function(m,q){if(!m){throw new Error("No model");}if(m.bUseBatch==false){L.error("sap.ui.generic.app.transaction.BaseController: Only ODataModel with batch mode enabled are supported!");B.prototype.NonBatchEventHandlers={};m.attachRequestCompleted(function(e){var r=e.getParameters().ID;var o=B.prototype.NonBatchEventHandlers[r];if(o&&e.getParameters().success){o.success();delete B.prototype.NonBatchEventHandlers[r];}else if(o&&!e.getParameters().success){o.error();delete B.prototype.NonBatchEventHandlers[r];}});}E.apply(this,arguments);this.sName="sap.ui.generic.app.transaction.BaseController";this._oModel=m;this._oMeta=m.getMetaModel();this._oDraftUtil=new D();this._oModelUtil=new M(m);if(q){this._oQueue=q;}else{this._oQueue=new Q();this._bOwnsQueue=true;}this._initCounts();}
});
B.prototype.attachFatalError=function(f,l){this.attachEvent("fatalError",f,l);};
B.prototype.detachFatalError=function(f,l){this.detachEvent("fatalError",f,l);};
B.prototype._prepareCallAction=function(f,c,p){var e,o,a,s,k;if(!f){throw new Error("Invalid Function Import");}p.urlParameters=p.urlParameters||{};p.functionImport=this._oMeta.getODataFunctionImport(f.split("/")[1]);if(!p.functionImport){throw new Error("Unknown Function Import "+f);}if(c){s=M.getEntitySetFromContext(c);e=this._oMeta.getODataEntitySet(s,false);o=this._oMeta.getODataEntityType(e.entityType,false);k=o.key.propertyRef;a=c.getObject();}if(a){this._getActionParameters(a,p,k);this._getAdditionalActionParameters(a,p,k);this._getActionRequestHeaders(c,a,p);}return p;};
B.prototype._callAction=function(f,c,p){var t=this;if(!p.urlParameters||!p.functionImport){p=this._prepareCallAction(f,c,p);}return new Promise(function(r,a){var F,C;F="/"+p.functionImport.name;C=t._getRequestCallbacks(r,a);t._oModel.callFunction(F,{method:p.functionImport.httpMethod,urlParameters:p.urlParameters,success:C.success,error:C.error,batchGroupId:p.batchGroupId,changeSetId:p.changeSetId,headers:p.headers});});};
B.prototype._createFunctionContext=function(c,p){var a={};var C;var h;var t=this;a.result=new Promise(function(r,R){C=t._getRequestCallbacks(r,R);});this._getActionRequestHeaders(c,c.getObject(),p);h=this._oModel.callFunction("/"+p.functionImport.name,{method:p.functionImport.httpMethod,urlParameters:p.urlParameters,success:C.success,error:C.error,batchGroupId:p.batchGroupId,changeSetId:p.changeSetId,headers:p.headers,eTag:t._oModel.getETag(c.getPath())});a.context=h.contextCreated();a.abort=h.abort;return a;};
B.prototype._getActionRequestHeaders=function(c,e,p){var s;if(!p.headers){p.headers={};}if(!p.headers["If-Match"]&&p.functionImport["sap:action-for"]){s=this._oModel.getETag(null,c,e);if(s){p.headers["If-Match"]=s;}}};
B.prototype._getActionParameters=function(e,p,k){var i,a,l=k.length,A={},s;s=p.functionImport["sap:action-for"];a=function(P){if(p.functionImport.parameter){var j,b=p.functionImport.parameter.length;for(j=0;j<b;j++){if(p.functionImport.parameter[j].name===P){return true;}}}return false;};if(!p.functionImport.parameter&&s){L.error("Action doesn't have any parameters");throw new Error("Action doesn't have any parameters");}for(i=0;i<l;i++){if(a(k[i].name)){p.urlParameters[k[i].name]=e[k[i].name];}else if(s&&(k[i].name!="IsActiveEntity"||k[i].name!="DraftUUID")){L.error("Action does not contain a equally-named parameter for key property: "+k[i].name);throw new Error("Action does not contain a equally-named parameter for key property: "+k[i].name);}}return A;};
B.prototype._getAdditionalActionParameters=function(e,p,k){var j,l=0,P;var I=function(s){var i=0,a=k.length;for(i=0;i<a;i++){if(k[i].name===s){return true;}}return false;};if(p.functionImport.parameter){l=p.functionImport.parameter.length;}if(l>k.length){for(j=0;j<l;j++){P=p.functionImport.parameter[j];if(!I(P.name)){var n=(P.nullable==="true")?true:false;if(!p.urlParameters.hasOwnProperty(P.name)&&!n){L.error("Unknown parameter "+P.name);throw new Error("Unknown parameter "+P.name);}}}}};
B.prototype._read=function(p,P){var t=this;return new Promise(function(r,a){var c,u;if(P.readParameters){u=P.readParameters;}else if(P.urlParameters){u=P.urlParameters;}c=t._getRequestCallbacks(r,a);t._oModel.read(p,{context:P.context,success:c.success,error:c.error,batchGroupId:P.batchGroupId,changeSetId:P.changeSetId,urlParameters:u});});};
B.prototype._remove=function(p,P){var t=this;return new Promise(function(r,a){var c=t._getRequestCallbacks(r,a);t._oModel.remove(p,{success:c.success,error:c.error,eTag:"*",batchGroupId:P.batchGroupId,changeSetId:P.changeSetId});});};
B.prototype._syncRemove=function(p,P,s,e){var c=this._getRequestCallbacks(s,e);return this._oModel.remove(p,{success:c.success,error:c.error,eTag:"*",batchGroupId:P.batchGroupId,changeSetId:P.changeSetId});};
B.prototype._submitChanges=function(p){var t=this;if(!this._checkSubmit(p)){return Promise.resolve({context:p&&p.context});}if(this._oModel.bUseBatch==true){return new Promise(function(r,a){var c=t._getRequestCallbacks(r,a);t._oModel.submitChanges({batchGroupId:p.batchGroupId,success:c.success,error:c.error,eTag:p.eTag});});}else{return new Promise(function(r,a){var c=t._getRequestCallbacks(r,a);if(p.batchGroupId&&this._oModel.mDeferredRequests&&this._oModel.mDeferredRequests[p.batchGroupId]&&this._oModel.mDeferredRequests[p.batchGroupId].changes){var C=this._oModel.mDeferredRequests[p.batchGroupId].changes[p.changeSetId]||[];for(var i=0;i<C.length;i++){if(C[i].request._aborted==undefined||C[i].request._aborted==false){B.prototype.NonBatchEventHandlers[C[i].request.requestID]={"success":c.success,"error":c.error};}}}if(p.batchGroupId&&this._oModel.mDeferredRequests&&this._oModel.mDeferredRequests[p.batchGroupId]&&this._oModel.mDeferredRequests[p.batchGroupId].requests){var R=this._oModel.mDeferredRequests[p.batchGroupId].requests;for(var i=0;i<R.length;i++){if(R[i].request._aborted==undefined||R[i].request._aborted==false){B.prototype.NonBatchEventHandlers[R[i].request.requestID]={"success":c.success,"error":c.error};}}}t._oModel.submitChanges({batchGroupId:p.batchGroupId,eTag:p.eTag});}.bind(this));}};
B.prototype._checkSubmit=function(p){if(this._oModel.hasPendingChanges()){p.pendingChanges=true;return true;}if(p.forceSubmit&&p.forceSubmit==true){if(p.batchGroupId&&this._oModel.mDeferredRequests&&this._oModel.mDeferredRequests[p.batchGroupId]&&this._oModel.mDeferredRequests[p.batchGroupId].changes){var c=this._oModel.mDeferredRequests[p.batchGroupId].changes;var C=[];var a=[];var b;for(var k in c){if(c.hasOwnProperty(k)){C.push(k);}}for(var i=0;i<C.length;i++){b=this._oModel.mDeferredRequests[p.batchGroupId].changes[C[i]]||[];a=a.concat(b);}for(var i=0;i<a.length;i++){if(a[i].request._aborted==undefined||a[i].request._aborted==false){return true;}}}if(p.batchGroupId&&this._oModel.mDeferredRequests&&this._oModel.mDeferredRequests[p.batchGroupId]&&this._oModel.mDeferredRequests[p.batchGroupId].requests){var r=this._oModel.mDeferredRequests[p.batchGroupId].requests||[];for(var i=0;i<r.length;i++){if(r[i].request._aborted==undefined||r[i].request._aborted==false){return true;}}}}return false;};
B.prototype.triggerSubmitChanges=function(p){var t=this,f,r;p=p||{};p.successMsg=p.successMsg||"Action succeeded";p.failedMsg=p.failedMsg||"Action failed";r=function(e){t.fireEvent("fatalError",{response:e});throw e;};f=function(){return t._submitChanges(p).then(function(R){var _=function(R,p){try{t._checkImplicitError({httpResponse:R,responseData:R.data},p);return t._normalizeResponse({httpResponse:R,responseData:R.data},true);}catch(e){r(e);}};var b;var c;var n=[];if(R&&R.responseData&&R.responseData.__batchResponses){if(R.responseData.__batchResponses.length==1&&R.responseData.__batchResponses[0].__changeResponses&&R.responseData.__batchResponses[0].__changeResponses.length==1){return _(R.responseData.__batchResponses[0].__changeResponses[0],p);}for(var i=0;i<R.responseData.__batchResponses.length;i++){b=R.responseData.__batchResponses[i];if(b.__changeResponses){for(var j=0;j<b.__changeResponses.length;j++){c=b.__changeResponses[j];n.push(_(c,p));}}else{return _(b,p);}}}else{try{t._checkImplicitError(R,p);return t._normalizeResponse(R,true);}catch(e){r(e);}}return n;},function(R){var o=t._normalizeError(R);r(o);});};return this._oQueue.enqueue(f,{draftSave:p.draftSave});};
B.prototype.addOperationToQueue=function(f,e){this._oQueue.enqueue(f,e);};
B.prototype.attachBeforeQueueItemProcess=function(f){this._oQueue._attachEvent('beforeQueueItemProcess',f);};
B.prototype.detachBeforeQueueItemProcess=function(f){this._oQueue._detachEvent('beforeQueueItemProcess',f);};
B.prototype.attachOnQueueCompleted=function(f){this._oQueue._attachEvent('onQueueCompleted',f);};
B.prototype.detachOnQueueCompleted=function(f){this._oQueue._detachEvent('onQueueCompleted',f);};
B.prototype.attachOnQueueFailed=function(f){this._oQueue._attachEvent('onQueueFailed',f);};
B.prototype.detachOnQueueFailed=function(f){this._oQueue._detachEvent('onQueueFailed',f);};
B.prototype.hasClientMessages=function(){if(this._oModelUtil.hasClientMessages()){return Promise.reject(new Error("Client messages detected"));}return null;};
B.prototype._normalizeResponse=function(r,c){if(r&&(r.httpResponse||r.responseData)){return{data:r.responseData,response:r.httpResponse||null,context:c?this._oModelUtil.getContextFromResponse(r.responseData):null};}return r;};
B.prototype._normalizeError=function(r){if(r&&r.message){return{response:r};}return r;};
B.prototype._returnPromiseAll=function(p){return Promise.all(p).then(function(r){if(r.length){return r[0];}return r;});};
B.prototype._atLeastOnePromiseResolved=function(p,d){var r=[];var R=Promise.resolve(null);var a=false;var P=p.length;var f=function(o){if(!d){r.push(o);a=true;}else if(P-1>r.length&&d){r.push(o);a=true;}};p.forEach(function(o,i){R=R.then(function(){return o;}).then(f,function(e){r.push(e);},this);});return R.then(function(){if(a){return Promise.resolve(r);}else{return Promise.reject(r);}});};
B.prototype._checkImplicitError=function(r,p){var P,o,s,c=false;if(this._mCounts.requestSent===1&&this._mCounts.requestCompleted===1){c=true;}this._initCounts();if(p.pendingChanges&&c){if(r&&r.httpResponse){P=r.httpResponse;}if(P&&P.response&&P.response.statusCode){s=parseInt(P.response.statusCode);if(s<200||s>299){o=this._parseError(P);throw this._normalizeError(o);}}}};
B.prototype._parseError=function(p){var r={};if(p.message){r.message=p.message;}if(p.response){r.statusCode=p.response.statusCode;r.statusText=p.response.statusText;r.headers=p.response.headers;r.responseText=p.response.body;}return r;};
B.prototype._initCounts=function(){this._mCounts={requestSent:0,requestCompleted:0};};
B.prototype._getRequestCallbacks=function(r,a){var t=this;this._mCounts.requestSent++;return{success:function(d,R){t._mCounts.requestCompleted++;r({responseData:d,httpResponse:R});},error:function(R){t._mCounts.requestCompleted++;a(R);}};};
B.prototype.destroy=function(){if(this._oModelUtil){this._oModelUtil.destroy();}if(this._oQueue&&this._bOwnsQueue){this._oQueue.destroy();}this._oModel=null;this._oMeta=null;this._oDraftUtil=null;this._oModelUtil=null;};
return B;},true);
sap.ui.predefine('sap/ui/generic/app/transaction/DraftContext',["sap/ui/base/Object","sap/ui/generic/app/util/ModelUtil"],function(B,M){"use strict";
var D=B.extend("sap.ui.generic.app.transaction.DraftContext",{
metadata:{publicMethods:["isDraftEnabled","isDraftRoot","hasDraft","hasDraftRoot","hasDraftValidationFunction","hasDraftPreparationAction","isTechnicalKey","isSemanticKey","getSemanticKey","checkUpdateOnChange","getODataDraftFunctionImportName","hasDraftAdministrativeData","hasSiblingEntity","destroy","hasPreserveChanges"]},
constructor:function(m){if(!m){throw new Error("No model");}this._oModel=m;this._oMeta=m.getMetaModel();this._oModelUtil=new M(m);return this.getInterface();}
});
D.prototype.isDraftEnabled=function(e){var d=this._getODataDraftEntitySet(e);return!!(d&&d.isDraft);};
D.prototype.isDraftRoot=function(e){var d=this._getODataDraftEntitySet(e);return!!(d&&d.isRoot);};
D.prototype.hasDraft=function(c){var e=M.getEntitySetFromContext(c);if(e==null){return false;}return this.isDraftEnabled(e);};
D.prototype.hasDraftRoot=function(c){var e=M.getEntitySetFromContext(c);return this.isDraftRoot(e);};
D.prototype.hasDraftValidationFunction=function(c){return!!this.getODataDraftFunctionImportName(c,"ValidationFunction");};
D.prototype.hasDraftPreparationAction=function(c){return!!this.getODataDraftFunctionImportName(c,"PreparationAction");};
D.prototype.isTechnicalKey=function(e,k){var E,o,K,i,s;if(!e){throw new Error("No entity set");}E=this._oMeta.getODataEntitySet(e);o=this._oMeta.getODataEntityType(E.entityType);K=o.key.propertyRef.length;if(Object.keys(k).length!==K){return false;}for(i=0;i<K;i++){s=o.key.propertyRef[i].name;if(!k[s]){return false;}}return true;};
D.prototype.isSemanticKey=function(e,k){var s,i,l;if(this.isDraftEnabled(e)){s=this.getSemanticKey(e);l=s.length;for(i=0;i<l;i++){if(!k[s[i].name]){return false;}}return true;}return false;};
D.prototype.getSemanticKey=function(e){var E,o,s,S=[],i,l;if(!e){throw new Error("No entity set");}E=this._oMeta.getODataEntitySet(e);o=this._oMeta.getODataEntityType(E.entityType);s=o["com.sap.vocabularies.Common.v1.SemanticKey"];if(s){l=s.length;for(i=0;i<l;i++){S.push({name:s[i].PropertyPath});}}return S;};
D.prototype.getODataDraftFunctionImportName=function(c,d){var e,o;e=M.getEntitySetFromContext(c);o=this._getODataDraftEntitySet(e);if(o.oDraft[d]&&o.oDraft[d].String){return o.oDraft[d].String;}return null;};
D.prototype._getODataDraftEntitySet=function(e){var o={},E;if(!e){throw new Error("No entity set");}E=this._oMeta.getODataEntitySet(e);o.ODataEntitySet=E;if(E["com.sap.vocabularies.Common.v1.DraftRoot"]){o.isDraft=true;o.isRoot=true;o.oDraft=E["com.sap.vocabularies.Common.v1.DraftRoot"];}else if(E["com.sap.vocabularies.Common.v1.DraftNode"]){o.isDraft=true;o.isRoot=false;o.oDraft=E["com.sap.vocabularies.Common.v1.DraftNode"];}return o;};
D.prototype.hasDraftAdministrativeData=function(e){return this._hasNavigationProperty(e,"DraftAdministrativeData");};
D.prototype.hasSiblingEntity=function(e){return this._hasNavigationProperty(e,"SiblingEntity");};
D.prototype._hasNavigationProperty=function(e,n){var E,o,i,l;E=this._oMeta.getODataEntitySet(e);o=this._oMeta.getODataEntityType(E.entityType);if(o.navigationProperty){l=o.navigationProperty.length;for(i=0;i<l;i++){if(o.navigationProperty[i].name===n){return true;}}}return false;};
D.prototype.checkUpdateOnChange=function(e,p){var P,E,s;if(!e){throw new Error("No entity set");}E=this._oMeta.getODataEntitySet(e);for(P in E){if(P.indexOf&&P.indexOf("com.sap.vocabularies.Common.v1.SideEffects")===0){s=E[P];if(s.SourceProperties&&s.SourceProperties.length){if(s.SourceProperties.length===1&&s.SourceProperties[0].PropertyPath){if(s.SourceProperties[0].PropertyPath===p){return true;}}}}}return false;};
D.prototype.hasPreserveChanges=function(c){var e=this._oMeta.getODataFunctionImport(this.getODataDraftFunctionImportName(c,"EditAction"));if(e&&e.parameter){for(var i=0;i<e.parameter.length;i++){var p=e.parameter[i];if(p.mode==='In'&&p.name==="PreserveChanges"){return true;}}}return false;};
D.prototype.destroy=function(){if(this._oModelUtil){this._oModelUtil.destroy();}this._oModelUtil=null;this._oModel=null;this._oMeta=null;};
return D;},true);
sap.ui.predefine('sap/ui/generic/app/transaction/DraftController',["sap/ui/thirdparty/jquery","./BaseController","./DraftContext","sap/base/Log"],function(q,B,D,L){"use strict";
var a=B.extend("sap.ui.generic.app.transaction.DraftController",{
metadata:{publicMethods:["getDraftContext","getDraftForActiveEntity","createNewDraftEntity","createEditDraftEntity","validateDraftEntity","validateDraft","prepareDraft","prepareDraftEntity","saveAndPrepareDraftEntity","activateDraftEntity","isActiveEntity","hasActiveEntity","destroy"]},
constructor:function(m,Q){B.apply(this,[m,Q]);this.sName="sap.ui.generic.app.transaction.DraftController";this._oContext=null;}
});
a.prototype.getDraftContext=function(){if(!this._oContext){this._oContext=new D(this._oModel);}return this._oContext;};
a.prototype.createDraft=function(e,p,P){var t=this;if(!e){throw new Error("No entity set");}P=P||{};return new Promise(function(r,b){var s=function(d,R){r({responseData:d,httpResponse:R});};var c;var E=function(o){t._oModel.deleteCreatedEntry(c);b(o);};c=t._oModel.createEntry(p,{properties:P.predefinedValues,success:s,error:E,batchGroupId:P.batchGroupId,changeSetId:P.changeSetId,canonicalRequest:!!P.canonicalRequest});});};
a.prototype.validateDraft=function(c,p){if(!c.getModel().getObject(c.getPath()).IsActiveEntity){var i=this.getDraftContext().getODataDraftFunctionImportName(c,"ValidationFunction");return this._callAction(i,c,p);}else{return Promise.resolve();}};
a.prototype.prepareDraft=function(c,p){if(!c.getModel().getObject(c.getPath()).IsActiveEntity){var i;p=p||{};p.urlParameters=p.urlParameters||{};i=this.getDraftContext().getODataDraftFunctionImportName(c,"PreparationAction");return this._callAction(i,c,p);}else{return Promise.resolve();}};
a.prototype.activateDraft=function(c,p,A){var b=this.prepareDraft(c,p);var i=this.getDraftContext().getODataDraftFunctionImportName(c,"ActivationAction");var d=this._callAction(i,c,A);return Promise.all([b,d]);};
a.prototype.editDraft=function(c,p){var i=this.getDraftContext().getODataDraftFunctionImportName(c,"EditAction");if(i){return this._callAction(i,c,p);}throw new Error(c?"No Edit action defined for the given context":"No context provided for the Edit action");};
a.prototype.discardDraft=function(c,p){if(!c){throw new Error("No context");}return this._remove(c.getPath(),p);};
a.prototype.getDraftForActive=function(c,p){var t=this;if(!c){throw new Error("No context");}p=p||{};p.urlParameters={"$expand":"SiblingEntity"};return this._read(c.getPath(),p).then(function(r){if(r.responseData&&r.responseData.hasOwnProperty("SiblingEntity")){r.context=t._oModel.getContext("/"+t._oModel.getKey(r.responseData.SiblingEntity));return r;}throw new Error("No draft entity could be found");});};
a.prototype.getDraftForActiveEntity=function(c){var p,P,t=this,m={batchGroupId:"Changes",changeSetId:"Changes",noShowSuccessToast:true,forceSubmit:true};p=this.getDraftForActive(c,m).then(function(r){return r;},function(r){throw t._normalizeError(r);});P=this.triggerSubmitChanges(m);return this._returnPromiseAll([p,P]);};
a.prototype.createNewDraftEntity=function(e,p,P,c){var t=this;var i="Changes";var m={predefinedValues:P,batchGroupId:i,changeSetId:i,canonicalRequest:c};var o=this.createDraft(e,p,m).then(function(r){return t._normalizeResponse(r,true);},function(r){var R=t._normalizeError(r);throw R;});var b={batchGroupId:i,changeSetId:i,noShowSuccessToast:true,forceSubmit:true,failedMsg:"New draft document could not be created"};var d=this.triggerSubmitChanges(b).then(function(){return o.then(function(r){var I,h,R,f=t._normalizeResponse(r,true);if(f.context){R=f.context.getObject();}if(!R){L.error("Activate function returned no entity");return Promise.reject(new Error("Activate function returned no entity"));}I=t._oDraftUtil.isActiveEntity(R);if(I){L.error("New draft entity is not marked as draft - isActiveEntity = "+I);return Promise.reject("New draft entity is not marked as draft - isActiveEntity = "+I);}h=t._oDraftUtil.hasDraftEntity(R);if(h){L.error("Wrong value for HasTwin of new draft entity - HasDraftEntity = "+h);return Promise.reject(new Error("Wrong value for HasTwin of new draft entity - HasDraftEntity = "+h));}return f;});});return this._returnPromiseAll([o,d]);};
a.prototype.createEditDraftEntity=function(c,p){var P,o,t=this,m={batchGroupId:"Changes",changeSetId:"Changes",successMsg:"Draft for document was created",failedMsg:"Could not create draft for document",forceSubmit:true,context:c};if(p){m.urlParameters={PreserveChanges:true};}P=this.editDraft(c,m).then(function(r){var i,R,b;b=t._normalizeResponse(r,true);if(b.context){R=b.context.getObject();}if(!R){L.error("Activate function returned no entity");return Promise.reject(new Error("Activate function returned no entity"));}i=t._oDraftUtil.isActiveEntity(R);if(i){L.error("Edit function returned an entity which is not a draft instance - IsActiveEntity = "+i);return Promise.reject(new Error("Returned entity ist not a draft instance - IsActiveEntity = "+i));}return b;},function(r){var R=t._normalizeError(r);throw R;});o=this.triggerSubmitChanges(m);return this._returnPromiseAll([P,o]);};
a.prototype.validateDraftEntity=function(c){var p,P,t=this,m={batchGroupId:"Changes",changeSetId:"Changes",context:c,forceSubmit:true};p=this.validateDraft(c,m).then(function(r){return t._normalizeResponse(r,true);},function(r){var R=t._normalizeError(r);throw R;});P=this.triggerSubmitChanges(m);return this._returnPromiseAll([p,P]);};
a.prototype.saveAndPrepareDraftEntity=function(c,p){var P,o,t=this;p=p||{};p.batchGroupId="Changes";p.changeSetId="Changes";p.successMsg="Saved";p.failedMsg="Save failed";p.context=c;p.forceSubmit=true;P=this.prepareDraft(c,p).then(function(r){var i,R,b;b=t._normalizeResponse(r,true);if(b.context){R=b.context.getObject();}if(!R){L.error("Activate function returned no entity");return Promise.reject(new Error("Activate function returned no entity"));}i=t._oDraftUtil.isActiveEntity(R);if(i){L.error("Prepare function returned an entity which is not a draft instance - IsActiveEntity = "+i);return Promise.reject(new Error("Returned entity ist not a draft instance - IsActiveEntity = "+i));}return b;},function(r){var R=t._normalizeError(r);throw R;});if(p.binding){p.binding.refresh(true,"Changes");}o=this.triggerSubmitChanges(p);return this._returnPromiseAll([P,o]);};
a.prototype.prepareDraftEntity=function(c){var t=this;return this.prepareDraft(c).then(function(r){var R,o;R=t._normalizeResponse(r,true);o=R.context.getObject();if(t._oDraftUtil.isActiveEntity(o)){L.error("Prepare function returned an entity which is not a draft instance - IsActiveEntity = "+true);return Promise.reject(new Error("Returned entity ist not a draft instance - IsActiveEntity = "+true));}return R;},function(r){var R=t._normalizeError(r);throw R;});};
a.prototype.activateDraftEntity=function(c,i){var p,P,t=this,o={batchGroupId:"Changes",successMsg:"Document activated",failedMsg:"Activation of document failed",forceSubmit:true,context:c};var A=q.extend({},o);o.changeSetId="Changes";A.changeSetId="Activation";var h=i?"lenient":"strict";A.headers={Prefer:"handling="+h};p=this.activateDraft(c,o,A).then(function(r){var I,R,b;var d=r[1];b=t._normalizeResponse(d,true);if(b.context){R=b.context.getObject();}if(!R){L.error("Activate function returned no entity");return Promise.reject(new Error("Activate function returned no entity"));}I=t._oDraftUtil.isActiveEntity(R);if(!I){L.error("Activate function returned an entity which is still a draft instance - IsActiveEntity = "+I);return Promise.reject(new Error("Returned entity is still a draft instance - IsActiveEntity = "+I));}return b;},function(r){var R=t._normalizeError(r);throw R;});P=this.triggerSubmitChanges(o);return this._returnPromiseAll([p,P]);};
a.prototype.isActiveEntity=function(c){if(this.getDraftContext().hasDraft(c)){return this._oDraftUtil.isActiveEntity(c.getObject());}return true;};
a.prototype.hasActiveEntity=function(c){return this._oDraftUtil.hasActiveEntity(c.getObject());};
a.prototype.destroy=function(){if(this._oContext){this._oContext.destroy();}this._oContext=null;this._oModel=null;B.prototype.destroy.apply(this,[]);};
return a;},true);
sap.ui.predefine('sap/ui/generic/app/transaction/TransactionController',["sap/ui/thirdparty/jquery","./BaseController","./DraftController","sap/ui/generic/app/util/ModelUtil"],function(q,B,D,M){"use strict";
var T=B.extend("sap.ui.generic.app.transaction.TransactionController",{
metadata:{publicMethods:["destroy","setBatchStrategy","getDraftController","invokeAction","editEntity","deleteEntity","deleteEntities","propertyChanged","hasClientValidationErrors","resetChanges"]},
constructor:function(m,Q,p){B.apply(this,[m,Q]);this.sName="sap.ui.generic.app.transaction.TransactionController";this._oDraft=null;p=p||{};if(!p.noBatchGroups){m.setDeferredGroups(["Changes"]);m.setChangeGroups({"*":{groupId:"Changes",changeSetId:"Changes",single:false}});}return this.getInterface();}
});
T.prototype.setBatchStrategy=function(s){var n,c=this._oModel.getChangeGroups();for(n in c){c[n].single=s;}this._oModel.setChangeGroups(c);};
T.prototype.getDraftController=function(){if(!this._oDraft){this._oDraft=new D(this._oModel,this._oQueue);}return this._oDraft;};
T.prototype.editEntity=function(c,p){var t=this;return new Promise(function(r){var d,e;d=t.getDraftController().getDraftContext();e=M.getEntitySetFromContext(c);if(d.isDraftEnabled(e)&&t._oDraftUtil.isActiveEntity(c.getObject())){return r(t.getDraftController().createEditDraftEntity(c,p));}return r({context:c});});};
T.prototype.deleteEntity=function(e,p){var P,o,t=this,s,c;if(typeof e=="string"){s=e;}else if(typeof e=="object"&&e instanceof sap.ui.model.Context){c=e;s=c.getPath();}p=p||{};q.extend(p,{batchGroupId:"Changes",changeSetId:"Changes",successMsg:"Changes were discarded",failedMsg:"Discarding of changes failed",forceSubmit:true,context:c});P=this._remove(s,p).then(function(r){return t._normalizeResponse(r,true);},function(r){var R=t._normalizeError(r);throw R;});o=this.triggerSubmitChanges(p);return this._returnPromiseAll([P,o]);};
T.prototype.deleteEntities=function(e,p){var P,a=[],t=this,s,c;p=p||{};q.extend(p,{batchGroupId:"Changes",changeSetId:"Changes",successMsg:"Changes were discarded",failedMsg:"Discarding of changes failed",forceSubmit:true});var r=function(o){return t._normalizeResponse(o,true);};var R=function(o){var b=t._normalizeError(o);throw b;};for(var i=0;i<e.length;i++){if(typeof e[i]=="string"){s=e[i];}else if(typeof e[i]=="object"&&e[i]instanceof sap.ui.model.Context){c=e[i];s=c.getPath();}if(t._oModel.getObject(s)&&!t._oDraftUtil.isActiveEntity(t._oModel.getObject(s))){p.changeSetId="Changes";}else{p.changeSetId="ActiveChanges";}P=this._remove(s,p).then(r,R);a.push(P);}P=this.triggerSubmitChanges(p);a.push(P);return this._atLeastOnePromiseResolved(a,true);};
T.prototype.invokeAction=function(f,c,p){var t=this,P,o;P=this.hasClientMessages();if(P){return P;}p={batchGroupId:"Changes",changeSetId:"Changes",successMsg:"Call of action succeeded",failedMsg:"Call of action failed",urlParameters:p.urlParameters,forceSubmit:true,context:c};P=this._callAction(f,c,p).then(function(r){return t._normalizeResponse(r,true);},function(r){var O=t._normalizeError(r);throw O;});this._oModel.refresh(true,false,"Changes");o=this.triggerSubmitChanges(p);return this._returnPromiseAll([P,o]);};
T.prototype.resetChanges=function(k){this._oModel.resetChanges(k);};
T.prototype.propertyChanged=function(e,p,b){var d,c,P={batchGroupId:"Changes",changeSetId:"Changes",binding:b};d=this.getDraftController().getDraftContext();if(d.checkUpdateOnChange(e,p)){c=b.getBoundContext();if(d.hasDraftPreparationAction(c)){return this.getDraftController().saveAndPrepareDraftEntity(c,P);}P.onlyIfPending=true;return this.triggerSubmitChanges(P);}P.onlyIfPending=true;P.noShowResponse=true;P.noBlockUI=true;return this.triggerSubmitChanges(P);};
T.prototype.destroy=function(){B.prototype.destroy.apply(this,[]);if(this._oDraft){this._oDraft.destroy();}this._oDraft=null;};
return T;},true);
sap.ui.predefine('sap/ui/generic/app/util/DraftUtil',[],function(){"use strict";var D=function(){};
D.prototype.isActiveEntity=function(e){return e.IsActiveEntity;};
D.prototype.hasDraftEntity=function(e){return e.HasDraftEntity;};
D.prototype.hasActiveEntity=function(e){return e.HasActiveEntity;};
D.prototype.destroy=function(){};
return D;},true);
sap.ui.predefine('sap/ui/generic/app/util/ModelUtil',[],function(){"use strict";var M=function(m){this._oModel=m;};
M.prototype.getContextFromResponse=function(r){var p="/"+this._oModel.getKey(r);return this._oModel.getContext(p);};
M.getEntitySetFromContext=function(c){var p,e;if(!c){throw new Error("No context");}if(c&&c.getPath){p=c.getPath().split("(")[0];e=p.substring(1);}if(e==null){return null;}else{return c.getModel().getMetaModel().getODataEntitySet(e)&&c.getModel().getMetaModel().getODataEntitySet(e).name;}};
M.prototype.hasClientMessages=function(){var m,o,a,b,i=0,l=0;m=sap.ui.getCore().getMessageManager();o=m.getMessageModel();a=o.getData();if(a){l=a.length;}for(i=0;i<l;i++){b=a[i];if(b.processor.getMetadata()._sClassName==="sap.ui.core.message.ControlMessageProcessor"){return true;}}return false;};
M.prototype.destroy=function(){this._oModel=null;};
return M;},true);
sap.ui.predefine('sap/ui/generic/app/util/Queue',["sap/ui/thirdparty/jquery"],function(q){"use strict";var Q=function(m){this._iMaxLength=m;this._aQueue=[];this._aEventHandlerRegistry=[];};
Q.prototype._attachEvent=function(e,f){if(typeof f!=="function"){throw new Error("Event handler must be a function");}this._aEventHandlerRegistry.push({event:e,handler:f});};
Q.prototype._detachEvent=function(e,f){for(var i=this._aEventHandlerRegistry.length;i--;){if(this._aEventHandlerRegistry[i].handler===f&&this._aEventHandlerRegistry[i].event===e){this._aEventHandlerRegistry.splice(i,1);}}};
Q.prototype._fireEvent=function(e,E){for(var i=0;i<this._aEventHandlerRegistry.length;i++){if(this._aEventHandlerRegistry[i].event===e){this._aEventHandlerRegistry[i].handler(E);}}};
Q.prototype._execNext=function(){var n,t=this;setTimeout(function(){t._aQueue.shift();n=t._aQueue[0];if(n){t._exec(n);}else{t._fireEvent('onQueueCompleted');}});};
Q.prototype._exec=function(i){var t=this,s=function(){t._execNext();};this._fireEvent('beforeQueueItemProcess',i.eventParameters);i.jqdeferred.resolve();i.wait.then(function(){i.wait.then(s);},q.proxy(t._cancel,t));};
Q.prototype.enqueue=function(f,e){var i={fn:f,eventParameters:e};i.jqdeferred=q.Deferred();i.defer=new Promise(function(a,r){i.jqdeferred.then(a,r);});i.wait=i.defer.then(f);if(!(this._iMaxLength===undefined)&&this._aQueue.length>=this._iMaxLength){i.jqdeferred.reject(new Error("Queue overflow: "+this._aQueue.length));}else{this._aQueue.push(i);if(this._aQueue.length===1){this._exec(i);}}return i.wait.then();};
Q.prototype._cancel=function(){var I,i,l=this._aQueue.length;for(i=0;i<l;i++){I=this._aQueue[i];I.jqdeferred.reject(new Error("Queue cancellation"));}this._fireEvent('onQueueFailed');this._aQueue=[];};
Q.prototype.destroy=function(){this._aQueue=[];};
return Q;},true);
sap.ui.require.preload({
	"sap/ui/generic/app/fragments/MessageDialog.fragment.xml":'<core:FragmentDefinition xmlns="sap.m" xmlns:core="sap.ui.core" xmlns:layout="sap.ui.layout"><Dialog class="sapUiNoContentPadding" id="messageDialog" state="{settings&gt;/state}" type="Message" showHeader="true" horizontalScrolling="false" draggable="true" contentHeight="440px" contentWidth="440px" verticalScrolling="false"><content><MessageView items="{settings&gt;/messages}" showDetailsPageHeader="false" itemSelect="onMessageSelect" groupItems="{settings&gt;/grouping}"><MessageItem type="{settings&gt;type}" title="{settings&gt;message}" description="{settings&gt;description}" longtextUrl="{settings&gt;descriptionUrl}" groupName="{= ${settings&gt;/messageToGroupName}[${settings&gt;id}] || ${settings&gt;/genericGroupName} }"/></MessageView></content><customHeader><Bar><contentMiddle><Text text="{settings&gt;/title}"/></contentMiddle><contentLeft><Button icon="sap-icon://nav-back" visible="{settings&gt;/backButtonVisible}" press="onBackButtonPress"/></contentLeft></Bar></customHeader><buttons><Button text="{settings&gt;/closeButtonText}" id="Close" press="onMessageDialogClose"/></buttons></Dialog></core:FragmentDefinition>',
	"sap/ui/generic/app/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.generic.app","type":"library","embeds":[],"applicationVersion":{"version":"1.71.34"},"title":"The SAPUI5 library contains classes that are mainly used in smart template applications, but can also be used in any Fiori/UI5 application that uses the OData protocol to communicate with an application server.","description":"The SAPUI5 library contains classes that are mainly used in smart template applications, but can also be used in any Fiori/UI5 application\\n                   that uses the OData protocol to communicate with an application server.","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":[]},"sap.ui5":{"dependencies":{"minUI5Version":"1.71","libs":{"sap.ui.core":{"minVersion":"1.71.34"},"sap.ui.comp":{"minVersion":"1.71.34","lazy":true},"sap.m":{"minVersion":"1.71.34","lazy":true}}},"library":{"i18n":"messagebundle.properties","css":false,"content":{"controls":[],"elements":[],"types":["sap.ui.generic.app.navigation.service.NavType","sap.ui.generic.app.navigation.service.ParamHandlingMode","sap.ui.generic.app.navigation.service.SuppressionBehavior"],"interfaces":[]}}}}',
/*
 * ! SAPUI5

(c) Copyright 2009-2019 SAP SE. All rights reserved
 */
	"sap/ui/generic/app/AppComponent.js":function(){sap.ui.getCore().loadLibrary("sap.suite.ui.generic.template");sap.ui.define(["sap/suite/ui/generic/template/lib/AppComponent"],function(A){"use strict";return A;},true);
},
	"sap/ui/generic/app/util/ActionUtil.js":function(){sap.ui.getCore().loadLibrary("sap.m");sap.ui.getCore().loadLibrary("sap.ui.comp");sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/m/MessageBox","sap/ui/layout/form/SimpleForm","sap/ui/comp/smartfield/SmartField","sap/ui/comp/smartfield/SmartLabel","sap/m/Dialog","sap/ui/generic/app/util/ModelUtil","sap/m/VBox","sap/m/Text","sap/base/strings/formatMessage","sap/base/Log"],function(q,M,a,S,b,c,D,d,V,T,f,L){"use strict";
var A=M.extend("sap.ui.generic.app.util.ActionUtil",{metadata:{properties:{controller:{type:"object",group:"Misc",defaultValue:null},applicationController:{type:"object",group:"Misc",defaultValue:null},contexts:{type:"object",group:"Misc",defaultValue:null},successCallback:{type:"function",group:"Misc",defaultValue:null},operationGrouping:{type:"string",group:"Misc",defaultValue:null}}}});
A.prototype.call=function(F,s,i){var t=this;return new Promise(function(r,e){var m;t._oActionPromiseCallback={resolve:r,reject:e};t._sFunctionImportPath=F;var C=t.getController();if(!C||!C.getView()){e("No View Controller provided");}t._oMetaModel=C.getView().getModel().getMetaModel();var g=F.split('/')[1];t._oFunctionImport=t._oMetaModel.getODataFunctionImport(g);t._sFunctionImportLabel=s||g;if(!t._oFunctionImport){e("Unknown Function Import "+g);}if(t._isActionCritical()){var h="ACTION_CONFIRM|"+g;var j;var R=C.getOwnerComponent().getAppComponent&&C.getOwnerComponent().getAppComponent().getModel("i18n")&&C.getOwnerComponent().getAppComponent().getModel("i18n").getResourceBundle();if(R&&R.hasText(h)){j=R.getText(h);}else{j=sap.ui.getCore().getLibraryResourceBundle("sap.ui.generic.app").getText("ACTION_CONFIRM");j=f(j,t._sFunctionImportLabel);}a.confirm(j,{title:t._sFunctionImportLabel,onClose:function(o){if(o==="OK"){m=t._prepareParameters(t.getContexts());m=m||{};m.isDraftEnabled=i;t._initiateCall(m);}else if(o==="CANCEL"){t._oActionPromiseCallback.reject();}},sClass:t._getCompactModeStyleClass()});}else{m=t._prepareParameters(t.getContexts());m=m||{};m.isDraftEnabled=i;t._initiateCall(m);}});};
A.prototype._getCompactModeStyleClass=function(){if(this.getController().getView().$().closest(".sapUiSizeCompact").length){return"sapUiSizeCompact";}return"";};
A.prototype._isActionCritical=function(){var C=this._oFunctionImport["com.sap.vocabularies.Common.v1.IsActionCritical"];if(!C){return false;}if(C.Bool===undefined){return true;}return this._toBoolean(C.Bool);};
A.prototype._toBoolean=function(p){if(typeof p==="string"){var v=p.toLowerCase();return!(v=="false"||v==""||v==" ");}return!!p;};
A.prototype._prepareParameters=function(C){var s,e=null;if(Array.isArray(C)&&C.length!=1){return undefined;}else{s=C[0];}var o=s.getObject();if(s&&s.getPath()){var E=d.getEntitySetFromContext(s);var g=this._oMetaModel.getODataEntitySet(E,false);e=this._oMetaModel.getODataEntityType(g.entityType,false);}var k=this._getPropertyKeys(e);var p;var m={parameterData:{},additionalParameters:[]};if(this._oFunctionImport.parameter){for(var i=0;i<this._oFunctionImport.parameter.length;i++){var P=this._oFunctionImport.parameter[i];this._addParameterLabel(P,e);var h=P.name;var I=!!k[h];p=undefined;if(o.hasOwnProperty(h)){p=o[h];}else if(I){L.error("Key parameter of action not found in current context: "+h);throw new Error("Key parameter of action not found in current context: "+h);}m.parameterData[h]=p;if(!I&&P.mode.toUpperCase()=="IN"){m.additionalParameters.push(P);}}}return m;};
A.prototype._getPropertyKeys=function(e){var k={};if(e&&e.key&&e.key.propertyRef){for(var i=0;i<e.key.propertyRef.length;i++){var K=e.key.propertyRef[i].name;k[K]=true;}}return k;};
A.prototype._initiateCall=function(m){if(m!=undefined&&m.additionalParameters&&m.additionalParameters.length==0){this._call(m.parameterData,m.isDraftEnabled);}else if(m!=undefined&&m.additionalParameters&&m.additionalParameters.length>0){var t=this;var p={urlParameters:{}};var e=this.getContexts()[0];var F=this.getApplicationController().getNewActionContext(this._sFunctionImportPath,e,p);F.context.then(function(o){var P=t._buildParametersForm(m,o);for(var k in m.parameterData){o.oModel.setProperty(k,m.parameterData[k],o);}var g=false;var h=new D({title:t._sFunctionImportLabel,content:[P.form],beginButton:new sap.m.Button({text:t._sFunctionImportLabel,press:function(E){if(P.hasNoClientErrors()){if(P.getEmptyMandatoryFields().length==0){h.close();t._oActionPromiseCallback.resolve({executionPromise:F.result.then(function(R){t._bExecutedSuccessfully=true;return R;},function(l){t._bExecutedSuccessfully=false;throw l;})});g=true;var s=t._sFunctionImportPath.split('/')[1];t.getApplicationController().submitActionContext(e,o,s);}else{var C=new V();var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.generic.app").getText("ACTION_MISSING_MANDATORY");for(var i=0;i<P.getEmptyMandatoryFields().length;i++){var j=f(r,P.getEmptyMandatoryFields()[i].getTextLabel());C.addItem(new T({text:j}));}a.error(C,{sClass:t._getCompactModeStyleClass()});}}}}),endButton:new sap.m.Button({text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.generic.app").getText("ACTION_CANCEL"),press:function(){F.abort();h.close();t._oActionPromiseCallback.reject();g=true;}}),afterClose:function(C){h.destroy();if(!g){t._oActionPromiseCallback.reject();}}}).addStyleClass("sapUiNoContentPadding");h.addStyleClass(t._getCompactModeStyleClass());h.setModel(o.oModel);if(this.getController().getView().getModel("@i18n")){h.setModel(this.getController().getView().getModel("@i18n"),"@i18n");}h.open();}.bind(this));}else{this._call(null,m.isDraftEnabled);}};
A.prototype._call=function(u,i){var C=this.getContexts();var p={urlParameters:u,operationGrouping:this.getOperationGrouping(),triggerChanges:i};var o=this.getController();var e=this.getApplicationController()||o.getApplicationController();var t=this;t._oActionPromiseCallback.resolve({executionPromise:e.invokeActions(this._sFunctionImportPath,C,p).then(function(r){t._bExecutedSuccessfully=true;return r;},function(E){t._bExecutedSuccessfully=false;throw E;})});};
A.prototype._getActionParameterData=function(p){var m=[];var r=p.getObject('/');var P={};for(var i=0;i<this._oFunctionImport.parameter.length;i++){var o=this._oFunctionImport.parameter[i];var s=o.name;if(r.hasOwnProperty(s)){var v=r[s];if(v===undefined){if(!this._toBoolean(o.nullable)){if(o.type==='Edm.Boolean'){P[s]=false;}else{m.push(o);}}}else{P[s]=v;}}else{throw new Error("Unknown parameter: "+s);}}return{preparedParameterData:P,missingMandatoryParameters:m};};
A.prototype._buildParametersForm=function(p,C){var F=new S({editable:true});F.setBindingContext(C);var s;var e=[];var o;var v;for(var i=0;i<p.additionalParameters.length;i++){var P=p.additionalParameters[i];if(P["com.sap.vocabularies.UI.v1.Hidden"]&&!(P["com.sap.vocabularies.UI.v1.Hidden"].Bool=="false")){continue;}v=P["com.sap.vocabularies.Common.v1.ValueListWithFixedValues"]?"fixed-values":undefined;if(v==undefined){v=P["sap:value-list"]=="fixed-values"?"fixed-values":undefined;}s=new b("ActionUtil-"+this._sFunctionImportPath.replace("/","-")+"-"+P.name,{value:'{'+P.name+'}',textLabel:this._getParameterName(P),width:"100%"});s.data("configdata",{"configdata":{isInnerControl:false,path:P.name,entitySetObject:{},annotations:{valuelist:P["com.sap.vocabularies.Common.v1.ValueList"],valuelistType:v},modelObject:C.oModel,entityType:P.type,property:{property:P,typePath:P.name}}});if(P.nullable=="false"){s.setMandatory(true);}e.push(s);o=new c();o.setLabelFor(s);F.addContent(o);F.addContent(s);}var h=function(){var n=true;for(var i=0;i<e.length;i++){if(e[i].getValueState()!="None"){n=false;break;}}return n;};var g=function(){var m=q.grep(e,function(j){return(j.getMandatory()==true&&j.getValue()==""&&j.getDataType()!="Edm.Boolean");});return m;};return{form:F,hasNoClientErrors:h,getEmptyMandatoryFields:g};};
A.prototype._getParameterName=function(p){return p["com.sap.vocabularies.Common.v1.Label"]?p["com.sap.vocabularies.Common.v1.Label"].String:p.name;};
A.prototype._addParameterLabel=function(p,e){if(e&&p&&!p["com.sap.vocabularies.Common.v1.Label"]){var P=this._oMetaModel.getODataProperty(e,p.name,false);if(P&&P["com.sap.vocabularies.Common.v1.Label"]){p["com.sap.vocabularies.Common.v1.Label"]=P["com.sap.vocabularies.Common.v1.Label"];}}};
A.prototype.getFunctionImportLabel=function(){return this._sFunctionImportLabel;};
A.prototype.getExecutedSuccessfully=function(){return this._bExecutedSuccessfully;};
return A;},true);
},
	"sap/ui/generic/app/util/MessageUtil.js":function(){sap.ui.getCore().loadLibrary("sap.m");sap.ui.define(["sap/ui/core/ValueState","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/m/MessageToast","sap/ui/core/syncStyleClass"],function(V,F,a,J,M,s){"use strict";var h={badRequest:"400",unauthorized:"401",forbidden:"403",notFound:"404",methodNotAllowed:"405",preconditionFailed:"428",internalServerError:"500",notImplemented:"501",badGateway:"502",serviceUnavailable:"503",gatewayTimeout:"504",httpVersionNotSupported:"505"};var o={callAction:"callAction",addEntry:"addEntry",saveEntity:"saveEntity",deleteEntity:"deleteEntity",editEntity:"editEntity",modifyEntity:"modifyEntity",activateDraftEntity:"activateDraftEntity",saveAndPrepareDraftEntity:"saveAndPrepareDraftEntity",getCollection:"getCollection"};var m;
function g(R){var t=[],e;var f=sap.ui.getCore().getMessageManager();var j=f.getMessageModel().getData();for(var i=0;i<j.length;i++){e=j[i];if(e.getPersistent()){t.push(e);}}return t;}
function c(P,C){var D;D=function(n,f){var e;var i={onMessageDialogClose:function(){f.onMessageDialogClose();e.destroy();}};e=sap.ui.xmlfragment(n,i);if(C){s(C,P,e);}P.addDependent(P);return e;};return D;}
function b(v,A){var t=g();if(t.length===0){return Promise.resolve();}r();var S=V.None;for(var i=0;i<t.length&&S!==V.Error;i++){var e=t[i];switch(e.type){case sap.ui.core.MessageType.Error:S=V.Error;break;case sap.ui.core.MessageType.Warning:S=V.Warning;break;case sap.ui.core.MessageType.Success:if(S===sap.ui.core.ValueState.None){S=V.Success;}}}if(t.length===1&&(S===V.Success||S===V.None)){M.show(t[0].message);return Promise.resolve();}return new Promise(function(R){var f=(typeof v==="function")?v:c(v.owner,v.contentDensityClass);var D,j,k;var l={onMessageDialogClose:function(){D.close();k.setProperty("/backButtonVisible",false);k.setProperty("/messages",[]);k.setProperty("/messageToGroupName",Object.create(null));j.navigateBack();k.getProperty("/resolve")();},onBackButtonPress:function(){k.setProperty("/backButtonVisible",false);j.navigateBack();},onMessageSelect:function(){k.setProperty("/backButtonVisible",true);}};D=f("sap.ui.generic.app.fragments.MessageDialog",l);j=D.getContent()[0];var n=D.getModel();var q=n&&n.getMetaModel();var G=false;var u=Object.create(null);if(q){t.forEach(function(e){var w=e.getTarget();if(!w){return;}if(w.lastIndexOf("/")>0){w=w.substring(0,w.lastIndexOf("/"));}var E=w.substring(1,w.indexOf("("));var x=E&&q.getODataEntitySet(E);var y=x&&q.getODataEntityType(x.entityType);var H=y&&y["com.sap.vocabularies.UI.v1.HeaderInfo"];var T=H&&H.Title&&H.Title.Value&&H.Title.Value.Path;var z=n.getProperty(w);var B=z&&z[T];if(B){u[e.getId()]=B;G=true;}});}var L=sap.ui.getCore().getLibraryResourceBundle("sap.ui.generic.app");k=D.getModel("settings");if(!k){k=new J({closeButtonText:L.getText("DIALOG_CLOSE"),genericGroupName:L.getText("GENERAL_TITLE"),backButtonVisible:false});D.setModel(k,"settings");}k.setProperty("/title",A||L.getText("DIALOG_TITLE"));k.setProperty("/messages",t);k.setProperty("/grouping",G);k.setProperty("/state",S);k.setProperty("/resolve",R);k.setProperty("/messageToGroupName",u);D.open();});}
function r(){var e=sap.ui.getCore().getMessageManager();var t=g();if(t.length>0){e.removeMessages(t);}}
function d(e,D,f){var t=new sap.ui.core.message.Message({message:e,description:D,type:sap.ui.core.MessageType.Error,processor:f,target:'',persistent:true});sap.ui.getCore().getMessageManager().addMessages(t);}
function p(e){var R;m=e&&e.url;if(m){m="/"+m.substring(0,m.indexOf(")")+1);}var f=sap.ui.getCore().getLibraryResourceBundle("sap.ui.generic.app").getText("ERROR_UNKNOWN");var H;if(e instanceof Error){if(e.message){f=e.message;}}else if(e.response){if(e.response.message){f=e.response.message;}if(e.response.statusCode){H=e.response.statusCode;}if(e.response.headers){for(var i in e.response.headers){if(i.toLowerCase()==="content-type"){var j=e.response.headers[i];if(j.toLowerCase().indexOf("application/json")===0){if(e.response.responseText){var O=JSON.parse(e.response.responseText);if(O&&O.error&&O.error.message&&O.error.message.value){f=O.error.message.value;}}}else if(e.message){f=e.message;}break;}}}}var t=g(e);R={httpStatusCode:H,messageText:f,description:null,containsTransientMessage:(t.length===0)?false:true};return R;}
return{operations:o,httpStatusCodes:h,handleTransientMessages:b,removeTransientMessages:r,addTransientErrorMessage:d,parseErrorResponse:p};},true);
}
},"sap/ui/generic/app/library-preload"
);
//# sourceMappingURL=library-preload.js.map