/*!
* OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./library","sap/ui/core/Core","sap/ui/core/Control","./ResponsiveSplitterUtilities","./ResponsiveSplitterPage","./PaneContainer","./SplitPane","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","./ResponsiveSplitterRenderer","sap/ui/thirdparty/jquery"],function(l,C,c,R,d,P,S,I,e,f,q){"use strict";var g=c.extend("sap.ui.layout.ResponsiveSplitter",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"rootPaneContainer",aggregations:{rootPaneContainer:{type:"sap.ui.layout.PaneContainer",multiple:false},_pages:{type:"sap.ui.layout.ResponsiveSplitterPage",multiple:true,visibility:"hidden"}},associations:{defaultPane:{type:"sap.ui.layout.SplitPane",multiple:false}},events:{}}});var h={MAX_VISIBLE_BUTTONS:7};g.prototype.init=function(){this._aPaneContainers=[];this._aPanes=[];this._oResourceBundle=C.getLibraryResourceBundle("sap.ui.layout");this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._iDefaultPageIndex=0;};g.prototype.onBeforeRendering=function(){var r=this.getRootPaneContainer();if(r){r._oSplitter.addEventDelegate({onAfterRendering:function(){this._setSplitterBarsTooltips(r._oSplitter);this._updatePaginatorButtonsTooltips();}},this);this._createWidthIntervals();this._createPages();this._detachResizeHandler();}};g.prototype.onAfterRendering=function(){this._parentResizeHandler=e.register(this,this._onParentResize.bind(this));var r=this.getRootPaneContainer();if(r){this._onParentResize();}this._setItemNavigation();};g.prototype.exit=function(){this._detachResizeHandler();this._clearItemNavigation();};g.prototype._setSplitterBarsTooltips=function(o,p){var s=o.$().find(" > .sapUiLoSplitterBar"),a=o.$().find(" > .sapUiLoSplitterContent"),t="",b,n,A,j;for(var i=0;i<a.length;i++){j=a[i].childNodes[0].id;A=C.byId(j);b=i+1;n=i+2;if(p){t+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE",[p+"."+b,p+"."+n]);}else{t+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE",[b,n]);}if(s[i]){s[i].setAttribute("title",t);t="";}if(A instanceof sap.ui.layout.Splitter){this._setSplitterBarsTooltips(A,b);}}};g.prototype._updatePaginatorButtonsTooltips=function(){var v=Array.prototype.slice.call(this._getVisibleButtons()),H=this.getRootPaneContainer()._oSplitter.getAssociatedContentAreas().length,s=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_HOME")+" ",a=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_AND"),t="",b=this,o;if(v.length>0){o=v.shift();for(var i=1;i<=H;i++){s+=i;if(i<(H-1)){s+=", ";}else if(i===H-1){s+=" "+a+" ";}}o.setAttribute("title",s);[].forEach.call(v,function(B){t=b._oResourceBundle.getText("RESPONSIVE_SPLITTER_GOTO")+" "+(H+1);H+=1;B.setAttribute("title",t);});}};g.prototype.onsapright=function(E){this._handleArrowNavigation(6,"Forward",E);};g.prototype.onsapleft=function(E){this._handleArrowNavigation(0,"Back",E);};g.prototype._setItemNavigation=function(){var b=this._getVisibleButtons(),D=[];this._oItemNavigation.setRootDomRef(this.$().find(".sapUiResponsiveSplitterPaginator")[0]);for(var i=0;i<b.length;i++){if(b[i]){D.push(b[i]);}}this._oItemNavigation.setItemDomRefs(D);this._oItemNavigation.setFocusedIndex(this._iDefaultPageIndex);};g.prototype._clearItemNavigation=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;};g.prototype._handleArrowNavigation=function(b,D,E){if(E.target===this._getVisibleButtons()[b]){this["_handlePaginator"+D](E);this._setItemNavigation();}else{return;}};g.prototype._onParentResize=function(){var i=this._intervalHasChanged(),r=this.getRootPaneContainer();if(i&&r){this._arrangeContent();this._setPaginatorVisibility();}};g.prototype._detachResizeHandler=function(){if(this._parentResizeHandler){e.deregister(this._parentResizeHandler);this._parentResizeHandler=null;}};g.prototype._createWidthIntervals=function(){var B=[];this._aIntervals=[];R.visitPanes(this.getRootPaneContainer(),function(p){var r=p.getRequiredParentWidth();if(B.indexOf(r)==-1){B.push(r);}});B.push(Number.NEGATIVE_INFINITY);B.push(Number.POSITIVE_INFINITY);B.sort(function(a,b){return a-b;});for(var i=0;i<B.length-1;i++){var o=new R.splitterInterval(B[i],B[i+1],this.getRootPaneContainer());this._aIntervals.push(o);}};g.prototype._createPages=function(){var m=this._getMaxPageCount();this.destroyAggregation("_pages",true);for(var i=0;i<m;i++){var p=new d();this.addAggregation("_pages",p,true);}};g.prototype._intervalHasChanged=function(){var w=this.getDomRef().clientWidth,o=null,a=this._aIntervals;for(var i=0;i<a.length;i++){if(a[i].iFrom<w&&w<=a[i].iTo){o=a[i];break;}}if(this._currentInterval!==o){this._currentInterval=o;return true;}return false;};g.prototype._setPaginatorVisibility=function(){var b=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),n=this.$().find(".sapUiResponsiveSplitterPaginatorNavButton"),p=this.$().find(".sapUiResponsiveSplitterPaginator"),i=(this._getHiddenPanes().length+1),s=i<h.MAX_VISIBLE_BUTTONS;b.addClass("sapUiResponsiveSplitterHiddenElement");if(i>1){this.getDomRef().classList.add("sapUiRSVisiblePaginator");b=b.slice(0,s?i:h.MAX_VISIBLE_BUTTONS);b.removeClass("sapUiResponsiveSplitterHiddenElement");b.removeClass("sapUiResponsiveSplitterHiddenPaginatorButton");n.toggleClass("sapUiResponsiveSplitterHiddenPaginatorButton",s);p.toggleClass("sapUiResponsiveSplitterWithNavButtons",!s);}else{this.getDomRef().classList.remove("sapUiRSVisiblePaginator");}};g.prototype._getMaxPageCount=function(){var t=0;this._aIntervals.forEach(function(i){if(i.iPagesCount>t){t=i.iPagesCount;}});return t;};g.prototype._arrangeContent=function(){var p=this.getAggregation("_pages")||[],D=0,o=C.byId(this.getDefaultPane()),a,s,i;this._clearContent();p.forEach(function(b){b.setVisible(false);});this._fillPageContent(this.getRootPaneContainer());if(o){a=o.getContent();if(a){s=a.getId();for(i=0;i<p.length;i++){if(p[i].containsControl(s)){D=i;break;}}}}this._iDefaultPageIndex=D;this._activatePage(D);};g.prototype._activatePage=function(p){var $=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),o=this.$().find(".sapUiResponsiveSplitterPaginatorSelectedButton"),O=$.index(o),a=this.getAggregation("_pages")||[];a[O]&&a[O].setVisible(false);a[p]&&a[p].setVisible(true);o.removeClass("sapUiResponsiveSplitterPaginatorSelectedButton");$.eq(p).addClass("sapUiResponsiveSplitterPaginatorSelectedButton");o.attr("aria-checked",false);$.eq(p).attr("aria-checked",true);};g.prototype._fillPageContent=function(s){var b=s instanceof P,a=s instanceof S,o=s.getParent(),j=o instanceof P,p=this.getAggregation("_pages"),H,k,m,D,n,M;if(b&&p){this._aPaneContainers.push(s);k=this._getAllPanesInInterval(s,this._currentInterval.iFrom).length>0;m=s._oSplitter;if(j&&k){o._oSplitter.addAssociatedContentArea(m);}else if(!j){p[0].setContent(m);}s.getPanes().forEach(function(r){this._fillPageContent(r);},this);}else if(a&&p){this._assignDefault(s);this._aPanes.push(s);D=s.getDemandPane();H=this._getHiddenPanes();n=H.length;M=this._getMaxPageCount();var i;if(s._isInInterval(this._currentInterval.iFrom)){o._oSplitter.addAssociatedContentArea(s.getContent());}else if(D&&(n<M)){for(i=0;i<n;i++){p[i+1].setContent(H[i].getContent());}}else if(D&&n===M){for(i=0;i<n;i++){p[i].setContent(H[i].getContent());}}else if(this._isDefault(s)){p[0].setContent(s.getContent());}}};g.prototype._isDefault=function(p){return this.getDefaultPane()===p.getId();};g.prototype._assignDefault=function(p){var D=this.getDefaultPane();this.setDefaultPane(D||p);};g.prototype._getAllPanesInInterval=function(p,F){var a=[];function v(p){p.getPanes().forEach(function(o){if(o instanceof P){v(o);}else if(o._isInInterval(F)){a.push(o);}});return a;}return v(p,F);};g.prototype._getHiddenPanes=function(){return this._aPanes.filter(function(p){return p.getDemandPane()&&!p._isInInterval(this._currentInterval.iFrom);},this);};g.prototype._clearContent=function(){this._aPaneContainers.forEach(function(p){p._oSplitter.removeAllAssociatedContentArea();});this._aPaneContainers=[];this._aPanes=[];};g.prototype._getVisibleButtons=function(){return this.$().find(".sapUiResponsiveSplitterPaginatorButton:not(.sapUiResponsiveSplitterHiddenElement, .sapUiResponsiveSplitterHiddenPaginatorButton)");};g.prototype._handlePaginatorButtonTap=function(E){var t=E.target,T=E.target.classList,p;if(T&&T.contains("sapUiResponsiveSplitterPaginatorButton")){p=parseInt(t.getAttribute("page-index"));this._activatePage(p);}else if(T&&T.contains("sapUiResponsiveSplitterPaginatorNavButton")){if(T.contains("sapUiResponsiveSplitterPaginatorButtonForward")){this._handlePaginatorForward(E);}else{this._handlePaginatorBack(E);}}};g.prototype._handlePaginatorForward=function(E){var v=this._getVisibleButtons(),H=this._getHiddenPanes().length,$=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),p,a=$.filter(function(){p=parseInt(this.getAttribute("page-index"));return p>=h.MAX_VISIBLE_BUTTONS&&p<=H;});if(a.length>0){v.first().addClass("sapUiResponsiveSplitterHiddenElement");a.last().removeClass("sapUiResponsiveSplitterHiddenElement");}};g.prototype._handlePaginatorBack=function(E){var v=this._getVisibleButtons(),m=this._getMaxPageCount()-h.MAX_VISIBLE_BUTTONS,H=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),$=H.filter(function(){return parseInt(this.getAttribute("page-index"))<m;});if($.length>0){v.last().addClass("sapUiResponsiveSplitterHiddenElement");$.last().removeClass("sapUiResponsiveSplitterHiddenElement");}};g.prototype.ontap=g.prototype._handlePaginatorButtonTap;g.prototype.onsapenter=g.prototype._handlePaginatorButtonTap;g.prototype.onsapspace=g.prototype._handlePaginatorButtonTap;return g;});
