/*!
 * SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['sap/ui/mdc/BaseControl','sap/ui/base/ManagedObjectObserver','sap/ui/model/json/JSONModel','sap/ui/mdc/library','sap/ui/model/base/ManagedObjectModel','sap/ui/model/Sorter','sap/base/Log','sap/base/util/deepEqual','sap/ui/Device','sap/ui/mdc/chart/ToolbarHandler'],function(B,M,J,a,b,S,L,d,D,T){"use strict";var C,c,e,f,g,h,l;var m=B.extend("sap.ui.mdc.Chart",{metadata:{library:"sap.ui.mdc",defaultAggregation:"items",properties:{header:{type:"string",group:"Misc",defaultValue:null},chartType:{type:"string",group:"Misc",defaultValue:"column"},selectionMode:{type:"string",group:"Misc",defaultValue:"MULTIPLE"},conditionModelName:{type:"string",defaultValue:null},legendVisible:{type:"boolean",group:"Misc",defaultValue:true},vizProperties:{type:"object",group:"Misc"},_colorings:{type:"object",visibility:"_hidden",byValue:true},ignoreToolbarActions:{type:"sap.ui.mdc.ChartToolbarActionType[]",defaultValue:[]},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"240px",invalidate:true},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"400px",invalidate:true}},aggregations:{data:{multiple:true},items:{type:"sap.ui.mdc.chart.Item",multiple:true},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{idSuffix:"--toolbar",aggregation:"actions"}},_chart:{type:"sap.chart.Chart",multiple:false},_toolbar:{type:"sap.ui.mdc.ActionToolbar",multiple:false},_breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false},selectionDetailsActions:{type:"sap.ui.mdc.chart.SelectionDetailsActions",multiple:false},uiState:{type:"sap.ui.mdc.base.state.UiState",multiple:false}},events:{selectionDetailsActionPressed:{parameters:{action:{type:"sap.ui.core.Item"},itemContexts:{type:"sap.ui.model.Context"},level:{type:"sap.m.SelectionDetailsActionLevel"}}}}},renderer:function(r,o){r.write("<div");r.writeControlData(o);r.writeAccessibilityState(o);r.addClass("sapUiFixFlex");r.writeClasses();r.addStyle("overflow","hidden;");if(o.getHeight()){r.addStyle("height",o.getHeight());}if(o.getWidth()){r.addStyle("width",o.getWidth());}if(o.getMinHeight()){r.addStyle("min-height",o.getMinHeight());}if(o.getMinWidth()){r.addStyle("min-width",o.getMinWidth());}r.writeStyles();r.write(">");var t=o.getAggregation("_toolbar");if(t){r.write("<div");r.addClass("sapUiFixFlexFixed");r.writeClasses();r.writeStyles();r.write(">");r.renderControl(t);r.write("</div>");}var i=o.getAggregation("_breadcrumbs");if(i){r.renderControl(i);}var j=o.getAggregation("_chart");if(j){r.write("<div");r.addClass("sapUiFixFlexFlexible");r.writeClasses();r.addStyle("overflow","hidden;");r.writeStyles();r.write(">");r.write("<div");r.addClass("sapUiFixFlexFlexibleContainer");r.writeClasses();r.writeStyles();r.write(">");r.renderControl(j);r.write("</div>");r.write("</div>");}r.write("</div>");r.write("</div>");},init:function(){this._oObserver=new M(this.update.bind(this));this._oObserver.observe(this,{aggregations:["items","_chart"],properties:["ignoreToolbarActions"]});this._oManagedObjectModel=new b(this);this.setModel(this._oManagedObjectModel,"$mdcChart");this.attachModelContextChange(this._onSetConditionModel,this);if(!this.oDelegatePromise){this.setMetadataDelegate("sap/ui/mdc/ChartDelegate");}},applySettings:function(s){s=s||{};var A=s.actions||[];delete s.actions;this.oChartPromise=this._getLibraryPromise().then(function(){if(!this._bIsBeingDestroyed){return this.oDelegatePromise.then(function(o){return o.fetchProperties(this.getCollectionModel(),this.getCollectionPath());}.bind(this)).then(function(p){var I={};for(var i=0;i<p.length;i++){I[p[i].name]=p[i];}T.createToolbar(this,A);this._createDrillBreadcrumbs();return this._createInnerChart(s,I);}.bind(this));}else{return null;}}.bind(this));B.prototype.applySettings.apply(this,[s]);},bindAggregation:function(n,o){if(n=="data"){this.oDataInfo=o;var i=this.getAggregation("_chart");if(i){i.bindAggregation("data",o);}else{this.oChartPromise.then(function(i){i.bindAggregation("data",this.oDataInfo);}.bind(this));}return this;}return B.bindAggregation(n,o);},getBindingInfo:function(n){if(n=="data"){return this.oDataInfo;}return B.prototype.getBindingInfo.apply(this,[n]);},setLegendVisible:function(v){this.setVizProperties({'legend':{'visible':v},'sizeLegend':{'visible':v}});return this.setProperty("legendVisible",v);},_createInnerChart:function(s,I){var k={},o,v=[],n=[],p=[],V={};k.chartType='{$mdcChart>/chartType}';k.dimensions=[];k.measures=[];k.id=this.getId()+"--innerChart";k.height='100%';k.width='100%';k.vizProperties='{$mdcChart>/vizProperties}';s.items=s.items||[];function q(j){if(this&&this.getVizItemType()=="Dimension"){k.dimensions.push(j);}else{k.measures.push(j);}}function r(o,u){if(o.getCriticality()){u._addCriticality(o);}p.push(o.getKey());if(o.getAdditionalColoringMeasures){for(var j=0;j<o.getAdditionalColoringMeasures().length;j++){if(n.indexOf(o.getAdditionalColoringMeasures()[j])==-1){n.push(o.getAdditionalColoringMeasures()[j]);}}}}function t(j){var K,u;for(var i=0;i<n.length;i++){K=n[i];if(p.indexOf(K)==-1){u=j.retrieveAggregationItem("items",I[K]);u=l.getVizItemSettings(u.settings);v.push(l.createVizChartItem(u).then(q));}}}for(var i=0;i<s.items.length;i++){o=s.items[i];r(o,this);if(I[o.getKey()]){V=this.DELEGATE.retrieveAggregationItem("items",I[o.getKey()]).settings;}else{V=undefined;}v.push(o.toVizChartItem(V).then(q.bind(o)));}t(this.DELEGATE);var w=new Promise(function(j){sap.ui.require(["sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],function(F){if(!F.isFlexSupported({element:this})){return Promise.resolve();}F.waitForChanges({element:this}).then(function(){return j();});}.bind(this));}.bind(this));return Promise.all(v,w).then(function(){var j=new C(k);j.setVisibleDimensions([]);j.setVisibleMeasures([]);j.setInResultDimensions([]);this._oObserver.observe(j,{bindings:["data"],aggregations:["dimensions","measures"]});this.setAggregation("_chart",j);return j;}.bind(this));},setSelectionMode:function(v){var o=this.getAggregation("_chart");if(o){o.setSelectionMode(v);if(v!=="NONE"){this._prepareSelection();}}else{this.oChartPromise.then(function(o){if(o){o.setSelectionMode(v);if(v!=="NONE"){this._prepareSelection();}}}.bind(this));}return this.setProperty("selectionMode",v,true);},_getLibraryPromise:function(){if(!this.oChartLibPromise){this.oChartLibPromise=new Promise(function(r,i){if(!C){sap.ui.require(["sap/chart/Chart","sap/ui/mdc/chart/ChartTypeButton","sap/ui/mdc/chart/MeasureItem"],function(m,j,k){C=m;h=j;c=sap.ui.getCore().getLibraryResourceBundle("sap.chart.messages");e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");l=k;r(true);});}else{r(true);}});}return this.oChartLibPromise;},addItem:function(i,s){var o=this.getAggregation("_chart");if(o){i.toChart(o);}else{this.oChartPromise.then(function(o){if(o){this.toChart(o);}}.bind(i));}this._oObserver.observe(i,{properties:["visible","inResult","role"]});return this.addAggregation("items",i,s);},insertItem:function(i,I,s){if(i.getCriticality()){this._addCriticality(i);}var o=this.getAggregation("_chart");if(o){i.toChart(o);}else{this.oChartPromise.then(function(o){if(o){this.toChart(o);}}.bind(i));}this._oObserver.observe(i,{properties:["visible","inResult","role"]});return this.insertAggregation("items",i,I,s);},removeItem:function(i,s){this._oObserver.unobserve(i);return this.removeAggregation("items",i,s);}});m.prototype.exit=function(){var o=this.getAggregation("_chart");this.detachModelContextChange(this._onSetConditionModel,this);if(o){o.destroy();}else{this._bIsBeingDestroyed=true;this.oChartPromise.finally(function(){var o=this.getAggregation("_chart");if(o){o.destroy();}}.bind(this));}B.prototype.exit.apply(this,[]);};m.prototype._showDrillDown=function(){if(g){if(!this._oDrillDownPopover){g.createDrillDownPopover(this);}g.showDrillDownPopover(this);}else{sap.ui.require(["sap/ui/mdc/chart/DrillStackHandler"],function(i){g=i;g.createDrillDownPopover(this);g.showDrillDownPopover(this,this.getMetadataDelegate());}.bind(this));}};m.prototype._createDrillBreadcrumbs=function(){if(g){if(!this._oDrillBreadcrumbs){g.createDrillBreadcrumbs(this);}}else{sap.ui.require(["sap/ui/mdc/chart/DrillStackHandler"],function(i){g=i;g.createDrillBreadcrumbs(this);}.bind(this));}};m.prototype._getPropertyData=function(){return new Promise(function(r,i){if(!this.aFetchedProperties){return this.oDelegatePromise.then(function(o){return o.fetchProperties(this.getCollectionModel(),this.getCollectionPath());}.bind(this)).then(function(F){this.aFetchedProperties=F;r(F);}.bind(this));}else{r(this.aFetchedProperties);}}.bind(this));};m.prototype._getP13nStateOfFilter=function(){return this.oDelegatePromise.then(function(o){return o.fetchProperties(this.getCollectionModel(),this.getCollectionPath());}.bind(this)).then(function(p){var F={};p.filter(function(o){return o.filterable;}).forEach(function(o){F[o.name]=o;});var G=function(k,I){var t;I.some(function(o){if(o.getKey()===k){t=o.getLabel();return true;}});return t||F[k].label;};var i=function(w,s,I){var P=[];for(var k in F){var j={key:F[k].name,text:G(k,I),tooltip:G(k,I)};if(w){var o=new sap.ui.mdc.FilterField({dataType:F[k].type,maxConditions:F[k].filterExpression,conditions:{path:s+">/conditions/"+F[k].name}});j.controls=[o];}P.push(j);}return P;};var I=this.getItems();var s=this.getConditionModelName();return{initialData:{items:i(false,s,I)},runtimeData:{modelName:s,model:s?this.getModel(s):null,items:i(true,s,I)}};}.bind(this));};m.prototype.getAvailableChartTypes=function(){var j=[];var o=this.getAggregation("_chart");if(o){var A=o.getAvailableChartTypes().available;if(j){for(var i=0;i<A.length;i++){var t=A[i].chart;j.push({key:t,icon:h.mMatchingIcon[t],text:c.getText("info/"+t),selected:(t==this.getChartType())});}}}return j;};m.prototype.getTypeInfo=function(){var t=this.getChartType();var i={icon:h.mMatchingIcon[t],text:e.getText("chart.CHART_TYPE_TOOLTIP",[t])};return i;};m.prototype.getManagedObjectModel=function(){return this._oManagedObjectModel;};m.prototype.update=function(o){var i=this.getAggregation("_chart");if(i){this._update(i,o);}else{this.oChartPromise.then(function(i){if(i){this._update(i,o);}}.bind(this));}};m.prototype._update=function(o,j){var I=this.getItems(),v,k,V=[],n=[],p=[],q={};if(j.name==="ignoreToolbarActions"){T.updateToolbar(this);return;}if(j.name==="data"&&j.type==="binding"&&j.mutation==="prepare"&&j.object.isA("sap.chart.Chart")){j.bindingInfo.sorter=this._getSorters();}this._aInResultProperties=[];for(var i=0;i<I.length;i++){k=I[i];v=k.getVizItemType()=="Measure"?o.getMeasureByName(k.getKey()):o.getDimensionByName(k.getKey());if(!v){continue;}if(k.getVisible()){if(k.getVizItemType()=="Measure"){V.push(v.getName());if(k.getDataPoint()){q[v.getName()]=k.getDataPoint();}}else{n.push(v.getName());}this._aInResultProperties.push(v.getName());}if(k.getVizItemType()=="Dimension"){if(k.getInResult()){p.push(v.getName());this._aInResultProperties.push(v.getName());}}}var r=false;if(!d(n,o.getVisibleDimensions())){o.setVisibleDimensions(n);r=true;}if(!d(V,o.getVisibleMeasures())){o.setVisibleMeasures(V);r=true;}if(!d(p,o.getInResultDimensions())){o.setInResultDimensions(p);r=true;}if(r){this._rebind();this._updateSemanticalPattern(o,V,q);this._updateColoring(o,n,V);}if(g&&this.getAggregation("_breadcrumbs")){g._updateDrillBreadcrumbs(this.getAggregation("_chart"),this.getAggregation("_breadcrumbs"));}};m.prototype._updateSemanticalPattern=function(o,v,i){for(var k=0;k<v.length;k++){var j=i[v[k]];if(j){if(j.targetValue||j.foreCastValue){var A=o.getMeasureByName(v[k]);A.setSemantics("actual");if(j.targetValue!=null){var r=o.getMeasureByName(j.targetValue);if(r){r.setSemantics("reference");}else{L.error("sap.ui.mdc.Chart: "+j.targetValue+" is not a valid measure");}}if(j.foreCastValue){var p=o.getMeasureByName(j.foreCastValue);if(p){p.setSemantics("projected");}else{L.error("sap.ui.comp.SmartChart: "+j.ForecastValue.Path+" is not a valid measure");}}A.setSemanticallyRelatedMeasures({referenceValueMeasure:j.targetValue,projectedValueMeasure:j.foreCastValue});}}}};m.prototype._updateColoring=function(o,v,V,i){var j=this.getProperty("_colorings"),k;if(j&&j.Criticality){var A;for(k=0;k<v.length;k++){if(j.Criticality.DimensionValues[v[k]]){A={coloring:"Criticality",parameters:{dimension:v[k]}};delete j.Criticality.MeasureValues;break;}}if(!A){delete j.Criticality.DimensionValues;for(var s in j.Criticality.MeasureValues){if(V.indexOf(s)==-1){delete j.Criticality.MeasureValues[s];}}A={coloring:"Criticality",parameters:{measure:V}};}if(A){o.setColorings(j);o.setActiveColoring(A);}}};m.prototype._prepareSelection=function(){if(f){f.prepareChart(this);}else{if(!this.oSelectionHandlerPromise){this.oSelectionHandlerPromise=new Promise(function(r,i){sap.ui.require(["sap/ui/mdc/chart/SelectionHandler"],function(j){f=j;r(true);});});}this.oSelectionHandlerPromise.then(function(){f.prepareChart(this);}.bind(this));}};m.prototype._getSorters=function(){var s=[],p,v,j,o,k;p=this.data("$p13nSort");if(typeof p==="string"){p=p.replace(/\\{/g,"{");v=JSON.parse(p);}if(v){s=v;}for(var i=0;i<s.length;i++){o=s[i];if(this._aInResultProperties.indexOf(o.name)!=-1){k=new S(o.name,o.sortOrder==="Descending");if(j){j.push(k);}else{j=[k];}}}return j;};m.prototype._getSelectOptions=function(){return!this.getUiState()?[]:this.getUiState().getSelectOptions().map(function(s){return{propertyName:s.getPropertyName(),conditions:s.getCustomData("conditions")[0].getValue().conditions};});};m.prototype._applyFilters=function(o){this._getSelectOptions().forEach(function(s){o.removeAllConditions(s.propertyName);s.conditions.forEach(function(i){o.addCondition(s.propertyName,i);});});o.applyFilters();};m.prototype._rebind=function(){if(this.getAggregation("_chart")&&this.getAggregation("_chart").getBinding("data")){this.getAggregation("_chart").getBinding("data").sort(this._getSorters());}};m.prototype._onSetConditionModel=function(){if(!this.getConditionModelName()||!this.getModel(this.getConditionModelName())){return;}this.detachModelContextChange(this._onSetConditionModel,this);this._applyFilters(this.getModel(this.getConditionModelName()));};m.prototype.applyFiltersAfterChangesApplied=function(){if(this._bWaitForChangesToBeApplied){return;}this._bWaitForChangesToBeApplied=true;sap.ui.require(["sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],function(F){F.waitForChanges({element:this}).then(function(){this._bWaitForChangesToBeApplied=false;this._rebind();if(!this.getConditionModelName()||!this.getModel(this.getConditionModelName())){L.error("sap.ui.mdc.Chart: no condition model obtained. Therefore flexibility changes for filtering can not be applied on Chart.");}else{this._applyFilters(this.getModel(this.getConditionModelName()));}}.bind(this));}.bind(this));};m.prototype._addCriticality=function(i){var o=this.getProperty("_colorings");o=o||{Criticality:{DimensionValues:{},MeasureValues:{}}};var j=i.getCriticality(),k={};if(i.getVizItemType()=="Dimension"){for(var K in j){k[K]={Values:j[K]};}o.Criticality.DimensionValues[i.getKey()]=k;}else{for(var K in j){k[K]=j[K];}o.Criticality.MeasureValues[i.getKey()]=k;}this.setProperty("_colorings",o);};m.prototype.getCollectionModel=function(){var o=this.getBindingInfo("data");return o?this.getModel(o.model):null;};m.prototype.getCollectionPath=function(){var o=this.getBindingInfo("data");return o?o.path:null;};m.prototype.done=function(){return this.oChartPromise;};return m;},true);
