/*
 * ! SAPUI5

		(c) Copyright 2009-2019 SAP SE. All rights reserved
	
 */
sap.ui.define(['sap/ui/core/Control','sap/base/util/merge','sap/base/util/deepEqual','sap/ui/model/PropertyBinding','sap/ui/model/Context','sap/ui/model/base/ManagedObjectModel','sap/ui/base/ManagedObjectObserver','sap/base/Log','sap/ui/mdc/library','sap/ui/mdc/base/filterbar/FilterItemLayout','sap/ui/mdc/base/ConditionModel','sap/ui/mdc/base/Condition','sap/ui/mdc/FilterField','sap/ui/mdc/field/FieldValueHelp','sap/ui/mdc/util/IdentifierUtil','sap/ui/mdc/util/ConditionUtil','sap/ui/layout/AlignedFlowLayout','sap/m/library','sap/m/Button','sap/ui/model/json/JSONModel',"sap/ui/fl/write/api/ControlPersonalizationWriteAPI","sap/ui/fl/apply/api/FlexRuntimeInfoAPI"],function(C,m,d,P,a,M,b,L,c,F,e,f,g,h,I,k,A,l,B,J,n,o){"use strict";var p=l.ButtonType;var q=C.extend("sap.ui.mdc.FilterBar",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/FilterBar.designtime",defaultAggregation:"filterItems",interfaces:["sap.ui.mdc.IFilter"],properties:{metadataDelegate:{type:"string",defaultValue:"sap/ui/mdc/FilterBarDelegate"},liveMode:{type:"boolean",defaultValue:false},showGoButton:{type:"boolean",defaultValue:true},showAdaptFiltersButton:{type:"boolean",defaultValue:true},supportP13N:{type:"boolean",defaultValue:false},filtersConditions:{type:"object",defaultValue:{}},metadataInfo:{type:"object",defaultValue:{}}},aggregations:{filterItems:{type:"sap.ui.mdc.FilterField",multiple:true},basicSearchField:{type:"sap.ui.mdc.FilterField",multiple:false}},events:{search:{conditions:{type:"object"}},reset:{},filtersChanged:{filtersText:{type:"string"}}}},renderer:function(R,i){R.write("<div ");R.writeControlData(i);R.writeClasses();R.write(">");R.renderControl(i._getContent());R.write("</div>");}});q.INNER_MODEL_NAME="$sap.ui.mdc.FilterBar";q.CONDITION_MODEL_NAME="$filters";var r=null;var s=null;q.prototype.init=function(){this.addStyleClass("sapUiMdcBaseFilterBar");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._createInnerModel();this._oObserver=new b(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["filterItems"]});this._oFilterBarLayout=new A();this._addButtons();this._clearChanges();this._aProperties=null;this._fResolveFilterBarMetaModelSet=undefined;this._oMetaModelSetPromise=new Promise(function(i){this._fResolveFilterBarMetaModelSet=i;}.bind(this));this._fResolveFilterBarMetadataApplied=undefined;this._oMetadataAppliedPromise=new Promise(function(i){this._fResolveFilterBarMetadataApplied=i;}.bind(this));this._fResolveFilterBarConditionModel=undefined;this._oConditionModelPromise=new Promise(function(i){this._fResolveFilterBarConditionModel=i;}.bind(this));this._fResolveInitialFiltersApplied=undefined;this._oInitialFiltersAppliedPromise=new Promise(function(i){this._fResolveInitialFiltersApplied=i;}.bind(this));this._bIgnoreChanges=false;this.bWaiting=false;};q.prototype._getConditionModel=function(){return this._oConditionModel;};q.prototype.getConditionModelName=function(){return this._getConditionModelName();};q.prototype._getConditionModelName=function(){return q.CONDITION_MODEL_NAME;};q.prototype._createConditionModel=function(){this._oConditionModel=new e();this.setModel(this._oConditionModel,this._getConditionModelName());if(!this._oMetadataPromise){this._oMetadataPromise=this._retrieveMetadata();}Promise.all([this._oMetadataPromise]).then(function(){if(this._oConditionModel){this._oConditionChangeBinding=this._oConditionModel.bindProperty("/conditions",this._oConditionModel.getContext("/conditions"));this._oConditionChangeBinding.attachChange(this._handleConditionModelChange,this);this._fResolveFilterBarConditionModel();}}.bind(this));};q.prototype._getMetaModelName=function(){return this.getMetadataInfo().modelName;};q.prototype._getEntitySetName=function(){return this.getMetadataInfo().collectionName;};q.prototype._setMetadataModel=function(){var i=null,j=this._getMetaModelName();if(j){i=this.getModel(j);}else{i=this.getModel();}if(i){this.detachModelContextChange(this._setMetadataModel,this);this._fResolveFilterBarMetaModelSet(i);}};q.prototype.applySettings=function(S,i){C.prototype.applySettings.apply(this,arguments);this._createConditionModel();this._oConditionModelPromise.then(function(){this._applyInitialFiltersConditions();}.bind(this));};q.prototype.setMetadataDelegate=function(i){this.setProperty("metadataDelegate",i);return this;};q.prototype._createInnerModel=function(){this._oModel=new M(this);this.setModel(this._oModel,q.INNER_MODEL_NAME);return this;};q.prototype._addButtons=function(){if(this._oFilterBarLayout){this._btnAdapt=new B(this.getId()+"-btnAdapt",{text:this._oRb.getText("filterbar.ADAPT"),press:this.onAdaptFilters.bind(this)});this._btnAdapt.setModel(this._oModel,q.INNER_MODEL_NAME);this._btnAdapt.bindProperty("visible",{parts:[{path:'/showAdaptFiltersButton',model:q.INNER_MODEL_NAME},{path:"/supportP13N",model:q.INNER_MODEL_NAME}],formatter:function(v,V){return v&&V;}});this._btnAdapt.addStyleClass("sapUiMdcBaseFilterBarButtonPaddingRight");this._oFilterBarLayout.addEndContent(this._btnAdapt);this._btnSearch=new B(this.getId()+"-btnSearch",{text:this._oRb.getText("filterbar.GO"),press:this.onSearch.bind(this),type:p.Emphasized});this._btnSearch.setModel(this._oModel,q.INNER_MODEL_NAME);this._btnSearch.bindProperty("visible",{parts:[{path:'/showGoButton',model:q.INNER_MODEL_NAME},{path:"/liveMode",model:q.INNER_MODEL_NAME}],formatter:function(v,V){return v&&!V;}});this._oFilterBarLayout.addEndContent(this._btnSearch);}};q.prototype._initializeProvider=function(){var i=this.getMetadataDelegate();if(!i){return Promise.resolve(null);}var j=this.getMetadataInfo();if(Object.keys(j).length>0){this.attachModelContextChange(this._setMetadataModel,this);}else{this._fResolveFilterBarMetaModelSet(null);}return this._loadProvider(i);};q.prototype._loadProvider=function(i){return new Promise(function(R){sap.ui.require([i],function(j){R(j);});});};q.prototype.onAdaptFilters=function(E){this.showFiltersDialog();};q.prototype._getAssignedFilterNames=function(){var i,N,j=null,t=this._getConditionModel(),u;if(t){i=t.getAllConditions();j=[];for(N in i){if(j.indexOf(N)<0){var v=t.getConditions(N);if(v&&v.length>0){if(N==="$search"){j.push(this._oRb.getText("filterbar.ADAPT_SEARCHTERM"));}else{u=this._getFilterField(N);if(u){if(u.getVisible()){j.push(N);}}else{j.push(N);}}}}}}return j;};q.prototype._getAssignedFiltersText=function(j){var t,u;j=j||[];if(j.length>5){u=j.slice(0,5);u.push("...");}else{u=j;}t=Object.keys(u).map(function(i){return u[i];}).join(", ");if(j.length){return this._oRb.getText("filterbar.ADAPT_FILTERED",[j.length,t]);}return this._oRb.getText("filterbar.ADAPT_NOTFILTERED");};q.prototype.getAssignedFiltersText=function(){return this._getAssignedFiltersText(this._getAssignedFilterNames());};q.prototype._handleConditionModelChange=function(E){if(!this._bIgnoreChanges){this._handleAssignedFilterNames(E);this._handleCalculateDifferences();}};q.prototype._handleCalculateDifferences=function(S,i){var j=this.getProperty("filtersConditions");this._calculateConditionsDiffsToPrevState(j,this._getConditionModel());};q.prototype._calculateConditionsDiffsToPrevState=function(j,t){if(!this.getSupportP13N()){return;}if(!t){return;}var u=t.getAllConditions();if(!d(u,j)){for(var v in u){if(!j[v]){for(var i=0;i<u[v].length;i++){var w=this._createAddRemoveConditionChangeWithFieldPath("addCondition",v,u[v][i]);if(w){this._aChanges.push(w);}}}else{this._calculateConditionsDifference(v,u,j);}}}this._storeChanges();};q.prototype._determineType=function(i){var j,t=this._getFilterField(i);if(t){return t;}j=this._getPropertyByName(i);if(j){return j;}L.error("not able to resolve metadata for "+i);return null;};q.prototype._calculateConditionsDifference=function(i,O,j){var t,u,v,w;var x=O[i]?m([],O[i]):[];var S=j[i]?m([],j[i]):[];this._cleanupConditions(x);this._cleanupConditions(S);if(d(x,S)){return;}this._removeSameConditions(x,S);if((x.length>0)||(S.length>0)){w=this._determineType(i);if(!w){return;}if(w.isA&&w.isA("sap.ui.mdc.FilterField")){t=w.getDataType();u=w.getDataTypeFormatOptions();v=w.getDataTypeConstraints();}else{t=w.type;u=w.formatOptions;v=w.constraints;}x.forEach(function(y){y=k.toExternal(y,t,u,v);});S.forEach(function(y){this._aChanges.push(this._createAddRemoveConditionChange("removeCondition",i,t,u,v,y));}.bind(this));x.forEach(function(y){this._aChanges.push(this._createAddRemoveConditionChange("addCondition",i,t,u,v,y));}.bind(this));}};q.prototype._cleanupConditions=function(i){if(i){i.forEach(function(j){if(j.hasOwnProperty("isEmpty")){delete j.isEmpty;}});}};q.prototype._removeSameConditions=function(t,S){var R;do{R=false;for(var i=0;i<t.length;i++){for(var j=0;j<S.length;j++){if(d(t[i],S[j])){t.splice(i,1);S.splice(j,1);R=true;break;}}if(R){break;}}}while(R);};q.prototype._handleAssignedFilterNames=function(E){var O={},i=this._getAssignedFilterNames();if(i){if(this._btnAdapt){this._btnAdapt.setText(this._oRb.getText(i.length?"filterbar.ADAPT_NONZERO":"filterbar.ADAPT",i.length));this._oFilterBarLayout.reflow();}O.filtersText=this._getAssignedFiltersText(i);this.fireFiltersChanged(O);if(this.getLiveMode()){this.fireSearch();}}};q.prototype.onReset=function(E){this.fireReset();};q.prototype.onSearch=function(E){this.fireSearch();};q.prototype.fireSearch=function(E){var i=this.getConditions(true);this.fireEvent("search",{conditions:i});};q.prototype.getConditions=function(D){var i={},j=this._getConditionModel();if(j){var t=j.getAllConditions();for(var u in t){if(t[u]&&(t[u].length>0)){i[u]=m([],t[u]);if(!D){this._cleanupConditions(i[u]);}}}}return i;};q.prototype.setConditions=function(i){var j=this._getConditionModel();if(j){for(var t in i){j.removeAllConditions(t);var u=i[t];u.forEach(function(v){j.addCondition(t,v);});}}};q.prototype.showFiltersDialog=function(){if(!this._oMetadataPromise){this._oMetadataPromise=this._retrieveMetadata();}if(!r){sap.ui.require(["sap/ui/mdc/base/filterbar/AdaptFiltersDialog","sap/ui/mdc/base/filterbar/AdaptFiltersDialogItem"],function(i,j){this._oMetadataPromise.then(function(){r=i;s=j;this._showFiltersDialog();}.bind(this));}.bind(this));}else{this._showFiltersDialog();}};q.prototype._showFiltersDialog=function(){this._clearChanges();var j=new J({showResetEnabled:false,items:this._setItemsForAdaptFiltersDialog()});var i=new s({key:"{$sapuimdcbasefilterbarAdaptFiltersDialog>key}",text:"{$sapuimdcbasefilterbarAdaptFiltersDialog>text}",tooltip:"{$sapuimdcbasefilterbarAdaptFiltersDialog>tooltip}",required:"{$sapuimdcbasefilterbarAdaptFiltersDialog>required}",visible:"{$sapuimdcbasefilterbarAdaptFiltersDialog>visible}",relativePosition:"{$sapuimdcbasefilterbarAdaptFiltersDialog>relativePosition}",controls:{path:'$sapuimdcbasefilterbarAdaptFiltersDialog>controls',templateShareable:false,factory:function(v,w){return w.getObject(w.getPath());}}});var t=new r({showReset:false,showResetEnabled:{path:'$sapuimdcbasefilterbarAdaptFiltersDialog>/showResetEnabled'},items:{path:'$sapuimdcbasefilterbarAdaptFiltersDialog>/items',templateShareable:false,template:i},visibilityChanged:function(E){this._addFilterVisibilityChange(E.getParameter("key"),E.getParameter("visible"));}.bind(this),positionChanged:function(E){this._addFilterPositionyChange(E.getParameter("key"),E.getParameter("relativePosition"));}.bind(this),ok:function(E){var v=this._oAdaptFiltersDialog.getModel("cmodel");this._calculateConditionsDiffsToPrevState(this._getConditionModel().getAllConditions(),v);E.getSource().close();E.getSource().destroy();this._oAdaptFiltersDialog=null;}.bind(this),reset:function(){this._oAdaptFiltersDialog=null;}.bind(this),cancel:function(E){E.getSource().close();E.getSource().destroy();this._oAdaptFiltersDialog=null;}.bind(this)});t.setModel(j,"$sapuimdcbasefilterbarAdaptFiltersDialog");var u=this._getConditionModel().clone();t.setModel(u,"cmodel");this.addDependent(t);this._oAdaptFiltersDialog=t;t.open();};q.prototype._addFilterPositionyChange=function(N,i){var j=this._getFilterField(N);var t=j?j.getId():this._getFilterFieldId(N);this._removeSetFilterPositionChange(t);var u={id:t,position:i};this._aChanges.push({selectorElement:this,changeSpecificData:{changeType:"setFilterPosition",content:u}});};q.prototype._createFilterVisibilityChangeContent=function(i,N,t,j,u,R,v,w,x){return{id:i,name:N,type:t,conditions:'\{'+this._getConditionModelName()+">/conditions/"+N+'\}',constraints:m({},j),formatOptions:m({},u),required:R,label:v,maxConditions:w,fieldHelp:x};};q.prototype._isMultiValue=function(i){var j=true;switch(i.filterExpression){case"SearchExpression":case"SingleRange":case"SingleValue":j=false;break;default:break;}return j;};q.prototype._createFilterVisibilityChangeContentByProperty=function(i,K,j){var t=this._isMultiValue(j)?-1:1;return this._createFilterVisibilityChangeContent(i,K,j.type,j.constraints,j.formatOptions,j.required,j.label,t,j.fieldHelp);};q.prototype._createFilterVisibilityChangeContentByFilterField=function(i,K,j){return this._createFilterVisibilityChangeContent(i,K,j.getDataType(),j.getDataTypeConstraints(),j.getDataTypeFormatOptions(),j.getRequired(),j.getLabel(),j.getMaxConditions(),j.getFieldHelp());};q.prototype._addFilterVisibilityChange=function(N,v){var i=this._getFilterField(N),j=this._getNonHiddenPropertyByName(N);if(v){if(!i){this._aChanges.push({selectorElement:this,changeSpecificData:{changeType:"addFilter",content:this._createFilterVisibilityChangeContentByProperty(this._getFilterFieldId(N),N,j)}});}else{if(i.getVisible()){this._removeRemoveFilterChange(i);}else{this._aChanges.push({selectorElement:this,changeSpecificData:{changeType:"addFilter",content:this._createFilterVisibilityChangeContentByFilterField(i.getId(),N,i)}});}}}else{if(i){this._aChanges.push({selectorElement:this,changeSpecificData:{changeType:"removeFilter",content:this._createFilterVisibilityChangeContentByFilterField(i.getId(),N,i)}});}else{this._removeAddFilterChange(j);}}};q.prototype._createAddRemoveConditionChangeWithFieldPath=function(i,j,t){var O=this._determineType(j);if(!O){return null;}if(O.isA&&O.isA("sap.ui.mdc.FilterField")){return this._createAddRemoveConditionChangeWithField(i,O,t);}else{return this._createAddRemoveConditionChange(i,j,O.type,O.formatOptions,O.constraints,t);}};q.prototype._createAddRemoveConditionChange=function(i,j,t,u,v,w,O,x){var y=w;if(w&&w.values&&w.values.length>0){y=k.toExternal(w,t,u,v);}var z={selectorElement:this,changeSpecificData:{changeType:i,content:{name:j,condition:y,index:x,outConditions:O?O:null}}};return z;};q.prototype._createAddRemoveConditionChangeWithField=function(i,j,t,O,u){return this._createAddRemoveConditionChange(i,j.getFieldPath(),j.getDataType(),j.getDataTypeFormatOptions(),j.getDataTypeConstraints(),t,O,u);};q.prototype._removeAddFilterChange=function(i){var j=-1;this._aChanges.some(function(t,u){if((t.changeSpecificData.changeType==="addFilter")&&(t.changeSpecificData.content.name===i.name)){j=u;}return j>-1;});if(j>-1){this._aChanges.splice(j,1);}};q.prototype._removeRemoveFilterChange=function(i){var j=-1;this._aChanges.some(function(t,u){if((t.changeSpecificData.changeType==="removeFilter")&&(t.changeSpecificData.content.id===i.getId())){j=u;}return j>-1;});if(j>-1){this._aChanges.splice(j,1);}};q.prototype._removeSetFilterPositionChange=function(i){var j=-1;this._aChanges.some(function(t,u){if((t.changeSpecificData.changeType==="setFilterPosition")&&(t.changeSpecificData.content.id===i)){j=u;}return j>-1;});if(j>-1){this._aChanges.splice(j,1);}};q.prototype._clearChanges=function(){this._aChanges=[];};q.prototype._condenseChange=function(){var R=[];this._aChanges.every(function(j){var i,t,u=false;if(j.changeSpecificData.changeType==="setFilterPosition"){if(j.changeSpecificData.content.id){for(i=0;i<this._aChanges.length;i++){t=this._aChanges[i];if((t.changeSpecificData.changeType==="removeFilter")&&(t.changeSpecificData.content.id===j.changeSpecificData.content.id)){u=true;break;}}}else if(j.changeSpecificData.content.name){u=true;for(i=0;i<this._aChanges.length;i++){t=this._aChanges[i];if((t.changeSpecificData.changeType==="addFilter")&&(t.changeSpecificData.content.name===j.changeSpecificData.content.name)){u=false;break;}}}if(!u){R.push(j);}}else{R.push(j);}return true;}.bind(this));this._aChanges=R;};q.prototype._storeChanges=function(){if(!this.getSupportP13N()){this._clearChanges();return;}this._condenseChange();if(this._aChanges&&this._aChanges.length){var H=o.hasVariantManagement({element:this});try{n.add({changes:this._aChanges,ignoreVariantManagement:!H});}catch(i){L.error("error while saving changes - "+i.message);}this._clearChanges();}};q.prototype._setItemsForAdaptFiltersDialog=function(){var i=this.getFilterItems();if(this._getNonHiddenPropertyInfoSet().length>0){return this._getNonHiddenPropertyInfoSet().map(function(j,t){var K=this._getFilterFieldPath(j);var u=this._getFilterField(K);var v=i.indexOf(u);var w=u?u.clone():this.createFilterField(j);w.setVisible(true);w.bindProperty("conditions",{path:"cmodel>/conditions/"+K});return{key:K,text:j.label,tooltip:j.tooltip,required:j.required,relativePosition:v,visible:(v>-1)&&u.getVisible(),controls:[w]};}.bind(this));}else{return i.map(function(j,t){var u=j.clone();u.bindProperty("conditions",{path:"cmodel>/conditions/"+u.getFieldPath()});return{key:u.getFieldPath(),text:u.getFieldPath(),tooltip:u.getTooltip(),required:u.getRequired(),relativePosition:t,visible:j.getVisible(),controls:[u]};});}};q.prototype._getContent=function(){return this._oFilterBarLayout;};q.prototype._insertFilterFieldtoContent=function(i,j){if(!F){return;}var t=new F();t.setFilterField(i);this._oFilterBarLayout.insertContent(t,j);};q.prototype._filterItemInserted=function(i){if(!i.getVisible()){return;}if(i.setWidth){i.setWidth("");}if(this._isChangeApplying()){this._suspendBinding(i);}this._applyFilterItemInserted(i);};q.prototype._applyFilterItemInserted=function(j){var t,u;u=this.indexOfAggregation("filterItems",j);if(this.getAggregation("basicSearchField")){u++;}t=u;var v=this.getFilterItems();for(var i=0;i<t;i++){if(!v[i].getVisible()){u--;}}this._insertFilterFieldtoContent(j,u);if(!this._oObserver.isObserved(j,{properties:["visible"]})){this._oObserver.observe(j,{properties:["visible"]});}};q.prototype._filterItemRemoved=function(i){this._applyFilterItemRemoved(i.getFieldPath());};q.prototype._applyFilterItemRemoved=function(i){this._removeFilterFieldFromContentByName(i);};q.prototype._removeFilterFieldFromContent=function(i){this._removeFilterFieldFromContentByName(i.getFieldPath());};q.prototype._removeFilterFieldFromContentByName=function(i){var j=this._getFilterItemLayoutByName(i);if(j){this._oFilterBarLayout.removeContent(j);j.destroy();}};q.prototype._observeChanges=function(i){if(i.type==="aggregation"&&i.name==="filterItems"){switch(i.mutation){case"insert":this._filterItemInserted(i.child);break;case"remove":this._filterItemRemoved(i.child);break;default:L.error("operation "+i.mutation+" not yet implemented");}}else if(i.type==="property"){var j;if(i.object.isA&&i.object.isA("sap.ui.mdc.FilterField")){j=i.object;if(j){if(i.current){this._filterItemInserted(j);}else{this._filterItemRemoved(j);}this._oFilterBarLayout.rerender();}}}};q.prototype._getFilterItemLayout=function(i){return this._getFilterItemLayoutByName(i.getFieldPath());};q.prototype._getFilterItemLayoutByName=function(i){var j=null;this._oFilterBarLayout.getContent().some(function(t){if(t._getFieldPath()===i){j=t;}return j!==null;});return j;};q.prototype._getFilterField=function(N){var i=null;this.getFilterItems().some(function(j){if(j&&j.getFieldPath&&(j.getFieldPath()===N)){i=j;}return i!==null;});return i;};q.prototype._retrieveMetadata=function(){return new Promise(function(i){Promise.all([this._initializeProvider(),this._oMetaModelSetPromise]).then(function(j){if(!this._bIsBeingDestroyed){var t=j[0];var u=j[1];this._aProperties=[];if(t&&t.fetchProperties){try{t.fetchProperties(u,this._getEntitySetName()).then(function(w){this._aProperties=w;if(this._aProperties.length===0){this._createLocalPropertySet();}this._fResolveFilterBarMetadataApplied();}.bind(this));}catch(v){L.error("Exception during fetchProperties occured: "+v.message);}}else{L.error("Provided metadataDelegate '"+this.getMetadataDelegate()+"' not valid.");}if(this._aProperties.length===0){this._createLocalPropertySet();}this._fResolveFilterBarMetadataApplied();}i();}.bind(this));}.bind(this));};q.prototype._createLocalPropertySet=function(){this.getFilterItems().forEach(function(i){var j=this._isInternalVH(i);var t={name:i.getFieldPath(),label:i.getLabel(),required:i.getRequired(),type:i.getDataType(),constraints:i.getDataTypeConstraints(),formatOptions:i.getDataTypeFormatOptions(),visible:i.getVisible(),filterable:true,hiddenFilter:false,hasFieldHelp:j,fieldHelp:j?"":i.getFieldHelp()};this._aProperties.push(t);}.bind(this));};q.prototype._isInternalVH=function(i){var j,v,t=false;if(i.getFieldHelp()){v=sap.ui.getCore().byId(i.getFieldHelp());if(v){do{j=v.getParent();if(j===i){t=true;}else if(j===this){j=null;}}while(!t&&j);}}return t;};q.prototype.setBasicSearchField=function(i){var O=this.getAggregation("basicSearchField");if(O){this._removeFilterFieldFromContent(O);}this.setAggregation("basicSearchField",i);if(i){if(!this._oObserver.isObserved(i,{properties:["visible"]})){this._oObserver.observe(i,{properties:["visible"]});}this._insertFilterFieldtoContent(i,0);}return this;};q.prototype.getPropertyInfoSet=function(){return this._aProperties||[];};q.prototype._getNonHiddenPropertyInfoSet=function(){var v=[];this.getPropertyInfoSet().every(function(i){if(!i.hiddenFilter){if(i.name!=="$search"){v.push(i);}}return true;});return v;};q.prototype._getNonHiddenPropertyByName=function(N){var i=null;this._getNonHiddenPropertyInfoSet().some(function(j){if(j.name===N){i=j;}return i!=null;});return i;};q.prototype._getPropertyByName=function(N){var i=null;this.getPropertyInfoSet().some(function(j){if(j.name===N){i=j;}return i!=null;});return i;};q.prototype._getFilterFieldId=function(N){return this.getId()+"--filter--"+I.replace(N);};q.prototype._getFilterFieldPath=function(i){if(i){return i.path||i.name;}return null;};q.prototype.createFilterField=function(i){var j,t=1,v=null;if(this._isMultiValue(i)){t=-1;}j=new g(this._getFilterFieldId(i.name),{label:i.label,dataType:i.type,dataTypeConstraints:m({},i.constraints),dataTypeFormatOptions:m({},i.formatOptions),maxConditions:t,required:i.required,visible:i.visible});j.bindProperty("conditions",{path:this._getConditionModelName()+">/conditions/"+this._getFilterFieldPath(i)},true);var V=i.filterConditions;if(V&&(V.length>0)){j.setConditions(V);}if(i.tooltip){j.setTooltip(i.tooltip);}v=i.fieldHelp;if(v){j.setFieldHelp(this._getView().createId(v));}var u=this._getConditionModel();if(u){j.setModel(u,this._getConditionModelName());}return j;};q.prototype.applyConditionsAfterChangesApplied=function(){if(this._isChangeApplying()){return;}this._bIgnoreChanges=true;var i=this.getFilterItems();i.forEach(function(j){this._suspendBinding(j);}.bind(this));this._oFlexPromise=o.waitForChanges({element:this});this._bIgnoreChanges=true;Promise.all([this._oFlexPromise,this._oInitialFiltersAppliedPromise]).then(function(v){this._applyFiltersConditionsChanges();this._resumeBindings();this._oFlexPromise=null;if(!this._iShadowModelResolveTimer&&!this._iShadowModelTimer){this._iShadowModelTimer=setTimeout(function(){delete this._iShadowModelTimer;this._createShadowModel();}.bind(this),0);}}.bind(this));};q.prototype.waitForInitialFiltersApplied=function(){return this._oInitialFiltersAppliedPromise;};q.prototype._suspendBinding=function(i){if(i){var j=i.getBinding("conditions");if(j){if(!this._aBindings){this._aBindings=[];}j.suspend();this._aBindings.push(i);}}};q.prototype._resumeBindings=function(){if(this._aBindings){this._aBindings.forEach(function(i){if(!i.bIsDestroy){var j=i.getBinding("conditions");if(j){j.resume();}}});this._aBindings=null;}};q.prototype._isChangeApplying=function(){return!!this._oFlexPromise;};q.prototype._applyInitialFiltersConditions=function(){this._bIgnoreChanges=true;this._applyFiltersConditionsChanges();if(!this._iShadowModelResolveTimer){if(this._iShadowModelTimer){clearTimeout(this._iShadowModelTimer);delete this._iShadowModelTimer;}this._iShadowModelResolveTimer=setTimeout(function(){delete this._iShadowModelResolveTimer;this._createShadowModel();this._fResolveInitialFiltersApplied();}.bind(this),0);}};q.prototype._applyFiltersConditionsChanges=function(){var i,j,t,O,T,u,v;var S=this.getProperty("filtersConditions");if(Object.keys(S).length>0){j=m([],S);t=this._getConditionModel();t.removeAllConditions();if(j){for(var w in j){i=j[w];O=this._determineType(w);if(O){if(O.isA&&O.isA("sap.ui.mdc.FilterField")){T=O.getDataType();u=O.getDataTypeFormatOptions();v=O.getDataTypeConstraints();}else{T=O.type;u=O.formatOptions;v=O.constraints;}i.forEach(function(x){x=k.toInternal(x,T,u,v);var N=f.createCondition(x.operator,x.values);t.addCondition(w,N);});}}}}};q.prototype._createShadowModel=function(){var i,S={};var j=this._getConditionModel();var t=j.getAllConditions();for(var u in t){i=t[u];i.forEach(function(v){if(!S[u]){S[u]=[];}S[u].push(v);});this._cleanupConditions(S[u]);}this.setProperty("filtersConditions",S);this._bIgnoreChanges=false;this._handleConditionModelChange();};q.prototype._getView=function(){if(!this._oView){var O=this.getParent();while(O){if(O.isA("sap.ui.core.mvc.View")){this._oView=O;break;}O=O.getParent();}}return this._oView;};q.prototype.getFilters=function(){return this._getConditionModel()?this._getConditionModel().getFilters():[];};q.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this._oFilterBarLayout){this._oFilterBarLayout.destroy();this._oFilterBarLayout=null;}this._btnAdapt=undefined;this._btnSearch=undefined;this._oRb=null;if(this._oModel){this._oModel.destroy();this._oModel=null;}if(this._oConditionChangeBinding){this._oConditionChangeBinding.detachChange(this._handleConditionModelChange,this);this._oConditionChangeBinding=null;}if(this._oConditionModel){this._oConditionModel.destroy();this._oConditionModel=null;}this._oObserver.disconnect();this._oObserver=undefined;this._aProperties=null;this._oFlexPromise=null;this._oMetadataPromise=null;this._fResolveFilterBarConditionModel=undefined;this._oConditionModelPromise=null;this._fResolveFilterBarMetaModelSet=undefined;this._oMetaModelSetPromise=null;this._fResolveFilterBarMetadataApplied=undefined;this._oMetadataAppliedPromise=null;this._fResolveInitialFiltersApplied=undefined;this._oInitialFiltersAppliedPromise=null;if(this._iShadowModelTimer){clearTimeout(this._iShadowModelTimer);delete this._iShadowModelTimer;}if(this._iShadowModelResolveTimer){clearTimeout(this._iShadowModelResolveTimer);delete this._iShadowModelResolveTimer;}this._aChanges=null;this._oView=null;this._aBindings=null;};return q;},true);
